/* #########################################################################

			       XCORAL SMAC

   File: window-utilities.sc
   Created: Mon Jan 3 17:18:11 1994
   Author: Thierry Emery
   Modified: Fri Jan 21 16:27:04 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: window utilities

   Defines: choose_window, current_position_in, end_of_file_in, the_char_in,
	    goto_char_in

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   Window choice
   ------------------------------------------------------------------------- */

int choose_window(char* msg) {

  int win;
  char *item, *file;
  
  clear_list();

  for (win=0; win<32; ++win) {
    if (select_window(win) >= 0) {
      file = filename();
      if (file) {
	item = (char*) malloc(strlen(file)+4);
	sprintf(item,"%d %s",win,file);
	free(file);
	add_list_item(item);
      }
    }
  }

  item = select_from_list(msg);

  if (item)
    win = read_int_from_string(item);
  else
    win = -1;

  clear_list();

  return win;
}

/* -------------------------------------------------------------------------
   returns current position in window <win>
   ------------------------------------------------------------------------- */

int current_position_in(int win) {

  int origin_win=current_window(), pos;

  select_window(win);
  pos = current_position();
  select_window(origin_win);

  return pos;
}

/* -------------------------------------------------------------------------
   returns end of file position in window <win>
   ------------------------------------------------------------------------- */

int end_of_file_in(int win) {

  int origin_win=current_window(), pos;

  select_window(win);
  pos = end_of_file();
  select_window(origin_win);

  return pos;
}

/* -------------------------------------------------------------------------
   returns the char <pos> in window <win>
   ------------------------------------------------------------------------- */

char the_char_in(int win, int pos) {

  int origin_win=current_window();
  char c;

  select_window(win);
  c = the_char(pos);
  select_window(origin_win);

  return c;
}

/* -------------------------------------------------------------------------
   goes to char <pos> in window <win>
   ------------------------------------------------------------------------- */

void goto_char_in(int win, int pos) {

  int origin_win=current_window();

  select_window(win);
  goto_char(pos);
  select_window(origin_win);

  return;
}

