/* #########################################################################

			       XCORAL SMAC

   File: mode-ext.sc

   Created: Tue Nov 30 19:05:32 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:26:24 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: extensions of C and C++ modes
   
   Requires: mode.sc
	     utilities.sc

   Defines: next_form, next_form_and_delete, current_form,
	    delete_current_form, transpose_forms

   Suggested bindings: "^xy" transpose_forms

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   extract and optionnally (depending on <delete_p>) delete next form (malloc)
   ------------------------------------------------------------------------- */

char* next_form_delete_opt(int delete_p) {

  int origin=current_position(),beg,end;
  char* form;

  forward_c_form();
  end = current_position();
  backward_c_form();
  beg = current_position();
  form = window_substring(beg,end);
  if (delete_p)
    delete_region(beg,end);
  
  goto_char(origin);
  
  return form;
}

/* -------------------------------------------------------------------------
   extract next form (malloc)
   ------------------------------------------------------------------------- */

char* next_form() {

  return next_form_delete_opt(0);
}

/* -------------------------------------------------------------------------
   extract and delete next form (malloc)
   ------------------------------------------------------------------------- */

char* next_form_and_delete() {

  return next_form_delete_opt(1);
}

/* -------------------------------------------------------------------------
   current form (malloc)
   ------------------------------------------------------------------------- */

char* current_form() {

  forward_c_form();
  backward_c_form();

  return next_form();
}

/* -------------------------------------------------------------------------
   delete current form
   ------------------------------------------------------------------------- */

void delete_current_form() {

  forward_c_form();
  backward_c_form();
  delete_next_c_form();
}

/* -------------------------------------------------------------------------
   transpose current and preceding form
   ------------------------------------------------------------------------- */

void transpose_forms() {

  char* current;
  
  forward_c_form();
  backward_c_form();
  current=next_form_and_delete();
  backward_c_form();
  insert_string(current);
  free(current);
}


