
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

/* You can use the following function for any purpose :

        int edit_file_at_line(char * filename, int line)
	
	Returns 0 if filename is not found, else 1
*/


/*
   |
   |   Execute an Unix command, go to the indicated lines
   |   
   |   The recognized line indications are :
   |
   |          "file_name" <any>{0-9}<any>
   |          file_name:{0-9}<any>
   |          <any>"file_name", line {0-9}<any>
   |          <any> file_name, line {0-9}<any>
   |
   |   Usage :
   |   
   |   To execute the command :
   |   
   |         ^x^e cmd("command with its arguments");
   |   
   |   
   |   To go to the indicated lines :
   |   
   |         In c mode, c++ mode and default mode : ^xg 
   |         else : ^x^e go_next(); 
   |   
*/

int cmd_window = -1;			/* command window number */
int cmd_from_go_next = 0;		/* for edit_file_at_line */

/* cmd("command with its arguments"); */

void cmd(char * cmd)
{
  char * complete_cmd;
  char * fname = 0;

  /* select the command window */

  {
    int win = current_window();
    
    if ((select_window(cmd_window) == -1) || (fname = filename())) {
      /* killed, never created or reused for other thing */
      select_window(win);	/* to have a right associed directory */
      if ((cmd_window = new_window()) == -1)
	error("cannot create window");
      if (fname)
	free(fname);
    }
    else if (cmd_window != win) {
      /* kill the window to have a right associed directory */
      kill_window(cmd_window);
      select_window(win);
      cmd_window = new_window();
    }
    else
      /* Empty the window */
      kill_current_buffer();
  }
  select_window(cmd_window);
  
  /* The command */
  
  if (! (complete_cmd = (char *) malloc(strlen(cmd) + 6)))
    error("not enougth memory");

  sprintf(complete_cmd, "%s 2>&1", cmd);
  wprintf("%s\n\n", complete_cmd);
  redisplay();
  cmd_shell(complete_cmd);
  insert_string("\nDone\n");
  free(complete_cmd);
  goto_line(2);			/* first result line */
}


/* Search the file name and the line number for the pattern
   "file_name" <any>line_number<any> */

int find_cmd_trace1(int * bline, int * bfile, int * efile)
{
  if (current_char() == '"') {
    *bfile = current_position() + 1;
    do
      goto_next_char();
    while (! strchr("\"\n", current_char()));
    if ((current_char() == '"') && 
	(((*efile = current_position()) - *bfile) > 1) &&
	(msearch("0123456789", end_of_line(), 1))) {
      *bline = current_position();
      return 1;
    }
  }
  
  /* nothing recognized */
  goto_beginning_of_line();
  return 0;
}


/* Search the file name and the line number for the pattern
   file_name:line_number<any> */

int find_cmd_trace2(int * bline, int * bfile, int * efile)
{
  *bfile = current_position();
  while (! strchr("\n:", current_char()))
    goto_next_char();
  if ((current_char() == ':') &&
      (((*efile = current_position()) - *bfile) > 1) &&
      (strchr("0123456789", next_char()))) {
    *bline = current_position() + 1;
    return 1;
  }
  
  /* nothing recognized */
  goto_beginning_of_line();
  return 0;
}


int cmd_following_is(char * s)
{
  int pos = current_position();

  while (*s) {
    if (current_char() != *s++) {
      goto_char(pos);
      return 0;
    }
    else
      goto_next_char();
  }

  goto_char(pos);
  return 1;
}

/* Search the file name and the line number for the pattern
   <any>"file_name", line {0-9}<any> */

int find_cmd_trace3(int * bline, int * bfile, int * efile)
{
  while (current_char() != '\n') {
    if (current_char() == '\"') {
      *bfile = current_position() + 1;
      do goto_next_char();
      while (! strchr("\n\"", current_char()));
      if (cmd_following_is("\", line ") &&
	  strchr("0123456789", the_char(current_position() + 8))) {
	*efile = current_position();
	*bline = current_position() + 8;
	return 1;
      }
    }
    else
      goto_next_char();
  }
  
  /* nothing recognized */
  goto_beginning_of_line();
  return 0;
}

/* Search the file name and the line number for the pattern
   <any> file_name, line {0-9}<any> */

int find_cmd_trace4(int * bline, int * bfile, int * efile)
{
  while (current_char() != '\n') {
    if (cmd_following_is(", line ") &&
	strchr("0123456789", the_char(current_position() + 7))) {
      *efile = current_position();
      *bline = current_position() + 7;
      while (! strchr(" \t\n", previous_char()))
	goto_previous_char();
      *bfile = current_position();
      return 1;
    }
    else
      goto_next_char();
  }
  
  /* nothing recognized */
  goto_beginning_of_line();
  return 0;
}


/* Returns 1 if the current buffer is `file'
   filename() returns an absolute path, but file is absolute or relative */

int cmd_desired_buffer_p(char * file, int win)
{
  char * fname;
  int result = 0;

  if ((select_window(win) != -1) && (fname = filename())) {
    if (*file == '.') {
      /* remove the ../ or ./ at the beginning of file */
      do file += 1; while ((*file == '.') || (*file == '/'));
    }
    if (strlen(fname) >= strlen(file))
      result = ! strcmp(file,
			(strchr(file, '/'))
			   ? (*file == '/')
				? fname
				: fname + strlen(fname) - strlen(file)
			   : strrchr(fname, '/') + 1);
    
    free(fname);
  }

  return result;
}

int cmd_read_file_in_a_new_buffer(char * file)
{
  int win;
  
  if ((win = new_window()) == -1) {
    cmd_from_go_next = 0;
    error("no more buffer");
  }
  
  select_window(win);
  
  if (! read_file(file)) {
    kill_window(win);
    return 0;
  }
  
  return 1;
}

int edit_file_at_line(char * file, int line)
{
  int cwin = current_window();
  int win;

  /* Find a buffer associated with file */

  /* to avoid access to window which will imply redisplay */
  if (cmd_desired_buffer_p(file, current_window())) {
    goto_line(line - 1);
    upper_window();
    return;
  }

  /* perhaps another window */
  for (win = 31; win != -1; win -= 1)
    if (cmd_desired_buffer_p(file, win)) {
      goto_line(line - 1);
      upper_window();
      return;
    }
  
  /* not find, use a new buffer */

  if ((! cmd_from_go_next) ||
      (select_window(cmd_window) < 0) ||	/* to have the right dir */
      (! cmd_read_file_in_a_new_buffer(file))) {
    select_window(cwin);
    if (! cmd_read_file_in_a_new_buffer(file))
      return 0;
  }

  goto_line(line - 1);
  upper_window();
}


/* Go to the next indicated line */

void go_next()
{
  int win = current_window();
  int bline, bfile, efile;
  char * fname = 0;
  
  if ((select_window(cmd_window) == -1) || (fname = filename())) {
    /* killed, never created or reused for other thing */
    if (fname) free(fname);
    error("no cmd result window");
  }
  
  /* If the user change the cursor position */
  goto_beginning_of_line();
  
  while (! at_end_of_file()) {
    if (find_cmd_trace1(&bline, &bfile, &efile) ||
	find_cmd_trace2(&bline, &bfile, &efile) ||
	find_cmd_trace3(&bline, &bfile, &efile) ||
	find_cmd_trace4(&bline, &bfile, &efile)) {
      int line = 0;
      char filename[128];
      char * pfilename = filename;
  
      /* compute the line number */
      
      goto_char(bline);
      while (strchr("0123456789", current_char())) {
 	line = line * 10 + current_char() - '0';
	goto_next_char();
      }

      /* take the filename */
      
      goto_char(bfile);
      do {
	*pfilename++ = current_char();
	goto_next_char();
      } while (current_position() != efile);
      *pfilename = 0;
      
      /* go to the next case for the next call */
      
      current_line_to_top();
      goto_end_of_line();
      goto_next_char();

      select_window(win);
      cmd_from_go_next = 1;
      edit_file_at_line(filename, line);
      cmd_from_go_next = 0;
      return;
    }
    else {
      /* no line indication, go to the next */
      goto_end_of_line();
      goto_next_char();
    }
  }
  
  error("no more case");
}

{
  key_def("C-mode", "^xg", "go_next");
  key_def("C++mode", "^xg", "go_next");
  key_def("default", "^xg", "go_next");
}

/**/

void make()
{
  cmd("make -k");
}

void grep(char * args)
{
  /* add /dev/null to avoid deadlock when user forget filenames */
  char * str = (char *) malloc(strlen(args) + 9 + 10);

  if (! str)
    error("not enougth memory");

  sprintf(str, "grep -n %s /dev/null", args);
  cmd(str);
  free(str);
}
