#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include "config.h"
#define XINTERNAL_C
#include "xinternal.h"
#include "xinit.h"
#include "ich.xbm"
#include "myword.h"
#include "debug.h"
#include "xactions.h"
#include "status.h"
#undef DEBUG1

Flag redisplay;

void XPutChar(char c,long x,long y)
{
  XDrawString(display,bitmapW,gcFore,x,y,&c,1);
}


void XPutInverseChar(long x,long y,int p,int q)
{
  XFillRectangle(display,bitmapW,gcBack,x,y,p,q);
}

void WriteLineP(LineP *lp,float x,float y,int begin,int end,float delta)
{
  int i,j,k,l;
  float p,q;
  int pp,qq;
  FontInfo *font=lp->finfo;

/*  lp->c[lp->clength+1]=0;*/
#ifdef DEBUG1
  fprintf(stderr,"%1d",lp->softhyph);
#endif

  if(lp->clength>=begin)
    {
      j=lp->selb; k=lp->sele; l=end;
      if(l>lp->clength) l=lp->clength;
      if(j>l) j=l+1;
      if(k>l) k=l;
      XSetFont(display,gcFore,font->font);
      
      p=x+lp->pos.x; q=y+lp->pos.y;
      for(i=0;i<begin-1;i++)
	IncrementXPos(p,lp,i,font,delta);
      if(begin<j)
	{
	  XSetForeground(display,gcFore,black);
	  for(i=begin;i<j;i++)
	    {
	      pp=p*scaleX; qq=q*scaleX;
	      XPutChar(lp->c[i],pp,qq);
	      IncrementXPos(p,lp,i,font,delta);
	    }
	}
      if(j<=l)
	{
	  int pp1,qq1=lp->line->height*scaleX-1;
	  int qq2=(lp->line->depth+lp->line->height)*scaleX+1;

	  if((lp->line->previous!=NULL)
	     &&(lp->line->previous->page==lp->line->page))
	    qq1=(lp->line->pos.y-lp->line->previous->pos.y
		 -lp->line->previous->depth)*scaleX-1;
	  XSetForeground(display,gcFore,white);
	  XSetForeground(display,gcBack,black);

	  for(i=j;i<=k;i++)
	    {
	      pp=p*scaleX; qq=q*scaleX;
	      IncrementXPos(p,lp,i,font,delta);
	      pp1=p*scaleX;
	      XPutInverseChar(pp,qq-qq1,pp1-pp,qq2);
	      XPutChar(lp->c[i],pp,qq);
	    }

	  XSetForeground(display,gcFore,black);
	  XSetForeground(display,gcBack,white);
	}
      if(k<l)
	{
	  XSetForeground(display,gcFore,black);
	  for(i=k+1;i<=l;i++)
	    {
	      pp=p*scaleX; qq=q*scaleX;
	      XPutChar(lp->c[i],pp,qq);
	      if(i<lp->clength)
		IncrementXPos(p,lp,i,font,delta);
	    }
	}
    }
}

void WriteLine(Line *l,float x,float y)
{
  LineP *lp=l->first;
  float delta;

/*  if((l->space_num==0)||(l->next==NULL)||(l->next->newline>0))
    delta=0;
  else
    delta=(l->width-l->actualwidth)/l->space_num;*/
  delta=CalcDelta(l);
  while(lp!=NULL)
    {
      WriteLineP(lp,x,y,0,lp->clength,delta);
      lp=lp->next;
    }
#ifdef DEBUG1
  fprintf(stderr,"\n");
#endif
}

void RewriteLine(Line *l,float x,float y)
{
  long y1,y2,x1,x2;
  CursorUnblink();
  y1=y+(l->pos.y+l->depth)*scaleX;
  y2=(l->depth+l->height+l->lineskip)*scaleX+1;
  x1=l->pos.x*scaleX;
  x2=l->width*scaleX;
/*  if((l->previous!=NULL)&&(l->previous->page==l->page))
    y2=(l->pos.y-l->previous->pos.y-l->previous->depth+l->depth)*scaleX;*/
/*  XSetForeground(display,gcBack,white);*/
  XFillRectangle(display,bitmapW,gcBack, x1, y1-y2, x2, y2);
  WriteLine(l,x,y);
  XFlush(display);
}
  
void CleanPage(Page *p)
{
  Line *l=p->first;
  do
    {
      if(l->clean>0)
      	 CleanLine(l);
      l=l->next;
    } while((l!=NULL)&&(l->page==p));
  CheckPage(p);
}

void DrawMargins(Page *p)
{
  int ww=p->width*scaleX,hh=p->height*scaleX;
  int x,y;
/*  if(v_x+v_width>ww)*/
    XDrawLine(display,bitmapW,gcFore,ww,0,ww,hh);
/*  if(v_y+v_height>hh)*/
    XDrawLine(display,bitmapW,gcFore,0,hh,ww,hh);
#if 1
  x=p->lmargin*scaleX; y=(p->width-p->rmargin)*scaleX;
  XDrawLine(display,bitmapW,gcFore,x,0,x,hh);
  XDrawLine(display,bitmapW,gcFore,y,0,y,hh);
  x=p->tskip*scaleX; y=(p->height-p->bskip)*scaleX;
  XDrawLine(display,bitmapW,gcFore,0,y,ww,y);
  XDrawLine(display,bitmapW,gcFore,0,x,ww,x);
#endif
}

void WritePage(Page *p)
{
  Line *l;
  if(p->change>0)
    RewriteWholePage(p);
  else
    {
/*      CleanPage(p);*/
      FormatPage(p);
      l=p->first;
      while((l!=NULL)&&(l->page==p))
	{
	  WriteLine(l,0,0);
	  l->change=0;
	  l=l->next;
	}
      DrawMargins(p);
    }
}

void RewriteWholePage(Page *p)
{
  int width,height;
  p->change=0;
/*  fprintf(stderr,"RewriteWholePage called\n");*/
  width=p->width*scaleX;
  height=p->height*scaleX;
  if((width!=w_width)||(height!=w_height))
    {
      w_width=width; w_height=height;
      XtVaSetValues(bitmap,XtNheight,w_height,XtNwidth,w_width,NULL);
/*      XtVaGetValues(viewport,XtNheight,&v_height,XtNwidth,&v_width,NULL);*/
/*      myGetVWidth();
      XtVaSetValues(status,XtNwidth,v_width,NULL);*/
    }
  CursorUnblink();
  XFillRectangle(display,bitmapW,gcBack,v_x,v_y,v_width,v_height);
  WritePage(p);
}

void RewritePage(Page *p)
{
  Line *l=p->first;
  CursorUnblink();
  redisplay=0;
/*      CleanPage(p);*/
  FormatPage(p);
  if(p->change>0)
    RewriteWholePage(p);
  else
    {
      while((l!=NULL)&&(l->page==p))
	{
	  if(l->change>0)
	    {
	      RewriteLine(l,0,0);
	      l->change=0;
	    }
	  l=l->next;
	}
      DrawMargins(p);
    }
}

static
void CursorUnblinkCallback(XtPointer p, XtIntervalId *id)
{
  CursorUnblink();
}

static
void CursorBlinkCallback(XtPointer p, XtIntervalId *id)
{
  CursorBlink();
}

void CursorBlink(void)
{
/*  if(cursor_status.cursor_on>0)
    CursorUnblink();
  else*/
  if(cursor_status.cursor_on==0)
    {
      if(act_tpos->linep->line->page!=act_page)
	cursor_status.cursor_on=2;
      else
	{
	  cursor_status.p1=Tpos2Pos(*act_tpos);
	  cursor_status.p1.y*=scaleX;
	  cursor_status.p1.x*=scaleX;
	  cursor_status.p2=cursor_status.p1;
	  cursor_status.p2.y-=act_tpos->linep->line->height*scaleX;
	  cursor_status.p1.y+=act_tpos->linep->line->depth*scaleX;
	  XDrawLine(display,bitmapW,gcCursor,
		    (int)cursor_status.p1.x,(int)cursor_status.p1.y,
		    (int)cursor_status.p2.x,(int)cursor_status.p2.y);
	  cursor_status.cursor_on=1;
	}
/*      fprintf(stderr,"Cursor now on, calling delayed UnblinkCursor\n");*/
      cursor_status.id=XtAppAddTimeOut(app_context,300,CursorUnblinkCallback,
				       NULL);
      XFlush(display);
    }
}

void CursorUnblink(void)
{
  if(cursor_status.cursor_on>0)
    {
      if(cursor_status.cursor_on==1)
	XDrawLine(display,bitmapW,gcCursor,
		  (int)cursor_status.p1.x,(int)cursor_status.p1.y,
		  (int)cursor_status.p2.x,(int)cursor_status.p2.y);
      cursor_status.cursor_on=0;
/*      fprintf(stderr,"Cursor now off, calling delayed BlinkCursor\n");*/
      cursor_status.id=XtAppAddTimeOut(app_context,300,CursorBlinkCallback,
				       NULL);
      XFlush(display);
    }
}

void CenterPage(Pos pos)
{
  float x,y;

  x=(pos.x*scaleX-v_width/2)/w_width;
  y=(pos.y*scaleX-v_height/2)/w_height;
/*  if(x<0) x=0.0; if(x>1-v_width/w_width) x=1-v_width/w_width;
  if(y<0) y=0.0; if(y>1-v_height/w_height) y=1-v_height/w_height;*/
#ifdef BAD_VIEWPORT_SCROLLBARS
  XtCallCallbacks(hscroll,XtNjumpProc,(XtPointer)&x);
  XtCallCallbacks(vscroll,XtNjumpProc,(XtPointer)&y);
#else
  XawViewportSetLocation(viewport,x,y);
#endif
      act_tpos->linep->line->change=1;
}

void FollowCursor()
{
/*  Page *bup_page;*/
  Pos pos;

  CursorUnblink();
  XtRemoveTimeOut(cursor_status.id);
  pos=Tpos2Pos(*act_tpos);
  if((pos.x*scaleX>v_x+v_width)||(pos.x*scaleX<v_x)
     ||((pos.y+act_tpos->linep->depth)*scaleX>v_y+v_height)
     ||((pos.y-act_tpos->linep->height)*scaleX<v_y))
    CenterPage(pos);
  DelayedRewritePage();
  CursorBlink();
}

#if 0
void CursorReblink()
{
  if(cursor_status.cursor_on>0)
    {
      XDrawLine(display,bitmapW,gcCursor,
		(int)cursor_status.p1.x,(int)cursor_status.p1.y,
		(int)cursor_status.p2.x,(int)cursor_status.p2.y);
      cursor_status.cursor_on=0;
      fprintf(stderr,"Cursor now off, calling delayed BlinkCursor\n");
      XtAppAddTimeOut(app_context,1,CursorBlink,NULL);
      XFlush(display);
    }
}
#endif /* #if 0 */

void myViewAreaChange(Widget w, XtPointer cl_d, XtPointer ca_d)
{
/*  char s[256];*/
  XawPannerReport *r=(XawPannerReport*)ca_d;
/*  sprintf(s,"Panner: %d,%d,%d,%d,%d,%d: %d,%d",r->slider_x,r->slider_y,
	  r->slider_width,r->slider_height,r->canvas_width,r->canvas_height,
	  v_width,v_height);
  WriteStatus(s);
  fprintf(stderr,"%s\n",s);*/
/*  fprintf(stderr,"myViewChange\n");*/
  v_width=r->slider_width; v_height=r->slider_height;
  v_x=r->slider_x; v_y=r->slider_y;
  w_width=r->canvas_width; w_height=r->canvas_height;
}

#if 0
void myResizeBitmap(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  XResizeRequestEvent *ev=(XResizeRequestEvent*)cl_d;
  fprintf(stderr," Resize: %d, %d\n", ev->width, ev->height);
}
#endif

#define max(a,b) (((a)>(b))?(a):(b))

void InitText()
{

  if(finfo==NULL)
    {
#ifdef ICH      
      Dimension x=v_width,y=v_height;
      static Pixmap ich;
      ich = XCreateBitmapFromData(display,
				  RootWindowOfScreen(XtScreen(bitmap)),
				  (char*)ich_bits,ich_width,ich_height);
      XSetForeground(display,gcFore,black);
      XSetBackground(display,gcFore,white);
      x=max(0,(x-ich_width)/2); y=max(0,(y-ich_height)/2);
      XCopyPlane(display,ich,bitmapW,gcFore,0,0,ich_width,ich_height,x,y,1);
      XFlush(display);
#endif      
      WriteStatus("Initializing MyWord");
      myinit();
#ifdef ICH      
      XFillRectangle(display,bitmapW,gcBack,x,y,ich_width,ich_height);
#endif      
      cursor_status.cursor_on=0; /* It's the first time ... */
      CursorBlink();
      WriteStatus("Done.");
    }
  CursorUnblink();
  act_tpos->linep->line->change=1;
  WritePage(act_page);
}


static
void DelayedRewriteCallback(XtPointer p, XtIntervalId *i)
{
  RewritePage(act_page);
}

void DelayedRewritePage()
{
  Page *bup_page;

  bup_page=act_tpos->linep->line->page;
  if(bup_page!=act_page)
    {
      act_page=bup_page;
      act_page->change=1;
      fprintf(stderr,"xactions.c:39\n");
    }
  if(redisplay==0)
    {
      redisplay=1;
      XtAppAddTimeOut(app_context,10,
		      DelayedRewriteCallback,NULL);
    }
}

