#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Dialog.h>
#include "Xfwf/TextMenu.h"
#include "config.h"
#include "myword.h"
#include "xinit.h"
#include "xinternal.h"
#include "xactions.h"
#include "psinternal.h"
#include "mySelFile.h"
#include "status.h"
#include "xdialog.h"
#include "selection.h"

String actual_name;
int actual_overwrite=0; /* 0-nothing 1-yes 2-no */

static
void SetupPos(Widget w)
{
  Position x,y;
  XtVaGetValues(topLevel,XtNx,&x,XtNy,&y,NULL);
  XtVaSetValues(w,XtNx,x+20,XtNy,y+20,NULL);
}

static
char ModalYesNo(Widget toplevel, char* label, char *yes, char *no)
{
  Position x,y;
  XtVaGetValues(toplevel,XtNx,&x,XtNy,&y,NULL);
  XtVaSetValues(overwrite,XtNx,x+50,XtNy,y+50,NULL);
  XtVaSetValues(overwrite_label,XtNlabel,label,NULL);
  XtVaSetValues(overwrite_yes,XtNlabel,yes,NULL);
  XtVaSetValues(overwrite_no,XtNlabel,no,NULL);
  actual_overwrite=0;
  XtPopup(overwrite,XtGrabNonexclusive);
  while(actual_overwrite==0)
    {
      XEvent event;
      XtAppNextEvent(app_context,&event);
      XtDispatchEvent(&event);
    }
  XtPopdown(overwrite);
  return(actual_overwrite&1);
}

void doDeleteText(void)
{
  /* CursorUnblink(); */
  DeleteText(act_text);
  NewText(&act_text,&act_page,act_tpos);
  SetEval(act_page->first);
  act_page->change=1;
  fprintf(stderr,"xdialog.c:51\n");
  FollowCursor();
  DelayedRewritePage();
}

#if 0
void doLoad(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  Widget d=(Widget)cl_d;
  String string;
  
/*  string=XawDialogGetValueString(d);
  CursorUnblink();
  
  LoadText(string);
  RewritePage(act_page);*/
}
#endif

void doSave(void)
{
  SaveText(act_text->name);
}

void doWriteTo(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  Widget d=(Widget)cl_d;
  FILE *file;
  
  actual_name=XawDialogGetValueString(d);
  if((file=fopen(actual_name,"rb"))!=NULL)
    {
      fclose(file);
      actual_overwrite=1;
      SetupPos(overwrite);
      XtPopup(overwrite,XtGrabNonexclusive);
    }
  else
    {
      fclose(file);
      SaveText(actual_name);
    }
}

void doPrint(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  Widget d=(Widget)cl_d;
  FILE *file;

  actual_name=XawDialogGetValueString(d);
  if((file=fopen(actual_name,"rb"))!=NULL)
    {
      fclose(file);
      actual_overwrite=2;
      SetupPos(overwrite);
      XtPopup(overwrite,XtGrabNonexclusive);
    }
  else
    {
      fclose(file);
      PSPrintTextToFile(actual_name);
    }
}

void doOverwrite(Widget w, XtPointer cl_d, XtPointer ca_d)
{
/*  Widget i=(Widget)cl_d;
  XtPopdown(overwrite);
  if(actual_overwrite==1)
    SaveText(actual_name);
  else if(actual_overwrite==2)
    PrintText(actual_name);
  else
    WriteStatus("Overwrite what?");
  actual_overwrite=0;*/
  actual_overwrite=1;
}

void Popdown(Widget w, XtPointer cl_d, XtPointer ca_d)
{
/*  Widget pp=(Widget)cl_d;*/
/*  XtPopdown(overwrite);
  actual_overwrite=0;*/
  actual_overwrite=2;
}

#if 0
void PopdownFilesel(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  XtPopdown(filesel);
  actual_action=0;
}
#endif

void PopdownFontsel(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  XtPopdown(fontsel);
}

#if 0
void doLoadSave(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  XtPopdown(filesel);
  switch(actual_action)
    {
    case 1:
      doLoad(w,(XtPointer)fseldialog,ca_d);
      break;
    case 2:
      doWriteTo(w,(XtPointer)fseldialog,ca_d);
      break;
    case 3:
      doPrint(w,(XtPointer)fseldialog,ca_d);
      break;
    default:
      WriteStatus("Something wrong: FileSelected, but no action.");
    }
  actual_action=0;
}
#endif

void PopupLoad()
{
/*  if(actual_action==0)
    {*/
/*      SetupPos(filesel);
      XtVaSetValues(fseldialog,XtNlabel,"Load from File:       ",NULL);
      actual_action=1;
      XtPopup(filesel,XtGrabNonexclusive);*/
      char *name;
      Dimension x,y;
/*      FILE *file;*/

      XtVaGetValues(topLevel,XtNx,&x,XtNy,&y,NULL);
      name=mySelFile(topLevel,x,y);
      /*file=XsraSelFile(topLevel,"Load File","Done","Cancel","Failed","","rb",
		  NULL,&name);*/
      CursorUnblink();
      if(name[0]!=0)
	LoadText(name);
      RewritePage(act_page);
/*    }*/
}

void PopupWriteTo()
{
/*  if(actual_action==0)
    {*/
/*      SetupPos(filesel);
      XtVaSetValues(fseldialog,XtNlabel,"Write to File:         ",NULL);
      actual_action=2;
      XtPopup(filesel,XtGrabNonexclusive);*/
      char *name,string[1024];
      FILE *file;
      Dimension x,y;
      Flag f=1;

      XtVaGetValues(topLevel,XtNx,&x,XtNy,&y,NULL);
      name=mySelFile(topLevel,x,y);
      if(name[0]!=0)
	{
	  file=/*XsraSelFile(topLevel,"Save File","Done","Cancel","Failed","","wb",
		  NULL,&name);*/
	    fopen(name,"rb");
	  if(file!=NULL)
	    {
	      fclose(file);
	      sprintf(string,"Really overwrite %s?",name);
	      f=ModalYesNo(topLevel,string,"Yes","No");
	    }
	  if(f==1)
	    SaveText(name);
	}
/*    }*/
}

void PopupPrint()
{
/*  if(actual_action==0)
    {*/
/*      SetupPos(filesel);
      XtVaSetValues(fseldialog,XtNlabel,"Print to File:          ",NULL);
      actual_action=3;
      XtPopup(filesel,XtGrabNonexclusive);*/
      char *name,string[1024];
      FILE *file;
      Dimension x,y;
      Flag f=1;

      XtVaGetValues(topLevel,XtNx,&x,XtNy,&y,NULL);
      name=mySelFile(topLevel,x,y);
      if(name[0]!=0)
	{
	  file=/*XsraSelFile(topLevel,"Save File","Done","Cancel","Failed","","wb",
		 NULL,&name);*/
	    fopen(name,"rb");
	  if(file!=NULL)
	    {
	      fclose(file);
	      sprintf(string,"Really Overwrite %s?",name);
	      f=ModalYesNo(topLevel,string,"Yes","No");
	    }
	  if(f==1)
	    PSPrintTextToFile(name);
	}
/*    }*/
}

/*
void PopupExportAscii()
{
  if(actual_action==0)
    {
      SetupPos(filesel);
      XtVaSetValues(fseldialog,XtNlabel,"Print to File:");
      actual_action=4;
      XtPopup(filesel,XtGrabNonexclusive);
    }
}
*/

void PopupFontsel()
{
  SetupPos(fontsel);
  XtPopup(fontsel,XtGrabNonexclusive);
}  

/* Aufpassen, myFontsel ist nochmal in xencapsulate... (franz) */

void doFontsel(Widget w, XtPointer cl_d, XtPointer ca_d)
{
/*  Widget dialog=(Widget)cl_d;*/
  String str;
  char *name;
  float size;
  FontInfo *font;

  XtPopdown(fontsel);
  str=XawDialogGetValueString(fontseldialog);
  
  name=strtok(str," ");
  size=atof(name);
  name=strtok(NULL," ");

  font=LoadFont(name,size);

  if(font!=NULL)
    {
      ChangeFont(font);
      DelayedRewritePage();
    }
}

typedef union { int i; XtPointer p; } Point;

void doMenu( Widget w, XtPointer cl_d, XtPointer ca_d )
{
  Point ppp;
  unsigned int menu_no;
  XfwfTextMenuData *data=(XfwfTextMenuData*) ca_d;

  ppp.p=cl_d; menu_no=ppp.i;
  WriteStatus(data->label);
  switch(menu_no)
    {
    case 1: /* File */
      switch(data->n) 
	{
	case 0: /* New */
	  doDeleteText(); break;
	case 1: /* Load */
	  PopupLoad(); break;
	case 2: /* Save */
	  doSave(); break;
	case 3: /* WriteTo */
	  PopupWriteTo(); break;
	case 4: /* Import */
	  WriteStatus("Not yet implemented."); break;
	case 5: /* Print */
	  PopupPrint(); break;
	case 6: /* Quit */
	  Quit(0);
	}
      break;
    case 2: /* Edit */
      switch(data->n)
	{
	case 0: /* Kill */
	  WriteStatus("Not yet implemented."); break;
	case 1: /* Copy */
	  WriteStatus("Not yet implemented."); break;
	case 2: /* Yank */
	  WriteStatus("Not yet implemented."); break;
	case 3: /* Select all */
	  WriteStatus("Not yet implemented."); break;
	case 4: /* Write selection */
	  WriteStatus("Not yet implemented."); break;
	}
      break;
    case 3: /* Layout */
      switch(data->n)
	{
	case 0: /* SetPageDimen */
	  WriteStatus("Not yet implemented."); break;
	}
      break;
    case 4: /* Font */
      switch(data->n)
	{
	case 0: /* Select Font */
	  PopupFontsel(); break;
	}
      break;
    }
}

 
