#include <stdio.h>
#include <stdlib.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <strings.h>
#include "config.h"
#include "xinit.h"
#include "myword.h"
#include "xinternal.h"
#include "xactions.h"
#include "loadsave.h"
#include "psinternal.h"
#include "status.h"
#include "debug.h"

void test_init()
{
  act_page->width=150.0;
  act_page->wlist=(WindowList*)calloc(1,sizeof(WindowList));
  act_page->wlist->lu.x=80; act_page->wlist->lu.y=0;
  act_page->wlist->rl.x=120; act_page->wlist->rl.y=40;
}

static
float NextQuadPosToRight(Pos pos, WindowList *w, float h, float d)
{
  WindowList *w1=w;
  while(w!=NULL)
    if(!WindowsOverlapping(pos.x,pos.y-h,pos.x+h+d,pos.y+d,
 			   w->lu.x,w->lu.y,w->rl.x,w->rl.y))
      w=w->next;
    else
      {
 	pos.x=w->rl.x;
 	w=w1;
      }
  return(pos.x);
}

static
float NextPosToBottom(float y,WindowList *w)
{
  float y1=y;
  if(w!=NULL)
    {
      y1=w->rl.y;
      while(w!=NULL)
 	{
 	  if((w->rl.y<y1)&&(w->rl.y>y))
 	    y1=w->rl.y;
 	  w=w->next;
 	}
    }
  else
    fprintf(stderr,"a pity, NextPosToBottom called with NULL-WindowList\n");
  return(y1);
}

Flag GetLinePos(Line *l)
{
  float h=l->height, d=l->depth;
  int page_count=0; /* for breaking endless loop */
  Page *p; 
  WindowList *w, *w1;
  Pos pos;
  float maxr,maxl,maxt,maxb/*,x*/;
  
  p=l->page;
  if(l->previous==NULL)
    {
      pos.x=p->lmargin;
      pos.y=p->tskip+h;
    }
  else if(l->newline>1)
    {
      /*      if((l->window==NULL)||(l->window->next==NULL))
	      {*/
      pos.x=0;
      pos.y=2.0+l->page->height;
    }
  else
    {
      if((l->previous->page!=l->page)&&(l->eval>0))
 	{
 	  l->page->eval--;
 	  p=l->page=l->previous->page;
 	  l->window=l->previous->window;
 	  l->page->eval++;
 	}
      pos.x=l->previous->pos.x+l->previous->width;
      pos.y=l->previous->pos.y;
    }
  w=l->window;
  if(w==NULL)
    {
      w1=p->wlist;
      maxr=p->width-p->rmargin; maxl=p->lmargin;
      maxb=p->height-p->bskip; maxt=p->tskip;
    }
  else
    {
      /* if next-column do next-column */
      w1=w->wlist;
      maxr=w->rl.x; maxl=w->lu.x;
      maxb=w->rl.y; maxt=w->lu.y;
    }
  if((pos.y+l->depth>maxb)||((pos.x=NextQuadPosToRight(pos,w1,h,d))+h+d>maxr))
    {
      pos.x=maxl; 
      if(l->previous!=NULL)
 	pos.y+=l->previous->depth+l->previous->lineskip+h;
      while((page_count<2)&&((pos.y+l->depth>maxb)||
		  ((pos.x=NextQuadPosToRight(pos,w1,h,d))+h+d>maxr)))
 	{
 	  if(pos.y+d>maxb)
 	    {
 	      if((w!=NULL)&&(w->next!=NULL))
 		{
 		  w=w->next;
 		  pos=w->lu; pos.y+=h;
 		  maxl=w->lu.x; maxr=w->rl.x; maxt=w->lu.y; maxb=w->rl.y;
 		}
 	      else /* (w==0)||(w->next==NULL) */
 		{
 		  page_count++;
 		  if((p->next==NULL)||(p->next->newpage>0))
 		    {
 		      /* insert page; copy from old GetLinePos */
 		      InsertPage(p,l);
 		    }
 		  else
 		    {
 		      p=p->next; p->first=l;
 		      if(l->eval>0)
 			{ l->page->eval--; p->eval++; }
 		      l->page=p; SetEval(l->next);
		    }
 		  w=l->window=p->clist;
		  if(w==NULL)
 		    {
 		      w1=p->wlist;
 		      maxr=p->width-p->rmargin; maxl=p->lmargin;
 		      maxb=p->height-p->bskip; maxt=p->tskip;
 		    }
 		  else
 		    {
 		      /* if next-column do next-column */
 		      w1=w->wlist;
 		      maxr=w->rl.x; maxl=w->lu.x;
 		      maxb=w->rl.y; maxt=w->lu.y;
 		    }
 		  pos.x=maxl;
 		  pos.y=maxt+h;
 		}
 	    }
 	  else /* pos.y+d<=maxb */
 	    if(w==NULL)
 	      WriteStatus("Internal failure: test.c:131");
 	    else
 	      pos.y=NextPosToBottom(pos.y,l->window);
 	}
    }
  if(page_count>=2)
    WriteStatus("Failed to position line correctly.");
  if((l->pos.x!=pos.x)||(l->pos.y!=pos.y))
    {
      l->pos=pos;
      return(2);
    }
  return(0);
}

float GetLineWidth(Line *line,float h,float d)
{
  WindowList *w;
  float x,x1;
  
  if(line->window==NULL)
    {
      w=line->page->wlist;
      x=line->page->width-line->page->rmargin;
      x1=line->page->lmargin;
    }
  else
    {
      w=line->window->wlist;
      x=line->window->rl.x;
      x1=line->window->lu.x;
    }
  while(w!=NULL)
    {
      if(WindowsOverlapping(x1,line->pos.y-h,x,line->pos.y+d,
 			    w->lu.x,w->lu.y,w->rl.x,w->rl.y))
 	x=w->lu.x;
      w=w->next;
    }
  return(x-x1);
}

