#include "config.h"
#include "myword.h"
#include "xinternal.h"
#include "xactions.h"
#include "selection.h"

void ForeachLineInSelection(void func(Line*))
{
  Line *l,*l1;

  if(SelectionNotNULL)
    {
      for(l=bookmark[1].linep->line,l1=l1->next;
	  (l!=NULL)&&(l!=bookmark[2].linep->line);l=l1,l1=l1->next)
	func(l);
      if(l==NULL)
	fprintf(stderr,"End of selection not found");
      else
	func(bookmark[2].linep->line);
    }
}

void ForeachLinePInSelection(void func(LineP*))
{
  LineP *lp,*lp1;

  if(SelectionNotNULL)
    {
      if(bookmark[1].index!=0)
	SplitLineP(bookmark[1].linep,bookmark[1].index);
      if(bookmark[2].index<bookmark[2].linep->clength)
	SplitLineP(bookmark[2].linep,bookmark[2].index+1);
      for(lp=bookmark[1].linep,lp1=lp->next;
	  (lp!=NULL)&&(bookmark[2].linep!=lp);lp=lp1,lp1=NextLineP(lp1))
	func(lp);
      if(lp==NULL)
	fprintf(stderr,"Something went wrong with unselect: End not found\n");
      else /* if(bookmark[1].linep!=bookmark[2].linep) */
	func(bookmark[2].linep);
    }
}
	  
static void UnselectLineP(LineP *lp)
{
  lp->selb=LLine;
  lp->sele=LLine;
  lp->line->change=1;
}

void Unselect(void)
{
  if(SelectionNotNULL)
    ForeachLinePInSelection(UnselectLineP);
  bookmark[1].linep=bookmark[2].linep=NULL;
/*    {
      bookmark[2].linep=NULL; bookmark[1].linep=NULL;
    }
  else
    {
      if(!LaterLineP(bookmark[2].linep,bookmark[1].linep))
	{
	  fprintf(stderr,"Selection not correctly accomplished!");
	}
      else
	{
	  lp=bookmark[1].linep;
	  while((lp!=bookmark[2].linep)&&(lp!=NULL))
	    {
	      lp->selb=LLine;
	      lp->sele=LLine;
	      lp->line->change=1;
	      if(lp->next!=NULL)
		lp=lp->next;
	      else
		lp=lp->line->next->first;
	    }
	  if(lp==NULL)
	    fprintf(stderr,"BIG Mistake: End not found while unselect");
	  else
	    {
	      lp->selb=LLine;
	      lp->sele=LLine;
	      lp->line->change=1;
	      bookmark[2].linep=NULL;
	      bookmark[2].index=0;
	    }
	}
    }
*/
}
  

void SelBegin(void)
{
  if(bookmark[2].linep!=NULL)
    Unselect();
  bookmark[1]=*act_tpos;
  DelayedRewritePage();
}

void SelEnd(void)
{
  Flag f;
  LineP *lp;

  if(bookmark[1].linep!=NULL)
    {
      if(bookmark[2].linep!=NULL)
	Unselect();
      f=LaterLineP(act_tpos->linep,bookmark[1].linep);
      if(f==2)
	fprintf(stderr,"SelBegin&SelEnd not in same text!\n");
      else
	{
	  if(f==0)
	    {
	      if(bookmark[2].linep==NULL)
		bookmark[2]=bookmark[1];
	      bookmark[1]=*act_tpos;
	    }
	  else
	    {
	      if((act_tpos->linep==bookmark[1].linep)
		 &&(act_tpos->index<=bookmark[1].index))
		{
		  bookmark[2]=bookmark[1];
		  bookmark[1]=*act_tpos;
		}
	      else
		bookmark[2]=*act_tpos;
	    }
	  lp=bookmark[1].linep;
	  lp->selb=bookmark[1].index;
	  lp->sele=LLine;
	  lp->line->change=1;
	  if(lp!=bookmark[2].linep)
	    do
	      {
		if(lp->next==NULL)
		  lp=lp->line->next->first;
		else
		  lp=lp->next;
		lp->selb=0;
		lp->sele=LLine;
		lp->line->change=1;
	      } while(lp!=bookmark[2].linep);
	  lp->sele=bookmark[2].index;
	}
    }
}

/* since ANSI-C doesn't allow nested functions, here is a should-be-private
   variable: */
static FontInfo *changefont;
static void ChangeFontInLineP(LineP *lp)
{
  lp->finfo=changefont;
  lp->height=changefont->height;
  lp->depth=changefont->depth;
  SetEval(lp->line);
}

void ChangeFont(FontInfo *font)
{
  LineP *lp;

  changefont=font;
  if(SelectionNotNULL)
    ForeachLinePInSelection(ChangeFontInLineP);
  else
    {
      if(act_tpos->index>0)
	SplitLineP(act_tpos->linep,act_tpos->index);
      lp=act_tpos->linep;
      
/*      if(lp->previous==NULL)
	{
	  lp->previous=lp->line->first=MakeDummyLineP(lp);
	  lp->previous->next=lp;
	  lp->previous->line=lp->line;
	}
      else
	AppendChar(lp->previous,0);
*/
      PrependLineP(lp,MakeDummyLineP(lp));
      lp->previous->finfo=font;
      lp->previous->height=font->height;
      lp->previous->depth=font->depth;
      SetEval(lp->line);
    }
}

