/* Output Routines */
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "myword.h"
#include "loadsave.h"

static
void PrintoutLine(Line *l,FILE *f)
{
  LineP *lp,*lp1;
  Flag f1=0;
  int i,count=0;

  if(l!=NULL)
    {
      lp1=NULL;
      if(l->previous!=NULL)
	{
	  for(lp1=l->previous->first;lp1->next!=NULL;lp1=lp1->next);
	}
      
      CleanLine(l);
      if((l->previous!=NULL)&&((l->newline>0)
			       ||(l->lineskip!=l->previous->lineskip)))
	fprintf(f,"\\newline %d\n",l->newline);
      if((l->previous==NULL)||(l->previous->lineskip!=l->lineskip))
	fprintf(f,"\\lineskip %fpt\n",l->lineskip);
      if((lp1==NULL)||(l->previous->format!=l->format))
	fprintf(f,"\\format %d\n",l->format);
      lp=l->first;
      while(lp!=NULL)
	{
	  if(lp->kern!=0)
	    {
	      if(f1!=0) fprintf(f,"\n");
	      f1=0;
	      fprintf(f,"\\kern %f\n",lp->kern);
	    }
	  if((lp1==NULL)||(lp1->finfo!=lp->finfo))
	    {
	      if(f1!=0) fprintf(f,"\n");
	      fprintf(f,"\\font %f %s\n",lp->finfo->size,lp->finfo->name);
	      f1=0;
	    }
	  if(f1==0)
	    {
	      f1=1;
	      if(lp->c[0]=='\\')
                fputc('\\',f);
	    }
	  if(lp->special!=NULL)
	    switch(lp->special->type)
	      {
	      case 1:
		if(f1!=0) fprintf(f,"\n");
		fprintf(f,"\\tab\n");
		f1=0;
		break;
	      default:
		WriteStatus("Failed to write special.");
	      }
	  else
	    for(i=0;i<=lp->clength;i++)
	      if(lp->c[i]!=0)
		{
		  count++;
		  if(count>MAX_LINE)
		    {
		      fputc('\n',f);
		      if(lp->c[i]=='\\')
			fputc('\\',f);
		    }
		  fputc(lp->c[i],f);
		}
	  lp1=lp;
	  lp=lp->next;
	}
      fprintf(f,"\n");
    }
}

void PrintoutPage(Page *p,FILE *f)
{
  Line *l=p->first;
  if(p!=NULL)
    {
/*      if(p->newpage>0)*/
      fprintf(f,"\\newpage %d\n",p->newpage);
      while((l!=NULL)&&(l->page==p))
	{
	  PrintoutLine(l,f);
	  l=l->next;
	}
    }
}

static
void PrintoutText(Text *t,FILE *f)
{
  Page *p;
  Line *l;
  Flag flag=2;

  if(t!=NULL)
    {
      fprintf(f,"%s\n",myword_version);
      p=t->first;
      l=p->first;
/*      if(p->newpage>0)*/
      while(l!=NULL)
	{
	  if(l->page!=p)
	    {
	      fprintf(f,"\\newpage %d\n",p->newpage);
	      flag=1;
	      p=l->page;
	    }
	  if(flag>0)
	    {
	      if((flag==2)||(p->rmargin!=p->previous->rmargin))
		fprintf(f,"\\rightmargin %fpt\n",p->rmargin);
	      if((flag==2)||(p->lmargin!=p->previous->lmargin))
		fprintf(f,"\\leftmargin %fpt\n",p->lmargin);
	      if((flag==2)||(p->tskip!=p->previous->tskip))
		fprintf(f,"\\topskip %fpt\n",p->tskip);
	      if((flag==2)||(p->bskip!=p->previous->bskip))
		fprintf(f,"\\bottomskip %fpt\n",p->bskip);
	      if((flag==2)||(p->height!=p->previous->height))
		fprintf(f,"\\pageheight %fpt\n",p->height);
	      if((flag==2)||(p->width!=p->previous->width))
		fprintf(f,"\\pagewidth %fpt\n",p->width);
	      flag=0;
	    }
	  PrintoutLine(l,f);
	  l=l->next;
	}
    }
}

void SaveText(char *name)
{
  FILE *f;
  char s[256];

  if((f=fopen(name,"wb"))==NULL)
    {
/*      fprintf(stderr,"Error opening file for writing\n");*/
      WriteStatus("Error opening file for writing.");
    }
  else
    {
      sprintf(s,"Writing File %s",name); WriteStatus(s);
/*    free(act_text->name);*/
/*      act_text->name=(char*)malloc(sizeof(char)*strlen(name));*/
      strcpy(act_text->name,name);

      PrintoutText(act_text,f);
      if(fclose(f)!=0)
/*	fprintf(stderr,"Error writing file.\n");*/
	WriteStatus("Error writing file.");
      else
	WriteStatus("Done");
    }
}
