#ifndef MYWORD_H
#define MYWORD_H 1

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>

#define LLine 80

typedef char Flag;

typedef struct  {
  float x;
  float y;
} Pos;

typedef char *Map;

typedef struct {
  float height;
  float depth;
  float width;
} Metrics;

typedef struct KernL {
  struct KernL *next;
  char c;
  float kern;
} KernL;

typedef struct FontInfo {
  struct FontInfo *next;
  Font font;
  char *name;
  char *fontname;
  float scale; /* scale factor of bound XFont */
  float size;
  float height;
  float depth;
  Map map[256];
  Metrics metric[256];
  KernL *kern[256];
  Flag used;
  void *special;
} FontInfo;

typedef struct {
  float r,g,b; /* red,green,blue 0.0-1.0 */
  int x; /* best matching X color */
} Color;

typedef struct {
  int type; /* 0 eps, 1 XBitmap, 2 gif */
  char *name;
  Pixmap *pixmap; /* for X11 display */
  float scale; /* scale of Pixmap */
  Pos dimen; /* Dimensions of graphics */
} Graphics;

typedef struct TabRow {
  struct Page *row; /* This points to one row of a tabular */
  struct Line *line; /* This points to the line in which is the row */
  struct TabRow *next;
  struct TabRow *previous;
} TabRow;

typedef struct {
  Pos lu; /* Left-Upper corner */
  Pos rl; /* Right-Lower corner */
  Color color;
} Rule;

typedef struct WindowList {
  Pos lu;
  Pos rl;
  Rule lrule; /* Rule to the left */
  Rule rrule; /* Rule to the right */
  Rule trule; /* Rule at the top */
  Rule brule; /* Rule at the bottom */
  struct Page *page; /* for text-in-window */
  Graphics *graph; /* for graphics-in-window */
  Color color; /* for simple background color */
  struct WindowList *wlist;
  int backing_order; /* Window overlaps every Window with a higher number */
  void *special;
  struct WindowList *next;
} /*TextWindow*/ WindowList;

/*typedef struct WindowList {
  TextWindow window;
  struct WindowList *next;
} WindowList;*/

/*typedef TextWindow Column;

typedef WindowList ColumnList;  
*/

typedef union {
  int type;          /* type 1: Tab */
                     /* type 2: Graphics */
                     /* type 3: Tabulars */
  void *pointer;
} LPSpecial;

typedef struct LineP {
  struct LineP *next;
  struct LineP *previous;
  struct Line  *line;
  float  kern;
  Pos pos;
  float height;
  float depth;
  FontInfo  *finfo;
  int    clength;
  char c[LLine+1];
  Flag softhyph; /* 1 - last lp;  3 - softhyphen */
  int    selb; /* Selection begin */
  int    sele; /* Selection end */
  float  space_num; /* number of stretchable spaces */
                    /* this is float, because it is a factor */
  LPSpecial *special;
} LineP;

typedef struct Line {
  LineP *first;
  struct Line  *next;
  struct Line  *previous;
  struct Page  *page;
  TabRow *tabular;
  float  width;
  float  height;
  float  depth;
  float  actualwidth;
  float  lineskip;
  Flag   newline;
  Pos pos;
  int    format; /* {0,1,2,3}={justify,center,right,left} */
  int    eval; /* number of members to format */
  int    memopt; /* number of members to optimize for memory usage */
  int    clean; /* number of members to clean */
  int    change; /* changed by FormatLine (ready for display) */
  float  space_num;
  WindowList *window;
  void  *special;
} Line;

typedef struct Page {
  Line *first;
  struct Page *next;
  struct Page *previous;
  struct Text *text;
  int pageno;
  float width;
  float height;
  float rmargin; /* right margin */
  float lmargin; /* left margin */
  float tskip;   /* topskip */
  float bskip;   /* bottom skip */
  Pos pos;
  int newpage;
  long int eval;
  long int memopt;
  int change; /* Whole Page needs to be rewritten */
  Flag stretchable; /* 0 normal, 1 stretchable page, 2 no next page */
  WindowList *clist; /* The windows the text floats in */
  WindowList *wlist; /* The windows the text floats around */
  Graphics *back; /* background picture */
  void *special;
} Page;

typedef struct Text {
  Page *first;
  struct Text *next;
  struct Text *previous;
  char name[256];
  float height;
  float width;
  long int eval;
  long int memopt;
} Text;

typedef struct {
  struct LineP *linep;
  int index;
} Tpos;

/* Prototypes */
extern float GetKern(char,char,FontInfo*);
extern float GetWidth(char,FontInfo*);
extern void AppendChar(LineP*,char);
extern Tpos InsertChar(Tpos,char);
extern void InsertLineP(LineP*,LineP*);
extern void PrependLineP(LineP*,LineP*);
extern void InsertLine(Line*,Line*);
extern void FormatLine(Line*);
extern void FormatPage(Page*);
extern void FormatText(Text*);
extern void SplitLineP(LineP*,int);
extern void SetEval(Line*);
extern void OptMem(Line*);
extern void CleanLine(Line*);
extern void HeavyCleanLine(Line*);
extern Tpos DeleteChar(Tpos);
extern Flag UnbindLineP(LineP*);
extern void DeleteLineP(LineP*);
extern void DeleteLine(Line*);
extern void DeletePage(Page*);
extern void DeleteText(Text*);
extern FontInfo *LoadFont(char*,float);
extern Flag RescaleFont(FontInfo*,float);
extern FontInfo *FindFont(char*,float);
extern void DestroyFont(FontInfo*);
extern LineP *NextLineP(LineP*);
extern Tpos NextTpos(Tpos);
extern Tpos PreviousTpos(Tpos);
extern Tpos Pos2Tpos(Pos,Page*);
extern Pos Tpos2Pos(Tpos);
extern Tpos LineUp(Tpos);
extern Tpos LineDown(Tpos);
extern Tpos PageUp(Tpos);
extern Tpos PageDown(Tpos);
extern Tpos InsertString(Tpos,char*);
extern Tpos SearchString(Tpos,char*);
extern void GetTextDimen(Text*);
extern Flag GetLinePos(Line*);
extern float GetLineWidth(Line*,float,float);
extern Flag GetLineHeight(Line*);
extern LineP *MergeNextLineP(LineP*);
extern LineP *MergeNextLine(LineP*);
extern LineP *MakeDummyLineP(LineP*);
extern LineP *MakeStandardLineP(void);
extern Line *MakeLine(Line*,LineP*);
extern Flag LaterLineP(LineP*,LineP*);

extern Flag LoadText(char*);
extern void SaveText(char*);
extern void NewText(Text**,Page**,Tpos*);

extern void doReturn(Tpos*);
extern void doTab(Tpos);
extern void InsertPage(Page*,Line*);
extern void myinit(void);
extern void int_init(void);
extern void test_init(void);

/* Global variables */
#ifdef INTERNAL_C
#define EXTERN /**/
#else
#define EXTERN extern
#endif

#define NBookmarks 10 /* Must be greater than 4 (for selection) */
EXTERN Tpos bookmark[NBookmarks]; /* bookmark[0] current Cursor
				     bookmark[1],
				     bookmark[2] are margins of the selection
				     bookmark[3] temporary internal bookmark
				     bookmark[4] temporary bookmark for YOU */
EXTERN Text *act_text;
EXTERN Page *act_page;
EXTERN Tpos *act_tpos;
EXTERN FontInfo *finfo;
EXTERN Flag display_graphics;

#define IncrementXPos(xpos,linep,index,font,delta) \
 	{\
	  xpos+=GetWidth(linep->c[index],font)\
	         +GetKern(linep->c[index],linep->c[index+1],font);\
	  if((linep->c[index]==' ')\
	      &&((index!=linep->clength)||(linep->softhyph==0)))\
	    xpos+=delta;\
	}

#define CalcDelta(l) \
        (\
	   ( (l->space_num==0)||(l->next==NULL)\
	    ||(l->next->newline>0)||(l->format!=0)) ?\
	   0: (l->width-l->actualwidth)/l->space_num\
	)

#define WindowsOverlapping(l1,u1,r1,d1,l2,u2,r2,d2) \
  (((u1)<(d2))&&((d1)>(u2))&&((l1)<(r2))&&((r1)>(l2)))

#undef EXTERN
#endif /* #ifndef MYWORD_H */
