#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#define INTERNAL_C
#include "myword.h"
#include "debug.h"

#if 0
Tpos bookmark[NBookmarks];
Text *act_text;
Page *act_page;
Tpos *act_tpos;
FontInfo *finfo;
Flag display_graphics;
#endif

Tpos InsertChar(Tpos tpos,char c)
{
  LineP *lp=tpos.linep;
/*  Tpos t;*/
  char *cc=lp->c;
  char c1=cc[lp->clength];
  int i;

#if 1
  if((tpos.index==0)&&(tpos.linep->previous!=NULL))/*
     &&(tpos.linep->previous->finfo!=tpos.linep->finfo))*/
    {
      AppendChar(tpos.linep->previous,c);
      tpos.linep=lp=tpos.linep->previous;
      tpos.index=i=0;
    }
  else if(cc[tpos.index]=='\0')
    {
      cc[tpos.index]=c;
      if(tpos.linep->next==NULL)
	AppendChar(tpos.linep,0);
    }
  else
    {
      for(i=lp->clength;i>tpos.index;i--)
	cc[i]=cc[i-1];
      cc[i]=c;
      if(lp->clength<LLine-1)
	{
	  cc[++(lp->clength)]=c1;
	}
      else
	{
	  Tpos temp;
	  temp.index=0;
	  temp.linep=lp->next;
	  if(temp.linep==NULL)
	    AppendChar(lp,c1);
	  else
	    InsertChar(temp,c1);
	}
    }
/*  CleanLine(tpos.linep->line);*/
  bookmark[3]=tpos;
  /*Bookmarks moving*/
  for(i=0;i<NBookmarks;i++)
    if((bookmark[i].linep==lp)&&(bookmark[i].index>=tpos.index))
      {
	if(bookmark[i].index<lp->clength)
	  bookmark[i].index++;
	else
	  {
	    bookmark[i].index=0;
	    if(lp->next!=NULL)
	      bookmark[i].linep=lp->next;
	    else
	      bookmark[i].linep=lp->line->next->first;
	  }
      }
  
/*      bookmark[i]=NextTpos(bookmark[i]);*/
#endif
#if 0
  /* not nice code, but works (hopefully) */
  t=PreviousTpos(tpos);
  if((t.linep==tpos.linep)&&(t.index==tpos.index))
    {
      if(t.index==0)
	{
	  if(t.linep->clength>0)
	    SplitLineP(t.linep,1);
	  t.linep->c[1]=t.linep->c[0];
	  t.linep->c[0]=c;
	  t.linep->clength=1;
	  tpos.index=1;
	}
      else
	{
	  SplitLineP(t.linep,t.index);
	  tpos.linep=t.linep->next;
	  tpos.index=0;
	  AppendChar(t.linep,c);
	}
    }
  else
    {
      if(t.linep==tpos.linep)
	SplitLineP(tpos.linep,tpos.index);
      /*      tpos.linep=t.linep->next;
	      tpos.index=0;*/
      AppendChar(tpos.linep->previous,c);
    }
  bookmark[3]=tpos;
#endif

  OptMem(tpos.linep->line);
  SetEval(lp->line);

  return(bookmark[3]);
}

void AppendChar(LineP *lp,char c)
{
  LineP *lp1;
  lp1=MakeDummyLineP(lp);
  lp1->c[0]=c;
  InsertLineP(lp,lp1);
/*  if(lp->selb<=lp->clength)
    {
      lp1->selb=0;
    }
  if(lp->sele<=lp->clength)
    {
      lp1->sele=LLine;
    }*/
  if((lp->selb<LLine)&&(lp->sele<LLine))
    {
      lp1->selb=0; lp1->sele=LLine;
    }
  else
    {
      lp1->selb=LLine; lp1->sele=LLine;
    }
}

void SetEval(Line *l)
{
  if((l!=NULL)&&(l->eval==0))
    {
      l->eval=1;
      (l->page->eval)++;
      (l->page->text->eval)++;
    }
}

float GetKern(char c1,char c2,FontInfo *font)
{
  union {
    char s;
    unsigned char u;
  } c;
  KernL *k;
  float f=0.0;

  c.s=c1;
  k=font->kern[c.u];
  while((k!=NULL)&&(k->c!=c2))
     k=k->next;
  if(k!=NULL)
     f=k->kern;
  return(f);
}

float GetWidth(char c,FontInfo *font)
{
  union {
    char s;
    unsigned char u;
  } c1;
  c1.s=c;
  return(font->metric[c1.u].width);
}

void InsertLineP(LineP *lp,LineP *lp1)
{
  lp1->line=lp->line;
  lp1->next=lp->next;
  if(lp1->next!=NULL)
     lp1->next->previous=lp1;
  lp1->previous=lp;
  lp->next=lp1;
  SetEval(lp->line);
}

void InsertLine(Line *l, Line *l1)
{
  l1->page=l->page;
  l1->next=l->next;
  if(l1->next!=NULL)  l1->next->previous=l1;
  l1->previous=l;
  l->next=l1;
  SetEval(l1);
}

void SplitLineP(LineP *lp, int index)
{
  if((index<=lp->clength)&&(index>0))
    {
      int i;
      AppendChar(lp,0);
      for(i=index;i<=lp->clength;i++)
      	 lp->next->c[i-index]=lp->c[i];
      lp->next->clength=lp->clength-index;
      lp->clength=index-1;
      for(i=0;i<NBookmarks;i++)
      	if((bookmark[i].linep==lp)&&(bookmark[i].index>=index))
	  {
	    (bookmark[i].index)-=index;
	    bookmark[i].linep=lp->next;
	  }
      lp->next->sele=LLine;
      if((lp->selb<LLine)&&(lp->sele==LLine))
	lp->next->selb=0;
      else
	lp->next->selb=LLine;
    }
}

Tpos DeleteChar(Tpos tpos)
{
  Tpos t=tpos;
  int i;
  if(tpos.linep->clength==0)
    {
      if((tpos.linep->c[0]==0)&&(tpos.linep->next==NULL))
	{
	  if(tpos.linep->line->next!=NULL)
	    tpos.linep->line->next->newline=0;
	  t.linep=MergeNextLine(tpos.linep);
	  t.index=0;
	  SetEval(tpos.linep->line);
	  PrintAsciiPage(act_page);
	}
      else
	{
	  for(i=0;i<NBookmarks;i++)
	     if(bookmark[i].linep==t.linep)
	       bookmark[i]=NextTpos(bookmark[i]);
	  t=NextTpos(t);
	  DeleteLineP(tpos.linep);
	}
    }
  else
    {
      LineP *lp=t.linep;
      for(i=0;i<NBookmarks;i++)
      	 if(bookmark[i].linep==lp)
      	   if(bookmark[i].index>t.index)
      	     bookmark[i]=PreviousTpos(bookmark[i]);
      for(i=t.index;i<lp->clength;i++)
      	 lp->c[i]=lp->c[i+1];
      (lp->clength)--;
      if(t.index>lp->clength)
	{
	  t.index--;
	  t=NextTpos(t);
	}
      SetEval(lp->line);
    }
  return(t);
}

static
void DeleteSpecial(LPSpecial *special)
{
  if(special!=NULL)
    {
      switch(special->type)
	{
	case 1:
	  free(special);
	  break;
	default:
	  fprintf(stderr,"Not implemented to delete: type %d",special->type);
	}
    }
}

Flag UnbindLineP(LineP *lp)
{
  int i;

  if((lp->next==NULL)&&(lp->previous==NULL))
    {
      DeleteLine(lp->line);
      return(1);
    }
  else
    {
      SetEval(lp->line);
      for(i=0;i<NBookmarks;i++)
	if(bookmark[i].linep==lp)
	  {
	    bookmark[i].index=lp->clength;
	    bookmark[i]=NextTpos(bookmark[i]);
	    if(bookmark[i].linep==lp)
	      {
		bookmark[i].index=0;
		bookmark[i]=PreviousTpos(bookmark[i]);
	      }
	  }
      if(lp->special!=NULL)
	DeleteSpecial(lp->special);
      if(lp->previous==NULL)
	{
	  lp->line->first=lp->next;
	  lp->next->previous=NULL;
/*	  free(lp);*/
	}
      else
	{
	  lp->previous->next=lp->next;
	  if(lp->next!=NULL)
	    lp->next->previous=lp->previous;
/*	  free(lp);*/
	}
      return(0);
    }
}

void DeleteLineP(LineP *lp)
{
  if(UnbindLineP(lp)==0)
    free(lp);
}

void DeleteLine(Line *l)
{
  int i;
  if((l->next!=NULL)||(l->previous!=NULL))
    {
      l->page->change=1;
/*      fprintf(stderr,"internal.c;297\n");*/
      if(((l->next==NULL)||(l->next->page!=l->page))
	 &&((l->previous==NULL)||(l->previous->page!=l->page)))
	{
	  if(l->previous!=NULL)
	    l->previous->next=l->next;
	  if(l->next!=NULL)
	    l->next->previous=l->previous;
	  DeletePage(l->page);
	}
      else
	{
	  LineP *lp,*lp1;
	  for(i=0;i<NBookmarks;i++)
	    if((bookmark[i].linep!=NULL)&&(bookmark[i].linep->line==l))
	      {
		if(l->next!=NULL)
		  bookmark[i].linep=l->next->first;
		else
		  {
		    bookmark[i].linep=l->previous->first;
		    while(bookmark[i].linep->next!=NULL)
		      bookmark[i].linep=bookmark[i].linep->next;
		    bookmark[i].index=bookmark[i].linep->clength;
		  }
	      }
	  if(l->eval>0)
	    {
	      l->eval=0; l->page->eval--; l->page->text->eval--;
	    }
	  if(l->next!=NULL)
	    SetEval(l->next);
	  if((l->previous==NULL)||(l->previous->page!=l->page))
	    l->page->first=l->next;
	  if(l->previous!=NULL)
	    l->previous->next=l->next;
	  if(l->next!=NULL)
	    l->next->previous=l->previous;
	  lp=l->first; lp1=lp->next;
	  while(lp1!=NULL)
	    {
	      free(lp);
	      lp=lp1;
	      lp1=lp->next;
	    }
	  free(lp);
	  free(l);
	}
    }
}

void DeletePage(Page *p)
{ 
  Text *text=p->text;
  if((p->next!=NULL)||(p->previous!=NULL))
    {
      Line *l;
      LineP *lp,*lp1;
      if(p->previous!=NULL)
      	 p->previous->next=p->next;
      else
	text->first=p->next;
      if(p->next!=NULL)
      	 p->next->previous=p->previous;
      l=p->first->next; 
      while(l->page==p)
	{
	  DeleteLine(l);
	}
      lp=p->first->first;
      while(lp!=NULL)
	{
	  lp1=lp->next;
	  free(lp);
	  lp=lp1;
	}
      free(p->first);
      free(p);
      GetTextDimen(text);
    }
}

void OptMem(Line *l)
{
  LineP *t1,*t=l->first;
  while(((t1=t->next)!=NULL)&&(t1->next!=NULL))
    {
/*      t1=t->next;*/
      if((t->clength<LLine-1)&&(t1!=NULL)&&(t->special==NULL)&&
	  (t1->special==NULL)&&(t->finfo==t1->finfo)&&(t1->kern==0.0))
	{
	  int i,j,k;

	  for(i=t->clength+1,j=0;(i<LLine)&&(j<=t1->clength);i++,j++)
	     t->c[i]=t1->c[j];
	  t->clength=i-1;

	  /* Bookmarks moving */
	  for(k=0;k<NBookmarks;k++)
	    if(t1==bookmark[k].linep)
	      {
		if(bookmark[k].index<j)
		  {
		    bookmark[k].linep=t;
		    bookmark[k].index+=i-j;
		  }
		else
		  bookmark[k].index-=j;
	      }

	  if(t1->clength==j-1)
	     DeleteLineP(t1);
	  else
	    {
	      for(i=0;i+j-1<=t1->clength;i++)
	      	 t1->c[i]=t1->c[i+j-1];
	      t1->clength=i-1;
	    }
	}
      else
      	 t=t1;
    }
  HeavyCleanLine(l);
  l->memopt=0;
}

/* This is quite a monster. Sorry. */
void CleanLine(Line *l)
{
  LineP *lp=l->first,*lp1;
  int i;

  while((lp->next!=NULL)&&((lp->next->clength>0)
			   ||(lp->next->c[0]!=0)||(lp->next->next!=NULL)))
    if((lp->clength==0)&&(lp->c[0]==0)
       &&(lp->special==NULL)
       &&((lp->finfo==lp->next->finfo)
	  ||((lp->next->clength==0)&&(lp->next->c[0]==0)
	     &&(lp->next->special==NULL))))
      {
	for(i=0;i<NBookmarks;i++)
	  if(bookmark[i].linep==lp)
	    bookmark[i].linep=lp->next;
	if(lp->previous!=NULL)
	  lp->previous->next=lp->next;
	else
	  lp->line->first=lp->next;
	lp->next->previous=lp->previous;
	lp->next->kern+=lp->kern;
	lp1=lp; lp=lp->next;
	free(lp1);
      }
    else
      {
/*	if((lp->clength>0)&&(lp->c[lp->clength]=='\0'))
	  lp->clength--;*/
	lp->c[lp->clength+1]=0;
	lp=lp->next;
      }
  while(lp->next!=NULL)
    lp=lp->next;
  if((lp->clength>0)||(lp->c[0]!=0))
    {
      AppendChar(lp,0);
      lp->c[lp->clength+1]=0;
      lp=lp->next;
    }
  if((lp->previous!=NULL)&&(lp->previous->finfo!=lp->finfo))
    {
      lp->finfo=lp->previous->finfo;
      lp->height=lp->previous->height;
      lp->depth=lp->previous->depth;
    }
}

void HeavyCleanLine(Line *l)
{
  Tpos t;
  CleanLine(l);
  if(l->clean>0)
    {
      l->clean=0;
      t.linep=l->first;
      while(t.linep->next!=NULL)
	{
	  if(t.linep->clength>0)
	    {
	      t.index=0;
	      while(t.index<=t.linep->clength)
		if(t.linep->c[t.index]==0)
		  DeleteChar(t);
		else
		  t.index++;
	    }
	  t.linep=t.linep->next;
	}
    }
}
 
Pos Tpos2Pos(Tpos tpos)
{
  int i;
  Pos p;
/*  unsigned char *c=tpos.linep->c;*/
  FontInfo *font=tpos.linep->finfo;
  float delta;

  while(tpos.linep->line->eval>0)
    {
      bookmark[3]=tpos;
      FormatLine(tpos.linep->line);
      tpos=bookmark[3];
    }
  delta=CalcDelta(tpos.linep->line);
  p=tpos.linep->pos;
  for(i=0;i<tpos.index;i++)
    IncrementXPos(p.x,tpos.linep,i,font,delta);
  return(p);
}

static
Line *Pos2Line(Pos pos,Page *page)
{
  Line *l;
  if(page->eval>0)
     FormatPage(page);
  l=page->first;
  while((l->next!=NULL)&&(l->pos.y+l->depth<pos.y))
     l=l->next;
  return(l);
}

static
Tpos LinePos2Tpos(Line *l,Pos pos)
{
  LineP *lp;
  float x,delta;
  int index;
  char *c;
  FontInfo *font;
  Tpos tpos;
  while(l->page->eval>0)
     FormatPage(l->page);
  lp=l->first;
  delta=CalcDelta(l);
  while((lp->next!=NULL)&&(lp->next->pos.x<pos.x))
     lp=lp->next;
  index=0;
  c=lp->c;
  font=lp->finfo;
  x=lp->pos.x+GetWidth(c[0],font); 
  while((index<lp->clength)&&(x<pos.x))
    {
      index++;
      IncrementXPos(x,lp,index,font,delta);
    }
  tpos.linep=lp;
  tpos.index=index;
  return(tpos);
}

Tpos Pos2Tpos(Pos pos,Page *p)
{
  return(LinePos2Tpos(Pos2Line(pos,p),pos));
}

LineP *NextLineP(LineP *lp)
{
  if(lp==NULL)
    return(NULL);
  else if(lp->next!=NULL)
    return(lp->next);
  else if(lp->line->next!=NULL)
    return(lp->line->next->first);
  else
    return(NULL);
}

Tpos NextTpos(Tpos tpos)
{
  Tpos t=tpos;
  Flag f=0;
  do
    {
      if(t.index<t.linep->clength)
      	 (t.index)++;
      else
	{
	  if(t.linep->next!=NULL)
	    {
	      t.linep=t.linep->next;
	      t.index=0;
	      if(t.linep->next==NULL)
		f=1;
	    }
	  else 
	    {
	      if(t.linep->line->next!=NULL)
		{
		  t.linep=t.linep->line->next->first;
		  t.index=0;
		}
	      else
		f=1;
	    }
	}
    } while((f==0)&&(t.linep->c[t.index]==0)&&(t.linep->special==NULL)/*&&
	       ((t.index<t.linep->clength)||(t.linep->next!=NULL))*/);
  return(t);
}

Tpos PreviousTpos(Tpos tpos)
{
  Tpos t=tpos;
  Flag f=0;
  do
    {
      if(t.index>0)
      	 (t.index)--;
      else
	{
	  if(t.linep->previous!=NULL)
	    {
	      t.linep=t.linep->previous;
	      t.index=t.linep->clength;
	    }
	  else
	    {
	      f=1;
	      if(t.linep->line->previous!=NULL)
		{
		  static LineP *lp;
		  lp=t.linep->line->previous->first;
		  while(lp->next!=NULL)
		     lp=lp->next;
		  t.linep=lp; t.index=t.linep->clength;
		}
	      else if((t.linep->c[t.index]==0)&&(t.linep->special==NULL)&&
		      	 ((t.linep->next!=NULL)||(t.linep->clength>0)))
	      	 t=NextTpos(t);
	    }
	}
    } while((t.linep->c[t.index]==0)&&(f<1)&&(t.linep->special==NULL));
     
  return(t);
} 

void FormatPage(Page* page)
{
  Line *l;
  int i=1;
  while((page->eval>0)&&(i!=0))
    {
      l=page->first;
      i=0;
      while((l!=NULL)&&(l->page==page))
	{
	  if(l->eval>0)
	    {
	      FormatLine(l);
	      i++;
	    }
	  l=l->next;
	}
    }
  if(page->eval!=0)
    page->eval=0;
}

void FormatText(Text* text)
{
  Line *l;
  while(text->eval>0)
    {
      l=text->first->first;
      while(l!=NULL)
	{
	  if(l->eval>0)
	     FormatLine(l);
	  l=l->next;
	}
    }
}

LineP *MergeNextLineP(LineP *lp)
{
  LineP *lp1;
  Line *t;
  Tpos tpos;
  Flag change;

  if((lp==NULL)||(lp->next!=NULL)||
     	(lp->line->next==NULL)||(lp->line->next->newline>0))
     return(lp);
  else
    {
      change=lp->line->page->change;
      t=lp->line->next;
      if(lp->softhyph>2)
	{
	  tpos.linep=lp;
	  tpos.index=lp->clength;
	  DeleteChar(tpos);
	}
      lp->softhyph=0;
      lp1=t->first;
      t->first=lp1->next;
      InsertLineP(lp,lp1);
      if(t->first==NULL)
	{
	  t->first=MakeDummyLineP(lp);
	  DeleteLine(t);
	}
      else
	{
	  t->first->previous=NULL;
	  GetLineHeight(t);
	}
      lp->line->page->change=change;
      AppendChar(lp1,0);
      DeleteLineP(lp);
      return(lp1);
    }
}

LineP *MergeNextLine(LineP *lp)
{
  LineP *lp1,*lp2,*lp_bup=lp;
  Line *t;
  Tpos tpos;
  Flag change;

  if((lp==NULL)||(lp->next!=NULL)||
     	(lp->line->next==NULL)||(lp->line->next->newline>0))
     return(lp);
  else
    {
      change=lp->line->page->change;
      t=lp->line->next;
      if(lp->softhyph>2)
	{
	  tpos.linep=lp;
	  tpos.index=lp->clength;
	  DeleteChar(tpos);
	}
      lp->softhyph=0;
      lp1=t->first;
      do
	{
	  lp2=lp1->next;
	  InsertLineP(lp,lp1);
	  lp=lp1;
	  lp1=lp2;
	} while(lp1!=NULL);
      t->first=MakeDummyLineP(lp);
      DeleteLine(t);
      lp->line->page->change=change;
      lp=lp_bup->next;
      DeleteLineP(lp_bup);
      return(lp);
    }
}

LineP *MakeDummyLineP(LineP *lp)
{
  LineP *lp1;
  lp1=(LineP*)calloc(1,sizeof(LineP));
  (*lp1)=(*lp);
  lp1->next=lp1->previous=NULL;
  lp1->kern=0.0;
  lp1->clength=0;
  lp1->c[0]=0;
  lp1->special=NULL;
  if(lp->selb<LLine)  
    lp1->selb=0;
  if(lp->sele<LLine)
    lp1->selb=lp1->sele=LLine;
  return(lp1);
}

void GetTextDimen(Text *t)
{
  Page *p;

  t->height=0;
  t->width=0;
  for(p=t->first;p!=NULL;p=p->next)
    {
      if(t->height<p->height)
	t->height=p->height;
      if(t->width<p->width)
	t->width=p->width;
    }
}

#if 0
Flag GetLinePos(Line *l)
{
  Line *l1;
  Page *page=l->page;
  Pos p;
  Flag f=0;
  
  if((l->previous!=NULL)&&(l->previous->page!=page)
     	&&(l->previous->page!=page->previous))
    {
      f=8;
      page=l->page=l->previous->page;
    }
  if((l->previous==NULL)||(l->previous->page!=l->page))
    {
      p.x=l->page->lmargin; /*15.0;*/
      p.y=/*20.0*/l->page->tskip+l->height; /*+l->lineskip;*/
    }
  else
    {
      l1=l->previous;
      p.x=l1->pos.x;
      p.y=l1->pos.y+l1->depth+l->height+l->lineskip;
      if(p.y+l->depth>page->height-page->bskip)
	{
	  if((page->next==0)||(page->next->newpage>0))
	     InsertPage(page,l);
	  else
	    {
/*	      l->page=page->next;*/
	      page->next->first=l;
	      for(l1=l;l1->page==page;l1=l1->next)
		{
		  if(l1->eval>0)
		    {
		      page->eval--;
		      page->next->eval++;
		    }
		  l1->page=page->next;
		}
	    }
	  p.x=l->page->lmargin;
	  p.y=l->page->tskip+l->height;
	  f=8;
	}
    }
  if((f==0)&&(p.x==l->pos.x)&&(p.y==l->pos.y))
     return(0);
  else
    {
      l->pos=p;
/*      l->page->change=1;
      fprintf(stderr,"internal.c:821\n");*/
      return(4|f);
    }
}
#endif

#if 0
float GetLineWidth(Pos pos,Page *page,float height,float depth)
{
  return(page->width-pos.x-page->rmargin);
}
#endif

void int_init(void)
{
  finfo=NULL;
  act_text=NULL;
  act_page=NULL;
  act_tpos=(Tpos*)&bookmark;
  act_tpos->index=0;
  act_tpos->linep=NULL;
}

LineP *MakeStandardLineP()
{
  LineP *lp;
  lp=(LineP*)calloc(1,sizeof(LineP));
  lp->next=NULL;
  lp->previous=NULL;
  lp->kern=0.0;
  lp->pos.x=1.0;
  lp->pos.y=4.0;
  lp->finfo=finfo;
  lp->height=lp->finfo->height;
  lp->depth=lp->finfo->depth;
  lp->clength=0;
  lp->c[0]=0;
  lp->softhyph=0;
  lp->selb=LLine;
  lp->sele=LLine;
  return(lp);
}

void NewText(Text **text,Page **page,Tpos *tpos)
{
  Line *l;

  tpos->linep=MakeStandardLineP();
  tpos->linep->clength=0;
  tpos->linep->line=l=(Line*)calloc(1,sizeof(Line));
  tpos->index=0;
  l->first=tpos->linep;
  l->next=NULL;
  l->previous=NULL;
  l->width=500.0;
  l->height=tpos->linep->finfo->height;
  l->depth=tpos->linep->finfo->depth;
  l->lineskip=0.1;
  l->newline=1;
  l->pos=l->first->pos;
  l->format=0;
  l->eval=0;
  l->memopt=0;
  *page=l->page=(Page*)calloc(1,sizeof(Page));
  (*page)->first=l;
  (*page)->next=NULL;
  (*page)->previous=NULL;
  (*page)->pageno=1;
  (*page)->width=(*page)->first->width;
  (*page)->rmargin=(*page)->lmargin=15.0;
  (*page)->tskip=(*page)->bskip=20.0;
  (*page)->height=500.0;
  (*page)->pos=(*page)->first->pos;
  (*page)->newpage=1;
  (*page)->eval=0;
  (*page)->change=1;
  (*page)->memopt=(*page)->first->memopt;
  *text=(*page)->text=(Text*)calloc(1,sizeof(Text));
  (*text)->first=*page;
  (*text)->next=NULL;
  (*text)->previous=NULL;
  strcpy((*text)->name,"Noname.my");
  (*text)->height=(*page)->height;
  (*text)->width=(*page)->width;
  (*text)->eval=0;
  SetEval((*text)->first->first);
}

void myinit()
{
/*  Line *l;*/
  finfo=LoadFont("tnr",12);
#if 0
  act_tpos->linep=MakeStandardLineP();
  act_tpos->linep->clength=0;
  act_tpos->linep->line=l=(Line*)calloc(1,sizeof(Line));
  l->first=act_tpos->linep;
  l->next=NULL;
  l->previous=NULL;
  l->width=500.0;
  l->height=act_tpos->linep->finfo->height;
  l->depth=act_tpos->linep->finfo->depth;
  l->lineskip=0.1;
  l->newline=1;
  l->pos=l->first->pos;
  l->format=0;
  l->eval=0;
  l->memopt=0;
  act_page=l->page=(Page*)calloc(1,sizeof(Page));
  act_page->first=l;
  act_page->next=NULL;
  act_page->previous=NULL;
  act_page->pageno=1;
  act_page->width=act_page->first->width;
  act_page->height=500.0;
  act_page->pos=act_page->first->pos;
  act_page->newpage=1;
  act_page->eval=0;
  act_page->memopt=act_page->first->memopt;
  act_text=act_page->text=(Text*)calloc(1,sizeof(Text));
  act_text->first=act_page;
  act_text->next=NULL;
  act_text->previous=NULL;
  act_text->name="Noname";
  act_text->eval=0;
#endif

  NewText( &act_text, &act_page, act_tpos);

/*  strcpy(act_tpos->linep->c,"Hi, Dsc ho O");*/
/*  AppendChar(act_tpos->linep,0);*/
/*  act_tpos->linep->clength=strlen(act_tpos->linep->c)-1;*/
/*  act_tpos->index=4;
  *act_tpos=InsertChar(*act_tpos,'D');
  *act_tpos=InsertChar(*act_tpos,'s');
  AppendChar(act_tpos->linep,'N');*/
  test_init();
  SetEval(act_tpos->linep->line);
/*  FormatPage(act_page);*/
}

Line *MakeLine(Line *l, LineP *lp)
{
  Line *l1=NULL;
/*  int i;*/

  if(lp==l->first)
    {
      l->first=MakeDummyLineP(lp);
      lp->previous=l->first;
      lp->previous->next=lp;
    }
  l1=(Line*)calloc(1,sizeof(Line));
  *l1=*l;
  l1->newline=0;
  l1->eval=0;
  l1->memopt=0;
  l1->first=lp;
  if(lp->previous!=NULL)
    {
      lp->previous->next=NULL;
      lp->previous=NULL;
    }
  while(lp!=NULL)
    {
      lp->line=l1;
      lp=lp->next;
    }
  GetLineHeight(l1);
  return(l1);
}

Tpos LineUp(Tpos t)
{
  Line *l=t.linep->line;
  if(l->previous!=NULL)
    {
      l=l->previous;
      while((l!=NULL)&&(l->pos.y==l->next->pos.y))
	l=l->previous;
      if(l!=NULL)
	{
	  Pos pos;
	  pos=Tpos2Pos(t);
	  t=LinePos2Tpos(l,pos);
	}
    }
  return(t);
}

Tpos LineDown(Tpos t)
{
  Line *l=t.linep->line;
  if(l->next!=NULL)
    {
      l=l->next;
      while((l!=NULL)&&(l->pos.y==l->previous->pos.y))
	l=l->next;
      if(l!=NULL)
	{
	  Pos pos;
	  pos=Tpos2Pos(t);
	  t=LinePos2Tpos(l,pos);
	}
    }
  return(t);
}

#if 0
Tpos LineDown(Tpos t)
{
  if(t.linep->line->next!=NULL)
    {
      Pos pos;
      pos=Tpos2Pos(t);
      t=LinePos2Tpos(t.linep->line->next,pos);
    }
  return(t);
}
#endif

Tpos PageUp(Tpos t)
{
  if(t.linep->line->page->previous!=NULL)
    {
      Pos pos;
      pos=Tpos2Pos(t);
      t=Pos2Tpos(pos,t.linep->line->page->previous);
    }
  return(t);
}

Tpos PageDown(Tpos t)
{
  if(t.linep->line->page->next!=NULL)
    {
      Pos pos;
      pos=Tpos2Pos(t);
      t=Pos2Tpos(pos,t.linep->line->page->next);
    }
  return(t);
}

/* LaterLineP is:
   0 iff lp1 comes before lp2;
   1 iff lp1 is or comes later than lp2;
   2 iff none of the above is correct (true mistake) */
Flag LaterLineP(LineP *lp1,LineP *lp2)
{
  LineP *lp3=lp2;
  Line *l1,*l2,*l3;
  Flag f=5;

  if((lp1==0)||(lp2==0))
    return(2);
  else
    {
      if(lp1->line==lp2->line)
	{
	  while((lp1!=lp2)&&(lp1!=lp3)&&(f>3))
	    {
	      if(lp2!=NULL)
		lp2=lp2->previous;
	      if(lp3!=NULL)
		lp3=lp3->next;
	      if((lp2==NULL)&&(lp3==NULL))
		f=2;
	    }
	  if(lp1==lp2)
	    f=0;
	  if(lp1==lp3)
	    f=1;
	}
      else
	{
	  l1=lp1->line;
	  l2=l3=lp2->line;
	  
	  while((l1!=l2)&&(l1!=l3)&&(f>3))
	    {
	      if(l2!=NULL)
		l2=l2->previous;
	      if(l3!=NULL)
		l3=l3->next;
	      if((l2==NULL)&&(l3==NULL))
		f=2;
	    }
	  if(l1==l2)
	    f=0;
	  if(l1==l3)
	    f=1;
	}
      return(f);
    }
}

Tpos InsertString(Tpos t,char *a)
{
  int i,j,b=strlen(a);
  if(t.index>0)
    {
      SplitLineP(t.linep,t.index);
    }
  else
    {
      if((t.linep->previous==NULL)
	 ||(t.linep->previous->finfo!=t.linep->finfo))
	{
	  t.linep->line->first=MakeDummyLineP(t.linep);
	  t.linep->previous=t.linep->line->first;
	  t.linep->previous->next=t.linep;
	}
      t.linep=t.linep->previous;
    }
  
  while(b>0)
    {
/*      AppendChar(t.linep,*a);*/
      InsertLineP(t.linep,MakeDummyLineP(t.linep->next));
      
      t.linep=t.linep->next; t.linep->c[0]=*a;
      if(b>LLine) j=LLine;
      else j=b;
      for(a++,b--,i=1;i<j;i++,b--,a++)
	t.linep->c[i]=*a;
      t.linep->clength=j-1;
    }
  t.linep=t.linep->next;
  t.index=0;
  return(t);
}

void doReturn(Tpos *tp)
{
  LineP *lp=tp->linep;
  Line *l;
  if(tp->index>0)
    {
      SplitLineP(lp,tp->index);
    }
  else
    {
      if(tp->linep->previous==NULL)
	{
	  lp->line->first=MakeDummyLineP(lp);
	  lp->previous=lp->line->first;
	  lp->previous->next=lp;
	}
      lp=lp->previous;
    }
  l=MakeLine(tp->linep->line,tp->linep);
  InsertLine(lp->line,l);
/*  lp->next->previous=NULL;
  lp->next=NULL;*/
  AppendChar(lp,0);
  tp->linep->line->newline=1;
/*  tp->linep->line->page->change=1;*/
}

void DeleteText(Text *text)
{
  Page *p,*p1;
  Line *l,*l1;
  LineP *lp,*lp1;
  int i;

  for(l=text->first->first,l1=l->next;l!=NULL;l=l1,l1=l1?l1->next:NULL)
    {
      for(lp=l->first,lp1=lp->next;lp!=NULL;lp=lp1,lp1=lp1?lp1->next:NULL)
	free(lp);
      free(l);
    }

  for(p=text->first,p1=p->next;p!=NULL;p=p1,p1=p1?p1->next:NULL)
    free(p);

  free(text);
  for(i=0;i<NBookmarks;i++)
    {
      bookmark[i].index=0;
      bookmark[i].linep=NULL;
    }
}

void PrependLineP(LineP *lp,LineP *lp1)
{
  if(lp->previous==NULL)
    {
      lp1->next=lp; lp1->next->previous=lp1;
      lp1->previous=NULL; lp->line->first=lp1;
      lp1->line=lp->line;
      SetEval(lp1->line);
    }
  else
    InsertLineP(lp->previous,lp1);
}

void doTab(Tpos tp)
{
  LineP *lp;
  if(tp.index>0)
    {
      SplitLineP(tp.linep,tp.index);
    }
  lp=MakeDummyLineP(tp.linep);
  PrependLineP(tp.linep,lp);
  lp->special=(LPSpecial*)calloc(1,sizeof(LPSpecial));
  lp->special->type=1;
  SetEval(lp->line);
}
