#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/param.h>
#include <X11/Intrinsic.h>
#include "config.h"
#include "parseAFM/myparseAFM.h"
#define FONTS_C 1
#include "myword.h"
#include "xinit.h"
#include "status.h"

/*extern XPutChar(char,float,float,Window);*/

static
void ShowError(char *s)
{
  fprintf(stderr,"%s",s);
}

static
Font LoadXFont(char *name,int isize)
{
  char xname[MAX_NAME],**fontnames;
  int dummy;
  Font font;

/*  sprintf(xname,"Loading font %s at size %d",name,isize);
  WriteStatus(xname);*/

  sprintf(xname,"-myword-%s-precalc%d-*-*-*-%d-*-*-*-*-*-iso8859-1",
	                name,isize,        isize);
  fontnames=XListFonts(display,xname,1,&dummy);
  if((fontnames==0)||(strncmp(fontnames[0],xname,8)))
    sprintf(xname,"-myword-%s-*-*-*-*-%d-*-*-*-*-*-iso8859-1",
	                  name,      isize);
  XFreeFontNames(fontnames);
  font=XLoadFont(display,xname);
  if((font==BadName)||(font==BadAlloc))
    {
      if(finfo==NULL)
	{
	  fprintf(stderr,"\nMyWord FATAL: You forgot to set the FontPath\n");
	  exit(23652);
	}
      else
	font=finfo->font;
    }
  return(font);
}
  
Flag RescaleFont(FontInfo *font,float scale)
{
  int isize;

  if(scale!=font->scale)
    {
      XUnloadFont(display,font->font);
      font->scale=scale;
      isize=font->size*font->scale;
      font->font=LoadXFont(font->name,isize);
      if(font->font==(Font)NULL)
	ShowError("Error loading/rescaling font");
    }
  if(font->font==(Font)NULL)
    return(0);
  else
    return(1);
}

FontInfo *FindFont(char *name,float size)
{
  FontInfo *fi=finfo;

  while((fi!=NULL)&&((strcmp(name,fi->name))||(size!=fi->size)))
    fi=fi->next;
  return(fi);
}

void DestroyFont(FontInfo *font)
{
  FontInfo /* *f=font, */ *f1;
  KernL *kl,*kl1;
  int i;
  
  if((font!=finfo)||(font->next!=NULL))
    {
      if(font==finfo)
	finfo=font->next;
      else
	{
	  for(f1=finfo;(f1!=NULL)&&(f1->next!=font);f1=f1->next);
	  if(f1!=NULL)
	    f1->next=font->next;
	}
      for(i=0;i<255;i++)
	{
	  kl=font->kern[i];
	  font->kern[i]=NULL;
	  while(kl->next!=NULL)
	    {
	      kl1=kl->next;
	      free(kl);
	      kl=kl1;
	    }
	}
      XUnloadFont(display,font->font);
      if(font->special!=NULL)
	free(font->special);
      font->special=NULL;
      free(font);
    }
}

FontInfo *LoadFont(char *name,float size)
{
/*  Window w=bitmapW;*/
#ifndef PATH_MAX
#define PATH_MAX MAXPATHLEN
#endif
  char xname[PATH_MAX];
  FILE *afmfile;
  FontInfo *font;
  AFMFontInfo *afi;
  int isize,i;

  if((font=FindFont(name,size))==NULL)
    {
      font=(FontInfo*)calloc(1,3*sizeof(FontInfo));
      font->name=(char*)calloc(1,sizeof(char)*strlen(name));
      strcpy(font->name,name);
      font->size=size;
      font->scale=scaleX;
      isize=size*scaleX;
/*      sprintf(xname,"%s/%s.afm",fontpath[0],name);
      afmfile=fopen(xname,"r");*/
      for(i=0,afmfile=NULL;((afmfile==NULL)&&(i<myfontpaths));i++)
	{
	  sprintf(xname,"%s/%s.afm",myfontpath[i],name);
	  afmfile=fopen(xname,"r");
	}
      if(afmfile==NULL)
	{
	  free(font);
	  fprintf(stderr,"Can't find %s\n",xname);
	  return(finfo);
	  return(NULL);
	}
      switch(parseFile(afmfile,&afi,P_M|P_P|P_G))
	{
	case parseError:
	case earlyEOF:
	case storageProblem:
	  fclose(afmfile);
	  freeStorage(afi);
	  free(font);
	  return(NULL);
	case ok:
	default:
	  break;
	}
      fclose(afmfile);
      if(((font->font=LoadXFont(name,isize))==BadName)
	 ||(font->font==BadAlloc))
	{
	  free(font);
	  fprintf(stderr,"X can't find %s\n",name);
	  return(finfo);
	}

      /* This is the name of the font to use in PostScript */
      font->fontname=(char*)malloc(sizeof(char)*strlen(afi->gfi->fontName));
      strcpy(font->fontname,afi->gfi->fontName);

      {
	/* PutCharMetrics to FontInfo */
	CharMetricInfo *temp = afi->cmi;
	int i,c;
	float height,depth;
	font->height=font->depth=0.0;
/*	font->height=size*afi->gfi->fontBBox.ury/1000;
	font->depth=size*afi->gfi->fontBBox.lly/1000;*/
	for(i=0;i<afi->numOfChars;i++)
	  {
	    if((temp->code>0)&&(temp->code<256))
	      {
		c=temp->code;
		font->map[c]=(char*)malloc(sizeof(char)*strlen(temp->name));
		strcpy(font->map[c],temp->name);
		font->metric[c].width=(float)temp->wx*size/1000;
		height=(float)temp->charBBox.ury*size/1000;
		font->metric[c].height=height;
		depth=(float)-temp->charBBox.lly*size/1000;
		font->metric[c].depth=depth;
		if(font->height<height) font->height=height;
		if(font->depth<depth) font->depth=depth;
	      }
	    temp++;
	  }
	for(i=0;i<256;i++)
	  if(font->map[i]==NULL)
	    {
	      font->map[i]=calloc(1,1);
	      font->map[i][0]=0;
	    }
	
	/* Put KernData into FontInfo */
	{
	  PairKernData *k=afi->pkd;
	  KernL *kl;
	  int i1=0,i2=0;
	  for(i=0;i<afi->numOfPairs;i++)
	    {
	      if(strcmp(font->map[i1],k[i].name1))
		{
		  i1=0;
		  while((i1<256)&&(strcmp(font->map[i1],k[i].name1)))
		    i1++;
		  if(i1==256) i1=0;
		}
	      if(i1>0)
		{
		  i2=0;
		  while((i2<256)&&(strcmp(font->map[i2],k[i].name2)))
		    i2++;
		  if((i2>0)&&(i2<256))
		    {
		      kl=font->kern[i1];
		      if(kl!=NULL)
			{
			  while(kl->next!=NULL) kl=kl->next;
			  kl->next=(KernL*)calloc(1,sizeof(KernL));
			  kl=kl->next;
			  kl->next=NULL;
			}
		      else
			{
			  font->kern[i1]=(KernL*)calloc(1,sizeof(KernL));
			  kl=font->kern[i1];
			}
		      kl->c=i2;
		      kl->kern=(float)k[i].xamt*size/1000;
		    }
		}
	    }
	}
      }
      freeStorage(afi);
      if(finfo==NULL)
	finfo=font;
      else
	{
	  FontInfo *fi=finfo;
	  while(fi->next!=NULL) fi=fi->next;
	  fi->next=font;
	}
    }
  return(font);
}

