/* amiga_commandline.c -- prompt for AmigaDOS
   Copyright (C) 1993, 1994 John Harper <jsh@ukc.ac.uk>

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "jade.h"
#include "jade_protos.h"

#define INTUI_V36_NAMES_ONLY
#include <clib/intuition_protos.h>
#include <clib/keymap_protos.h>
#include <string.h>

_PR u_char *sys_prompt(VW *, u_char *, u_char *);

/*
 * returns a string got from the command line
 * it (the string) must be valstrfree()'ed after use.
 * cursor should be off.
 */
u_char *
sys_prompt(VW *vw, u_char *prompt, u_char *original)
{
    u_char *cmdline;
    long cmdlen;
    long promptlen = strlen(prompt);
    if(!sys_unsleep_vw(vw))
	return(FALSE);
    cmdline = str_dup(original ? original : (STRPTR)"");
    if(cmdline)
    {
	POS oldcursor = vw->vw_CursorPos;
	long oldstartcol = vw->vw_StartCol;
	long prevx;
	char keepgoing = 0;

	cmdlen = strlen(cmdline) + 1;
	vw->vw_CursorPos.pos_Col = promptlen + cmdlen - 1;
	vw->vw_CursorPos.pos_Line = vw->vw_StartCol + vw->vw_MaxY - 1;
	prevx = vw->vw_CursorPos.pos_Col;
	if(vw->vw_CursorPos.pos_Col >= vw->vw_MaxX)
	    vw->vw_StartCol = vw->vw_CursorPos.pos_Col - vw->vw_MaxX + 1;
	else
	    vw->vw_StartCol = 0;

	redraw_cmd_line(vw, prompt, cmdline, promptlen, cmdlen - 1);
	cmd_line_cursor(vw, CURS_ON);

	while(!keepgoing)
	{
	    struct IntuiMessage *imsg;

	    Wait(1 << vw->vw_Window->UserPort->mp_SigBit);
	    while((!keepgoing) && (imsg = ami_get_win_imsg(vw->vw_Window)))
	    {
		struct IntuiMessage imsgcopy = *imsg;
		ReplyMsg((struct Message *)imsg);
		if(imsgcopy.Class == IDCMP_RAWKEY)
		{
		    cmd_line_cursor(vw, CURS_OFF);
		    switch(imsgcopy.Code)
		    {
		    case 0x41:	/* delete */
			if(cmdlen > 1)
			{
			    u_char *newline;
			    vw->vw_CursorPos.pos_Col--;
			    cmdlen--;
			    if(newline = str_dupn(cmdline, cmdlen - 1))
			    {
				str_free(cmdline);
				cmdline = newline;
			    }
			}
			break;
		    case 0x44:	/* return */
			keepgoing = 1;
			break;
		    case 0x45:	/* escape */
			keepgoing = -1;
			break;
		    case 0x4c:	/* up */
		    case 0x4d:	/* down */
			if(last_prompted)
			{
			    u_char *temp = cmdline;
			    cmdline = last_prompted;
			    last_prompted = temp;
			    cmdlen = strlen(cmdline) + 1;
			    vw->vw_CursorPos.pos_Col = cmdlen + promptlen - 1;
			    prevx = 20000;
			}
			break;
		    default:
			if(!(imsgcopy.Code & IECODE_UP_PREFIX))
			{
			    struct InputEvent ie;
			    u_char buff[256];
			    long len;

			    ie.ie_Class = IECLASS_RAWKEY;
			    ie.ie_SubClass = 0;
			    ie.ie_Code = imsgcopy.Code;
			    ie.ie_Qualifier = imsgcopy.Qualifier;
			    ie.ie_EventAddress = *((APTR *)imsgcopy.IAddress);
			    if((len = MapRawKey(&ie, buff, 255, NULL)) != -1)
			    {
				u_char *newline;
				buff[len] = 0;
				if(newline = str_dupn(cmdline, cmdlen + len))
				{
				    strcat(newline, buff);
				    str_free(cmdline);
				    cmdline = newline;
				    cmdlen += len;
				    vw->vw_CursorPos.pos_Col += len;
				}
			    }
			}
			break;
		    }
		}
		else if(imsgcopy.Class == IDCMP_NEWSIZE)
		{
		    cmd_line_cursor(vw, CURS_OFF);
		    vw->vw_StartCol = oldstartcol;
		    sys_update_dimensions(vw);
		    redraw_all(vw);
		    prevx = 20000;
#if 0
		    redraw_cmd_line(vw, prompt, cmdline, promptlen,
				    cmdlen - 1);
#endif
		}
		else
		    continue;

		if(vw->vw_CursorPos.pos_Col >= vw->vw_MaxX)
		{
		    vw->vw_StartCol = vw->vw_CursorPos.pos_Col - vw->vw_MaxX + 1;
		    redraw_cmd_line(vw, prompt, cmdline, promptlen,
				    cmdlen - 1);
		}
		else
		{
		    vw->vw_StartCol = 0;
		    if(prevx >= vw->vw_MaxX)
			redraw_cmd_line(vw, prompt, cmdline, promptlen,
					cmdlen - 1);
		    else if(prevx < vw->vw_CursorPos.pos_Col)
			redraw_cmd_line_from(vw, prompt, cmdline, promptlen,
					     cmdlen - 1, prevx);
		    else
			redraw_cmd_line_from(vw, prompt, cmdline, promptlen,
					     cmdlen - 1,
					     vw->vw_CursorPos.pos_Col);
		}
		prevx = vw->vw_CursorPos.pos_Col;
		cmd_line_cursor(vw, CURS_ON);
	    }
	}
	if(keepgoing < 0)
	{
	    str_free(cmdline);
	    cmdline = NULL;
	}
	else
	{
	    str_free(last_prompted);
	    last_prompted = str_dup(cmdline);
	}
	cmd_line_cursor(vw, CURS_OFF);
	vw->vw_CursorPos = oldcursor;
	vw->vw_StartCol = oldstartcol;
	return(cmdline);
    }
    return(FALSE);
}
