;;;; ask.jl -- Boolean prompting
;;;  Copyright (C) 1993, 1994 John Harper <jsh@ukc.ac.uk>

;;; This file is part of Jade.

;;; Jade is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.

;;; Jade is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.

;;; You should have received a copy of the GNU General Public License
;;; along with Jade; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;;###autoload
(defun yes-or-no-p (question)
  "Prompts the user for a yes or no answer to QUESTION, returns t for yes."
  (let*
      ((answer (prompt (concat question " (yes or no) "))))
    (string= "yes" answer)))

(setq y-or-n-keymap (make-keylist))
(bind-keys y-or-n-keymap
  "n" '(throw 'ask nil)
  "BS" '(throw 'ask nil)
  "y" '(throw 'ask t)
  "SPC" '(throw 'ask t))

;;;###autoload
(defun y-or-n-p (question)
  "Prompts the user for a single keypress response, either `y' or `n' to the
string QUESTION, returns t for `y'."
  (let*
      ((old-u-k-h unbound-key-hook)
       (old-k-p keymap-path)
       (buf (current-buffer))
       (title-string (concat question " (y or n) ")))
    (setq unbound-key-hook (cons #'(lambda ()
				     (beep)
				     (message title-string)) nil))
    (setq keymap-path '(y-or-n-keymap)
	  status-line-cursor t)
    (message title-string)
    (unwind-protect
	(catch 'ask
	  (recursive-edit))
      (with-buffer buf
	(setq keymap-path old-k-p
	      unbound-key-hook old-u-k-h
	      status-line-cursor nil)))))
