/*   Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"

/*************************************************************************************/
/*       			PROCEDURE DECLARATIONS     		             */
/*************************************************************************************/

void
gui_createHelpPopUp(toplevel)
Widget	toplevel;
{
	Arg	args[15];
	int	n;
	Widget	helpFrame,helpFO,helpListFrame,helpTextFrame,
		helpControlFO,helpListFO,helpLabel,helpHelpPB,helpCancelPB;
		

/* CREATE HELP POPUP UNMANAGED */
	n=0;
	XtSetArg(args[n],XmNautoUnmanage,False); n++;
	helpPopUp= XmCreateBulletinBoardDialog(toplevel,"Help",args,n);

/* CREATE FRAME FOR HELP FORM */
	n=0;
	helpFrame = XmCreateFrame(helpPopUp,"help",args,n);
	XtManageChild(helpFrame);

/* HELP FORM */
	n=0;
	XtSetArg(args[n],XmNwidth,650); n++;
	helpFO = XmCreateForm(helpFrame,"helpFO",args,n);
	XtManageChild(helpFO);

/*********************************************************************************/
/*HELP LIST FRAME */
	n=0;	
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++; 
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++; 
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++; 
	helpListFrame = XmCreateFrame(helpFO,"control",args,n);
	XtManageChild(helpListFrame);

/* HELP CREATE FRAME FOR TEXT AREA */
	n=0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++; 
	XtSetArg(args[n],XmNleftWidget,helpListFrame); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	helpTextFrame=XmCreateFrame(helpFO,"helpTextFrame",args,n);
	XtManageChild(helpTextFrame);
/*************************************************************************/
/*CREATE HELP TEXT CANVAS*/
	n=0;
	XtSetArg(args[n],XmNeditable,False); n++;
	XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
	helpText=XmCreateScrolledText(helpTextFrame,"helpText",args,n);
	XtManageChild(helpText);

/*********************************************************************************/
/* HELP LIST FORM WIDGET */
	n=0;
	helpListFO = XmCreateForm(helpListFrame,"helpListFO",args,n);
	XtManageChild(helpListFO);

/* HELP LIST LABEL WIDGET */
	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	helpLabel = XmCreateLabel(helpListFO,"Help Topics",args,n);
	XtManageChild(helpLabel);

/* HELP LIST WIDGET */
	n = 0;
	XtSetArg(args[n],XmNvisibleItemCount,20); n++;
	XtSetArg(args[n],XmNlistSizePolicy,XmCONSTANT); n++;
	XtSetArg(args[n],XmNselectionPolicy,XmBROWSE_SELECT); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopWidget,helpLabel); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	helpLI = XmCreateScrolledList(helpListFO,"helpLI",args,n);
	XtAddCallback(helpLI,XmNbrowseSelectionCallback,gui_helpSelectCB,NULL);
	XtManageChild(helpLI);

/* MAIN CONTROL BUTTONS */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,2); n++; 
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNspacing,10); n++;
	XtSetArg(args[n],XmNtopWidget,helpLI); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	helpControlFO=XmCreateRowColumn(helpListFO,"CONTROL",args,n);
	XtManageChild(helpControlFO);

/* HELP BUTTON WIDGET */
	n = 0;
	helpHelpPB = XmCreatePushButtonGadget(helpControlFO," HelpOnHelp ",args,n);
	XtAddCallback(helpHelpPB,XmNdisarmCallback,gui_helpCB,HELPHELP); 
	XtManageChild(helpHelpPB);

/* CANCEL BUTTON WIDGET */
	n = 0;
	helpCancelPB = XmCreatePushButtonGadget(helpControlFO," Cancel ",args,n);
	XtAddCallback(helpCancelPB,XmNdisarmCallback,gui_helpCB,HELPCANCEL); 
	XtManageChild(helpCancelPB);
}


/**************************************/
/* CREATE CONFIGURATION POPUP         */
/**************************************/
void
gui_createConfigPopUp(toplevel)
Widget	toplevel;
{
	Arg	args[15];
	int	n;
	Widget  toolBarFrame,languageFrame,autosavetimeFrame,autosaveFrame,
		rootFrame,workingFrame,printerFrame,onOffFrame,controlFrame,
		toolBarFO,toolBarLabel,languageFO,languageLabel,
		autosavetimeFO,autosavetimeLabel,autosavetimeLabel2,autosaveFO,autosaveLabel,
		autosaveBox,
		rootFO,rootLabel,workingFO,workingLabel,
		printerFO,printerLabel,
		onOffFO,formatterBox,backupBox,
		controlFO,okPB,saveConfigPB,cancelConfigPB,restoreConfigPB,helpConfigPB,
		configFrame,configFO,formatterFO,backupFO,formatterLabel,backupLabel;


/* CREATE CONFIG POPUP UNMANAGED */
	n=0;
	XtSetArg(args[n],XmNautoUnmanage,False); n++;
	configPopUp= XmCreateBulletinBoardDialog(toplevel,"Configuration",args,n);

/* CREATE FRAME FOR MAIN FORM */
	n=0;
	configFrame = XmCreateFrame(configPopUp,"config",args,n);
	XtManageChild(configFrame);

/* CONFIG FORM WIDGET */
	n=0;
	XtSetArg(args[n],XmNspacing,3); n++;
	configFO = XmCreateForm(configFrame,"configFO",args,n);
	XtManageChild(configFO);

/*******************************************************************************/
/* 				   OBJECT FRAMES 			       */
/* 				MAKES ATTACHMENT EASY 			       */	
/*******************************************************************************/

/* ON OFF FRAME */
	n=0;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++; 
	onOffFrame = XmCreateFrame(configFO,"onOff",args,n);
	XtManageChild(onOffFrame);

/*AUTOSAVETIME FRAME */
	n=0;	
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++; 
	XtSetArg(args[n],XmNtopWidget,onOffFrame); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++; 
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	autosavetimeFrame = XmCreateFrame(configFO,"autosavetime",args,n);
	XtManageChild(autosavetimeFrame);

/*CONTROL FRAME */
	n=0;	
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNbottomWidget,autosavetimeFrame); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++; 
	XtSetArg(args[n],XmNleftWidget,onOffFrame); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++; 
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	controlFrame = XmCreateFrame(configFO,"control",args,n);
	XtManageChild(controlFrame);


/* PRINTER FRAME */
	n=0;	
	XtSetArg(args[n],XmNtopWidget,autosavetimeFrame); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNrightWidget,controlFrame); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET); n++; 
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	printerFrame = XmCreateFrame(configFO,"printer",args,n);
	XtManageChild(printerFrame);

/* ROOT FRAME */
	n=0;	
	XtSetArg(args[n],XmNtopWidget,printerFrame); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++; 
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	rootFrame = XmCreateFrame(configFO,"root",args,n);
	XtManageChild(rootFrame);

/********************************************************************************/
/* 	OBJECT DEFINITIONS							*/
/********************************************************************************/
/***************************************************************************************/
/*****************************************************************************/
	
/*****************************************************************************/

/* ROOT DIRECTORY ROW COLUMN */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNspacing,0); n++;
	XtSetArg(args[n],XmNpacking,XmPACK_COLUMN); n++;
	rootFO=XmCreateRowColumn(rootFrame,"Width",args,n);
	XtManageChild(rootFO);

/* ROOT LABEL WIDGET */
	n = 0;
	rootLabel = XmCreateLabelGadget(rootFO,"Root Directory",args,n);
	XtManageChild(rootLabel);

/* ROOT TEXT */
	n=0;
	XtSetArg(args[n],XmNvalue,RootDirectory); n++;
	XtSetArg(args[n],XmNmaxLength,200); n++;
	XtSetArg(args[n],XmNcolumns,32); n++;
	XtSetArg(args[n],XmNeditable,False); n++;
	rootText = XmCreateTextField(rootFO,"rootText",args,n);
	XtAddCallback(rootText,XmNvalueChangedCallback,gui_rootTextCB,NULL);
	XtManageChild(rootText);

/*****************************************************************************/

/* PRINTER DIRECTORY ROW COLUMN */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNpacking,XmPACK_COLUMN); n++;
	XtSetArg(args[n],XmNspacing,0); n++;
	printerFO=XmCreateRowColumn(printerFrame,"PRINTER",args,n);
	XtManageChild(printerFO);

/* PRINTER LABEL WIDGET */
	n = 0;
	printerLabel = XmCreateLabelGadget(printerFO,"Printer",args,n);
	XtManageChild(printerLabel);

/* PRINTER TEXT */
	n=0;
	XtSetArg(args[n],XmNvalue,DefaultPrinter); n++;
	XtSetArg(args[n],XmNmaxLength,20); n++;
	XtSetArg(args[n],XmNcolumns,15); n++;
	printerText = XmCreateTextField(printerFO,"printerText",args,n);
	XtAddCallback(printerText,XmNvalueChangedCallback,gui_printerTextCB,NULL);
	XtManageChild(printerText);

/*****************************************************************************/
/* AUTOSAVETIME ROW COLUMN */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,3); n++; 
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNspacing,3); n++;
	autosavetimeFO=XmCreateRowColumn(autosavetimeFrame,"Time",args,n);
	XtManageChild(autosavetimeFO);

/* AUTOSAVETIME LABEL WIDGET */
	n = 0;
	autosavetimeLabel = XmCreateLabelGadget(autosavetimeFO,"Auto save every",args,n);
	XtManageChild(autosavetimeLabel);

/* AUTOSAVETIME TEXT */
	n=0;
	XtSetArg(args[n],XmNmaxLength,20); n++;
	XtSetArg(args[n],XmNcolumns,5); n++;
	autosavetimeText = XmCreateTextField(autosavetimeFO,"autosavetimeText",args,n);
	XtAddCallback(autosavetimeText,XmNactivateCallback,gui_autosavetimeTextCB,NULL);
	XtManageChild(autosavetimeText);

/* AUTOSAVETIME LABEL 2 WIDGET */
	n = 0;
	autosavetimeLabel2 = XmCreateLabelGadget(autosavetimeFO,"seconds",args,n);
	XtManageChild(autosavetimeLabel2);
/**************************************************************************************/

/* ON OFF BOX */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,2); n++; 
	XtSetArg(args[n],XmNspacing,0); n++;
	onOffFO=XmCreateRowColumn(onOffFrame,"ON OFF",args,n);
	XtManageChild(onOffFO);

/*******************************/

/* AUTOSAVE BOX*/
	n=0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNspacing,3); n++;
	autosaveFO=XmCreateRowColumn(onOffFO,"autosaveFO",args,n);
	XtManageChild(autosaveFO);

/* AUTOSAVE LABEL WIDGET */
	n = 0;
	autosaveLabel = XmCreateLabelGadget(autosaveFO,"Auto Save",args,n);
	XtManageChild(autosaveLabel);

/* AUTOSAVE ON OFF BOX*/
	n=0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNspacing,3); n++;
	autosaveBox=XmCreateRadioBox(autosaveFO,"autosaveBox",args,n);
	XtManageChild(autosaveBox);

/* ON OFF BUTTONS*/
	n=0;
	XtSetArg(args[n],XmNset,AutoSave); n++;
	XtSetArg(args[n],XmNfillOnSelect,True);n++;
	autosaveOnTB=XmCreateToggleButton(autosaveBox,"on",args,n);	
	XtAddCallback(autosaveOnTB,XmNarmCallback,gui_autosaveOnCB,NULL); 
	XtManageChild(autosaveOnTB);
	
	n=0;
	XtSetArg(args[n],XmNset,!AutoSave); n++;
	XtSetArg(args[n],XmNfillOnSelect,True);n++;
	autosaveOffTB=XmCreateToggleButton(autosaveBox,"off",args,n);	
	XtAddCallback(autosaveOffTB,XmNarmCallback,gui_autosaveOffCB,NULL); 
	XtManageChild(autosaveOffTB);


/* BACKUP BOX*/
	n=0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNspacing,3); n++;
	backupFO=XmCreateRowColumn(onOffFO,"backupFO",args,n);
	XtManageChild(backupFO);

/* BACKUP LABEL WIDGET */
	n = 0;
	backupLabel = XmCreateLabelGadget(backupFO,"Auto Backup",args,n);
	XtManageChild(backupLabel);

/* BACKUP ON OFF BOX*/
	n=0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNspacing,3); n++;
	backupBox=XmCreateRadioBox(backupFO,"backupBox",args,n);
	XtManageChild(backupBox);

/* ON OFF BUTTONS*/
	n=0;
	XtSetArg(args[n],XmNset,AutoBackup); n++;
	XtSetArg(args[n],XmNfillOnSelect,True);n++;
	backupOnTB=XmCreateToggleButton(backupBox,"on",args,n);	
	XtAddCallback(backupOnTB,XmNarmCallback,gui_backupOnCB,NULL); 
	XtManageChild(backupOnTB);
	
	n=0;
	XtSetArg(args[n],XmNset,!AutoBackup); n++;
	XtSetArg(args[n],XmNfillOnSelect,True);n++;
	backupOffTB=XmCreateToggleButton(backupBox,"off",args,n);	
	XtAddCallback(backupOffTB,XmNarmCallback,gui_backupOffCB,NULL); 
	XtManageChild(backupOffTB);

/* MAIN CONTROL BUTTONS */
	n = 0;
	XtSetArg(args[n],XmNnumColumns,1); n++; 
	XtSetArg(args[n],XmNpacking,XmPACK_COLUMN); n++;
	XtSetArg(args[n],XmNspacing,10); n++;
	controlFO=XmCreateRowColumn(controlFrame,"CONTROL",args,n);
	XtManageChild(controlFO);

/* OK BUTTON WIDGET */
	n = 0;
	okPB = XmCreatePushButtonGadget(controlFO,"        OK       ",args,n);
	XtAddCallback(okPB,XmNdisarmCallback,gui_okConfigCB,NULL);
	XtManageChild(okPB);

/* SAVE CONFIG BUTTON WIDGET */
	n = 0;
	saveConfigPB = XmCreatePushButtonGadget(controlFO,"   Save  Config  ",args,n);
	XtAddCallback(saveConfigPB,XmNdisarmCallback,saveConfigCB,NULL);
	XtManageChild(saveConfigPB);

/* CANCEL BUTTON WIDGET */
	n = 0;
	cancelConfigPB = XmCreatePushButtonGadget(controlFO,"      Cancel     ",args,n);
	XtAddCallback(cancelConfigPB,XmNdisarmCallback,gui_cancelConfigCB,NULL); 
	XtManageChild(cancelConfigPB);

/* RESTORE DEFAULTS BUTTON WIDGET */
	n = 0;
	restoreConfigPB = XmCreatePushButtonGadget(controlFO," Restore Defaults",args,n);
	XtAddCallback(restoreConfigPB,XmNdisarmCallback,gui_restoreConfigCB,NULL); 
	XtManageChild(restoreConfigPB);

/* HELP BUTTON WIDGET */
	n = 0;
	helpConfigPB = XmCreatePushButtonGadget(controlFO,"      Help     ",args,n);
	XtAddCallback(helpConfigPB,XmNdisarmCallback,gui_helpCB,HELPSETUP); 
	XtManageChild(helpConfigPB);
}

