/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler. (goblin@dcs.qmw.ac.uk)


*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

void
gui_cutCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	/* FIRST TAKE A SNAPSHOT TO ALLOW FOR UNDO */
	EditEvent=True;
	snapshot();
	LastOp=CUTOP;
	XmTextCut(text_canvas,CurrentTime); 
}

void
gui_copyCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	XmTextCopy(text_canvas,CurrentTime); 
}

void
gui_undoCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	char *temp;
	XmTextPosition tempPosition;
	Dimension height;
	int 	rows,charcount,linecount;

	EditEvent=True;
	/* Make copy of OldCanvas details so as to be able to undo undo */
	temp=OldCanvasValue;
	tempPosition=OldCanvasPosition;
	snapshot();
	/* Now perform Undo */
	XmTextSetString(text_canvas,temp);	
	/* Now motif doesn't offer any thing to return the height 
	in columns of the text canvas so I'm going to have to 
	guestimate*/
	XtVaGetValues(text_canvas,XmNheight,&height,NULL);
	rows=(int)((int)height/15);
	/*Now search backwards rows/2 lines */
	charcount=tempPosition;
	linecount=(int)rows/2;
	while ((linecount>0)&&(charcount>1))
	{
		charcount--;
		if (temp[charcount]=='\n')
			linecount--;
	};
	XmTextSetTopCharacter(text_canvas,charcount);
	/* Now set insertion position to beginning of word */
	XmTextSetInsertionPosition(text_canvas,tempPosition);
	/* Free up temp */
	if (temp!=NULL) XtFree(temp);
	LastOp=UNDOOP;
}

void
gui_pasteCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	/* FIRST TAKE A SNAPSHOT TO ALLOW FOR UNDO */
	EditEvent=True;
	snapshot();
	XmTextPaste(text_canvas);
	LastOp=PASTEOP;
}

/* Take a copy of the current value of the text_canvas */
void
snapshot()
{
	OldCanvasValue=(char*) XmTextGetString(text_canvas);
	OldCanvasPosition=XmTextGetInsertionPosition(text_canvas);
}
