/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
/**************************************/
/*       PROCEDURE DECLARATIONS       */
/**************************************/

void gui_refreshScr(Widget w)
{
}
	 
/* CREATE INTERFACE */
void
gui_createWidgets(display,toplevel)
Display	*display;
Widget	toplevel;
{
	Arg	args[15];
	int	n;
	static  XmTextScanType sarray[] = {XmSELECT_POSITION, XmSELECT_WORD,
					   XmSELECT_LINE, XmSELECT_PARAGRAPH,
					   XmSELECT_ALL};				
	XmString label_str;
	char *accel;

/* MAIN FORM WIDGET */
	n = 0;
	XtSetArg(args[n],XmNverticalSpacing,2); n++;
	XtSetArg(args[n],XmNhorizontalSpacing,2); n++;
	mainFO = XmCreateForm(toplevel,"mainFO",args,n);
	XtManageChild(mainFO);

/* CREATE FRAME FOR TOOL BAR */

	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNshadowThickness,3); n++;
	XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_IN); n++;
	toolbarFrame=XmCreateFrame(mainFO,"toolbarFrame",args,n);
	XtManageChild(toolbarFrame);

/* TOOL BAR WIDGET */
	n = 0;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizeHeight,True); n++;
	XtSetArg(args[n],XmNspacing,0); n++;
	XtSetArg(args[n],XmNadjustLast,True); n++;
	toolBar = XmCreateRowColumn(toolbarFrame,"toolBar",args,n);
	XtManageChild(toolBar);

/* CREATE FRAME FOR TEXT AREA */
	n=0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopWidget,toolbarFrame); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;   
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNshadowThickness,5); n++;
	XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_IN); n++;
	textFrame=XmCreateFrame(mainFO,"textFrame",args,n);
	XtManageChild(textFrame);

/*CREATE TEXT CANVAS*/
	n=0;
	XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n],XmNselectionArrayCount,5);n++;
	XtSetArg(args[n],XmNselectionArray,sarray);n++;
	text_canvas=XmCreateScrolledText(textFrame,"text_canvas",args,n);
	/*XtAddCallback(text_canvas,XmNmotionVerifyCallback,gui_cursorMotionCB,NULL); */
	XtAddCallback(text_canvas,XmNmodifyVerifyCallback,gui_keypressCB,NULL); 
	XtAddCallback(text_canvas,XmNfocusCallback,gui_enterTextCB,NULL); 
	XtAddCallback(text_canvas,XmNlosingFocusCallback,gui_leaveTextCB,NULL); 
	/*XtAddCallback(text_canvas,XmNvalueChangedCallback,keyPressedCB,NULL); */
	XtManageChild(text_canvas);
}

void
gui_createToolBar(toplevel)
Widget	toplevel;
{	
	Arg	args[15];
	int	n;
	#define CANCEL 4
	XmString label_str;
	XmString accel_text;
	char *accel;
	Widget saveSeparator,saveSeparator1,saveSeparator2,saveSeparator3;

/***********************************************************************************/
/******************************TOOL BAR ********************************************/	
/***********************************************************************************/

/* MENU BAR */
	n=0;
	menuBar=XmCreateMenuBar(toolBar,"menuBar",args,n);
	XtManageChild(menuBar);

/********************************************************************************/
/******   FILE PULLDOWN *********************************************************/
/********************************************************************************/	
/* FILE PULLDOWN */
	label_str=XmStringCreateLocalized("File");
	n=0;
	filePullDown=XmCreatePulldownMenu(menuBar,"filePullDown",args,n);
	#if MOTIF1_2
		 XtVaSetValues(filePullDown,XmNtearOffModel,XmTEAR_OFF_ENABLED,NULL);
	#endif
	XtVaCreateManagedWidget("File",xmCascadeButtonWidgetClass, menuBar,
	XmNlabelString,label_str,
	XmNmnemonic,'F',
	XmNsubMenuId, filePullDown,
	NULL);
	XmStringFree(label_str);	

/* SAVE BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+S");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>S"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	saveMenuPB = XmCreatePushButtonGadget(filePullDown,"Save",args,n);
	XtAddCallback(saveMenuPB,XmNactivateCallback,gui_saveCB,NULL);
	XtAddCallback(saveMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,SAVE); 
	XtAddCallback(saveMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,SAVE); 
	XtManageChild(saveMenuPB);
	XmStringFree(accel_text);	

/* SAVE AS BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+A");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>A"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	saveAsMenuPB = XmCreatePushButtonGadget(filePullDown,"SaveAs",args,n);
	XtAddCallback(saveAsMenuPB,XmNactivateCallback,gui_saveAsCB,NULL);
	XtAddCallback(saveAsMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,SAVEAS); 
	XtAddCallback(saveAsMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,SAVEAS); 
	XtManageChild(saveAsMenuPB);
	XmStringFree(accel_text);	

/* SAVE SELECTION BUTTON WIDGET */
	n = 0;
	saveSelectionMenuPB = XmCreatePushButtonGadget(filePullDown,"Save Selection",args,n);
	XtAddCallback(saveSelectionMenuPB,XmNactivateCallback,gui_saveSelectionCB,NULL);
	XtAddCallback(saveSelectionMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,SAVESELECTION); 
	XtAddCallback(saveSelectionMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,SAVESELECTION); 
	XtManageChild(saveSelectionMenuPB);

	n = 0;
	saveSeparator = XmCreateSeparator(filePullDown,"Separator ",args,n);
	XtManageChild(saveSeparator);

/* OPEN BUTTON WIDGET */
	n = 0; 
	accel_text=XmStringCreateLocalized("Ctrl+O");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>O"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	openMenuPB = XmCreatePushButtonGadget(filePullDown,"Open",args,n);
	XtAddCallback(openMenuPB,XmNactivateCallback,gui_openBrowseCB,NULL);
	XtAddCallback(openMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,OPEN); 
	XtAddCallback(openMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,OPEN); 
	XtManageChild(openMenuPB);
	XmStringFree(accel_text);	

/* INSERT FILE BUTTON WIDGET */
	n = 0; 
	accel_text=XmStringCreateLocalized("Ctrl+I");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>I"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	insertMenuPB = XmCreatePushButtonGadget(filePullDown,"Insert",args,n);
	XtAddCallback(insertMenuPB,XmNactivateCallback,gui_insertBrowseCB,NULL);
	XtAddCallback(insertMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,INSERT); 
	XtAddCallback(insertMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,INSERT); 
	XtManageChild(insertMenuPB);
	XmStringFree(accel_text);	

/* NEW BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+N");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>N"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	newMenuPB = XmCreatePushButtonGadget(filePullDown,"New",args,n);
	XtAddCallback(newMenuPB,XmNactivateCallback,gui_newCB,NULL);
	XtAddCallback(newMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,NEW); 
	XtAddCallback(newMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,NEW); 
	XtManageChild(newMenuPB);
	XmStringFree(accel_text);	

	n = 0;
	saveSeparator1 = XmCreateSeparator(filePullDown,"Separator ",args,n);
	XtManageChild(saveSeparator1);

/* PRINT BUTTON WIDGET */
	n = 0; 
	accel_text=XmStringCreateLocalized("Ctrl+P");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>P"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	printMenuPB = XmCreatePushButtonGadget(filePullDown,"Print",args,n);
	XtAddCallback(printMenuPB,XmNactivateCallback,gui_printCB,NULL);
	XtAddCallback(printMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,PRINT); 
	XtAddCallback(printMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,PRINT); 
	XtManageChild(printMenuPB);
	XmStringFree(accel_text);	

/* PRINT SELECTION BUTTON WIDGET */
	n = 0; 
	printSelectionMenuPB = XmCreatePushButtonGadget(filePullDown,"Print Selection",args,n);
	XtAddCallback(printSelectionMenuPB,XmNactivateCallback,gui_printSelectionCB,NULL);
	XtAddCallback(printSelectionMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,PRINTSELECTION); 
	XtAddCallback(printSelectionMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,PRINTSELECTION); 
	XtManageChild(printSelectionMenuPB);

	n = 0;
	saveSeparator2 = XmCreateSeparator(filePullDown,"Separator ",args,n);
	XtManageChild(saveSeparator2);

/* QUIT BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+Q");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>Q"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	quitMenuPB = XmCreatePushButtonGadget(filePullDown,"Quit",args,n);
	XtAddCallback(quitMenuPB,XmNactivateCallback,gui_quitCB,NULL);
	XtAddCallback(quitMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,QUIT); 
	XtAddCallback(quitMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,QUIT); 
	XtManageChild(quitMenuPB);
	XmStringFree(accel_text);	


/********************************************************************************/
/******   EDIT PULLDOWN *********************************************************/
/********************************************************************************/
/* EDIT PULLDOWN */
	n=0;
	label_str=XmStringCreateLocalized("Edit");
	editPullDown=XmCreatePulldownMenu(menuBar,"editPullDown",args,n);
	#if MOTIF1_2
		XtVaSetValues(editPullDown,XmNtearOffModel,XmTEAR_OFF_ENABLED,NULL);
	#endif
	XtVaCreateManagedWidget("Edit",xmCascadeButtonWidgetClass, menuBar,
	XmNlabelString,label_str,
	XmNmnemonic,'E',
	XmNsubMenuId, editPullDown,
	NULL);
	XmStringFree(label_str);	

/* COPY BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+C");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>C"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	copyMenuPB = XmCreatePushButtonGadget(editPullDown,"Copy",args,n);
	XtAddCallback(copyMenuPB,XmNactivateCallback,gui_copyCB,NULL); 
	XtAddCallback(copyMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,COPY); 
	XtAddCallback(copyMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,COPY); 
	XtManageChild(copyMenuPB);
	XmStringFree(accel_text);	

/* CUT BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+X");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>X"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	cutMenuPB = XmCreatePushButtonGadget(editPullDown,"Cut",args,n);
	XtAddCallback(cutMenuPB,XmNactivateCallback,gui_cutCB,NULL); 
	XtAddCallback(cutMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,CUT); 
	XtAddCallback(cutMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,CUT); 
	XtManageChild(cutMenuPB);
	XmStringFree(accel_text);	

/* PASTE BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+V");
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>V"); n++;
	pasteMenuPB = XmCreatePushButtonGadget(editPullDown,"Paste",args,n);
	XtAddCallback(pasteMenuPB,XmNactivateCallback,gui_pasteCB,NULL); 
	XtAddCallback(pasteMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,PASTE); 
	XtAddCallback(pasteMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,PASTE); 
	XtManageChild(pasteMenuPB);
	XmStringFree(accel_text);	

/* UNDO BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+U");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>U"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	undoMenuPB = XmCreatePushButtonGadget(editPullDown,"Undo",args,n);
	XtAddCallback(undoMenuPB,XmNactivateCallback,gui_undoCB,NULL); 
	XtAddCallback(undoMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,UNDO); 
	XtAddCallback(undoMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,UNDO); 
	XtManageChild(undoMenuPB);
	XmStringFree(accel_text);	

/********************************************************************************/
/******   SEARCH PULLDOWN *******************************************************/
/********************************************************************************/
/* CREATE SEARCH PULL DOWN */	
	n=0;
	label_str=XmStringCreateLocalized("Search");
	searchPullDown=XmCreatePulldownMenu(menuBar,"searchPullDown",args,n);
	#if MOTIF1_2
		XtVaSetValues(searchPullDown,XmNtearOffModel,XmTEAR_OFF_ENABLED,NULL);
	#endif
	XtVaCreateManagedWidget("Search",xmCascadeButtonWidgetClass, menuBar,
	XmNlabelString,label_str,
	XmNmnemonic,'S',
	XmNsubMenuId, searchPullDown,
	NULL);
	XmStringFree(label_str);	

/* SEARCH BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+F");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>F"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	searchMenuPB = XmCreatePushButtonGadget(searchPullDown,"Search_For",args,n);
	XtAddCallback(searchMenuPB,XmNactivateCallback,gui_searchReplaceCB,SEARCH); 
	XtAddCallback(searchMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,SEARCH); 
	XtAddCallback(searchMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,SEARCH); 
	XtManageChild(searchMenuPB); 
	XmStringFree(accel_text);	

/* REPLACE BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+R");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>R"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	replaceMenuPB = XmCreatePushButtonGadget(searchPullDown,"Replace_With",args,n);
	XtAddCallback(replaceMenuPB,XmNactivateCallback,gui_searchReplaceCB,REPLACE); 
	XtAddCallback(replaceMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,REPLACE); 
	XtAddCallback(replaceMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,REPLACE); 
	XtSetSensitive(replaceMenuPB,False);
	XtManageChild(replaceMenuPB); 
	XmStringFree(accel_text);	

/* REPLACE ALL BUTTON WIDGET */
	n = 0;
	replaceAllMenuPB = XmCreatePushButtonGadget(searchPullDown,"Replace_All",args,n);
	XtAddCallback(replaceAllMenuPB,XmNactivateCallback,gui_searchReplaceCB,REPLACEALL); 
	XtAddCallback(replaceAllMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,REPLACEALL); 
	XtAddCallback(replaceAllMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,REPLACEALL); 
	XtManageChild(replaceAllMenuPB); 

/* TOGGLE SELECTION BUTTON */
	n=0;
 	XtSetArg(args[n],XmNset,False); n++;
      	XtSetArg(args[n],XmNlabelString,XmStringCreateLtoR("Within Selection",XmSTRING_DEFAULT_CHARSET));n++;
	selectionOnlyMenuTB=XmCreateToggleButton(searchPullDown,"TB",args,n);
	XtManageChild(selectionOnlyMenuTB);
	XtAddCallback(selectionOnlyMenuTB,XmNvalueChangedCallback,searchSelectionOnlyToggleCB,NULL);

/* MATCH BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+M");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>M"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	matchMenuPB = XmCreatePushButtonGadget(searchPullDown,"Match",args,n);
	XtAddCallback(matchMenuPB,XmNactivateCallback,gui_matchCB,NULL); 
	XtAddCallback(matchMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,MATCH); 
	XtAddCallback(matchMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,MATCH); 
	XtManageChild(matchMenuPB);
	XmStringFree(accel_text);	

/********************************************************************************/
/******   OPTIONS PULLDOWN *******************************************************/
/********************************************************************************/
/* CREATE OPTION PULL DOWN */	
	n=0;
	label_str=XmStringCreateLocalized("Option");	
	optionPullDown=XmCreatePulldownMenu(menuBar,"optionPullDown",args,n);
	XtVaCreateManagedWidget("Option",xmCascadeButtonWidgetClass, menuBar,
	XmNlabelString,label_str,
	XmNmnemonic,'O',
	XmNsubMenuId, optionPullDown,
	NULL);
	XmStringFree(label_str);	

/* setUp BUTTON WIDGET */
	n = 0;
	setUpMenuPB = XmCreatePushButtonGadget(optionPullDown,"SetUp",args,n);
	XtAddCallback(setUpMenuPB,XmNactivateCallback,gui_setUpCB,NULL);
	XtAddCallback(setUpMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,SETUP); 
	XtAddCallback(setUpMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,SETUP); 
	XtManageChild(setUpMenuPB);

/********************************************************************************/
/******   HELP PULLDOWN *******************************************************/
/********************************************************************************/
/* CREATE HELP PULL DOWN */	
	n=0;
	label_str=XmStringCreateLocalized("Help");
	helpPullDown=XmCreatePulldownMenu(menuBar,"helpPullDown",args,n);
	XtVaCreateManagedWidget("Help",xmCascadeButtonWidgetClass, menuBar,
	XmNlabelString,label_str,
	XmNmnemonic,'H',
	XmNsubMenuId,helpPullDown,
	NULL);
	XmStringFree(label_str);	
	
/* HELP BUTTON WIDGET */
	n = 0;
	accel_text=XmStringCreateLocalized("Ctrl+H");
	XtSetArg(args[n],XmNaccelerator,"Ctrl<Key>H"); n++;
	XtSetArg(args[n],XmNacceleratorText,accel_text); n++;
	helpMenuPB = XmCreatePushButtonGadget(helpPullDown,"Help",args,n);
	XtAddCallback(helpMenuPB,XmNactivateCallback,gui_helpCB,HELPCALL);
	XtAddCallback(helpMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,HELPB); 
	XtAddCallback(helpMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,HELPB); 
	XtManageChild(helpMenuPB);
	XmStringFree(accel_text);	
	
	n = 0;
	helpAboutMenuPB = XmCreatePushButtonGadget(helpPullDown,"About Gloe",args,n);
	XtAddCallback(helpAboutMenuPB,XmNactivateCallback,gui_helpCB,HELPABOUT);
	XtManageChild(helpAboutMenuPB);
	
	helpBugsMenuPB = XmCreatePushButtonGadget(helpPullDown,"Bugs",args,n);
	XtAddCallback(helpBugsMenuPB,XmNactivateCallback,gui_helpCB,HELPBUGS);
	XtManageChild(helpBugsMenuPB);
	
	helpDevelMenuPB = XmCreatePushButtonGadget(helpPullDown,"Development",args,n);
	XtAddCallback(helpDevelMenuPB,XmNactivateCallback,gui_helpCB,HELPDEVEL);
	XtManageChild(helpDevelMenuPB);



/********************************************************************************/
/******************** BAR FOR TEXT WIDGETS **************************************/
/********************************************************************************/

/* CREATE FRAME FOR SECOND BAR AREA */
	n=0;
	XtSetArg(args[n],XmNshadowThickness,3); n++;
	XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_IN); n++;
	secondBarFrame=XmCreateFrame(toolBar,"secondBarFrame",args,n);
	XtManageChild(secondBarFrame);

/* BUTTON BAR WIDGET */
	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNadjustLast,True); n++;
	secondBar = XmCreateRowColumn(secondBarFrame,"secondBar",args,n);
	XtManageChild(secondBar);

/* JUMP BUTTON WIDGET */
	n = 0;
	jumpMenuPB = XmCreatePushButtonGadget(secondBar,"Jump_To ->",args,n);
	XtAddCallback(jumpMenuPB,XmNactivateCallback,gui_jumpCB,NULL); 
	XtAddCallback(jumpMenuPB,XmNarmCallback,gui_contextSensitiveHelpCB,JUMP); 
	XtAddCallback(jumpMenuPB,XmNdisarmCallback,gui_undoContextSensitiveHelpCB,JUMP); 
	XtManageChild(jumpMenuPB); 
	
/* JUMP MenuText Widget */ 
	n = 0;
	XtSetArg(args[n],XmNmaxLength,8); n++;
        XtSetArg(args[n],XmNcolumns,8); n++;
	jumpMenuText= XmCreateTextField(secondBar,"jumpMenuText",args,n);
        XtAddCallback(jumpMenuText,XmNactivateCallback,gui_jumpCB,NULL);
	XtAddCallback(jumpMenuText,XmNfocusCallback,gui_contextSensitiveHelpCB,JUMPTEXT); 
	XtAddCallback(jumpMenuText,XmNlosingFocusCallback,gui_undoContextSensitiveHelpCB,JUMPTEXT); 
        XtManageChild(jumpMenuText);

/* SEARCH LABEL WIDGET */
	n = 0;
	searchLabel = XmCreateLabelGadget(secondBar,"Search_for ->",args,n);
	XtManageChild(searchLabel);

/* SEARCH MenuText Widget */
	n=0;
	XtSetArg(args[n],XmNmaxLength,100); n++;
       	XtSetArg(args[n],XmNcolumns,17); n++;
	searchMenuText = XmCreateTextField(secondBar,"searchMenuText",args,n);
	XtAddCallback(searchMenuText,XmNactivateCallback,gui_searchReplaceCB,SEARCH);
	XtAddCallback(searchMenuText,XmNfocusCallback,gui_contextSensitiveHelpCB,SEARCHTEXT); 
	XtAddCallback(searchMenuText,XmNlosingFocusCallback,gui_undoContextSensitiveHelpCB,SEARCHTEXT); 
	XtManageChild(searchMenuText);

/* REPLACE LABEL WIDGET */
	n = 0;
	replaceLabel = XmCreateLabelGadget(secondBar,"Replace_with ->",args,n);
	XtManageChild(replaceLabel);

/* REPLACE MenuText Widget */
	n=0;
	XtSetArg(args[n],XmNmaxLength,100); n++;
       	XtSetArg(args[n],XmNcolumns,17); n++;
	replaceMenuText = XmCreateTextField(secondBar,"replaceMenuText",args,n);
	XtAddCallback(replaceMenuText,XmNfocusCallback,gui_contextSensitiveHelpCB,REPLACETEXT); 
	XtAddCallback(replaceMenuText,XmNlosingFocusCallback,gui_undoContextSensitiveHelpCB,REPLACETEXT); 
	XtManageChild(replaceMenuText);
}
