/*
 *  Color Routines.. randomizing, rotating, and init'ing colormap
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <math.h>
#include <stdio.h>
#include "trippy.h"

#ifndef sgn
#define sgn(x) ( ((x)<0)?(-1):(1))
#endif

extern Visual *vis;
XColor *color_info; /* [NCOLORS]; */
short m_color=1;

unsigned long
StrColor(char *string,unsigned long def)
{  
/* Lookup a color by its name */
  XColor screen_def_return, exact_def_return;
  if (string==(char*)0 || XAllocNamedColor(display, colmap, string,
					   &exact_def_return,
					   &screen_def_return)==False)
    return def;
  else 
    return screen_def_return.pixel;
}
     
int
randomize_color()
{
/* pick a random color from the list, set it to a random value */
  XColor color;
  int i=rndm((long)numcolors-1);
  
  if(i==0) i=1;  /* overwriting the Background color is a Bad Thing */
  
  color.pixel = color_info[i].pixel;
  colors[i][0]=color.red = rndm(65535L);
  colors[i][1]=color.green = rndm(65535L);
  colors[i][2]=color.blue = rndm(65535L);
  color.flags = DoRed|DoGreen|DoBlue;
  XStoreColor(display, colmap, &color);
  color_info[i].red = color.red;
  color_info[i].green = color.green;
  color_info[i].blue = color.blue;

  return i;
}

void
randomize_colors()
{
  int i;
  /* randomize the whole Colormap */
  if(!options.mono)
  {
    XColor *color;
    color=(XColor *)malloc(numcolors*sizeof(XColor));
    for (i=1; i<numcolors; i++) 
    {
      color[i].pixel = color_info[i].pixel; 
      colors[i][0]=color[i].red = rndm(65535L);
      colors[i][1]=color[i].green = rndm(65535L);
      colors[i][2]=color[i].blue = rndm(65535L);
      color[i].flags = DoRed|DoGreen|DoBlue;
      XStoreColor(display, colmap, &color[i]); 
      color_info[i].red = color[i].red;
      color_info[i].green = color[i].green;
      color_info[i].blue = color[i].blue;
    }
    free (color);
    /*  XStoreColors(display,colmap, &color[1], numcolors-1); */
  }
  else
  {
    XColor *color;
    color=(XColor *)malloc(numcolors*sizeof(XColor));
    for (i=1; i<numcolors; i++) 
    {
      color[i].pixel = color_info[i].pixel; 
      colors[i][0]=color[i].red = 
	colors[i][1]=color[i].green =
	  colors[i][2]=color[i].blue = rndm(65535L);
      color[i].flags = DoRed|DoGreen|DoBlue;
      XStoreColor(display, colmap, &color[i]); 
      color_info[i].red = color[i].red;
      color_info[i].green = color[i].green;
      color_info[i].blue = color[i].blue;
    }
    free (color);
    /*  XStoreColors(display,colmap, &color[1], numcolors-1); */
  }      
}

void
rotate_colors()
{ 
/*  Rotate the colormaps
 *  Palette 0 is the standard RYGCyBM
 *  Palette 1 is 3 band of Red, Green and Blue
 *  Palette 2 starts out Greyscale
 *  Palette 3 starts out... well, it's complex
 *  Palette 4 starts like palette 0, then interjects random new
 *   colors, and interpolates
 *  Palette 5 drops 3 random colors , and interpolates between 'em
 *  in rotating palettes 1 and 2, the 3 primary colors (RGB) are independent
 *  of each other...
 */

  XColor temp_color;
  register int i;
  static int plusme1=0,plusme2=0,plusme3=0;
  static int add1=1,add2=1,add3=1;
  int a,b,c;
  memcpy(&temp_color,&color_info[1],sizeof(XColor));
  if(options.palette==4)
  {
    static int smoothing=0;
    static int ind;
    static int steps,nSteps;
    static float forR, forG, forB;
    static float bacR, bacG, bacB;
      
    if(!smoothing)
    {
      int iF,iB;

      ind=randomize_color();  /* change one */
      steps = rndm(50l)+1;
      iF = (ind+steps)%numcolors;
      iB = (ind-steps)%numcolors;
      if(iB<=0)
	iB = numcolors-1+iB;
/*
      fprintf(stdout,"\t ind= %d iF = %d iB = %d steps=%d\n",ind,iF,iB,steps);
      fprintf(stdout,"\tcolors[ind]= (%u,%u,%u)\n",
	      colors[ind][0],colors[ind][1],colors[ind][2]);
      fprintf(stdout,"\tcolors[iF]= (%u,%u,%u) colors[iB]= (%u,%u,%u)\n",
	      colors[iF][0],colors[iF][1],colors[iF][2],
	      colors[iB][0],colors[iB][1],colors[iB][2]);
 */	  
/* wow, this looks gross! but the version of GCC I was working with couldn't
 *  deal with everything on the same line, so....
 */
      forR = (float)(colors[iF][0]);
      forR -= colors[ind][0];
      forR /= (float)steps;
      forG = (float)(colors[iF][1]);
      forG -= colors[ind][1];
      forG /= (float)steps;
      forB = (float)(colors[iF][2]);
      forB -= colors[ind][2];
      forB /= (float)steps;
      bacR = (float)(colors[iB][0]);
      bacR -=colors[ind][0];
      bacR /= (float)steps;
      bacG = (float)(colors[iB][1]);
      bacG -= colors[ind][1];
      bacG /= (float)steps;
      bacB = (float)(colors[iB][2]);
      bacB-=colors[ind][2];
      bacB /= (float)steps;
/*
      fprintf(stdout,"\tfor = (%6.2f,%6.2f,%6.2f)\n bac = (%6.2f,%6.2f,%6.2f)\n",
	      forR,forG,forB,bacR,bacG,bacB);
 */     
      nSteps=1;
      smoothing=1;
    }
    else
    {
      if(nSteps==steps)
	smoothing=0;
      else
      {
	int iF = (ind+nSteps)%numcolors;
	int iB = (ind-nSteps)%numcolors;
	if(iF==0) iF=1;
	if(iB<=0)
	  iB = numcolors-1+iB;
	      
	colors[iF][0]= colors[ind][0] +(forR*nSteps);
	colors[iF][1]= colors[ind][1] +(forG*nSteps);
	colors[iF][2]= colors[ind][2] +(forB*nSteps);
	colors[iB][0]= colors[ind][0] +(bacR*nSteps);
	colors[iB][1]= colors[ind][1] +(bacG*nSteps);
	colors[iB][2]= colors[ind][2] +(bacB*nSteps);

	color_info[iF].red   = colors[iF][0];
	color_info[iF].green = colors[iF][1];
	color_info[iF].blue  = colors[iF][2];
	color_info[iF].flags = DoRed|DoGreen|DoBlue;
/*
	fprintf(stdout, "Colors[%d] = (%u,%u,%u)... \n",
		iF,colors[iF][0],colors[iF][1],colors[iF][2]);
*/			
	XStoreColor(display,colmap,&color_info[iF]);

	color_info[iB].red   = colors[iB][0];
	color_info[iB].green = colors[iB][1];
	color_info[iB].blue  = colors[iB][2];
	color_info[iB].flags = DoRed|DoGreen|DoBlue;
/*
	fprintf(stdout, "Colors[%d] = (%u,%u,%u)...\n", iB,
		colors[iB][0],colors[iB][1],colors[iB][2]);
*/ 
	XStoreColor(display,colmap,&color_info[iB]);

	nSteps++;
      }
    }
    return;
  }
  else /* every palette except #4 */
  {
    for (i=1; i<numcolors; i++)
    {
      if(options.palette!=0 &&options.palette!=5)
      {
	a= (i+plusme1)%numcolors;
	b= (i+plusme2)%numcolors;
	c= (i+plusme3)%numcolors;
	if(a<0) a=numcolors+a;
	if(b<0) b=numcolors+b;
	if(c<0) c=numcolors+c;
	color_info[i].red=colors[a][0];
	color_info[i].green=colors[b][1];
	color_info[i].blue=colors[c][2];
      }
      else
	color_info[i].pixel = color_info[i+1].pixel;
      color_info[i].flags = DoRed|DoGreen|DoBlue;
/*      XStoreColor(display,colmap,&color_info[i]); */
    }
    if(options.palette==0 ||options.palette==5)
    {
      memcpy(&color_info[numcolors-1],&temp_color,sizeof(XColor));
/*      color_info[numcolors-1].pixel = temp_color.pixel;
 *     color_info[numcolors-1].flags = DoRed|DoGreen|DoBlue; 
 */
    }
    else
    {
      if(!rndm(5000l))
	add1*= -1;
      plusme1+=add1;
      if(!rndm(5000l))
	add2*= -1;
      plusme2+=add2;
      if(!rndm(5000l))
	add3*= -1;
      plusme3+=add3;
    }
    XStoreColors(display,colmap,&color_info[1],numcolors-1); 
  }
}

/*
void
EndofTunnel()
{
  XColor temp_color;
  int i,j;
  
  for(j=1; j<numcolors-1; j++)
  {
    for (i=2; i<numcolors-1; i++)
    {
	  color_info[i].pixel = color_info[i+1].pixel;
	  color_info[i].flags = DoRed|DoGreen|DoBlue;
	  XStoreColor(display,colmap,&color_info[i]);
	}
      color_info[1].pixel=color_info[i+1].pixel;
      color_info[1].flags=0;
      XStoreColor(display,colmap,&color_info[1]); 
      color_info[numcolors-1].pixel = temp_color.pixel;
      color_info[numcolors-1].flags = DoRed|DoGreen|DoBlue;
      XStoreColor(display,colmap,&color_info[numcolors-1]);
    }
}
*/
/*
int
myfunc (int in, int max)
{
  int tmp;

  tmp = (sin (in * M_PI / (max*3/4) ) * max);
  fprintf(stderr, "tmp=%d\n",tmp);

  if (tmp<0)
    return 0;
  else
    return tmp;
}
*/

void
get_them_colors()
{
/* Allocate the Colormap and Initialize them */
  unsigned long *pixels; /*[NCOLORS];  */
  unsigned long *plane_masks;
  int i;
  int mask_for;
  XGCValues values;  
  if ((HC =(int *)calloc(options.tryfor,sizeof(int))) == NULL) return ;
  pixels=(unsigned long *)malloc(sizeof(unsigned long)*options.tryfor);
/*
  if(options.perfect)
  mask_for=1;
  else
  */
  mask_for=0;

  if (!vis->class)
  {
    color_info=(XColor *)malloc(sizeof(XColor)*2);
    numcolors=2;
    color_info[0].pixel = WhitePixel(display,screen);
    color_info[1].pixel = BlackPixel(display,screen);
    for(i=0;i<numcolors;i++)
    {
      int win;
      values.foreground = color_info[i].pixel;
      values.background = options.bgcolor;
/*	  for(win=0;win<options.windows;win++) */
      color_gcs[i]=XCreateGC(display,window[0],
			     GCForeground|GCBackground,&values);
    }
  }
  else if (options.dynamic_colors) 
  {
    for (numcolors=options.tryfor; numcolors>=2; numcolors-=6) 
    {
      if (XAllocColorCells(display,colmap, True , plane_masks,
			   mask_for, pixels,
			   (unsigned int)numcolors) != 0) 
      {
	color_info=(XColor *)malloc(sizeof(XColor)*(numcolors+1));
	for (i=0;i<numcolors;i++)
	  color_info[i].pixel=pixels[i];
	randomize_colors();
	break;
      }
    }
      
    fprintf(stderr,"Alloc'ing %d colors \n",numcolors);
    if (numcolors < 2) 
      fatalerror("Cannot allocate R/W color cells","");

    color_info[0].pixel=options.bgcolor;
    for(i=0;i<numcolors;i++)
    {
      int win=0;
      values.foreground = color_info[i].pixel;
      values.background = options.bgcolor;
      for(win=0;win<options.windows;win++)
	color_gcs[i] = XCreateGC(display,window[win],
				 GCForeground|GCBackground,&values);
    }
  }
  else if(!options.mono)
  {
    XColor screen_in_out;
    int poisson=options.tryfor;
    int done=0;
    screen_in_out.flags=DoRed|DoGreen|DoBlue;
      
    while(!done)
    {
      if (XAllocColorCells(display, colmap, True, plane_masks,
			   mask_for, pixels, poisson) != 0) 
      {

/* this is Prof's Color setting code.. Good, but it skips Yellow and Cyan */
/* 		  color_info=(XColor *)malloc(sizeof(XColor)*poisson); */
/*  		  for(i=0;i<=poisson;i++)                              */
/* 		    {                                                  */
/* 		      int num;                                         */
/* 		      num = myfunc (i, poisson);                       */
/* 		      colors[i][0] = (256 * num / poisson) << 8;       */
/* 		      if (m_color)                                     */
/* 			{                                              */
/* 			  num = i + poisson/3;                         */
/* 			  if (num>poisson)                             */
/* 			    num -= poisson;                            */
/* 			  num = myfunc(num, poisson);                  */
/* 			}                                              */
/* 		      colors[i][1] = (256 * num / poisson) << 8;       */
/* 		      if (m_color)                                     */
/* 			{                                              */
/* 			  num = i + 2*poisson/3;                       */
/* 			  if (num>poisson)                             */
/* 			    num -= poisson;                            */
/* 			  num = myfunc(num,poisson);                   */
/* 			}                                              */
/* 		      colors[i][2] = (256 * num / poisson) << 8;       */
		  
	float fact = (float)65535/(poisson/6); 
	color_info=(XColor *)malloc(sizeof(XColor)*(poisson+1));
	switch (options.palette)
	{
	  case 3:
	    {
	      int stepX,stepY;
	      int sqrtColors,sqrColors,done,x,y;
	      /*	fprintf(stderr,"poisson=%d\n",poisson);
			sqrtColors=sqrt(sqrt(poisson)); /* squareroot */
	      sqrColors= sqrt(poisson); /*(sqrtColors*sqrtColors);*/
	      done=0;
	      x=sqrColors;
	      y=(sqrColors-1)*sqrColors;
			
	      do
	      {
		colors[x][0]=rndm(65535);
		colors[x][1]=rndm(65535);
		colors[x][2]=rndm(65535);
			    
		colors[y][0]=rndm(65535);
		colors[y][1]=rndm(65535);
		colors[y][2]=rndm(65535);
			    
		/* make sure at least one of the colors is fairly strong */
		if(( (colors[x][0]<32767) &&
		     (colors[x][1]<32767) &&
		     (colors[x][2]<32767) ) ||
		   ( (colors[y][0]<32767) &&
		     (colors[y][1]<32767) &&
		     (colors[y][2]<32767) ) ||
		   ( colors[x][0]+colors[y][0]>65535) ||
		   ( colors[x][1]+colors[y][1]>65535) ||
		   (colors[x][2]+colors[y][2]>65535) )
		  done=0;
		else done=1;
	      } while (!done);
			
	      colors[0][0]=
		colors[0][1]=
		colors[0][2]=0;
			
	      for(stepX=1;stepX<x;stepX++)
	      {
		colors[stepX][0]=
		  colors[x][0]*((float)stepX/x);
		colors[stepX][1]=
		  colors[x][1]*((float)stepX/x);
		colors[stepX][2]=
		  colors[x][2]*((float)stepX/x);

	      }
			
	      for(stepY=1;stepY<x;stepY++)
	      {
		colors[stepY*x][0]=
		  colors[y][0]*((float)stepY/x);
		colors[stepY*x][1]=
		  colors[y][1]*((float)stepY/x);
		colors[stepY*x][2]=
		  colors[y][2]*((float)stepY/x);
	      }
			    
	      for(stepX=1;stepX<x;stepX++)
		for(stepY=1;stepY<x;stepY++)
		{
		  colors[stepX+(stepY*x)][0]= 
		    colors[stepX][0] + colors[stepY*x][0];
		  colors[stepX+(stepY*x)][1]= 
		    colors[stepX][1] + colors[stepY*x][1];
		  colors[stepX+(stepY*x)][2]= 
		    colors[stepX][2] + colors[stepY*x][2];
		}

	      poisson=sqrColors*sqrColors;
	      break;
	    }
	  case 5:
	    {
	      float dR1,dR2,dR3;
	      float dG1,dG2,dG3;
	      float dB1,dB2,dB3;
	      const int x1 = poisson/3;
	      const int x2 = 2*poisson/3;
	      colors[1][0] = rndm(65535l);
	      colors[1][1] = rndm(65535l);
	      colors[1][2] = rndm(65535l);
	      colors[x1][0] = rndm(65535l);
	      colors[x1][1] = rndm(65535l);
	      colors[x1][2] = rndm(65535l);
	      colors[x2][0] = rndm(65535l);
	      colors[x2][1] = rndm(65535l);
	      colors[x2][2] = rndm(65535l);
/*
  fprintf(stderr, "colors[1] = (%d,%d,%d)\n",
  colors[1][0],colors[1][1],colors[1][2]);
  fprintf(stderr, "colors[%d] = (%d,%d,%d)\n",x1,
  colors[x1][0],colors[x1][1],colors[x1][2]);
  fprintf(stderr, "colors[%d] = (%d,%d,%d)\n",x2,
  colors[x2][0],colors[x2][1],colors[x2][2]);
  */			  
	      dR1 = (float)colors[x1][0] - (float)colors[1][0];
	      dR1 /= (float)x1;			  
	      dG1 = (float)colors[x1][1] - (float)colors[1][1];
	      dG1 /= (float)x1;
	      dB1 = (float)colors[x1][2] - (float)colors[1][2];
	      dB1 /= (float)x1;
	      dR2 = (float)colors[x2][0] -(float) colors[x1][0];
	      dR2 /= (float)x1;
	      dG2 = (float)colors[x2][1] - (float)colors[x1][1];
	      dG2 /= (float)x1;			  
	      dB2 = (float)colors[x2][2] - (float)colors[x1][2];
	      dB2 /= (float)x1;			  
	      dR3 = (float)colors[1][0] - (float)colors[x2][0];
	      dR3 /= (float)x1;			  
	      dG3 = (float)colors[1][1] - (float)colors[x2][1];
	      dG3 /= (float)x1;			  
	      dB3 = (float)colors[1][2] - (float)colors[x2][2];
	      dB3 /= (float)x1;
/*
  fprintf(stderr,"d1 = (%f,%f,%f)\n",dR1,dG1,dB1);
  fprintf(stderr,"d2 = (%f,%f,%f)\n",dR2,dG2,dB2);
  fprintf(stderr,"d3 = (%f,%f,%f)\n",dR3,dG3,dB3);
  */		  
	      for(numcolors=1;numcolors<=x1;numcolors++)
	      {
		colors[1+numcolors][0]= colors[1][0]+(dR1*numcolors);
		colors[1+numcolors][1]= colors[1][1]+(dG1*numcolors);
		colors[1+numcolors][2]= colors[1][2]+(dB1*numcolors);
/*			    fprintf(stderr,"(%d,%d,%d)\t",colors[1+numcolors][0],colors[1+numcolors][1],colors[1+numcolors][2]); */
			    
		colors[x1+numcolors][0]= colors[x1][0]+(dR2*numcolors);
		colors[x1+numcolors][1]= colors[x1][1]+(dG2*numcolors);
		colors[x1+numcolors][2]= colors[x1][2]+(dB2*numcolors);
/*			    fprintf(stderr,"(%d,%d,%d)\t",colors[x1+numcolors][0],colors[x1+numcolors][1],colors[x1+numcolors][2]); */
		colors[x2+numcolors][0]= colors[x2][0]+(dR3*numcolors);
		colors[x2+numcolors][1]= colors[x2][1]+(dG3*numcolors);
		colors[x2+numcolors][2]= colors[x2][2]+(dB3*numcolors);
/*			    fprintf(stderr,"(%d,%d,%d)\n",colors[x2+numcolors][0],colors[x2+numcolors][1],colors[x2+numcolors][2]); */
	      }
	      break;
	    }
	  case 2:
	  case 4:
	    {
	      for(;numcolors<=poisson>>1;numcolors++)
	      {
		colors[numcolors][0]=
		  colors[poisson-numcolors][0]=
		  colors[numcolors][1]=
		  colors[poisson-numcolors][1]=
		  colors[numcolors][2]=
		  colors[poisson-numcolors][2]=
		  (unsigned long)numcolors*2*(float)(65535/poisson);
	      }
	      break;
	    }
	  case 1:
	    {
	      for(numcolors=0;numcolors<=(poisson/6);numcolors++) 
	      { 
		colors[numcolors][0]= 
		  colors[numcolors+(poisson*2/6)][1]= 
		  colors[numcolors+(poisson*4/6)][2]= 
		  (unsigned long)(fact*numcolors); 
		colors[numcolors+(poisson/6)][0]= 
		  colors[numcolors+(poisson*3/6)][1]= 
		  colors[numcolors+(poisson*5/6)][2]= 
		  (unsigned long)(65535-(fact*numcolors)); 
		/* and then we zero out anything else */
		colors[numcolors][2]= 
		  colors[numcolors+(poisson/6)][2]= 
		  colors[numcolors+(poisson*2/6)][0]= 
		  colors[numcolors+(poisson*3/6)][0]=
		  colors[numcolors+(poisson*4/6)][1]= 
		  colors[numcolors+(poisson*5/6)][1]=
		  (unsigned long)0; 
	      }			  
	      break;
	    }
	  case 0:
	  default:
	    {
	      for(numcolors=0;numcolors<=(poisson/6);numcolors++) 
	      { 
		colors[numcolors][1]= 
		  colors[numcolors+(poisson*2/6)][2]= 
		  colors[numcolors+(poisson*4/6)][0]= 
		  (unsigned long)(fact*numcolors); 
		colors[numcolors+(poisson/6)][0]= 
		  colors[numcolors+(poisson*3/6)][1]= 
		  colors[numcolors+(poisson*5/6)][2]= 
		  (unsigned long)(65535-(fact*numcolors)); 
		colors[numcolors][0]= 
		  colors[numcolors+(poisson/6)][1]= 
		  colors[numcolors+(poisson*2/6)][1]= 
		  colors[numcolors+(poisson*3/6)][2]= 
		  colors[numcolors+(poisson*4/6)][2]= 
		  colors[numcolors+(poisson*5/6)][0]=
		  (unsigned long)65535; 
		/* and then we zero out anything else */
		colors[numcolors][2]= 
		  colors[numcolors+(poisson/6)][2]= 
		  colors[numcolors+(poisson*2/6)][0]= 
		  colors[numcolors+(poisson*3/6)][0]=
		  colors[numcolors+(poisson*4/6)][1]= 
		  colors[numcolors+(poisson*5/6)][1]=
		  (unsigned long)0; 
	      }
	      break;
	    }
	}
	done=1;
      }
      else
	poisson-=6;
    }
      
    fprintf(stderr,"Alloc'ing %d colors \n",poisson);

    for(numcolors=0;numcolors<poisson;numcolors++)
    {
      int win;
      screen_in_out.red   = colors[numcolors][0];
      screen_in_out.green = colors[numcolors][1];
      screen_in_out.blue  = colors[numcolors][2];
      screen_in_out.pixel = pixels[numcolors];

      if (XStoreColor(display, colmap, &screen_in_out)==False) 
      {
	/* oh well... guess this doesn't mean anything now */
	/*	  fatalerror("Cannot allocate colors",""); */
      }
/*
  fprintf(stderr, "Got to #%d in here:",numcolors);
  fprintf(stderr, "red:%ld\tgreen:%ld\tblue:%ld\n",
  colors[numcolors][0],colors[numcolors][1],
  colors[numcolors][2]);
  fflush(stderr);
  */
      color_info[numcolors].pixel = screen_in_out.pixel;
      color_info[numcolors].red = screen_in_out.red;
      color_info[numcolors].green = screen_in_out.green;
      color_info[numcolors].blue = screen_in_out.blue;
      color_info[0].pixel=options.bgcolor;
      values.foreground = color_info[numcolors].pixel;
      values.background = options.bgcolor;
      for(win=0;win<options.windows;win++)
	color_gcs[numcolors] = XCreateGC(display,window[win],
					 GCForeground|GCBackground,
					 &values);
    }
  }
  else                                           /*greyscale */
  { 
    XColor screen_in_out;
    int poisson=options.tryfor;
    int done=0;
    screen_in_out.flags=DoRed|DoGreen|DoBlue;

    while(!done)
    {
      if (XAllocColorCells(display,colmap, True, plane_masks, mask_for,
			   pixels, poisson) != 0) 
      {
	color_info=(XColor *)malloc(sizeof(XColor)*poisson);
	for (numcolors=0; numcolors<poisson; numcolors++) 
	{
	  int win;
	  colors[numcolors][0]=
	    colors[numcolors][1]=
	    colors[numcolors][2]=
	    (unsigned long)(numcolors*(float)(65535/poisson));
		
	  screen_in_out.flags = DoRed | DoGreen | DoBlue;
	  screen_in_out.red = colors[numcolors][0];
	  screen_in_out.green = colors[numcolors][1];
	  screen_in_out.blue = colors[numcolors][2];
	  screen_in_out.pixel = pixels[numcolors];	  
	  if (XStoreColor(display, colmap,&screen_in_out)==False) 
	  {
/*
  if (numcolors < 2) 
  fatalerror("Cannot allocate colors","");
  break;
  */
	  }
	  color_info[numcolors].pixel = screen_in_out.pixel;
	  color_info[numcolors].red = screen_in_out.red;
	  color_info[numcolors].green = screen_in_out.green;
	  color_info[numcolors].blue = screen_in_out.blue;
	  values.foreground = color_info[numcolors].pixel;
	  values.background = options.bgcolor;
	  for(win=0;win<options.windows;win++)
	    color_gcs[numcolors] = XCreateGC(display,window[win],
					     GCForeground|GCBackground,
					     &values);
	}
	done=1;
      }
      else
	poisson-=6;
    }
    fprintf(stderr,"Alloc'ing %d colors \n",poisson);
  }
  free (pixels);
}

