#include <stdio.h>
#include <math.h>
#include <X11/X.h>
#include <X11/Xlib.h>
/* #include "trippy.h" */

#define NUM_PTS 21

static const long   iBernTbl[] = {65536,0,0,0,
				  56188,8871,466,8,
				  47775,15925,1769,65,
				  40247,21307,3760,221,
				  33554,25165,6291,524,
				  27648,27648,9216,1024,
				  22478,28901,12386,1769,
				  17997,29073,15654,2809,
				  14155,28311,18874,4194,
				  10903,26763,21897,5971,
				  8192,24576,24576,8192,
				  5971,21897,26763,10903,
				  4194,18874,28311,14155,
				  2809,15654,29073,17997,
				  1769,12386,28901,22478,
				  1024,9216,27648,27648,
				  524,6291,25165,33554,
				  221,3760,21307,40247,
				  65,1769,15925,47775,
				  8,466,8871,56188,
				  0,0,0,65536};
/*
static const double bernTbl[] = {1.000000,0.000000,0.000000,0.000000,
				 0.857375,0.135375,0.007125,0.000125,
				 0.729000,0.243000,0.027000,0.001000,
				 0.614125,0.325125,0.057375,0.003375,
				 0.512000,0.384000,0.096000,0.008000,
				 0.421875,0.421875,0.140625,0.015625,
				 0.343000,0.441000,0.189000,0.027000,
				 0.274625,0.443625,0.238875,0.042875,
				 0.216000,0.432000,0.288000,0.064000,
				 0.166375,0.408375,0.334125,0.091125,
				 0.125000,0.375000,0.375000,0.125000,
				 0.091125,0.334125,0.408375,0.166375,
				 0.064000,0.288000,0.432000,0.216000,
				 0.042875,0.238875,0.443625,0.274625,
				 0.027000,0.189000,0.441000,0.343000,
				 0.015625,0.140625,0.421875,0.421875,
				 0.008000,0.096000,0.384000,0.512000,
				 0.003375,0.057375,0.325125,0.614125,
				 0.001000,0.027000,0.243000,0.729000,
				 0.000125,0.007125,0.135375,0.857375,
				 0.000000,0.000000,0.000000,1.000000};

static double bern(int k,int i)
{
  return bernTbl[i*4+k];
}
*/

static long bern(int k,int i)
{
  return iBernTbl[i*4+k];
}

XPoint*
Bezier(XPoint* points,int npoints)
{
  int i,k;
 
  const int L = 3;

  static XPoint listP[NUM_PTS];
  memset(listP,0,NUM_PTS*sizeof(XPoint));
  
  for(i=0;i<NUM_PTS;i++)
  {
/* fill listP with p(i/NUM_PTS-1) */
/*    float t =(float)i/NUM_PTS; */
    long x=0,y=0;
    for(k=0;k<=L;k++)
    {
      long B = bern(k,i);
      x+=(points[k].x*B);
      y+=(points[k].y*B);

/*       double B = bern(k,i); */
/*       listP[i].x+=(points[k].x * B); */
/*       listP[i].y+=(points[k].y * B); */
    }
    listP[i].x = x>>16;
    listP[i].y = y>>16;
  }
  /* PolyLine(21,(point *)listP); */
  return listP;
}

/* double */
/* bern(int k,float t) */
/* { */
/*   double pow1,pow2; */
/* //  pow1 = pow((1-t),3-k); */
/* //  pow2 = ((k==0)?1:pow(t,k)); */
/* //  fprintf(stdout,"Pow1 = %lf, Pow2 = %lf \n",pow1,pow2); */
/*   if( (k==0) || (k==3)) */
/*     return pow((1-t),3-k)*((k==0)?1:pow(t,k)); */
/*   else */
/*     return 3.0*pow((1-t),3-k)*((k==0)?1:pow(t,k)); */
/* } */

#ifdef TEST

void
main()
{
  int i;
  XPoint naffgit[4] = { {50,50},{50,100},{100,100},{100,50}};
  XPoint *foobar= Bezier(naffgit,4);

  for (i=0;i<=20;i++)
  {
    printf("Foobar[%d] = (%d,%d)\n",i,foobar[i].x,foobar[i].y);
  } 
}
#endif

