/* ds3 */

/* Derived from:
  s3/s3.c
   Routine to set the third clock on a Steath VRAM board. I don't know if
this will work on any other hardware and it may cause damage to either the
card or monitor. I have only used it <s3 4 8 0> with my Stealth VRAM and
a DELL UltraScan monitor. This needs to be compiled with the -O6 option.
This program seems to leave the text mode in a flaky way. But it does work
with X? The actual routine to set the clock was posted by Batman ?? several
weeks ago while most of the other code is based on examples from S3*/

#include <linux/unistd.h>
#include <asm/io.h>
#include <stdio.h>

static _syscall1(int,iopl,int,level)

extern inline void outw(unsigned short value, unsigned short port)
{
__asm__ __volatile__ ("outw %%ax,%%dx"
		::"a" ((unsigned short) value),"d" ((unsigned short) port));
}

int INTRLCE; /*INTRLCE flag see OC()*/

void set_clock();

extern void scr_off(),scr_on(),wait_for_vsync();

/*These magic numbers are from the Batman post*/
long Reset=0x000000a3;
long Horiz=0x000c2dd6;
/*
long H_CLOCKS[]={0x0000a3,0x89189e,0xcc0596,0x0c2dd6,0xb824f6,0x1411f6};
*/

#define INTERLACE_CONST	0x00010000
#define N_V_CLOCKS	11
#define MIN_TARGET	10
#define MAX_TARGET	100
#define DEFAULT_TARGET	25
long V_CLOCKS[]={
			0xbc2ac2,	/* v03 39.7 */
			0x5410c2,	/* v08 44.6 */
			0xbc35a2,	/* v05 49.6 */
			0x3c15a2,	/* v11 49.9 */
			0x340692,	/* new 56.2 */
			0xac1bd2,	/* v13 62.6 */
			0xc422b2,	/* v06 64.4 */
			0x842af2,	/* new 71.4 */
			0x3427f2,	/* v14 71.8 */
			0x0c3ff2,	/* v09 73.9 */
			0xd437f2,	/* v10 79.6 */
		};

float V_FREQS[]={
			39.7,
			44.6,
			49.6,
			49.9,
			56.2,
			62.6,
			64.4,
			71.4,
			71.8,
			73.9,
			79.6
		};

main(argc,argv)
int argc;
char *argv[];
{
float current, target, error, besterror;
char errorsign;
int j, best, interlace, useinterlace, doit=1;
unsigned short tmp;
long v_clock;

  j=1;
  if (!strcmp(argv[j],"-n"))
  { /* just check the frequency against clocks; don't set anything */
    doit=0;
    ++j;
  }

  if (!strcmp(argv[j],"-a"))
  { /* Just print out all of the available clocks */
    printf(" Constant\t\tInterlaced\t\tNoninterlaced\n");
    printf(" --------\t\t----------\t\t-------------\n");
    for (j=0; j<N_V_CLOCKS; ++j)
      printf("0x00%06x\t\t %.1f MHz\t\t  %.1f MHz\n",
	V_CLOCKS[j], V_FREQS[j]/2, V_FREQS[j]);
    exit(0);
  }

  if (argc < j+1)
    target=(float)DEFAULT_TARGET;
  else  
  { if (1 != sscanf(argv[j], "%f", (float *)&target))
    { fprintf(stderr, "Parameter %s should be a target frequency.\n", argv[j]);
      exit(3);
    }

    if (target < (float)MIN_TARGET || target > (float)MAX_TARGET)
    { fprintf(stderr,
		"Invalid target frequency %.1f (use %.1f to %.1f (MHz))!\n",
		target, (float)MIN_TARGET, (float)MAX_TARGET);
      exit(4);
    }
    ++j;

    if (argc > j)
    { /* STILL parameters left!  Take a look. */
      if (1 == sscanf(argv[j], "%d", &tmp))
      { /* XFree86 tells us which clock to set (we can only do #2) */
        if (tmp != 2)
	  exit(0);
	/* If not the 2nd clock, just hope clock 0 or 1 is the right freq */
      }
      else
      { fprintf(stderr, "Usage: %s [ -a | [ -n ] [frequency in MHz] ]\n",
		argv[0]);
        for (j=1; j< argc; ++j)
          fprintf(stderr,"Arg %d was %s.\n",j,argv[j]);
        exit(2);
      }
    }
  }

  if (doit)
  { iopl(3);		/*give us the power to in/out to all ports. This
			  probably should be changed to only allow access to
			  the needed ports now that the code doesn't use the
			  S3 magic ports*/
			  
    unlk();			/*unlock the magic S3 registers !*/
    scr_off();		/*shutdown the screen*/
    outw(0,0x3c4);		/*turn off sequencer*/
    tmp=inb(0x3cc);		/*save ??*/
    tmp=tmp | 0x0c;		/*turn off ??*/
    outb(tmp,0x3c2);	/*do it*/
  }

  for (j=0,best=0,besterror=1; j < N_V_CLOCKS; ++j)
  { for (interlace=0; interlace <= 1; ++interlace)
    { current=V_FREQS[j]/(interlace+1);
      if (current > target)
        error=(current/target-1);
      else
        error=(target/current-1);
      if (error < besterror)
      { best=j;
        useinterlace=interlace;
	besterror=error;
      }
    }
  }

  current=V_FREQS[best]/(useinterlace+1);
  if (current>target)
    errorsign='+';
  else
    errorsign='-';

  printf("Desired frequency was %3.1f; using %3.1f; error is %c%.1f%%.\n",
	target, current, errorsign, besterror*100);

  if (useinterlace)
    v_clock=(V_CLOCKS[best] | (long)INTERLACE_CONST);
  else
    v_clock=V_CLOCKS[best];

  if (!doit)
    printf("V_CLOCK constant is 0x%6x (%sinterlaced).\n",
		v_clock, useinterlace?"":"non-");
  else
  { set_clock(v_clock);

/*INTRLCE=atoi(argv[3]);*/
    INTRLCE=0;
    wait_for_vsync();
    set_clock(Horiz);
    wait_for_vsync();
    tmp=inb(0x3cc);
    tmp=tmp & 0xf7;		/*enable ??*/
    outb(tmp,0x03c2);		/*do it*/
    wait_for_vsync();
    outw(0x300,0x3c4);		/*enable sequencer*/
    scr_on();			/*turn the screen back on*/
    lk();			/*lock the registers back up*/
    iopl(0);			/*remove all i/o permissions*/
  }
  exit(0);
}

inline unsigned short OC(x)
unsigned short x;
{
unsigned short ret;
ret=0x42 | ((x & 3) << 8);
if (INTRLCE) ret|=0x2000;
return(ret);
}

unlk()	/*unlock the S3 extended registers*/
{
outw(0x4838,0x3d4);
outw(0xa039,0x3d4);
outw(0x0e11,0x3d4);
}

lk()	/*lock the S3 extended registers*/
{
outw(0x38,0x3d4);
outw(0x39,0x3d4);
outw(0x8e11,0x3d4);
}

/* This is the code that was posted to comp.os.linux by Batman several
weeks ago. */
void set_clock(l)
long l;
{
long bit;
int i;
unsigned char c,idx;
c=inb(0x3cc);
idx=inb(0x3d4);
outw(OC(3),0x3cc);
outb(c,0x3c2);
for(i=1;i<=6;i++) {
	outw(OC(2),0x3d4);
	outw(OC(3),0x3d4);
}
outw(OC(2),0x3d4);
outw(OC(0),0x3d4);
outw(OC(1),0x3d4);
outw(OC(0),0x3d4);
outw(OC(1),0x3d4);
for(bit=1<<23;bit;bit>>=1)
	if (l & bit) {
		outw(OC(1),0x3d4);
		outw(OC(0),0x3d4);
		outw(OC(2),0x3d4);
		outw(OC(3),0x3d4);
	}
	else {
		outw(OC(3),0x3d4);
		outw(OC(2),0x3d4);
		outw(OC(0),0x3d4);
		outw(OC(1),0x3d4);
	}
outw(OC(3),0x3d4);
outw(OC(2),0x3d4);
outw(OC(3),0x3d4);
outb(idx,0x3d4);
}
