NONSEPAR [^ \t\n\{\}]
WHITE    [ \t\n]
ALPHA	 [A-Za-z]
ALPHANUM [A-Za-z0-9_-]
TAG	{ALPHA}{ALPHANUM}*=
TAGBRACE {ALPHA}{ALPHANUM}*=\{
SQ	\'([^']*\'\')*[^']*[']
DQ	\"([^"]*\"\")*[^"]*["]
BQ	\`([^`]*\`\`)*[^`]*[`]
LEFT    \{
RIGHT   \}


%{

/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/xtpanel-scan.l
 *
 * Steve Cole, Dave Nichols (SEP), August 31 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole, Dave Nichols (SEP), November 20 1992 -  version 2.00
 * 1) added new objects: toggle, scrollbar, graph.
 * 2) added new actions: ASSIGN, SET.
 * 3) objects can have multiple actions.
 * 4) backquoted strings in actions get executed at action time.
 * Steve Losen (scl@virginia.edu) 3 Mar 1993
 * introduced `` as an escaped backquote.
 */

/* lexical scanning for xtpanel */

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#if defined _POSIX_SOURCE
#include <unistd.h>
#endif

#include "tree.h"
#include "eval_command.h"

#ifndef MIN
#define MIN(A,B) (A<B?A:B)
#endif

#define MAX_NEST 20
static int stack_ptr = -1;
static char *input_buf;
static char *input_buf_start;
static char *input_buf_end;

static entry *entry_stack[MAX_NEST];

#undef input
#define input() ((int) *(input_buf++))
#undef unput
/* The redundant  =(c) insures side effects of expressions occur */
#define unput(c) (*(--(input_buf))=(c))

/* define the look ahead buffer size to something big
 * This is needed in case they have a very big text 
 * string in quotes.
 */
#undef YYLMAX
#define YYLMAX 50000

#define yywrap() xtpanel_wrap()
#define yylex()  xtpanel_lexscan()
#define yylook() xtpanel_yylook()

entry *tree_ent;
entry *treetop;
int len;
int left=0;

static void syntax_err();
static int massage();

/* workhorse to decode xtpanel files; */

entry* xtpanel_scan( buffer, root )
char* buffer;
entry* root;
{
 extern int yylex();

 /* note the input buffer should be null terminated */
 input_buf = buffer;
 input_buf_start = input_buf;
 input_buf_end = input_buf + strlen(input_buf) - 1;

 /* all the info we find will be stored under the root entry */
 push_entry( root );

 yylex();
 if( left > 0 ) {
    fprintf(stderr," %d unmatched left braces present \n",left);
    exit(-1);
 }
 if( left < 0 ) {
    fprintf(stderr," %d unmatched right braces present \n",-left);
    exit(-1);
 }

}


%}
%S FOUNDTAG 
%%
<FOUNDTAG>{SQ}		{
			 len = yyleng-2; tree_ent->value=malloc(len+1);
			 len = massage(yytext+1,tree_ent->value,len,yytext[0]);
			 tree_ent->value[len]='\0';  
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
<FOUNDTAG>{BQ}		{  /* backquotes are now evaluated in get_value */
			 len=yyleng; tree_ent->value=malloc(len+1);
		 	 bcopy(yytext,tree_ent->value,len+1); 
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
<FOUNDTAG>{DQ}		{
			 len = yyleng-2; tree_ent->value=malloc(len+1);
			 len = massage(yytext+1,tree_ent->value,len,yytext[0]);
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
<FOUNDTAG>[^'"]{NONSEPAR}*	{
			 len=yyleng; tree_ent->value=malloc(len+1);
		 	 bcopy(yytext,tree_ent->value,len+1); 
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
^{TAGBRACE}             { /* start of a new level of braces */
			 tree_ent = new_entry( yytext, 
					get_taglen(yytext,yyleng-1));
                         push_entry( tree_ent );
			 left++;
		     	}
([ \t]){TAGBRACE}  	{ /* start of a new level of braces */
			 tree_ent = new_entry( yytext+1, 
					get_taglen(yytext+1,yyleng-2));
			 push_entry(tree_ent);
			 left++;
		     	}
{TAG}/{NONSEPAR}	{
			 tree_ent = new_entry( yytext, yyleng-1 );
                         BEGIN FOUNDTAG;
			 }
{TAG}{WHITE}		{ /* an empty tag */
			  syntax_err("unexpected empty field ");
			 }
{RIGHT}			{ /* end of a level of braces */
			 pop_entry();
			 left--; 
			 if( left<0 ) {
			    syntax_err("unmatched right brace");
			 }
			}
{LEFT}			{ /* found a left brace in the wrong context */
			  syntax_err("left brace found in an unexpected place");
			}
^\!.*   /* skip comment lines */;
.       |
\n      ;
%%

/* get the tag length from a string that may have spaces around the equal */
int get_taglen( str, len )
char *str; int len;
{
char *temp;
int ret;
temp = malloc( len+1); strncpy( temp, str, len ); temp[len]='\0';
ret= strcspn( temp, " =" ) ;
free(temp);
return ret;
}

/* print a syntax error, try and give them enough context to figure
 * out where it is */
static void  syntax_err( message )
char *message;
{
    char temp[41];
    int lchar,rchar,nchar,i,j,ptrpos;

    /* print the error message */
    fprintf(stderr,"Syntax Error: %s\n", message);

    /* back up to the character causing the error */
    input_buf--; 

    /* print enough characters on either side to give he user some context*/
    lchar = MIN( 20, input_buf - input_buf_start );
    rchar = MIN( 20, input_buf_end - input_buf);
    nchar = lchar+rchar+1;
    strncpy( temp, (input_buf-lchar), nchar ); temp[nchar] = '\0';
    fprintf(stderr,"%s\n",temp);

    /* back up looking for a newline or the start of string */
    ptrpos = lchar;
    for( j=lchar-1; j>=0 ; j-- ){ 
       if( temp[j] == '\n' ) { 
         ptrpos=lchar-j-1;
         break; 
       }
    }

    /* now put a marker that points at the error */
    for( i=0; i<ptrpos; i++ ) temp[i]=' ';
    temp[ptrpos]='^'; temp[ptrpos+1]='\0';
    strcat( temp, "--- error here (I think) ");
    fprintf(stderr,"%s\n",temp);
    exit(-1);
}

push_entry( ent )
entry* ent;
{
if( stack_ptr >=0 ) add_child( entry_stack[stack_ptr], ent );
stack_ptr++;
if( stack_ptr >MAX_NEST ){
   fprintf(stderr," items nested too deeply, only %d levels supported\n",
            MAX_NEST);
   exit(-1);
}
entry_stack[stack_ptr] = ent;
treetop = entry_stack[stack_ptr];
}


pop_entry()
{
stack_ptr--;
if( stack_ptr >= 0 ) treetop = entry_stack[stack_ptr] ;
}

int
yywrap()
{
    pop_entry();
    if(stack_ptr < 0) return(1);
    return(0);
}


/* play with quoted strings and newlines etc. */
static int
massage(string,out,len,quote)
register char *string, *out;
register int len, quote;
{
  register int i,j;
  for(i=0,j=0; i<len-1; j++) {
    out[j]=string[i++];

    if(out[j]==quote) /* compress doubled quotes */
      if(string[i]==quote) i++;
    
    if(out[j]=='\\') {
      if(string[i]== 'n') { 
	   /* turn backslash n "\n" into a newline */
           i++; out[j] = '\n';
      }else if( string[i] == '\n' ){ /* remove backslash newline */
	   i++; j--;
      }
    }
    
  }
  if(i<len) out[j++] = string[i];
  return(j);
}
