/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/menubutton.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/bitmaps/dot>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

#include "object.h" 
#include "item.h"
#include "tree.h"
#include "builders.h"

void build_menubutton(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    entry *curr, *lower;
    char *label, *value ;
    struct itemizedinfo *menu_info;
    struct itemdef *item;
    Arg args[20];
    int narg;
    Widget button, menu, menuitem;
    int first;
    char defname[14];
    static int nummenu=1;
    int nitem=0;
    Pixmap mark;
    extern void menubutton_callback();
    extern void menubutton_update();
    
    /* create new object */
    object = new_object();

    /* construct default button name */
    sprintf(defname,"menubutton%d",nummenu++);
    
    /* find label, name, action in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    menu_info = (struct itemizedinfo*) 
             malloc( sizeof( struct itemizedinfo ) );
    menu_info->firstitem = (struct itemdef*) 0;
    
    object->info = menu_info;
    object->updater = menubutton_update;
    
    /* create the button and the menu */
    narg = 0;
    XtSetArg(args[narg], XtNlabel, label); narg++;
    /* common parameters */
    common_tags(parent,root,args,&narg,SET_ALL);

    button = XtCreateManagedWidget(object->name,menuButtonWidgetClass,
                 parent,args,narg);
    menu = XtCreatePopupShell("menu",simpleMenuWidgetClass,button,NULL,ZERO);
    
    /* first parse any itemlist entries into items */
    parse_itemlist( root, &(menu_info->separator) );
    
    /* loop over again to get items */
    for (curr = get_next(root,"item",(entry*) 0), nitem=0; 
	 curr != ((entry*) 0); 
	 curr = get_next(root,"item",curr), nitem++){
	
	/* construct default item name */
	sprintf(defname,"item%d",nitem+1);
	
	/* allocate structure to hold info for menu item */
	item = new_item(menu_info);
	
	/* find label, value in the next level of the tree */
	label = get_value(curr,"label",defname);
	item->value = get_value(curr,"value",label);
	
	/* add an item */
	narg = 0;

        /* common parameters */
        common_tags(menu,curr,args,&narg,SET_ALL);

	XtSetArg(args[narg], XtNlabel, label); narg++;
	menuitem =  XtCreateManagedWidget(object->name,smeBSBObjectClass,
                          menu,args,narg);

	XtAddCallback( menuitem, XtNcallback, menubutton_callback, 
		      (XtPointer) item );

	item->label = strdupl(label);
	item->widgetname = menuitem;
	/* callback routine needs to know the object name */
	item->object = object;
	
	/* info structure points to first item for find_item routine */
	if (nitem == 0) menu_info->firstitem = item;
	
	/* value is default; we select the button whose value matches this */
	if (nitem == 0) value = get_value(root,"value",item->value);
	
	/* check to see if this is the default item */
	/* indicate the default item with an X */
	narg = 0;
	
        if (!strcmp(value,item->value)) {
 	    mark = XCreateBitmapFromData(XtDisplay(parent),
			     RootWindowOfScreen(XtScreen(parent)),
			     (char *) dot_bits,
			     dot_width, dot_height);
	    XtSetArg(args[narg], XtNleftBitmap, mark); narg++;
	    object->value = value;
	    XtSetValues(menuitem,args,narg);
	}
    }
}

extern Widget toplevel;

void
  menubutton_callback(widget, client_data, callData)
Widget widget;
XtPointer client_data, callData;
{
    Objdef *object;
    struct itemdef *menuitem;
    struct itemizedinfo *menu_info;
    Arg args[20];
    int narg;
    Pixmap mark;
    extern int quitflag;
    extern void unmark_all_items();
    
    menuitem = (struct itemdef *) client_data;
    object = (Objdef *) menuitem->object;
    menu_info = (struct itemizedinfo *) object->info;
    
    /* first unmark the previous choice, if any */
    unmark_all_items(menu_info);
    
    object->value = strdupl((char *) menuitem->value);
    if (perform_actions(object->name,object->action,1) && !quitflag)
        quit_xtpanel(0);
    
    /* indicate the current choice */
    mark = XCreateBitmapFromData(XtDisplay(toplevel),
			     RootWindowOfScreen(XtScreen(toplevel)),
			     (char *) dot_bits,
			     dot_width, dot_height);
    narg = 0;
    XtSetArg(args[narg], XtNleftBitmap, mark); narg++;
    XtSetValues(menuitem->widgetname,args,narg);
    
}

void
  unmark_all_items(menu_info)
struct itemizedinfo *menu_info;
{
    struct itemdef *item;
    Arg args[20];
    int narg;
    
    for( item=menu_info->firstitem; 
	 item != (struct itemdef*)0; 
	 item = item->next )
      {
	  narg = 0;
	  XtSetArg(args[narg], XtNleftBitmap, None); narg++;
	  XtSetValues(item->widgetname,args,narg);
      }
}

void
  menubutton_update(object,value)
Objdef* object;
char* value;
{
    struct itemizedinfo *menu_info;
    struct itemdef *item;
    Arg args[20];
    int narg;
    Pixmap mark;
    
    menu_info = object->info;

    for( item=menu_info->firstitem; 
	 item != (struct itemdef*)0; 
	 item = item->next )
      {
	if (!strcmp(item->value,value)) {
	  unmark_all_items(menu_info);
	  narg = 0;
	  XtSetArg(args[narg], XtNleftBitmap, None); narg++;
	  XtSetValues(item->widgetname,args,narg);
	  mark = XCreateBitmapFromData(XtDisplay(toplevel),
			     RootWindowOfScreen(XtScreen(toplevel)),
			     (char *) dot_bits,
			     dot_width, dot_height);
	  narg = 0;
	  XtSetArg(args[narg], XtNleftBitmap, mark); narg++;
	  XtSetValues(item->widgetname,args,narg);
	}
      }
}
