/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/list.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), February 25 1993
 *      Added number of columns. Changed list to use form widget.
 * Steve Cole (SEP), May 10 1993
 *      List separator is stored in info structure for SetTag.
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>

#include "object.h" 
#include "item.h" 
#include "tree.h"
#include "builders.h"

void build_list(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    entry *curr, *lower;
    char *label, *value;
    struct itemdef *item;
    struct itemizedinfo *list_info;
    Arg args[20];
    int narg;
    Widget box,labl,viewport,list;
    int first;
    char defname[12];
    static int numlist=1;
    int nitem=0;
    String * liststring = NULL; 
    int allocated_items = 0;
    int ncols;
    extern void list_callback();
    extern void list_update();
    
    /* list gets its own box - actually it is a form */
    narg = 0;
    /* common parameters */
    common_tags(parent,root,args,&narg,SET_POSITION);
    box = XtCreateManagedWidget("listbox",formWidgetClass,parent,args,narg);
    
    /* create new object */
    object = new_object();

    /* construct default list name */
    sprintf(defname,"list%d",numlist++);
    
    /* find label, name, action in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    list_info = (struct itemizedinfo*) 
            malloc( sizeof( struct itemizedinfo ) );
    list_info->firstitem = (struct itemdef*) 0;
    object->info = list_info;
    
    /* the list label */
    narg = 0;
    common_tags(parent,root,args,&narg,SET_FONT);
    XtSetArg(args[narg], XtNborderWidth, 0); narg++;
    XtSetArg(args[narg], XtNlabel, label); narg++;
    labl = XtCreateManagedWidget(object->name,labelWidgetClass,
                  box,args,narg);
    
    /* the list goes in a viewport to allow scrolling */
    /* the viewport is not resizable */
    narg=0;
    XtSetArg(args[narg], XtNallowHoriz, True ); narg++;
    XtSetArg(args[narg], XtNallowVert, True ); narg++;
    XtSetArg(args[narg], XtNfromVert, labl ); narg++;
    XtSetArg(args[narg], XtNresizable, False); narg++;
    /* common parameters */
    common_tags(box,root,args,&narg,~SET_POSITION);

    viewport = XtCreateManagedWidget( object->name,viewportWidgetClass,
				     box,args,narg);

    /* the list is resizable to allow for scrolling */
    narg=0;
    XtSetArg(args[narg], XtNresizable, True); narg++;
    /* common parameters */
    common_tags(viewport,root,args,&narg,SET_COLOR | SET_FONT | SET_PIXMAP);

    /* number of columns */
    if (is_specified(root,"columns"))
    {
	value = get_value(root,"columns","0");
	sscanf( value,"%d",&ncols);
        XtSetArg(args[narg], XtNforceColumns, TRUE ); narg++;
        XtSetArg(args[narg], XtNdefaultColumns, ncols ); narg++;
    }

    /* now create the list */
    list = XtCreateManagedWidget(object->name,listWidgetClass,viewport,
				 args,narg);
    
    /* first parse any itemlist entries into items */
    parse_itemlist( root, &(list_info->separator) );

    /* loop over again to get items */
    for (curr = get_next(root,"item",(entry*) 0), nitem=0; 
	 curr != ((entry*) 0); 
	 curr = get_next(root,"item",curr), nitem++){
	
	/* construct default item name */
	sprintf(defname,"item%d",nitem+1);
	
	/* allocate structure to hold info for list item */
	item =  new_item(list_info);
	
	/* find label, value in the next level of the tree */
	label = get_value(curr,"label",defname);
	item->value = get_value(curr,"value",label);
	
	/* add an item */
	if (nitem == allocated_items) {
	    allocated_items += 5;
	    liststring = (String *) XtRealloc((char *)liststring, 
					   sizeof(String) * allocated_items);
	}
	liststring[nitem] = XtNewString(label);
	XawListChange(list, liststring, nitem+1, 0, True);
	
	item->label = strdupl(label);
	item->widgetname = list;
	/* callback routine needs to know the object name */
	item->object = object;
	
	/* info structure points to first item for find_item routine */
	if (nitem == 0) list_info->firstitem = item;
	
	/* value is default; we select the button whose value matches this */
	if (nitem == 0) value = get_value(root,"value",item->value);
	
    }
    
    /* loop over items - look for one that matches the default */
    for (item = list_info->firstitem,nitem=0; 
         item != (struct itemdef*) 0; item=item->next,nitem++) {
        if (!strcmp(item->value,value)) {
    	    XawListHighlight(list,nitem);
            object->value = value;
        }
    }
    
    XtAddCallback( list, XtNcallback, list_callback, (XtPointer) object );
    object->widgetname = list;
    object->updater = list_update;
}

void
  list_callback(widget, client_data, callData)
Widget widget;
XtPointer client_data, callData;
{
    Objdef *object;
    XawListReturnStruct *item;
    struct itemdef *listitem;
    Arg arg[1];
    int num;
    extern int quitflag;
    
    object = (Objdef *) client_data;
    /* XawListReturnStruct just tells us the label */
    item = (XawListReturnStruct *) callData;
    
    /* find the item whose label matches */
    listitem = find_item(object,item->string);
    
    /* get the value of the text field */
    object->value = strdupl((char *) listitem->value);
    
    if (perform_actions(object->name,object->action,1) && !quitflag)
       quit_xtpanel(0);
}

void list_update(object,value)
Objdef *object;
char *value;
{
    struct itemdef *item;
    struct itemizedinfo *list_info;
    Arg args[20];
    int narg;
    int nitem=0;
    
    list_info = object->info;

    /* loop over items - look for one that matches the value */
    for (item = list_info->firstitem,nitem=0; 
	     item != (struct itemdef*) 0; item=item->next,nitem++) {
	    if (!strcmp(item->value,value)) {
		XawListHighlight(object->widgetname,nitem);
       		object->value = value;
	    }
    }
    
}
