# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/xtpanel-scan.l
 *
 * Steve Cole, Dave Nichols (SEP), August 31 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole, Dave Nichols (SEP), November 20 1992 -  version 2.00
 * 1) added new objects: toggle, scrollbar, graph.
 * 2) added new actions: ASSIGN, SET.
 * 3) objects can have multiple actions.
 * 4) backquoted strings in actions get executed at action time.
 * Steve Losen (scl@virginia.edu) 3 Mar 1993
 * introduced `` as an escaped backquote.
 */

/* lexical scanning for xtpanel */

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#if defined _POSIX_SOURCE
#include <unistd.h>
#endif

#include "tree.h"
#include "eval_command.h"

#ifndef MIN
#define MIN(A,B) (A<B?A:B)
#endif

#define MAX_NEST 20
static int stack_ptr = -1;
static char *input_buf;
static char *input_buf_start;
static char *input_buf_end;

static entry *entry_stack[MAX_NEST];

#undef input
#define input() ((int) *(input_buf++))
#undef unput
/* The redundant  =(c) insures side effects of expressions occur */
#define unput(c) (*(--(input_buf))=(c))

/* define the look ahead buffer size to something big
 * This is needed in case they have a very big text 
 * string in quotes.
 */
#undef YYLMAX
#define YYLMAX 50000

#define yywrap() xtpanel_wrap()
#define yylex()  xtpanel_lexscan()
#define yylook() xtpanel_yylook()

entry *tree_ent;
entry *treetop;
int len;
int left=0;

static void syntax_err();
static int massage();

/* workhorse to decode xtpanel files; */

entry* xtpanel_scan( buffer, root )
char* buffer;
entry* root;
{
 extern int yylex();

 /* note the input buffer should be null terminated */
 input_buf = buffer;
 input_buf_start = input_buf;
 input_buf_end = input_buf + strlen(input_buf) - 1;

 /* all the info we find will be stored under the root entry */
 push_entry( root );

 yylex();
 if( left > 0 ) {
    fprintf(stderr," %d unmatched left braces present \n",left);
    exit(-1);
 }
 if( left < 0 ) {
    fprintf(stderr," %d unmatched right braces present \n",-left);
    exit(-1);
 }

}


# define FOUNDTAG 2
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{
			 len = yyleng-2; tree_ent->value=malloc(len+1);
			 len = massage(yytext+1,tree_ent->value,len,yytext[0]);
			 tree_ent->value[len]='\0';  
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
break;
case 2:
	{  /* backquotes are now evaluated in get_value */
			 len=yyleng; tree_ent->value=malloc(len+1);
		 	 bcopy(yytext,tree_ent->value,len+1); 
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
break;
case 3:
	{
			 len = yyleng-2; tree_ent->value=malloc(len+1);
			 len = massage(yytext+1,tree_ent->value,len,yytext[0]);
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
break;
case 4:
{
			 len=yyleng; tree_ent->value=malloc(len+1);
		 	 bcopy(yytext,tree_ent->value,len+1); 
			 tree_ent->value[len]='\0'; 
			 add_child( treetop, tree_ent );
			 BEGIN 0; 
			 }
break;
case 5:
            { /* start of a new level of braces */
			 tree_ent = new_entry( yytext, 
					get_taglen(yytext,yyleng-1));
                         push_entry( tree_ent );
			 left++;
		     	}
break;
case 6:
 	{ /* start of a new level of braces */
			 tree_ent = new_entry( yytext+1, 
					get_taglen(yytext+1,yyleng-2));
			 push_entry(tree_ent);
			 left++;
		     	}
break;
case 7:
{
			 tree_ent = new_entry( yytext, yyleng-1 );
                         BEGIN FOUNDTAG;
			 }
break;
case 8:
	{ /* an empty tag */
			  syntax_err("unexpected empty field ");
			 }
break;
case 9:
		{ /* end of a level of braces */
			 pop_entry();
			 left--; 
			 if( left<0 ) {
			    syntax_err("unmatched right brace");
			 }
			}
break;
case 10:
		{ /* found a left brace in the wrong context */
			  syntax_err("left brace found in an unexpected place");
			}
break;
case 11:
  /* skip comment lines */;
break;
case 12:
      case 13:
     ;
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* get the tag length from a string that may have spaces around the equal */
int get_taglen( str, len )
char *str; int len;
{
char *temp;
int ret;
temp = malloc( len+1); strncpy( temp, str, len ); temp[len]='\0';
ret= strcspn( temp, " =" ) ;
free(temp);
return ret;
}

/* print a syntax error, try and give them enough context to figure
 * out where it is */
static void  syntax_err( message )
char *message;
{
    char temp[41];
    int lchar,rchar,nchar,i,j,ptrpos;

    /* print the error message */
    fprintf(stderr,"Syntax Error: %s\n", message);

    /* back up to the character causing the error */
    input_buf--; 

    /* print enough characters on either side to give he user some context*/
    lchar = MIN( 20, input_buf - input_buf_start );
    rchar = MIN( 20, input_buf_end - input_buf);
    nchar = lchar+rchar+1;
    strncpy( temp, (input_buf-lchar), nchar ); temp[nchar] = '\0';
    fprintf(stderr,"%s\n",temp);

    /* back up looking for a newline or the start of string */
    ptrpos = lchar;
    for( j=lchar-1; j>=0 ; j-- ){ 
       if( temp[j] == '\n' ) { 
         ptrpos=lchar-j-1;
         break; 
       }
    }

    /* now put a marker that points at the error */
    for( i=0; i<ptrpos; i++ ) temp[i]=' ';
    temp[ptrpos]='^'; temp[ptrpos+1]='\0';
    strcat( temp, "--- error here (I think) ");
    fprintf(stderr,"%s\n",temp);
    exit(-1);
}

push_entry( ent )
entry* ent;
{
if( stack_ptr >=0 ) add_child( entry_stack[stack_ptr], ent );
stack_ptr++;
if( stack_ptr >MAX_NEST ){
   fprintf(stderr," items nested too deeply, only %d levels supported\n",
            MAX_NEST);
   exit(-1);
}
entry_stack[stack_ptr] = ent;
treetop = entry_stack[stack_ptr];
}


pop_entry()
{
stack_ptr--;
if( stack_ptr >= 0 ) treetop = entry_stack[stack_ptr] ;
}

int
yywrap()
{
    pop_entry();
    if(stack_ptr < 0) return(1);
    return(0);
}


/* play with quoted strings and newlines etc. */
static int
massage(string,out,len,quote)
register char *string, *out;
register int len, quote;
{
  register int i,j;
  for(i=0,j=0; i<len-1; j++) {
    out[j]=string[i++];

    if(out[j]==quote) /* compress doubled quotes */
      if(string[i]==quote) i++;
    
    if(out[j]=='\\') {
      if(string[i]== 'n') { 
	   /* turn backslash n "\n" into a newline */
           i++; out[j] = '\n';
      }else if( string[i] == '\n' ){ /* remove backslash newline */
	   i++; j--;
      }
    }
    
  }
  if(i<len) out[j++] = string[i];
  return(j);
}
int yyvstop[] = {
0,

12,
0,

12,
0,

13,
0,

12,
0,

10,
12,
0,

9,
12,
0,

11,
12,
0,

12,
0,

4,
12,
0,

4,
12,
0,

4,
13,
0,

12,
0,

12,
0,

4,
12,
0,

4,
12,
0,

4,
10,
12,
0,

4,
9,
12,
0,

4,
11,
12,
0,

4,
12,
0,

-7,
0,

11,
0,

-7,
0,

4,
0,

4,
0,

3,
0,

1,
0,

4,
0,

4,
-7,
0,

4,
0,

2,
4,
0,

4,
11,
0,

4,
0,

4,
-7,
0,

7,
0,

8,
0,

5,
0,

4,
0,

4,
7,
0,

2,
0,

6,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,5,	0,0,	
0,0,	3,13,	0,0,	0,0,	
0,0,	0,0,	1,6,	1,7,	
0,0,	3,14,	3,15,	27,0,	
0,0,	0,0,	22,41,	39,39,	
41,41,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	22,0,	
0,0,	41,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,5,	
2,11,	33,32,	3,16,	4,22,	
1,5,	0,0,	35,34,	3,17,	
15,0,	15,0,	1,5,	14,0,	
14,0,	3,13,	0,0,	22,41,	
39,39,	41,41,	0,0,	0,0,	
22,41,	39,39,	41,41,	0,0,	
0,0,	0,0,	22,41,	39,39,	
41,41,	0,0,	1,8,	15,0,	
2,12,	3,18,	14,0,	4,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	22,41,	39,39,	
41,41,	0,0,	0,0,	0,0,	
0,0,	20,0,	20,0,	0,0,	
0,0,	21,0,	21,0,	0,0,	
0,0,	1,5,	0,0,	0,0,	
3,19,	0,0,	0,0,	14,31,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
20,0,	22,41,	39,50,	41,41,	
21,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,9,	0,0,	1,10,	3,20,	
2,10,	3,21,	44,51,	4,21,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	15,0,	50,39,	
15,0,	14,0,	0,0,	14,0,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	6,24,	6,24,	
6,24,	6,24,	8,25,	0,0,	
0,0,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	20,0,	
0,0,	20,0,	8,26,	21,0,	
0,0,	21,0,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
29,47,	0,0,	29,0,	0,0,	
8,25,	0,0,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
11,27,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
11,27,	11,0,	24,24,	18,0,	
18,0,	24,24,	24,24,	24,24,	
24,24,	24,24,	24,24,	24,24,	
24,24,	24,24,	24,24,	0,0,	
0,0,	0,0,	24,44,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	11,27,	18,0,	0,0,	
0,0,	0,0,	11,27,	0,0,	
0,0,	0,0,	0,0,	0,0,	
11,27,	0,0,	0,0,	18,36,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
24,24,	0,0,	0,0,	18,37,	
11,27,	0,0,	0,0,	18,36,	
30,0,	30,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
12,28,	0,0,	0,0,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	0,0,	0,0,	30,0,	
12,29,	0,0,	0,0,	11,27,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	11,27,	0,0,	
0,0,	18,0,	12,28,	18,0,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	12,28,	12,28,	
12,28,	12,28,	13,30,	23,0,	
23,0,	16,32,	0,0,	0,0,	
0,0,	17,34,	13,0,	13,0,	
19,38,	16,32,	16,32,	0,0,	
0,0,	17,34,	17,34,	26,45,	
19,39,	19,39,	0,0,	0,0,	
0,0,	0,0,	23,0,	26,46,	
26,46,	0,0,	30,0,	0,0,	
30,0,	13,0,	37,49,	13,30,	
0,0,	0,0,	16,33,	23,42,	
13,30,	0,0,	17,34,	16,32,	
0,0,	19,38,	13,30,	17,35,	
0,0,	16,32,	19,38,	0,0,	
26,45,	17,34,	0,0,	23,43,	
19,38,	26,45,	0,0,	23,42,	
0,0,	40,0,	40,0,	26,45,	
0,0,	0,0,	13,30,	37,49,	
0,0,	16,32,	48,0,	48,0,	
37,49,	17,34,	0,0,	0,0,	
19,38,	0,0,	37,49,	0,0,	
31,0,	31,0,	0,0,	26,45,	
40,0,	0,0,	36,0,	36,0,	
0,0,	49,0,	49,0,	0,0,	
0,0,	48,0,	0,0,	0,0,	
0,0,	13,30,	37,49,	0,0,	
16,32,	0,0,	0,0,	31,0,	
17,34,	0,0,	43,49,	19,40,	
0,0,	36,0,	42,0,	42,0,	
49,0,	0,0,	26,45,	0,0,	
31,31,	23,0,	0,0,	23,0,	
0,0,	0,0,	36,36,	0,0,	
13,0,	0,0,	13,0,	16,32,	
0,0,	37,49,	0,0,	17,34,	
31,48,	42,0,	19,39,	0,0,	
31,31,	0,0,	36,37,	43,49,	
0,0,	26,0,	36,36,	26,0,	
43,49,	0,0,	42,42,	0,0,	
40,38,	0,0,	43,49,	0,0,	
0,0,	0,0,	0,0,	0,0,	
37,0,	0,0,	37,0,	0,0,	
0,0,	0,0,	42,43,	0,0,	
0,0,	0,0,	42,42,	0,0,	
0,0,	0,0,	43,49,	0,0,	
0,0,	0,0,	0,0,	40,0,	
0,0,	40,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
48,51,	0,0,	48,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	31,0,	0,0,	
31,0,	0,0,	0,0,	0,0,	
36,0,	43,49,	36,0,	49,0,	
0,0,	49,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
42,0,	0,0,	42,0,	0,0,	
43,47,	0,0,	43,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-3,	yysvec+1,	0,	
yycrank+-4,	0,		0,	
yycrank+-6,	yysvec+3,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+67,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+145,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+9,
yycrank+0,	0,		yyvstop+12,
yycrank+-267,	0,		yyvstop+15,
yycrank+299,	0,		yyvstop+18,
yycrank+-421,	0,		yyvstop+20,
yycrank+-38,	yysvec+13,	yyvstop+23,
yycrank+-35,	yysvec+13,	yyvstop+26,
yycrank+-424,	0,		yyvstop+29,
yycrank+-428,	0,		yyvstop+31,
yycrank+-270,	yysvec+13,	yyvstop+33,
yycrank+-431,	0,		yyvstop+36,
yycrank+-80,	yysvec+13,	yyvstop+39,
yycrank+-84,	yysvec+13,	yyvstop+43,
yycrank+-17,	yysvec+11,	yyvstop+47,
yycrank+-414,	yysvec+13,	yyvstop+51,
yycrank+233,	yysvec+6,	0,	
yycrank+0,	yysvec+8,	0,	
yycrank+-438,	0,		yyvstop+54,
yycrank+-5,	yysvec+11,	yyvstop+56,
yycrank+0,	yysvec+12,	0,	
yycrank+-113,	yysvec+26,	yyvstop+58,
yycrank+-327,	yysvec+13,	yyvstop+60,
yycrank+-491,	yysvec+13,	yyvstop+62,
yycrank+0,	yysvec+16,	0,	
yycrank+3,	0,		yyvstop+64,
yycrank+0,	yysvec+17,	0,	
yycrank+3,	0,		yyvstop+66,
yycrank+-497,	yysvec+13,	yyvstop+68,
yycrank+-453,	yysvec+26,	yyvstop+70,
yycrank+0,	yysvec+19,	yyvstop+73,
yycrank+-18,	yysvec+19,	0,	
yycrank+-472,	yysvec+13,	yyvstop+75,
yycrank+-19,	yysvec+11,	yyvstop+78,
yycrank+-521,	yysvec+13,	yyvstop+81,
yycrank+-525,	yysvec+26,	yyvstop+83,
yycrank+7,	0,		0,	
yycrank+0,	0,		yyvstop+86,
yycrank+0,	0,		yyvstop+88,
yycrank+0,	0,		yyvstop+90,
yycrank+-481,	yysvec+13,	yyvstop+92,
yycrank+-500,	yysvec+13,	yyvstop+94,
yycrank+63,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
0,	0,	0};
struct yywork *yytop = yycrank+650;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,047 ,
01  ,01  ,01  ,01  ,01  ,'-' ,01  ,01  ,
'-' ,'-' ,'-' ,'-' ,'-' ,'-' ,'-' ,'-' ,
'-' ,'-' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,'-' ,
'`' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'{' ,01  ,'{' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
