
COMMAND LINE INTERFACE
     On the command line, objects are specified in the  following
     format:

     xtpanel -object_type value value ... -object_type value...

     The values must be  specified  in  a  prescribed  order,  as
     described  below  for  each  object type. You can specify as
     many of the values for a given object as you wish;  the  "-"
     on  the object type is the signal to xtpanel to stop reading
     parameters for one object and begin the next. But  in  order
     to  specify  a  value  for  one  parameter, you MUST specify
     values all those that  precede  it,  in  exactly  the  order
     specified here.

     The values for each object  are  described  in  the  section
     above  named DESCRIPTION OF OBJECTS AND SCRIPT SYNTAX.  Here
     we simply list them in the order that they must be specified
     from the command line.

     -message    [value]
     -text       [action name value width height editType]
     -field      [action name value]
     -dialog     [label action name value]
     -button     [label action name value]
     -toggle     [label action name value]
     -slider     [label action name value min max format width height]
     -scrollbar  [action name value min max format width height]
     -choice     [label action name value numchoice label value ...]
     -menubutton [label action name value numchoice label value ...]
     -list       [label action name value numchoice label value ...]
     -var        [name value action]
     -startup    [action name value]
     -timer      [action interval name value running]
     -graph      [nsamp action name value min max format width height]
     -grid       [nx ny action name value xmin ymin dx dy format width height]
     -togglegrid [nx ny action name value xmin ymin dx dy format formtype    width height]
     -quit

     For the multiple-choice  objects  (choice,  menubutton,  and
     list), you must specify a label (which gets displayed on the
     screen) and a value (used on output) for each item, and  you
     must  precede  these  by  the number of items in the choice,
     menubutton, or list (which is not  required  in  a  script).
     There  is  no  analog to the script "itemlist" object, which
     lets you specify only one string for each  item  instead  of
     two.

     Note that the box and  form  objects  described  above  (see
     BOXES AND FORMS), used to group objects into horizontally or
     vertically oriented boxes or forms, are not  available  from
     the command line.


COMMAND LINE EXAMPLES
     The following examples illustrate the use  of  xtpanel  from
     the command line:

     This example contains a quit button and a message:

     xtpanel -quit -message "this is a message"

     This example contains a choice:

     xtpanel -choice "this is a choice" 'PRINT choice is $val' name 1 3 one 1 two 2 three 3

     This example contains a slider and a button that outputs the
     slider's value:

     xtpanel -quit -slider "this is a slider" 'PRINT slider value is $val'
     name 5 0 10 "%.0f" 100 20 -button "press me" 'PRINT slider value is $name'

     Be careful with quoting on the command line. In most  shells
     if  you want to pass a backquoted string to xtpanel you have
     to put it inside single quotes not double quotes.

     This command will not work, the shell will complain about an
     undefined variable.
     xtpanel -field  "PRINT `cat $val`" joe myfile.c
     But this should,
     xtpanel -field  'PRINT `cat $val`' joe myfile.c


GENERAL COMMAND LINE OPTIONS
     -file filename
          Read in the script file "filename". Xtpanel also  looks
          for  a  script file on stdin. The filename specified in
          this way is searched for in a number of possible direc-
          tories.   If the environment variable "XTPANEL_PATH" is
          set it is assumed to  be  a  colon  separated  list  of
          directories to be searched. If the file is not found in
          these directories the program will search  a  directory
          called  .xtpanel  in  the users home directory and then
          the system xtpanel directory.

          If the environment variable is not set the program will
          search  the  current  directory, followed by ~/.xtpanel
          followed by the system xtpanel directory.

          The system directory is specified in the Makefile  used
          to  compile the xtpanel program. At compilation time on
          this system it was set to SYS_XTPANELDIR.


     -cpp [cpp_args]
          If the -cpp flag is specified then all files read using
          the   "-file"   flag  will  be  passed  though  the  C-
          preprocessor before being parsed. The preprocessor will
          be  invoked  using any command line arguments that look
          like they might be C-preprocessor arguments.  Currently
          this  is  interpreted as being any argument that starts
          with "-I" or "-D". Note the  standard  input  is  never
          passed  through  cpp. If you wish to to this you should
          pipe the output of cpp into xtpanel yourself.

          This option can be very useful in designing system wide
          xtpanel scripts where a few key words may be changed at
          each invocation. These words may be redefined  with  "-
          Doldname=newname".  This  can  also be done using vari-
          ables and it is probaly more efficient to  do  so.  The
          -cpp  option  can  also  be  used  to define macros for
          repeated parts of script files or even  including  pre-
          built  pieces  of script files from elsewhere. The fol-
          lowing example illustrates some of these possibilities.

          #ifndef NAME
          #define NAME "default name"
          #endif

          #define mkslid(VAL) slider={ label="" min=0 max=100 value=VAL
          width=300 height=25 format="%.0f" action="STRING $val" }

          label={ value=NAME }

          mkslid(0)
          mkslid(10)
          mkslid(20)


     -help
          Invokes a series of xtpanel scripts that present infor-
          mation  about  xtpanel,  mostly  taken from this manual
          page, in an interactive, menu-driven form.


     -tty Read a script from the terminal. Generally  not  recom-
          mended;  it  is  better  to  save  the script in a file
          first. If this option is not set the program  will  not
          accept  input  from standard input if it is a terminal.
          You can  redirect  standard  input  and  pipe  data  to
          xtpanel without setting this option.
