/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/dialog.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), February 23 1993
 *      Ok button suppressed if all actions are STRING or NONE.
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>

#include "object.h" 
#include "tree.h"
#include "builders.h"

/* translation table used for dialog widget */
char trans[] = 		
  "<Leave>:         update_dialog()\n\
   <Key>Return:     return_key()";

void build_dialog(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    char *label;
    Arg args[20];
    Widget dialog, button;
    char defname[12];
    static int numdiag=1;
    int narg;
    extern void dialog_callback();
    extern void dialog_update();
    
    /* create new object */
    object = new_object();

    /* construct default dialog name */
    sprintf(defname,"dialog%d",numdiag++);
    
    /* find label, name, action, etc. in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    object->value = get_value(root,"value","");
    
    narg=0;
    XtSetArg(args[narg], XtNlabel, label ); narg++;
    XtSetArg(args[narg], XtNvalue, object->value); narg++;
    /* common parameters */
    common_tags(parent,root,args,&narg,SET_ALL);

    dialog = XtCreateManagedWidget(object->name,dialogWidgetClass,parent,
				   args,narg);

    object->widgetname = dialog;
    object->updater = dialog_update;
    
    /* use translations to update value whenever mouse leaves dialog widget */
    XtOverrideTranslations(dialog,XtParseTranslationTable(trans));
    
    /* add a button */
    if (!all_string_actions(object->action)) {
      button = XtCreateManagedWidget(object->name,commandWidgetClass,
				       dialog,NULL,ZERO);
      XtAddCallback(button, XtNcallback, dialog_callback, 
		      (XtPointer) object );
    }
}

/* 
 * this routine gets called when the optional button of a dialog
 * item is pressed 
 */
void  dialog_callback(widget, client_data, callData)
     Widget widget;
     XtPointer client_data, callData;
{
    Objdef *object;
    Arg arg[1];
    extern int quitflag;
    
    object = (Objdef *) client_data;
    /* get the value of the dialog */
    object->value = 
      strdupl((char *) XawDialogGetValueString(object->widgetname));

    if (perform_actions(object->name,object->action,1) && !quitflag)
      quit_xtpanel(0);
}

/*
 * this routine gets called whenever we leave
 * a dialog widget, to be sure its value is up to date
 */
void dialog_update_callback( w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
    Objdef* obj;
    
    obj = find_by_widget(w);  
    obj->value = strdupl((char *) XawDialogGetValueString(w));
}

/*
 * this routine gets called whenever we press return
 * in a dialog widget.
 */
void return_key_callback( w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
    Objdef *object;
    Widget dialog = XtParent(w);
    extern int quitflag;
   
    object = find_by_widget(dialog);  
    /* get the value of the dialog */
    object->value = 
      strdupl((char *) XawDialogGetValueString(object->widgetname));

    if (perform_actions(object->name,object->action,1) && !quitflag)
      quit_xtpanel();
    return;
}

void dialog_update(object,value)
Objdef *object;
char *value;
{
    char *label;
    Arg args[20];
    int narg;
    
    narg=0;
    XtSetArg(args[narg], XtNvalue, value); narg++;
    XtSetValues(object->widgetname,args,narg);
}
