/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/choice.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>

#include "object.h" 
#include "item.h"
#include "tree.h"
#include "builders.h"

typedef struct choicedef {
    char* value;
    Widget widgetname;
    Objdef* object;
    struct choicedef* next;
} _cdef;

/* translation table used for toggle widgets in a choice object */
char choice_trans[] =
  "<EnterWindow>:   highlight(Always)\n\
   <LeaveWindow>:   unhighlight()\n\
   <Btn1Down>,<Btn1Up>:   set() notify()";

void build_choice(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    entry *curr;
    struct itemdef *item;
    struct itemizedinfo *choice_info;
    char *label,*value;
    Arg args[20];
    int narg;
    Widget box,labl,choice1,choice2;
    char defname[12];
    static int numtog=1;
    int nitem;
    extern void choice_callback();
    extern void choice_update();
    
    narg = 0;
    /* common parameters */
    common_tags(parent,root,args,&narg,SET_ALL);

    /* choice object gets its own box */
    box = XtCreateManagedWidget("choicebox",boxWidgetClass,parent,args,narg);
    
    /* create new object */
    object = new_object();

    /* construct default button name */
    sprintf(defname,"choice%d",numtog++);
    
    /* find label, name, action in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    
    choice_info = (struct itemizedinfo*) 
                   malloc( sizeof( struct itemizedinfo));
    choice_info->firstitem = (struct itemdef*) 0;
    object->info = choice_info;

    /* make the label */
    /* if label is not specified, skip displaying it */
    if (is_specified(root,"label")) {
	narg = 0;
     	XtSetArg(args[narg], XtNborderWidth, 0); narg++;
     	XtSetArg(args[narg], XtNlabel, label); narg++;
    	/* common parameters */
    	common_tags(box,root,args,&narg,~SET_SIZE);

     	labl = XtCreateManagedWidget(object->name,labelWidgetClass,box,
				     args,narg);
    }
    
    /* first parse any itemlist entries into items */
    parse_itemlist( root, &(choice_info->separator) );
    
    /* loop over items */
    for (curr = get_next(root,"item",(entry*) 0), nitem=0; 
	 curr != ((entry*) 0); 
	 curr = get_next(root,"item",curr), nitem++){
	
	/* construct default item name */
	sprintf(defname,"item%d",nitem+1);
	
	/* allocate structure to hold info for choice item */
	item = new_item(choice_info);
	
	/* find label, value in the next level of the tree */
	label = get_value(curr,"label",defname);
	item->value = get_value(curr,"value",label);
	
	/* value is default; we set a button to on if its value matches this */
	if (nitem == 0) value = get_value(root,"value",item->value);
	
	/* check to see if this is the default item */
	/* choice object always needs to have one button set */
	narg = 0;
	if (!strcmp(value,item->value)) {
	    XtSetArg(args[narg], XtNstate, True); narg++;
	    object->value = item->value;
	}
	
	/* first button stands alone; others have to point to it 
	   with radioGroup */
	if (nitem == 0) {
	    XtSetArg(args[narg], XtNlabel, label); narg++;
	    /* radioData is used by choice_update routine */
	    XtSetArg(args[narg], XtNradioData, item->value); narg++;
	    /* common parameters */
    	    common_tags(box,curr,args,&narg,SET_ALL);

	    choice1 = XtCreateManagedWidget(object->name,toggleWidgetClass,box,
					    args,narg);
            /* use translations */
    	    XtOverrideTranslations(choice1,
                   XtParseTranslationTable(choice_trans));
	    XtAddCallback(choice1, XtNcallback,choice_callback, 
			  (XtPointer)item );
	    item->widgetname = choice1;
	}
	else {
	    XtSetArg(args[narg], XtNradioGroup, choice1); narg++;
	    XtSetArg(args[narg], XtNlabel, label); narg++;
	    XtSetArg(args[narg], XtNradioData, item->value); narg++;
	    /* common parameters */
    	    common_tags(box,curr,args,&narg,SET_ALL);

	    choice2 = XtCreateManagedWidget(object->name,toggleWidgetClass,
                         box,args,narg);

            /* use translations */
    	    XtOverrideTranslations(choice2,
                   XtParseTranslationTable(choice_trans));
	    XtAddCallback(choice2, XtNcallback,choice_callback, 
			  (XtPointer)item );
	    item->widgetname = choice2;
	}
	
	item->object = object;
	item->label = strdupl(label);
        if (nitem == 0) choice_info->firstitem = item;

	/* set object->widgetname to any of the choice widgets */
	/* for use by choice_update */
	object->widgetname = choice1;
        object->updater = choice_update;
    }
}

void choice_callback(widget, client_data, callData)
     Widget widget;
     XtPointer client_data, callData;
{
    Objdef *object;
    struct itemdef *item;
    Arg arg[1];
    Boolean state;
    extern int quitflag; 
    
    item = (struct itemdef *) client_data;
    object = (Objdef *) item->object;
    /* get current state of button */
    XtSetArg( arg[0], XtNstate, &state );
    XtGetValues( item->widgetname, arg, ONE );
    /* if button is now selected, perform its action */
    if (state == TRUE) 
      {
	  object->value = strdupl((char *) item->value);
	  if (perform_actions(object->name,object->action,1) && !quitflag) 
	    quit_xtpanel(0);
      }
}

void choice_update(object,value)
Objdef *object;
char *value;
{
    struct itemdef *item;
    struct itemizedinfo *choice_info;
    Arg arg[1];
    int nitem;

    choice_info = object->info;

    /* loop over items - look for one that matches value and highlight */
    for (item = choice_info->firstitem,nitem=0;
	item != (struct itemdef*) 0; item=item->next,nitem++) {
	if (!strcmp(item->value,value)) {
    		XawToggleUnsetCurrent(object->widgetname);
    		XtSetArg( arg[0], XtNstate, TRUE );
    		XtSetValues( item->widgetname, arg, ONE );
	}
    }
}
