
#ifndef ACTIONS_H

#define ACTIONS_H

#include "tree.h"


enum actType{ NONE, QUIT, PRINT, STRING, SYSTEM, ASSIGN, SET };

struct act_ {
   char* condition;
   struct act_ *true_acts;
   struct act_ *false_acts;
   enum actType type;
   char* format;
   char *assignto;
   char *totag;
   struct act_ *next;
};

typedef struct act_ action;


#if ( defined(__STDC__) || defined(FUNCPROTO) ) && !defined(_NO_PROTO)
extern action* parse_actions( char*, entry* );
extern void parse_one_action( action*, char*, char* );
extern void parse_one_test( action*, char*, entry* );
extern action* new_action( action* );
extern void print_action( char*, action* );
extern perform_actions( char*, action*, int );
extern perform_one_action( char*, action* );
extern char* format_action( action* );
extern int all_string_actions(action *);
#else
extern action* parse_actions();
extern void parse_one_action();
extern void parse_one_test();
extern action* new_action();
extern void print_action();
extern perform_actions();
extern perform_one_action();
extern char *format_action();
extern int all_string_actions();
#endif

#endif
