static char TMxtent_xipc_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#if defined(__STDC__)
#include <sys/file.h>           /* RAD - to pick up FNDELAY */
#endif
#include <X11/Intrinsic.h>
#include "xtent.h"
#include "XIpc.h"
#include "xtent_xipc.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
XtentHandleIpcToClient C_P_ARGS((XtPointer pointer));

extern void
XtentSendMessage C_P_ARGS((int type, unsigned char *buffer));

extern void
XtentIPCServerInputProc C_P_ARGS((XtPointer client_data_ptr, int *source, XtInputId *id));

extern void
XtentIPCClientCleanup C_P_ARGS((XIpcClient *client));

static void
XtentIPCClientWriteProc C_P_ARGS((XtPointer client_data, int *source,
				  XtInputId *id));

static void
XtentIPCClientEnableQueue C_P_ARGS((XIpcClient *client));

static void
XtentIPCClientDisableQueue C_P_ARGS((XIpcClient *client));

static void
XtentIPCQueueAction C_P_ARGS((XIpcClient *client, int action));

extern void
XtentIPCCloseServer C_P_ARGS((XIpcServer *server));

extern void
XtentIPCServerCloseClient C_P_ARGS((XIpcServer *server, int i));

C_PROTOS_END_EXTERN

void
XtentHandleIpcToClient (pointer)
XtPointer pointer;
{
	XIpcClient *client = (XIpcClient *) pointer;
	static Widget toplevel;
	Widget *toplevel_ptr = XtentToplevelPtr ();
	Display *display = XtDisplay ((Widget) client -> data);
	XIpcMessage *message;

	if (toplevel_ptr == (Widget *) NULL)
	{
		toplevel = (Widget) client -> data;
		XtentSetToplevelPtr (&toplevel);
		toplevel_ptr = &toplevel;
	}

	XtentSetDisplay (display);

	while (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, 0) ==
		XIPC_MONITOR_MESSAGES)
	{
		if ((message = XIpcRecvFromServer (client)) ==
		    (XIpcMessage *) NULL)
		{
			if (XIpcIsClientActive (client) == FALSE)
			{
				fprintf (stderr,
		 "%s: the connection to the IPC server has been lost.\n",
					 XtentProgramName ());
				exit (1);
			}
			continue;
		}
		
		XtentSetMessageCount (XtentMessageCount () + 1);

		XtentEvalResourceLine (display, toplevel_ptr,
				       (char *) message -> buffer);
	}
}

void
XtentSendMessage (type, buffer)
int type;
unsigned char *buffer;
{
	XIpcClient *client = (XIpcClient *) XtXIpcClient ();
	static unsigned char message_buf[XIPCBUFSIZ];
	XIpcMessage *message;
	unsigned char *ptrm, *ptrb;
	int i;

	if (client == (XIpcClient *) NULL)
	{
		XtentWarningMessage ("Attempt to send a message before connecting to a message server.");
		return;
	}
	message = (XIpcMessage *) message_buf;
	ptrm = message -> buffer;
	ptrb = buffer;
	i = 0;
	while (*ptrm++ = *ptrb++)
	{
		if (i++ >= XIPC_MAX_MESSAGE_SIZE)
		{
			fprintf (stderr,
			 "%s: Attempt to send a message larger than %d.\n",
				 XtentProgramName (), XIPC_MAX_MESSAGE_SIZE);
			return;
		}
	}
	message -> length = ptrm - message -> buffer;
	message -> type = type;
	XIpcSendToServer (client, message);
}

void
XtentIPCServerInputProc (client_data_ptr, source, id)
XtPointer client_data_ptr;
int *source;
XtInputId *id;
{
    IPCServerDescriptor *sp = (IPCServerDescriptor *) client_data_ptr;
    XIpcServer *server = sp -> server;
    IPCClientData *client_data;

    if (*source == server -> channel)
    {
	struct sockaddr_in caddr;
	int caddr_len = sizeof (caddr);
	int rc;
	int i;
	int flags;
	XtInputId new_id;

	char *error_message = "cannot open client channel.\n";

	if ((rc = accept (server -> channel, (struct sockaddr *)&caddr,
			  &caddr_len)) < 0)
	    return;

	if ((i = XIpcFindClient (server, (XIpcChannel) NULL)) ==
	    server -> max_clients)
	{
	    close (rc);
	    fprintf (stderr, error_message);
	    return;
	}

	flags = fcntl (rc, F_GETFL, 0);
	if (flags >= 0 && (flags & FNDELAY) == 0)
	    if (fcntl (rc, F_SETFL, flags | FNDELAY) < 0)
	    {
		close (rc);
		fprintf (stderr, error_message);
		return;
	    }

	memset (&server -> clients[i], (char) 0, sizeof (XIpcClient));
	server -> clients[i].channel = rc;
	if (xipc_fdopen (&server -> clients[i]) == FALSE)
	{
	    close (rc);
	    fprintf (stderr, error_message);
	    return;
	}

	client_data = (IPCClientData *) XtMalloc (sizeof (IPCClientData));

	client_data -> read_id = XtAppAddInput
	 (XtWidgetToApplicationContext (XtentToplevel (XtentDisplay (),
						       XtentToplevelPtr ())),
	  rc,  (XtPointer) XtInputReadMask,
	  (XtInputCallbackProc) XtentIPCServerClientInputProc,
	  (XtPointer) sp);

	client_data -> using_write_id = False;
	client_data -> write_id = (XtInputId) NULL;
	client_data -> client_cleanup_code = (char *) NULL;

	server -> clients[i].data = (XtPointer) client_data;
	server -> clients[i].cleanup = XtentIPCClientCleanup;
	server -> clients[i].queue_update = XtentIPCQueueAction;
    }
}

void
XtentIPCClientCleanup (client)
XIpcClient *client;
{
    IPCClientData *client_data = (IPCClientData *) client -> data;

    if (client_data == (IPCClientData *) NULL)
	return;

    XtRemoveInput (client_data -> read_id);

    if (client_data -> using_write_id)
	XtRemoveInput (client_data -> write_id);

    if (client_data -> client_cleanup_code)
    {
	Widget * toplevel_ptr = XtentToplevelPtr ();
	Display * display = XtentDisplay ();

	XtentEvalResourceLine (display, toplevel_ptr,
			       client_data -> client_cleanup_code);

	XtFree (client_data -> client_cleanup_code);
    }
    XtFree ((char *) client -> data);
    client -> data = (char *) NULL;
}

static void
XtentIPCClientWriteProc (client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
    XIpcClient *client = (XIpcClient *) client_data;

    if (client -> message_queue)
	switch (XIpcSendQueue (client))
	{
	case XIPC_SENDQUEUE_DEAD:
	    XtentIPCClientDisableQueue (client);
	    return;
	case XIPC_SENDQUEUE_BLOCKED:
	    return;
	case XIPC_SENDQUEUE_SENT:
	    XtentIPCClientDisableQueue (client);
	    return;
	}
}

static void
XtentIPCClientEnableQueue (client)
XIpcClient *client;
{
    IPCClientData *client_data = (IPCClientData *) client -> data;

    if (client_data == (IPCClientData *) NULL)
	return;

    if (client_data -> using_write_id == False)
    {
	client_data -> write_id =
	    XtAppAddInput (
		XtWidgetToApplicationContext (XtentToplevel (XtentDisplay (),
							 XtentToplevelPtr ())),
			   client -> channel, (XtPointer) XtInputWriteMask,
			   XtentIPCClientWriteProc, (XtPointer) client);
	client_data -> using_write_id = True;
    }
}

static void
XtentIPCClientDisableQueue (client)
XIpcClient *client;
{
    IPCClientData *client_data = (IPCClientData *) client -> data;

    if (client_data == (IPCClientData *) NULL)
	return;

    if (client_data -> using_write_id == True)
    {
	XtRemoveInput (client_data -> write_id);
	client_data -> using_write_id = False;
    }
}

static void
XtentIPCQueueAction (client, action)
XIpcClient *client;
int action;
{
    switch (action)
    {
    case XIPC_SENDQUEUE_BLOCKED:
    case XIPC_SENDQUEUE_DEAD:
	XtentIPCClientEnableQueue (client);
	return;
    case XIPC_SENDQUEUE_SENT:
	XtentIPCClientDisableQueue (client);
	return;
    }
}

extern void
XtentIPCCloseServer (server)
XIpcServer *server;
{
    int i;

    for (i = 0; i < server -> max_clients; i++)
	XtentIPCClientDisableQueue (&server -> clients[i]);

    XIpcCloseServer (server);
}

extern void
XtentIPCServerCloseClient (server, i)
XIpcServer *server;
int i;
{
    if (i >= 0 && i < server -> max_clients)
    {
	XtentIPCClientDisableQueue (&server -> clients[i]);
	XIpcServerCloseClient (server, i);
    }
}
