static char TMxtent_signal_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <signal.h>
#include <X11/Intrinsic.h> /* RAD */
#include "xtent.h"

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

#if defined(__STDC__)
static void
XtentCatchSignal C_P_ARGS((int sig));
#else
static void
XtentCatchSignal C_P_ARGS((int sig, code, struct sigcontext *scp, char *addr));
#endif

extern void
XtentSetSignals C_P_NO_ARGS();

extern void
XtentUnSetSignals C_P_NO_ARGS();

C_PROTOS_END_EXTERN

/*
 * signal() function returns for set and unset
 */
typedef void (*PFV)();
static PFV signal_functions[SIGTERM];		/* usually 15 */
static int signals_set = FALSE;

/*
 * routine for catching deadly errors and exiting cleanly.
 */
#if defined(__STDC__)
static void
XtentCatchSignal (sig)
int sig;
#else /* defined(__STDC__) */
static void
XtentCatchSignal (sig, code, scp, addr)
int sig, code;
struct sigcontext *scp;
char *addr;
#endif /* defined(__STDC__) */
{
	fprintf (stderr, "%s: Caught signal %d, at line %d, message %d.\n",
		 XtentProgramName (), sig,
		 XtentLineCount (), XtentMessageCount ());
	exit (1);
}

void
XtentSetSignals ()
{
	register int i;

	if (signals_set == TRUE)
		return;

        for (i = 1; i <= SIGTERM; i++)
                signal_functions[i - 1] = signal (i, XtentCatchSignal);

	signals_set = TRUE;
}

void
XtentUnSetSignals ()
{
	register int i;

	if (signals_set == FALSE)
		return;

        for (i = 1; i < SIGTERM; i++)
                signal (i, signal_functions[i - 1]);

	signals_set = FALSE;
}
