static char TM_xtent_quark_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

/***********************************************************
 Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
 and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
  
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its 
  documentation for any purpose and without fee is hereby granted, 
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in 
  supporting documentation, and that the names of Digital or MIT not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.  
  
  DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
  DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
  SOFTWARE.
  
  I have borrowed the Quark.c code from the X distribution.  This version 
  adds a pointer upon which the application program can hang data.
  Allocation is a bit better here as we only call alloc once. Blewett
  
******************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include "xtent_quark.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern Item
XtentStringToQuarkItem C_P_ARGS((char *name, int new));

C_PROTOS_END_EXTERN

/*
 * round to nearest word boundary
 */
#ifdef WORD64
#define WORDMASK	(7)
#else
#define WORDMASK	(3)
#endif

#define ITEM_LENGTH	((sizeof (ItemRec) + WORDMASK) & (~WORDMASK))

#ifdef XTENT_USE_OLD_HASH_SCHEME_FROM_X
#define HASHTABLESIZE 1024
#define HASHTABLEMASK 1023
#else
#define HASHTABLESIZE 256
#define HASHTABLEMASK 255
#endif

Item
XtentStringToQuarkItem (name, new)
register char *name;
int new;
{
	/*
	 * Permanent memory allocation
	 */
	static int NEVERFREETABLESIZE = (256 * ITEM_LENGTH);
	static char *neverFreeTable = NULL;
	static int   neverFreeTableSize = 0;
	static Item  itemTable[HASHTABLESIZE];
	static ItemRec null_item;
	/*
	 * local memory allocation
	 */
	register Signature sig = 0;
	register Signature scale = 27;
	register char *tname;
	register Item np;
	register char *npn;
	Item *hashp;

#ifndef XTENT_USE_OLD_HASH_SCHEME_FROM_X
/*
 * this is a hashing scheme described in Pearson, Peter.
 * Fast Hashing of Variable Length Text Strings,
 * Communications of the ACM 33, 6 (June 1990), 677-681.
 */
	static unsigned char T[] =
	{
		  1,  14, 110,  25,  97, 174, 132, 119,
		138, 170, 125, 118,  27, 233, 140,  51,

		 87, 197, 177, 107, 234, 169,  56,  68,
		 30,   7, 173,  73, 188,  40,  36,  65,

		 49, 213, 104, 190,  57, 211, 148, 223,
		 48, 115,  15,   2,  67, 186, 210,  28,

		 12, 181, 103,  70,  22,  58,  75,  78,
		183, 167, 238, 157, 124, 147, 172, 144,

		176, 161, 141,  86,  60,  66, 128,  83,
		156, 241,  79,  46, 168, 198,  41, 254,

		178,  85, 253, 237, 250, 154, 133,  88,
		 35, 206,  95, 116, 252, 192,  54, 221,

		102, 218, 255, 240,  82, 106, 158, 201,
		 61,   3,  89,   9,  42, 155, 159,  93,

		166,  80,  50,  34, 175, 195, 100,  99,
		 26, 150,  16, 145,   4,  33,   8, 189,

		121,  64,  77,  72, 208, 245, 130, 122,
		143,  55, 105, 134,  29, 164, 185, 194,

		193, 239, 101, 242,   5, 171, 126,  11,
		 74,  59, 137, 228, 108, 191, 232, 139,

		  6,  24,  81,  20, 127,  17,  91,  92,
		251, 151, 225, 207,  21,  98, 113, 112,

		 84, 226,  18, 214, 199, 187,  13,  32,
		 94, 220, 224, 212, 247, 204, 196,  43,

		249, 236,  45, 244, 111, 182, 153, 136,
		129,  90, 217, 202,  19, 165, 231,  71,

		230, 142,  96, 227,  62, 179, 246, 114,
		162,  53, 160, 215, 205, 180,  47, 109,

		 44,  38,  31, 149, 135,   0, 216,  52,
		 63,  23,  37,  69,  39, 117, 146, 184,

		163, 200, 222, 235, 248, 243, 219,  10,
		152, 131, 123, 229, 203,  76, 120, 209
	};
#endif
	if (name == NULL)
		return & null_item;
	
#ifdef XTENT_USE_OLD_HASH_SCHEME_FROM_X
	/* 
	 * Compute string signature (sparse 32-bit hash value)
	 */
	for (tname = name; *tname != '\0';)
		sig = sig * scale + (unsigned int) * tname++;
#else
	for (tname = name; *tname != '\0';)
		sig = T[ sig ^ *tname++ ];
#endif
	
	/*
	 * Look for string in hash table
	 */
	hashp = &itemTable[sig & HASHTABLEMASK];
	for (np = *hashp; np != NULL; np = np -> next)
	{
		if (np -> sig == sig)
		{
			for (npn = np -> name, tname = name;
			     ((scale = *tname) != 0) &&
			     (scale == *npn);
			     ++tname, ++npn)
				;
			if (scale == *npn)
				return np;
		}
	}
	
	if (!new)
		return & null_item;
	
	/* 
	 * Not found, add string to hash table
	 */
	if (neverFreeTableSize < ITEM_LENGTH)
	{
		neverFreeTableSize = NEVERFREETABLESIZE;
		neverFreeTable = (char *) XtMalloc (neverFreeTableSize);
		NEVERFREETABLESIZE = (32 * ITEM_LENGTH);
	}
	np = (Item) neverFreeTable;
	neverFreeTable += ITEM_LENGTH;
	neverFreeTableSize -= ITEM_LENGTH;
	np -> next = *hashp;
	*hashp = np;
	np -> sig = sig;
	np -> name = name;

	return np;
}
