static char TMxtent_name_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xatom.h>
#include "xtent.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

typedef Widget (*NameMatchProc) C_P_ARGS((XrmNameList, XrmBindingList, 
					  WidgetList, int, int, int *,
					  int *));
C_PROTOS_BEGIN_EXTERN

extern char *
XtentWidgetToName C_P_ARGS((Widget w));

static Widget
MatchExactChildren C_P_ARGS((XrmNameList names, XrmBindingList bindings,
			     WidgetList children, int num, int in_depth,
			     int *out_depth, int *found_depth));

static Widget
MatchWildChildren C_P_ARGS((XrmNameList names, XrmBindingList bindings,
			    WidgetList children, int num, int in_depth,
			    int *out_depth, int *found_depth));

static Widget
SearchChildren C_P_ARGS((Widget root, XrmNameList names,
			 XrmBindingList bindings, NameMatchProc matchproc,
			 int in_depth, int *out_depth, int *found_depth));

static Widget
NameListToWidget C_P_ARGS((Widget root, XrmNameList names,
			   XrmBindingList bindings, int in_depth,
			   int *out_depth, int *found_depth));

static int
XtentStringToBindingQuarkList C_P_ARGS((char *name, XrmBindingList bindings,
					XrmQuarkList quarks, int count));

extern void
XtentCompileParseQuarks C_P_ARGS((char *string_zero, XrmQuark *quark_array,
				  XrmBinding *binding_array, int *count));

extern Widget
_xtentNameToWidget C_P_ARGS((Display * display, Widget * toplevel_ptr,
			     char *buffer, char *element, char *string_one,
			     XrmQuark *quarks, XrmBinding *bindings,
			     int count));

extern Widget
XtentNameToWidget C_P_ARGS((char *widget_name));

C_PROTOS_END_EXTERN

/*
 * convert a widget to its printed name
 */
typedef struct NameCollector
{
    char *name;
    int length;
    struct NameCollector   *next;
} NameCollector;

char *
XtentWidgetToName (w)
Widget w;
{
    NameCollector * local_name;
    NameCollector * top_name = (NameCollector *) NULL;
    int length;
    static char *name = (char *) NULL;
    static int name_length = 0;
    Widget parent;
    XtentShellRecord * shell_ptr;
    char *ptr;

    if (w == (Widget) NULL)
    {
	XtentWarningMessage ("Null widget given to name to widget.");
	return "";
    }

    length = 0;
    while (w)
    {
	local_name = (NameCollector *) XtMalloc (sizeof (NameCollector));
	local_name -> name = XrmQuarkToString (w -> core.xrm_name);
	local_name -> length = strlen (local_name -> name);
	length += local_name -> length + 1;
	local_name -> next = top_name;
	top_name = local_name;
	parent = w;
	w = XtParent (w);
    }

    for (shell_ptr = XtentShells; shell_ptr; shell_ptr = shell_ptr -> next)
    {
	if (parent == shell_ptr -> w)
	{
	    local_name = (NameCollector *) XtMalloc
		(sizeof (NameCollector));
	    local_name -> name = shell_ptr -> name;
	    local_name -> length = strlen (local_name -> name);
	    length += local_name -> length + 1;
	    local_name -> next = top_name -> next;
	    top_name -> next = local_name;
	}
    }

    if (length > name_length)
    {
	name = (char *) XtRealloc (name, length);
	name_length = length;
    }
    ptr = name;
    while (top_name)
    {
	strcpy (ptr, top_name -> name);
	ptr += top_name -> length;
	*ptr++ = '.';
	local_name = top_name;
	top_name = top_name -> next;
	XtFree ((char *) local_name);
    }
    if (name < ptr)
	*(ptr - 1) = '\0';

    return name;
}

/*
 * common logic for converting a resource line to a widget
 */
static Widget
MatchExactChildren(names, bindings, children, num,
	in_depth, out_depth, found_depth)
    XrmNameList     names;
    XrmBindingList  bindings;
    register WidgetList children;
    register int num;
    int in_depth, *out_depth, *found_depth;
{
    register Cardinal   i;
    register XrmName    name = *names;
    Widget w, result = NULL;
    int d, min = 10000;

    for (i = 0; i < num; i++) {
	if (name == children[i]->core.xrm_name) {
	    w = NameListToWidget(children[i], &names[1], &bindings[1],
		    in_depth+1, &d, found_depth);
	    if (w != NULL && d < min) {result = w; min = d;}
	}
    }
    *out_depth = min;
    return result;
}

static Widget
MatchWildChildren(names, bindings, children, num,
	in_depth, out_depth, found_depth)
    XrmNameList     names;
    XrmBindingList  bindings;
    register WidgetList children;
    register int num;
    int in_depth, *out_depth, *found_depth;
{
    register Cardinal   i;
    Widget w, result = NULL;
    int d, min = 10000;

    for (i = 0; i < num; i++) {
	w = NameListToWidget(children[i], names, bindings,
		in_depth+1, &d, found_depth);
	if (w != NULL && d < min) {result = w; min = d;}
    }
    *out_depth = min;
    return result;
}

static Widget
SearchChildren(root, names, bindings, matchproc,
	in_depth, out_depth, found_depth)
    Widget root;
    XrmNameList     names;
    XrmBindingList  bindings;
    NameMatchProc matchproc;
    int in_depth;
int *out_depth;
int *found_depth;
{
    Widget w1, w2;
    int d1, d2;

    if (XtIsComposite(root)) {
	w1 = (*matchproc)(names, bindings,
		((CompositeWidget) root)->composite.children,
		((CompositeWidget) root)->composite.num_children,
		in_depth, &d1, found_depth);
    } else d1 = 10000;
    w2 = (*matchproc)(names, bindings, root->core.popup_list,
	    root->core.num_popups, in_depth, &d2, found_depth);
    *out_depth = (d1 < d2 ? d1 : d2);
    return (d1 < d2 ? w1 : w2);
}

static Widget
NameListToWidget(root, names, bindings, in_depth, out_depth, found_depth)
register Widget root;
XrmNameList     names;
XrmBindingList  bindings;
int in_depth, *out_depth, *found_depth;
{
    Widget w1, w2;
    int d1, d2;

    if (in_depth >= *found_depth) {
	*out_depth = 10000;
	return NULL;
    }

    if (names[0] == NULLQUARK) {
	*out_depth = *found_depth = in_depth;
	return root;
    }

    if (! XtIsWidget(root)) {
	*out_depth = 10000;
	return NULL;
    }

    if (*bindings == XrmBindTightly) {
	return SearchChildren(root, names, bindings, MatchExactChildren,
		in_depth, out_depth, found_depth);

    } else {	/* XrmBindLoosely */
	w1 = SearchChildren(root, names, bindings, MatchExactChildren,
		in_depth, &d1, found_depth);
	w2 = SearchChildren(root, names, bindings, MatchWildChildren,
		in_depth, &d2, found_depth);
	*out_depth = (d1 < d2 ? d1 : d2);
	return (d1 < d2 ? w1 : w2);
    }
} /* NameListToWidget */

static int
XtentStringToBindingQuarkList (name, bindings, quarks, count)
register char *name;
register XrmBindingList bindings;   /* RETURN */
register XrmQuarkList  quarks;     /* RETURN */
int count;
{
    register XrmBinding binding;
    register char       ch;
    char *start_ptr;

    if (name != NULL)
    {
	binding = XrmBindTightly;
	for (start_ptr = name; ((ch = *name) != '\0'); name++)
	{
	    if (ch == '.' || ch == '*')
	    {
		if (name != start_ptr)
		{
		    /* Found a complete name */
		    if (count <= 0)
			return 0;
		    *bindings = binding;
		    bindings++;
		    *name = '\0';
		    *quarks = XrmStringToQuark(start_ptr);
		    *name = ch;
		    quarks++;
		    binding = XrmBindTightly;
		    count--;
		}
		if (ch == '*') binding = XrmBindLoosely;
		start_ptr = name + 1;
	    }
	}
	/*
	 * Do last name
	 */
	if (name != start_ptr)
	{
	    if (count <= 0)
		return 0;
	    *bindings = binding;
	    *quarks = XrmStringToQuark(start_ptr);
	    quarks++;
	    count--;
	}
    }
    if (count <= 0)
	return 0;
    *quarks = NULLQUARK;
    return count;
} /* XrmStringToBindingQuarkList */

void
XtentCompileParseQuarks (string_zero, quark_array, binding_array, count)
char *string_zero;
XrmQuark *quark_array;
XrmBinding *binding_array;
int *count;
{
    register int i;
    register char * val_ptr;
    register char * arg_ptr;
    int j;
    int end = *count;
    char mark;
    XrmBinding binding;

    arg_ptr = string_zero;
    binding = XrmBindTightly;
    for (i = 0, j = 0; i < end; i++)
    {
	val_ptr = (char *) quark_array[i];
	if (binding_array[i] == XrmBindLoosely)
	    binding = XrmBindLoosely;
	/*
	 * *arg_ptr != '.' and *arg_ptr != '*'
	 */
	if (arg_ptr != val_ptr)
	{
	    mark = *val_ptr;
	    *val_ptr = '\0';
	    quark_array[j] = XrmStringToQuark (arg_ptr);
	    *val_ptr = mark;
	    binding_array[j] = binding;
	    j++;
	    binding = XrmBindTightly;
	}
	arg_ptr = val_ptr + 1;
    }
    quark_array[j] = (XrmQuark) NULL;
    *count = j;
}

Widget
_xtentNameToWidget (display, toplevel_ptr, buffer, element,
		    string_one, quarks, bindings, count)
Display * display;
Widget * toplevel_ptr;
char *buffer;
char *element;
char *string_one;
XrmQuark *quarks;
XrmBinding *bindings;
int count;
{
    /*
     * character oriented cache
     */
    static Widget cache_widget = (Widget) NULL;
    static char cache_widget_name[256];
    static int cache_widget_length = 0;
    /*
     * data for the quark oriented cache
     */
    static int cache_widget_array_size = 0;
    static XrmQuark *cache_widget_quarks = (XrmQuarkList) NULL;
    static XrmBinding *cache_widget_bindings = (XrmBindingList) NULL;
    static Widget *cache_quark_widgets = (Widget *) NULL;
    /*
     * data for bindings from strings - allocate the first time though
     */
    static int local_array_size = 0;
    static XrmQuarkList local_quarks = (XrmQuarkList) NULL;
    static XrmBindingList local_bindings = (XrmBindingList) NULL;

    Widget parent, w;
    char mark;
    int depth, found, offset, i;
    int length = element - buffer - 1;
    Boolean flush = False;
    Boolean matched_all = False;

    /*
     * do the easy cases - toplevel
     */
    if (element == buffer || *buffer == '\0' || count == 1 || count == -1)
    {
	if (count == -1)
	{
	    cache_widget = (Widget) NULL;
	    if (cache_widget_quarks)
	    {
		cache_widget_quarks[0] = (XrmQuark) NULL;
		cache_widget_bindings[0] = (XrmBinding) NULL;
		cache_quark_widgets[0] = (Widget) NULL;
	    }
	}
	return XtentToplevel (display, toplevel_ptr);
    }

    /*
     * last cached widget
     */
    if (cache_widget &&
	cache_widget_length == length &&
	(strncmp (cache_widget_name, buffer, cache_widget_length) == 0))
    {
	w = cache_widget;
	if (count < 0)
	{
	    cache_widget = (Widget) NULL;
	    if (cache_widget_quarks)
	    {
		cache_widget_quarks[0] = (XrmQuark) NULL;
		cache_widget_bindings[0] = (XrmBinding) NULL;
		cache_quark_widgets[0] = (Widget) NULL;
	    }
	}
	return w;
    }
    
    /*
     * convert to quarks for search
     */
    if (count)			/* from xtent parse */
    {
	if (count < 0)
	{
	    flush = True;
	    count = count * -1;
	}
	
	quarks++; bindings++; count--;
	XtentCompileParseQuarks (string_one, quarks, bindings, &count);
	if (count < 1)
	{
	    if (flush)
	    {
		cache_widget = (Widget) NULL;
		if (cache_widget_quarks)
		{
		    cache_widget_quarks[0] = (XrmQuark) NULL;
		    cache_widget_bindings[0] = (XrmBinding) NULL;
		    cache_quark_widgets[0] = (Widget) NULL;
		}
	    }
	    return XtentToplevel (display, toplevel_ptr);
	}
    }
    else			/* from string */
    {
	if (element)
	{
	    element--;
	    mark = *element;
	    *element = '\0';
	}
	else
	{
	    element = buffer + strlen (buffer);
	    mark = *element;
	}
	while ((depth = XtentStringToBindingQuarkList (buffer,
						       local_bindings,
						       local_quarks,
						       local_array_size)) == 0)
	{
	    local_array_size += 16;
	    local_bindings = (XrmBindingList)
		XtRealloc ((char *) local_bindings,
			   local_array_size * sizeof (XrmBinding));
	    local_quarks = (XrmQuarkList)
		XtRealloc ((char *) local_quarks,
			   local_array_size * sizeof (XrmQuark));
	}
	*element = mark;
	bindings = local_bindings;
	quarks = local_quarks;
	count = local_array_size - depth;
    }
    
    /*
     * check the quark cache
     */
    if (cache_widget_quarks)
    {
	offset = -1;
	for (i = 0; i < count; i++)
	{
	    if (!(cache_widget_quarks[i] == quarks[i] &&
		  cache_widget_bindings[i] == bindings[i]))
		break;
	    if (cache_quark_widgets[i])
		offset = i;
	}
	matched_all = (i == count);
	if (offset == -1)
	{
	    offset = 0;
	    parent = XtentToplevel (display, toplevel_ptr);
	}
	else
	{
	    if (offset == (count - 1))
	    {
		w = cache_quark_widgets[offset];
		if (flush)
		    cache_quark_widgets[offset] = (Widget) NULL;
		return w;
	    }
	    parent = cache_quark_widgets[offset];
	    offset++;
	}
    }
    else
    {
	offset = 0;
	parent = XtentToplevel (display, toplevel_ptr);
    }

    /*
     * search for the widget in the widget tree
     */
    depth = 0;
    found = 10000;
    w = NameListToWidget (parent,
			  quarks + offset, bindings + offset,
			  0, &depth, &found);
    
    /*
     * look at all shell widgets
     */
    if (w == (Widget) NULL)
    {
	XtentShellRecord * shell_ptr;
	char *ptr;

	offset = 0;
	flush = True;

	while (*buffer == '.')
	    buffer++;

	for (shell_ptr = XtentShells;
	     shell_ptr && w == (Widget) NULL;
	     shell_ptr = shell_ptr -> next)
	{
	    if (strncmp (shell_ptr -> name, buffer,
			 shell_ptr -> length))
		continue;
	    
	    if (buffer + shell_ptr -> length == element)
		w = shell_ptr -> w;
	    else
	    {
		offset = 1;
		for (ptr = shell_ptr -> name; *ptr; ptr++)
		    if (*ptr == '.' || *ptr == '*')
			offset++;
		depth = 0;
		found = 10000;
		w = NameListToWidget (shell_ptr -> w,
				      quarks + offset, bindings + offset, 0,
				      &depth, &found);
	    }
	}
	if (w == NULL)
	{
	    if (bindings[count] == (XrmBinding) 0x17)
		return w;
	    element = XtentProgramName ();
	    fprintf (stderr, "%s: Using toplevel widget for \"%s\".\n",
		     element, buffer);
	    return XtentToplevel (display, toplevel_ptr);
	}
    }
    
    /*
     * cache this widget
     */
    if (flush == True)
	    return w;

    if (length < 256)
    {
	cache_widget = w;
	cache_widget_length = length;
	memcpy (cache_widget_name, buffer, cache_widget_length);
    }
    if (count >= cache_widget_array_size)
    {
	i = cache_widget_array_size;
	if (count < cache_widget_array_size + 16)
	    cache_widget_array_size += 16;
	else
	    cache_widget_array_size = count + 16;
	
	cache_widget_bindings = (XrmBindingList)
	    XtRealloc ((char *) cache_widget_bindings,
		       cache_widget_array_size * sizeof (XrmBinding));
	cache_widget_quarks = (XrmQuarkList)
	    XtRealloc ((char *) cache_widget_quarks,
		       cache_widget_array_size * sizeof (XrmQuark));
	cache_quark_widgets = (Widget *)
	    XtRealloc ((char *) cache_quark_widgets,
		       cache_widget_array_size * sizeof (Widget));
	for (; i < cache_widget_array_size; i++)
	{
	    cache_widget_quarks[i] = (XrmQuark) NULL;
	    cache_quark_widgets[i] = (Widget) NULL;
	}
    }
    for (i = offset; i < count; i++)
    {
	cache_widget_quarks[i] = quarks[i];
	cache_widget_bindings[i] = bindings[i];
	cache_quark_widgets[i] = (Widget) NULL;
    }
    if (count)
	cache_quark_widgets[count - 1] = w;
    if (!matched_all)
    {
	cache_widget_quarks[i] = (XrmQuark) NULL;
	cache_widget_bindings[i] = (XrmBinding) NULL;
	cache_quark_widgets[i] = (Widget) NULL;
    }
    return w;
}

Widget
XtentNameToWidget (widget_name)
char *widget_name;
{
    char *end_pointer;

    end_pointer = widget_name + strlen (widget_name);
    if (end_pointer != widget_name)
	end_pointer++;

    return _xtentNameToWidget (XtentDisplay (), XtentToplevelPtr (),
			       widget_name, end_pointer,
			       NULL, NULL, NULL, 0);
}
