static char TMxtent_data_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xtent.h"

#ifdef ___JUST_A_COMMENT___
typedef struct XtentNamedResourceList
{
    struct XtentNamedResourceList *next;
    int count;
    XtResource **resources;
    char list_name[1];
} XtentNamedResourceList;

typedef struct _XtResource {
    String	resource_name;	/* Resource name			    */
    String	resource_class;	/* Resource class			    */
    String	resource_type;	/* Representation type desired		    */
    Cardinal	resource_size;	/* Size in bytes of representation	    */
    Cardinal	resource_offset;/* Offset from base to put resource value   */
    String	default_type;	/* representation type of specified default */
    XtPointer	default_addr;	/* Address of default resource		    */
} XtResource, *XtResourceList;
#endif


/*
 *  Function prototypes used in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern int
XtentConvertCtoResources C_P_ARGS((Widget w, XtPointer ptr,
				   XtentNamedResourceList * NamedResourceLists,
				   char *c_data_type_name,
				   char *base_resource_name));

C_PROTOS_END_EXTERN

int
XtentConvertCtoResources (w, ptr, NamedResourceLists,
			  c_data_type_name, base_resource_name)
Widget w;
XtPointer ptr;
XtentNamedResourceList * NamedResourceLists;
char *c_data_type_name;
char *base_resource_name;
{
    XtentNamedResourceList *list;
    int base_resource_name_length;
    int resource_name_length;
    int i;
    XrmValue from_value, to_value;
    Display *display = XtDisplay (w);
    XrmDatabase db = XtDatabase(display);
    int return_value = True;
    char *buffer = (char *) NULL;
    int buffer_length = 0;
    char *new_type;
    int type_offset;
    int direct;

    /*
     * retrieve the named XtResource struct
     */
    list = NamedResourceLists;
    while (list)
    {
	if (strcmp (c_data_type_name, list -> list_name) == 0)
	    break;

	list = list -> next;
    }
    if (list == (XtentNamedResourceList *) NULL)
    {
	fprintf (stderr,
	 "%s: Could not find type conversion info for: \"%s\".\n",
		 XtentProgramName (),
		 c_data_type_name);

	return False;
    }

    /*
     * store the length of the base resource name
     */
    base_resource_name_length = strlen (base_resource_name);

    /*
     * do the conversion and add the result to the resource data base
     */
    for (i = 0; i < list -> count; i++)
    {
	if (strncmp (list -> resources[i] -> resource_type, "direct:", 7) == 0)
	{
	    type_offset = 7;
	    new_type = (char *)
		list -> resources[i] -> resource_type + type_offset;

	    while (*new_type == ' ' || *new_type == '\t')
	    {
		new_type++;
		type_offset++;
	    }
	    direct = True;
	}
	else
	{
	    direct = False;
	    type_offset = 0;
	}

	if (strncmp (list -> resources[i] -> resource_type + type_offset,
		     "struct:", 7) == 0)
	{
	    XtPointer *x;

	    new_type = (char *)
		list -> resources[i] -> resource_type + type_offset + 7;

	    while (*new_type == ' ' || *new_type == '\t')
		new_type++;

	    sprintf (buffer, "%s.%s", base_resource_name,
		     list -> resources[i] -> resource_name);

	    /* RAD - cast ptr to unsigned char* */
	    x = (XtPointer *)
		((unsigned char *) ptr + list -> resources[i] -> resource_offset);
	    if (direct == False)
		x = (XtPointer *) *x;
	    return_value = XtentConvertCtoResources (w, (XtPointer) x,
						     NamedResourceLists,
						     new_type, buffer);
	    if (return_value == False)
		break;

	    continue;
	}

	if (strcmp (list -> resources[i] -> resource_type + type_offset,
		    "String") == 0)
	{
	    to_value.size = 1;
	    if (direct)
		to_value.addr = (XtPointer)
		       ((unsigned char *) ptr + list -> resources[i] -> resource_offset);
			    /* RAD - cast ptr to unsigned char* */
	    else
		to_value.addr =
		    * ((XtPointer *)
		       ((unsigned char *) ptr + list -> resources[i] -> resource_offset));
			    /* RAD - cast ptr to unsigned char* */
	    
	    if (to_value.addr == NULL)
		to_value.addr = list -> resources[i] -> default_addr;
	}
	else
	{
	    if (direct)
		from_value.addr = (XtPointer) ((unsigned char *) &ptr +
		    list -> resources[i] -> resource_offset);
			    /* RAD - cast ptr to unsigned char* */
	    else
		from_value.addr = (caddr_t) ((unsigned char *) ptr +
		    list -> resources[i] -> resource_offset);
			    /* RAD - cast ptr to unsigned char* */
	    from_value.size = list -> resources[i] -> resource_size;

	    if (from_value.addr == NULL)
	    {
		to_value.size = 1;
		to_value.addr = list -> resources[i] -> default_addr;
	    }
	    else
	    {
		to_value.size = 0;
		to_value.addr = (caddr_t) NULL;

		XtConvert (w,
			   list -> resources[i] -> resource_type +
			   type_offset, &from_value,
			   XtRString, &to_value);
	    }
	}

	if (to_value.size && to_value.addr)
	{
	    resource_name_length =
		strlen (list -> resources[i] -> resource_name);
	    /*
	     * allocate a buffer that will hopefully be able to
	     *  handle all strings
	     */
	    if (2 + resource_name_length + base_resource_name_length >
		buffer_length)
	    {
		buffer_length = resource_name_length +
		    base_resource_name_length + 64;
		buffer = (char *) XtRealloc (buffer, buffer_length);
	    }
	    
	    sprintf (buffer, "%s.%s", base_resource_name,
		     list -> resources[i] -> resource_name);
	    XtentXrmPutStringResource (&db,
				       buffer, to_value.addr, 30);
	}
	else
	{
	    fprintf (stderr,
	"%s: Could not do type conversion for: \"%s\" field %d, \"%s\".\n",
		     XtentProgramName (),
		     c_data_type_name, i,
		     list -> resources[i] -> resource_name);
	    return_value = False;
	    break;
	}
    }

    XtFree (buffer);

    return return_value;
}
