static char TMxtent_cvt_c[] = "<%W%	%D% %T%>"; 
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#endif /* MOTIF */

#ifdef OPENLOOK
#include <Xol/OpenLookP.h>  /* RAD - contains OL_VERSION */
#include <Xol/ScrollingL.h>
#include <Xol/OlCursors.h>
#include <Xol/TextEdit.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#endif /* HP_WIDGETS */

#include "CreateTile.h"		/* Xw tile names */
#include "xtent.h"

#ifdef MOTIF
#include "xtent_wdgts.h"
#endif /* MOTIF */

#ifndef MIN
#define MIN(x, y)		((x) <= (y) ? (x) : (y))
#define MAX(x, y)		((x) >= (y) ? (x) : (y))
#endif

/*
 * converter return macros of various flavors
 */
#ifndef XtConverterReturn
#define XtConverterReturn(type, value, to) \
{								\
	if (to->addr != (XtPointer)NULL) {			\
		if (to->size < (unsigned int)sizeof(type)) {	\
			to->size = (unsigned int) sizeof(type);	\
			return (False);				\
		}						\
		*(type*)(to->addr) = value;			\
	} else {						\
		to->addr = (XtPointer)&value;			\
	}							\
	to->size = (unsigned int)sizeof(type);			\
	return(True);						\
}
#endif /* XtConverterReturn */

#define	xtentConverterReturnString(to, value, length) \
	{							\
		to->size = length;				\
		to->addr = (XtPointer) value;			\
		return True;					\
	}

/*
 * touched up converters from Xt - CvtStringToPixel(), CvtStringToCursor(),
 *		and new CvtCursorToString().
 */
#define	done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

/*
 * types used in this file
 */
typedef struct ImageEntry
{
    struct ImageEntry *next;
    XImage *image;
    char name[1];		/* arbitrary length */
} ImageEntry;
static ImageEntry *ImageList = (ImageEntry *) NULL;

typedef struct PixmapEntry
{
    struct PixmapEntry *next;
    Pixmap pixmap;
    char name[1];		/* arbitrary length */
} PixmapEntry;
static PixmapEntry *PixmapList = (PixmapEntry *) NULL;

typedef struct BitmapEntry
{
    struct BitmapEntry *next;
    Pixmap bitmap;
    char name[1];		/* arbitrary length */
} BitmapEntry;
static BitmapEntry *BitmapList = (BitmapEntry *) NULL;

typedef Cursor (*CursorProc) C_P_ARGS((Widget));

typedef struct XtentCursorName
{
    char *name;
    unsigned int shape;
    CursorProc get_cursor;
    Cursor cursor;
} XtentCursorName;

typedef struct CursorEntry
{
    struct CursorEntry *next;
    Cursor cursor;
    XtentCursorName *np;
    char name[1];		/* arbitrary length */
} CursorEntry;
static CursorEntry *CursorList = (CursorEntry *) NULL;

typedef struct ColormapEntry
{
    struct ColormapEntry *next;
    Colormap colormap;
    char name[1];		/* arbitrary length */
} ColormapEntry;
static ColormapEntry *ColormapList = (ColormapEntry *) NULL;

typedef XImage *XImagePtr;

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern XImage *
XtentReadImage C_P_ARGS((Display *display, char *filename,
			 C_Promoted_Char type, int new_colormap));

static Boolean
xtentCvtStringToImage C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtImageToString C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));

extern Pixmap
XtentReadPixmap C_P_ARGS((Display *display, char *filename,
			  C_Promoted_Char type, int new_colormap));

static Boolean
xtentCvtStringToPixmap C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtPixmapToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToBitmap C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtBitmapToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToColormap C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtColormapToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToAtom C_P_ARGS((Display *display, XrmValue *args,
			       Cardinal *num_args, XrmValuePtr from_val,
			       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtAtomToString C_P_ARGS((Display *display, XrmValue *args,
			       Cardinal *num_args, XrmValuePtr from_val,
			       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToWindow C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtWindowToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToWidget C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtWidgetToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToWidgetList C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtWidgetListToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static int
CompareISOLatin1 C_P_ARGS((char *first, char *second));

static Boolean
CvtStringToPixel C_P_ARGS((Display* dpy, XrmValuePtr args,
			   Cardinal *num_args, XrmValuePtr fromVal,
			   XrmValuePtr toVal, XtPointer *closure_ret));

static void
FreePixel C_P_ARGS((XtAppContext app, XrmValuePtr toVal, XtPointer closure,
		    XrmValuePtr args, Cardinal *num_args));

static void
FetchDisplayArg C_P_ARGS((Widget widget, Cardinal *size, XrmValue* value));

static Boolean
CvtStringToCursor C_P_ARGS((Display* dpy, XrmValuePtr args, Cardinal *num_args,
			    XrmValuePtr fromVal, XrmValuePtr toVal,
			    XtPointer *closure_ret));

static Boolean
CvtCursorToString C_P_ARGS((Display* dpy, XrmValuePtr args, Cardinal *num_args,
			    XrmValuePtr fromVal, XrmValuePtr toVal,
			    XtPointer *closure_ret));

static void
FreeCursor C_P_ARGS((XtAppContext app, XrmValuePtr toVal, XtPointer closure,
		     XrmValuePtr args, Cardinal *num_args));

static Boolean
xtentCvtStringToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtDimensionToString C_P_ARGS((Display *display, XrmValue *args,
				    Cardinal *num_args, XrmValuePtr from_val,
				    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtPositionToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtCharToString C_P_ARGS((Display *display, XrmValue *args,
			       Cardinal *num_args, XrmValuePtr from_val,
			       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToChar C_P_ARGS((Display *display, XrmValue *args,
			       Cardinal *num_args, XrmValuePtr from_val,
			       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtShortToString C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtIntToString C_P_ARGS((Display *display, XrmValue *args,
			      Cardinal *num_args, XrmValuePtr from_val,
			      XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtPixelToString C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtCardinalToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtFloatToString C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtBooleanToString C_P_ARGS((Display *display, XrmValue *args,
				  Cardinal *num_args, XrmValuePtr from_val,
				  XrmValuePtr to_val, XtPointer data));

extern void
XtentAddConverters C_P_NO_ARGS();

static XImage *
BitmapFileToXImage C_P_ARGS((Display *display, char *filename));

static Pixel
ColorNameToPixel C_P_ARGS((char *color));

static Pixmap
BitmapFileToPixmap C_P_ARGS((Display *display, char *filename,
			     int *ret_width, int *ret_height));

static Pixmap
BitmapToPixmap C_P_ARGS((Display *display, Pixmap bitmap, Pixel foreground,
			 Pixel background, int width, int height));

static Pixmap
ImageToBitmap C_P_ARGS((Display *display, XImage *image));

static Pixmap
PixmapToBitmap C_P_ARGS((Display *display, Pixmap pixmap, int width,
			 int height));

static int
ImageToBitmapFile C_P_ARGS((Display *display, XImage *image, int x_hot,
			    int y_hot, char *filename));

static int
PixmapToBitmapFile C_P_ARGS((Display *display, Pixmap pixmap, int width,
			     int height, int x_hot, int y_hot,
			     char *filename));

extern int
XtentScaleImage C_P_ARGS((Display *display, char *in_name, int out_width,
			  int out_height, char *out_name));

static XImage *
LocalCreateImage C_P_ARGS((Display *display, int out_width, int out_height));

extern void
XtentWriteImage C_P_ARGS((Display *display, char *image_name, char *filename,
			  C_Promoted_Char type, char *colormap_name));

extern void
XtentWritePixmap C_P_ARGS((Display *display, char *pixmap_name, char *filename,
			   C_Promoted_Char type, char *colormap_name));

extern void
XtentFreeImage C_P_ARGS((Display *display, char *image_name));

extern void
XtentFreePixmap C_P_ARGS((Display *display, char *pixmap_name));

extern Cursor
XtentCreateImageCursor C_P_ARGS((Display *display, char *image_name,
				 char *image_mask_name,
				 char *fg_color, char *bg_color,
				 char *x, char *y));

extern void
XtentFreeImageCursor C_P_ARGS((Display *display, char *image_name,
			       char *image_mask_name,
			       char *fg_color, char *bg_color,
			       char *x, char *y));

extern void
XtentCreateColormap C_P_ARGS((Display *display, char *colormap_name));

extern void
XtentFreeColormap C_P_ARGS((Display *display, char *colormap_name));

extern char *
XtentNextImageName C_P_NO_ARGS();

static char *
XtentNextPixmapName C_P_NO_ARGS();

static char *
XtentNextColormapName C_P_NO_ARGS();

static ImageEntry *
StoreImage C_P_ARGS((char *name, XImage *image));

static PixmapEntry *
StorePixmap C_P_ARGS((char *name, Pixmap pixmap));

static BitmapEntry *
StoreBitmap C_P_ARGS((char *name, Pixmap bitmap));

static CursorEntry *
StoreCursor C_P_ARGS((char *name, Cursor cursor, XtentCursorName *np));

static ColormapEntry *
StoreColormap C_P_ARGS((char *name, Colormap colormap));

extern XImage *
XtentGetImage C_P_ARGS((Display *display, Window root, XRectangle *rect,
			int store_image, char *out_name));

static void
PseudoMapToGreyMap C_P_ARGS((XColor *colors, unsigned char *greymap,
			     int size));

static void
ImageToPostScriptFile C_P_ARGS((Display *display, XImage *image,
				Colormap colormap, char *output_file));

extern long
XtentAllocColor C_P_ARGS((Display* display, char *color_map_name,
			  char *color_name));

extern void
XtentQueryPixel C_P_ARGS((Display *display, char *colormap_name, char *pixel,
			  XColor *color));

extern int
XtentFreeColor C_P_ARGS((Display* display, char *color_map_name,
			 char *color_name));

#ifdef OPENLOOK

static char *
XtentOLDefineToString C_P_ARGS((C_Promoted_Short define));

static Boolean
xtentCvtOlDefineToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static char *
XtentOLGravityToString C_P_ARGS((int gravity));

static Boolean
xtentCvtOlGravityToString C_P_ARGS((Display *display, XrmValue *args,
				    Cardinal *num_args, XrmValuePtr from_val,
				    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlWMProtocolMsgTypeToString C_P_ARGS((Display *display, XrmValue *args,
					      Cardinal *num_args,
					      XrmValuePtr from_val,
					      XrmValuePtr to_val,
					      XtPointer data));

static void
XtentOlFlatCallback C_P_ARGS((Widget widget, XtPointer client_data,
			      XtPointer call_data));

static void
XtentOlFlatOtherCallback C_P_ARGS((Widget widget, XtPointer client_data,
				   XtPointer call_data));

static Boolean
xtentCvtStringtoOlPointer C_P_ARGS((Display *display, XrmValue *args,
				    Cardinal *num_args, XrmValuePtr from_val,
				    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringtoOlFlatCallback C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr from_val,
					 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlListDeleteToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToOlWrapMode C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlWrapModeToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToOlSourceType C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlSourceTypeToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToOlEditMode C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlEditModeToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));


#if OL_VERSION >= 3 && OL_REVISION >= 2

static Boolean
xtentCvtStringToOlStrRep C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlStrRepToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOlStrToString C_P_ARGS((Display *display, XrmValue *args,
				Cardinal *num_args, XrmValuePtr from_val,
				XrmValuePtr to_val, XtPointer data));



#endif /* OL_VERSION >= 3 && OL_REVISION >= 2 */

#ifdef NEED_XrmCompileResourceList
extern void
XrmCompileResourceList C_P_ARGS((XtResourceList resources,
				 Cardinal num_resources));

#endif /* NEED_XrmCompileResourceList */

#endif /* OPENLOOK */

#ifdef MOTIF

static Boolean
xtentCvtAlignmentToString C_P_ARGS((Display *display, XrmValue *args,
				    Cardinal *num_args, XrmValuePtr from_val,
				    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtArrowDirectionToString C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr from_val,
					 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtChildPlacementToString C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr from_val,
					 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtCommandWindowLocationToString C_P_ARGS((Display *display,
						XrmValue *args,
						Cardinal *num_args,
						XrmValuePtr from_val,
						XrmValuePtr to_val,
						XtPointer data));

static Boolean
xtentCvtDefaultButtonTypeToString C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr from_val,
					    XrmValuePtr to_val,
					    XtPointer data));

static Boolean
xtentCvtDialogStyleToString C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args,
				      XrmValuePtr from_val,
				      XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtDialogueTypeToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtEditModeToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtFileTypeMaskToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtIndicatorTypeToString C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr from_val,
					XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtInitialStateToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtKeySymToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtLabelTypeToString C_P_ARGS((Display *display, XrmValue *args,
				    Cardinal *num_args, XrmValuePtr from_val,
				    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtListSizePolicyToString C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr from_val,
					 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtMultiClickToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtNavigationTypeToString C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr from_val,
					 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtOrientationToString C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args,
				      XrmValuePtr from_val,
				      XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtPackingToString C_P_ARGS((Display *display, XrmValue *args,
				  Cardinal *num_args, XrmValuePtr from_val,
				  XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtProcessingDirectionToString C_P_ARGS((Display *display,
					      XrmValue *args,
					      Cardinal *num_args,
					      XrmValuePtr from_val,
					      XrmValuePtr to_val,
					      XtPointer data));

static Boolean
xtentCvtResizePolicyToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtRowColumnTypeToString C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr from_val,
					XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtScrollBarDisplayPolicyToString C_P_ARGS((Display *display,
						 XrmValue *args,
						 Cardinal *num_args,
						 XrmValuePtr from_val,
						 XrmValuePtr to_val,
						 XtPointer data));

static Boolean

xtentCvtScrollBarPlacementToString C_P_ARGS((Display *display, XrmValue *args,
					     Cardinal *num_args,
					     XrmValuePtr from_val,
					     XrmValuePtr to_val,
					     XtPointer data));

static Boolean
xtentCvtScrollingPolicyToString C_P_ARGS((Display *display, XrmValue *args,
					  Cardinal *num_args,
					  XrmValuePtr from_val,
					  XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtSelectionPolicyToString C_P_ARGS((Display *display, XrmValue *args,
					  Cardinal *num_args,
					  XrmValuePtr from_val,
					  XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtSelectionTypeToString C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr from_val,
					XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtSeparatorTypeToString C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr from_val,
					XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtShadowTypeToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args,
				     XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringArrayToString C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args, XrmValuePtr fromVal,
				      XrmValuePtr toVal, XtPointer data));

static Boolean
xtentCvtStringDirectionToString C_P_ARGS((Display *display, XrmValue *args,
					  Cardinal *num_args,
					  XrmValuePtr from_val,
					  XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtTearOffModelToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtUnitTypeToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtVerticalAlignmentToString C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr from_val,
					    XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtVisualToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr from_val,
				 XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtVisualPolicyToString C_P_ARGS((Display *display, XrmValue *args,
				       Cardinal *num_args,
				       XrmValuePtr from_val,
				       XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtAttachmentToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args,
				     XrmValuePtr from_val,
				     XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtWidgetClassToString C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args,
				      XrmValuePtr from_val,
				      XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtStringToWidgetClass C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args,
				      XrmValuePtr from_val,
				      XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtXmStringToString C_P_ARGS((Display *display, XrmValue *args,
				   Cardinal *num_args, XrmValuePtr from_val,
				   XrmValuePtr to_val, XtPointer data));

static Boolean
xtentCvtXmStringTableToString C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr fromVal,
					XrmValuePtr toVal, XtPointer data));

extern char *
xtentXmCvtXmStringTableToString C_P_ARGS((long list, int list_count));

#endif /* MOTIF */

C_PROTOS_END_EXTERN


/*
 * begin functions
 */

#ifdef OPENLOOK

#ifdef NEED_XrmCompileResourceList

/*
 * using the X11R4 OpenLook libraries with X11R5
 */
void
XrmCompileResourceList (resources, num_resources)
XtResourceList resources;
Cardinal num_resources;
{
    _XtCompileResourceList (resources, num_resources);
}
#endif

#endif /* OPENLOOK */

/*
 * image converters
 */
XImage *
XtentReadImage (display, filename, type, new_colormap)
Display *display;
char *filename;
char type;
int new_colormap;
{
    XImage *image;
    Colormap colormap;

    switch (type)
    {
    case 'b':
	image = BitmapFileToXImage (display, filename);
	if (image)
	    StoreImage (filename, image);
	return image;
    case 't':
	image = LoadTifImage (display, DefaultScreen (display),
			      filename, new_colormap, &colormap);
	if (image)
	{
	    StoreColormap (filename, colormap);
	    StoreImage (filename, image);
	}
	return image;
    default:
	return (XImage *) NULL;
    }
}

static Boolean
xtentCvtStringToImage (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static XImage *image;
    ImageEntry *ie;
    char type;

    if (from_val -> addr == NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    for (ie = ImageList; ie; ie = ie -> next)
    {
	if (strcmp (ie -> name, (char *) from_val -> addr) == 0)
	{
	    image = ie -> image;
	    XtConverterReturn (XImagePtr, image, to_val);
	}
    }

    if (strcmp ("None", (char *) from_val -> addr) == 0 ||
	strcmp ("NULL", (char *) from_val -> addr) == 0 ||
	strcmp ("XtUnspecifiedImage", (char *) from_val -> addr) == 0)
    {
	image = (XImage *) NULL;
	XtConverterReturn (XImagePtr, image, to_val);
    }

    if (strcmp ((char *) from_val -> addr +
		strlen ((char *) from_val -> addr) - 4, ".tif") == 0)
	type = 't';
    else
	type = 'b';

    image = XtentReadImage (XtentDisplay (),
			    (char *) from_val -> addr, type, FALSE);

    if (image != (XImage *) NULL)
	XtConverterReturn (XImagePtr, image, to_val);

    to_val -> addr = (XtPointer) NULL;
    to_val -> size = 0;
    return False;
}

static Boolean
xtentCvtImageToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    XImage *image;
    ImageEntry *ie;
	
    image = (XImage *) *((XImage **) from_val -> addr);

    for (ie = ImageList; ie; ie = ie -> next)
    {
	if (ie -> image == image)
	    xtentConverterReturnString (to_val, ie -> name,
					strlen (ie -> name) + 1);
    }
    if (image == (XImage *) NULL)
	xtentConverterReturnString (to_val, "None", 5);

    ie = StoreImage (XtentNextImageName (), image);
    xtentConverterReturnString (to_val, ie -> name,
				strlen (ie -> name) + 1);
}

/*
 * pixmap converters
 */
Pixmap
XtentReadPixmap (display, filename, type, new_colormap)
Display *display;
char *filename;
char type;
int new_colormap;
{
    Pixmap pixmap;
    Colormap colormap;
    int width, height;

    switch (type)
    {
    case 'b':
	pixmap = BitmapFileToPixmap (display, filename,
				     &width, &height);
	if (pixmap)
	    StorePixmap (filename, pixmap);
	return pixmap;
    case 't':
	pixmap = LoadTifPixmap (display, DefaultScreen (display),
				filename, new_colormap,
				&colormap, &width, &height);
	if (pixmap)
	{
	    StoreColormap (filename, colormap);
	    StorePixmap (filename, pixmap);
	}
	return pixmap;
    default:
	return (Pixmap) NULL;
    }
}

static Boolean
xtentCvtStringToPixmap (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Pixmap pixmap;
    PixmapEntry *pe;
    char type;

    if (from_val -> addr == NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    for (pe = PixmapList; pe; pe = pe -> next)
    {
	if (strcmp (pe -> name, (char *) from_val -> addr) == 0)
	{
	    pixmap = pe -> pixmap;
	    XtConverterReturn (Pixmap, pixmap, to_val);
	}
    }

    if (strcmp ("None", (char *) from_val -> addr) == 0 ||
	strcmp ("NULL", (char *) from_val -> addr) == 0 ||
	strcmp ("XtUnspecifiedPixmap", (char *) from_val -> addr) == 0)
    {
	pixmap = XtUnspecifiedPixmap;
	XtConverterReturn (Pixmap, pixmap, to_val);
    }

    if (strcmp ((char *) from_val -> addr +
		strlen ((char *) from_val -> addr) - 4, ".tif") == 0)
	type = 't';
    else
	type = 'b';

    pixmap = XtentReadPixmap (XtentDisplay (),
			      (char *) from_val -> addr,
			      type, FALSE);

    if (pixmap != (Pixmap) NULL)
	XtConverterReturn (Pixmap, pixmap, to_val);

    to_val -> addr = (XtPointer) NULL;
    to_val -> size = 0;
    return False;
}

static Boolean
xtentCvtPixmapToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Pixmap pixmap;
    PixmapEntry *pe;

    pixmap = (Pixmap) *((Pixmap *) from_val -> addr);

    if (pixmap == (Pixmap) NULL || pixmap == XtUnspecifiedPixmap)
	xtentConverterReturnString (to_val, "None", 5);

    for (pe = PixmapList; pe; pe = pe -> next)
    {
	if (pe -> pixmap == pixmap)
	    xtentConverterReturnString (to_val, pe -> name,
					strlen (pe -> name) + 1);
    }

    pe = StorePixmap (XtentNextPixmapName (), pixmap);
    xtentConverterReturnString (to_val, pe -> name,
				strlen (pe -> name) + 1);
}

static Boolean
xtentCvtStringToBitmap (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Pixmap bitmap;
    Pixmap pixmap;
    BitmapEntry *be;
    Colormap colormap;
    Window root;
    int ignore;
    int width, height, depth;
    char *filename = (char *) from_val -> addr;

    if (from_val -> addr == NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    for (be = BitmapList; be; be = be -> next)
    {
	if (strcmp (be -> name, filename) == 0)
	{
	    bitmap = be -> bitmap;
	    XtConverterReturn (Pixmap, bitmap, to_val);
	}
    }

    if (strcmp ("None", filename) == 0 ||
	strcmp ("NULL", filename) == 0 ||
	strcmp ("XtUnspecifiedPixmap", filename) == 0)
    {
	bitmap = XtUnspecifiedPixmap;
	XtConverterReturn (Pixmap, bitmap, to_val);
    }

    if (strcmp (filename + strlen (filename) - 4, ".tif") == 0)
	pixmap = LoadTifPixmap (display, DefaultScreen (display),
				filename, FALSE,
				&colormap, &width, &height);
    else
	pixmap = BitmapFileToPixmap (display, filename,
				     &width, &height);

    if (pixmap == (Pixmap) NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    if (XGetGeometry (display, pixmap, &root,
		      &ignore, &ignore,
		      (unsigned int *) &width,
		      (unsigned int *) &height,
		      (unsigned int *) &ignore,
		      (unsigned int *) &depth) == FALSE)
    {
	fprintf (stderr,
		 "%s: Could not get the geometry of the pixmap: %s\n",
		 XtentProgramName (), filename);
	return;
    }

    if (depth > 1)
    {
	bitmap = PixmapToBitmap (display, pixmap, width, height);
	XFreePixmap (display, pixmap);
    }
    else
	bitmap = pixmap;

    if (bitmap == (Pixmap) NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    be = StoreBitmap (filename, bitmap);
    XtConverterReturn (Pixmap, bitmap, to_val);
}

static Boolean
xtentCvtBitmapToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Pixmap bitmap;
    BitmapEntry *be;

    bitmap = (Pixmap) *((Pixmap *) from_val -> addr);
    for (be = BitmapList; be; be = be -> next)
    {
	if (be -> bitmap == bitmap)
	    xtentConverterReturnString (to_val, be -> name,
					strlen (be -> name) + 1);
    }
    if (bitmap == (Pixmap) NULL || bitmap == XtUnspecifiedPixmap)
	xtentConverterReturnString (to_val, "None", 5);

    be = StoreBitmap (XtentNextPixmapName (), bitmap);
    xtentConverterReturnString (to_val, be -> name,
				strlen (be -> name) + 1);
}

/*
 * colomap converters - goes by the same name as the associated pixmap
 */
static Boolean
xtentCvtStringToColormap (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Pixmap pixmap;
    ColormapEntry *ce;
    static Colormap colormap;

    if (from_val -> addr == NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    for (ce = ColormapList; ce; ce = ce -> next)
    {
	if (strcmp (ce -> name, (char *) from_val -> addr) == 0)
	{
	    colormap = ce -> colormap;
	    XtConverterReturn (Colormap, colormap, to_val);
	}
    }

    if (strcmp ((char *) from_val -> addr +
		strlen ((char *) from_val -> addr) - 4, ".tif") == 0)
    {
	pixmap = XtentReadPixmap (XtentDisplay (),
				  (char *) from_val -> addr,
				  't', FALSE);
	if (pixmap != (Pixmap) NULL)
	{
	    for (ce = ColormapList; ce; ce = ce -> next)
	    {
		if (strcmp (ce -> name,
			    (char *) from_val -> addr)  == 0)
		{
		    colormap = ce -> colormap;
		    XtConverterReturn(Colormap, colormap,
				      to_val);
		}
	    }
	}
    }

    if (strcmp ("None", (char *) from_val -> addr) == 0 ||
	strcmp ("NULL", (char *) from_val -> addr) == 0 ||
	strcmp ("DefaultColormap", (char *) from_val -> addr) == 0)
    {
	ce = StoreColormap ((char *) from_val -> addr,
			    DefaultColormap (XtentDisplay (),
					     DefaultScreen (XtentDisplay ())));
	colormap = ce -> colormap;
	XtConverterReturn(Colormap, colormap, to_val);
    }

    to_val -> addr = (XtPointer) NULL;
    to_val -> size = 0;
    return False;
}

static Boolean
xtentCvtColormapToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Colormap colormap;
    ColormapEntry *ce;

    colormap = (Colormap) *((Colormap *) from_val -> addr);

    for (ce = ColormapList; ce; ce = ce -> next)
    {
	if (ce -> colormap == colormap)
	    xtentConverterReturnString (to_val, ce -> name,
					strlen (ce -> name) + 1);
    }
    if (colormap == (Colormap) NULL ||
	colormap == DefaultColormap (XtentDisplay (),
				     DefaultScreen (XtentDisplay ())))
	xtentConverterReturnString (to_val, "DefaultColormap", 16);

    ce = StoreColormap (XtentNextColormapName (), colormap);
    xtentConverterReturnString (to_val, ce -> name,
				strlen (ce -> name) + 1);
}

/*
 * server atom converters
 */
static Boolean
xtentCvtStringToAtom (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Atom atom;

    if (from_val -> addr == NULL ||
	strcmp ((char *) from_val -> addr, "None") == 0 ||
	strcmp ((char *) from_val -> addr, "NULL") == 0)
	atom = (Atom) None;
    else
	atom = XInternAtom (display, (char *) from_val -> addr, False);

    XtConverterReturn (Atom, atom, to_val);
}

static Boolean
xtentCvtAtomToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Atom atom;
    char *ptr;
    
    atom = (Atom) *((Atom *) from_val -> addr);
    
    if (atom == (Atom) None)
	ptr = "None";
    else
    {
	ptr = XGetAtomName (display, atom);
	if (ptr == (char *) NULL)
	    ptr = "None";
    }
    
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

/*
 * window converters - a number
 */
static Boolean
xtentCvtStringToWindow (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Window w;
    char *ptr;

    ptr = (char *) from_val -> addr;
    if (ptr == (char *) NULL || *ptr == '\0' ||
	(strcmp (ptr, "None") == 0) ||
	(strcmp (ptr, "NULL") == 0))
	w = (Window) NULL;
    else
	w = atoi (ptr);

    XtConverterReturn (Window, w, to_val);
}

static Boolean
xtentCvtWindowToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Window w;
    static char buf[16];

    w = (Window) *((Window *) from_val -> addr);
    if (w == (Window) NULL)
	xtentConverterReturnString (to_val, "None", 5);

    sprintf (buf, "%d", w);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

/*
 * widget converters
 */
static Boolean
xtentCvtStringToWidget (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Widget w;
    char *ptr;

    ptr = (char *) from_val -> addr;
    if (ptr == (char *) NULL || *ptr == '\0' ||
	(strcmp (ptr, "None") == 0) ||
	(strcmp (ptr, "NULL") == 0))
    {
	w = (Widget) NULL;
    }
    else
    {
	Widget parent = *(Widget*) args[0].addr;
	int length = XtentProgramNameLength ();

	if (*ptr == '.' || *ptr == '*')
	{
	    parent = (Widget) NULL;
	}
	else if (strncmp (ptr, XtentProgramName (), length) == 0)
	{
	    if (ptr[length] == '.' || ptr[length] == '*')
	    {
		parent = (Widget) NULL;
		ptr += length;
	    }
	    else if (ptr[length] == '\0')
	    {
		w = XtentToplevel (XtentDisplay (), XtentToplevelPtr ());
		XtConverterReturn (Widget, w, to_val);
	    }
	}

	if (parent &&
	    parent != XtentToplevel (XtentDisplay (), XtentToplevelPtr ()))
	    w = XtNameToWidget (parent, ptr);
	else
	    w = XtentNameToWidget (ptr);
    }

     XtConverterReturn (Widget, w, to_val);
}

static Boolean
xtentCvtWidgetToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int ptr_len;
    Widget w;
    static char *buf;
    static int buf_len = 0;

    w = (Widget) *((Widget *) from_val -> addr);
    if (w == NULL)
	xtentConverterReturnString (to_val, "None", 5);

    ptr = (char *) XtentWidgetToName (w);
    if (ptr == (char *) NULL || *ptr == '\0')
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }

    if ((ptr_len = strlen (ptr) + 1) >= buf_len)
    {
	buf_len = ptr_len + 32;
	buf = (char *) XtRealloc (buf, buf_len);
    }
    memcpy (buf, ptr, ptr_len);
    xtentConverterReturnString (to_val, buf, ptr_len);
}

static Boolean
xtentCvtStringToWidgetList (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static Widget simple_list[1];
    static Widget *w_list_simple = simple_list;
    static Widget *w_list;
    static int w_list_len = 0;
    int count = 0;
    char *ptr;
    char *name;
    char end;

    ptr = (char *) from_val -> addr;
    if (ptr == (char *) NULL || *ptr == '\0' ||
	(strcmp (ptr, "None") == 0) ||
	(strcmp (ptr, "NULL") == 0))
    {
	simple_list[0] = (Widget) NULL;
	XtConverterReturn (WidgetList, w_list_simple, to_val);
    }

    name = ptr;
    for (;;)
    {
	if (*ptr == '\0' || *ptr == ' ' || *ptr == ':')
	{
	    if (count + 1 >= w_list_len)
	    {
		w_list_len += 16;
		w_list = (WidgetList)
		    XtRealloc ((char *) w_list, w_list_len);
	    }
	    end = *ptr;
	    *ptr = '\0';
	    w_list[count] = XtentNameToWidget (name);
	    *ptr = end;
	    count++;
	    if (end == '\0')
		break;
	    name = ptr + 1;
	}
	ptr++;
    }
    if (count == 0)
    {
	simple_list[0] = (Widget) NULL;
	XtConverterReturn (WidgetList, w_list_simple, to_val);
    }
    w_list[count] = (Widget) NULL;
    XtConverterReturn (WidgetList, w_list, to_val);
}

static Boolean
xtentCvtWidgetListToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
    Widget	w = *((Widget *)args[0].addr);
    char *ptr;
    int ptr_len;
    int total_len;
    WidgetList w_list;
    WidgetList w_list_end;
    static char *buf;
    static int buf_len = 0;

    w_list = (WidgetList) *((WidgetList *) fromVal -> addr);

    if (w_list == NULL)
	xtentConverterReturnString (toVal, "None", 5);

    if (!XtIsComposite (w))
	xtentConverterReturnString (toVal,
				   (XtPointer) "#Not a composite widget.", 25);

    w_list = (((CompositeWidget)w)->composite).children;
    w_list_end = w_list + (((CompositeWidget)w)->composite).num_children;

    total_len = 0;
    while (w_list < w_list_end)
    {
	ptr = (char *) XtentWidgetToName (*w_list++);

	if (ptr && *ptr != '\0')
	{
	    if ((ptr_len = strlen (ptr)) + total_len >= buf_len)
	    {
		buf_len = total_len + ptr_len + 64;
		buf = (char *) XtRealloc (buf, buf_len);
	    }
	    memcpy (&buf[total_len], ptr, ptr_len);
	    total_len += ptr_len;
	    buf[total_len] = ' ';
	    total_len++;
	}
    }
    if (total_len)
    {
	buf[total_len] = '\0';
	while (buf[total_len - 1] == ' ')
	    buf[--total_len] = '\0';
	xtentConverterReturnString (toVal, buf, total_len);
    }
    else
	xtentConverterReturnString (toVal, "None", 5);
}

/*
 * touched up converters from Xt - CvtStringToPixel(), CvtStringToCursor(),
 *		and new CvtCursorToString().
 */
static int
CompareISOLatin1 (first, second)
char *first, *second;
{
    register unsigned char *ap, *bp;

    for (ap = (unsigned char *) first, bp = (unsigned char *) second;
	 *ap && *bp; ap++, bp++) {
	register unsigned char a, b;

	if ((a = *ap) != (b = *bp)) {
	    /* try lowercasing and try again */

	    if ((a >= XK_A) && (a <= XK_Z))
	      a += (XK_a - XK_A);
	    else if ((a >= XK_Agrave) && (a <= XK_Odiaeresis))
	      a += (XK_agrave - XK_Agrave);
	    else if ((a >= XK_Ooblique) && (a <= XK_Thorn))
	      a += (XK_oslash - XK_Ooblique);

	    if ((b >= XK_A) && (b <= XK_Z))
	      b += (XK_a - XK_A);
	    else if ((b >= XK_Agrave) && (b <= XK_Odiaeresis))
	      b += (XK_agrave - XK_Agrave);
	    else if ((b >= XK_Ooblique) && (b <= XK_Thorn))
	      b += (XK_oslash - XK_Ooblique);

	    if (a != b) break;
	}
    }
    return (((int) *bp) - ((int) *ap));
}

static Boolean
CvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *closure_ret;
{
    String	    str = (String)fromVal->addr;
    XColor	    screenColor;
    XColor	    exactColor;
    Screen	    *screen;
/*
    XtPerDisplay    pd = _XtGetPerDisplay(dpy);
*/
    extern XtAppContext _XtDefaultAppContext();
    XtAppContext    app = _XtDefaultAppContext();
    Colormap	    colormap;
    Status	    status;
    String          params[1];
    Cardinal	    num_params=1;

    if (*num_args != 2)
     XtAppErrorMsg(app, "wrongParameters", "cvtStringToPixel",
		   "XtToolkitError",
	"String to pixel conversion needs screen and colormap arguments",
        (String *)NULL, (Cardinal *)NULL);

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (CompareISOLatin1(str, XtDefaultBackground) == 0) {
	*closure_ret = False;
/*
	if (pd->rv) done(Pixel, BlackPixelOfScreen(screen))
	else	    done(Pixel, WhitePixelOfScreen(screen));
*/
	done(Pixel, WhitePixelOfScreen(screen));
    }
    if (CompareISOLatin1(str, XtDefaultForeground) == 0) {
	*closure_ret = False;
/*
	if (pd->rv) done(Pixel, WhitePixelOfScreen(screen))
        else	    done(Pixel, BlackPixelOfScreen(screen));
*/
	done(Pixel, BlackPixelOfScreen(screen));
    }

    /*
     * specific pixel value
     */
    if (*str >= '0'  && *str <= '9')
    {
	    *closure_ret = False;
	    done(Pixel, atol (str));
    }

    if (*str == '#') {  /* some color rgb definition */

        status = XParseColor(DisplayOfScreen(screen), colormap,
			     (char*)str, &screenColor);

        if (status != 0)
           status = XAllocColor(DisplayOfScreen(screen), colormap,
                                &screenColor);
    } else  /* some color name */

        status = XAllocNamedColor(DisplayOfScreen(screen), colormap,
                                  (char*)str, &screenColor, &exactColor);
    if (status == 0) {
	params[0] = str;
	XtAppWarningMsg(app, "noColormap", "cvtStringToPixel",
			"XtToolkitError",
                 "Cannot allocate colormap entry for \"%s\"",
                  params,&num_params);
	return False;
    } else {
	*closure_ret = (char*)True;
        done(Pixel, screenColor.pixel);
    }
}

/* ARGSUSED */
static void
FreePixel(app, toVal, closure, args, num_args)
XtAppContext app;
XrmValuePtr toVal;
XtPointer closure;
XrmValuePtr args;
Cardinal *num_args;
{
    Screen	    *screen;
    Colormap	    colormap;

    if (*num_args != 2)
     XtAppErrorMsg(app, "wrongParameters","freePixel","XtToolkitError",
	"Freeing a pixel requires screen and colormap arguments",
        (String *)NULL, (Cardinal *)NULL);

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (closure) {
	XFreeColors( DisplayOfScreen(screen), colormap,
		     (unsigned long*)toVal->addr, 1, (unsigned long)0
		    );
    }
}

/*ARGSUSED*/
static void
FetchDisplayArg(widget, size, value)
Widget widget;
Cardinal *size;
XrmValue* value;
{
    if (widget == NULL) {
	XtErrorMsg("missingWidget", "fetchDisplayArg", "XtToolkitError",
		   "FetchDisplayArg called without a widget to reference",
		   (String*)NULL, (Cardinal*)NULL);
    }
    value->size = sizeof(Display*);
    value->addr = (XtPointer)&DisplayOfScreen(XtScreenOfObject(widget));
}

/*
 * cursor names registry
 */
static XtentCursorName cursor_names[] =
{
 {"None",		0,			0, (Cursor) 0 },
 {"NULL",		0,			0, (Cursor) 0 },
 {"DefaultCursor",	0,			0, (Cursor) 0 },
 {"X_cursor",		XC_X_cursor,		0, (Cursor) 0 },
 {"arrow",		XC_arrow,		0, (Cursor) 0 },
 {"based_arrow_down",	XC_based_arrow_down,	0, (Cursor) 0 },
 {"based_arrow_up",	XC_based_arrow_up,	0, (Cursor) 0 },
 {"boat",		XC_boat,		0, (Cursor) 0 },
 {"bogosity",		XC_bogosity,		0, (Cursor) 0 },
 {"bottom_left_corner",	XC_bottom_left_corner,	0, (Cursor) 0 },
 {"bottom_right_corner",XC_bottom_right_corner,	0, (Cursor) 0 },
 {"bottom_side",	XC_bottom_side,		0, (Cursor) 0 },
 {"bottom_tee",		XC_bottom_tee,		0, (Cursor) 0 },
 {"box_spiral",		XC_box_spiral,		0, (Cursor) 0 },
 {"center_ptr",		XC_center_ptr,		0, (Cursor) 0 },
 {"circle",		XC_circle,		0, (Cursor) 0 },
 {"clock",		XC_clock,		0, (Cursor) 0 },
 {"coffee_mug",		XC_coffee_mug,		0, (Cursor) 0 },
 {"cross",		XC_cross,		0, (Cursor) 0 },
 {"cross_reverse",	XC_cross_reverse,	0, (Cursor) 0 },
 {"crosshair",		XC_crosshair,		0, (Cursor) 0 },
 {"diamond_cross",	XC_diamond_cross,	0, (Cursor) 0 },
 {"dot",		XC_dot,			0, (Cursor) 0 },
 {"dotbox",		XC_dotbox,		0, (Cursor) 0 },
 {"double_arrow",	XC_double_arrow,	0, (Cursor) 0 },
 {"draft_large",	XC_draft_large,		0, (Cursor) 0 },
 {"draft_small",	XC_draft_small,		0, (Cursor) 0 },
 {"draped_box",		XC_draped_box,		0, (Cursor) 0 },
 {"exchange",		XC_exchange,		0, (Cursor) 0 },
 {"fleur",		XC_fleur,		0, (Cursor) 0 },
 {"gobbler",		XC_gobbler,		0, (Cursor) 0 },
 {"gumby",		XC_gumby,		0, (Cursor) 0 },
 {"hand1",		XC_hand1,		0, (Cursor) 0 },
 {"hand2",		XC_hand2,		0, (Cursor) 0 },
 {"heart",		XC_heart,		0, (Cursor) 0 },
 {"icon",		XC_icon,		0, (Cursor) 0 },
 {"iron_cross",		XC_iron_cross,		0, (Cursor) 0 },
 {"left_ptr",		XC_left_ptr,		0, (Cursor) 0 },
 {"left_side",		XC_left_side,		0, (Cursor) 0 },
 {"left_tee",		XC_left_tee,		0, (Cursor) 0 },
 {"leftbutton",		XC_leftbutton,		0, (Cursor) 0 },
 {"ll_angle",		XC_ll_angle,		0, (Cursor) 0 },
 {"lr_angle",		XC_lr_angle,		0, (Cursor) 0 },
 {"man",		XC_man,			0, (Cursor) 0 },
 {"middlebutton",	XC_middlebutton,	0, (Cursor) 0 },
 {"mouse",		XC_mouse,		0, (Cursor) 0 },
 {"pencil",		XC_pencil,		0, (Cursor) 0 },
 {"pirate",		XC_pirate,		0, (Cursor) 0 },
 {"plus",		XC_plus,		0, (Cursor) 0 },
 {"question_arrow",	XC_question_arrow,	0, (Cursor) 0 },
 {"right_ptr",		XC_right_ptr,		0, (Cursor) 0 },
 {"right_side",		XC_right_side,		0, (Cursor) 0 },
 {"right_tee",		XC_right_tee,		0, (Cursor) 0 },
 {"rightbutton",	XC_rightbutton,		0, (Cursor) 0 },
 {"rtl_logo",		XC_rtl_logo,		0, (Cursor) 0 },
 {"sailboat",		XC_sailboat,		0, (Cursor) 0 },
 {"sb_down_arrow",	XC_sb_down_arrow,	0, (Cursor) 0 },
 {"sb_h_double_arrow",	XC_sb_h_double_arrow,	0, (Cursor) 0 },
 {"sb_left_arrow",	XC_sb_left_arrow,	0, (Cursor) 0 },
 {"sb_right_arrow",	XC_sb_right_arrow,	0, (Cursor) 0 },
 {"sb_up_arrow",	XC_sb_up_arrow,		0, (Cursor) 0 },
 {"sb_v_double_arrow",	XC_sb_v_double_arrow,	0, (Cursor) 0 },
 {"shuttle",		XC_shuttle,		0, (Cursor) 0 },
 {"sizing",		XC_sizing,		0, (Cursor) 0 },
 {"spider",		XC_spider,		0, (Cursor) 0 },
 {"spraycan",		XC_spraycan,		0, (Cursor) 0 },
 {"star",		XC_star,		0, (Cursor) 0 },
 {"target",		XC_target,		0, (Cursor) 0 },
 {"tcross",		XC_tcross,		0, (Cursor) 0 },
 {"top_left_arrow",	XC_top_left_arrow,	0, (Cursor) 0 },
 {"top_left_corner",	XC_top_left_corner,	0, (Cursor) 0 },
 {"top_right_corner",	XC_top_right_corner,	0, (Cursor) 0 },
 {"top_side",		XC_top_side,		0, (Cursor) 0 },
 {"top_tee",		XC_top_tee,		0, (Cursor) 0 },
 {"trek",		XC_trek,		0, (Cursor) 0 },
 {"ul_angle",		XC_ul_angle,		0, (Cursor) 0 },
 {"umbrella",		XC_umbrella,		0, (Cursor) 0 },
 {"ur_angle",		XC_ur_angle,		0, (Cursor) 0 },
 {"watch",		XC_watch,		0, (Cursor) 0 },
 {"xterm",		XC_xterm,		0, (Cursor) 0 },

#ifdef OPENLOOK

#ifndef OLD_OPENLOOK

 {"OlGetMoveCursor",		0, OlGetMoveCursor,		(Cursor) 0 },
 {"OlGetDuplicateCursor",	0, OlGetDuplicateCursor,	(Cursor) 0 },
 {"OlGetBusyCursor",		0, OlGetBusyCursor,		(Cursor) 0 },
 {"OlGetPanCursor",		0, OlGetPanCursor,		(Cursor) 0 },
 {"OlGetQuestionCursor",	0, OlGetQuestionCursor,		(Cursor) 0 },
 {"OlGetTargetCursor",		0, OlGetTargetCursor,		(Cursor) 0 },
 {"OlGetStandardCursor",	0, OlGetStandardCursor,		(Cursor) 0 },
 {"OlGetDocCursor",		0, OlGetDocCursor,		(Cursor) 0 },
 {"OlGetDocStackCursor",	0, OlGetDocStackCursor,		(Cursor) 0 },
 {"OlGetDropCursor",		0, OlGetDropCursor,		(Cursor) 0 },
 {"OlGetDupeDocCursor",		0, OlGetDupeDocCursor,		(Cursor) 0 },
 {"OlGetDupeDocDragCursor",	0, OlGetDupeDocDragCursor,	(Cursor) 0 },
 {"OlGetDupeDocDropCursor",	0, OlGetDupeDocDropCursor,	(Cursor) 0 },
 {"OlGetDupeDocNoDropCursor",	0, OlGetDupeDocNoDropCursor,	(Cursor) 0 },
 {"OlGetDupeStackCursor",	0, OlGetDupeStackCursor,	(Cursor) 0 },
 {"OlGetDupeStackDragCursor",	0, OlGetDupeStackDragCursor,	(Cursor) 0 },
 {"OlGetDupeStackDropCursor",	0, OlGetDupeStackDropCursor,	(Cursor) 0 },
 {"OlGetDupeStackNoDropCursor",	0, OlGetDupeStackNoDropCursor,	(Cursor) 0 },
 {"OlGetMoveDocCursor",		0, OlGetMoveDocCursor,		(Cursor) 0 },
 {"OlGetMoveDocDragCursor",	0, OlGetMoveDocDragCursor,	(Cursor) 0 },
 {"OlGetMoveDocDropCursor",	0, OlGetMoveDocDropCursor,	(Cursor) 0 },
 {"OlGetMoveDocNoDropCursor",	0, OlGetMoveDocNoDropCursor,	(Cursor) 0 },
 {"OlGetMoveStackCursor",	0, OlGetMoveStackCursor,	(Cursor) 0 },
 {"OlGetMoveStackDragCursor",	0, OlGetMoveStackDragCursor,	(Cursor) 0 },
 {"OlGetMoveStackDropCursor",	0, OlGetMoveStackDropCursor,	(Cursor) 0 },
 {"OlGetMoveStackNoDropCursor",	0, OlGetMoveStackNoDropCursor,	(Cursor) 0 },
 {"OlGetNoDropCursor",		0, OlGetNoDropCursor,		(Cursor) 0 },
 {"OlGetTextDupeDragCursor",	0, OlGetTextDupeDragCursor,	(Cursor) 0 },
 {"OlGetTextDupeDropCursor",	0, OlGetTextDupeDropCursor,	(Cursor) 0 },
 {"OlGetTextDupeNoDropCursor",	0, OlGetTextDupeNoDropCursor,	(Cursor) 0 },
 {"OlGetTextMoveDragCursor",	0, OlGetTextMoveDragCursor,	(Cursor) 0 },
 {"OlGetTextMoveDropCursor",	0, OlGetTextMoveDropCursor,	(Cursor) 0 },
 {"OlGetTextMoveNoDropCursor",	0, OlGetTextMoveNoDropCursor,	(Cursor) 0 },
 {"OlGetTextMoveInsertCursor",	0, OlGetTextMoveInsertCursor,	(Cursor) 0 },
 {"OlGetTextDupeInsertCursor",	0, OlGetTextDupeInsertCursor,	(Cursor) 0 },
 {"OlGetDataDupeDragCursor",	0, OlGetDataDupeDragCursor,	(Cursor) 0 },
 {"OlGetDataDupeDropCursor",	0, OlGetDataDupeDropCursor,	(Cursor) 0 },
 {"OlGetDataDupeInsertCursor",	0, OlGetDataDupeInsertCursor,	(Cursor) 0 },
 {"OlGetDataDupeNoDropCursor",	0, OlGetDataDupeNoDropCursor,	(Cursor) 0 },
 {"OlGetDataMoveDragCursor",	0, OlGetDataMoveDragCursor,	(Cursor) 0 },
 {"OlGetDataMoveDropCursor",	0, OlGetDataMoveDropCursor,	(Cursor) 0 },
 {"OlGetDataMoveInsertCursor",	0, OlGetDataMoveInsertCursor,	(Cursor) 0 },
 {"OlGetDataMoveNoDropCursor",	0, OlGetDataMoveNoDropCursor,	(Cursor) 0 },
 {"OlGetFolderCursor",		0, OlGetFolderCursor,		(Cursor) 0 },
 {"OlGetFolderStackCursor",	0, OlGetFolderStackCursor,	(Cursor) 0 },

#endif /* OLD_OPENLOOK */

#endif /* OPENLOOK */

};

/*ARGSUSED*/
static Boolean
CvtStringToCursor(dpy, args, num_args, fromVal, toVal, closure_ret)
Display* dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *closure_ret;
{
    Display *display = *(Display**)args[0].addr;
    char *name = (char *)fromVal->addr;
    XtentCursorName *nP;
    register int i;
    String params[1];
    Cardinal num_params;
    CursorEntry *ce;
    int length;
    static Cursor cursor;

    if (*num_args != 1)
	XtAppErrorMsg(XtDisplayToApplicationContext(dpy),
	     "wrongParameters","cvtStringToCursor","XtToolkitError",
             "String to cursor conversion needs display argument",
              (String *)NULL, (Cardinal *)NULL);

    if (name == (char *) NULL || *name == '\0')
	name = "None";

    for (ce = CursorList; ce; ce = ce -> next)
    {
	if (strcmp (ce -> name, name) == 0)
	{
	    cursor = ce -> cursor;
	    XtConverterReturn (Cursor, cursor, toVal);
	}
    }

    cursor = (Cursor) NULL;
    length = strlen (name) - 1;
    if (strncmp ("cursor(", name, 7) == 0 && name[length] == ')')
    {
	char *s[7], *ptr;

	s[0] = ptr = name + 7;
	s[6] = name + length;
	*s[6] = '\0';
	for (i = 1; i < 6; i++)
	{
	    while (*ptr)
	    {
		if (*ptr == ',')
		    break;
		else
		    ptr++;
	    }
	    if (*ptr)
		*ptr++ = '\0';
	    s[i] = ptr;
	}
	cursor = XtentCreateImageCursor (display, s[0], s[1], s[2], s[3], s[4],
					 s[5]);
	for (i = 1; i < 6; i++)
	    *(s[i] + 1) = ',';
	name[length] = ')';

	StoreCursor (name, cursor, NULL);
	XtConverterReturn (Cursor, cursor, toVal);
    }
    else
    for (i=0, nP=cursor_names; i < XtNumber(cursor_names); i++, nP++ ) {
	if (strcmp(name, nP->name) == 0) {
	    if (i > 2)	/* skip over defaults */
	    {
		if (nP -> get_cursor)
		    cursor = (*nP -> get_cursor) (XtentToplevel (XtentDisplay (), XtentToplevelPtr ()));
		else
		    cursor = XCreateFontCursor(display, nP->shape);
	    }
	    nP -> cursor = cursor;
	    StoreCursor (nP -> name, cursor, nP);
	    XtConverterReturn (Cursor, cursor, toVal);
	}
    }
    num_params = 1;
    params[0] = name;
    XtWarningMsg("conversionError","string","XtToolkitError",
		 "Cannot convert string \"%s\" to type cursor.",
		 params,&num_params);
    return False;
}

/*ARGSUSED*/
static Boolean
CvtCursorToString(dpy, args, num_args, fromVal, toVal, closure_ret)
Display* dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *closure_ret;
{
    XtentCursorName *nP;
    Cursor cursor = *((Cursor *)fromVal -> addr);
    register int i;
    Display *display;
    Cursor read_cursor;
    CursorEntry *ce;

    if (*num_args != 1)
	XtAppErrorMsg(XtDisplayToApplicationContext(dpy),
	     "wrongParameters", "cvtCursorToString", "XtToolkitError",
             "Cursor to String conversion needs display argument",
              (String *)NULL, (Cardinal *)NULL);

    if (cursor == (Cursor) NULL)
    {
	toVal -> addr = (XtPointer) cursor_names[0].name;
	toVal -> size = strlen (cursor_names[0].name) + 1;
	return True;
    }

    for (ce = CursorList; ce; ce = ce -> next)
    {
	if (ce -> cursor == cursor)
	    xtentConverterReturnString (toVal, ce -> name,
					strlen (ce -> name) + 1);
    }

    display = *(Display**)args[0].addr;

    for (i = 3, nP = &cursor_names[3]; i < XtNumber (cursor_names); i++, nP++)
    {
	if (nP -> cursor == (Cursor) NULL)
	{
	    if (nP -> get_cursor)
		read_cursor = (*nP -> get_cursor) (XtentToplevel (XtentDisplay (), XtentToplevelPtr ()));
	    else
		read_cursor = XCreateFontCursor (display, nP -> shape);

	    if (cursor == read_cursor)
	    {
		toVal -> addr = (XtPointer) nP -> name;
		toVal -> size = strlen (nP -> name) + 1;
		nP -> cursor = cursor;
		StoreCursor (nP -> name, cursor, nP);
		return True;
	    }
	}
    }

    XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
		    "no Cursor by that number",
		    "cvtCursorToString", "XtToolkitError",
		    "Cannot find the specified Cursor",
		    (String *) NULL, (Cardinal *) NULL);
    return False;
}

/* ARGSUSED */
static void
FreeCursor(app, toVal, closure, args, num_args)
XtAppContext app;
XrmValuePtr toVal;
XtPointer closure;	/* unused */
XrmValuePtr args;		/* unused */
Cardinal *num_args;
{
    Display*	display;
    CursorEntry *ce, *ce_prev;
    Cursor cursor;

    if (*num_args != 1)
     XtAppErrorMsg(app,
	     "wrongParameters","freeCursor","XtToolkitError",
             "Free Cursor requires display argument",
              (String *)NULL, (Cardinal *)NULL);

    display = *(Display**)args[0].addr;
    cursor = *(Cursor*)toVal->addr;

    for (ce_prev = (CursorEntry *) NULL, ce = CursorList; ce;
	 ce_prev = ce, ce = ce -> next)
	if (ce -> cursor == cursor)
	    break;
    if (ce)
    {
	if (ce -> np == NULL || ce -> np -> get_cursor == 0)
	    XFreeCursor (display, ce -> cursor);

	if (ce_prev)
	    ce_prev -> next = ce -> next;
	else
	    CursorList = ce -> next;

	    XFree ((char *) ce);
    }
    else
	XFreeCursor (display, cursor); /* open look losers gulp */
}

/*
 * simple type converters
 */
/*
 * string to string should not be needed, but the XtVaCreate*() low
 * level functions run the "identity" conversion - cough
 */
static Boolean
xtentCvtStringToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *src = (char *) from_val -> addr;
    char **dst = (char **) to_val -> addr;

    if (src == (char *) NULL)
	src = "";

    if (to_val -> addr != (XtPointer) NULL)
    {
	if (to_val -> size < (unsigned int) sizeof (XtPointer))
	{
	    to_val -> size = (unsigned int) sizeof (XtPointer);

	    return False;
	}
	*dst = (char *) src;
    }
    else
    {
	to_val -> addr = (XtPointer) src;
	to_val -> size = (unsigned int) sizeof (XtPointer);
    }
    return True;
}

static Boolean
xtentCvtDimensionToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Dimension x;
    static char buf[32];

    x = (Dimension) *((Dimension *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtPositionToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Position x;
    static char buf[32];

    x = (Position) *((Position *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtCharToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char c;
    static char buf[2];

    c = *((char *) from_val -> addr);
    buf[0] = c;
    buf[1] = '\0';
    xtentConverterReturnString (to_val, buf, 2);
}

static Boolean
xtentCvtStringToChar (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static char c;

    if (from_val -> addr == NULL)
    {
	to_val -> addr = (XtPointer) NULL;
	to_val -> size = 0;
	return False;
    }
    c = *((char *) from_val -> addr);
    XtConverterReturn (char, c, to_val);
}

static Boolean
xtentCvtShortToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    short x;
    static char buf[32];

    x = (short) *((short *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtIntToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    int x;
    static char buf[32];

    x = (int) *((int *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtPixelToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Pixel x;
    static char buf[32];

    x = (Pixel) *((Pixel *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtCardinalToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Cardinal x;
    static char buf[32];

    x = (Cardinal) *((Cardinal *) from_val -> addr);
    sprintf (buf, "%d", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtFloatToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    double x;
    static char buf[64];

    x = (float) *((float *) from_val -> addr);
    sprintf (buf, "%f", x);
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

static Boolean
xtentCvtBooleanToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    Boolean x;
    char *buf;

    x = (Boolean) *((Boolean *) from_val -> addr);
    if (x)
	buf = "True";
    else
	buf = "False";
    xtentConverterReturnString (to_val, buf, strlen (buf) + 1);
}

/*
 * setup our converter environment */
XrmQuark XtQBoolean;		/* These are not static! */
XrmQuark XtQCardinal;
XrmQuark XtQColormap;
XrmQuark XtQCursor;
XrmQuark XtQDimension;
XrmQuark XtQFloat;
XrmQuark XtQImage;
XrmQuark XtQInt;
XrmQuark XtQPixel;
XrmQuark XtQPosition;
XrmQuark XtQShort;
XrmQuark XtQString;

#ifdef OPENLOOK
XrmQuark XtQFont;
XrmQuark XtQFontStruct;
#endif /* OPENLOOK */

void
XtentAddConverters ()
{
    static XtConvertArgRec colorConvertArgs[] =
    {
    	{
	    XtWidgetBaseOffset,
	    (XtPointer) XtOffset (Widget, core.screen),
	    sizeof (Screen *)
	},
	{
	    XtWidgetBaseOffset,
	    (XtPointer) XtOffset (Widget, core.colormap),
	    sizeof (Colormap)
	}
    };
    static XtConvertArgRec displayConvertArg[] =
    {
        {
	    XtProcedureArg,
	    (XtPointer) FetchDisplayArg,
	    0
	},
    };
    static XtConvertArgRec contextConvertArgs [] =
    {
	{
	    XtWidgetBaseOffset,
	    (XtPointer) XtOffset(Widget, core.self),
	    sizeof(Widget),
	},
    };

    static XtConvertArgRec parentConvertArgs[] =
    {
        {
	    XtWidgetBaseOffset,
	    (XtPointer) XtOffset(Widget, core.parent), 
	    sizeof(Widget),
	},
    };

    XtQBoolean = XrmStringToQuark (XtRBoolean);
    XtQCardinal = XrmStringToQuark (XtRCardinal);
    XtQColormap = XrmStringToQuark (XtRColormap);
    XtQCursor = XrmStringToQuark (XtRCursor);
    XtQDimension = XrmStringToQuark (XtRDimension);
    XtQFloat = XrmStringToQuark (XtRFloat);
    XtQImage = XrmStringToQuark (XtRImage);
    XtQInt = XrmStringToQuark (XtRInt);
    XtQPixel = XrmStringToQuark (XtRPixel);
    XtQPosition = XrmStringToQuark (XtRPosition);
    XtQShort = XrmStringToQuark (XtRShort);
    XtQString = XrmStringToQuark (XtRString);

#ifdef OPENLOOK
    XtQFont = XrmStringToQuark (XtRFont);
    XtQFontStruct = XrmStringToQuark (XtRFontStruct);
#endif /* OPENLOOK */

    XtSetTypeConverter  (XtRString, XtRPixel, 
			 (XtTypeConverter) CvtStringToPixel,
			 colorConvertArgs, XtNumber(colorConvertArgs),
			 XtCacheByDisplay, FreePixel);
    XtSetTypeConverter (XtRString,  XtRCursor, 
			(XtTypeConverter) CvtStringToCursor,
			displayConvertArg, XtNumber(displayConvertArg),
			XtCacheByDisplay, FreeCursor);
    XtSetTypeConverter (XtRCursor,  XtRString, 
			(XtTypeConverter) CvtCursorToString,
			displayConvertArg, XtNumber(displayConvertArg),
			XtCacheNone, NULL);
    XtSetTypeConverter (XtRString, XtRWindow, 
			(XtTypeConverter) xtentCvtStringToWindow,
			NULL, (Cardinal) 0,
			XtCacheNone, (XtDestructor) NULL);
    XtSetTypeConverter (XtRWindow, XtRString, 
			(XtTypeConverter) xtentCvtWindowToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRWidget, 
			(XtTypeConverter) xtentCvtStringToWidget,
			parentConvertArgs, XtNumber(parentConvertArgs),
			XtCacheNone, (XtDestructor) NULL);
    XtSetTypeConverter (XtRWidget, XtRString, 
			(XtTypeConverter) xtentCvtWidgetToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRWidgetList,
			(XtTypeConverter) xtentCvtStringToWidgetList,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRWidgetList, XtRString,
			(XtTypeConverter) xtentCvtWidgetListToString,
			contextConvertArgs, XtNumber (contextConvertArgs),
			XtCacheNone, (XtDestructor) NULL);
    XtSetTypeConverter (XtRString, "Image",
			(XtTypeConverter) xtentCvtStringToImage,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter ("Image", XtRString, 
			(XtTypeConverter) xtentCvtImageToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRPixmap, 
			(XtTypeConverter) xtentCvtStringToPixmap,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRBitmap, 
			(XtTypeConverter) xtentCvtStringToBitmap,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRBitmap, XtRString, 
			(XtTypeConverter) xtentCvtBitmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRColormap, 
			(XtTypeConverter) xtentCvtStringToColormap,
			NULL, 0, XtCacheNone, (XtDestructor) NULL);
    XtSetTypeConverter (XtRColormap, XtRString, 
			(XtTypeConverter) xtentCvtColormapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRAtom, 
			(XtTypeConverter) xtentCvtStringToAtom,
			NULL, (Cardinal) 0, XtCacheAll,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRAtom, XtRString, 
			(XtTypeConverter) xtentCvtAtomToString,
			NULL, (Cardinal) 0, XtCacheAll,
			(XtDestructor) NULL);
    /*
     * simple type converters
     */

    XtSetTypeConverter (XtRString, XtRString,
			(XtTypeConverter) xtentCvtStringToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

    XtSetTypeConverter (XtRDimension, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRPosition, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRChar, XtRString, 
			(XtTypeConverter) xtentCvtCharToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRString, XtRChar, 
			(XtTypeConverter) xtentCvtStringToChar,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRShort, XtRString, 
			(XtTypeConverter) xtentCvtShortToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRInt, XtRString, 
			(XtTypeConverter) xtentCvtIntToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRPixel, XtRString, 
			(XtTypeConverter) xtentCvtPixelToString,
			NULL, (Cardinal) 0, XtCacheAll,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRCardinal, XtRString, 
			(XtTypeConverter) xtentCvtCardinalToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRFloat, XtRString, 
			(XtTypeConverter) xtentCvtFloatToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRBoolean, XtRString, 
			(XtTypeConverter) xtentCvtBooleanToString,
			NULL, (Cardinal) 0, XtCacheAll,
			(XtDestructor) NULL);

#ifdef OPENLOOK
    XtSetTypeConverter (XtROlDefine, XtRString, 
			(XtTypeConverter) xtentCvtOlDefineToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);
    XtSetTypeConverter (XtRGravity, XtRString, 
			(XtTypeConverter) xtentCvtOlGravityToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#define XtROlWMProtocolMsgType "OlWMProtocolMsgType"

    XtSetTypeConverter (XtROlWMProtocolMsgType, XtRString,
			(XtTypeConverter) xtentCvtOlWMProtocolMsgTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtRPointer,
			(XtTypeConverter) xtentCvtStringtoOlPointer, 
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtRCallbackProc,
			(XtTypeConverter) xtentCvtStringtoOlFlatCallback, 
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

#define XtROlListDelete "OlListDelete"

    XtSetTypeConverter (XtROlListDelete, XtRString,
			(XtTypeConverter) xtentCvtOlListDeleteToString, 
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtROlWrapMode,
			(XtTypeConverter) xtentCvtStringToOlWrapMode,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtROlWrapMode, XtRString,
			(XtTypeConverter) xtentCvtOlWrapModeToString,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtROlSourceType,
			(XtTypeConverter) xtentCvtStringToOlSourceType,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtROlSourceType, XtRString,
			(XtTypeConverter) xtentCvtOlSourceTypeToString,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtROlEditMode,
			(XtTypeConverter) xtentCvtStringToOlEditMode,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtROlEditMode, XtRString,
			(XtTypeConverter) xtentCvtOlEditModeToString,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

#if OL_VERSION >= 3 && OL_REVISION >= 2


    XtSetTypeConverter (XtRString, XtROlStrRep,
			(XtTypeConverter) xtentCvtStringToOlStrRep,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtROlStrRep, XtRString,
			(XtTypeConverter) xtentCvtOlStrRepToString,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtROlStr, XtRString,
			(XtTypeConverter) xtentCvtOlStrToString,
			NULL, 0,
			XtCacheNone, (XtDestructor) NULL);

#endif /* OL_VERSION >= 3 && OL_REVISION >= 2 */

#endif /* OPENLOOK */

#ifdef MOTIF

/*
 * shared converters
 */
#ifndef XtRBool
#define XtRBool "Bool"
#endif
    XtSetTypeConverter (XtRBool, XtRString, 
			(XtTypeConverter) xtentCvtBooleanToString,
			NULL, (Cardinal) 0, XtCacheAll,
			(XtDestructor) NULL);

#ifndef XtRBooleanDimension
#define XtRBooleanDimension "BooleanDimension"
#endif
    XtSetTypeConverter (XtRBooleanDimension, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRBottomShadowPixmap
#define XtRBottomShadowPixmap "BottomShadowPixmap"
#endif
    XtSetTypeConverter (XtRBottomShadowPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRGadgetPixmap
#define XtRGadgetPixmap "GadgetPixmap"
#endif
    XtSetTypeConverter (XtRGadgetPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRHighlightPixmap
#define XtRHighlightPixmap "HighlightPixmap"
#endif
    XtSetTypeConverter (XtRHighlightPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);


#ifndef XtRHorizontalDimension
#define XtRHorizontalDimension "HorizontalDimension"
#endif
    XtSetTypeConverter (XtRHorizontalDimension, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRHorizontalInt
#define XtRHorizontalInt "HorizontalInt"
#endif
    XtSetTypeConverter (XtRHorizontalInt, XtRString, 
			(XtTypeConverter) xtentCvtIntToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRHorizontalPosition
#define XtRHorizontalPosition "HorizontalPosition"
#endif
    XtSetTypeConverter (XtRHorizontalPosition, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRManBottomShadowPixmap
#define XtRManBottomShadowPixmap "ManBottomShadowPixmap"
#endif
    XtSetTypeConverter (XtRManBottomShadowPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRManForegroundPixmap
#define XtRManForegroundPixmap "ManForegroundPixmap"
#endif
    XtSetTypeConverter (XtRManForegroundPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRManHighlightPixmap
#define XtRManHighlightPixmap "ManHighlightPixmap"
#endif
    XtSetTypeConverter (XtRManHighlightPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRManTopShadowPixmap
#define XtRManTopShadowPixmap "ManTopShadowPixmap"
#endif
    XtSetTypeConverter (XtRManTopShadowPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRMenuWidget
#define XtRMenuWidget "MenuWidget"
#endif
    XtSetTypeConverter (XtRString, XtRMenuWidget, 
			(XtTypeConverter) xtentCvtStringToWidget,
			parentConvertArgs, XtNumber(parentConvertArgs),
			XtCacheNone, (XtDestructor) NULL);

    XtSetTypeConverter (XtRMenuWidget, XtRString, 
			(XtTypeConverter) xtentCvtWidgetToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRPrimForegroundPixmap
#define XtRPrimForegroundPixmap "PrimForegroundPixmap"
#endif
    XtSetTypeConverter (XtRPrimForegroundPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRShellHorizDim
#define XtRShellHorizDim "ShellHorizDim"
#endif
    XtSetTypeConverter (XtRShellHorizDim, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRShellHorizPos
#define XtRShellHorizPos "ShellHorizPos"
#endif
    XtSetTypeConverter (XtRShellHorizPos, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRShellVertDim
#define XtRShellVertDim "ShellVertDim"
#endif
    XtSetTypeConverter (XtRShellVertDim, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRShellVertPos
#define XtRShellVertPos "ShellVertPos"
#endif
    XtSetTypeConverter (XtRShellVertPos, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRTextPosition
#define XtRTextPosition "TextPosition"
#endif
    XtSetTypeConverter (XtRTextPosition, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRTopShadowPixmap
#define XtRTopShadowPixmap "TopShadowPixmap"
#endif
    XtSetTypeConverter (XtRTopShadowPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVerticalDimension
#define XtRVerticalDimension "VerticalDimension"
#endif
    XtSetTypeConverter (XtRVerticalDimension, XtRString,
			(XtTypeConverter) xtentCvtDimensionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVerticalInt
#define XtRVerticalInt "VerticalInt"
#endif
    XtSetTypeConverter (XtRVerticalInt, XtRString, 
			(XtTypeConverter) xtentCvtIntToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVerticalPosition
#define XtRVerticalPosition "VerticalPosition"
#endif
    XtSetTypeConverter (XtRVerticalPosition, XtRString, 
			(XtTypeConverter) xtentCvtPositionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRWhichButton
#define XtRWhichButton "WhichButton"
#endif
    XtSetTypeConverter (XtRWhichButton, XtRString, 
			(XtTypeConverter) xtentCvtIntToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRXmBackgroundPixmap
#define XtRXmBackgroundPixmap "XmBackgroundPixmap"
#endif
    XtSetTypeConverter (XtRXmBackgroundPixmap, XtRString, 
			(XtTypeConverter) xtentCvtPixmapToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

/*
 * Motif only converters
 */
#ifndef XtRAlignment
#define XtRAlignment "Alignment"
#endif
    XtSetTypeConverter (XtRAlignment, XtRString,
			(XtTypeConverter) xtentCvtAlignmentToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRArrowDirection
#define XtRArrowDirection "ArrowDirection"
#endif
    XtSetTypeConverter (XtRArrowDirection, XtRString,
			(XtTypeConverter) xtentCvtArrowDirectionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRChildPlacement
#define XtRChildPlacement "ChildPlacement"
#endif
    XtSetTypeConverter (XtRChildPlacement, XtRString,
			(XtTypeConverter) xtentCvtChildPlacementToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRCommandWindowLocation
#define XtRCommandWindowLocation "CommandWindowLocation"
#endif
    XtSetTypeConverter (XtRCommandWindowLocation, XtRString,
			(XtTypeConverter) xtentCvtCommandWindowLocationToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRDefaultButtonType
#define XtRDefaultButtonType "DefaultButtonType"
#endif
    XtSetTypeConverter (XtRDefaultButtonType, XtRString,
			(XtTypeConverter) xtentCvtDefaultButtonTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRDialogStyle
#define XtRDialogStyle "DialogStyle"
#endif
    XtSetTypeConverter (XtRDialogStyle, XtRString,
			(XtTypeConverter) xtentCvtDialogStyleToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRDialogueType
#define XtRDialogueType "DialogueType"
#endif
    XtSetTypeConverter (XtRDialogueType, XtRString,
			(XtTypeConverter) xtentCvtDialogueTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtREditMode
#define XtREditMode "EditMode"
#endif
    XtSetTypeConverter (XtREditMode, XtRString,
			(XtTypeConverter) xtentCvtEditModeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRFileTypeMask
#define XtRFileTypeMask "FileTypeMask"
#endif
    XtSetTypeConverter (XtRFileTypeMask, XtRString,
			(XtTypeConverter) xtentCvtFileTypeMaskToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRIndicatorType
#define XtRIndicatorType "IndicatorType"
#endif
    XtSetTypeConverter (XtRIndicatorType, XtRString,
			(XtTypeConverter) xtentCvtIndicatorTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRInitialState
#define XtRInitialState "InitialState"
#endif
    XtSetTypeConverter (XtRInitialState, XtRString,
			(XtTypeConverter) xtentCvtInitialStateToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRKeySym
#define XtRKeySym "KeySym"
#endif
    XtSetTypeConverter (XtRKeySym, XtRString,
			(XtTypeConverter) xtentCvtKeySymToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRLabelType
#define XtRLabelType "LabelType"
#endif
    XtSetTypeConverter (XtRLabelType, XtRString,
			(XtTypeConverter) xtentCvtLabelTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRListSizePolicy
#define XtRListSizePolicy "ListSizePolicy"
#endif
    XtSetTypeConverter (XtRListSizePolicy, XtRString,
			(XtTypeConverter) xtentCvtListSizePolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRMultiClick
#define XtRMultiClick "MultiClick"
#endif
    XtSetTypeConverter (XtRMultiClick, XtRString,
			(XtTypeConverter) xtentCvtMultiClickToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRNavigationType
#define XtRNavigationType "NavigationType"
#endif
    XtSetTypeConverter (XtRNavigationType, XtRString,
			(XtTypeConverter) xtentCvtNavigationTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtROrientation
#define XtROrientation "Orientation"
#endif
    XtSetTypeConverter (XtROrientation, XtRString,
			(XtTypeConverter) xtentCvtOrientationToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRPacking
#define XtRPacking "Packing"
#endif
    XtSetTypeConverter (XtRPacking, XtRString,
			(XtTypeConverter) xtentCvtPackingToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRProcessingDirection
#define XtRProcessingDirection "ProcessingDirection"
#endif
    XtSetTypeConverter (XtRProcessingDirection, XtRString,
			(XtTypeConverter) xtentCvtProcessingDirectionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRResizePolicy
#define XtRResizePolicy "ResizePolicy"
#endif
    XtSetTypeConverter (XtRResizePolicy, XtRString,
			(XtTypeConverter) xtentCvtResizePolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRRowColumnType
#define XtRRowColumnType "RowColumnType"
#endif
    XtSetTypeConverter (XtRRowColumnType, XtRString,
			(XtTypeConverter) xtentCvtRowColumnTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRScrollBarDisplayPolicy
#define XtRScrollBarDisplayPolicy "ScrollBarDisplayPolicy"
#endif
    XtSetTypeConverter (XtRScrollBarDisplayPolicy, XtRString,
			(XtTypeConverter) xtentCvtScrollBarDisplayPolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRScrollBarPlacement
#define XtRScrollBarPlacement "ScrollBarPlacement"
#endif
    XtSetTypeConverter (XtRScrollBarPlacement, XtRString,
			(XtTypeConverter) xtentCvtScrollBarPlacementToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRScrollingPolicy
#define XtRScrollingPolicy "ScrollingPolicy"
#endif
    XtSetTypeConverter (XtRScrollingPolicy, XtRString,
			(XtTypeConverter) xtentCvtScrollingPolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRSelectionPolicy
#define XtRSelectionPolicy "SelectionPolicy"
#endif
    XtSetTypeConverter (XtRSelectionPolicy, XtRString,
			(XtTypeConverter) xtentCvtSelectionPolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRSelectionType
#define XtRSelectionType "SelectionType"
#endif
    XtSetTypeConverter (XtRSelectionType, XtRString,
			(XtTypeConverter) xtentCvtSelectionTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRSeparatorType
#define XtRSeparatorType "SeparatorType"
#endif
    XtSetTypeConverter (XtRSeparatorType, XtRString,
			(XtTypeConverter) xtentCvtSeparatorTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRShadowType
#define XtRShadowType "ShadowType"
#endif
    XtSetTypeConverter (XtRShadowType, XtRString,
			(XtTypeConverter) xtentCvtShadowTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRStringArray
#define XtRStringArray "StringArray"
#endif
    XtSetTypeConverter (XtRStringArray, XtRString,
			(XtTypeConverter) xtentCvtStringArrayToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRStringDirection
#define XtRStringDirection "StringDirection"
#endif
    XtSetTypeConverter (XtRStringDirection, XtRString,
			(XtTypeConverter) xtentCvtStringDirectionToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRTearOffModel
#define XtRTearOffModel "TearOffModel"
#endif
    XtSetTypeConverter (XtRTearOffModel, XtRString,
			(XtTypeConverter) xtentCvtTearOffModelToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRUnitType
#define XtRUnitType "UnitType"
#endif
    XtSetTypeConverter (XtRUnitType, XtRString,
			(XtTypeConverter) xtentCvtUnitTypeToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVerticalAlignment
#define XtRVerticalAlignment "VerticalAlignment"
#endif
    XtSetTypeConverter (XtRVerticalAlignment, XtRString,
			(XtTypeConverter) xtentCvtVerticalAlignmentToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVisual
#define XtRVisual "Visual"
#endif
    XtSetTypeConverter (XtRVisual, XtRString,
			(XtTypeConverter) xtentCvtVisualToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRVisualPolicy
#define XtRVisualPolicy "VisualPolicy"
#endif
    XtSetTypeConverter (XtRVisualPolicy, XtRString,
			(XtTypeConverter) xtentCvtVisualPolicyToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRAttachment
#define XtRAttachment "Attachment"
#endif
    XtSetTypeConverter (XtRAttachment, XtRString,
			(XtTypeConverter) xtentCvtAttachmentToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRWidgetClass
#define XtRWidgetClass "WidgetClass"
#endif
    XtSetTypeConverter (XtRWidgetClass, XtRString,
			(XtTypeConverter) xtentCvtWidgetClassToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

    XtSetTypeConverter (XtRString, XtRWidgetClass,
			(XtTypeConverter) xtentCvtStringToWidgetClass,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRXmString
#define XtRXmString "XmString"
#endif
    XtSetTypeConverter (XtRXmString, XtRString,
			(XtTypeConverter) xtentCvtXmStringToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#ifndef XtRXmStringTable
#define XtRXmStringTable "XmStringTable"
#endif
    XtSetTypeConverter (XtRXmStringTable, XtRString,
			(XtTypeConverter) xtentCvtXmStringTableToString,
			NULL, (Cardinal) 0, XtCacheNone,
			(XtDestructor) NULL);

#endif /* MOTIF */
}

/*
 * type support routines
 */
static XImage *
BitmapFileToXImage (display, filename)
Display *display;
char *filename;
{
    Pixmap pixmap;
    XImage *image;
    int screen = DefaultScreen (display);
    int width, height;
    XRectangle rect;

    pixmap = BitmapFileToPixmap (display, filename, &width, &height);

    rect.x = rect.y = 0; rect.width = width; rect.height = height;
    image = XtentGetImage (display, pixmap, &rect, FALSE, (char *) NULL);
    XFreePixmap (display, pixmap);

    return image;
}

static Pixel
ColorNameToPixel (color)
char *color;
{
    Widget w = (Widget) XtentToplevel (XtentDisplay (),
				       XtentToplevelPtr ());
    XrmValue from_value, to_value;
	
    from_value.size = strlen (color);
    from_value.addr = color;
    to_value.size = 0;
    to_value.addr = (XtPointer) NULL;
	
    _XtConvert (w, XtQString, &from_value,
		XtQPixel, &to_value, NULL);
	
    if (to_value.size && to_value.addr)
	return *((Pixel *) to_value.addr);

    return (Pixel) NULL;
}

static Pixmap
BitmapFileToPixmap (display, filename, ret_width, ret_height)
Display *display;
char *filename;
int *ret_width;
int *ret_height;
{
    Pixmap bitmap;
    Pixmap pixmap;
    int screen = DefaultScreen (display);
    int depth = DefaultDepth (display, screen);
    Window root = RootWindow (display, screen);
    int x_hot, y_hot;
    Pixel foreground;
    Pixel background;
    char *color_names;

    /*
     * bitmaps may include colors: file(foreground,background)
     */
    foreground = BlackPixel (display, screen);
    background = WhitePixel (display, screen);
    if (color_names = (char *) strchr (filename, '('))
    {
	char *parse = color_names;
	char *color;
	char end;
	Pixel pixels[2];
	int i;

	*color_names = '\0';

	pixels[0] = foreground;
	pixels[1] = background;
	for (i = 0; i < 2; i++)
	{
	    parse++;
	    while (*parse && (*parse == ' ' || *parse == '\t'))
		parse++;
	    if (*parse == '\0')
		break;;
	    color = parse;
	    while (*parse && (*parse != ',' && *parse != ')'))
		parse++;
	    end = *parse;
	    *parse = '\0';
	    pixels[i] = ColorNameToPixel (color);
	    *parse = end;
	    if (end == '\0')
		break;
	}
	foreground = pixels[0];
	background = pixels[1];
    }

    /*
     * Tile
     */
    if (strncmp (filename, "Xw", 2) == 0)
    {
	Widget w = (Widget) XtentToplevel (XtentDisplay (),
					   XtentToplevelPtr ());
	int type = -1;
	int dither = 0;

	if (strcmp (&filename[2], "FOREGROUND") == 0)
	    type = XwFOREGROUND;
	else if (strcmp (&filename[2], "BACKGROUND") == 0)
	    type = XwBACKGROUND;
	else if (strcmp (&filename[2], "25_FOREGROUND") == 0)
	    type = Xw25_FOREGROUND;
	else if (strcmp (&filename[2], "50_FOREGROUND") == 0)
	    type = Xw50_FOREGROUND;
	else if (strcmp (&filename[2], "75_FOREGROUND") == 0)
	    type = Xw75_FOREGROUND;
	else if (strcmp (&filename[2], "VERTICAL_TILE") == 0)
	    type = XwVERTICAL_TILE;
	else if (strcmp (&filename[2], "HORIZONTAL_TILE") == 0)
	    type = XwHORIZONTAL_TILE;
	else if (strcmp (&filename[2], "SLANT_RIGHT") == 0)
	    type = XwSLANT_RIGHT;
	else if (strcmp (&filename[2], "SLANT_LEFT") == 0)
	    type = XwSLANT_LEFT;
	else if (strncmp (&filename[2], "DITHER", 6) == 0)
	{
	    type = XwDITHER;
	    dither = atoi (filename + 8);
	}

	if (type != -1)
	{
	    if (color_names)
		*color_names = '(';

	    *ret_width = 16;
	    *ret_height = 16;
	    return (Pixmap) _XwCreateTile (XtScreen (w),
					   foreground, background,
					   type, dither);
	}
    }

    if (XReadBitmapFile (display, root, filename,
			 (unsigned int *) ret_width,
			 (unsigned int *) ret_height, 
			 &bitmap, &x_hot, &y_hot) != BitmapSuccess)
    {
	fprintf (stderr, "%s: Cannot read the bitmap file: %s.\n",
		 XtentProgramName (), filename);
	if (color_names)
	    *color_names = '(';
	return (Pixmap) NULL;
    }
    if (depth == 1 && color_names == (char *) NULL)
	return bitmap;

    pixmap = BitmapToPixmap (display, bitmap, foreground, background,
			     *ret_width, *ret_height);
    if (pixmap == (Pixmap) NULL)
    {
	fprintf (stderr,
		 "%s: Cannot create the pixmap from the file: %s.\n",
		 XtentProgramName (), filename);
    }

    XFreePixmap (display, bitmap);

    if (color_names)
	*color_names = '(';

    return pixmap;
}

static Pixmap
BitmapToPixmap (display, bitmap, foreground, background, width, height)
Display *display;
Pixmap bitmap;
Pixel foreground;
Pixel background;
int width;
int height;
{
    Pixmap pixmap;
    int screen = DefaultScreen (display);
    int depth = DefaultDepth (display, screen);
    Window root = RootWindow (display, screen);
    GC gc;
    XGCValues gcvalues;

    pixmap = XCreatePixmap (display, root, width, height, depth);
	
    if (pixmap == (Pixmap) NULL)
	return pixmap;

    gcvalues.function = GXcopy;
    gcvalues.foreground = foreground;
    gcvalues.background = background;
    gc = XCreateGC (display, root,
		    GCFunction | GCForeground | GCBackground,
		    &gcvalues);

    XCopyPlane (display, bitmap, pixmap, gc,
		0, 0, width, height, 0, 0, 1L);
	
    XFreeGC (display, gc);

    return (pixmap);
}

static Pixmap
ImageToBitmap (display, image)
Display *display;
XImage *image;
{
    Pixmap bitmap;
    int screen = DefaultScreen (display);
    Window root = RootWindow (display, screen);
    GC gc;
    XGCValues gcvalues;

    bitmap = XCreatePixmap (display, root, 
			    image -> width, image -> height,
			    image -> depth);
	
    if (bitmap == (Pixmap) NULL)
	return bitmap;

    gcvalues.function = GXcopy;
    gcvalues.plane_mask = AllPlanes;
    gcvalues.foreground = BlackPixel (display, screen);
    gcvalues.background = WhitePixel (display, screen);
    gc = XCreateGC (display, root,
		    GCFunction | GCPlaneMask | GCForeground | GCBackground,
		    &gcvalues);

    XPutImage (display, bitmap, gc, image, 0, 0, 0, 0,
	       image -> width, image -> height);

    XFreeGC (display, gc);

    if (image -> depth != 1)
    {
	Pixmap new_bitmap;

	new_bitmap = PixmapToBitmap (display, bitmap,
				     image -> width, image -> height);
	XFreePixmap (display, bitmap);
	bitmap = new_bitmap;
    }

    return (bitmap);
}

static Pixmap
PixmapToBitmap (display, pixmap, width, height)
Display *display;
Pixmap pixmap;
int width;
int height;
{
    Pixmap bitmap;
    int screen = DefaultScreen (display);
    Window root = RootWindow (display, screen);
    GC gc;
    XGCValues gcvalues;

    bitmap = XCreatePixmap (display, root, width, height, 1);
	
    if (bitmap == (Pixmap) NULL)
	return bitmap;

    gcvalues.function = GXcopy;
    gcvalues.plane_mask = 1;
    gcvalues.foreground = BlackPixel (display, screen);
    gcvalues.background = WhitePixel (display, screen);
    gc = XCreateGC (display, bitmap,
		    GCFunction | GCPlaneMask | GCForeground | GCBackground,
		    &gcvalues);
	
    XCopyPlane (display, pixmap, bitmap, gc,
		0, 0, width, height, 0, 0, 1L);

    XFreeGC (display, gc);

    return (bitmap);
}

static int
ImageToBitmapFile (display, image, x_hot, y_hot, filename)
Display *display;
XImage *image;
int x_hot, y_hot;
char *filename;
{
    Pixmap bitmap;

    bitmap = ImageToBitmap (display, image);
    if (bitmap == (Pixmap) NULL)
    {
	fprintf (stderr,
		 "%s: Cannot create the bitmap for the file: %s.\n",
		 XtentProgramName (), filename);
	return FALSE;
    }

    if (XWriteBitmapFile (display, filename, bitmap,
			  image -> width, image -> height,
			  x_hot, y_hot) != BitmapSuccess)
    {
	fprintf (stderr,
		 "%s: Cannot write the bitmap file: %s.\n",
		 XtentProgramName (), filename);
	XFreePixmap (display, bitmap);
	return FALSE;
    }

    XFreePixmap (display, bitmap);
    return TRUE;
}

static int
PixmapToBitmapFile (display, pixmap, width, height, x_hot, y_hot, filename)
Display *display;
Pixmap pixmap;
int width, height, x_hot, y_hot;
char *filename;
{
    Pixmap bitmap;

    bitmap = PixmapToBitmap (display, pixmap, width, height);
    if (bitmap == (Pixmap) NULL)
    {
	fprintf (stderr,
		 "%s: Cannot create the bitmap for the file: %s.\n",
		 XtentProgramName (), filename);
	return FALSE;
    }

    if (XWriteBitmapFile (display, filename, bitmap,
			  width, height, x_hot, y_hot) != BitmapSuccess)
    {
	fprintf (stderr,
		 "%s: Cannot write the bitmap file: %s.\n",
		 XtentProgramName (), filename);
	XFreePixmap (display, bitmap);
	return FALSE;
    }

    XFreePixmap (display, bitmap);
    return TRUE;
}

int
XtentScaleImage (display, in_name, out_width, out_height, out_name)
Display *display;
char *in_name;
int out_width;
int out_height;
char *out_name;
{
    ImageEntry *ie;
    XImage *in = (XImage *) NULL;
    XImage *out;
    char *error_message = "Cannot scale image - illegal parameters.";

    if (out_width < 1 || out_height < 1)
    {
	XtentWarningMessage (error_message);
	XtentWarningMessage ("Width or hieght of new iamge is less than 1.");
	return FALSE;
    }

    if (out_name == (char *) NULL || *out_name == '\0')
    {
	XtentWarningMessage (error_message);
	XtentWarningMessage ("Null output name.");
	return FALSE;
    }
    for (ie = ImageList; ie; ie = ie -> next)
	if (strcmp (ie -> name, in_name) == 0)
	{
	    in = ie -> image;
	    break;
	}

    if (in == (XImage *) NULL)
    {
	XtentWarningMessage (error_message);
	XtentWarningMessage ("Could not find the requested image.");
	return FALSE;
    }

    if ((out = LocalCreateImage (display, out_width, out_height)) ==
	(XImage *) NULL)
    {
	XtentWarningMessage ("Could not allocate the new image.");
	return FALSE;
    }

    SampleImage (in, out);

    StoreImage (out_name, out);

    return TRUE;
}

static XImage *
LocalCreateImage (display, out_width, out_height)
Display *display;
int out_width;
int out_height;
{
    XImage *out;
    int screen = DefaultScreen (display);
    int depth = DefaultDepth (display, screen);

    out = XCreateImage (display, DefaultVisual (display, screen),
			depth,
			(depth > 1) ? ZPixmap : XYPixmap,
			0,	/* offset */
			(char *) NULL,
			out_width, out_height,
			8,	/* bitmap quantum */
			0);

    if (out == (XImage *) NULL)
    {
	XtentWarningMessage ("Cannot allocate image space.");
	exit (1);
    }

    out -> data = (char *) XtMalloc (out -> bytes_per_line *
				     out -> height);
    return out;
}

void
XtentWriteImage (display, image_name, filename, type, colormap_name)
Display *display;
char *image_name;
char *filename;
char type;
char *colormap_name;
{
    ImageEntry *ie;
    ColormapEntry *ce;
    Colormap colormap;

    for (ie = ImageList; ie; ie = ie -> next)
	if (strcmp (ie -> name, image_name) == 0)
	    break;

    if (ie == (ImageEntry *) NULL)
    {
	fprintf (stderr, "%s: Could not find the image: %s\n",
		 XtentProgramName (), image_name);
	return;
    }

    if ((type == 't' || type == 'p') &&
	(colormap_name == (char *) NULL || *colormap_name == '\0'))
    {
	colormap = DefaultColormap (display, DefaultScreen (display));
    }
    else if ((type == 't' || type == 'p') &&
	     colormap_name && *colormap_name)
    {
	for (ce = ColormapList; ce; ce = ce -> next)
	    if (strcmp (ce -> name, colormap_name) == 0)
		break;
		
	if (ce == (ColormapEntry *) NULL)
	{
	    fprintf (stderr,
		     "%s: Could not find the colormap: %s\n",
		     XtentProgramName (), colormap_name);
	    return;
	}
	colormap = ce -> colormap;
    }

    switch (type)
    {
    case 'b':
	ImageToBitmapFile (display, ie -> image, 0, 0, filename);
	break;
    case 't':
	ImageToTifFile (display, ie -> image, colormap, filename);
	break;
    case 'p':
	ImageToPostScriptFile (display, ie -> image, colormap,
			       filename);
	break;
    }
}

void
XtentWritePixmap (display, pixmap_name, filename, type, colormap_name)
Display *display;
char *pixmap_name;
char *filename;
char type;
char *colormap_name;
{
    PixmapEntry *pe;
    ColormapEntry *ce;
    Window root;
    int ignore;
    int width, height, depth;
    XImage *image;
    Colormap colormap;

    for (pe = PixmapList; pe; pe = pe -> next)
	if (strcmp (pe -> name, pixmap_name) == 0)
	    break;

    if (pe == (PixmapEntry *) NULL)
    {
	fprintf (stderr, "%s: Could not find the pixmap: %s\n",
		 XtentProgramName (), pixmap_name);
	return;
    }

    if ((type == 't' || type == 'p') &&
	(colormap_name == (char *) NULL || *colormap_name == '\0'))
    {
	colormap = DefaultColormap (display, DefaultScreen (display));
    }
    else if ((type == 't' || type == 'p') &&
	     colormap_name && *colormap_name)
    {
	for (ce = ColormapList; ce; ce = ce -> next)
	    if (strcmp (ce -> name, colormap_name) == 0)
		break;
		
	if (ce == (ColormapEntry *) NULL)
	{
	    fprintf (stderr,
		     "%s: Could not find the colormap: %s\n",
		     XtentProgramName (), colormap_name);
	    return;
	}
	colormap = ce -> colormap;
    }

    if (XGetGeometry (display, pe -> pixmap, &root,
		      &ignore, &ignore,
		      (unsigned int *) &width, (unsigned int *) &height, 
		      (unsigned int *) &ignore, 
		      (unsigned int *) &depth) == FALSE)
    {
	fprintf (stderr,
		 "%s: Could not get the geometry the pixmap: %s\n",
		 XtentProgramName (), pixmap_name);
	return;
    }
    if (type == 't' || type == 'p')
    {
	XRectangle rect;

	rect.x = rect.y = 0; rect.width = width; rect.height = height;
	image = XtentGetImage (display, pe -> pixmap, &rect,
			       FALSE, (char *) NULL);
    }

    switch (type)
    {
    case 'b':
	if (depth != 1)
	{
	    PixmapToBitmapFile (display, pe -> pixmap,
				width, height, 0, 0, filename);
	}
	else
	    if (XWriteBitmapFile (display, filename, pe -> pixmap,
				  width, height, 0, 0) != BitmapSuccess)
	    {
		fprintf (stderr,
			 "%s: Cannot write the bitmap file: %s.\n",
			 XtentProgramName (), filename);
	    }
	break;
    case 't':
	ImageToTifFile (display, image, colormap, filename);
	XDestroyImage (image);
	break;
    case 'p':
	ImageToPostScriptFile (display, image, colormap, filename);
	XDestroyImage (image);
	break;
    }
}

/*
 * a little C++ would help with the following sets of routines
 */
void
XtentFreeImage (display, image_name)
Display *display;
char *image_name;
{
    ImageEntry *ie, *ie_prev;

    for (ie_prev = (ImageEntry *) NULL, ie = ImageList; ie;
	 ie_prev = ie, ie = ie -> next)
	if (strcmp (ie -> name, image_name) == 0)
	    break;
    if (ie)
    {
	XtentFreeColormap (display, image_name);
	XDestroyImage (ie -> image);
	if (ie_prev)
	    ie_prev -> next = ie -> next;
	else
	    ImageList = ie -> next;
	XFree ((char *) ie);
    }
}

void
XtentFreePixmap (display, pixmap_name)
Display *display;
char *pixmap_name;
{
    PixmapEntry *pe, *pe_prev;

    for (pe_prev = (PixmapEntry *) NULL, pe = PixmapList; pe;
	 pe_prev = pe, pe = pe -> next)
	if (strcmp (pe -> name, pixmap_name) == 0)
	    break;
    if (pe)
    {
	XtentFreeColormap (display, pixmap_name);
	XFreePixmap (display, pe -> pixmap);
	if (pe_prev)
	    pe_prev -> next = pe -> next;
	else
	    PixmapList = pe -> next;
	XFree ((char *) pe);
    }
}

/*
 * XtCreateImageCursor(bitmap, bitmap-mask, fg-color, bg-color, x, y)
 */
Cursor
XtentCreateImageCursor (display, image_name, image_mask_name,
			fg_color, bg_color, x, y)
Display *display;
char *image_name, *image_mask_name;
char *fg_color, *bg_color;
char *x, *y;
{
    CursorEntry *ce, *ce_prev;
    Cursor cursor = (Cursor) NULL;
    char *cursor_name;
    char buffer[256];
    int length;
    int screen = DefaultScreen (display);
    Colormap colormap = DefaultColormap (display, screen);
    XColor fg, bg;
    XImage *source_image, *mask_image;
    Pixmap source_bitmap, mask_bitmap;
    ImageEntry *ie;

    if (*image_name == '\0')
	return cursor;

    /*
     * find the image names
     */
    source_image = mask_image = (XImage *) NULL;
    for (ie = ImageList; ie; ie = ie -> next)
    {
	if (source_image == (XImage *) NULL &&
	    strcmp (ie -> name, image_name) == 0)
	    source_image = ie -> image;
	if (mask_image == (XImage *) NULL &&
	    strcmp (ie -> name, image_mask_name) == 0)
	    mask_image = ie -> image;
	if (mask_image && source_image)
	    break;
    }

    if (source_image == NULL)
	return cursor;

    source_bitmap = ImageToBitmap (display, source_image);
    if (source_bitmap == (Pixmap) NULL)
	return cursor;

    if (mask_image)
	mask_bitmap = ImageToBitmap (display, mask_image);
    else
	mask_bitmap = (Pixmap) NULL;

    /*
     * look for the cursor name
     *
     *   cursor(name,mask,fg-color,bg-color,x,y)
     */
    length = 7 + strlen (image_name) + 1 + strlen (image_mask_name) + 1 +
	strlen (fg_color) + 1 + strlen (bg_color) + 1 +
	    strlen (x) + 1 + strlen (y) + 1 + 1;
    if (length < sizeof (buffer))
	cursor_name = buffer;
    else
	cursor_name = (char *) XtMalloc (length);

    sprintf (cursor_name, "cursor(%s,%s,%s,%s,%s,%s)", image_name,
	     image_mask_name, fg_color, bg_color, x, y);

    for (ce_prev = (CursorEntry *) NULL, ce = CursorList; ce;
	 ce_prev = ce, ce = ce -> next)
	if (strcmp (ce -> name, cursor_name) == 0)
	    break;

    if (ce)
    {
	if (ce -> np == NULL || ce -> np -> get_cursor == 0)
	    XFreeCursor (display, ce -> cursor);

	if (ce_prev)
	    ce_prev -> next = ce -> next;
	else
	    CursorList = ce -> next;

	XFree ((char *) ce);
    }

    /*
     * convert the strings to XColors
     */
    if (XParseColor (display, colormap, fg_color, &fg) == 0)
	XParseColor (display, colormap, "black", &fg);

    if (XParseColor (display, colormap, bg_color, &bg) == 0)
	XParseColor (display, colormap, "white", &bg);

    /*
     * create the cursor and store it
     */
    cursor = XCreatePixmapCursor (display, source_bitmap, mask_bitmap,
				  &fg, &bg, atoi (x), atoi (y));

    StoreCursor (cursor_name, cursor, NULL);

    if (cursor_name != buffer)
	XtFree (cursor_name);

    XFreePixmap (display, source_bitmap);
    if (mask_bitmap)
    	XFreePixmap (display, mask_bitmap);

    return cursor;
}

void
XtentFreeImageCursor (display, image_name, image_mask_name,
			fg_color, bg_color, x, y)
Display *display;
char *image_name, *image_mask_name;
char *fg_color, *bg_color;
char *x, *y;
{
    CursorEntry *ce, *ce_prev;
    char *cursor_name;
    char buffer[256];
    int length;

    /* cursor(name,mask,fg-color,bg-color,x,y) */
    length = 7 + strlen (image_name) + 1 + strlen (image_mask_name) + 1 +
	strlen (fg_color) + 1 + strlen (bg_color) + 1 +
	    strlen (x) + 1 + strlen (y) + 1 + 1;
    if (length < sizeof (buffer))
	cursor_name = buffer;
    else
	cursor_name = (char *) XtMalloc (length);

    sprintf (cursor_name, "cursor(%s,%s,%s,%s,%s,%s)", image_name,
	     image_mask_name, fg_color, bg_color, x, y);

    for (ce_prev = (CursorEntry *) NULL, ce = CursorList; ce;
	 ce_prev = ce, ce = ce -> next)
	if (strcmp (ce -> name, cursor_name) == 0)
	    break;
    if (ce)
    {
	if (ce -> np == NULL || ce -> np -> get_cursor == 0)
	    XFreeCursor (display, ce -> cursor);

	if (ce_prev)
	    ce_prev -> next = ce -> next;
	else
	    CursorList = ce -> next;

	XFree ((char *) ce);
    }

    if (cursor_name != buffer)
	XtFree (cursor_name);
}

void
XtentCreateColormap (display, colormap_name)
Display *display;
char *colormap_name;
{
    Colormap new_colormap;
    int screen = DefaultScreen (display);

    new_colormap = XCreateColormap (display,
				    RootWindow (display, screen),
				    DefaultVisual (display, screen),
				    AllocNone);

    StoreColormap (colormap_name, new_colormap);
}

void
XtentFreeColormap (display, colormap_name)
Display *display;
char *colormap_name;
{
    ColormapEntry *ce, *ce_prev;

    for (ce_prev = (ColormapEntry *) NULL, ce = ColormapList; ce;
	 ce_prev = ce, ce = ce -> next)
	if (strcmp (ce -> name, colormap_name) == 0)
	    break;
    if (ce)
    {
	XFreeColormap (display, ce -> colormap);
	if (ce_prev)
	    ce_prev -> next = ce -> next;
	else
	    ColormapList = ce -> next;
	XFree ((char *) ce);
    }
}

char *
XtentNextImageName ()
{
    static char image_name[32];
    static int image_count = 0;

    sprintf (image_name, "image%d", image_count++);

    return image_name;
}

static char *
XtentNextPixmapName ()
{
    static char pixmap_name[32];
    static int pixmap_count = 0;

    sprintf (pixmap_name, "pixmap%d", pixmap_count++);

    return pixmap_name;
}

static char *
XtentNextColormapName ()
{
    static char colormap_name[32];
    static int colormap_count = 0;

    sprintf (colormap_name, "colormap%d", colormap_count++);

    return colormap_name;
}

static ImageEntry *
StoreImage (name, image)
char *name;
XImage *image;
{
    ImageEntry *ie;
    int length;

    for (ie = ImageList; ie; ie = ie -> next)
    {
	if (strcmp (ie -> name, name) == 0)
	{
	    XDestroyImage (ie -> image);
	    ie -> image = image;
	    return ie;
	}
    }

    length = strlen (name) + 1;
    ie = (ImageEntry *) XtMalloc (sizeof (ImageEntry) + length);
    memcpy (ie -> name, name, length);
    ie -> image = image;
    ie -> next = ImageList;
    ImageList = ie;

    return ie;
}

static PixmapEntry *
StorePixmap (name, pixmap)
char *name;
Pixmap pixmap;
{
    PixmapEntry *pe;
    int length;

    for (pe = PixmapList; pe; pe = pe -> next)
    {
	if (strcmp (pe -> name, name) == 0)
	{
	    XFreePixmap (XtentDisplay (), pe -> pixmap);
	    pe -> pixmap = pixmap;
	    return pe;
	}
    }

    length = strlen (name) + 1;
    pe = (PixmapEntry *) XtMalloc (sizeof (PixmapEntry) + length);
    memcpy (pe -> name, name, length);
    pe -> pixmap = pixmap;
    pe -> next = PixmapList;
    PixmapList = pe;

    return pe;
}

static BitmapEntry *
StoreBitmap (name, bitmap)
char *name;
Pixmap bitmap;
{
    BitmapEntry *be;
    int length;

    for (be = BitmapList; be; be = be -> next)
    {
	if (strcmp (be -> name, name) == 0)
	{
	    XFreePixmap (XtentDisplay (), be -> bitmap);
	    be -> bitmap = bitmap;
	    return be;
	}
    }

    length = strlen (name) + 1;
    be = (BitmapEntry *) XtMalloc (sizeof (BitmapEntry) + length);
    memcpy (be -> name, name, length);
    be -> bitmap = bitmap;
    be -> next = BitmapList;
    BitmapList = be;

    return be;
}

static CursorEntry *
StoreCursor (name, cursor, np)
char *name;
Cursor cursor;
XtentCursorName *np;
{
    CursorEntry *ce;
    int length;

    for (ce = CursorList; ce; ce = ce -> next)
    {
	if (strcmp (ce -> name, name) == 0)
	{
	    XFreeCursor (XtentDisplay (), ce -> cursor);
	    ce -> cursor = cursor;
	    return ce;
	}
    }

    length = strlen (name) + 1;
    ce = (CursorEntry *) XtMalloc (sizeof (CursorEntry) + length);
    memcpy (ce -> name, name, length);
    ce -> np = np;
    ce -> cursor = cursor;
    ce -> next = CursorList;
    CursorList = ce;

    return ce;
}

static ColormapEntry *
StoreColormap (name, colormap)
char *name;
Colormap colormap;
{
    ColormapEntry *ce;
    int length;

    for (ce = ColormapList; ce; ce = ce -> next)
    {
	if (strcmp (ce -> name, name) == 0)
	{
	    XFreeColormap (XtentDisplay (), ce -> colormap);
	    ce -> colormap = colormap;
	    return ce;
	}
    }

    length = strlen (name) + 1;
    ce = (ColormapEntry *) XtMalloc (sizeof (ColormapEntry) + length);
    memcpy (ce -> name, name, length);
    ce -> colormap = colormap;
    ce -> next = ColormapList;
    ColormapList = ce;

    return ce;
}

/*
 * screen chunk size  largest piece we'll request
 */
#define MAX_IMAGE	(64 * 1024)

XImage *
XtentGetImage (display, root, rect, store_image, out_name)
Display *display;
Window root;
XRectangle *rect;
int store_image;
char *out_name;
{
    XImage *image_out, *image_in;
    char *data_out, *data_in;
    int current_line, lines_per_sample, i;
    int bytes_per_line;

    /*
     * verify that the name and size are ok
     */
    if (store_image && (out_name == (char *) NULL || *out_name == '\0'))
    {
	XtentWarningMessage ("Image name is missing in GetImage.");
	return (XImage *) NULL;
    }

    if (rect -> width < 1 || rect -> height < 1)
    {
	XtentWarningMessage ("Illegal image size in GetImage.");
	return (XImage *) NULL;
    }

    /*
     * create an XImage large enough to store the entire image
     */
    image_out = LocalCreateImage (display, (int) rect -> width,
				  (int) rect -> height);
    if (image_out == NULL)
    {
	XtentWarningMessage ("Cannot allocate image space.");
	return (XImage *) NULL;
    }

    /*
     * Loop getting parts of the image
     */
    lines_per_sample = MAX_IMAGE / image_out -> bytes_per_line;
    if (lines_per_sample > image_out -> height)
    {
	image_in = XGetImage (display,
			      root,
			      rect -> x,
			      rect -> y,
			      rect -> width,
			      rect -> height,
			      AllPlanes,
			      image_out -> format);

	XDestroyImage (image_out);

	if (store_image)
	    StoreImage (out_name, image_in);
		
	return image_in;
    }
    current_line = 0;
    data_out = image_out -> data;
    for (current_line = 0; current_line < image_out -> height;
	 current_line += lines_per_sample)
    {
	if (current_line + lines_per_sample > image_out -> height)
	    lines_per_sample = image_out -> height - current_line;

	image_in = XGetImage (display,
			      root,
			      rect -> x,
			      rect -> y + current_line,
			      rect -> width,
			      lines_per_sample,
			      AllPlanes,
			      image_out -> format);

	data_in = image_in -> data;
	bytes_per_line = MIN (image_in -> bytes_per_line,
			      image_out -> bytes_per_line);
	for (i = 0; i < image_in -> height; i++)
	{
	    memcpy (data_out, data_in, bytes_per_line);
	    data_in += image_in -> bytes_per_line;
	    data_out += image_out -> bytes_per_line;
	}

	(*image_in -> f.destroy_image) (image_in);
    }

    if (store_image)
	StoreImage (out_name, image_out);

    return image_out;
}

static void
PseudoMapToGreyMap (colors, greymap, size)
XColor *colors;
unsigned char *greymap;
int size;
{
    XColor *cptr = colors;
    unsigned char *gptr = greymap;
    unsigned long grey;
    int i;

    for (i = 0; i < size; i++)
    {
	grey = ((cptr -> red >> 8) & 255) * 77 +
	    ((cptr -> green >> 8) & 255) * 151 +
		((cptr -> blue >> 8) & 255) * 28;
	*gptr++ = grey >> 8;
	cptr++;
    }
}

static char *post_script_0_uncompress[] =
{
"",
"%%%",
"%%% image display routines - select the display type below",
"%%%",
"/image-prev-state save def",
"64 dict begin",
"/inch {72 mul} def",
"",
"/image-landscape % stack: width height",
"{",
"	div /image-aspect-ratio exch def",
"	image-aspect-ratio 1 gt",
"	{",
"		/image-width 10 def",
"		/image-height 10 1 image-aspect-ratio div mul def",
"	}",
"	{",
"		/image-width 7.5 image-aspect-ratio mul def",
"		/image-height 7.5 def",
"	} ifelse",
"	/image-x-min 8.5 dup image-height sub 2 div sub def",
"	/image-y-min 11 image-width sub 2 div def",
"	image-x-min inch image-y-min inch translate",
"	90 rotate",
"	image-width inch image-height inch scale",
"} def",
"",
"/image-portrait % stack: width height",
"{",
"	div /image-aspect-ratio exch def",
"	image-aspect-ratio 0.75 gt",
"	{",
"		/image-width 7.5 def",
"		/image-height 7.5 1 image-aspect-ratio div mul def",
"	}",
"	{",
"		/image-width 10 image-aspect-ratio mul def",
"		/image-height 10 def",
"	} ifelse",
"	/image-x-min 8.5 image-width sub 2 div def",
"	/image-y-min 11  image-height sub 2 div def",
"	image-x-min inch image-y-min inch translate",
"	image-width inch image-height inch scale",
"} def",
"",
"/image-encapsulated % stack: width height",
"{",
"	0 0 translate",
"	scale",
"} def",
"",
"%%%",
"%%% select the display type",
"%%%",
(char *) NULL
};

static char *post_script_1_uncompress[] =
{
"",
"/image-check-each-character % stack: character",
"{",
"	dup 170 eq % look for AA",
"	{",
"		/image-duplicate-character-flag true def pop",
"	}",
"	{",
"		image-buffer image-character-position 3 -1 roll put",
"		/image-character-position image-character-position 1 add def",
"	} ifelse",
"} def",
"",
"/image-create-run % stack: length",
"{",
"	image-character-position add dup",
"	image-character-position 1 3 -1 roll",
"	{",
"		image-buffer exch image-run-character put",
"	} for",
"	/image-character-position exch def",
"} def",
"",
"/image-recursive-create-run % stack: length",
"{",
"	dup cvi 1 cvi and exch",
"	cvi -1 cvi bitshift dup",
"	3 -1 roll add dup",
"	4 gt",
"	{",
"		image-recursive-create-run",
"	} %else",
"	{",
"		image-create-run",
"	} ifelse",
"	dup dup",
"	image-buffer image-character-position",
"	image-buffer image-character-position 5 -1 roll sub 6 -1 roll",
"	getinterval putinterval",
"	/image-character-position exch image-character-position add def",
"} def",
"",
"/image-read-compressed",
"{",
"	/image-character-position 0 def",
"	currentfile image-read-buffer readhexstring pop",
"	{",
"		image-duplicate-character-flag",
"		{",
"			image-create-run-flag",
"			{",
"				image-recursive-create-run",
"				/image-duplicate-character-flag false def",
"				/image-create-run-flag false def",
"			} % else",
"			{",
"				/image-run-character exch def",
"				/image-create-run-flag true def",
"			} ifelse",
"		} % else",
"		{",
"			image-check-each-character",
"		} ifelse",
"	} forall",
"	% trim unused space from the end of image-buffer",
"	image-buffer 0 image-character-position getinterval",
"} def",
"",
"/image-process % stack: width, height, depth",
"{",
"	/image-depth exch def",
"	/image-height exch def",
"	/image-width exch def",
"",
"	% allocate space for one line of input",
"	/image-read-buffer 36 string def",
"",
"	% must be at least 255 * 36 / 3 bytes",
"	/image-buffer 3072 string def",
"",
"	% flags",
"	/image-duplicate-character-flag false def",
"	/image-create-run-flag false def",
"",
"	% read and dump the image",
"	image-width image-height image-depth",
"		[image-width 0 0 image-height neg 0 image-height]",
"		{ image-read-compressed } image",
"} def",
(char *) NULL
};

#define PRINT_LINE_WIDTH	72

#define PRINT_HEX(fp, char_to_print, byte_count) \
{						 \
	fprintf (fp, "%02x", char_to_print);	 \
	byte_count += 2;			 \
	if (byte_count == PRINT_LINE_WIDTH)	 \
	{					 \
		fprintf (fp, "\n");		 \
		byte_count = 0;			 \
	}					 \
}

#define PRINT_COMPACT(fp, c, last_c, c_count, byte_count)		\
{									\
	if (c_count == 0)						\
	{								\
		c_count = 1;						\
		last_c = c;						\
	}								\
	else if (c == last_c)						\
	{								\
		if (c_count == 255)					\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
			c_count = 1;					\
		}							\
		else							\
			c_count++;					\
	}								\
	else								\
	{								\
		if (last_c == 0xAA || c_count > 3)			\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
		}							\
		else							\
		{							\
			for (c_index = 0; c_index < c_count; c_index++)	\
				PRINT_HEX(fp, last_c, byte_count);	\
		}							\
		c_count = 1;						\
		last_c = c;						\
	}								\
}									\

static void
ImageToPostScriptFile (display, image, colormap, output_file)
Display *display;
XImage *image;
Colormap colormap;
char *output_file;
{
    FILE *fp;
    XColor *colors = (XColor *) NULL;
    unsigned char *greymap;
    int screen = DefaultScreen (display);
    int swap;
    int i, j;
    int width, depth;
    int cmap_size;
    unsigned char *data_ptr;
    long clock;
    unsigned char last_c;
    int c_count = 0;
    int byte_count = 0;
    int c_index;
    unsigned char c;
    char **ptr;

    if ((fp = fopen (ExpandFileName (output_file), "w")) == NULL)
    {
	fprintf (stderr, "%s: Cannot open the file: %s\n",
		 XtentProgramName (),  output_file);
	return;
    }

    switch (image -> depth)
    {
    default:			/* make all pixmaps 8 bits deep */
    case 8:
	cmap_size = 1 << image -> depth;
	greymap = (unsigned char *) XtMalloc (sizeof (XColor) *
					      (cmap_size + cmap_size));
	colors = (XColor *) greymap;
	greymap += (sizeof (XColor) * cmap_size);
	for (i = 0; i < cmap_size; i++)
	    colors[i].pixel = i;
	XQueryColors (display, colormap, colors, cmap_size);
	PseudoMapToGreyMap (colors, greymap, cmap_size);
	width = image -> width;
	depth = 8;
	break;
    case 1:
	width = (image -> width + 7) / 8;
	depth = 1;
	swap = (BlackPixel (display, screen) == 0);
	break;
    }

    fprintf (fp, "%%!\n");
    fprintf (fp, "%%%%Title: %s\n", output_file);
    fprintf (fp, "%%%%Creator: X11 screen dump\n");
    time (&clock);
    fprintf (fp, "%%%%CreationDate: %s", ctime (&clock));
    fprintf (fp, "%%%%BoundingBox: 0 0 %d %d\n",
	     image -> width, image -> height);
    fprintf (fp, "%%%%Pages: (atend)\n");
    fprintf (fp, "%%%%EndComments\n");

    /*
     * print out the first bit of PostScript de-compression code
     */
    ptr = post_script_0_uncompress;
    while (*ptr)
	fprintf (fp, "%s\n", *ptr++);

    /*
     * print out the display types
     */
    fprintf (fp, "   %d %d image-encapsulated\n",
	     image -> width, image -> height);

    fprintf (fp, "%%  %d %d image-landscape\n",
	     image -> width, image -> height);

    fprintf (fp, "%%  %d %d image-portrait\n",
	     image -> width, image -> height);

    /*
     * print out the second bit of PostScript de-compression code
     */
    ptr = post_script_1_uncompress;
    while (*ptr)
	fprintf (fp, "%s\n", *ptr++);

    /*
     * print out the PostScript command to read in the image data
     */
    fprintf (fp, "\n");
    fprintf (fp, "%d %d %d image-process\n",
	     image -> width, image -> height, depth);
		 
    switch (image -> depth)
    {
    case 8:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		c = greymap[*data_ptr++];
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }

	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;

    case 1:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		if (swap)
		    c =  (*data_ptr++) & 0377;
		else
		    c = ~(*data_ptr++) & 0377;
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }
	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;

    default:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		c = greymap[XGetPixel (image, j, i)];
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }
	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;
    }

    if (last_c == 0xAA || c_count > 3)
    {
	PRINT_HEX(fp, 0xAA, byte_count);
	PRINT_HEX(fp, last_c, byte_count);
	PRINT_HEX(fp, c_count, byte_count);
    }
    else
    {
	for (c_index = 0; c_index < c_count; c_index++)
	{
	    PRINT_HEX(fp, last_c, byte_count);
	}
    }
    while (byte_count < PRINT_LINE_WIDTH)
    {
	fprintf (fp, "0");
	byte_count++;
    }

    fprintf (fp, "\nshowpage\nend\nimage-prev-state restore\n");
    XFree ((char *) colors);
    fclose (fp);
}

long
XtentAllocColor (display, color_map_name, color_name)
Display* display;
char *color_map_name;
char *color_name;
{
    XColor screen_color;
    XColor exact_color;
    Colormap colormap;
    Status status;
    int screen = DefaultScreen (display);
    ColormapEntry *ce;
	
    if (color_map_name != (char *) NULL &&
	*color_map_name != '\0' &&
	(strcmp (color_map_name, "XtDefaultColormap") != 0))
    {
	for (ce = ColormapList; ce; ce = ce -> next)
	{
	    if (strcmp (ce -> name, color_map_name) == 0)
		break;
	}
	if (ce)
	{
	    colormap = ce -> colormap;
	}
	else
	{
	    fprintf (stderr,
		     "%s: Cannot find the named colormap: \"%s\".\n",
		     XtentProgramName (), color_map_name);
	    colormap = DefaultColormap (display, screen);
	}
    }
    else
	colormap = DefaultColormap (display, screen);

    if (strcmp (color_name, XtDefaultBackground) == 0)
	return WhitePixel (display, screen);

    if (strcmp (color_name, XtDefaultForeground) == 0)
	return BlackPixel (display, screen);
	
    if (*color_name >= '0' && *color_name <= '9')
    {
	screen_color.pixel = atol (color_name);
	return screen_color.pixel;
    }

    if (*color_name == '#')	/* some color rgb definition */
    {
		
	if ((status = XParseColor (display, colormap, color_name,
				   &screen_color)) != 0)
	    status = XAllocColor(display, colormap, &screen_color);
    }
    else			/* some color name */
    {
		
	status = XAllocNamedColor(display, colormap, color_name,
				  &screen_color, &exact_color);
    }

    if (status == 0)
    {
	fprintf (stderr,
		 "%s: Cannot allocate colormap entry for \"%s\".\n",
		 XtentProgramName (), color_name);
	return BlackPixel (display, screen);
    }

    return screen_color.pixel;
}

void
XtentQueryPixel (display, colormap_name, pixel, color)
Display *display;
char *colormap_name;
char *pixel;
XColor *color;
{
    ColormapEntry *ce = (ColormapEntry *) NULL;
    Colormap colormap;
    
    if (colormap_name != (char *) NULL &&
	*colormap_name != '\0' &&
	(strcmp (colormap_name, "XtDefaultColormap") != 0))
    {
	for (ce = ColormapList; ce; ce = ce -> next)
	{
	    if (strcmp (ce -> name, colormap_name) == 0)
		break;
	}
	if (ce)
	{
	    colormap = ce -> colormap;
	}
	else
	{
	    fprintf (stderr,
		     "%s: Cannot find the named colormap: \"%s\".\n",
		     XtentProgramName (), colormap_name);
	}
    }
    if (ce == (ColormapEntry *) NULL)
	colormap = DefaultColormap (display, DefaultScreen (display));
    
    color -> pixel = atol (pixel);
    XQueryColor (display, colormap, color);
}

int
XtentFreeColor (display, color_map_name, color_name)
Display* display;
char *color_map_name;
char *color_name;
{
    XColor screen_color;
    XColor exact_color;
    Colormap colormap;
    Status status;
    int screen = DefaultScreen (display);
    ColormapEntry *ce;
	
    if (color_map_name != (char *) NULL &&
	*color_map_name != '\0' &&
	(strcmp (color_map_name, "XtDefaultColormap") != 0))
    {
	for (ce = ColormapList; ce; ce = ce -> next)
	{
	    if (strcmp (ce -> name, color_map_name) == 0)
		break;
	}
	if (ce)
	{
	    colormap = ce -> colormap;
	}
	else
	{
	    fprintf (stderr,
		     "%s: Cannot find the named colormap: \"%s\".\n",
		     XtentProgramName (), color_map_name);
	    colormap = DefaultColormap (display, screen);
	}
    }
    else
	colormap = DefaultColormap (display, screen);

    if (strcmp (color_name, XtDefaultBackground) == 0)
	return FALSE;

    if (strcmp (color_name, XtDefaultForeground) == 0)
	return FALSE;
	
    if (*color_name >= '0' && *color_name <= '9')
    {
	screen_color.pixel = atol (color_name);
	if (screen_color.pixel == BlackPixel (display, screen) ||
	    screen_color.pixel == WhitePixel (display, screen))
	    return TRUE;
	XFreeColors (display, colormap, &screen_color.pixel, 1,
		     (unsigned long) 0);
	return TRUE;
    }

    /*
     * use allocate to locate the color
     */
    if (*color_name == '#')	/* some color rgb definition */
    {
		
	if ((status = XParseColor (display, colormap, color_name,
				   &screen_color)) != 0)
	    status = XAllocColor(display, colormap, &screen_color);
    }
    else			/* some color name */
    {
		
	status = XAllocNamedColor(display, colormap, color_name,
				  &screen_color, &exact_color);
    }

    if (status == 0)
    {
	fprintf (stderr,
		 "%s: Cannot locate colormap entry for \"%s\".\n",
		 XtentProgramName (), color_name);
	return FALSE;
    }

    if (screen_color.pixel == BlackPixel (display, screen) ||
	screen_color.pixel == WhitePixel (display, screen))
	return TRUE;
    /*
     * XFreeColors() must be called once for each time that the
     * color was allocated.
     */
    XFreeColors (display, colormap, &screen_color.pixel, 1,
		 (unsigned long) 0);
    XFreeColors (display, colormap, &screen_color.pixel, 1,
		 (unsigned long) 0);

    return TRUE;
}

#ifdef OPENLOOK

typedef struct
{
    char *name;
    int  const_value;
    /* one of the files in which it is used */
} OlDefineLookupItem;

static OlDefineLookupItem OLDefineList[] =
{
 {"OL_ROWS",			OL_ROWS},		/* Flat.c */
 {"all",			OL_ALL},		/* Slider.c */
 {"always",			OL_BEEP_ALWAYS},	/* Applic.c */
 {"auto_scroll_both",		OL_AUTO_SCROLL_BOTH},	/* TextPane.c */
 {"auto_scroll_horizontal",	OL_AUTO_SCROLL_HORIZONTAL},/* TextPane.c */
 {"auto_scroll_off",		OL_AUTO_SCROLL_OFF},	/* TextPane.c */
 {"auto_scroll_vertical",	OL_AUTO_SCROLL_VERTICAL},/* TextPane.c */
 {"base",			OL_WT_BASE},		/* Vendor.c */
 {"both",			OL_GROW_BOTH},		/* TextPane.c */
 {"bottom",			OL_BOTTOM},		/* Caption.c */
 {"buttonstack",		OL_BUTTONSTACK},	/* Button.c */
 {"cancel",			OL_MENU_CANCEL},	/* Vendor.c */
 {"center",			OL_CENTER},		/* StaticText.c */
 {"click_to_type",		OL_CLICK_TO_TYPE},	/* Vendor.c */
 {"cmd",			OL_WT_CMD},		/* Vendor.c */
 {"columns",			OL_COLUMNS},		/* ControlAre.c */
 {"command",			OL_WT_CMD},		/* Vendor.c */
 {"continuous",			OL_CONTINUOUS},		/* Slider.c */
 {"disksrc",			OL_DISK_SOURCE},	/* TextPane.c */
 {"display_form",		OL_DISPLAY_FORM},	/* TextPane.c */
 {"down",			OL_DOWN},		/* Button.c */
 {"fixedcols",			OL_FIXEDCOLS},		/* Nonexclusi.c */
 {"fixedheight",		OL_FIXEDHEIGHT},	/* ControlAre.c */
 {"fixedrows",			OL_FIXEDROWS},		/* Nonexclusi.c */
 {"fixedwidth",			OL_FIXEDWIDTH},		/* ControlAre.c */
 {"full",			OL_MENU_FULL},		/* Vendor.c */
 {"granularity",		OL_GRANULARITY},	/* Slider.c */
 {"grow_both",			OL_GROW_BOTH},		/* Text.c */
 {"grow_horizontal",		OL_GROW_HORIZONTAL},	/* Text.c */
 {"grow_off",			OL_GROW_OFF},		/* Text.c */
 {"grow_vertical",		OL_GROW_VERTICAL},	/* Text.c */
 {"help",			OL_WT_HELP},		/* Vendor.c */
 {"horizontal",			OL_HORIZONTAL},		/* Slider.c */
 {"ignore",			OL_IGNORE},		/* Category.c */
 {"image",			OL_IMAGE},		/* CheckBox.c */
 {"in",				OL_IN},			/* Vendor.c */
 {"inputfocus",			OL_INPUTFOCUS},		/* Applic.c */
 {"label",			OL_LABEL},		/* Button.c */
 {"left",			OL_LEFT},		/* StaticText.c */
 {"limited",			OL_MENU_LIMITED},	/* Vendor.c */
 {"maximize",			OL_MAXIMIZE},		/* Category.c */
 {"minimize",			OL_MINIMIZE},		/* Category.c */
 {"never",			OL_BEEP_NEVER},		/* Applic.c */
 {"none",			OL_NONE},		/* Vendor.c */
 {"notice",			OL_WT_NOTICE},		/* Vendor.c */
 {"notices",			OL_BEEP_NOTICES},	/* Applic.c */
 {"oblong",			OL_OBLONG},		/* Button.c */
 {"off",			OL_GROW_OFF},		/* TextPane.c */
 {"other",			OL_WT_OTHER},		/* Vendor.c */
 {"out",			OL_OUT},		/* Vendor.c */
 {"percent",			OL_PERCENT},		/* Slider.c */
 {"pointer",			OL_POINTER},		/* Applic.c */
 {"popup",			OL_POPUP},		/* Button.c */
 {"proc",			OL_PROC},		/* Button.c */
 {"real_estate",		OL_REALESTATE},		/* Vendor.c */
 {"rectbutton",			OL_RECTBUTTON},		/* Button.c */
 {"release",			OL_RELEASE},		/* Slider.c */
 {"right",			OL_RIGHT},		/* StaticText.c */
 {"slidervalue",		OL_SLIDERVALUE},	/* Slider.c */
 {"source_form",		OL_SOURCE_FORM},	/* TextPane.c */
 {"string",			OL_STRING},		/* CheckBox.c */
 {"stringsrc",			OL_STRING_SOURCE},	/* TextPane.c */
 {"textedit",			OL_TEXT_EDIT},		/* TextPane.c */
 {"textread",			OL_TEXT_READ},		/* TextPane.c */
 {"tickmark",			OL_TICKMARK},		/* Slider.c */
 {"top",			OL_TOP},		/* Caption.c */
 {"vertical",			OL_GROW_VERTICAL},	/* TextPane.c */
 {"vertical",			OL_VERTICAL},		/* Slider.c */
 {"wrapany",			OL_WRAP_ANY},		/* TextPane.c */
 {"wrapwhitespace",		OL_WRAP_WHITE_SPACE},	/* TextPane.c */
 {"display",			OL_DISPLAY},		/* Applic.c */
 {"highlight",			OL_HIGHLIGHT},		/* Applic.c */
 {"inactive",			OL_INACTIVE},		/* Applic.c */
 {"underline",			OL_UNDERLINE},		/* Applic.c */
 {NULL,				NULL}			/* END OF LIST */
};

static char *
XtentOLDefineToString (define)
OlDefine define;
{
    static char buf[32];
    static OlDefineLookupItem **lookup_table = (OlDefineLookupItem **) NULL;
    static OlDefine largest_define;
    static OlDefine lowest_define;

    /*
     * initialize the table the first time through
     */
    if (lookup_table == (OlDefineLookupItem **) NULL)
    {
	OlDefineLookupItem *ptr;
	int i;

	/* assume there are at least two entries */
	largest_define = lowest_define = OLDefineList[0].const_value;
	for (ptr = &OLDefineList[1]; ptr -> name; ptr++)
	{
	    if (largest_define < ptr -> const_value)
		largest_define = ptr -> const_value;
	    if (lowest_define > ptr -> const_value)
		lowest_define = ptr -> const_value;
	}

	i = (1 + largest_define - lowest_define) *
	    sizeof (OlDefineLookupItem *)	;
	lookup_table = (OlDefineLookupItem **) XtMalloc (i);
	memset (lookup_table, '\0', i);

	/* nice thing about sorting ints */
	for (ptr = OLDefineList; ptr -> name; )
	    lookup_table[ptr -> const_value - lowest_define] = ptr++;
    }

    /*
     * lookup the const_valueant
     */
    if (define >= lowest_define && define <= largest_define &&
	lookup_table[define - lowest_define])
    {
	return lookup_table[define - lowest_define] -> name;
    }
    else
    {
	fprintf (stderr,
		 "%s: OlDefine value not in the database: %d.\n",
		 XtentProgramName (), define);
	sprintf (buf, "%d", define);
	return buf;
    }
}

static Boolean
xtentCvtOlDefineToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;

    ptr = XtentOLDefineToString ((OlDefine)
				 *((OlDefine *) from_val -> addr));
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static OlDefineLookupItem OLGravityList[] =
{
	{ "forget",      ForgetGravity        },
	{ "northwest",   NorthWestGravity     },
	{ "north",       NorthGravity         },
	{ "northeast",   NorthEastGravity     },
	{ "west",        WestGravity          },
	{ "center",      CenterGravity        },
	{ "east",        EastGravity          },
	{ "southwest",   SouthWestGravity     },
	{ "south",       SouthGravity         },
	{ "southeast",   SouthEastGravity     },
	{ "static",      StaticGravity        },
	{ "unmap",       UnmapGravity         },
	{ "eastwest",    Ol_EastWestGravity   },
	{ "northsouth",  Ol_NorthSouthGravity },
	{ "all",         Ol_AllGravity        },
	{NULL,           NULL                 }	/* END OF LIST */
};

static char *
XtentOLGravityToString (gravity)
int gravity;
{
    static char buf[32];
    static OlDefineLookupItem **lookup_table = (OlDefineLookupItem **) NULL;
    static int largest_gravity;
    static int lowest_gravity;

    /*
     * initialize the table the first time through
     */
    if (lookup_table == (OlDefineLookupItem **) NULL)
    {
	OlDefineLookupItem *ptr;
	int i;

	/* assume there are at least two entries */
	largest_gravity = lowest_gravity = OLGravityList[0].const_value;
	for (ptr = &OLGravityList[1]; ptr -> name; ptr++)
	{
	    if (largest_gravity < ptr -> const_value)
		largest_gravity = ptr -> const_value;
	    if (lowest_gravity > ptr -> const_value)
		lowest_gravity = ptr -> const_value;
	}

	i = (1 + largest_gravity - lowest_gravity) *
	    sizeof (OlDefineLookupItem *);
	lookup_table = (OlDefineLookupItem **) XtMalloc (i);
	memset (lookup_table, '\0', i);

	/* nice thing about sorting ints */
	for (ptr = OLGravityList; ptr -> name; )
	    lookup_table[ptr -> const_value - lowest_gravity] = ptr++;
    }

    /*
     * lookup the constant
     */
    if (gravity >= lowest_gravity && gravity <= largest_gravity &&
	lookup_table[gravity - lowest_gravity])
    {
	return lookup_table[gravity - lowest_gravity] -> name;
    }
    else
    {
	fprintf (stderr,
		 "%s: OlGravity value not in the database: %d.\n",
		 XtentProgramName (), gravity);
	sprintf (buf, "%d", gravity);
	return buf;
    }
}

static Boolean
xtentCvtOlGravityToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;

    ptr = XtentOLGravityToString ((int) *((int *) from_val -> addr));
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtOlWMProtocolMsgTypeToString (display, args, num_args,
				     from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    OlWMProtocolVerify *p = (OlWMProtocolVerify *) from_val -> addr;

    if (p == NULL)
		ptr = "Illegal OL_WM Value";
    else switch (p -> msgtype)
    {
    case OL_WM_TAKE_FOCUS:
	ptr = "OL_WM_TAKE_FOCUS";
	break;
    case OL_WM_SAVE_YOURSELF:
	ptr = "OL_WM_SAVE_YOURSELF";
	break;
    case OL_WM_DELETE_WINDOW:
	ptr = "OL_WM_DELETE_WINDOW";
	break;
    default:
	ptr = "Illegal OL_WM Value";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static void
XtentOlFlatCallback (widget, client_data, call_data)
Widget	widget;
XtPointer client_data;
XtPointer call_data;
{
    XtentEvalString (XtentDisplay (), XtentToplevelPtr (), client_data);
}

static void
XtentOlFlatOtherCallback (widget, client_data, call_data)
Widget	widget;
XtPointer client_data;
XtPointer call_data;
{
    Display *display = XtentDisplay ();
    XrmDatabase db = XtDatabase(display);

    XrmPutStringResource (&db, "XtentOlFlatOtherCB", "True");
	
    XtentEvalString (XtentDisplay (), XtentToplevelPtr (), client_data);

    XrmPutStringResource (&db, "XtentOlFlatOtherCB", "False");
}

static Boolean
xtentCvtStringtoOlPointer (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int ptr_len;
    Widget w;
    static char *buf;
    static int buf_len = 0;
	
    ptr = (char *) from_val -> addr;
    if (ptr == (char *) NULL)
	ptr == "";

    if ((ptr_len = strlen (ptr) + 1) >= buf_len)
    {
	buf_len = ptr_len + 32;
	buf = (char *) XtRealloc (buf, buf_len);
    }
    memcpy (buf, ptr, ptr_len);
    xtentConverterReturnString (to_val, buf, ptr_len);
}

static Boolean
xtentCvtStringtoOlFlatCallback (display, args, num_args, from_val, to_val,
				data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static XtPointer loc;

    if (from_val -> addr)
    {
	if (strcmp (from_val -> addr, "XtentOlFlatCB") == 0)
	{
	    loc = (XtPointer) XtentOlFlatCallback;
	    XtConverterReturn (XtPointer, loc, to_val);
	}
	else if (strcmp (from_val -> addr, "XtentOlFlatOtherCB") == 0)
	{
	    loc = (XtPointer) XtentOlFlatOtherCallback;
	    XtConverterReturn (XtPointer, loc, to_val);
	}
    }
    fprintf (stderr, "String to callback conversion failed: %s\n",
	     from_val -> addr);
    fprintf (stderr,
	     "String to callback conversion only works for:\n");
    fprintf (stderr,
	     "        \"XtentOlFlatCB\" or \"XtentOlFlatOtherCB\"\n");

    loc = NULL;
    XtConverterReturn(XtPointer, loc, to_val);
}

static Boolean
xtentCvtOlListDeleteToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static char *buffer = (char *) NULL;
    static int length = 0;
    OlListDelete *list;
    OlListToken *tokens;
    int i;
    char *ptr;

    if (from_val -> addr != (XtPointer) NULL)
    {
	list = (OlListDelete *) from_val -> addr;

	if (list -> num_tokens < 1)
	{
	    buffer[0] = '\0';
	    xtentConverterReturnString (to_val, buffer, 1);
	}

	if (list -> num_tokens * 12 > length)
	{
	    length = list -> num_tokens * 12;
	    buffer = XtRealloc (buffer, length);
	}
	ptr = buffer;
	tokens = list -> tokens;
	for (i = list -> num_tokens; i > 0; i--)
	{
	    sprintf (ptr, "%d ", *tokens++);
	    ptr += strlen (ptr);
	}
	ptr[-1] = '\0';
	xtentConverterReturnString (to_val, buffer, ptr - buffer);
    }

    fprintf (stderr, "OlListDelete to String conversion failed: %s\n",
	     from_val -> addr);

    to_val -> size = 0;
    to_val -> addr = (XtPointer) NULL;
    return FALSE;
}

static Boolean
xtentCvtStringToOlWrapMode (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static OlWrapMode ret;

    if (from_val -> addr == NULL)
	from_val -> addr = (XtPointer) "";
    if (strcmp (from_val -> addr, "OL_WRAP_OFF") == 0)
	ret = OL_WRAP_OFF;
    else if (strcmp (from_val -> addr, "OL_WRAP_ANY") == 0)
	ret = OL_WRAP_ANY;
    else if (strcmp (from_val -> addr, "OL_WRAP_WHITE_SPACE") == 0)
	ret = OL_WRAP_WHITE_SPACE;
    else if (strcmp (from_val -> addr, "wrapoff") == 0)
	ret = OL_WRAP_OFF;
    else if (strcmp (from_val -> addr, "wrapany") == 0)
	ret = OL_WRAP_ANY;
    else if (strcmp (from_val -> addr, "wrapwhitespace") == 0)
	ret = OL_WRAP_WHITE_SPACE;
    else
    {
	fprintf (stderr,
		 "%s: OlWrapMode value not in the database: %s.\n",
		 XtentProgramName (), from_val -> addr);
	fprintf (stderr,
		 "%s: OlWrapMode: assuming OL_WRAP_OFF.\n",
		 XtentProgramName ());

	ret = OL_WRAP_OFF;
    }

    XtConverterReturn (OlWrapMode, ret, to_val);
}

static Boolean
xtentCvtOlWrapModeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    OlWrapMode x;

    x = (OlWrapMode) *((OlWrapMode *) from_val -> addr);

    switch (x)
    {
    case OL_WRAP_OFF:
	ptr = "OL_WRAP_OFF";
	break;
    case OL_WRAP_ANY:
	ptr = "OL_WRAP_ANY";
	break;
    case OL_WRAP_WHITE_SPACE:
	ptr = "OL_WRAP_WHITE_SPACE";
	break;
    default:
	fprintf (stderr,
		 "%s: OlWrapMode value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: OlWrapMode: assuming OL_WRAP_OFF.\n",
		 XtentProgramName ());

	ptr = "OL_WRAP_OFF";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtStringToOlSourceType (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static OlSourceType ret;

    if (from_val -> addr == NULL)
	from_val -> addr = (XtPointer) "";
    if (strcmp (from_val -> addr, "OL_DISK_SOURCE") == 0)
	ret = OL_DISK_SOURCE;
    else if (strcmp (from_val -> addr, "OL_STRING_SOURCE") == 0)
	ret = OL_STRING_SOURCE;
    else if (strcmp (from_val -> addr, "OL_TEXT_BUFFER_SOURCE") == 0)
	ret = OL_TEXT_BUFFER_SOURCE;
    else if (strcmp (from_val -> addr, "disksource") == 0)
	ret = OL_DISK_SOURCE;
    else if (strcmp (from_val -> addr, "stringsource") == 0)
	ret = OL_STRING_SOURCE;
    else if (strcmp (from_val -> addr, "textbuffersource") == 0)
	ret = OL_TEXT_BUFFER_SOURCE;
#if OL_VERSION >= 3 && OL_REVISION >= 2
    else if (strcmp (from_val -> addr, "OL_MLTEXT_BUFFER_SOURCE") == 0)
	ret = OL_MLTEXT_BUFFER_SOURCE;
    else if (strcmp (from_val -> addr, "mltextbuffersource") == 0)
	ret = OL_MLTEXT_BUFFER_SOURCE;
#endif
    else
    {
	fprintf (stderr,
		 "%s: OlSourceType value not in the database: %s.\n",
		 XtentProgramName (), from_val -> addr);
	fprintf (stderr,
		 "%s: OlSourceType: assuming OL_STRING_SOURCE.\n",
		 XtentProgramName ());

	ret = OL_STRING_SOURCE;
    }

    XtConverterReturn (OlSourceType, ret, to_val);
}

static Boolean
xtentCvtOlSourceTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    OlSourceType x;

    x = (OlSourceType) *((OlSourceType *) from_val -> addr);

    switch (x)
    {
    case OL_DISK_SOURCE:
	ptr = "OL_DISK_SOURCE";
	break;
    case OL_STRING_SOURCE:
	ptr = "OL_STRING_SOURCE";
	break;
    case OL_TEXT_BUFFER_SOURCE:
	ptr = "OL_TEXT_BUFFER_SOURCE";
	break;
#if OL_VERSION >= 3 && OL_REVISION >= 2
    case OL_MLTEXT_BUFFER_SOURCE:
	ptr = "OL_MLTEXT_BUFFER_SOURCE";
	break;
#endif
    default:
	fprintf (stderr,
		 "%s: OlSourceType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: OlSourceType: assuming OL_STRING_SOURCE.\n",
		 XtentProgramName ());

	ptr = "OL_STRING_SOURCE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtStringToOlEditMode (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static OlEditMode ret;

    if (from_val -> addr == NULL)
	from_val -> addr = (XtPointer) "";
    if (strcmp (from_val -> addr, "OL_TEXT_EDIT") == 0)
	ret = OL_TEXT_EDIT;
    else if (strcmp (from_val -> addr, "OL_TEXT_READ") == 0)
	ret = OL_TEXT_READ;
    else if (strcmp (from_val -> addr, "textedit") == 0)
	ret = OL_TEXT_EDIT;
    else if (strcmp (from_val -> addr, "textread") == 0)
	ret = OL_TEXT_READ;
    else
    {
	fprintf (stderr,
		 "%s: OlEditMode value not in the database: %s.\n",
		 XtentProgramName (), from_val -> addr);
	fprintf (stderr,
		 "%s: OlEditMode: assuming OL_TEXT_EDIT.\n",
		 XtentProgramName ());

	ret = OL_TEXT_EDIT;
    }

    XtConverterReturn (OlEditMode, ret, to_val);
}

static Boolean
xtentCvtOlEditModeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    OlEditMode x;

    x = (OlEditMode) *((OlEditMode *) from_val -> addr);

    switch (x)
    {
    case OL_TEXT_EDIT:
	ptr = "OL_TEXT_EDIT";
	break;
    case OL_TEXT_READ:
	ptr = "OL_TEXT_READ";
	break;
    default:
	fprintf (stderr,
		 "%s: OlEditMode value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: OlEditMode: assuming OL_TEXT_EDIT.\n",
		 XtentProgramName ());

	ptr = "OL_TEXT_EDIT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

#if OL_VERSION >= 3 && OL_REVISION >= 2

static Boolean
xtentCvtStringToOlStrRep (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static OlStrRep ret;
	
    if (from_val -> addr == NULL)
	from_val -> addr = (XtPointer) "";
    if (strcmp (from_val -> addr, "OL_SB_STR_REP") == 0)
	ret = OL_SB_STR_REP;
    else if (strcmp (from_val -> addr, "OL_MB_STR_REP") == 0)
	ret = OL_MB_STR_REP;
    else if (strcmp (from_val -> addr, "OL_WC_STR_REP") == 0)
	ret = OL_WC_STR_REP;
    /* cec
     *  allow the usual lower-case for entering from rdb
     */
    else if (strcmp (from_val -> addr, "sbstrrep") == 0)
	ret = OL_SB_STR_REP;
    else if (strcmp (from_val -> addr, "mbstrrep") == 0)
	ret = OL_MB_STR_REP;
    else if (strcmp (from_val -> addr, "wcstrrep") == 0)
	ret = OL_WC_STR_REP;
    else
    {
	fprintf (stderr,
		 "%s: OlStrRep value not in the database: %s.\n",
		 XtentProgramName (), from_val -> addr);
	fprintf (stderr,
		 "%s: OlStrRep: assuming OL_SB_STR_REP.\n",
		 XtentProgramName ());
	ret = OL_SB_STR_REP;
    }

    XtConverterReturn (OlStrRep, ret, to_val);
}

static Boolean
xtentCvtOlStrRepToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    OlStrRep x;

    x = (OlStrRep) *((OlStrRep *) from_val -> addr);

    switch (x)
    {
    case OL_SB_STR_REP:
	ptr = "OL_SB_STR_REP";
	break;
    case OL_MB_STR_REP:
	ptr = "OL_MB_STR_REP";
	break;
    case OL_WC_STR_REP:
	ptr = "OL_WC_STR_REP";
	break;
    default:
	fprintf (stderr,
		 "%s: OlStrRep value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: OlStrRep: assuming OL_SB_STR_REP.\n",
		 XtentProgramName ());
	ptr = "OL_SB_STR_REP";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtOlStrToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static char *buffer = (char *) NULL;
    static int length = 0;
    int i;
    char *ptr;

    ptr = (char *) *((OlStr *) from_val -> addr);
    if (ptr == NULL)
	ptr = "";

    i = strlen ((char *) ptr) + 1;
    if (i > length)
    {
	buffer = (char *) XtRealloc (buffer, i + 32);
	length = i + 32;
    }
    memcpy (buffer, ptr, i);
    xtentConverterReturnString (to_val, buffer, i);
}

#endif /* OL_VERSION >= 3 && OL_REVISION >= 2 */

#endif /* OPENLOOK */


#ifdef MOTIF

static Boolean
xtentCvtAlignmentToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    char x;

    x = (char) *((char *) from_val -> addr);

    switch (x)
    {
    case XmALIGNMENT_BEGINNING:
	ptr = "XmALIGNMENT_BEGINNING";
	break;
    case XmALIGNMENT_CENTER:
	ptr = "XmALIGNMENT_CENTER";
	break;
    case XmALIGNMENT_END:
	ptr = "XmALIGNMENT_END";
	break;
    default:
	fprintf (stderr,
		 "%s: Alignment value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: Alignment: assuming XmALIGNMENT_BEGINNING.\n",
		 XtentProgramName ());

	ptr = "XmALIGNMENT_BEGINNING";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtArrowDirectionToString (display, args, num_args, from_val, to_val,
				data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmARROW_UP:
	ptr = "XmARROW_UP";
	break;
    case XmARROW_DOWN:
	ptr = "XmARROW_DOWN";
	break;
    case XmARROW_LEFT:
	ptr = "XmARROW_LEFT";
	break;
    case XmARROW_RIGHT:
	ptr = "XmARROW_RIGHT";
	break;
    default:
	fprintf (stderr,
		 "%s: ArrowDirection value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ArrowDirection: assuming XmARROW_UP.\n",
		 XtentProgramName ());

	ptr = "XmARROW_UP";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtChildPlacementToString (display, args, num_args, from_val, to_val,
				data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmPLACE_TOP:
	ptr = "XmPLACE_TOP";
	break;
    case XmPLACE_ABOVE_SELECTION:
	ptr = "XmPLACE_ABOVE_SELECTION";
	break;
    case XmPLACE_BELOW_SELECTION:
	ptr = "XmPLACE_BELOW_SELECTION";
	break;
    default:
	fprintf (stderr,
		 "%s: ChildPlacement value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ChildPlacement: assuming XmPLACE_TOP.\n",
		 XtentProgramName ());

	ptr = "XmPLACE_TOP";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtCommandWindowLocationToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmCOMMAND_ABOVE_WORKSPACE:
	ptr = "XmCOMMAND_ABOVE_WORKSPACE";
	break;
    case XmCOMMAND_BELOW_WORKSPACE:
	ptr = "XmCOMMAND_BELOW_WORKSPACE";
	break;
    default:
	fprintf (stderr,
		 "%s: CommandWindowLocation value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
	 "%s: CommandWindowLocation: assuming XmCOMMAND_ABOVE_WORKSPACE.\n",
		 XtentProgramName ());

	ptr = "XmCOMMAND_ABOVE_WORKSPACE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtDefaultButtonTypeToString (display, args, num_args, from_val, to_val,
				   data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmDIALOG_NONE:
	ptr = "XmDIALOG_NONE";
	break;
    case XmDIALOG_CANCEL_BUTTON:
	ptr = "XmDIALOG_CANCEL_BUTTON";
	break;
    case XmDIALOG_OK_BUTTON:
	ptr = "XmDIALOG_OK_BUTTON";
	break;
    case XmDIALOG_HELP_BUTTON:
	ptr = "XmDIALOG_HELP_BUTTON";
	break;
    default:
	fprintf (stderr,
		 "%s: DefaultButtonType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: DefaultButtonType: assuming XmDIALOG_NONE.\n",
		 XtentProgramName ());

	ptr = "XmDIALOG_NONE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtDialogStyleToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int x;

    x = (int) *((int *) from_val -> addr);

    switch (x)
    {
    case XmDIALOG_SYSTEM_MODAL:
	ptr = "XmDIALOG_SYSTEM_MODAL";
	break;
    case XmDIALOG_PRIMARY_APPLICATION_MODAL:
	ptr = "XmDIALOG_PRIMARY_APPLICATION_MODAL";
	break;
    case XmDIALOG_FULL_APPLICATION_MODAL:
	ptr = "XmDIALOG_FULL_APPLICATION_MODAL";
	break;
    case XmDIALOG_MODELESS:
	ptr = "XmDIALOG_MODELESS";
	break;
    default:
	fprintf (stderr,
		 "%s: DialogueStyle value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: DialogueStyle: assuming XmDIALOG_MODELESS.\n",
		 XtentProgramName ());

	ptr = "XmDIALOG_MODELESS";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtDialogueTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmDIALOG_TEMPLATE:
	ptr = "XmDIALOG_TEMPLATE";
	break;
    case XmDIALOG_ERROR:
	ptr = "XmDIALOG_ERROR";
	break;
    case XmDIALOG_INFORMATION:
	ptr = "XmDIALOG_INFORMATION";
	break;
    case XmDIALOG_MESSAGE:
	ptr = "XmDIALOG_MESSAGE";
	break;
    case XmDIALOG_QUESTION:
	ptr = "XmDIALOG_QUESTION";
	break;
    case XmDIALOG_WARNING:
	ptr = "XmDIALOG_WARNING";
	break;
    case XmDIALOG_WORKING:
	ptr = "XmDIALOG_WORKING";
	break;

    default:
	fprintf (stderr,
		 "%s: DialogueType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: DialogueType: assuming XmDIALOG_MESSAGE.\n",
		 XtentProgramName ());

	ptr = "XmDIALOG_MESSAGE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtEditModeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int x;

    x = (int) *((int *) from_val -> addr);

    switch (x)
    {
    case XmSINGLE_LINE_EDIT:
	ptr = "XmSINGLE_LINE_EDIT";
	break;
    case XmMULTI_LINE_EDIT:
	ptr = "XmMULTI_LINE_EDIT";
	break;
    default:
	fprintf (stderr,
		 "%s: EditMode value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: EditMode: assuming XmSINGLE_LINE_EDIT.\n",
		 XtentProgramName ());

	ptr = "XmSINGLE_LINE_EDIT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtFileTypeMaskToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmFILE_REGULAR:
	ptr = "XmFILE_REGULAR";
	break;
    case XmFILE_DIRECTORY:
	ptr = "XmFILE_DIRECTORY";
	break;
    case XmFILE_ANY_TYPE:
	ptr = "XmFILE_ANY_TYPE";
	break;
    default:
	fprintf (stderr,
		 "%s: FileTypeMask value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: FileTypeMask: assuming XmFILE_REGULAR.\n",
		 XtentProgramName ());

	ptr = "XmFILE_REGULAR";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtIndicatorTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    case XmONE_OF_MANY:
	ptr = "XmONE_OF_MANY";
	break;
    case XmN_OF_MANY:
	ptr = "XmN_OF_MANY";
	break;
    default:
	fprintf (stderr,
		 "%s: IndicatorType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: IndicatorType: assuming XmONE_OF_MANY.\n",
		 XtentProgramName ());

	ptr = "XmONE_OF_MANY";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtInitialStateToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int x;

    x = (int) *((int *) from_val -> addr);

    switch (x)
    {
    case NormalState:
	ptr = "NormalState";
	break;
    case IconicState:
	ptr = "IconicState";
	break;
    default:
	fprintf (stderr,
		 "%s: InitialState value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: InitialState: assuming NormalState.\n",
		 XtentProgramName ());

	ptr = "NormalState";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtKeySymToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    KeySym c;
    static char buf[2];

    c = *((KeySym *) from_val -> addr);
    buf[0] = (char ) c;
    buf[1] = '\0';
    xtentConverterReturnString (to_val, buf, 2);
}

static Boolean
xtentCvtLabelTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: LabelType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: LabelType: assuming XmSTRING.\n",
		 XtentProgramName ());
    case XmSTRING:
	ptr = "XmSTRING";
	break;
    case XmPIXMAP:
	ptr = "XmPIXMAP";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtListSizePolicyToString (display, args, num_args, from_val, to_val,
				data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ListSizePolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ListSizePolicy: assuming XmVARIABLE.\n",
		 XtentProgramName ());
    case XmVARIABLE:
	ptr = "XmVARIABLE";
	break;
    case XmCONSTANT:
	ptr = "XmCONSTANT";
	break;
    case XmRESIZE_IF_POSSIBLE:
	ptr = "XmRESIZE_IF_POSSIBLE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtMultiClickToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: MultiClick value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: MultiClick: assuming XmMULTICLICK_DISCARD.\n",
		 XtentProgramName ());
    case XmMULTICLICK_DISCARD:
	ptr = "XmMULTICLICK_DISCARD";
	break;
    case XmMULTICLICK_KEEP:
	ptr = "XmMULTICLICK_KEEP";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtNavigationTypeToString (display, args, num_args, from_val, to_val,
				data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: NavigationType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: NavigationType: assuming XmTAB_GROUP.\n",
		 XtentProgramName ());
    case XmTAB_GROUP:
	ptr = "XmTAB_GROUP";
	break;
    case XmNONE:
	ptr = "XmNONE";
	break;
    case XmSTICKY_TAB_GROUP:
	ptr = "XmSTICKY_TAB_GROUP";
	break;
    case XmEXCLUSIVE_TAB_GROUP:
	ptr = "XmEXCLUSIVE_TAB_GROUP";
	break;
    }
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtOrientationToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: Orientation value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: Orientation: assuming XmVERTICAL.\n",
		 XtentProgramName ());
    case XmVERTICAL:
	ptr = "XmVERTICAL";
	break;
    case XmHORIZONTAL:
	ptr = "XmHORIZONTAL";
	break;
    case XmNO_ORIENTATION:
	ptr = "XmNO_ORIENTATION";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtPackingToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: Packing value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: Packing: assuming XmNO_PACKING.\n",
		 XtentProgramName ());
    case XmNO_PACKING:
	ptr = "XmNO_PACKING";
	break;
    case XmPACK_TIGHT:
	ptr = "XmPACK_TIGHT";
	break;
    case XmPACK_COLUMN:
	ptr = "XmPACK_COLUMN";
	break;
    case XmPACK_NONE:
	ptr = "XmPACK_NONE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtProcessingDirectionToString (display, args, num_args, from_val,
				     to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ProcessingDirection value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ProcessingDirection: assuming XmMAX_ON_TOP.\n",
		 XtentProgramName ());
    case XmMAX_ON_TOP:
	ptr = "XmMAX_ON_TOP";
	break;
    case XmMAX_ON_BOTTOM:
	ptr = "XmMAX_ON_BOTTOM";
	break;
    case XmMAX_ON_LEFT:
	ptr = "XmMAX_ON_LEFT";
	break;
    case XmMAX_ON_RIGHT:
	ptr = "XmMAX_ON_RIGHT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtResizePolicyToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ResizePolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ResizePolicy: assuming XmRESIZE_ANY.\n",
		 XtentProgramName ());
    case XmRESIZE_ANY:
	ptr = "XmRESIZE_ANY";
	break;
    case XmRESIZE_NONE:
	ptr = "XmRESIZE_NONE";
	break;
    case XmRESIZE_GROW:
	ptr = "XmRESIZE_GROW";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtRowColumnTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: RowColumnType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: RowColumnType: assuming XmWORK_AREA.\n",
		 XtentProgramName ());
    case XmWORK_AREA:
	ptr = "XmWORK_AREA";
	break;
    case XmMENU_BAR:
	ptr = "XmMENU_BAR";
	break;
    case XmMENU_PULLDOWN:
	ptr = "XmMENU_PULLDOWN";
	break;
    case XmMENU_POPUP:
	ptr = "XmMENU_POPUP";
	break;
    case XmMENU_OPTION:
	ptr = "XmMENU_OPTION";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtScrollBarDisplayPolicyToString (display, args, num_args,
					from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ScrollBarDisplayPolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ScrollBarDisplayPolicy: assuming XmAS_NEEDED.\n",
		 XtentProgramName ());
    case XmAS_NEEDED:
	ptr = "XmAS_NEEDED";
	break;
    case XmSTATIC:
	ptr = "XmSTATIC";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtScrollBarPlacementToString (display, args, num_args,
				    from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ScrollBarPlacement value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ScrollBarPlacement: assuming TOP_LEFT.\n",
		 XtentProgramName ());
    case XmTOP_LEFT:
	ptr = "XmTOP_LEFT";
	break;
    case XmBOTTOM_LEFT:
	ptr = "XmBOTTOM_LEFT";
	break;
    case XmTOP_RIGHT:
	ptr = "XmTOP_RIGHT";
	break;
    case XmBOTTOM_RIGHT:
	ptr = "XmBOTTOM_RIGHT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtScrollingPolicyToString (display, args, num_args, from_val,
				 to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ScrollingPolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ScrollingPolicy: assuming XmAUTOMATIC.\n",
		 XtentProgramName ());
    case XmAUTOMATIC:
	ptr = "XmAUTOMATIC";
	break;
    case XmAPPLICATION_DEFINED:
	ptr = "XmAPPLICATION_DEFINED";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtSelectionPolicyToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: SelectionPolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: SelectionPolicy: assuming XmSINGLE_SELECT.\n",
		 XtentProgramName ());
    case XmSINGLE_SELECT:
	ptr = "XmSINGLE_SELECT";
	break;
    case XmMULTIPLE_SELECT:
	ptr = "XmMULTIPLE_SELECT";
	break;
    case XmEXTENDED_SELECT:
	ptr = "XmEXTENDED_SELECT";
	break;
    case XmBROWSE_SELECT:
	ptr = "XmBROWSE_SELECT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtSelectionTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: SelectionType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: SelectionType: assuming XmDIALOG_SELECTION.\n",
		 XtentProgramName ());
    case XmDIALOG_SELECTION:
	ptr = "XmDIALOG_SELECTION";
	break;
    case XmDIALOG_WORK_AREA:
	ptr = "XmDIALOG_WORK_AREA";
	break;
    case XmDIALOG_PROMPT:
	ptr = "XmDIALOG_PROMPT";
	break;
    case XmDIALOG_COMMAND:
	ptr = "XmDIALOG_COMMAND";
	break;
    case XmDIALOG_FILE_SELECTION:
	ptr = "XmDIALOG_FILE_SELECTION";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtSeparatorTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: SeparatorType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: SeparatorType: assuming XmSINGLE_LINE.\n",
		 XtentProgramName ());
    case XmSINGLE_LINE:
	ptr = "XmSINGLE_LINE";
	break;
    case XmNO_LINE:
	ptr = "XmNO_LINE";
	break;
    case XmDOUBLE_LINE:
	ptr = "XmDOUBLE_LINE";
	break;
    case XmSINGLE_DASHED_LINE:
	ptr = "XmSINGLE_DASHED_LINE";
	break;
    case XmDOUBLE_DASHED_LINE:
	ptr = "XmDOUBLE_DASHED_LINE";
	break;
    case XmSHADOW_ETCHED_IN:
	ptr = "XmSHADOW_ETCHED_IN";
	break;
    case XmSHADOW_ETCHED_OUT:
	ptr = "XmSHADOW_ETCHED_OUT";
	break;
    case XmSHADOW_ETCHED_IN_DASH:
	ptr = "XmSHADOW_ETCHED_IN_DASH";
	break;
    case XmSHADOW_ETCHED_OUT_DASH:
	ptr = "XmSHADOW_ETCHED_OUT_DASH";
	break;
    case XmINVALID_SEPARATOR_TYPE:
	ptr = "XmINVALID_SEPARATOR_TYPE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtShadowTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: ShadowType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: ShadowType: assuming XmSHADOW_OUT.\n",
		 XtentProgramName ());
    case XmSHADOW_OUT:
	ptr = "XmSHADOW_OUT";
	break;
    case XmSHADOW_IN:
	ptr = "XmSHADOW_IN";
	break;
    case XmSHADOW_ETCHED_IN:
	ptr = "XmSHADOW_ETCHED_IN";
	break;
    case XmSHADOW_ETCHED_OUT:
	ptr = "XmSHADOW_ETCHED_OUT";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtStringArrayToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
    char *ptr;
    int ptr_len;
    int total_len = 0;
    char **list;
    static char *buf;
    static int buf_len = 0;

    if (fromVal -> addr == NULL)
	xtentConverterReturnString (toVal, "None", 5);
    list = *(char ***) fromVal -> addr;
    if (list == NULL)
	xtentConverterReturnString (toVal, "None", 5);

    while (*list)
    {
	ptr = *list++;

	if (ptr && *ptr != '\0')
	{
	    if ((ptr_len = strlen (ptr)) + total_len  + 2 >= buf_len)
	    {
		buf_len = total_len + ptr_len + 64;
		buf = (char *) XtRealloc (buf, buf_len);
	    }
	    memcpy (&buf[total_len], ptr, ptr_len);
	    total_len += ptr_len;
	    buf[total_len] = '\\';
	    total_len++;
	    buf[total_len] = 'n';
	    total_len++;
	}
    }
    if (total_len)
    {
	total_len -= 2;
	buf[total_len] = '\0';
	xtentConverterReturnString (toVal, buf, total_len);
    }
    else
	xtentConverterReturnString (toVal, "None", 5);
}

static Boolean
xtentCvtStringDirectionToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    int x;

    x = (int) *((int *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: StringDirection value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: StringDirection: assuming XmSTRING_DIRECTION_DEFAULT.\n",
		 XtentProgramName ());
    case XmSTRING_DIRECTION_DEFAULT:
	ptr = "XmSTRING_DIRECTION_DEFAULT";
	break;
    case XmSTRING_DIRECTION_L_TO_R:
	ptr = "XmSTRING_DIRECTION_L_TO_R";
	break;
    case XmSTRING_DIRECTION_R_TO_L:
	ptr = "XmSTRING_DIRECTION_R_TO_L";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtTearOffModelToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: TearOffModel value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: TearOffModel: assuming XmTEAR_OFF_DISABLED.\n",
		 XtentProgramName ());
    case XmTEAR_OFF_DISABLED:
	ptr = "XmTEAR_OFF_DISABLED";
	break;
    case XmTEAR_OFF_ENABLED:
	ptr = "XmTEAR_OFF_ENABLED";
	break;
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtUnitTypeToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: UnitType value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: UnitType: assuming XmPIXELS.\n",
		 XtentProgramName ());
    case XmPIXELS:
	ptr = "XmPIXELS";
	break;
    case Xm100TH_MILLIMETERS:
	ptr = "Xm100TH_MILLIMETERS";
	break;
    case Xm1000TH_INCHES:
	ptr = "Xm1000TH_INCHES";
	break;
    case Xm100TH_POINTS:
	ptr = "Xm100TH_POINTS";
	break;
    case Xm100TH_FONT_UNITS:
	ptr = "Xm100TH_FONT_UNITS";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtVerticalAlignmentToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: VerticalAlignment value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: VerticalAlignment: assuming XmALIGNMENT_BASELINE_TOP.\n",
		 XtentProgramName ());
    case XmALIGNMENT_BASELINE_TOP:
	ptr = "XmALIGNMENT_BASELINE_TOP";
	break;
    case XmALIGNMENT_BASELINE_BOTTOM:
	ptr = "XmALIGNMENT_BASELINE_BOTTOM";
	break;
    case XmALIGNMENT_CONTENTS_BOTTOM:
	ptr = "XmALIGNMENT_CONTENTS_BOTTOM";
	break;
    case XmALIGNMENT_CENTER:
	ptr = "XmALIGNMENT_CENTER";
	break;
    case XmALIGNMENT_CONTENTS_TOP:
	ptr = "XmALIGNMENT_CONTENTS_TOP";
    }
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtVisualToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    Visual *x;
    Visual tmp;

    x = (Visual *) *((Visual **) from_val -> addr);
    if (x == NULL)
    {
	x = &tmp;
	tmp.class = PseudoColor;
    }

    switch (x -> class)
    {
    default:
	fprintf (stderr,
		 "%s: Visual value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: Visual: assuming PseudoColor.\n",
		 XtentProgramName ());
    case PseudoColor:
	ptr = "PseudoColor";
	break;
    case StaticGray:
	ptr = "StaticGray";
	break;
    case GrayScale:
	ptr = "GrayScale";
	break;
    case StaticColor:
	ptr = "StaticColor";
	break;
    case TrueColor:
	ptr = "TrueColor";
	break;
    case DirectColor:
	ptr = "DirectColor";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtVisualPolicyToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: VisualPolicy value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: VisualPolicy: assuming XmCONSTANT.\n",
		 XtentProgramName ());
    case XmCONSTANT:
	ptr = "XmCONSTANT";
	break;
    case XmVARIABLE:
	ptr = "XmVARIABLE";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtAttachmentToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr;
    unsigned char x;

    x = (unsigned char) *((unsigned char *) from_val -> addr);

    switch (x)
    {
    default:
	fprintf (stderr,
		 "%s: Attachment value not in the database: %d.\n",
		 XtentProgramName (), x);
	fprintf (stderr,
		 "%s: Attachment: assuming XmATTACH_NONE.\n",
		 XtentProgramName ());
    case XmATTACH_NONE:
	ptr = "XmATTACH_NONE";
	break;
    case XmATTACH_FORM:
	ptr = "XmATTACH_FORM";
	break;
    case XmATTACH_OPPOSITE_FORM:
	ptr = "XmATTACH_OPPOSITE_FORM";
	break;
    case XmATTACH_WIDGET:
	ptr = "XmATTACH_WIDGET";
	break;
    case XmATTACH_OPPOSITE_WIDGET:
	ptr = "XmATTACH_OPPOSITE_WIDGET";
	break;
    case XmATTACH_POSITION:
	ptr = "XmATTACH_POSITION";
	break;
    case XmATTACH_SELF:
	ptr = "XmATTACH_SELF";
    }

    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtWidgetClassToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    XtentWidgetClassName * wcn;
    WidgetClass class;
    char *ptr;

    class = (WidgetClass) *((WidgetClass *) from_val -> addr);

    if (class)
    {
	wcn = XtentWidgetClassNames;

	while (wcn -> string != (char *) NULL)
	{
	    if (*wcn -> class == class)
	    {
		ptr = wcn -> string;
		xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
	    }
	    wcn++;
	}
    }

    ptr = "None";
    xtentConverterReturnString (to_val, ptr, strlen (ptr) + 1);
}

static Boolean
xtentCvtStringToWidgetClass (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    static WidgetClass class;
    XtentWidgetClassName * wcn;
    char *ptr;

    ptr = (char *) from_val -> addr;
    if (ptr == (char *) NULL)
    {
	to_val -> size = 0;
	to_val -> addr = (XtPointer) NULL;
	return FALSE;
    }

    wcn = XtentWidgetClassNames;

    while (wcn -> string != (char *) NULL)
    {
	if (strcmp (ptr, wcn -> string) == 0)
	{
	    class = *wcn -> class;
	    XtConverterReturn (WidgetClass, class, to_val);
	}
	wcn++;
    }

    class = (WidgetClass) NULL;
    XtConverterReturn (WidgetClass, class, to_val);
}

static Boolean
xtentCvtXmStringToString (display, args, num_args, from_val, to_val, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr from_val;
XrmValuePtr to_val;
XtPointer data;
{
    char *ptr, *initial_ptr;
    int ptr_len;
    static char *buf;
    static int buf_len = 0;
	
    if (from_val -> addr == (XtPointer) NULL ||
	* ((XtPointer *) from_val -> addr) == (XtPointer) NULL)
    {
	ptr = "";
	initial_ptr = (char *) NULL;
    }
    else
    {
	if (XmStringGetLtoR (* (XmString *) from_val -> addr,
			     (XmString) XmFONTLIST_DEFAULT_TAG, &ptr) == False)
	    ptr == (char *) NULL;

	initial_ptr = ptr;

	if (ptr == (char *) NULL)
	    ptr = "";
    }

    if ((ptr_len = strlen (ptr) + 1) >= buf_len)
    {
	buf_len = ptr_len + 32;
	buf = (char *) XtRealloc (buf, buf_len);
    }
    memcpy (buf, ptr, ptr_len);

    XtFree (initial_ptr);

    xtentConverterReturnString (to_val, buf, ptr_len);
}

static Boolean
xtentCvtXmStringTableToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
    static char buf[64];
    XmString *list;

    if (fromVal -> addr == NULL)
	xtentConverterReturnString (toVal, "None", 5);
    list = *(XmString **) fromVal -> addr;
    if (list == NULL)
	xtentConverterReturnString (toVal, "None", 5);

    sprintf (buf, "%d", list);
    xtentConverterReturnString (toVal, buf, strlen (buf) + 1);
}

char *
xtentXmCvtXmStringTableToString (list, count)
long list;
int count;
{
    static char *buf;
    static int buf_len = 0;
    char *ptr, *initial_ptr;
    int ptr_len;
    int total_len = 0;
    XmString *st_list = (XmString *) list;
    int i;

    if (list == NULL)
	return "None";

    for (i = 0; i < count; i++)
    {
	if (XmStringGetLtoR (st_list[i],
			     (XmString) XmFONTLIST_DEFAULT_TAG, &ptr) == False)
	    ptr == (char *) NULL;

	initial_ptr = ptr;

	if (ptr == (char *) NULL)
	    ptr = "";

	if ((ptr_len = strlen (ptr)) + total_len  + 2 >= buf_len)
	{
	    buf_len = total_len + ptr_len + 64;
	    buf = (char *) XtRealloc (buf, buf_len);
	}
	memcpy (&buf[total_len], ptr, ptr_len);
	XtFree (initial_ptr);
	total_len += ptr_len;
	buf[total_len] = '\\';
	total_len++;
	buf[total_len] = 'n';
	total_len++;
    }
    if (total_len)
    {
	total_len -= 2;
	buf[total_len] = '\0';
    }
    return buf;
}
#endif /* MOTIF */
