static char TMxtent_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <fcntl.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/ObjectP.h>
#include <X11/Xatom.h>
#include <math.h>
#include "xtent.h"
#include "xtent_quark.h"
#include "hs.regexp.h"
#include "XIpc.h"
#include "xtent_xipc.h"

#include <sys/types.h>
#include <sys/stat.h>
#if defined(__STDC__)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/*
 * supported widgets
 */
#include "xtent_wdgts.h"

#ifdef MOTIF
#include <Xm/CutPaste.h>
#include <Xm/Protocols.h>
#include <Xm/RepType.h>
#endif /* MOTIF */

#ifdef OENLOOK
#include <Xol/OpenLookP.h>  /* RAD - contains OL_VERSION */
#endif /* OPENLOOK */

/*
 * define small switches to avoid switch length problems
 */
/*
#define SMALL_SWITCHES
*/

/*
 * macros used by xtent routines
 */
#define ArgN(index)\
	XtentProcessArgN (display, toplevel_ptr, &frame_data, index, True)

#define ArgNReturn(x)\
{\
     XtentLocalVariable (display, XtentVariablesPop,\
			 frame_data.frame, NULL, NULL);\
     XtentReleaseFrame (&frame_data);\
     return x;\
}

#define ArgNReturnVoid()\
{\
     XtentLocalVariable (display, XtentVariablesPop,\
			 frame_data.frame, NULL, NULL);\
     XtentReleaseFrame (&frame_data);\
     return;\
}

#define XtentAbs(x) (x < 0 ? -x : x)

/*
 * op code table
 */
typedef enum
{
	NoOp = 0,
	AddCallback,
	_AddCallback,
	AddCallbackWithArgs,
	_AddCallbackWithArgs,
	AddEventHandler,
	_AddEventHandler,
	AddRawEventHandler,
	_AddRawEventHandler,
	AddGrab,
	AppAddAction,
	AppAddInput,
	AppAddInputNonBlocking,
	AppAddTimeOut,
	_AppAddTimeOut,
	AppAddWorkProc,
	_AppAddWorkProc,
	AppCreateShell,
	AppError,
	AppErrorMsg,
	AppMainLoop,
	AppWarning,
	AppWarningMsg,
	AugmentTranslations,
	_AugmentTranslations,
	BuildEventMask,
	CallCallbacks,
	Class,
	ConfigureWidget,
	VaCreateManagedWidget,
	VaCreatePopupShell,
	VaCreateWidget,
	CreateManagedWidget,
	CreatePopupShell,
	CreateWidget,
	DestroyWidget,
	DisownSelection,
	GetMultiClickTime,
	GetSelectionValue,
	_GetSelectionValue,
	GetValue,
	GetValues,
	GetValueWithType,
	GrabButton,
	GrabKey,
	GrabKeyboard,
	GrabPointer,
	HasCallbacks,
	Initialize,
	InsertEventHandler,
	_InsertEventHandler,
	InsertRawEventHandler,
	_InsertRawEventHandler,
	InstallAccelerators,
	InstallAllAccelerators,
	IsComposite,
	IsManaged,
	IsRealized,
	LastTimestampProcessed,
	ManageChild,
	ManageChildren,
	MapWidget,
	MoveWidget,
	OverrideTranslations,
	_OverrideTranslations,
	OwnSelection,
	_OwnSelection,
	Parent,
	Popdown,
	Popup,
	PopupSpringLoaded,
	RealizeWidget,
	RemoveAllCallbacks,
	RemoveCallback,
	RemoveEventHandler,
	RemoveGrab,
	RemoveInput,
	RemoveRawEventHandler,
	RemoveTimeOut,
	RemoveWorkProc,
	ReplaceTranslations,
	_ReplaceTranslations,
	ResizeWidget,
	SetKeyboardFocus,
	SetMappedWhenManaged,
	SetMultiClickTime,
	SetSensitive,
	SetValue,
	SetValues,
	SetValueWithType,
	Sync,
	TranslateCoords,
	UngrabButton,
	UngrabKey,
	UngrabKeyboard,
	UngrabPointer,
	UninstallTranslations,
	UnmanageChild,
	UnmanageChildren,
	UnmapWidget,
	UnrealizeWidget,
	WINdow,
	WindowToWidget,

	AddCFunction,
	AddFunction,
	AddThisFunction,
	AllocColor,
	Argc,
	Argv,
	Bell,
	Case,
	_Case,
	ConvertCtoResources,
	CopyFunction,
	CreateColormap,
	CreateImageCursor,
	CreateResourceList,
	DefineCursor,
	DestroyResourceList,
	DragWidget,
	EvalLine,
	_EvalLine,
	EvalLines,
	_EvalLines,
	Eval,
	_Eval,
	Exit,
	ForEach,
	_ForEach,
	ForEachArg,
	_ForEachArg,
	FreeColor,
	FreeColormap,
	FreeImage,
	FreeImageCursor,
	FreePixmap,
	FunctionArg,
	Get,
	GetImage,
	GetPixel,
	GetPoint,
	GetRect,
	GetWidget,
	If,
	_If,
	Include,
	InternLines,
	InternShellVariables,
	IsWidget,
	Iterate,
	_Iterate,
	LocalVariables,
	LowerWidget,
	MapWindow,
	Print,
	PrintOperations,
	PrintResources,
	PrintWidgetClasses,
	PrintWidgetResources,
	PrintWidgets,
	QueryPixel,
	QueryPointer,
	RaiseWidget,
	ReadImage,
	ReadPixmap,
	ReparentWindow,
	Return,
	ReturnN,
	ScaleImage,
	Set,
	SetShellVariables,
	SetStdin,
	SetStdout,
	SetStderr,
	ShellEscape,
	_ShellEscape,
	StringSize,
	UnmapWindow,
	UnsetShellVariables,
	WarpPointer,
	While,
	_While,
	WriteImage,
	WritePixmap,
	OldIf,
	_OldIf,
	OldWhile,
	_OldWhile,

	Add,
	Calc,
	DoubleCalc,
	Sub,
	Mult,
	Div,
	Hex,

	AddXIpc,
	RemoveXIpc,
	Send,

	XIPCSetupPortServer,
	_XIPCSetupPortServer,
	XIPCCloseServer,
	XIPCServerSetClientCleanup,
	_XIPCServerSetClientCleanup,

	XIPCSendToClient,
	XIPCFlushServer,

	XIPCServerClientSynchronize,
	XIPCIsServerClientActive,

	XIPCServerProcessMessage,
	XIPCServerCloseClient,

	XIPCSetupKeyClient,
	_XIPCSetupKeyClient,
	XIPCCloseClient,
	XIPCSetClientCleanup,
	_XIPCSetClientCleanup,

	XIPCSendToServer,
	XIPCFlushClient,

	XIPCClientSynchronize,
	XIPCIsClientActive,

	XIPCCatchErrors,

/* RAD */
#ifdef LIB_E
	AbortE,
	AddG2FdE,
	AddG2FdLongE,
	_AddG2FdLongE,
	AnnounceE,
	AnnounceLongE,
	_AnnounceLongE,
	AtExitE,
	_AtExitE,
	BlockE,
	CancelTimersE,
	ClearTraceE,
	ConnectE,
	ConnectLongE,
	_ConnectLongE,
	ErrorE,
	ExitE,
	FatalE,
	FyiE,
	InitE,
	LogE,
	LogMsgE,
	MsgEvalE,
	PutE,
	PutMsgE,
	ReleaseE,
	ResetHiWaterE,
	RemoveAllChanCbsE,
	RemoveAllMsgCbsE,
	RemoveChanCbE,
	RemoveMsgCbE,
	SetChanCbE,
	_SetChanCbE,
	SetClientConnectCbE,
	_SetClientConnectCbE,
	SetClientHiWaterCbE,
	_SetClientHiWaterCbE,
	SetFyiE,
	SetMsgCbE,
	_SetMsgCbE,
	SetOrphanCbE,
	_SetOrphanCbE,
	SetReleaseCbE,
	_SetReleaseCbE,
	SetServerHiWaterCbE,
	_SetServerHiWaterCbE,
	SetSvcConnectCbE,
	_SetSvcConnectCbE,
	SetTimerE,
	_SetTimerE,
	SetTraceE,
	SetWarningE,
	SyncCbE,
	_SyncCbE,
	TimedSyncCbE,
	_TimedSyncCbE,
	TraceE,
	TraceMsgE,
	UnBlockE,
	WarningE,
	WithdrawE,
#endif   /* LIB_E */
/* RAD */

	StrIndex,
	StrGSub,
	StrSub,
	StrLength,
	StrMatch,
	StrSplitToArgList,
	StrSplitToResource,
	StrSubstr,

	FClose,
	FFlush,
	FOpen,
	FGetS,
	FPrintF,
	PClose,
	POpen,
	SPrintF,
	StatF,

#ifdef ATHENA
	XAWListChange,
	XAWListHighlight,
	XAWListUnhighlight,
	XAWListShowCurrent,
	XAWScrollbarSetThumb,
	XAWStripChartAddValueProc,
	_XAWStripChartAddValueProc,
	XAWToggleChangeRadioGroup,
	XAWToggleGetCurrent,
	XAWToggleSetCurrent,
	XAWToggleUnsetCurrent,
	XAWSimpleMenuAddGlobalActions,
	XAWSimpleMenuGetActiveEntry,
	XAWSimpleMenuClearActiveEntry,
	XAWTextSetSelection,
	XAWTextUnsetSelection,
	XAWTextGetSelectionPos,
	XAWTextReplace,
	XAWTextSearch,
	XAWTextInvalidate,
	XAWTextEnableRedisplay,
	XAWTextDisableRedisplay,
	XAWTextDisplay,
	XAWTextTopPosition,
	XAWTextSetSelectionArray,
	XAWTextSetInsertionPoint,
	XAWTextGetInsertionPoint,
	XAWTextSetSource,
	XAWTextGetSource,
	XAWTextDisplayCaret,
	XAWAsciiSourceFreeString,
	XAWAsciiSave,
	XAWAsciiSaveAsFile,
	XAWAsciiSourceChanged,
	XAWDialogGetValueString,
	XAWFormDoLayout,
	XAWPanedAllowResize,
	XAWPanedSetMinMax,
	XAWPanedGetMinMax,
	XAWPanedSetRefigureMode,
	XAWPanedGetNumSub,
#if XT_REVISION > 4
	XAWTreeForceLayout
#endif
#endif /* AHTENA */

#ifdef MOTIF
	/*
	 * Motif functions not currently included:
	 *
	 * no uil related functions including the Mrm* functions
	 * XmCvtCtToXmString
	 * XmCvtStringToUniType
	 * XmCvtXmStringToCt
	 * font list functions
	 * XMGetAtomName()
	 * XmGetColorCalculation
	 * XmGetMenuCursor (obsolete)
	 * XmGetSecondaryResourceData
	 * XMInternAtom
	 * color calculation procedures
	 * XMGetSecondaryResourceData
	 * XMMapSegmentEncoding
	 * XMRegisterSegmentEncoding
	 * XMRepTypeGetRecord
	 * XMRepTypeGetRegistered
	 * XMResolveAllPartsOffsets
	 * XMResolvePartOffsets
	 * XMSetColorCalculaton
	 * XMSetMenuCursor (obsolete)
	 * XMSetProtocolHooks (used by widgets - internally - use callbacks)
	 * XMSetWMProtocolHooks
	 * XMStringBaseLine,
	 * XMStringByteCompare
	 * XMStringCompare
	 * XMStringConcat
	 * XMStringCopy
	 * XMStringCreate
	 * XMStringCreateLocalized
 	 * XMStringCreateLtoR
	 * XMStringCreateSimple
	 * XMStringDirectionCreate
	 * XMStringDraw
	 * XMStringDrawImage
	 * XMStringDrawUnderline
	 * XMStringEmpty
	 * XMStringExtent
	 * XMStringFree
	 * XMStringFreeContext
	 * XMStringGetLtoR
	 * XMStringGetNextComponent
	 * XMStringGetNextSegment
	 * XMstringHasSubstring
	 * XMStringHeight
	 * XMStringInitContext
	 * XMStringLength
	 * XMStringLineCount
	 * XMStringNConcat
	 * XMStringNCopy
	 * XMStringPeekNextComponent
	 * XMStringSegmentCreate
	 * XMStringSeparatorCreate
	 * XMStringWidth
	 * XMTargetsAreCompatible
	 * XMTextFieldGetSelectionWcs
	 * XMTextFieldGetStringWcs
	 * XMTextFieldGetSubstringWcs
	 * XMTextFieldInsertWcs
	 * XMTextFieldReplaceWcs
	 * XMTextFieldSetStringWcs
	 * XMTextFindStringWcs
	 * XMTextGetSelectionWcs
	 * XMTextGetStringWcs
	 * XMTextGetSubstringWcs
	 * XMTextInsertWcs
	 * XMTextReplaceWcs
	 * XMTextSetStringWcs
	 * XMTrackingLocate
	 * XMTranslateKey
	 * XMVaCreateSimpleCheckBox - create as xtent functions
	 * XMVaCreateSimpleMenuBar
	 * XMVaCreateSimpleOptionMenu
	 * XMVaCreateSimplePopupMenu
	 * XMVaCreateSimplePulldownMenu
	 * XMVaCreateSimpleRadioBox
	 *
	 * needs work:
	 *
	 * XMClipboardCopy - mainly testing
	 * XMClipboardInquirePendingItems
	 * XMClipboardStartCopy - not clear on the arg structures with these
	 * XMDropSiteRegister
	 * XMDropSiteRetrieve
	 * XMDropSiteUpdate
	 * XMDropTransferAdd
	 * XMDropTransferStart
	 * XMGetDragContext
	 * XMGetXmDisplay - check if these are producing real widgets
	 * XMGetXmScreen
	 *
	 * consider adding args to XMCreate functions - maybe xtent functions
	 *
	 */
	XMActivateProtocol,
	XMActivateWMProtocol,
	XMAddProtocolCallback,
	_XMAddProtocolCallback,
	XMAddWMProtocolCallback,
	_XMAddWMProtocolCallback,
	XMAddProtocols,
	XMAddWMProtocols,
	XMAddTabGroup,
	XMCascadeButtonGadgetHighlight,
	XMCascadeButtonHighlight,
	XMChangeColor,
	XMClipboardCancelCopy,
	XMClipboardCopy,
	XMClipboardCopyByName,
	XMClipboardEndCopy,
	XMClipboardEndRetrieve,
	XMClipboardInquireCount,
	XMClipboardInquireFormat,
	XMClipboardInquireLength,
	XMClipboardInquirePendingItems,
	XMClipboardLock,
	XMClipboardRegisterFormat,
	XMClipboardRetrieve,
	XMClipboardStartCopy,
	XMClipboardStartRetrieve,
	XMClipboardUndoCopy,
	XMClipboardUnlock,
	XMClipboardWithdrawFormat,
	XMCommandAppendValue,
	XMCommandError,
	XMCommandGetChild,
	XMCommandSetValue,
	XMConvertUnits,
	XMCreateArrowButton,
	XMCreateArrowButtonGadget,
	XMCreateBulletinBoard,
	XMCreateBulletinBoardDialog,
	XMCreateCascadeButton,
	XMCreateCascadeButtonGadget,
	XMCreateCommand,
	XMCreateDialogShell,
	XMCreateDragIcon,
	XMCreateDrawingArea,
	XMCreateDrawnButton,
	XMCreateErrorDialog,
	XMCreateFileSelectionBox,
	XMCreateFileSelectionDialog,
	XMCreateForm,
	XMCreateFormDialog,
	XMCreateFrame,
	XMCreateInformationDialog,
	XMCreateLabel,
	XMCreateLabelGadget,
	XMCreateList,
	XMCreateMainWindow,
	XMCreateMenuBar,
	XMCreateMenuShell,
	XMCreateMessageBox,
	XMCreateMessageDialog,
	XMCreateOptionMenu,
	XMCreatePanedWindow,
	XMCreatePopupMenu,
	XMCreatePromptDialog,
	XMCreatePulldownMenu,
	XMCreatePushButton,
	XMCreatePushButtonGadget,
	XMCreateQuestionDialog,
	XMCreateRadioBox,
	XMCreateRowColumn,
	XMCreateScale,
	XMCreateScrollBar,
	XMCreateScrolledList,
	XMCreateScrolledText,
	XMCreateScrolledWindow,
	XMCreateSelectionBox,
	XMCreateSelectionDialog,
	XMCreateSeparator,
	XMCreateSeparatorGadget,
	XMCreateSimpleCheckBox,
	XMCreateSimpleMenuBar,
	XMCreateSimpleOptionMenu,
	XMCreateSimplePopupMenu,
	XMCreateSimplePulldownMenu,
	XMCreateSimpleRadioBox,
	XMCreateTemplateDialog,
	XMCreateText,
	XMCreateTextField,
	XMCreateToggleButton,
	XMCreateToggleButtonGadget,
	XMCreateWorkArea,
	XMCreateWorkingDialog,
	XMDeactivateProtocol,
	XMDeactivateWMProtocol,
	XMDestroyPixmap,
	XMDragStart,
	XMDropSiteConfigureStackingOrder,
	XMDropSiteEndUpdate,
	XMDropSiteQueryStackingOrder,
	XMDropSiteRegister,
	XMDropSiteRetrieve,
	XMDropSiteStartUpdate,
	XMDropSiteUnregister,
	XMDropSiteUpdate,
	XMDropTransferAdd,
	XMDropTransferStart,
	XMFileSelectionBoxGetChild,
	XMFileSelectionDoSearch,
	XMGetColors,
	XMGetDestination,
	XMGetDragContext,
	XMGetFocusWidget,
	XMGetPixmap,
	XMGetPixmapByDepth,
	XMGetPostedFromWidget,
	XMGetTabGroup,
	XMGetTearOffControl,
	XMGetVisibility,
	XMGetXmDisplay,
	XMGetXmScreen,
	XMInstallImage,
	XMIsMotifWMRunning,
	XMIsTraversable,	
	XMListAddItem,
	XMListAddItemUnselected,
	XMListAddItems,
	XMListAddItemsUnselected,
	XMListDeleteAllItems,
	XMListDeleteItem,
	XMListDeleteItems,
	XMListDeleteItemsPos,
	XMListDeletePos,
	XMListDeletePositions,
	XMListDeselectAllItems,
	XMListDeselectItem,
	XMListDeselectPos,
	XMListGetKbdItemPos,
	XMListGetMatchPos,
	XMListGetSelectedPos,
	XMListItemExists,
	XMListItemPos,
	XMListPosSelected,
	XMListPosToBounds,
	XMListReplaceItems,
	XMListReplaceItemsPos,
	XMListReplaceItemsPosUnselected,
	XMListReplaceItemsUnselected,
	XMListReplacePositions,
	XMListSelectItem,
	XMListSelectPos,
	XMListSetAddMode,
	XMListSetBottomItem,
	XMListSetBottomPos,
	XMListSetHorizPos,
	XMListSetItem,
	XMListSetKbdItemPos,
	XMListSetPos,
	XMListUpdateSelectedList,
	XMListYToPos,
	XMMainWindowSep1,
	XMMainWindowSep2,
	XMMainWindowSep3,
	XMMainWindowSetAreas,
	XMMenuPosition,
	XMMessageBoxGetChild,
	XMOptionButtonGadget,
	XMOptionLabelGadget,
	XMProcessTraversal,
	XMRemoveProtocolCallback,
	XMRemoveProtocols,
	XMRemoveTabGroup,
	XMRemoveWMProtocolCallback,
	XMRemoveWMProtocols,
	XMRepTypeAddReverse,
	XMRepTypeGetId,
	XMRepTypeGetNameList,
	XMRepTypeInstallTearOffModelConverter,
	XMRepTypeRegister,
	XMRepTypeValidValue,
	XMScaleGetValue,
	XMScaleSetValue,
	XMScrollBarGetValues,
	XMScrollBarSetValues,
	XMScrollVisible,
	XMScrolledWindowSetAreas,
	XMSelectionBoxGetChild,
	XMSetFontUnit,
	XMSetFontUnits,
	XMTextClearSelection,
	XMTextCopy,
	XMTextCut,
	XMTextDisableRedisplay,
	XMTextEnableRedisplay,
	XMTextFieldClearSelection,
	XMTextFieldCopy,
	XMTextFieldCut,
	XMTextFieldGetBaseLine,
	XMTextFieldGetEditable,
	XMTextFieldGetInsertionPosition,
	XMTextFieldGetLastPosition,
	XMTextFieldGetMaxLength,
	XMTextFieldGetSelection,
	XMTextFieldGetSelectionPosition,
	XMTextFieldGetString,
	XMTextFieldGetSubstring,
	XMTextFieldInsert,
	XMTextFieldPaste,
	XMTextFieldPosToXY,
	XMTextFieldRemove,
	XMTextFieldReplace,
	XMTextFieldSetAddMode,
	XMTextFieldSetEditable,
	XMTextFieldSetHighlight,
	XMTextFieldSetInsertionPosition,
	XMTextFieldSetMaxLength,
	XMTextFieldSetSelection,
	XMTextFieldSetString,
	XMTextFieldShowPosition,
	XMTextFieldXYToPos,
	XMTextFindString,
	XMTextGetBaseLine,
	XMTextGetEditable,
	XMTextGetInsertionPosition,
	XMTextGetLastPosition,
	XMTextGetMaxLength,
	XMTextGetSelection,
	XMTextGetSelectionPosition,
	XMTextGetSource,
	XMTextGetString,
	XMTextGetSubstring,
	XMTextGetTopCharacter,
	XMTextInsert,
	XMTextPaste,
	XMTextPosToXY,
	XMTextRemove,
	XMTextReplace,
	XMTextScroll,
	XMTextSetAddMode,
	XMTextSetEditable,
	XMTextSetHighlight,
	XMTextSetInsertionPosition,
	XMTextSetMaxLength,
	XMTextSetSelection,
	XMTextSetSource,
	XMTextSetString,
	XMTextSetTopCharacter,
	XMTextShowPosition,
	XMTextXYToPos,
	XMToggleButtonGadgetGetState,
	XMToggleButtonGadgetSetState,
	XMToggleButtonGetState,
	XMToggleButtonSetState,
	XMTrackingEvent,
	XMUninstallImage,
	XMUpdateDisplay,
	XMWidgetGetBaselines,
	XMWidgetGetDisplayRect,

	XMCvtXmStringTableToString,
	XMReinstallXtentConverters

#endif /* MOTIF */

#ifdef OPENLOOK
	OLAddCallback,		/* SCU */
	_OLAddCallback,
	OLAddCallbackWithArgs,
	_OLAddCallbackWithArgs,

	OLMMToPixel,
	OLPointToPixel,
	OLPixelToMM,
	OLPixelToPoint,
	OL_MMToPixel,
	OL_PointToPixel,
	OL_PixelToMM,
	OL_PixelToPoint,

	OLRegisterHelp,
	OLInitialize,

	OLCallAcceptFocus,
	OLMoveFocus,
	OLCanAcceptFocus,
	OLHasFocus,
	OLSetInputFocus,
	OLGetCurrentFocusWidget,

	TextClearBuffer,
	TextCopyBuffer,
	TextGetInsertPoint,
	TextGetLastPos,
	TextInsert,
	TextReadSubString,
	TextRedraw,
	TextReplace,
	TextSetInsertPoint,
	TextUpdate,

	OLTextEditClearBuffer,
	OLTextEditCopyBuffer,
	OLTextEditCopySelection,
	OLTextEditGetCursorPosition,
	OLTextEditGetLastPosition,
	OLTextEditInsert,
	OLTextEditPaste,
	OLTextEditReadSubString,
	OLTextEditRedraw,
	OLTextEditSetCursorPosition,
	OLTextEditUpdate,

	OLTextFieldCopyString,
	OLTextFieldGetString,

	OLMenuPopup,
	OLMenuPopdown,
	OLMenuPost,
	OLMenuUnpost,

	OLSLApplAddItem,
	OLSLApplDeleteItem,
	OLSLApplEditClose,
	OLSLApplEditOpen,
	OLSLApplTouchItem,
	OLSLApplUpdateView,
	OLSLApplViewItem,

	OLDnDAllocTransientAtom,
	OLDnDBeginSelectionTransaction,
	OLDnDChangeDropSitePreviewHints,
	OLDnDClearDragState,
	OLDnDDeliverPreviewMessage,
	OLDnDDeliverTriggerMessage,
	OLDnDDestroyDropSite,
	OLDnDDisownSelection,
	OLDnDDragAndDrop,
	OLDnDDragNDropDone,
	OLDnDEndSelectionTransaction,
	OLDnDErrorDuringSelectionTransaction,
	OLDnDFreeTransientAtom,
	OLDnDGetCurrentSelectionsForWidget,
	OLDnDGetDropSitesOfWidget,
	OLDnDGetDropSitesOfWindow,
	OLDnDGetWidgetOfDropSite,
	OLDnDGetWindowOfDropSite,
	OLDnDInitializeDragState,
	OLDnDOwnSelection,
	OLDnDQueryDropSiteInfo,
	OLDnDRegisterWidgetDropSite,
	OLDnDRegisterWindowDropSite,
	OLDnDSetDropSiteInterest,
	OLDnDSetInterestInWidgetHier,
	OLDnDUpdateDropSiteGeometry,
	OLDnDWidgetConfiguredInHier,

	OLGrabDragPointer,
	OLUngrabDragPointer
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	TextClearBuffer,
	TextCopyBuffer,
	TextReadSubString,
	TextCopySelection,
	TextUnsetSelection,
	TextSetSelection,
	TextGetSelectionPos,
	TextInsert,
	TextReplace,
	TextRedraw,
	TextUpdate,
	TextGetLastPos,
	TextSetInsertPos,
	TextGetInsertPos
#endif /* HP_WIDGETS */

} XtentOp;

typedef struct
{
	char *string;
	XtentOp type;
} Operation;

static Operation Operations[] =
{
    { "AddCallback",		AddCallback		 },
    { "_AddCallback",		_AddCallback		 },
    { "AddCallbackWithArgs",	AddCallbackWithArgs	 },
    { "_AddCallbackWithArgs",	_AddCallbackWithArgs	 },
    { "AddEventHandler",	AddEventHandler		 },
    { "_AddEventHandler",	_AddEventHandler	 },
    { "AddRawEventHandler",	AddRawEventHandler	 },
    { "_AddRawEventHandler",	_AddRawEventHandler	 },
    { "AddGrab",		AddGrab			 },
    { "AppAddAction",		AppAddAction		 },
    { "AppAddInput",		AppAddInput		 },
    { "AppAddInputNonBlocking",	AppAddInputNonBlocking	 },
    { "AppAddTimeOut",		AppAddTimeOut		 },
    { "_AppAddTimeOut",		_AppAddTimeOut		 },
    { "AppAddWorkProc",		AppAddWorkProc		 },
    { "_AppAddWorkProc",	_AppAddWorkProc		 },
    { "AppCreateShell",		AppCreateShell		 },
    { "AppError",		AppError		 },
    { "AppErrorMsg",		AppErrorMsg		 },
    { "AppMainLoop",		AppMainLoop		 },
    { "AppWarning",		AppWarning		 },
    { "AppWarningMsg",		AppWarningMsg		 },
    { "AugmentTranslations",	AugmentTranslations	 },
    { "_AugmentTranslations",	_AugmentTranslations	 },
    { "BuildEventMask",		BuildEventMask		 },
    { "CallCallbacks",		CallCallbacks		 },
    { "Class",			Class			 },
    { "ConfigureWidget",	ConfigureWidget		 },
    { "VaCreateManagedWidget",	VaCreateManagedWidget	 },
    { "VaCreatePopupShell",	VaCreatePopupShell	 },
    { "VaCreateWidget",		VaCreateWidget		 },
    { "CreateManagedWidget",	CreateManagedWidget	 },
    { "CreatePopupShell",	CreatePopupShell	 },
    { "CreateWidget",		CreateWidget		 },
    { "DestroyWidget",		DestroyWidget		 },
    { "DisownSelection",	DisownSelection		 },
    { "GetMultiClickTime",	GetMultiClickTime	 },
    { "GetSelectionValue",	GetSelectionValue	 },
    { "_GetSelectionValue",	_GetSelectionValue	 },
    { "GetValue",		GetValue		 },
    { "GetValues",		GetValues		 },
    { "GetValueWithType",	GetValueWithType	 },
    { "GrabButton",		GrabButton		 },
    { "GrabKey",		GrabKey			 },
    { "GrabKeyboard",		GrabKeyboard		 },
    { "GrabPointer",		GrabPointer		 },
    { "HasCallbacks",		HasCallbacks		 },
    { "Initialize",		Initialize		 },
    { "InsertEventHandler",	InsertEventHandler	 },
    { "_InsertEventHandler",	_InsertEventHandler	 },
    { "InsertRawEventHandler",	InsertRawEventHandler	 },
    { "_InsertRawEventHandler",	_InsertRawEventHandler	 },
    { "InstallAccelerators",	InstallAccelerators	 },
    { "InstallAllAccelerators",	InstallAllAccelerators	 },
    { "IsComposite",		IsComposite		 },
    { "IsManaged",		IsManaged		 },
    { "IsRealized",		IsRealized		 },
    { "LastTimestampProcessed",	LastTimestampProcessed	 },
    { "ManageChild",		ManageChild		 },
    { "ManageChildren",		ManageChildren		 },
    { "MapWidget",		MapWidget		 },
    { "MoveWidget",		MoveWidget		 },
    { "OverrideTranslations",	OverrideTranslations	 },
    { "_OverrideTranslations",	_OverrideTranslations	 },
    { "OwnSelection",		OwnSelection		 },
    { "_OwnSelection",		_OwnSelection		 },
    { "Parent",			Parent			 },
    { "Popdown",		Popdown			 },
    { "Popup",			Popup			 },
    { "PopupSpringLoaded",	PopupSpringLoaded	 },
    { "RealizeWidget",		RealizeWidget		 },
    { "RemoveAllCallbacks",	RemoveAllCallbacks	 },
    { "RemoveCallback",		RemoveCallback		 },
    { "RemoveEventHandler",	RemoveEventHandler	 },
    { "RemoveGrab",		RemoveGrab		 },
    { "RemoveInput",		RemoveInput		 },
    { "RemoveRawEventHandler",	RemoveRawEventHandler	 },
    { "RemoveTimeOut",		RemoveTimeOut		 },
    { "RemoveWorkProc",		RemoveWorkProc		 },
    { "ReplaceTranslations",	ReplaceTranslations	 },
    { "_ReplaceTranslations",	_ReplaceTranslations	 },
    { "ResizeWidget",		ResizeWidget		 },
    { "SetKeyboardFocus",	SetKeyboardFocus	 },
    { "SetMappedWhenManaged",	SetMappedWhenManaged	 },
    { "SetMultiClickTime",	SetMultiClickTime	 },
    { "SetSensitive",		SetSensitive		 },
    { "SetValue",		SetValue		 },
    { "SetValues",		SetValues		 },
    { "SetValueWithType",	SetValueWithType	 },
    { "Sync",			Sync			 },
    { "TranslateCoords",	TranslateCoords		 },
    { "UngrabButton",		UngrabButton		 },
    { "UngrabKey",		UngrabKey		 },
    { "UngrabKeyboard",		UngrabKeyboard		 },
    { "UngrabPointer",		UngrabPointer		 },
    { "UninstallTranslations",	UninstallTranslations	 },
    { "UnmanageChild",		UnmanageChild		 },
    { "UnmanageChildren",	UnmanageChildren	 },
    { "UnmapWidget",		UnmapWidget		 },
    { "UnrealizeWidget",	UnrealizeWidget		 },
    { "Window",			WINdow			 },
    { "WindowToWidget",		WindowToWidget		 },

    { "AddCFunction",		AddCFunction		 },
    { "AddFunction",		AddFunction		 },
    { "AddThisFunction",	AddThisFunction		 },
    { "AllocColor",		AllocColor		 },
    { "Argc",			Argc			 },
    { "Argv",			Argv			 },
    { "Bell",			Bell			 },
    { "Case",			Case			 },
    { "_Case",			_Case			 },
    { "ConvertCtoResources",	ConvertCtoResources	 },
    { "CopyFunction",		CopyFunction		 },
    { "CreateColormap",		CreateColormap		 },
    { "CreateImageCursor",	CreateImageCursor	 },
    { "CreateResourceList",	CreateResourceList	 },
    { "DefineCursor",		DefineCursor		 },
    { "DestroyResourceList",	DestroyResourceList	 },
    { "DragWidget",		DragWidget		 },
    { "EvalLine",		EvalLine		 },
    { "_EvalLine",		_EvalLine		 },
    { "EvalLines",		EvalLines		 },
    { "_EvalLines",		_EvalLines		 },
    { "Eval",			Eval			 },
    { "_Eval",			_Eval			 },
    { "Exit",			Exit			 },
    { "ForEach",		ForEach			 },
    { "_ForEach",		_ForEach		 },
    { "ForEachArg",		ForEachArg		 },
    { "_ForEachArg",		_ForEachArg		 },
    { "FreeColor",		FreeColor		 },
    { "FreeColormap",		FreeColormap		 },
    { "FreeImage",		FreeImage		 },
    { "FreeImageCursor",	FreeImageCursor		 },
    { "FreePixmap",		FreePixmap		 },
    { "FunctionArg",		FunctionArg		 },
    { "Get",			Get			 },
    { "GetImage",		GetImage		 },
    { "GetPixel",		GetPixel		 },
    { "GetPoint",		GetPoint		 },
    { "GetRect",		GetRect			 },
    { "GetWidget",		GetWidget		 },
    { "If",			If			 },
    { "_If",			_If			 },
    { "Include",		Include			 },
    { "InternLines",		InternLines		 },
    { "InternShellVariables",	InternShellVariables	 },
    { "IsWidget",		IsWidget		 },
    { "Iterate",		Iterate			 },
    { "_Iterate",		_Iterate		 },
    { "LocalVariables",		LocalVariables		 },
    { "LowerWidget",		LowerWidget		 },
    { "MapWindow",		MapWindow		 },
    { "Print",			Print			 },
    { "PrintOperations",	PrintOperations		 },
    { "PrintResources",		PrintResources		 },
    { "PrintWidgetClasses",	PrintWidgetClasses	 },
    { "PrintWidgetResources",	PrintWidgetResources	 },
    { "PrintWidgets",		PrintWidgets		 },
    { "QueryPixel",		QueryPixel		 },
    { "QueryPointer",		QueryPointer		 },
    { "RaiseWidget",		RaiseWidget		 },
    { "ReadImage",		ReadImage		 },
    { "ReadPixmap",		ReadPixmap		 },
    { "ReparentWindow",		ReparentWindow		 },
    { "Return",			Return			 },
    { "ReturnN",		ReturnN			 },
    { "ScaleImage",		ScaleImage		 },
    { "Set",			Set      		 },
    { "SetShellVariables",	SetShellVariables	 },
    { "SetStdin",		SetStdin      		 },
    { "SetStdout",		SetStdout      		 },
    { "SetStderr",		SetStderr      		 },
    { "ShellEscape",		ShellEscape		 },
    { "_ShellEscape",		_ShellEscape		 },
    { "StringSize",		StringSize		 },
    { "UnmapWindow",		UnmapWindow		 },
    { "UnsetShellVariables",	UnsetShellVariables	 },
    { "WarpPointer",		WarpPointer		 },
    { "While",			While			 },
    { "_While",			_While			 },
    { "WriteImage",		WriteImage		 },
    { "WritePixmap",		WritePixmap		 },
    { "OldIf",			OldIf			 },
    { "_OldIf",			_OldIf			 },
    { "OldWhile",		OldWhile		 },
    { "_OldWhile",		_OldWhile		 },

    { "Add",			Add			 },
    { "Calc",			Calc			 },
    { "DoubleCalc",		DoubleCalc		 },
    { "Sub",			Sub			 },
    { "Mult",			Mult			 },
    { "Div",			Div			 },
    { "Hex",			Hex			 },

    { "AddXIpc",		AddXIpc			 },
    { "RemoveXIpc",		RemoveXIpc		 },
    { "Send",			Send			 },

    { "XIpcSetupPortServer",		XIPCSetupPortServer		},
    { "_XIpcSetupPortServer",		_XIPCSetupPortServer		},
    { "XIpcCloseServer",		XIPCCloseServer			},
    { "XIpcServerSetClientCleanup",	XIPCServerSetClientCleanup	},
    { "_XIpcServerSetClientCleanup",	_XIPCServerSetClientCleanup	},

    { "XIpcSendToClient",		XIPCSendToClient		},
    { "XIpcFlushServer",		XIPCFlushServer			},

    { "XIpcServerClientSynchronize",	XIPCServerClientSynchronize	},
    { "XIpcIsServerClientActive",	XIPCIsServerClientActive	},

    { "XIpcServerProcessMessage",	XIPCServerProcessMessage	},
    { "XIpcServerCloseClient",		XIPCServerCloseClient		},

    { "XIpcSetupKeyClient",		XIPCSetupKeyClient		},
    { "_XIpcSetupKeyClient",		_XIPCSetupKeyClient		},
    { "XIpcCloseClient",		XIPCCloseClient			},
    { "XIpcSetClientCleanup",		XIPCSetClientCleanup		},
    { "_XIpcSetClientCleanup",		_XIPCSetClientCleanup		},

    { "XIpcSendToServer",		XIPCSendToServer		},
    { "XIpcFlushClient",		XIPCFlushClient			},

    { "XIpcClientSynchronize",		XIPCClientSynchronize		},
    { "XIpcIsClientActive",		XIPCIsClientActive		},

    { "XIpcCatchErrors",		XIPCCatchErrors			},

/* RAD */
#ifdef LIB_E
    { "eAbort",			AbortE		 	 },
    { "eAddG2Fd",		AddG2FdE		 },
    { "eAddG2FdLong",		AddG2FdLongE		 },
    { "_eAddG2FdLong",		_AddG2FdLongE		 },
    { "eAnnounce",		AnnounceE		 },
    { "eAnnounceLong",		AnnounceLongE		 },
    { "_eAnnounceLong",		_AnnounceLongE		 },
    { "eAtExit",		AtExitE		 	 },
    { "_eAtExit",		_AtExitE		 },
    { "eClearTrace",		ClearTraceE		 },
    { "eBlock",			BlockE		 	 },
    { "eCancelTimers",		CancelTimersE		 },
    { "eConnect",		ConnectE		 },
    { "eConnectLong",		ConnectLongE		 },
    { "_eConnectLong",		_ConnectLongE		 },
    { "eError",			ErrorE		 	 },
    { "eExit",			ExitE		 	 },
    { "eFatal",			FatalE		 	 },
    { "eFyi",			FyiE		 	 },
    { "eInit",			InitE			 },
    { "eLog",			LogE		 	 },
    { "eLogMsg",		LogMsgE		 	 },
    { "eMsgEval",		MsgEvalE		 },
    { "ePut",			PutE			 },
    { "ePutMsg",		PutMsgE			 },
    { "eRelease",		ReleaseE		 },
    { "eResetHiWater",		ResetHiWaterE		 },
    { "eRemoveAllChanCbs",      RemoveAllChanCbsE        },
    { "eRemoveAllMsgCbs",       RemoveAllMsgCbsE         },
    { "eRemoveChanCb",          RemoveChanCbE            },
    { "eRemoveMsgCb",           RemoveMsgCbE             },
    { "eSetChanCb",		SetChanCbE		 },
    { "_eSetChanCb",		_SetChanCbE		 },
    { "eSetClientConnectCb",	SetClientConnectCbE	 },
    { "_eSetClientConnectCb",	_SetClientConnectCbE	 },
    { "eSetClientHiWaterCb",	SetClientHiWaterCbE	 },
    { "_eSetClientHiWaterCb",	_SetClientHiWaterCbE	 },
    { "eSetFyi",		SetFyiE		 	 },
    { "eSetMsgCb",		SetMsgCbE		 },
    { "_eSetMsgCb",		_SetMsgCbE		 },
    { "eSetOrphanCb",		SetOrphanCbE		 },
    { "_eSetOrphanCb",		_SetOrphanCbE		 },
    { "eSetReleaseCb",		SetReleaseCbE	 	 },
    { "_eSetReleaseCb",		_SetReleaseCbE	 	 },
    { "eSetServerHiWaterCb",	SetServerHiWaterCbE	 },
    { "_eSetServerHiWaterCb",	_SetServerHiWaterCbE	 },
    { "eSetServiceConnectCb",	SetSvcConnectCbE	 },
    { "_eSetServiceConnectCb",	_SetSvcConnectCbE	 },
    { "eSetTimer",		SetTimerE		 },
    { "_eSetTimer",		_SetTimerE		 },
    { "eSetTrace",		SetTraceE		 },
    { "eSetWarning",		SetWarningE		 },
    { "eSyncCb",		SyncCbE		 	 },
    { "_eSyncCb",		_SyncCbE		 },
    { "eTimedSyncCb",		TimedSyncCbE		 },
    { "_eTimedSyncCb",		_TimedSyncCbE		 },
    { "eTrace",			TraceE		 	 },
    { "eTraceMsg",		TraceMsgE	 	 },
    { "eUnBlock",		UnBlockE		 },
    { "eWarning",		WarningE		 },
    { "eWithdraw",		WithdrawE		 },
#endif   /* LIB_E */
/* RAD */

    { "StrIndex",		StrIndex		 },
    { "StrGSub",		StrGSub			 },
    { "StrSub",			StrSub			 },
    { "StrLength",		StrLength		 },
    { "StrMatch",		StrMatch		 },
    { "StrSplitToArgList",	StrSplitToArgList	 },
    { "StrSplitToResource",	StrSplitToResource	 },
    { "StrSubstr",		StrSubstr		 },

    { "FClose",			FClose			 },
    { "FFlush",			FFlush			 },
    { "FOpen",			FOpen			 },
    { "FGetS",			FGetS			 },
    { "FPrintF",		FPrintF			 },
    { "PClose",			PClose			 },
    { "POpen",			POpen			 },
    { "SPrintF",		SPrintF			 },
    { "StatF",			StatF			 },

#ifdef ATHENA
    { "XawListChange",			XAWListChange			},
    { "XawListHighlight",		XAWListHighlight		},
    { "XawListUnhighlight",		XAWListUnhighlight		},
    { "XawListShowCurrent",		XAWListShowCurrent		},
    { "XawScrollbarSetThumb",		XAWScrollbarSetThumb		},
    { "XawStripChartAddValueProc",	XAWStripChartAddValueProc	},
    { "_XawStripChartAddValueProc",	_XAWStripChartAddValueProc	},
    { "XawToggleChangeRadioGroup",	XAWToggleChangeRadioGroup	},
    { "XawToggleGetCurrent",		XAWToggleGetCurrent		},
    { "XawToggleSetCurrent",		XAWToggleSetCurrent		},
    { "XawToggleUnsetCurrent",		XAWToggleUnsetCurrent		},
    { "XawSimpleMenuAddGlobalActions",	XAWSimpleMenuAddGlobalActions	},
    { "XawSimpleMenuGetActiveEntry",	XAWSimpleMenuGetActiveEntry	},
    { "XawSimpleMenuClearActiveEntry",	XAWSimpleMenuClearActiveEntry	},
    { "XawTextSetSelection",		XAWTextSetSelection		},
    { "XawTextUnsetSelection",		XAWTextUnsetSelection		},
    { "XawTextGetSelectionPos",		XAWTextGetSelectionPos		},
    { "XawTextReplace",			XAWTextReplace			},
    { "XawTextSearch",			XAWTextSearch			},
    { "XawTextInvalidate",		XAWTextInvalidate		},
    { "XawTextEnableRedisplay",		XAWTextEnableRedisplay		},
    { "XawTextDisableRedisplay",	XAWTextDisableRedisplay		},
    { "XawTextDisplay",			XAWTextDisplay			},
    { "XawTextTopPosition",		XAWTextTopPosition		},
    { "XawTextSetSelectionArray",	XAWTextSetSelectionArray	},
    { "XawTextSetInsertionPoint",	XAWTextSetInsertionPoint	},
    { "XawTextGetInsertionPoint",	XAWTextGetInsertionPoint	},
    { "XawTextSetSource",		XAWTextSetSource		},
    { "XawTextGetSource",		XAWTextGetSource		},
    { "XawTextDisplayCaret",		XAWTextDisplayCaret		},
    { "XawAsciiSourceFreeString",	XAWAsciiSourceFreeString	},
    { "XawAsciiSave",			XAWAsciiSave			},
    { "XawAsciiSaveAsFile",		XAWAsciiSaveAsFile		},
    { "XawAsciiSourceChanged",		XAWAsciiSourceChanged		},
    { "XawDialogGetValueString",	XAWDialogGetValueString		},
    { "XawFormDoLayout",		XAWFormDoLayout			},
    { "XawPanedAllowResize",		XAWPanedAllowResize		},
    { "XawPanedSetMinMax",		XAWPanedSetMinMax		},
    { "XawPanedGetMinMax",		XAWPanedGetMinMax		},
    { "XawPanedSetRefigureMode",	XAWPanedSetRefigureMode		},
    { "XawPanedGetNumSub",		XAWPanedGetNumSub		},
#if XT_REVISION > 4
    { "XawTreeForceLayout",		XAWTreeForceLayout		},
#endif
#endif /* AHTENA */

#ifdef MOTIF
    { "XmActivateProtocol",		XMActivateProtocol		},
    { "XmActivateWMProtocol",		XMActivateWMProtocol		},
    { "XmAddProtocolCallback",		XMAddProtocolCallback		},
    { "_XmAddProtocolCallback",		_XMAddProtocolCallback		},
    { "XmAddWMProtocolCallback",	XMAddWMProtocolCallback		},
    { "_XmAddWMProtocolCallback",	_XMAddWMProtocolCallback	},
    { "XmAddProtocols",			XMAddProtocols			},
    { "XmAddWMProtocols",		XMAddWMProtocols		},
    { "XmAddTabGroup",			XMAddTabGroup			},
    { "XmAddWMProtocols",		XMAddWMProtocols		},
    { "XmCascadeButtonGadgetHighlight",	XMCascadeButtonGadgetHighlight	},
    { "XmCascadeButtonHighlight",	XMCascadeButtonHighlight	},
    { "XmChangeColor",			XMChangeColor			},
    { "XmClipboardCancelCopy",		XMClipboardCancelCopy		},
    { "XmClipboardCopy",		XMClipboardCopy			},
    { "XmClipboardCopyByName",		XMClipboardCopyByName		},
    { "XmClipboardEndCopy",		XMClipboardEndCopy		},
    { "XmClipboardEndRetrieve",		XMClipboardEndRetrieve		},
    { "XmClipboardInquireCount",	XMClipboardInquireCount		},
    { "XmClipboardInquireFormat",	XMClipboardInquireFormat	},
    { "XmClipboardInquireLength",	XMClipboardInquireLength	},
    { "XmClipboardInquirePendingItems",	XMClipboardInquirePendingItems	},
    { "XmClipboardLock",		XMClipboardLock			},
    { "XmClipboardRegisterFormat",	XMClipboardRegisterFormat	},
    { "XmClipboardRetrieve",		XMClipboardRetrieve		},
    { "XmClipboardStartCopy",		XMClipboardStartCopy		},
    { "XmClipboardStartRetrieve",	XMClipboardStartRetrieve	},
    { "XmClipboardUndoCopy",		XMClipboardUndoCopy		},
    { "XmClipboardUnlock",		XMClipboardUnlock		},
    { "XmClipboardWithdrawFormat",	XMClipboardWithdrawFormat	},
    { "XmCommandAppendValue",		XMCommandAppendValue		},
    { "XmCommandError",			XMCommandError			},
    { "XmCommandGetChild",		XMCommandGetChild		},
    { "XmCommandSetValue",		XMCommandSetValue		},
    { "XmConvertUnits",			XMConvertUnits			},
    { "XmCreateArrowButton",		XMCreateArrowButton		},
    { "XmCreateArrowButtonGadget",	XMCreateArrowButtonGadget	},
    { "XmCreateBulletinBoard",		XMCreateBulletinBoard		},
    { "XmCreateBulletinBoardDialog",	XMCreateBulletinBoardDialog	},
    { "XmCreateCascadeButton",		XMCreateCascadeButton		},
    { "XmCreateCascadeButtonGadget",	XMCreateCascadeButtonGadget	},
    { "XmCreateCommand",		XMCreateCommand			},
    { "XmCreateDialogShell",		XMCreateDialogShell		},
    { "XmCreateDragIcon",		XMCreateDragIcon		},
    { "XmCreateDrawingArea",		XMCreateDrawingArea		},
    { "XmCreateDrawnButton",		XMCreateDrawnButton		},
    { "XmCreateErrorDialog",		XMCreateErrorDialog		},
    { "XmCreateFileSelectionBox",	XMCreateFileSelectionBox	},
    { "XmCreateFileSelectionDialog",	XMCreateFileSelectionDialog	},
    { "XmCreateForm",			XMCreateForm			},
    { "XmCreateFormDialog",		XMCreateFormDialog		},
    { "XmCreateFrame",			XMCreateFrame			},
    { "XmCreateInformationDialog",	XMCreateInformationDialog	},
    { "XmCreateLabel",			XMCreateLabel			},
    { "XmCreateLabelGadget",		XMCreateLabelGadget		},
    { "XmCreateList",			XMCreateList			},
    { "XmCreateMainWindow",		XMCreateMainWindow		},
    { "XmCreateMenuBar",		XMCreateMenuBar			},
    { "XmCreateMenuShell",		XMCreateMenuShell		},
    { "XmCreateMessageBox",		XMCreateMessageBox		},
    { "XmCreateMessageDialog",		XMCreateMessageDialog		},
    { "XmCreateOptionMenu",		XMCreateOptionMenu		},
    { "XmCreatePanedWindow",		XMCreatePanedWindow		},
    { "XmCreatePopupMenu",		XMCreatePopupMenu		},
    { "XmCreatePromptDialog",		XMCreatePromptDialog		},
    { "XmCreatePulldownMenu",		XMCreatePulldownMenu		},
    { "XmCreatePushButton",		XMCreatePushButton		},
    { "XmCreatePushButtonGadget",	XMCreatePushButtonGadget	},
    { "XmCreateQuestionDialog",		XMCreateQuestionDialog		},
    { "XmCreateRadioBox",		XMCreateRadioBox		},
    { "XmCreateRowColumn",		XMCreateRowColumn		},
    { "XmCreateScale",			XMCreateScale			},
    { "XmCreateScrollBar",		XMCreateScrollBar		},
    { "XmCreateScrolledList",		XMCreateScrolledList		},
    { "XmCreateScrolledText",		XMCreateScrolledText		},
    { "XmCreateScrolledWindow",		XMCreateScrolledWindow		},
    { "XmCreateSelectionBox",		XMCreateSelectionBox		},
    { "XmCreateSelectionDialog",	XMCreateSelectionDialog		},
    { "XmCreateSeparator",		XMCreateSeparator		},
    { "XmCreateSeparatorGadget",	XMCreateSeparatorGadget		},
    { "XmCreateSimpleCheckBox",		XMCreateSimpleCheckBox		},
    { "XmCreateSimpleMenuBar",		XMCreateSimpleMenuBar		},
    { "XmCreateSimpleOptionMenu",	XMCreateSimpleOptionMenu	},
    { "XmCreateSimplePopupMenu",	XMCreateSimplePopupMenu		},
    { "XmCreateSimplePulldownMenu",	XMCreateSimplePulldownMenu	},
    { "XmCreateSimpleRadioBox",		XMCreateSimpleRadioBox		},
    { "XmCreateTemplateDialog",		XMCreateTemplateDialog		},
    { "XmCreateText",			XMCreateText			},
    { "XmCreateTextField",		XMCreateTextField		},
    { "XmCreateToggleButton",		XMCreateToggleButton		},
    { "XmCreateToggleButtonGadget",	XMCreateToggleButtonGadget	},
    { "XmCreateWorkArea",		XMCreateWorkArea		},
    { "XmCreateWorkingDialog",		XMCreateWorkingDialog		},
    { "XmDeactivateProtocol",		XMDeactivateProtocol		},
    { "XmDeactivateWMProtocol",		XMDeactivateWMProtocol		},
    { "XmDestroyPixmap",		XMDestroyPixmap			},
    { "XmDragStart",			XMDragStart			},
    { "XmDropSiteConfigureStackingOrder",
				XMDropSiteConfigureStackingOrder	},
    { "XmDropSiteEndUpdate",		XMDropSiteEndUpdate		},
    { "XmDropSiteQueryStackingOrder",	XMDropSiteQueryStackingOrder	},
    { "XmDropSiteRegister",		XMDropSiteRegister		},
    { "XmDropSiteRetrieve",		XMDropSiteRetrieve		},
    { "XmDropSiteStartUpdate",		XMDropSiteStartUpdate		},
    { "XmDropSiteUnregister",		XMDropSiteUnregister		},
    { "XmDropSiteUpdate",		XMDropSiteUpdate		},
    { "XmDropTransferAdd",		XMDropTransferAdd		},
    { "XmDropTransferStart",		XMDropTransferStart		},
    { "XmFileSelectionBoxGetChild",	XMFileSelectionBoxGetChild	},
    { "XmFileSelectionDoSearch",	XMFileSelectionDoSearch		},
    { "XmGetColors",			XMGetColors			},
    { "XmGetDestination",		XMGetDestination		},
    { "XmGetDragContext",		XMGetDragContext		},
    { "XmGetFocusWidget",		XMGetFocusWidget		},
    { "XmGetPixmap",			XMGetPixmap			},
    { "XmGetPixmapByDepth",		XMGetPixmapByDepth		},
    { "XmGetPostedFromWidget",		XMGetPostedFromWidget		},
    { "XmGetTabGroup",			XMGetTabGroup			},
    { "XmGetTearOffControl",		XMGetTearOffControl		},
    { "XmGetVisibility",		XMGetVisibility			},
    { "XmGetXmDisplay",			XMGetXmDisplay			},
    { "XmGetXmScreen",			XMGetXmScreen			},
    { "XmInstallImage",			XMInstallImage			},
    { "XmIsMotifWMRunning",		XMIsMotifWMRunning		},
    { "XmIsTraversable",		XMIsTraversable       		},
    { "XmListAddItem",			XMListAddItem			},
    { "XmListAddItemUnselected",	XMListAddItemUnselected		},
    { "XmListAddItems",			XMListAddItems			},
    { "XmListAddItemsUnselected",	XMListAddItemsUnselected	},
    { "XmListDeleteAllItems",		XMListDeleteAllItems		},
    { "XmListDeleteItem",		XMListDeleteItem		},
    { "XmListDeleteItems",		XMListDeleteItems		},
    { "XmListDeleteItemsPos",		XMListDeleteItemsPos		},
    { "XmListDeletePos",		XMListDeletePos			},
    { "XmListDeletePositions",		XMListDeletePositions		},
    { "XmListDeselectAllItems",		XMListDeselectAllItems		},
    { "XmListDeselectItem",		XMListDeselectItem		},
    { "XmListDeselectPos",		XMListDeselectPos		},
    { "XmListGetKbdItemPos",		XMListGetKbdItemPos		},
    { "XmListGetMatchPos",		XMListGetMatchPos		},
    { "XmListGetSelectedPos",		XMListGetSelectedPos		},
    { "XmListItemExists",		XMListItemExists		},
    { "XmListItemPos",			XMListItemPos			},
    { "XmListPosSelected",		XMListPosSelected		},
    { "XmListPosToBounds",		XMListPosToBounds		},
    { "XmListReplaceItems",		XMListReplaceItems		},
    { "XmListReplaceItemsPos",		XMListReplaceItemsPos		},
    { "XmListReplaceItemsPosUnselected",XMListReplaceItemsPosUnselected	},
    { "XmListReplaceItemsUnselected",	XMListReplaceItemsUnselected	},
    { "XmListReplacePositions",		XMListReplacePositions		},
    { "XmListSelectItem",		XMListSelectItem		},
    { "XmListSelectPos",		XMListSelectPos			},
    { "XmListSetAddMode",		XMListSetAddMode		},
    { "XmListSetBottomItem",		XMListSetBottomItem		},
    { "XmListSetBottomPos",		XMListSetBottomPos		},
    { "XmListSetHorizPos",		XMListSetHorizPos		},
    { "XmListSetItem",			XMListSetItem			},
    { "XmListSetKbdItemPos",		XMListSetKbdItemPos		},
    { "XmListSetPos",			XMListSetPos			},
    { "XmListUpdateSelectedList",	XMListUpdateSelectedList	},
    { "XmListYToPos",			XMListYToPos			},
    { "XmMainWindowSep1",		XMMainWindowSep1		},
    { "XmMainWindowSep2",		XMMainWindowSep2		},
    { "XmMainWindowSep3",		XMMainWindowSep3		},
    { "XmMainWindowSetAreas",		XMMainWindowSetAreas		},
    { "XmMenuPosition",			XMMenuPosition			},
    { "XmMessageBoxGetChild",		XMMessageBoxGetChild		},
    { "XmOptionButtonGadget",		XMOptionButtonGadget		},
    { "XmOptionLabelGadget",		XMOptionLabelGadget		},
    { "XmProcessTraversal",		XMProcessTraversal		},
    { "XmRemoveProtocolCallback",	XMRemoveProtocolCallback	},
    { "XmRemoveProtocols",		XMRemoveProtocols		},
    { "XmRemoveTabGroup",		XMRemoveTabGroup		},
    { "XmRemoveWMProtocolCallback",	XMRemoveWMProtocolCallback	},
    { "XmRemoveWMProtocols",		XMRemoveWMProtocols		},
    { "XmRepTypeAddReverse",		XMRepTypeAddReverse		},
    { "XmRepTypeGetId",			XMRepTypeGetId			},
    { "XmRepTypeGetNameList",		XMRepTypeGetNameList		},
    { "XmRepTypeInstallTearOffModelConverter",
	  			XMRepTypeInstallTearOffModelConverter	},
    { "XmRepTypeRegister",		XMRepTypeRegister		},
    { "XmRepTypeValidValue",		XMRepTypeValidValue		},
    { "XmScaleGetValue",		XMScaleGetValue			},
    { "XmScaleSetValue",		XMScaleSetValue			},
    { "XmScrollBarGetValues",		XMScrollBarGetValues		},
    { "XmScrollBarSetValues",		XMScrollBarSetValues		},
    { "XmScrollVisible",		XMScrollVisible			},
    { "XmScrolledWindowSetAreas",	XMScrolledWindowSetAreas	},
    { "XmSelectionBoxGetChild",		XMSelectionBoxGetChild		},
    { "XmSetFontUnit",			XMSetFontUnit			},
    { "XmSetFontUnits",			XMSetFontUnits			},
    { "XmTextClearSelection",		XMTextClearSelection		},
    { "XmTextCopy",			XMTextCopy			},
    { "XmTextCut",			XMTextCut			},
    { "XmTextDisableRedisplay",		XMTextDisableRedisplay		},
    { "XmTextEnableRedisplay",		XMTextEnableRedisplay		},
    { "XmTextFieldClearSelection",	XMTextFieldClearSelection	},
    { "XmTextFieldCopy",		XMTextFieldCopy			},
    { "XmTextFieldCut",			XMTextFieldCut			},
    { "XmTextFieldGetBaseLine",		XMTextFieldGetBaseLine		},
    { "XmTextFieldGetEditable",		XMTextFieldGetEditable		},
    { "XmTextFieldGetInsertionPosition",XMTextFieldGetInsertionPosition	},
    { "XmTextFieldGetLastPosition",	XMTextFieldGetLastPosition	},
    { "XmTextFieldGetMaxLength",	XMTextFieldGetMaxLength		},
    { "XmTextFieldGetSelection",	XMTextFieldGetSelection		},
    { "XmTextFieldGetSelectionPosition",XMTextFieldGetSelectionPosition	},
    { "XmTextFieldGetString",		XMTextFieldGetString		},
    { "XmTextFieldGetSubstring",	XMTextFieldGetSubstring		},
    { "XmTextFieldInsert",		XMTextFieldInsert		},
    { "XmTextFieldPaste",		XMTextFieldPaste		},
    { "XmTextFieldPosToXY",		XMTextFieldPosToXY		},
    { "XmTextFieldRemove",		XMTextFieldRemove		},
    { "XmTextFieldReplace",		XMTextFieldReplace		},
    { "XmTextFieldSetAddMode",		XMTextFieldSetAddMode		},
    { "XmTextFieldSetEditable",		XMTextFieldSetEditable		},
    { "XmTextFieldSetHighlight",	XMTextFieldSetHighlight		},
    { "XmTextFieldSetInsertionPosition",XMTextFieldSetInsertionPosition	},
    { "XmTextFieldSetMaxLength",	XMTextFieldSetMaxLength		},
    { "XmTextFieldSetSelection",	XMTextFieldSetSelection		},
    { "XmTextFieldSetString",		XMTextFieldSetString		},
    { "XmTextFieldShowPosition",	XMTextFieldShowPosition		},
    { "XmTextFieldXYToPos",		XMTextFieldXYToPos		},
    { "XmTextFindString",		XMTextFindString		},
    { "XmTextGetBaseLine",		XMTextGetBaseLine		},
    { "XmTextGetEditable",		XMTextGetEditable		},
    { "XmTextGetInsertionPosition",	XMTextGetInsertionPosition	},
    { "XmTextGetLastPosition",		XMTextGetLastPosition		},
    { "XmTextGetMaxLength",		XMTextGetMaxLength		},
    { "XmTextGetSelection",		XMTextGetSelection		},
    { "XmTextGetSelectionPosition",	XMTextGetSelectionPosition	},
    { "XmTextGetSource",		XMTextGetSource			},
    { "XmTextGetString",		XMTextGetString			},
    { "XmTextGetSubstring",		XMTextGetSubstring		},
    { "XmTextGetTopCharacter",		XMTextGetTopCharacter		},
    { "XmTextInsert",			XMTextInsert			},
    { "XmTextPaste",			XMTextPaste			},
    { "XmTextPosToXY",			XMTextPosToXY			},
    { "XmTextRemove",			XMTextRemove			},
    { "XmTextReplace",			XMTextReplace			},
    { "XmTextScroll",			XMTextScroll			},
    { "XmTextSetAddMode",		XMTextSetAddMode		},
    { "XmTextSetEditable",		XMTextSetEditable		},
    { "XmTextSetHighlight",		XMTextSetHighlight		},
    { "XmTextSetInsertionPosition",	XMTextSetInsertionPosition	},
    { "XmTextSetMaxLength",		XMTextSetMaxLength		},
    { "XmTextSetSelection",		XMTextSetSelection		},
    { "XmTextSetSource",		XMTextSetSource			},
    { "XmTextSetString",		XMTextSetString			},
    { "XmTextSetTopCharacter",		XMTextSetTopCharacter		},
    { "XmTextShowPosition",		XMTextShowPosition		},
    { "XmTextXYToPos",			XMTextXYToPos			},
    { "XmToggleButtonGadgetGetState",	XMToggleButtonGadgetGetState	},
    { "XmToggleButtonGadgetSetState",	XMToggleButtonGadgetSetState	},
    { "XmToggleButtonGetState",		XMToggleButtonGetState		},
    { "XmToggleButtonSetState",		XMToggleButtonSetState		},
    { "XmTrackingEvent",		XMTrackingEvent			},
    { "XmUninstallImage",		XMUninstallImage		},
    { "XmUpdateDisplay",		XMUpdateDisplay			},
    { "XmWidgetGetBaselines",		XMWidgetGetBaselines		},
    { "XmWidgetGetDisplayRect",		XMWidgetGetDisplayRect		},

    { "XmCvtXmStringTableToString",	XMCvtXmStringTableToString      },
    { "XmReinstallXtentConverters",	XMReinstallXtentConverters      },

#endif /* MOTIF */

#ifdef OPENLOOK
    { "OlAddCallback",		OLAddCallback 		 }, /* SCU */
    { "_OlAddCallback",		OLAddCallback 		 },
    { "OlAddCallbackWithArgs",	OLAddCallbackWithArgs	 },
    { "_OlAddCallbackWithArgs",	OLAddCallbackWithArgs	 },

    { "OlMMToPixel",		OLMMToPixel		 },
    { "OlPointToPixel",		OLPointToPixel		 },
    { "OlPixelToMM",		OLPixelToMM		 },
    { "OlPixelToPoint",		OLPixelToPoint		 },
    { "Ol_MMToPixel",		OL_MMToPixel		 },
    { "Ol_PointToPixel",	OL_PointToPixel		 },
    { "Ol_PixelToMM",		OL_PixelToMM		 },
    { "Ol_PixelToPoint",	OL_PixelToPoint		 },

    { "OlRegisterHelp",		OLRegisterHelp		 },
    { "OlInitialize",		OLInitialize		 },

    { "OlCallAcceptFocus",	OLCallAcceptFocus	 },
    { "OlMoveFocus",		OLMoveFocus		 },
    { "OlCanAcceptFocus",	OLCanAcceptFocus	 },
    { "OlHasFocus",		OLHasFocus		 },
    { "OlSetInputFocus",	OLSetInputFocus		 },
    { "OlGetCurrentFocusWidget",OLGetCurrentFocusWidget	 },

    { "TextClearBuffer",	TextClearBuffer		 },
    { "TextCopyBuffer",		TextCopyBuffer		 },
    { "TextGetInsertPoint",	TextGetInsertPoint	 },
    { "TextGetLastPos",		TextGetLastPos		 },
    { "TextInsert",		TextInsert		 },
    { "TextReadSubString",	TextReadSubString	 },
    { "TextRedraw",		TextRedraw		 },
    { "TextReplace",		TextReplace		 },
    { "TextSetInsertPoint",	TextSetInsertPoint	 },
    { "TextUpdate",		TextUpdate		 },

    { "OlTextEditClearBuffer",		OLTextEditClearBuffer		 },
    { "OlTextEditCopyBuffer",		OLTextEditCopyBuffer		 },
    { "OlTextEditCopySelection",	OLTextEditCopySelection		 },
    { "OlTextEditGetCursorPosition",	OLTextEditGetCursorPosition	 },
    { "OlTextEditGetLastPosition",	OLTextEditGetLastPosition	 },
    { "OlTextEditInsert",		OLTextEditInsert		 },
    { "OlTextEditPaste",		OLTextEditPaste			 },
    { "OlTextEditReadSubString",	OLTextEditReadSubString		 },
    { "OlTextEditRedraw",		OLTextEditRedraw		 },
    { "OlTextEditSetCursorPosition",	OLTextEditSetCursorPosition	 },
    { "OlTextEditUpdate",		OLTextEditUpdate		 },

    { "OlTextFieldCopyString",		OLTextFieldCopyString		 },
    { "OlTextFieldGetString",		OLTextFieldGetString		 },

    { "OlMenuPopup",			OLMenuPopup		 },
    { "OlMenuPopdown",			OLMenuPopdown		 },
    { "OlMenuPost",			OLMenuPost		 },
    { "OlMenuUnpost",			OLMenuUnpost		 },

    { "OlSLApplAddItem",		OLSLApplAddItem		 },
    { "OlSLApplDeleteItem",		OLSLApplDeleteItem	 },
    { "OlSLApplEditClose",		OLSLApplEditClose	 },
    { "OlSLApplEditOpen",		OLSLApplEditOpen	 },
    { "OlSLApplTouchItem",		OLSLApplTouchItem	 },
    { "OlSLApplUpdateView",		OLSLApplUpdateView	 },
    { "OlSLApplViewItem",		OLSLApplViewItem	 },

    { "OlDnDAllocTransientAtom",	OLDnDAllocTransientAtom		},
    { "OlDnDBeginSelectionTransaction",	OLDnDBeginSelectionTransaction	},
    { "OlDnDChangeDropSitePreviewHints",OLDnDChangeDropSitePreviewHints	},
    { "OlDnDClearDragState",		OLDnDClearDragState		},
    { "OlDnDDeliverPreviewMessage",	OLDnDDeliverPreviewMessage	},
    { "OlDnDDeliverTriggerMessage",	OLDnDDeliverTriggerMessage	},
    { "OlDnDDestroyDropSite",		OLDnDDestroyDropSite		},
    { "OlDnDDisownSelection",		OLDnDDisownSelection		},
    { "OlDnDDragAndDrop",		OLDnDDragAndDrop		},
    { "OlDnDDragNDropDone",		OLDnDDragNDropDone		},
    { "OlDnDEndSelectionTransaction",	OLDnDEndSelectionTransaction	},
    { "OlDnDErrorDuringSelectionTransaction",
	  				OLDnDErrorDuringSelectionTransaction },
    { "OlDnDFreeTransientAtom",		OLDnDFreeTransientAtom		},
    { "OlDnDGetCurrentSelectionsForWidget",
	  				OLDnDGetCurrentSelectionsForWidget },
    { "OlDnDGetDropSitesOfWidget",	OLDnDGetDropSitesOfWidget	},
    { "OlDnDGetDropSitesOfWindow",	OLDnDGetDropSitesOfWindow	},
    { "OlDnDGetWidgetOfDropSite",	OLDnDGetWidgetOfDropSite	},
    { "OlDnDGetWindowOfDropSite",	OLDnDGetWindowOfDropSite	},
    { "OlDnDInitializeDragState",	OLDnDInitializeDragState	},
    { "OlDnDOwnSelection",		OLDnDOwnSelection		},
    { "OlDnDQueryDropSiteInfo",		OLDnDQueryDropSiteInfo		},
    { "OlDnDRegisterWidgetDropSite",	OLDnDRegisterWidgetDropSite	},
    { "OlDnDRegisterWindowDropSite",	OLDnDRegisterWindowDropSite	},
    { "OlDnDSetDropSiteInterest",	OLDnDSetDropSiteInterest	},
    { "OlDnDSetInterestInWidgetHier",	OLDnDSetInterestInWidgetHier	},
    { "OlDnDUpdateDropSiteGeometry",	OLDnDUpdateDropSiteGeometry	},
    { "OlDnDWidgetConfiguredInHier",	OLDnDWidgetConfiguredInHier	},

    { "OlGrabDragPointer",		OLGrabDragPointer		},
    { "OlUngrabDragPointer",		OLUngrabDragPointer		},
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
    { "TextClearBuffer",	TextClearBuffer		 },
    { "TextCopyBuffer",		TextCopyBuffer		 },
    { "TextReadSubString",	TextReadSubString	 },
    { "TextCopySelection",	TextCopySelection	 },
    { "TextUnsetSelection",	TextUnsetSelection	 },
    { "TextSetSelection",	TextSetSelection	 },
    { "TextGetSelectionPos",	TextGetSelectionPos	 },
    { "TextInsert",		TextInsert		 },
    { "TextReplace",		TextReplace		 },
    { "TextRedraw",		TextRedraw		 },
    { "TextUpdate",		TextUpdate		 },
    { "TextGetLastPos",		TextGetLastPos		 },
    { "TextSetInsertPos",	TextSetInsertPos	 },
    { "TextGetInsertPos",	TextGetInsertPos	 },
#endif /* HP_WIDGETS */

    { (char *) NULL,		NoOp,			 }
};

enum
{
    XtentWidgetClassNamesType = 1,
    XtentOperationsType,
    XtentApplicationCFunctionType,
    XtentApplicationFunctionType,
    XtentApplicationThisFunctionType
};

/*
 * structures used by XtentEvalResourceLine()
 */
typedef struct CallbackWithArgItem
{
    struct CallbackWithArgItem *next;
    char arg[1];		/* arbitrary length */
} CallbackWithArgItem;

typedef struct CallbackLine
{
    struct CallbackLine *next;
    Widget widget;
    CallbackWithArgItem *arg_list;
    char *callback_name;
    char expanded;
    char code[1];		/* arbitrary length */
} CallbackLine;

typedef struct SelectionLine
{
    struct SelectionLine *next;
    Widget widget;
    Atom selection;
    XtPointer malloc_return;
    char *selection_atom_string;
    char *lose_code;
    char *done_code;
    char *transaction_state_code;
    char convert_code[1];	/* arbitrary length */
} SelectionLine;

typedef struct EventHandlerLine
{
    struct EventHandlerLine *next;
    Widget widget;
    EventMask event_mask;
    Boolean nonmaskable;
    char expanded;
    char code[1];		/* arbitrary length */
} EventHandlerLine;

typedef struct InputLine
{
    Display *display;
    Widget *toplevel_ptr;
    FILE *fp;
    struct InputLine *next;
    XtInputId id;
    char file[1];		/* arbitrary length */
} InputLine;

typedef struct TimeoutLine
{
    XtIntervalId id;
    Display *display;
    Widget *toplevel_ptr;
    long interval;
    struct TimeoutLine **timeouts;
    struct TimeoutLine *next;
    char expanded;
    char code[1];		/* arbitrary length */
} TimeoutLine;

typedef struct WorkProcLine
{
    XtWorkProcId id;
    Display *display;
    Widget *toplevel_ptr;
    struct WorkProcLine *next;
    char expanded;
    char code[1];		/* arbitrary length */
} WorkProcLine;

#define XtentReadable	01
#define XtentWritable	02

typedef struct FileDescriptor
{
    struct FileDescriptor *next;
    FILE *fp;
    unsigned char permission;
    char name[1];		/* arbitrary length */
} FileDescriptor;

typedef struct ConvertBuffer
{
    struct ConvertBuffer *next;
    int length;
    char buffer[1];		/* arbitrary length */
} ConvertBuffer;

typedef struct XtentLocalArg
{
    char *arg_name;
    char *arg_value;
    int reset_frame_number;
    struct XtentLocalArg *next;
} XtentLocalArg;

typedef struct XtentFrameData
{
    int frame;
    char *buffer;
    char *arg_buffer;
    int last_arg_index;
    char *last_arg;
    int parens;
    char used_malloc;
    char end_of_line;
    char evaluation_block;
    char break_from_eval;
    struct XtentFrameData *previous;
} XtentFrameData;

typedef struct XtentFunctionRecordArgs
{
    struct XtentFunctionRecordArgs *next;
    char argument_name[1];
} XtentFunctionRecordArgs;

typedef struct XtentOutputLink
{
    struct XtentOutputLink *next;
    int char_length;
    char item[1];
} XtentOutputLink;

typedef struct
{
    FILE *fp;
    char *resource;
    XtentOutputLink *list;
} XtentOutput;


typedef void (*CFuncPtr) ();  /* RAD - used in cast in AddCFunction */

typedef struct
{
    char *function_name;
    char *resource_name;
    void (*C_function) ();
    int argument_count;
    XtentFunctionRecordArgs *argument_list;
} XtentFunctionRecord;

typedef struct
{
    XrmQuark xrm_name;
    XrmQuark xrm_type;
    char *name;
} ResItem;

typedef struct
{
    unsigned char type;
    union
    {
	int bvalue;
	int nvalue;
	char *svalue;
    } x;
} XtentCalcIntegerPostFixArgs;

typedef struct
{
    unsigned char type;
    union
    {
	int bvalue;
	double  nvalue;
	char *svalue;
    } x;
} XtentCalcDoublePostFixArgs;

enum
{
    XtentVariablesPush = 1,
    XtentVariablesPop
};

#ifdef OPENLOOK

#ifdef OLD_OPENLOOK
typedef int OlDnDDropSiteID;
#endif /* OLD_OPENLOOK */

typedef struct OLDropSiteMessageLine
{
    struct OLDropSiteMessageLine *next;
    OlDnDDropSiteID id;
    char *trigger_code;
    char preview_code[1];	/* arbitrary length */
} OLDropSiteMessageLine;

/* RAD */
typedef struct OLHelpProcLine
{
	XtPointer id;
	int flatitem;
	Display *display;
	Widget *toplevel_ptr;
	struct OLHelpProcLine *next;
	char args[1];           /* arbitrary length */
} OLHelpProcLine;
/* RAD */

typedef struct OLSLDestroyCallbackListItem
{
    struct OLSLDestroyCallbackListItem *next;
    char args[1];		/* arbitrary length */
} OLSLDestroyCallbackListItem;

#endif /* OPENLOOK */

/*
 * globals
 */
XtentShellRecord *XtentShells = (XtentShellRecord *) NULL;
static SelectionLine *SelectionLines = (SelectionLine *) NULL;

#ifdef OPENLOOK
static OLDropSiteMessageLine *XtentOLDropSiteMessageLines = NULL;
/* RAD */
/* OlRegisterHelp doesn't provide client_data.  Need to store this here. */
static OLHelpProcLine *XtentOLHelpProcLines = NULL;
/* RAD */
#endif /* OPENLOOK */

typedef struct XtentXtTypedArg	/* from VarargsI.h */
{
    String      name;
    String      type;
    XtArgVal    value;
    int         size;
} XtentXtTypedArg;

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
Xtent C_P_ARGS((Display * display, Widget * toplevel_ptr, FILE * fp));

extern void
XtentEvalString C_P_ARGS((Display * display, Widget * toplevel_ptr,
			  char * buffer));

static int
XtentReadResourceLine C_P_ARGS((FILE * fp, char **resource_buffer,
				int *resource_buffer_size));

extern int
XtentEvalResourceLine C_P_ARGS((Display * display, Widget * toplevel_ptr,
				char * buffer));

static void
XtentCreateFrame C_P_ARGS((XtentFrameData *frame_ptr));

static void
XtentReleaseFrame C_P_ARGS((XtentFrameData *frame_ptr));

extern  void
XtentAddCFunction C_P_ARGS((Display *display, Widget *toplevel_ptr, char *name,
			    void (*function) (Arg *, int), char *args));

extern void
XtentXrmPutStringResource C_P_ARGS((XrmDatabase * db, char *buffer,
				    char *value, int field_count));

static void
XtentCheckSprintfSize C_P_ARGS((int string_size, char **buffer,
				int *buffer_length, char **start, char **end));

static Atom
XtentStringToAtom C_P_ARGS((Display *display, char *ptr));

static char *
XtentAtomToString C_P_ARGS((Display *display, Atom atom));

static int
XtentTestTextType C_P_ARGS((Widget w, WidgetClass class, char *buffer));

extern Widget
XtentToplevel C_P_ARGS((Display * display, Widget * toplevel_ptr));

extern Widget *
XtentSetToplevelPtr C_P_ARGS((Widget * set_toplevel_ptr));

extern Widget *
XtentToplevelPtr C_P_NO_ARGS();

extern Display *
XtentSetDisplay C_P_ARGS((Display * set_display));

extern Display *
XtentDisplay C_P_NO_ARGS();

static char *
XtentSetArgv C_P_ARGS((int set_argc, char *set_value));

static int
XtentSetArgc C_P_ARGS((int set_argc));

static int
XtentArgc C_P_NO_ARGS();

static char *
XtentArgv C_P_ARGS((int arg_index));

extern void
XtentStoreArgcArgv C_P_ARGS((int set_argc, char **set_argv));

extern int
XtentSetLineCount C_P_ARGS((int set_count));

extern int
XtentLineCount C_P_NO_ARGS();

extern int
XtentSetMessageCount C_P_ARGS((int set_count));

extern int
XtentMessageCount C_P_NO_ARGS();

static Boolean
XtentProcessWidgetNames C_P_ARGS((int process_type, Widget root,
				  char *title, XtentOutput *fp,
				  char *target_widget));

static XtCallbackProc
XtentCallbackProc C_P_ARGS((Widget w, XtPointer client_data,
			    XtPointer call_data));

static XtCallbackProc
XtentCallbackWithArgsProc C_P_ARGS((Widget w, XtPointer client_data,
				    XtPointer call_data));

static void
XtentGetSelectionProc C_P_ARGS((Widget w, XtPointer client_data,
				Atom * selection, Atom * type,
				XtPointer value, unsigned long * length,
				int * format));

static Widget
XtentToplevelParent C_P_ARGS((Widget w));

static Boolean
XtentConvertSelectionProc C_P_ARGS((Widget w, Atom *selection, Atom *target,
				    Atom *type, XtPointer *value,
				    unsigned long *length, int *format));

static void
XtentLoseSelectionProc C_P_ARGS((Widget w, Atom *selection));

static void
XtentDoneSelectionProc C_P_ARGS((Widget w, Atom *selection, Atom *target));

static void
XtentEventHandlerProc C_P_ARGS((Widget w, XtPointer client_data,
				XEvent * event,
				Boolean * continue_to_dispatch));

static void
XtentActionProc C_P_ARGS((Widget w, XEvent * event, String * params,
			  Cardinal * count));

static XtInputCallbackProc
XtentInputProc C_P_ARGS((InputLine * client_data, int *source,
			 XtInputId * id));

static XtTimerCallbackProc
XtentTimeoutProc C_P_ARGS((XtPointer client_data, XtIntervalId id));

static XtWorkProc
XtentWorkProcProc C_P_ARGS((XtPointer client_data));

extern void
XtentIPCServerClientInputProc C_P_ARGS((XtPointer client_data, int *source,
					XtInputId *id));

static void
XtentIPCClientInputProc C_P_ARGS((XtPointer client_data, int *source,
				  XtInputId *id));

static void
XtentIPCClientCleanupXtentData C_P_ARGS((IPCClientDescriptor
					 **XtentIPCClientDescriptors, int i));

static XtTranslations
XtentParseTranslationTable C_P_ARGS((char *buffer));

static char *
XtentConvertEmbeddedNames C_P_ARGS((Display *display, Widget *toplevel_ptr,
				    char *buffer));

static char *
XtentTrimBuffer C_P_ARGS((char *buffer));

static int
XtentTestTrue C_P_ARGS((char *str));

static void
XtentShellEscapeProc C_P_ARGS((Display * display, Widget * toplevel_ptr,
			       char *buffer));

static XrmQuark
ResourceToResourceType C_P_ARGS((Widget parent, WidgetClass widget_class,
				 WidgetClass top_widget_class,
				 XrmQuark name_quark));

static char *
XtentGetValue C_P_ARGS((Display * display, Widget * toplevel_ptr,
			char *buffer, char *pre_element));

static char *
XtentQuarkGetValue C_P_ARGS((Widget w, XrmQuark res_quark, char *name));

static int
ResItemCmp C_P_ARGS((ResItem **a, ResItem **b));

static void
XtentPrintWidgetResources C_P_ARGS((WidgetClass widget_class, Widget widget,
				    char *widget_name, XtentOutput *fp));

static void 
XtentFormatPrint C_P_ARGS((XtentOutput *output, char *format, ...));

static char *
XtentProcessArgN C_P_ARGS((Display * display, Widget * toplevel_ptr,
			   XtentFrameData * frame_data, int index,
			   int do_expansion));

static void
XtentLocalVariable C_P_ARGS((Display * display, int access_type,
			     int frame_number, char *argument_name,
			     char *argument_value));

static char *
XtentCalcTrueOrFalseString C_P_ARGS((int b));

static void
XtentCalcParse C_P_ARGS((char *arg_ptr, int double_type,
			 int *arg_stack_required, unsigned int *arg_type));

static int
XtentCalcIntegerToBoolean C_P_ARGS((XtentCalcIntegerPostFixArgs * ptr));

static void
XtentIntegerCalc C_P_ARGS((Display * display, Widget * toplevel_ptr,
			   XtentFrameData * frame_data_ptr));

static int
XtentCalcDoubleToBoolean C_P_ARGS((XtentCalcDoublePostFixArgs * ptr));

static void
XtentDoubleCalc C_P_ARGS((Display * display, Widget * toplevel_ptr,
			  XtentFrameData * frame_data_ptr));

static void
XtentSetReturn C_P_ARGS((char *value));

static void
XtentPutStringReturn C_P_ARGS((XrmDatabase * db, char *variable_name,
			       char *value));

static int
XtentIsNumber C_P_ARGS((char *ptr, int check_dot));

#ifdef ATHENA

static void
XtentScrollbarDestroyProc C_P_ARGS((Widget w, XtPointer client_data,
				    XtPointer value));

static void
XtentStripChartGetValueProc C_P_ARGS((Widget w, XtPointer client_data,
				      XtPointer value));

static void
XtentStripChartDestroyProc C_P_ARGS((Widget w, XtPointer client_data,
				     XtPointer value));

#endif /* ATHENA */

#ifdef MOTIF

static void
XtentXmCutPasteProc C_P_ARGS ((Widget w, int *data_id, int *private,
			       int *reason));

#endif /* MOTIF */
#ifdef OPENLOOK

static int
XtentOLAxis C_P_ARGS((char *arg_ptr));

static void
XtentOLSLDestroyCallbackProc C_P_ARGS((Widget w, XtPointer client_data,
				       XtPointer call_data));

static void
XtentOLHelpProc C_P_ARGS((C_Promoted_Short id_type, XtPointer id,
			  int src_x, int src_y));

#ifndef OLD_OPENLOOK

static void
XtentOlDnDPreviewAnimateCallbackProc C_P_ARGS((Widget widget, int eventcode,
					       Time time_stamp,
					       C_Promoted_Boolean sensitivity,
					       XtPointer closure));

static void
XtentOlDnDTriggerMessageNotifyProc C_P_ARGS((Widget widget, Window window,
					     C_Promoted_Short root_x,
					     C_Promoted_Short root_y,
					     Atom selection, Time time_stamp,
					     OlDnDDropSiteID dropsiteid,
					     OlDnDTriggerOperation operation,
					     C_Promoted_Boolean send_done,
					     C_Promoted_Boolean forwarded,
					     XtPointer closure));

static void
XtentOlDnDPreviewMessageNotifyProc C_P_ARGS((Widget widget, Window window,
					     C_Promoted_Short root_x,
					     C_Promoted_Short root_y,
					     int operation, Time time_stamp,
					     OlDnDDropSiteID dropsiteid,
					     C_Promoted_Boolean forwarded,
					     XtPointer closure));

static void
XtentOlDnDProtocolActionCallbackProc C_P_ARGS((Widget widget, Atom selection,
					  OlDnDProtocolAction protocol_action,
					     C_Promoted_Boolean flag,
					       XtPointer closure));

static void
XtentOlDnDTransactionStateCallback C_P_ARGS((Widget widget, Atom selection,
					     OlDnDTransactionState state,
					     Time time_stamp,
					     XtPointer closure));

#endif /* OLD_OPENLOOK */
#endif /* OPENLOOK */

C_PROTOS_END_EXTERN

extern double atof C_P_ARGS((const char *));

extern double sqrt C_P_ARGS((double));

typedef int (* QsortCmpProc) C_P_ARGS((const void *, const void *));

/*
 * primary interface presented to applications
 */
void
Xtent (display, toplevel_ptr, fp)
Display * display;
Widget * toplevel_ptr;
FILE * fp;
{
    char *resource_buffer = (char *) XtMalloc (RBUFSIZ);
    int resource_buffer_size = RBUFSIZ;

    /*
     * if toplevel_ptr == NULL then the application assumes
     * that Xtent will do all widget related manipulations
     */
    if (toplevel_ptr == (Widget *) NULL)
    {
	static Widget pseudo_top = (Widget) NULL;

	toplevel_ptr = &pseudo_top;
    }
    XtentSetToplevelPtr (toplevel_ptr);	/* stash it away for action proc */

    if (display == (Display *) NULL)
    {
	if (*toplevel_ptr)
	    display = XtDisplay (*toplevel_ptr);
	else
	{
	    static char *argv[2];
	    static int argc;
	    XtAppContext return_context;

	    argv[0] = XtentProgramName ();
	    argc = 1;
	    XtentInitialize (argv[0], "Xtent",
			     (XrmOptionDescRec *) NULL, 0,
			     &argc, argv,
			     &display, &return_context);
	}
	if (display == NULL)
	    XtentErrorMessage ("Cannot open the display.");
    }
    XtentSetDisplay (display);

    if (fp == (FILE *) NULL)
	fp = stdin;

    /*
     * read through the resource file
     */
    while (XtentReadResourceLine (fp, &resource_buffer,
				  &resource_buffer_size) == True)
	XtentEvalResourceLine (display, toplevel_ptr, resource_buffer);

    XtFree ((char *) resource_buffer);
}

/*
 * the string equivalent of Xtent()
 */
void
XtentEvalString (display, toplevel_ptr, buffer)
Display * display;
Widget * toplevel_ptr;
char * buffer;
{
    /*
     * if toplevel_ptr == NULL then the application assumes
     * that Xtent will do all widget related manipulations
     */
    if (toplevel_ptr == (Widget *) NULL)
    {
	static Widget pseudo_top = (Widget) NULL;

	toplevel_ptr = &pseudo_top;
    }
    XtentSetToplevelPtr (toplevel_ptr);

    if (display == (Display *) NULL)
    {
	if (*toplevel_ptr)
	    display = XtDisplay (*toplevel_ptr);
	else
	{
	    static char *argv[2];
	    static int argc;
	    XtAppContext return_context;

	    argv[0] = XtentProgramName ();
	    argc = 1;
	    XtentInitialize (argv[0], "Xtent",
			     (XrmOptionDescRec *) NULL, 0,
			     &argc, argv,
			     &display, &return_context);
	}
	if (display == NULL)
	    XtentErrorMessage ("Cannot open the display.");
    }
    XtentSetDisplay (display);

    XtentEvalResourceLine (display, toplevel_ptr, buffer);
}

/*
 * read in resource lines - handle continuations and comments
 */
static int
XtentReadResourceLine (fp, resource_buffer, resource_buffer_size)
FILE * fp;
char **resource_buffer;
int *resource_buffer_size;
{
    char *buffer = *resource_buffer;
    int size = *resource_buffer_size;
    int len, prev_len;
    int pound_entry = 0;
    int continue_line = False;
    int extend_line = False;
    int extend_len = 0;

    do
    {
	len = prev_len = 0;
	do
	{
	    if (fgets (buffer + len, size - len, fp) == NULL)
	    {
		if (len == 0)
		    return False;

		buffer[len] = '\0';
		return True;
	    }

	    prev_len = len;
	    len += strlen (buffer + len);
	    if (len > prev_len && buffer[len - 1] == '\n')
	    {
		XtentSetLineCount (XtentLineCount () + 1);

		/*
		 * reconnect spliced lines - cross buffer reads
		 */
		if (extend_line == True)
		{
		    prev_len = extend_len;
		    extend_line = False;
		}

		/*
		 * dump comments in functions
		 */
		if ((pound_entry || continue_line) &&
		    *XtentTrimBuffer (buffer + prev_len) == '!')
		{
		    continue_line = ((len - prev_len) >= 2 &&
				     buffer[len - 2] == '\\');
		    len = prev_len;
		    continue;
		}

		/*
		 * check for continuation and quotes
		 */
		continue_line = False;

		len--;
		if (len > prev_len)
		{
		    if (buffer[len - 1] == '#')
		    {
			if ((len - prev_len) >= 2 && buffer[len - 2] == '\\')
			{
			    pound_entry++;
			    len -= 2;
			}
			else if (len - prev_len == 1 && pound_entry)
			{
			    pound_entry--;
			    len--;
			}
		    }
		    else if (buffer[len - 1] == '\\')
		    {
			len--;
			continue_line = True;
		    }
		}
	    }
	    else if (len == (size - 1))
	    {
		/*
		 * no end of line has been found - cross buffer reads
		 * realloc() the buffer and continue reading
		 */
		size = *resource_buffer_size * 2;
		buffer = (char *) realloc (buffer, size);
		if (buffer == (char *) NULL)
		{
		    fprintf (stderr,
		     "%s: Line greater than %d characters read at line %d.\n",
			     XtentProgramName (), size + 1,
			     XtentLineCount ());
		    return False;
		}
		*resource_buffer = buffer;
		*resource_buffer_size = size;
		continue_line = True;
		if (extend_line == False)
		{
		    extend_len = prev_len;
		    extend_line = True;
		}
		continue;
	    }
	} while (pound_entry || continue_line);

    } while (len == 0 || buffer[0] == '!');/* resource db comments */

    buffer[len] = '\0';
    return True;
}

/*
 * This routine is called once for each line of the resource file.
 * return False if the line is not a legal Xtent command.
 */
#define XtentReturnBufferSize	32
static char * XtentReturnValue = NULL;
static char   XtentReturnBuffer[XtentReturnBufferSize];

#ifdef AUDIT_TRAIL		/* cec */
static int intern_lines = False;
#endif

int
XtentEvalResourceLine (display, toplevel_ptr, buffer)
Display * display;
Widget * toplevel_ptr;
register char * buffer;
{
    register char *arg_ptr;
    register char *val_ptr;
    XtentWidgetClassName * wcn;
    Operation * op;
    char *element, *operation, *colon, mark;
    int field_count;
    Item item;
    int arg_count, i, j;
    Widget w;
    static CallbackLine * XtentCallbackLines = NULL;
    static EventHandlerLine * XtentEventHandlerLines = NULL;
    static InputLine * XtentInputLines = NULL;
    static TimeoutLine * XtentTimeoutLines = NULL;
    static WorkProcLine * XtentWorkProcLines = NULL;
    static FileDescriptor * XtentFileDescriptors = NULL;
    static IPCServerDescriptor ** XtentIPCServerDescriptors = NULL;
    static int XtentIPCServerDescriptorsSize = 0;
    static IPCClientDescriptor ** XtentIPCClientDescriptors = NULL;
    static int XtentIPCClientDescriptorsSize = 0;
    static XtentNamedResourceList * XtentNamedResourceLists = NULL;
    static Arg *args = (Arg *) NULL;
    static int arg_max_count = 0;
    static char copy_buffer[32];
#ifndef AUDIT_TRAIL		/* cec */
    static int intern_lines = False;
#endif
    static char *intern_function = (char *) NULL;
    static int initialized = False;
#ifdef LIB_E /* RAD */
    static int e_initialized = False;
#endif /* LIB_E */ /* RAD */
    static int parse_array_size = 0;
    static XrmBindingList parse_bindings = (XrmBindingList) NULL;
    static XrmQuarkList parse_quarks = (XrmQuarkList) NULL;
    static XrmQuark xtent_name_quark;
    char *string_one;
    XtentFrameData frame_data;
    XrmDatabase db = XtDatabase(display);

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);

    /*
     * initialize the class names and operations
     */
    if (initialized == False)
    {
	register XtentWidgetClassName * wcn;
	register Operation * op;
	register Item item;

	initialized = True;
	wcn = XtentWidgetClassNames;
	while (wcn -> string != (char *) NULL)
	{
	    item = XtentStringToQuarkItem (wcn -> string, True);
	    item -> application_ptr = (XtPointer) wcn;
	    item -> application_type = (int) XtentWidgetClassNamesType;
	    wcn++;
	}
	op = Operations;
	while (op -> string != (char *) NULL)
	{
	    item = XtentStringToQuarkItem (op -> string, True);
	    item -> application_ptr = (XtPointer) op;
	    item -> application_type = (int) XtentOperationsType;
	    op++;
	}
	arg_max_count = XTENTMAXARGS;
	args = (Arg *) XtMalloc (sizeof (Arg) * arg_max_count);
	parse_array_size = 32;
	parse_bindings = (XrmBindingList)
	    XtMalloc (parse_array_size * sizeof (XrmBinding));
	parse_quarks = (XrmQuarkList)
	    XtMalloc (parse_array_size * sizeof (XrmQuark));
	xtent_name_quark = XrmStringToQuark (XtentProgramName ());
    }

    /*
     * debugging support
     */
    if (intern_lines == True)
    {
	XrmPutStringResource (&db, "XtentLine", buffer);
	sprintf (copy_buffer, "%d", frame_data.frame);
	XrmPutStringResource (&db, "XtentFrame", copy_buffer);

	if (intern_function)
	{
	    intern_lines = 2;
	    XtentEvalResourceLine (display, toplevel_ptr,
				   intern_function);
	    if (intern_lines == 2)	/* it may have been reset */
		intern_lines = True;
	}
	else
	{
	    for (i = 0; i < frame_data.frame; i++)
		fputc ('>', stderr);
	    fprintf (stderr, " %s evaluating:\n",
		     XtentProgramName ());

	    for (i = 0; i < frame_data.frame; i++)
		fputc ('>', stderr);
	    fprintf (stderr, "  \"%s\"\n", buffer);

	    for (i = 0; i < frame_data.frame; i++)
		fputc ('>', stderr);
	    fprintf (stderr, "  at line %d, message %d.\n",
		     XtentLineCount (), XtentMessageCount ());
	    fflush (stderr);
	}
    }

    /*
     * parse the resource line looking for the last element
     * and operation followed by the value (aka args).
     *
     * xtent.element.operation: value
     *
     */
    arg_count = 0;
    
    /*
     * two goto's to handle the double break case in C.
     */
 double_break_continue:
    /*
     * remove leading white space
     */
    arg_ptr = buffer;
    while (*arg_ptr == ' ' || *arg_ptr == '\t')
	arg_ptr++;
    
    if (*arg_ptr == '!' || *arg_ptr == '\n' || *arg_ptr == '\0')
	ArgNReturn (True);
    
    /*
     * parse the line looking for:
     *  . left hand macros to be expanded
     *  . the colon separating the left and right hand components
     *  . the operation and the element
     */
    element = NULL;
    operation = arg_ptr;
    field_count = 0;
    for (;;)
    {
	switch (*arg_ptr++)
	{
	case '\0':
	    /*
	     * an invalid resource line - discard it.
	     */
	    if (*(arg_ptr - 1) != ':')
	    {
		fprintf (stderr,
			 "%s: Missing \":\" at line %d, message %d: \"%s\"\n",
			 XtentProgramName (), XtentLineCount (),
			 XtentMessageCount (), buffer);
		ArgNReturn (False);
	    }
	case ':':
	    colon = arg_ptr - 1;
	    if (field_count >= parse_array_size)
	    {
		parse_array_size += 32;
		parse_bindings = (XrmBindingList)
		    XtRealloc ((char *) parse_bindings,
			       (Cardinal) parse_array_size * sizeof (XrmBinding));
		parse_quarks = (XrmQuarkList)
		    XtRealloc ((char *) parse_quarks,
			       (Cardinal) parse_array_size * sizeof (XrmQuark));
	    }
	    parse_quarks[field_count] = (XrmQuark) colon;
	    field_count++;
	    goto double_break_done;

	case '^':
	{
	    register char mark;
	    register char mark_end;
	    int pre_length;
	    
	    if (arg_ptr - buffer < arg_count)
		break;
	    
	    /*
	     * find the type of conversion requested
	     */
	    switch (*arg_ptr)
	    {
	    case '(':
		mark = '(';
		mark_end = ')';
		break;
	    case '{':
		mark = '{';
		mark_end = '}';
		break;
	    case '[':
		mark = '[';
		mark_end = ']';
		break;
	    default:
		mark = '-';
		break;
	    }
	    if (mark == '-')
		break;
	    
	    /*
	     * find the matching mark or delimiter
	     */
	    element = arg_ptr - 1;
	    arg_ptr++;
	    i = 1;
	    while (*arg_ptr)
	    {
		if (*arg_ptr == mark)
		    i++;
		else if (*arg_ptr == mark_end)
		{
		    i--;
		    if (i == 0)
		    {
			arg_ptr++;
			break;
		    }
		}
		else  if (*arg_ptr == '\\')
		{
		    if (arg_ptr[1])
			arg_ptr++;
		}
		arg_ptr++;
	    }
	    if (i == 0)
	    {
		mark = *arg_ptr;
		*arg_ptr = '\0';
		operation = XtentConvertEmbeddedNames (display,
						       toplevel_ptr,
						       element);
		*arg_ptr = mark;
	    }
	    if (i != 0 || operation == element)
	    {
		fprintf (stderr,
	"%s: Cannot process left hand macro at line %d, message %d:\n",
	XtentProgramName (), XtentLineCount (), XtentMessageCount ());
		fprintf (stderr, "%s: \"%s\"\n", XtentProgramName (), buffer);
		ArgNReturn (False);
	    }
	    pre_length = element - buffer;
	    i = strlen (operation);
	    j = strlen (arg_ptr);
	    val_ptr = XtMalloc (pre_length + i + j + 1);
	    
	    if (pre_length > 0)
		memcpy (val_ptr, buffer, pre_length);
	    
	    if (i > 0)
		memcpy (val_ptr + pre_length, operation, i);
	    
	    if (j > 0)
		memcpy (val_ptr + pre_length + i, arg_ptr, j);
	    
	    val_ptr[pre_length + i + j] = '\0';
	    
	    XtFree ((char *) operation);
	    if (frame_data.used_malloc)
		XtFree ((char *) buffer);
	    
	    frame_data.used_malloc = True;
	    frame_data.buffer = buffer = val_ptr;
	    arg_count = i + pre_length;
	    goto double_break_continue;
	}
	case '\\':
	    if (*arg_ptr)
		arg_ptr++;
	    break;
	case '.':
	case '*':
	    if ((field_count + 1) >= parse_array_size)
	    {
		parse_array_size += 32;
		parse_bindings = (XrmBindingList)
		    XtRealloc ((char *) parse_bindings,
			       (Cardinal) parse_array_size * sizeof (XrmBinding));
		parse_quarks = (XrmQuarkList)
		    XtRealloc ((char *) parse_quarks,
			       (Cardinal) parse_array_size * sizeof (XrmQuark));
	    }

	    parse_quarks[field_count] = (XrmQuark) (arg_ptr - 1);
	    field_count++;
	    if (*(arg_ptr - 1) == '.')
		parse_bindings[field_count] = XrmBindTightly;
	    else
		parse_bindings[field_count] = XrmBindLoosely;

	    if (element == (char *) NULL)
		element = arg_ptr;
	    else
		element = operation;

	    operation = arg_ptr;
	    break;
	}			/* switch per character */
    }				/* for: loop through the line */

 double_break_done:
    frame_data.buffer = buffer;

    /*
     * look for the line prefix - '.' is equivalent to xtent_program_name
     *
     *     frame_data.arg_buffer = XtentTrimBuffer (colon + 1);
     */
    arg_ptr = colon + 1;
    while (*arg_ptr == ' ' || *arg_ptr == '\t' || *arg_ptr == '\n')
	arg_ptr++;
    frame_data.arg_buffer = arg_ptr;

    /*
     * arg_ptr = buffer = XtentTrimBuffer (buffer);
     */
    arg_ptr = buffer;
    while (*arg_ptr == ' ' || *arg_ptr == '\t' || *arg_ptr == '\n')
	arg_ptr++;
    buffer = arg_ptr;

    /*
     * convert to quarks - CHECK the .. and .* case
     */
    switch (*arg_ptr)
    {
    case '\0':
    case '\n':
    case '!':
    case ':':
	ArgNReturn (True);

    case '.':
	parse_quarks[0] = xtent_name_quark;
	parse_bindings[0] = XrmBindTightly;
	buffer = arg_ptr + 1;
	if (*buffer == '*')
	{
	    j = field_count - 1;
	    for (i = 1; i < j; i++)
	    {
		parse_quarks[i] = parse_quarks[i + 1];
		parse_bindings[i] = parse_bindings[i + 1];
	    }
	    field_count--;
	    arg_ptr = buffer;
	}
	break;

    case '*':
	buffer = arg_ptr;
	while (*arg_ptr == '.' || *arg_ptr == '*')
	    arg_ptr++;
	arg_count = arg_ptr - buffer;
	j = field_count - arg_count;
	for (i = 0; i < j; i++)
	{
	    parse_quarks[i] = parse_quarks[i + arg_count];
	    parse_bindings[i] = parse_bindings[i + arg_count];
	}
	field_count -= arg_count;
	arg_ptr = (char *) parse_quarks[0];
	mark = *arg_ptr;
	*arg_ptr = '\0';
	parse_quarks[0] = XrmStringToQuark (buffer + arg_count);
	*arg_ptr = mark;
	parse_bindings[0] = XrmBindLoosely;
	break;

    default:
	arg_ptr = (char *) parse_quarks[0];
	mark = *arg_ptr;
	*arg_ptr = '\0';
	if (strcmp (buffer, XtentProgramName ()) == 0)
	    parse_quarks[0] = xtent_name_quark;
	else
	    parse_quarks[0] = XrmStringToQuark (buffer);
	*arg_ptr = mark;
	parse_bindings[0] = XrmBindTightly;
	buffer = arg_ptr;
    }
    if (*buffer == '.')
	buffer++;
    string_one = arg_ptr + 1;

    /*
     * forget about the operation field for searches and prefix for stores
     */
    field_count--;

    /*
     * check for the operation prefix
     */
    if (parse_quarks[0] != xtent_name_quark ||
	operation == colon ||
	strncmp (operation, OP_PREFIX, OP_PREFIXLENGTH) != 0)
    {
	XtentCompileParseQuarks (string_one, &parse_quarks[1],
				 &parse_bindings[1], &field_count);
	XrmQPutStringResource (&db, parse_bindings, parse_quarks,
			       frame_data.arg_buffer);
	ArgNReturn (False);
    }

    /*
     * a resource line with the format we can handle - get the operation
     */
    arg_ptr = operation + OP_PREFIXLENGTH;
    *colon = '\0';
    item = XtentStringToQuarkItem (arg_ptr, False);
    *colon = ':';
    if (item -> application_type == (int) XtentApplicationCFunctionType ||
	item -> application_type == (int) XtentApplicationFunctionType ||
	item -> application_type == (int) XtentApplicationThisFunctionType)
    {
	XrmString value_type;
	XrmValue value_return;
	XtentFunctionRecordArgs * argument_ptr;
	XtentFunctionRecord * record = (XtentFunctionRecord *)
	    item -> application_ptr;

	if (item -> application_type == (int) XtentApplicationCFunctionType)
	{
	    if ((record -> argument_count + 1) >= arg_max_count)
	    {
		arg_max_count += XTENTMAXARGS;
		args = (Arg *) XtRealloc ((char *) args, 
				(Cardinal) sizeof (Arg) * arg_max_count);
	    }

	    operation--;
	    mark = *operation;
	    *operation = '\0';
	    arg_ptr = XtNewString (frame_data.buffer);
	    *operation = mark;

	    XtSetArg (args[0], "this", arg_ptr);

	    if (record -> argument_count > 0)
	    {
		argument_ptr = record -> argument_list;
		if (record -> argument_count == 1)
		    i = -1;
		else
		    i = 0;

		arg_count = 1;
		while (argument_ptr)
		{
		    val_ptr = XtentProcessArgN (display, toplevel_ptr,
						&frame_data, i,
				(*argument_ptr -> argument_name != '_'));

		    if (arg_count >= arg_max_count)
		    {
			arg_max_count += XTENTMAXARGS;
			args = (Arg *) XtRealloc ((char *) args, 
					(Cardinal) sizeof (Arg) * arg_max_count);
		    }
		    XtSetArg (args[arg_count],
			      argument_ptr -> argument_name, val_ptr);
		    i++; arg_count++;

		    if (strcmp (argument_ptr -> argument_name, "...") == 0 ||
			strcmp (argument_ptr -> argument_name, "_...") == 0)
		    {
			if (*val_ptr == '\0' && frame_data.end_of_line)
			{
			    arg_count--;
			    break;
			}
			continue;
		    }

		    argument_ptr = argument_ptr -> next;
		}
	    }

	    (*record -> C_function) (args, arg_count);

	    XtFree (arg_ptr);

	    ArgNReturn (True);
	}

	if (!(XrmGetResource (XtDatabase (display),
			      record -> resource_name, (char *) NULL,
			      &value_type, &value_return) &&
	      value_return.size > 0))
	{
	    fprintf (stderr,
	"%s: Could not find the function at line %d, message %d: \"%s\"\n",
		     XtentProgramName (), XtentLineCount (),
		     XtentMessageCount (),
		     frame_data.buffer);

	    XrmPutLineResource (&db, frame_data.buffer);

	    ArgNReturn (False);
	}

	val_ptr = XtMalloc (value_return.size);
	memcpy (val_ptr, value_return.addr, value_return.size);

	/*
	 * add "this" as the current widget name
	 */
	if (item -> application_type == (int) XtentApplicationThisFunctionType)
	{
	    arg_ptr = "this";
	    operation--;
	    mark = *operation;
	    *operation = '\0';
	    XtentLocalVariable (display, XtentVariablesPush,
				frame_data.frame, arg_ptr,
				frame_data.buffer);
	    *operation = mark;
	}

	if (record -> argument_count > 0)
	{
	    argument_ptr = record -> argument_list;
	    if (record -> argument_count == 1)
		i = -1;
	    else
		i = 0;

	    while (argument_ptr)
	    {
		XtentLocalVariable (display, XtentVariablesPush,
				    frame_data.frame,
				    argument_ptr -> argument_name, ArgN (i));
		i++;
		argument_ptr = argument_ptr -> next;
	    }
	}
	XtentEvalResourceLine (display, toplevel_ptr, val_ptr);

	XtFree ((char *) val_ptr);

	ArgNReturn (True);
    }
    else if (item -> application_type != (int) XtentOperationsType)
    {
	fprintf (stderr,
     "%s: Unknown operation specified at line %d, message %d: \"%s\"\n",
		 XtentProgramName (), XtentLineCount (),
		 XtentMessageCount (), frame_data.buffer);
	XrmPutLineResource (&db, frame_data.buffer);
	ArgNReturn (False);
    }

    op = (Operation *) item -> application_ptr;

    /*
     * use a switch to avoid the function call overhead
     */
    switch (op -> type)
    {
    case AddCallback:
    case _AddCallback:
    case AddCallbackWithArgs:
    case _AddCallbackWithArgs:

#ifdef MOTIF
    case XMAddProtocolCallback:  /* widget.protocol.Xt*: (prop, cb-code) */
    case _XMAddProtocolCallback:
    case XMAddWMProtocolCallback:/* widget.protocol.Xt*: cb-code */
    case _XMAddWMProtocolCallback:
#endif /* MOTIF */

#ifdef OPENLOOK
    case OLAddCallback:
    case _OLAddCallback:
    case OLAddCallbackWithArgs:
    case _OLAddCallbackWithArgs:
#endif /* OPENLOOK */

    {
#ifdef MOTIF
	char *prop_str;
#endif /* MOTIF */
	CallbackLine * cb;
	int expanded;

	if (op -> type == _AddCallbackWithArgs ||
#ifdef MOTIF
	    op -> type == _XMAddProtocolCallback ||
	    op -> type == _XMAddWMProtocolCallback ||
#endif /* MOTIF */
#ifdef OPENLOOK
	    op -> type == _OLAddCallback ||
	    op -> type == _OLAddCallbackWithArgs ||
#endif /* OPENLOOK */
	    op -> type == _AddCallback)
	    expanded = False;
	else
	    expanded = True;

#ifdef MOTIF
	if (op -> type == XMAddProtocolCallback ||
	    op -> type == _XMAddProtocolCallback)
	{
	    prop_str = ArgN (0);
	    val_ptr = XtentProcessArgN (display, toplevel_ptr,
					&frame_data, 1, expanded);
	}
	else
#endif /* MOTIF */
	    val_ptr = XtentProcessArgN (display, toplevel_ptr,
					&frame_data, -1, expanded);

	i = strlen (val_ptr);
	j = (operation - 1) - element;
	cb = (CallbackLine *) XtMalloc (sizeof (CallbackLine) + i + 1 + j + 1);
	memcpy (cb -> code, val_ptr, i + 1);
	cb -> expanded = expanded;
	cb -> callback_name = cb -> code + i + 1;
	memcpy (cb -> callback_name, element, j);
	cb -> callback_name[j] = '\0';
	cb -> arg_list = (CallbackWithArgItem *) NULL;
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	cb -> widget = w;
	cb -> next = XtentCallbackLines;
	XtentCallbackLines = cb;

	if (op -> type == _AddCallbackWithArgs ||
#ifdef OPENLOOK
	    op -> type == OLAddCallbackWithArgs ||
	    op -> type == _OLAddCallbackWithArgs ||
#endif /* OPENLOOK */
	    op -> type == AddCallbackWithArgs)
	{
	    CallbackWithArgItem *arg_item, *arg_prev;

	    arg_count = 1;
	    arg_prev = (CallbackWithArgItem *) NULL;
	    for (;;)
	    {
		arg_ptr = ArgN (arg_count++);
		if (*arg_ptr == '\0' && frame_data.end_of_line)
		    break;

		i = strlen (arg_ptr);
		arg_item = (CallbackWithArgItem *)
		    XtMalloc (sizeof (CallbackWithArgItem) + i);
		memcpy (arg_item -> arg, arg_ptr, i + 1);

		if (arg_prev)
		    arg_prev -> next = arg_item;
		else
		    cb -> arg_list = arg_item;

		arg_item -> next = (CallbackWithArgItem *) NULL;
		arg_prev = arg_item;
	    }
	}

#ifdef MOTIF
	if (op -> type == XMAddProtocolCallback ||
	    op -> type == _XMAddProtocolCallback)
	{
	    CallbackWithArgItem *arg_item;

	    i = strlen (prop_str);
	    arg_item = (CallbackWithArgItem *)
		XtMalloc (sizeof (CallbackWithArgItem) + i);
	    memcpy (arg_item -> arg, prop_str, i + 1);
	    cb -> arg_list = arg_item;
	    arg_item -> next = (CallbackWithArgItem *) NULL;

	    XmAddProtocolCallback (w, XtentStringToAtom (display, prop_str),
				   XtentStringToAtom (display,
						      cb -> callback_name),
				   (XtCallbackProc) XtentCallbackProc,
				   (XtPointer) cb);
	}
	else if (op -> type == XMAddWMProtocolCallback ||
		 op -> type == _XMAddWMProtocolCallback)
	{
	    XmAddWMProtocolCallback (w,
				     XtentStringToAtom (display,
							cb -> callback_name),
				     (XtCallbackProc) XtentCallbackProc,
				     (XtPointer) cb);
	}
	else
#endif /* MOTIF */
#ifdef OPENLOOK
	if (op -> type == OLAddCallback || op -> type == _OLAddCallback)
	    OlAddCallback (w, cb -> callback_name,
			   (XtCallbackProc) XtentCallbackProc,
			   (XtPointer) cb);
	else if (op -> type == OLAddCallbackWithArgs ||
		 op -> type == _OLAddCallbackWithArgs)
	    OlAddCallback (w, cb -> callback_name,
			   (XtCallbackProc) XtentCallbackWithArgsProc,
			   (XtPointer) cb);
	else
#endif /* OPENLOOK */
	XtAddCallback (w, cb -> callback_name,
		       (XtCallbackProc) ((cb -> arg_list) ?
					 XtentCallbackWithArgsProc :
					 XtentCallbackProc),
		       (XtPointer) cb);

	ArgNReturn (True);
    }

    case AddEventHandler:
    case _AddEventHandler:
    case AddRawEventHandler:
    case _AddRawEventHandler:
    case InsertEventHandler:
    case _InsertEventHandler:
    case InsertRawEventHandler:
    case _InsertRawEventHandler:
    {
	EventHandlerLine * eh;
	EventMask event_mask = atol (ArgN (0));
	Boolean nonmaskable = XtentTestTrue (ArgN (1));
	int expanded;

	if (op -> type == _AddEventHandler ||
	    op -> type == _AddRawEventHandler ||
	    op -> type == _InsertEventHandler ||
	    op -> type == _InsertRawEventHandler)
	    expanded = False;
	else
	    expanded = True;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				    expanded);

	i = strlen (val_ptr);
	eh = (EventHandlerLine *) XtMalloc (sizeof (EventHandlerLine) + i);
	memcpy (eh -> code, val_ptr, i + 1);
	eh -> expanded = expanded;
	eh -> event_mask = event_mask;
	eh -> nonmaskable = nonmaskable;
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	eh -> widget = w;
	eh -> next = XtentEventHandlerLines;
	XtentEventHandlerLines = eh;

	if (op -> type == AddEventHandler || op -> type == _AddEventHandler)
	    XtAddEventHandler (w, eh -> event_mask, eh -> nonmaskable,
			       XtentEventHandlerProc, eh);
	else if (op -> type == AddRawEventHandler ||
		 op -> type == _AddRawEventHandler)
	    XtAddRawEventHandler (w, eh -> event_mask, eh -> nonmaskable,
				  XtentEventHandlerProc, eh);
	else
	{
	    XtListPosition position;

	    if (strcmp (ArgN (3), "XtListTail") == 0)
		position = XtListTail;
	    else
		position = XtListHead;

	    if (op -> type == InsertEventHandler ||
		op -> type == _InsertEventHandler)
		XtInsertEventHandler (w, eh -> event_mask, eh -> nonmaskable,
				      XtentEventHandlerProc, eh, position);
	    else
		XtInsertRawEventHandler (w, eh -> event_mask,
					 eh -> nonmaskable,
					 XtentEventHandlerProc, eh, position);
	}
	ArgNReturn (True);
    }

    case AddGrab:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtAddGrab (w, XtentTestTrue (ArgN (0)), XtentTestTrue (ArgN (1)));
	ArgNReturn (True);

    case AppAddAction:
    {
	XtActionsRec action;

	action.string = ArgN (-1);
	action.proc = XtentActionProc;
	XtAppAddActions (XtWidgetToApplicationContext
			 (XtentToplevel (display, toplevel_ptr)),
			 &action, 1);
	ArgNReturn (True);
    }

    case AppAddInput:
    case AppAddInputNonBlocking:
    {
	InputLine * input;

	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0')
	    ArgNReturn (True);
	input = (InputLine *) XtMalloc (sizeof (InputLine) + strlen (arg_ptr));
	input -> display = display;
	input -> toplevel_ptr = toplevel_ptr;
	if (strcmp (arg_ptr, "-") == 0)
	    input -> fp = stdin;
	else
	    input -> fp = fopen (ExpandFileName (arg_ptr), "r");
	if (input -> fp == NULL)
	{
	    fprintf (stderr,
		     "%s: Cannot open AppAddInput file: %s.\n",
		     XtentProgramName (), arg_ptr);
	    XtFree ((char *) input);
	    XrmPutLineResource (&db, frame_data.buffer);
	    ArgNReturn (False);
	}
	if (op -> type == AppAddInputNonBlocking)
	{
	    if ((i = fcntl (fileno (input -> fp), F_GETFL, NULL)) != -1)
		fcntl (fileno (input -> fp), F_SETFL, i | O_NDELAY);
	}
	input -> next = XtentInputLines;
	strcpy (input -> file, arg_ptr);
	XtentInputLines = input;

	input -> id = XtAppAddInput (XtWidgetToApplicationContext
				     (XtentToplevel (display, toplevel_ptr)),
				     (int) fileno (input -> fp),
				     (XtPointer) XtInputReadMask,
				     (XtInputCallbackProc) XtentInputProc,
				     (XtPointer) input);
	ArgNReturn (True);
    }

    case AppAddTimeOut:
    case _AppAddTimeOut:
    {
	TimeoutLine * timeout;
	long interval = atol (ArgN (0));
	int expanded;

	if (op -> type == _AppAddTimeOut)
	    expanded = False;
	else
	    expanded = True;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    expanded);

	i = strlen (val_ptr);
	timeout = (TimeoutLine *) XtMalloc (sizeof (TimeoutLine) + i);
	timeout -> display = display;
	timeout -> toplevel_ptr = toplevel_ptr;
	timeout -> interval = interval;
	timeout -> timeouts = &XtentTimeoutLines;
	timeout -> next = XtentTimeoutLines;
	timeout -> expanded = expanded;
	memcpy (timeout -> code, val_ptr, i + 1);
	XtentTimeoutLines = timeout;

	timeout -> id = XtAppAddTimeOut (XtWidgetToApplicationContext
				       (XtentToplevel (display, toplevel_ptr)),
					 (unsigned long) atol (ArgN (0)),
				 (XtTimerCallbackProc) XtentTimeoutProc,
					 (XtPointer) timeout);
	ArgNReturn (True);
    }

    case AppAddWorkProc:
    case _AppAddWorkProc:
    {
	WorkProcLine * workproc;
	int expanded;

	if (op -> type == _AppAddWorkProc)
	    expanded = False;
	else
	    expanded = True;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    expanded);

	i = strlen (val_ptr);
	workproc = (WorkProcLine *) XtMalloc (sizeof (WorkProcLine) + i);
	workproc -> display = display;
	workproc -> toplevel_ptr = toplevel_ptr;
	workproc -> next = XtentWorkProcLines;
	workproc -> expanded = expanded;
	memcpy (workproc -> code, val_ptr, i + 1);
	XtentWorkProcLines = workproc;
	workproc -> id = XtAppAddWorkProc (XtWidgetToApplicationContext
				       (XtentToplevel (display, toplevel_ptr)),
					   (XtWorkProc) XtentWorkProcProc,
					   (XtPointer) workproc);
	ArgNReturn (True);
    }

    case AppCreateShell:
    {
	XtentShellRecord * shell_ptr;

	item = XtentStringToQuarkItem (ArgN (-1), False);
	if (item -> application_type != (int) XtentWidgetClassNamesType)
	{
	    fprintf (stderr,
		     "%s: Requested widget class not found: %s.\n",
		     XtentProgramName (), ArgN (-1));
	    ArgNReturn (True);
	}
	wcn = (XtentWidgetClassName *) item -> application_ptr;

	shell_ptr = (XtentShellRecord *) XtMalloc (sizeof (XtentShellRecord) +
					      operation - element);
	operation--;
	shell_ptr -> length = operation - element;
	mark = *operation;
	*operation = '\0';
	memcpy (shell_ptr -> name, element, shell_ptr -> length + 1);
	*operation = mark;
	shell_ptr -> w = XtAppCreateShell (XtentProgramName (),
					   shell_ptr -> name,
					   *wcn -> class,
					   display, (Arg *) NULL, 0);
	shell_ptr -> next = XtentShells;
	XtentShells = shell_ptr;
	ArgNReturn (True);
    }

    case AppError:
    case AppWarning:
	if (op -> type == AppError)
	    XtAppError (XtWidgetToApplicationContext
			(XtentToplevel (display, toplevel_ptr)),
			ArgN (-1));
	else
	    XtAppWarning (XtWidgetToApplicationContext
			  (XtentToplevel (display, toplevel_ptr)),
			  ArgN (-1));
	ArgNReturn (True);

    case AppErrorMsg:
    case AppWarningMsg:
	element = ArgN (4);
	i = 1;
	if (op -> type == AppErrorMsg)
	    XtAppErrorMsg (XtWidgetToApplicationContext
			   (XtentToplevel (display, toplevel_ptr)),
			   ArgN (0),	/* name */
			   ArgN (1),	/* type */
			   ArgN (2),	/* class */
			   ArgN (3),	/* default */
			   &element, (Cardinal *) &i);
				/* RAD - cast for &i */
	else
	    XtAppWarningMsg (XtWidgetToApplicationContext
			     (XtentToplevel (display, toplevel_ptr)),
			     ArgN (0),	/* name */
			     ArgN (1),	/* type */
			     ArgN (2),	/* class */
			     ArgN (3),	/* default */
			     &element, (Cardinal *) &i);
				/* RAD - cast for &i */
	ArgNReturn (True);

    case AppMainLoop:
	XtAppMainLoop (XtWidgetToApplicationContext
		       (XtentToplevel (display, toplevel_ptr)));
	ArgNReturn (True);

    case AugmentTranslations:
    case _AugmentTranslations:
    {
	XtTranslations trans;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    op -> type == AugmentTranslations);
	trans = XtentParseTranslationTable (val_ptr);
	XtAugmentTranslations (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer,
						   operation,
						   string_one,
						   parse_quarks,
						   parse_bindings,
						   field_count),
			       trans);
	ArgNReturn (True);
    }

    case BuildEventMask:
	sprintf (copy_buffer, "%d",
		 XtBuildEventMask (_xtentNameToWidget (display,
						       toplevel_ptr,
						       buffer,
						       operation,
						       string_one,
						       parse_quarks,
						       parse_bindings,
						       field_count)));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

    case CallCallbacks:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	operation--;
	mark = *operation;
	*operation = '\0';
	XtCallCallbacks (w, element, (XtPointer) NULL);
	*operation = mark;
	ArgNReturn (True);

    case Class:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	wcn = XtentWidgetClassNames;

	while (wcn -> string != (char *) NULL)
	{
	    if (*wcn -> class == XtClass (w))
	    {
		XtentPutStringReturn (&db, ArgN (-1),
				      wcn -> string);
		ArgNReturn (True);
	    }
	    wcn++;
	}
	/*
	 *  XtentPutStringReturn (&db, ArgN (-1),
	 *			  XtClass (w) -> core_class.class_name);
	 */
	XtentPutStringReturn (&db, ArgN (-1), "None");
	ArgNReturn (True);

    case ConfigureWidget:
	XtConfigureWidget (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one,
					       parse_quarks,
					       parse_bindings,
					       field_count),
			   atoi (ArgN (0)), /* x */
			   atoi (ArgN (1)), /* y */
			   atoi (ArgN (2)), /* width */
			   atoi (ArgN (3)), /* height */
			   atoi (ArgN (4))); /* borderwidth */
	ArgNReturn (True);

    case VaCreateManagedWidget:
    case VaCreatePopupShell:
    case VaCreateWidget:
    {
	XrmQuark resource_quark;
	XrmValue from_value, to_value;
	WidgetRec widget_rec;
	Widget this;
	int not_initialized = True;
	static XtentXtTypedArg *tvar_args = (XtentXtTypedArg *) NULL;
	static int tvar_args_length = 0;

	item = XtentStringToQuarkItem (ArgN (-1), False);
	if (item -> application_type != (int) XtentWidgetClassNamesType)
	{
	    fprintf (stderr,
		     "%s: Requested widget class not found: %s.\n",
		     XtentProgramName (), ArgN (-1));
	    ArgNReturn (True);
	}
	wcn = (XtentWidgetClassName *) item -> application_ptr;
	i = 0;
	arg_count = 1;
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0')
		break;
	    val_ptr = ArgN (arg_count++);

	    if (i >= tvar_args_length)
	    {
		tvar_args_length += XTENTMAXARGS;
		tvar_args = (XtentXtTypedArg *) XtRealloc ((char *) tvar_args, 
				(Cardinal) sizeof (XtentXtTypedArg) *
					  tvar_args_length);
	    }

	    tvar_args[i].name = (String) arg_ptr;
	    tvar_args[i].type = XtRString;
	    tvar_args[i].value = (XtArgVal) val_ptr;
	    tvar_args[i].size = strlen (val_ptr) + 1;
	    i++;
	}
	if (i >= tvar_args_length)
	{
	    tvar_args_length += XTENTMAXARGS;
	    tvar_args = (XtentXtTypedArg *) XtRealloc ((char *) tvar_args, 
				   (Cardinal) sizeof (XtentXtTypedArg) *
					   tvar_args_length);
	}
	tvar_args[i].name = NULL;

	operation--;
	mark = *operation;
	*operation = '\0';
	if (op -> type == VaCreateManagedWidget)
	    XtVaCreateManagedWidget (element, *wcn -> class, w,
				     XtVaNestedList, (XtArgVal) tvar_args,
				     NULL);
	else if (op -> type == VaCreateWidget)
	    XtVaCreateWidget (element, *wcn -> class, w,
			      XtVaNestedList, (XtArgVal) tvar_args, NULL);
	else
	    XtVaCreatePopupShell (element, *wcn -> class, w,
				  XtVaNestedList, (XtArgVal) tvar_args, NULL);
	*operation = mark;

	ArgNReturn (True);
    }
#ifdef OLD_XTVACREATE
    {
	XrmQuark resource_quark;
	XrmValue from_value, to_value;
	WidgetRec widget_rec;
	Widget this;
	int not_initialized = True;

	item = XtentStringToQuarkItem (ArgN (-1), False);
	if (item -> application_type != (int) XtentWidgetClassNamesType)
	{
	    fprintf (stderr,
		     "%s: Requested widget class not found: %s.\n",
		     XtentProgramName (), ArgN (-1));
	    ArgNReturn (True);
	}
	wcn = (XtentWidgetClassName *) item -> application_ptr;
	i = 0;
	arg_count = 1;
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0')
		break;
	    val_ptr = ArgN (arg_count++);

	    if (i >= arg_max_count)
	    {
		arg_max_count += XTENTMAXARGS;
		args = (Arg *) XtRealloc ((char *) args, 
				(Cardinal) sizeof (Arg) * arg_max_count);
	    }
	    resource_quark = ResourceToResourceType (w,
						     *wcn -> class,
						     *wcn -> class,
						  XrmStringToQuark (arg_ptr));

	    if (resource_quark == XtQString ||
		resource_quark == (XrmQuark) NULL)
	    {
		XtSetArg (args[i], arg_ptr, val_ptr);
		i++;
	    }
	    else
	    {
		if (not_initialized)
		{
		    memset (&widget_rec, '\0', sizeof (widget_rec));
		    widget_rec.core.self = &widget_rec;
		    widget_rec.core.widget_class = coreWidgetClass;
		    widget_rec.core.parent = w;
		    widget_rec.core.screen =
			(Screen *) DefaultScreenOfDisplay (display);
		    widget_rec.core.colormap = w -> core.colormap;

		    XtInitializeWidgetClass (coreWidgetClass);
		    this = &widget_rec;
		    not_initialized = False;
		}

		from_value.addr = val_ptr;
		from_value.size = strlen (val_ptr) + 1;
		to_value.size = 0;
		to_value.addr = (XtPointer) NULL;

		_XtConvert (this,
			    XtQString, &from_value,
			    resource_quark, &to_value, NULL);

		if (to_value.size && to_value.addr)
		{
		    if (to_value.size == sizeof (char))
		    {
			XtSetArg (args[i], arg_ptr,
				  *((char *) to_value.addr));
			i++;
		    }
		    else if (to_value.size == sizeof (short))
		    {
			XtSetArg (args[i], arg_ptr,
				  *((short *) to_value.addr));
			i++;
		    }
		    else if (to_value.size == sizeof (long))
		    {
			XtSetArg (args[i], arg_ptr,
				  *((long *) to_value.addr));
			i++;
		    }
		}
	    }
	}
    }
#endif /* OLD_XTVACREATE */
    case CreateManagedWidget:
    case CreatePopupShell:
    case CreateWidget:
	if (op -> type == CreateManagedWidget ||
	    op -> type == CreateWidget ||
	    op -> type == CreatePopupShell)
	{
	    i = 0;
	    item = XtentStringToQuarkItem (ArgN (-1), False);
	    if (item -> application_type != (int) XtentWidgetClassNamesType)
	    {
		fprintf (stderr,
			 "%s: Requested widget class not found: %s.\n",
			 XtentProgramName (), ArgN (-1));
		ArgNReturn (True);
	    }
	    wcn = (XtentWidgetClassName *) item -> application_ptr;

	    w = _xtentNameToWidget (display, toplevel_ptr,
				    buffer, element,
				    string_one, parse_quarks, parse_bindings,
				    field_count - 1);
	}
	operation--;
	mark = *operation;
	*operation = '\0';
	if (op -> type == CreateManagedWidget ||
	    op -> type == VaCreateManagedWidget)
	    XtCreateManagedWidget (element, *wcn -> class, w, args, i);
	else
	    if (op -> type == CreateWidget ||
		op -> type == VaCreateWidget)
		XtCreateWidget (element, *wcn -> class, w, args, i);
	    else
		XtCreatePopupShell (element, *wcn -> class, w, args, i);
	*operation = mark;
	ArgNReturn (True);

    case DestroyWidget:
    {
	XtentShellRecord * shell_ptr, * shell_ptr_prev;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks,
				parse_bindings,
				field_count * -1);
	XtDestroyWidget (w);

	shell_ptr_prev = (XtentShellRecord *) NULL;
	for (shell_ptr = XtentShells; shell_ptr; shell_ptr = shell_ptr -> next)
	{
	    if (w == shell_ptr -> w)
	    {
		if (shell_ptr_prev)
		    shell_ptr_prev -> next = shell_ptr -> next;
		else
		    XtentShells = shell_ptr -> next;

		XtFree ((char *) shell_ptr);
		break;
	    }
	    shell_ptr_prev = shell_ptr;

	}
	ArgNReturn (True);
    }

    case DisownSelection:
    {
	Atom atom;
	SelectionLine *s, *s_prev;
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	atom = XtentStringToAtom (display, ArgN (-1));

	s = SelectionLines;
	s_prev = (SelectionLine *) NULL;
	while (s)
	{
	    if (s -> widget == w && s -> selection == atom)
		break;
	    s_prev = s;
	    s = s -> next;
	}
	if (s)
	{
	    if (s_prev)
		s_prev -> next = s -> next;
	    else
		SelectionLines = s -> next;

	    XtFree ((char *) s -> malloc_return);
	    XtFree ((char *) s);
	}
	val_ptr = ArgN (1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XtDisownSelection (w, atom, timestamp);

	ArgNReturn (True);
    }

    case GetMultiClickTime:
	sprintf (copy_buffer, "%d",
		 XtGetMultiClickTime (XtDisplay (XtentToplevel
						 (display, toplevel_ptr))));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

    case GetSelectionValue:
    case _GetSelectionValue:
    {
	XrmValue from_value, to_value;
	Atom atom;
	Time time_stamp;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	atom = XtentStringToAtom (display, ArgN (0));
	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data,
				    1, op -> type == GetSelectionValue);
	arg_ptr = (char *) XtMalloc (strlen (val_ptr) + 1);
	strcpy (arg_ptr, val_ptr);

	val_ptr = ArgN (2);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    time_stamp = XtLastTimestampProcessed (display);
	else
	    time_stamp = (Time) atol (val_ptr);

	XtGetSelectionValue (w, atom, XA_STRING,
			     XtentGetSelectionProc, arg_ptr,
			     time_stamp);
	ArgNReturn (True);
    }

    case GetValue:
	operation--;
	mark = *operation;
	*operation = '\0';
	element = XtentGetValue (display, toplevel_ptr, buffer, (char *) NULL);
	*operation = mark;
	if (element == (char *) NULL)
	{
	    XrmPutLineResource (&db, frame_data.buffer);
	    ArgNReturn (False);
	}
	XtentPutStringReturn (&db, ArgN (-1), element);
	ArgNReturn (True);

    case GetValues:
	i = 0;
	if (operation != buffer)
	    operation--;
	mark = *operation;
	for (;;)
	{
	    arg_ptr = ArgN (i++);
	    if (*arg_ptr == '\0')
		break;
	    val_ptr = ArgN (i++);
	    if (*val_ptr == '\0')
		break;
	    *operation = '\0';
	    element = XtentGetValue (display, toplevel_ptr, buffer, arg_ptr);
	    *operation = mark;
	    if (element == (char *) NULL)
		continue;
	    XtentXrmPutStringResource (&db, val_ptr, element, 30);
	}
	ArgNReturn (True);

    case GetValueWithType:
    {
	XrmQuark resource_quark;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	resource_quark = XrmStringToQuark (ArgN (0));
	operation--;
	mark = *operation;
	*operation = '\0';
	arg_ptr = XtentQuarkGetValue (w, resource_quark, element);
	*operation = mark;
	if (arg_ptr == (char *) NULL)
	{
	    XrmPutLineResource (&db, frame_data.buffer);
	    ArgNReturn (False);
	}
	XtentPutStringReturn (&db, ArgN (1), arg_ptr);
	ArgNReturn (True);
    }

    case GrabButton:
    {
	Cursor cursor;
	Window window;
	XrmValue from_value, to_value;

	/*
	 * confine to widget
	 */
	arg_ptr = ArgN (6);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	{
	    w = XtentToplevel (display, toplevel_ptr);
	    window = (Window) None;
	}
	else
	{
	    w = XtentNameToWidget (arg_ptr);
	    window = XtWindow (w);
	}

	/*
	 * cursor
	 */
	arg_ptr = ArgN (7);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	    cursor = (Cursor) None;
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen ((char *) from_value.addr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value, XtQCursor, &to_value, NULL);
	    if (to_value.size == sizeof (Cursor) && to_value.addr)
		cursor = *((Cursor *) to_value.addr);
	    else
		cursor = (Cursor) None;
	}

	XtGrabButton (_xtentNameToWidget (display,
					  toplevel_ptr,
					  buffer, operation,
					  string_one, parse_quarks,
					  parse_bindings, field_count),
		      atoi (ArgN (0)),	/* button */
		      atol (ArgN (1)),	/* modifiers */
		      /* owner_events */
		      XtentTestTrue (ArgN (2)),
		      atol (ArgN (3)),	/* event_mask */
		      atoi (ArgN (4)),	/* pointer mode */
		      atoi (ArgN (5)),	/* keyboard mode */
		      window, cursor);
	ArgNReturn (True);
    }

    case GrabKey:
	XtGrabKey (_xtentNameToWidget (display,
				       toplevel_ptr,
				       buffer, operation,
				       string_one, parse_quarks,
				       parse_bindings,
				       field_count),
		   atol (ArgN (0)),	/* keycode */
		   atol (ArgN (1)),	/* modifiers */
		   /* owner_events */
		   XtentTestTrue (ArgN (2)),
		   atoi (ArgN (3)),	/* pointer mode */
		   atoi (ArgN (4)));	/* keyboard mode */
	ArgNReturn (True);

    case GrabKeyboard:
	XtGrabKeyboard (_xtentNameToWidget (display,
					    toplevel_ptr,
					    buffer, operation,
					    string_one, parse_quarks,
					    parse_bindings,
					    field_count),
			/* owner_events */
			XtentTestTrue (ArgN (0)),
			atoi (ArgN (1)),	/* pointer mode */
			atoi (ArgN (2)),	/* keyboard mode */
			atol (ArgN (3)));	/* Time */
	ArgNReturn (True);

    case GrabPointer:
    {
	Cursor cursor;
	Window window;
	XrmValue from_value, to_value;

	/*
	 * confine to widget
	 */
	arg_ptr = ArgN (4);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	{
	    w = XtentToplevel (display, toplevel_ptr);
	    window = (Window) None;
	}
	else
	{
	    w = XtentNameToWidget (arg_ptr);
	    window = XtWindow (w);
	}

	/*
	 * cursor
	 */
	arg_ptr = ArgN (5);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	    cursor = (Cursor) None;
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen ((char *) from_value.addr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value, XtQCursor,
			&to_value, NULL);
	    if (to_value.size == sizeof (Cursor) && to_value.addr)
		cursor = *((Cursor *) to_value.addr);
	    else
		cursor = (Cursor) None;
	}

	XtGrabPointer (_xtentNameToWidget (display,
					   toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count),
		       /* owner_events */
		       XtentTestTrue (ArgN (0)),
		       atol (ArgN (1)),	/* event_mask */
		       atoi (ArgN (2)),	/* pointer mode */
		       atoi (ArgN (3)),	/* keyboard mode */
		       window, cursor,
		       atol (ArgN (6)));	/* Time */
	ArgNReturn (True);
    }

    case HasCallbacks:
    {
	XtCallbackStatus status;

	operation--;
	mark = *operation;
	*operation = '\0';
	status = XtHasCallbacks (_xtentNameToWidget (display,
						     toplevel_ptr,
						     buffer, element,
						     string_one, parse_quarks,
						     parse_bindings,
						     field_count - 1),
				 element);
	*operation = mark;
	switch (status)
	{
	case XtCallbackNoList:
	    element = "NoList";
	    break;
	case XtCallbackHasNone:
	    element = "HasNone";
	    break;
	case XtCallbackHasSome:
	    element = "HasSome";
	    break;
	}
	XtentPutStringReturn (&db, ArgN (-1), element);
	ArgNReturn (True);
    }

    case Initialize:
	XtentToplevel (display, toplevel_ptr);
	ArgNReturn (True);

    case InstallAccelerators:
	arg_ptr = ArgN (-1);
	XtInstallAccelerators (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer, operation,
						   string_one, parse_quarks,
						   parse_bindings,
						   field_count),
			       XtentNameToWidget (arg_ptr));
	ArgNReturn (True);

    case InstallAllAccelerators:
	arg_ptr = ArgN (-1);
	XtInstallAllAccelerators (_xtentNameToWidget (display,
						      toplevel_ptr,
						      buffer,
						      operation,
						      string_one, parse_quarks,
						      parse_bindings,
						      field_count),
				  XtentNameToWidget (arg_ptr));
	ArgNReturn (True);

    case IsComposite:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      XtIsComposite (w) ? "True" : "False");
	ArgNReturn (True);

    case IsManaged:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      XtIsManaged (w) ? "True" : "False");
	ArgNReturn (True);

    case IsRealized:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      XtIsRealized (w) ? "True" : "False");
	ArgNReturn (True);

    case LastTimestampProcessed:
	sprintf (copy_buffer, "%d", (long) XtLastTimestampProcessed (display));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

    case ManageChild:
	XtManageChild (_xtentNameToWidget (display, toplevel_ptr, buffer,
					   operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count));
	ArgNReturn (True);

    case ManageChildren:
    {
	Cardinal card;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], ArgN (0), &element);
	XtSetArg (args[1], ArgN (1), &card);
	XtGetValues (w, args, 2);
	if (card <= 0 || element == NULL)
	    ArgNReturn (True);
	XtManageChildren ((WidgetList) element, card);
	ArgNReturn (True);
    }

    case MapWidget:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtMapWidget (w);
	ArgNReturn (True);

    case MoveWidget:
	XtMoveWidget (_xtentNameToWidget (display, toplevel_ptr, buffer,
					  operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count),
		      (Position) atoi (ArgN (0)),
		      (Position) atoi (ArgN (1)));
	ArgNReturn (True);

    case OverrideTranslations:
    case _OverrideTranslations:
    {
	XtTranslations trans;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    op -> type == OverrideTranslations);
	trans = XtentParseTranslationTable (val_ptr);
	XtOverrideTranslations (_xtentNameToWidget (display,
						    toplevel_ptr,
						    buffer,
						    operation,
						    string_one, parse_quarks,
						    parse_bindings,
						    field_count),
				trans);
	ArgNReturn (True);
    }

    case OwnSelection:		/* (atom, convert, lose, done) */
    case _OwnSelection:
    {
	Atom atom;
	SelectionLine *s;
	char *atom_name = ArgN (0);
	int atom_name_length = strlen (atom_name) + 1;
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	atom = XtentStringToAtom (display, atom_name);

	arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    op -> type == OwnSelection);
	arg_count = strlen (arg_ptr) + 1;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				    op -> type == OwnSelection);
	i = strlen (val_ptr) + 1;

	element = XtentProcessArgN (display, toplevel_ptr, &frame_data, 3,
				    op -> type == OwnSelection);
	j = strlen (element) + 1;

	s = (SelectionLine *) XtMalloc (sizeof (SelectionLine) +
					arg_count + i + j + atom_name_length);
	s -> widget = w;
	s -> selection = atom;
	s -> malloc_return = (XtPointer) NULL;

	if (arg_count <= 1)
	    *s -> convert_code = '\0';
	else
	    memcpy (s -> convert_code, arg_ptr, arg_count);

	s -> lose_code = s -> convert_code + arg_count;
	if (i <= 1)
	    *s -> lose_code = '\0';
	else
	    memcpy (s -> lose_code, val_ptr, i);

	s -> done_code = s -> lose_code + i;
	if (j <= 1)
	    *s -> done_code = '\0';
	else
	    memcpy (s -> done_code, element, j);

	s -> selection_atom_string = s -> done_code + j;
	if (atom_name_length <= 1)
	    *s -> selection_atom_string = '\0';
	else
	    memcpy (s -> selection_atom_string, atom_name, atom_name_length);

	s -> transaction_state_code = (char *) NULL;

	s -> next = SelectionLines;
	SelectionLines = s;

	val_ptr = ArgN (4);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XtOwnSelection (w, atom, timestamp,
			XtentConvertSelectionProc, XtentLoseSelectionProc,
			XtentDoneSelectionProc);

	ArgNReturn (True);
    }

    case Parent:
	w = XtParent (_xtentNameToWidget (display, toplevel_ptr, buffer,
					  operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count));

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);

    case Popdown:
	XtPopdown (_xtentNameToWidget (display, toplevel_ptr, buffer,
				       operation,
				       string_one, parse_quarks,
				       parse_bindings,
				       field_count));
	ArgNReturn (True);

    case Popup:
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0' ||
	    (strcmp (arg_ptr, "XtGrabNone") == 0))
	    XtPopup (_xtentNameToWidget (display, toplevel_ptr,
					 buffer, operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count),
		     XtGrabNone);
	else if (strcmp (arg_ptr, "XtGrabExclusive") == 0)
	    XtPopup (_xtentNameToWidget (display, toplevel_ptr,
					 buffer, operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count),
		     XtGrabExclusive);
	else if (strcmp (arg_ptr, "XtGrabNonexclusive") == 0)
	    XtPopup (_xtentNameToWidget (display, toplevel_ptr,
					 buffer, operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count),
		     XtGrabNonexclusive);
	else
	    fprintf (stderr,
		     "%s: Unknown grab type given to XtPopup: %s.\n",
		     XtentProgramName (), arg_ptr);
	ArgNReturn (True);

    case PopupSpringLoaded:
	XtPopupSpringLoaded (_xtentNameToWidget (display, toplevel_ptr,
						 buffer, operation,
						 string_one, parse_quarks,
						 parse_bindings,
						 field_count));
	ArgNReturn (True);

    case RealizeWidget:
	XtRealizeWidget (_xtentNameToWidget (display, toplevel_ptr,
					     buffer, operation,
					     string_one, parse_quarks,
					     parse_bindings,
					     field_count));
	ArgNReturn (True);

    case RemoveAllCallbacks:
    {
	CallbackLine * cb, * cb_prev;
	CallbackWithArgItem * arg_item, * arg_next;
	int length;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	operation--;
	length = operation - element;
	for (cb_prev = NULL, cb = XtentCallbackLines; cb;)
	{
	    if (cb -> widget == w &&
		strncmp (cb -> callback_name, element, length) == 0)
	    {
		/*
		 * remove the callback
		 */
		if (cb_prev)
		    cb_prev -> next = cb -> next;
		else
		    XtentCallbackLines = cb -> next;

		arg_item = cb -> arg_list;
		while (arg_item)
		{
		    arg_next = arg_item -> next;
		    XtFree ((char *) arg_item);
		    arg_item = arg_next;
		}
		XtFree ((char *) cb);

		if (cb_prev)
		    cb = cb_prev -> next;
		else
		    cb = XtentCallbackLines;
		continue;
	    }
	    cb_prev = cb;
	    cb = cb -> next;
	}
	mark = *operation;
	*operation = '\0';
	XtRemoveAllCallbacks (w, element);
	*operation = mark;
	ArgNReturn (True);
    }

    case RemoveCallback:
#ifdef MOTIF
    case XMRemoveProtocolCallback:
    case XMRemoveWMProtocolCallback:
#endif /* MOTIF */
    {
	CallbackLine * cb, * cb_prev;
	CallbackWithArgItem * arg_item, * arg_next;
#ifdef MOTIF
	char *prop_str;

	if (op -> type == XMRemoveProtocolCallback)
	{
	    prop_str = ArgN (0);
	    val_ptr = XtentProcessArgN (display, toplevel_ptr,
					&frame_data, 1, False);
	}
	else
#endif /* MOTIF */
	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	
	for (cb_prev = NULL, cb = XtentCallbackLines; cb;
	     cb_prev = cb, cb = cb -> next)
	{
	    if (cb -> widget == w && strncmp (cb -> callback_name, element,
					      (operation - 1) - element) == 0)
	    {
		/*
		 * verify that the parameters match
		 */
		if (strcmp (cb -> code,
			    (cb -> expanded ? arg_ptr : val_ptr)) != 0)
		    continue;

#ifdef MOTIF
		if (op -> type == XMRemoveProtocolCallback &&
		    (cb -> arg_list == NULL ||
		     strcmp (cb -> arg_list -> arg, prop_str)))
		    continue;
#endif /* MOTIF */
		if (cb -> arg_list)
		{
		    arg_item = cb -> arg_list;
		    arg_count = 1;
		    while (arg_item)
		    {
			if (strcmp (ArgN (arg_count), arg_item -> arg) != 0)
			    break;
			arg_item = arg_item -> next;
			arg_count++;
		    }
		    if (arg_item)
			continue;
		    ArgN (arg_count);
		    if (frame_data.end_of_line == False)
			continue;
		}
		/*
		 * remove the callback
		 */
	if (op -> type == RemoveCallback)
		XtRemoveCallback (w, cb -> callback_name,
				  (XtCallbackProc) ((cb -> arg_list) ?
				   XtentCallbackWithArgsProc : 
				   XtentCallbackProc),
				  (XtPointer) cb);
#ifdef MOTIF
	else if (op -> type == XMRemoveProtocolCallback)
	XmRemoveProtocolCallback (w, XtentStringToAtom (display, prop_str),
				  XtentStringToAtom (display, cb -> callback_name),
				  (XtCallbackProc) XtentCallbackProc,
				  (XtPointer) cb);
	else if (op -> type == XMRemoveWMProtocolCallback)
	XmRemoveWMProtocolCallback (w, XtentStringToAtom (display, cb -> callback_name),
				  (XtCallbackProc) XtentCallbackProc,
				  (XtPointer) cb);
#endif /* MOTIF */
		if (cb_prev)
		    cb_prev -> next = cb -> next;
		else
		    XtentCallbackLines = cb -> next;

		arg_item = cb -> arg_list;
		while (arg_item)
		{
		    arg_next = arg_item -> next;
		    XtFree ((char *) arg_item);
		    arg_item = arg_next;
		}
		XtFree ((char *) cb);
		break;
	    }
	}

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case RemoveEventHandler:
    case RemoveRawEventHandler:
    {
	EventHandlerLine *eh, *eh_prev;
	EventMask event_mask = atol (ArgN (0));
	Boolean nonmaskable = XtentTestTrue (ArgN (1));

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				    False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	for (eh_prev = NULL, eh = XtentEventHandlerLines; eh;
	     eh_prev = eh, eh = eh -> next)
	{
	    if (eh -> widget == w &&
		eh -> event_mask == event_mask &&
		eh -> nonmaskable == nonmaskable &&
		(strcmp (eh -> code,
			 (eh -> expanded ? arg_ptr : val_ptr)) == 0))
	    {
		if (op -> type == RemoveEventHandler)
		    XtRemoveEventHandler (w, eh -> event_mask,
					  eh -> nonmaskable,
					  XtentEventHandlerProc, eh);
		else
		    XtRemoveRawEventHandler (w, eh -> event_mask,
					     eh -> nonmaskable,
					     XtentEventHandlerProc, eh);
		if (eh_prev)
		    eh_prev -> next = eh -> next;
		else
		    XtentEventHandlerLines = eh -> next;

		XtFree ((char *) eh);
		break;
	    }
	}

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case RemoveGrab:
	XtRemoveGrab (_xtentNameToWidget (display, toplevel_ptr, buffer,
					  operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count));
	ArgNReturn (True);

    case RemoveInput:
    {
	InputLine * input, * input_prev;

	element = ArgN (-1);
	if (*element == '\0')
	    ArgNReturn (True);
	for (input_prev = NULL, input = XtentInputLines; input;
	     input_prev = input, input = input -> next)
	{
	    if (strcmp (input -> file, element) == 0)
	    {
		XtRemoveInput (input -> id);
		fclose (input -> fp);
		if (input_prev)
		    input_prev -> next = input -> next;
		else
		    XtentInputLines = input -> next;
		XtFree ((char *) input);
		break;
	    }
	}
	ArgNReturn (True);
    }

    case RemoveTimeOut:
    {
	TimeoutLine * timeout, *timeout_prev;
	long interval = atol (ArgN (0));

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	for (timeout_prev = NULL, timeout = XtentTimeoutLines; timeout;
	     timeout_prev = timeout, timeout = timeout -> next)
	{
	    if (timeout -> interval == interval &&
		strcmp (timeout -> code,
			(timeout -> expanded ? arg_ptr : val_ptr)) == 0)
	    {
		XtRemoveTimeOut (timeout -> id);
		if (timeout_prev)
		    timeout_prev -> next = timeout -> next;
		else
		    XtentTimeoutLines = timeout -> next;
		XtFree ((char *) timeout);
		break;
	    }
	}

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case RemoveWorkProc:
    {
	WorkProcLine * workproc, * workproc_prev;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	for (workproc_prev = NULL, workproc = XtentWorkProcLines; workproc;
	     workproc_prev = workproc, workproc = workproc -> next)
	{
	    if (strcmp (workproc -> code,
			(workproc -> expanded ? arg_ptr : val_ptr)) == 0)
	    {
		XtRemoveWorkProc (workproc -> id);
		if (workproc_prev)
		    workproc_prev -> next = workproc -> next;
		else
		    XtentWorkProcLines = workproc -> next;
		XtFree ((char *) workproc);
		break;
	    }
	}

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case ReplaceTranslations:
    case _ReplaceTranslations:
    {
	XtTranslations trans;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    op -> type == ReplaceTranslations);
	trans = XtentParseTranslationTable (val_ptr);
	XtSetArg (args[0], XtNtranslations, trans);
	XtSetValues (_xtentNameToWidget (display, toplevel_ptr, buffer,
					 operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count), args, 1);
	ArgNReturn (True);
    }

    case ResizeWidget:
	XtResizeWidget (_xtentNameToWidget (display, toplevel_ptr,
					    buffer, operation,
					    string_one, parse_quarks,
					    parse_bindings,
					    field_count),
			   atoi (ArgN (0)), /* width */
			   atoi (ArgN (1)), /* height */
			   atoi (ArgN (2))); /* borderwidth */
	ArgNReturn (True);

    case SetKeyboardFocus:
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	{
	    XtSetKeyboardFocus (_xtentNameToWidget (display,
						    toplevel_ptr,
						    buffer,
						    operation,
						    string_one, parse_quarks,
						    parse_bindings,
						    field_count),
				(Widget) None);
	}
	else
	{
	    XtSetKeyboardFocus (_xtentNameToWidget (display,
						    toplevel_ptr,
						    buffer,
						    operation,
						    string_one, parse_quarks,
						    parse_bindings,
						    field_count),
				XtentNameToWidget (arg_ptr));
	}
	ArgNReturn (True);

    case SetMappedWhenManaged:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetMappedWhenManaged (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);
	
    case SetMultiClickTime:
	XtSetMultiClickTime (XtDisplay (XtentToplevel (display, toplevel_ptr)),
			     atoi (ArgN (-1)));
	ArgNReturn (True);

    case SetSensitive:
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetSensitive (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case SetValue:
    case SetValueWithType:
    {
	XrmQuark resource_quark;
	XrmValue from_value, to_value;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				string_one, parse_quarks, parse_bindings,
				field_count - 1);
	operation--;
	mark = *operation;
	*operation = '\0';
	if (op -> type == SetValue)
	{
	    resource_quark = ResourceToResourceType (XtParent (w),
						     XtClass (w),
						     XtClass (w),
						   XrmStringToQuark (element));
	    arg_ptr = ArgN (-1);
	}
	else
	{
	    resource_quark = XrmStringToQuark (ArgN (0));
	    arg_ptr = ArgN (1);
	}

	if (resource_quark == XtQString ||
	    resource_quark == (XrmQuark) NULL)
	{
	    XtSetArg (args[0], element, arg_ptr);
	    XtSetValues (w, args, 1);
	}
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen ((char *) from_value.addr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value,
			resource_quark, &to_value, NULL);
	    if (to_value.size && to_value.addr)
	    {
		if (to_value.size == sizeof (char))
		    XtSetArg (args[0], element, *((char *) to_value.addr));
		else if (to_value.size == sizeof (short))
		    XtSetArg (args[0], element, *((short *) to_value.addr));
		else if (to_value.size == sizeof (long))
		    XtSetArg (args[0], element, *((long *) to_value.addr));
		XtSetValues (w, args, 1);
	    }
	}
	*operation = mark;
	ArgNReturn (True);
    }

    case SetValues:
    {
	XrmQuark resource_quark;
	XrmValue from_value, to_value;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	i = 0;
	arg_count = 0;
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0')
		break;
	    val_ptr = ArgN (arg_count++);

	    if (i >= arg_max_count)
	    {
		arg_max_count += XTENTMAXARGS;
		args = (Arg *) XtRealloc ((char *) args, 
				(Cardinal) sizeof (Arg) * arg_max_count);
	    }

	    resource_quark = ResourceToResourceType (XtParent (w),
						     XtClass (w),
						     XtClass (w),
						   XrmStringToQuark (arg_ptr));

	    if (resource_quark == XtQString ||
		resource_quark == (XrmQuark) NULL)
	    {
		XtSetArg (args[i], arg_ptr, val_ptr);
		i++;
	    }
	    else
	    {
		from_value.addr = val_ptr;
		from_value.size = strlen (val_ptr) + 1;
		to_value.size = 0;
		to_value.addr = (XtPointer) NULL;

		_XtConvert (w, XtQString, &from_value,
			    resource_quark, &to_value, NULL);
		if (to_value.size && to_value.addr)
		{
		    if (to_value.size == sizeof (char))
		    {
			XtSetArg (args[i], arg_ptr, *((char *) to_value.addr));
			i++;
		    }
		    else if (to_value.size == sizeof (short))
		    {
			XtSetArg (args[i], arg_ptr, *((short *) to_value.addr));
			i++;
		    }
		    else if (to_value.size == sizeof (long))
		    {
			XtSetArg (args[i], arg_ptr, *((long *) to_value.addr));
			i++;
		    }
		}
	    }
	}
	if (i > 0)
	    XtSetValues (w, args, i);
	ArgNReturn (True);
    }

    case Sync:
	XSync (display, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case TranslateCoords:
    {
	Position x, y;

	XtTranslateCoords (_xtentNameToWidget (display,
					       toplevel_ptr,
					       buffer,
					       operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count),
			   (Position) atoi (ArgN (0)),
			   (Position) atoi (ArgN (1)),
			   &x, &y);

	sprintf (copy_buffer, "%d", (int) x);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	sprintf (copy_buffer, "%d", (int) y);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	ArgNReturn (True);
    }

    case UngrabButton:
	XtUngrabButton (_xtentNameToWidget (display,
					    toplevel_ptr,
					    buffer, operation,
					    string_one, parse_quarks,
					    parse_bindings,
					    field_count),
			atoi (ArgN (0)),	/* button */
			atol (ArgN (1)));	/* modifiers */
	ArgNReturn (True);

    case UngrabKey:
	XtUngrabKey (_xtentNameToWidget (display,
					 toplevel_ptr,
					 buffer, operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count),
		     atol (ArgN (0)),	/* keycode */
		     atol (ArgN (1)));	/* modifiers */
	ArgNReturn (True);

    case UngrabKeyboard:
	XtUngrabKeyboard (_xtentNameToWidget (display,
					      toplevel_ptr,
					      buffer, operation,
					      string_one, parse_quarks,
					      parse_bindings,
					      field_count),
			  /* owner_events */
			  atol (ArgN (-1)));	/* Time */
	ArgNReturn (True);

    case UngrabPointer:
	XtUngrabPointer (_xtentNameToWidget (display,
					     toplevel_ptr,
					     buffer, operation,
					     string_one, parse_quarks,
					     parse_bindings,
					     field_count),
			 atol (ArgN (-1)));	/* Time */
	ArgNReturn (True);

    case UninstallTranslations:
	XtUninstallTranslations (_xtentNameToWidget (display,
						     toplevel_ptr,
						     buffer,
						     operation,
						     string_one, parse_quarks,
						     parse_bindings,
						     field_count));
	ArgNReturn (True);

    case UnmanageChild:
	XtUnmanageChild (_xtentNameToWidget (display, toplevel_ptr,
					     buffer, operation,
					     string_one, parse_quarks,
					     parse_bindings,
					     field_count));
	ArgNReturn (True);

    case UnmanageChildren:
    {
	Cardinal card;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], ArgN (0), &element);
	XtSetArg (args[1], ArgN (1), &card);
	XtGetValues (w, args, 2);
	if (card <= 0 || element == NULL)
	    ArgNReturn (True);
	XtUnmanageChildren ((WidgetList) element, card);
	ArgNReturn (True);
    }

    case UnmapWidget:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtUnmapWidget (w);
	ArgNReturn (True);

    case UnrealizeWidget:
	XtUnrealizeWidget (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count));
	ArgNReturn (True);

    case WINdow:
    {
	Window window;

	window = XtWindow (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count));
	sprintf (copy_buffer, "%d", window);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);
    }

    case WindowToWidget:
	w = XtWindowToWidget (display, atoi (ArgN (0)));

	XtentPutStringReturn (&db, ArgN (1),
			      ((w) ? XtentWidgetToName (w) : "None"));

	ArgNReturn (True);


    case AddCFunction:
    case AddFunction:
    case AddThisFunction:
    {
	XtentFunctionRecordArgs * argument_ptr;
	XtentFunctionRecordArgs * prev;
	XtentFunctionRecord * record;

	arg_ptr = ArgN (0);		/* Xt<name> */
	val_ptr = ArgN (1);		/* resource name or function pointer */
	arg_count = strlen (arg_ptr) + 1;
	if (op -> type == AddCFunction)
	    j = 0;
	else
	    j = strlen (val_ptr) + 1;

	/*
	 * The line prefix - '.' is equivalent to xtent_program_name
	 */
	if (op -> type != AddCFunction && *val_ptr == '.')
	    j += XtentProgramNameLength ();
	i = sizeof (XtentFunctionRecord) + arg_count + j;

	item = XtentStringToQuarkItem (XtNewString (arg_ptr), True);

	if (op -> type == AddCFunction)
	    item -> application_type = (int) XtentApplicationCFunctionType;
	else if (op -> type == AddFunction)
	    item -> application_type = (int) XtentApplicationFunctionType;
	else
	    item -> application_type = (int) XtentApplicationThisFunctionType;

	element = (char *) XtMalloc (i);
	item -> application_ptr = (XtPointer) element;

	record = (XtentFunctionRecord *) element;
	element += sizeof (XtentFunctionRecord);
	record -> function_name = element;
	memcpy (element, arg_ptr, arg_count);

	if (op -> type == AddCFunction)
	    record -> C_function = (CFuncPtr) atol (val_ptr); /* RAD */
	else
	{
	    element += arg_count;
	    record -> resource_name = element;
	    if (*val_ptr == '.')
		sprintf (element, "%s%s", XtentProgramName (), val_ptr);
	    else
		memcpy (element, val_ptr, j);
	}

	record -> argument_list = (XtentFunctionRecordArgs *) NULL;

	i = 2;
	prev = (XtentFunctionRecordArgs *) NULL;
	for (;;)
	{
	    arg_ptr = ArgN (i++);
	    if (*arg_ptr == '\0')
		break;
	    argument_ptr = (XtentFunctionRecordArgs *)
		XtMalloc (sizeof (XtentFunctionRecordArgs) +
			  strlen (arg_ptr) + 1);
	    strcpy (argument_ptr -> argument_name, arg_ptr);

	    argument_ptr -> next = (XtentFunctionRecordArgs *) NULL;

	    if (prev)
		prev -> next = argument_ptr;
	    else
		record -> argument_list = argument_ptr;

	    prev = argument_ptr;
	}
	record -> argument_count = i - 3;

	ArgNReturn (True);
    }

    case AllocColor:
	i = XtentAllocColor (display, ArgN (0), ArgN (1));
	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case Argc:
	sprintf (copy_buffer, "%d", XtentArgc ());
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

    case Argv:
	XtentPutStringReturn (&db, ArgN (1),
			      XtentArgv (atoi (ArgN (0))));
	ArgNReturn (True);

    case Bell:
	XBell (display, atoi (ArgN (-1)));
	XSync (display, False);
	ArgNReturn (True);

    case Case:
    case _Case:
	arg_ptr = ArgN (0);

	j = (op -> type == Case);
	for (i = 1; True; i += 2)
	{
	    val_ptr = ArgN (i);
	    if (*val_ptr == '\0' && frame_data.end_of_line)
		ArgNReturn (True);

	    if (strcmp (arg_ptr, val_ptr) == 0 ||
		strcmp ("CaseDefault", val_ptr) == 0)
	    {
		XtentEvalResourceLine (display, toplevel_ptr,
				       XtentProcessArgN (display, toplevel_ptr,
							 &frame_data, i + 1,
							 j));
		ArgNReturn (True);
	    }
	}

    case ConvertCtoResources:	/* (C pointer, C data type, resource prefix */
	XtentConvertCtoResources (XtentToplevel (display, toplevel_ptr),
				  (XtPointer) atol (ArgN (0)),
				  XtentNamedResourceLists,
				  ArgN (1), ArgN (2));
	ArgNReturn (True);

    case CopyFunction:
    {
	XtentFunctionRecord * record;
	XtentFunctionRecord * record2;
	XtentFunctionRecordArgs * argument_ptr;
	XtentFunctionRecordArgs * argument_ptr2;
	XtentFunctionRecordArgs * prev;
	int type;

	arg_ptr = ArgN (0);	/* old name */
	val_ptr = ArgN (1);	/* new name */
	item = XtentStringToQuarkItem (arg_ptr, False);
	if (item -> application_type ==
	    (int) XtentOperationsType)
	{
	    element = (char *) XtMalloc (sizeof (Operation) +
					 strlen (val_ptr) + 1);
	    op = (Operation *) element;
	    element += sizeof (Operation);
	    op -> string = element;
	    strcpy (op -> string, val_ptr);
	    op -> type = ((Operation *) item -> application_ptr) -> type;
	    item = XtentStringToQuarkItem (XtNewString (val_ptr), True);
	    item -> application_ptr = (XtPointer) op;
	    item -> application_type = (int) XtentOperationsType;
	    ArgNReturn (True);
	}
	else
	if (item -> application_type != (int) XtentApplicationCFunctionType &&
	    item -> application_type != (int) XtentApplicationFunctionType &&
	    item -> application_type != (int) XtentApplicationThisFunctionType)
	{
	    fprintf (stderr,
		     "%s: Cannot find operation for XtCopyFunction: %s\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	record = (XtentFunctionRecord *) item -> application_ptr;

	arg_count = strlen (val_ptr) + 1;
	if (item -> application_type == (int) XtentApplicationCFunctionType)
	    j = 0;
	else
	    j = strlen (record -> resource_name) + 1;

	i = sizeof (XtentFunctionRecord) + arg_count + j;
	type = item -> application_type;

	item = XtentStringToQuarkItem (XtNewString (val_ptr), True);
	item -> application_type = type;

	element = (char *) XtMalloc (i);
	item -> application_ptr = (XtPointer) element;

	record2 = (XtentFunctionRecord *) element;
	element += sizeof (XtentFunctionRecord);
	record2 -> function_name = element;
	memcpy (element, val_ptr, arg_count);

	if (item -> application_type == (int) XtentApplicationCFunctionType)
	    record2 -> C_function = record -> C_function;
	else
	{
	    element += arg_count;
	    record2 -> resource_name = element;
	    memcpy (element, record -> resource_name, j);
	}

	record2 -> argument_list = (XtentFunctionRecordArgs *) NULL;
	argument_ptr = record -> argument_list;
	argument_ptr2 = (XtentFunctionRecordArgs *) NULL;
	prev = (XtentFunctionRecordArgs *) NULL;
	while (argument_ptr)
	{
	    argument_ptr2 = (XtentFunctionRecordArgs *)
		XtMalloc (sizeof (XtentFunctionRecordArgs) +
			  strlen (argument_ptr -> argument_name) + 1);
	    strcpy (argument_ptr2 -> argument_name,
		    argument_ptr -> argument_name);

	    argument_ptr2 -> next = (XtentFunctionRecordArgs *) NULL;

	    if (prev)
		prev -> next = argument_ptr2;
	    else
		record2 -> argument_list = argument_ptr2;

	    prev = argument_ptr2;

	    argument_ptr = argument_ptr -> next;
	}

	ArgNReturn (True);
    }

    case CreateColormap:
	XtentCreateColormap (display, ArgN (-1));
	ArgNReturn (True);

    case CreateImageCursor:	/* (image_name, image_mask_name,
				 *  fg_color, bg_color, x, y)
				 */
	XtentCreateImageCursor (display, ArgN (0), ArgN (1), ArgN (2),
				ArgN (3), ArgN (4), ArgN (5));
	ArgNReturn (True);

    case CreateResourceList:/* (res-name,
			     *  name, class, type, size, offset, def,
			     *  ...)
			     */
    {
	XtentNamedResourceList *list;

	arg_ptr = ArgN (0);
	j = strlen (arg_ptr);
	list = (XtentNamedResourceList *)
	    XtMalloc (sizeof (XtentNamedResourceList) + j);
	memcpy (list -> list_name, arg_ptr, j + 1);
	list -> resources = (XtResource **) NULL;
	list -> count = 0;

	arg_count = 1;
	for (i = 0; True; i++)
	{
	    /*
	     * check for the end of the list
	     */
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		    break;
	    /*
	     * allocate the storage list
	     */
	    if (i >= list -> count)
	    {
		list -> count += 8;
		list -> resources =
		    (XtResource **) XtRealloc ((char *) list -> resources,
					       (Cardinal) list -> count *
					       sizeof (XtResource *));
	    }
	    list -> resources[i] =
		(XtResource *) XtMalloc (sizeof (XtResource));
	    /*
	     * name
	     */
	    list -> resources[i] -> resource_name = XtNewString (arg_ptr);
	    /*
	     * class
	     */
	    arg_ptr = ArgN (arg_count++);
	    list -> resources[i] -> resource_class = XtNewString (arg_ptr);
	    /*
	     * type
	     */
	    arg_ptr = ArgN (arg_count++);
	    list -> resources[i] -> resource_type = XtNewString (arg_ptr);
	    /*
	     * size
	     */
	    arg_ptr = ArgN (arg_count++);
	    list -> resources[i] -> resource_size = atoi (arg_ptr);
	    /*
	     * offset
	     */
	    arg_ptr = ArgN (arg_count++);
	    list -> resources[i] -> resource_offset = atoi (arg_ptr);
	    /*
	     * default
	     */
	    arg_ptr = ArgN (arg_count++);
	    list -> resources[i] -> default_addr = XtNewString (arg_ptr);
	    list -> resources[i] -> default_type = XtRString;
	}
	list -> count = i;
	list -> resources = (XtResource **) XtRealloc ((char *) list -> resources,
						       (Cardinal) list -> count *
						       sizeof (XtResource *));
	list -> next = XtentNamedResourceLists;
	XtentNamedResourceLists = list;
	ArgNReturn (True);
    }

    case DestroyResourceList:	/* res-name */
    {
	XtentNamedResourceList *list = XtentNamedResourceLists;
	XtentNamedResourceList *prev_list = (XtentNamedResourceList *) NULL;

	arg_ptr = ArgN (-1);
	while (list)
	{
	    if (strcmp (arg_ptr, list -> list_name))
	    {
		prev_list = list;
		list = list -> next;
		continue;
	    }
	    for (i = 0; i < list -> count; i++)
	    {
		XtFree ((char *) list -> resources[i] -> resource_name);
		XtFree ((char *) list -> resources[i] -> resource_class);
		XtFree ((char *) list -> resources[i] -> resource_type);
		XtFree ((char *) list -> resources[i] -> default_addr);
		XtFree ((char *) list -> resources[i]);
	    }
	    if (prev_list)
		prev_list -> next = list -> next;
	    else
		XtentNamedResourceLists = list -> next;
	    XtFree ((char *) list);
	    break;
	}
	ArgNReturn (True);
    }

    case DefineCursor:
    {
	Cursor cursor;
	XrmValue from_value, to_value;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	    cursor = (Cursor) None;
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen (arg_ptr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value, XtQCursor, &to_value, NULL);

	    if (to_value.size && to_value.addr)
		cursor = *((Cursor *) to_value.addr);
	    else
		cursor = (Cursor) None;
	}

	XDefineCursor (display, XtWindow (w), cursor);

	ArgNReturn (True);
    }

    case DragWidget:
    {
	XPoint point;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (w == *toplevel_ptr)
	{
	    XtentWarningMessage ("Cannot drag the toplevel widget.");
	    ArgNReturn (True);
	}
	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "None") == 0)
	    arg_ptr = (char *) NULL;
	else
	{
	    val_ptr = arg_ptr;
	    i = 0;
	    while (*val_ptr)
		if (*val_ptr++ == '%' && *val_ptr == 'd')
		    i++;
	}

	if (i != 0 && i != 2)
	{
	    fprintf (stderr,
       "%s: The DragWidget format string must have 0, or 2 %%d entries: %s.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}
	XtDragWidget (w,
		      arg_ptr,		/* format */
		      ArgN (1),		/* font */
		      /* move the title window */
		      XtentTestTrue (ArgN (2)),
		      /* use setvalues to move the widget */
		      XtentTestTrue (ArgN (3)),
		      &point);
	sprintf (copy_buffer, "%d", point.x);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);
	sprintf (copy_buffer, "%d", point.y);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);
	ArgNReturn (True);
    }

    case EvalLine:
    case _EvalLine:
	arg_ptr = frame_data.arg_buffer;
	if (op -> type == EvalLine)
	{
	    element = XtentConvertEmbeddedNames (display,
						 toplevel_ptr,
						 arg_ptr);
	    if (*element == '\0')
		ArgNReturn (True);
	}
	else
	    element = arg_ptr;

	frame_data.evaluation_block = True;
	XtentEvalResourceLine (display, toplevel_ptr, element);

	if (element != arg_ptr)
	    XtFree ((char *) element);

	ArgNReturn (True);

    case EvalLines:
    case _EvalLines:
	frame_data.evaluation_block = True;
	arg_ptr = frame_data.arg_buffer;
	mark = *arg_ptr;
	while (*arg_ptr != '\0')
	{
	    operation = arg_ptr = XtentTrimBuffer (arg_ptr + 1);
	    while (*arg_ptr && *arg_ptr != mark)
		arg_ptr++;

	    mark = *arg_ptr;
	    *arg_ptr = '\0';
	    if (op -> type == EvalLines)
	    {
		element = XtentConvertEmbeddedNames (display,
						     toplevel_ptr,
						     operation);
		if (*element == '\0')
		{
		    *arg_ptr = mark;
		    continue;
		}
	    }
	    else
		element = operation;

	    XtentEvalResourceLine (display, toplevel_ptr, element);

	    if (element != operation)
		XtFree ((char *) element);

	    *arg_ptr = mark;

	    if (frame_data.break_from_eval == True)
		break;
	}
	ArgNReturn (True);

    case Eval:
    case _Eval:
	frame_data.evaluation_block = True;
	arg_count = 0;
	for (;;)
	{
	    arg_ptr = XtentProcessArgN (display, toplevel_ptr,
					&frame_data, arg_count++,
					(op -> type == Eval));

	    if (*arg_ptr == '\0')
		if (frame_data.end_of_line)
		    break;
		else
		    continue;

	    XtentEvalResourceLine (display, toplevel_ptr, arg_ptr);

	    if (frame_data.break_from_eval == True)
		break;
	}
	ArgNReturn (True);

    case Exit:
/* RAD */
#ifdef LIB_E
	if (e_initialized)
	    XtentEExit (atoi (ArgN (-1)));
#endif /* LIB_E */
/* RAD */
	exit (atoi (ArgN (-1)));

    case ForEach:		/* (variable, body, arg0, arg1, ..., argn) */
    case _ForEach:
	frame_data.evaluation_block = True;
	val_ptr = ArgN (0);
	arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    (op -> type == ForEach));
	if (*arg_ptr == '\0')
	    ArgNReturn (True);

	arg_count = 2;
	for (;;)
	{
	    element = ArgN (arg_count++);
	    if (*element == '\0' && frame_data.end_of_line)
		break;

	    XtentXrmPutStringResource (&db, val_ptr, element, 30);

	    XtentEvalResourceLine (display, toplevel_ptr, arg_ptr);

	    if (frame_data.break_from_eval == True)
		break;
	}
	ArgNReturn (True);

    case ForEachArg:		/* (variable, body, arg) arg: a, b, c, ... */
    case _ForEachArg:
	{
	    XtentFrameData for_each_frame_data;

	    val_ptr = ArgN (0);
	    arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
					(op -> type == ForEachArg));
	    if (*arg_ptr == '\0')
		ArgNReturn (True);

	    element = ArgN (2);
	    if (*element == '\0')
		ArgNReturn (True);

	    /*
	     * initialize this frame
	     */
	    XtentCreateFrame (&for_each_frame_data);
	    for_each_frame_data.buffer = (char *) NULL;

	    i = strlen (element);
	    colon = (char *) XtMalloc (i + 3);
	    *colon = '(';
	    memcpy (colon + 1, element, i);
	    *(colon + 1 + i) = ')';
	    *(colon + 1 + i + 1) = '\0';
	    for_each_frame_data.arg_buffer = colon;
	    for_each_frame_data.evaluation_block = True;

	    arg_count = 0;

	    for (;;)
	    {
		element = XtentProcessArgN (display, toplevel_ptr,
					    &for_each_frame_data, arg_count++,
					    (op -> type == ForEachArg));
		if (*element == '\0' && for_each_frame_data.end_of_line)
		    break;

		XtentXrmPutStringResource (&db, val_ptr,
					   element, 30);

		XtentEvalResourceLine (display, toplevel_ptr, arg_ptr);

		if (for_each_frame_data.break_from_eval == True)
		    break;
	    }

	    /*
	     * release this frame
	     */
	    XtFree (for_each_frame_data.arg_buffer);
	    XtentLocalVariable (display, XtentVariablesPop,
				for_each_frame_data.frame, NULL, NULL);
	    XtentReleaseFrame (&for_each_frame_data);

	    ArgNReturn (True);
	}

    case FreeColor:
	XtentFreeColor (display, ArgN (0), ArgN (1));
	ArgNReturn (True);

    case FreeColormap:
	XtentFreeColormap (display, ArgN (-1));
	ArgNReturn (True);

    case FreeImage:
	XtentFreeImage (display, ArgN (-1));
	ArgNReturn (True);

    case FreeImageCursor:
	XtentFreeImageCursor (display, ArgN (0), ArgN (1), ArgN (2),
			      ArgN (3), ArgN (4), ArgN (5));
	ArgNReturn (True);

    case FreePixmap:
	XtentFreePixmap (display, ArgN (-1));
	ArgNReturn (True);

    case FunctionArg:		/* (depth, index, expand, var, eof) */
    {
	XtentFrameData *frame_ptr;

	frame_ptr = frame_data.previous;
	i = atoi (ArgN (0));
	while (frame_ptr && i > 0)
	{
	    frame_ptr = frame_ptr -> previous;
	    i--;
	}

	if (frame_ptr == (XtentFrameData *) NULL)
	{
	    XtentXrmPutStringResource (&db, ArgN (3), "", 30);
	    XtentXrmPutStringResource (&db, ArgN (4), "True", 30);

	}
	else
	{
	    XtentFrameData function_arg_frame_data;

	    /*
	     * complete this frame
	     */
	    i = atoi (ArgN (1));
	    j = XtentTestTrue (ArgN (2));
	    colon = ArgN (3);
	    val_ptr = ArgN (4);

	    /*
	     * initialize the new frame
	     */
	    XtentCreateFrame (&function_arg_frame_data);
	    function_arg_frame_data.buffer = (char *) NULL;
	    function_arg_frame_data.arg_buffer = frame_ptr -> arg_buffer;

	    element = XtentProcessArgN (display, toplevel_ptr,
					&function_arg_frame_data,
					i, j);

	    if (*element == '\0' && function_arg_frame_data.end_of_line)
		arg_ptr = "True";
	    else
		arg_ptr = "False";

	    XtentXrmPutStringResource (&db, colon, element, 30);
	    XtentXrmPutStringResource (&db, val_ptr, arg_ptr, 30);

	    /*
	     * release this frame
	     */
	    XtentReleaseFrame (&function_arg_frame_data);
	}

	ArgNReturn (True);
    }

    case Get:
    {
	XrmString value_type;
	XrmValue value_return;

	arg_count = 0;
	for (;;)
	{
	    val_ptr = ArgN (arg_count++);
	    if (*val_ptr == '\0' && frame_data.end_of_line)
		break;

	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (!(XrmGetResource (XtDatabase (display),
				  val_ptr, (char *) NULL,
				  &value_type, &value_return) &&
		  value_return.size > 0))
		val_ptr = "";
	    else
		val_ptr = (char *) value_return.addr;

	    XtentXrmPutStringResource (&db, arg_ptr, val_ptr, 30);
	}
	ArgNReturn (True);
    }

    case GetImage:
    case GetPixel:
    {
	XRectangle rect;
	Window window;
	int usingRoot;

	if (strncmp (buffer, "theRootWindow.", 14) == 0)
	{
	    window = RootWindow (display, DefaultScreen (display));
	    usingRoot = True;
	}
	else
	{
	    w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				    operation, string_one, parse_quarks,
				    parse_bindings, field_count);
	    window = XtWindow (w);
	    usingRoot = False;
	}
	strcpy (copy_buffer, XtentNextImageName ());
	if (op -> type == GetPixel)
	{
	    XImage * image;
	    Colormap colormap;
	    XColor color;
	    XrmValue from_value, to_value;

	    arg_ptr = ArgN (0);
	    rect.x = atoi (ArgN (1));
	    rect.y = atoi (ArgN (2));
	    rect.width = rect.height = 1;
	    image = XtentGetImage (display, window, &rect, True, copy_buffer);
	    if (image == (XImage *) NULL)
		ArgNReturn (True);
	    color.pixel = XGetPixel (image, 0, 0);
	    XtentFreeImage (display, copy_buffer);

	    colormap = (Colormap) NULL;
	    if (usingRoot == False)
	    {
		from_value.addr = (XtPointer) arg_ptr;
		from_value.size = sizeof (XtPointer);
		to_value.size = 0;
		to_value.addr = (XtPointer) NULL;
		_XtConvert (w, XtQString, &from_value,
			    XtQColormap, &to_value, NULL);

		if (to_value.size && to_value.addr)
		    colormap = *((Colormap *) to_value.addr);
		else if (w -> core.colormap)
		    colormap = w -> core.colormap;
	    }
	    if (colormap == (Colormap) NULL)
		colormap = DefaultColormap (display, DefaultScreen (display));

	    XQueryColor (display, colormap, &color);

	    sprintf (copy_buffer, "%ld", color.pixel);
	    XtentXrmPutStringResource (&db, ArgN (3),
				       copy_buffer, 30);

	    sprintf (copy_buffer, "%ld", color.red);
	    XtentXrmPutStringResource (&db, ArgN (4),
				       copy_buffer, 30);

	    sprintf (copy_buffer, "%ld", color.green);
	    XtentXrmPutStringResource (&db, ArgN (5),
				       copy_buffer, 30);

	    sprintf (copy_buffer, "%ld", color.blue);
	    XtentXrmPutStringResource (&db, ArgN (6),
				       copy_buffer, 30);

	    ArgNReturn (True);
	}
	rect.x = atoi (ArgN (0));
	rect.y = atoi (ArgN (1));
	rect.width = atoi (ArgN (2));
	rect.height = atoi (ArgN (3));
	if (XtentGetImage (display, window, &rect, True, copy_buffer))
	    XtentPutStringReturn (&db, ArgN (4), copy_buffer);
	ArgNReturn (True);
    }

    case GetPoint:		/* (title, fontname, MoveWindow?,
				   cursor, x, y) */
    case GetRect:		/* (title, fontname, MoveWindow?, x, y,
				   width, height) */
    case GetWidget: 		/* (title, fontname, MoveWindow?,
				   cursor, widget_return) */
    {
	Cursor cursor;
	XRectangle rect;
	Window window;
	XSizeHints sizehints;

	if (strncmp (buffer, "theRootWindow.", 14) == 0)
	{
	    window = RootWindow (display, DefaultScreen (display));
	}
	else
	{
	    window = XtWindow (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer,
						   operation,
						   string_one, parse_quarks,
						   parse_bindings,
						   field_count));
	}
	sizehints.flags = PSize | PMinSize;
	sizehints.width = sizehints.min_width = 0;
	sizehints.height = sizehints.min_height = 0;

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "None") == 0)
	    arg_ptr = (char *) NULL;
	val_ptr = arg_ptr;
	i = 0;
	if (val_ptr)
	    while (*val_ptr)
		if (*val_ptr++ == '%' && *val_ptr == 'd')
		    i++;

	if ((op -> type == GetPoint || op -> type == GetWidget) &&
	    i != 0 && i != 2)
	{
	    fprintf (stderr,
	"%s: The %s format string must have 0, or 2 %%d entries: %s.\n",
		     XtentProgramName (),
		     ((op -> type == GetPoint) ?
		      "GetPoint" : "GetWidget"),
		     arg_ptr);
	    ArgNReturn (True);
	}
	else if (op -> type == GetRect && i != 0 && i != 2 && i != 4)
	{
	    fprintf (stderr,
   "%s: The GetRect format string must have 0, 2, or 4 %%d entries: %s.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	if (op -> type == GetRect)
	    cursor = None;
	else
	{
	    element = ArgN (3);
	    if (*element == '\0' ||
		(strcmp (element, "None") == 0))
		cursor = (Cursor) None;
	    else
	    {
		XrmValue from_value, to_value;

		from_value.addr = element;
		from_value.size = strlen (element) + 1;
		to_value.size = 0;
		to_value.addr = (XtPointer) NULL;

		_XtConvert (XtentToplevel (display,
					   toplevel_ptr),
			    XtQString, &from_value,
			    XtQCursor, &to_value, NULL);
		if (to_value.size == sizeof (Cursor) &&
		    to_value.addr)
		    cursor = *((Cursor *) to_value.addr);
		else
		    cursor = (Cursor) None;
	    }
	}

	XGetPoints (display, DefaultScreen (display), window,
		    &sizehints,
		    arg_ptr,		/* format string or title */
		    ArgN (1),		/* font */
		    cursor,
		    /* display the size only */
		    (op -> type != GetRect) ? 2 : (i == 2),
		    /* move the prompt window as the rectangle changes */
		    XtentTestTrue (ArgN (2)),
		    &rect, &window);

	if (op -> type == GetWidget)
	{
	    w = XtWindowToWidget (display, window); 
	    if (w)
		XtentPutStringReturn (&db, ArgN (4), XtentWidgetToName (w));
	    else
	    {
		XtentWarningMessage ("The window selected using GetWidget has no associated widget.");
		XtentPutStringReturn (&db, ArgN (4), "None");
	    }
	    ArgNReturn (True);
	}

	if (op -> type == GetPoint)
	{
	    sprintf (copy_buffer, "%d", rect.x);
	    XtentXrmPutStringResource (&db, ArgN (4),
				       copy_buffer, 30);

	    sprintf (copy_buffer, "%d", rect.y);
	    XtentXrmPutStringResource (&db, ArgN (5),
				       copy_buffer, 30);

	    ArgNReturn (True);
	}

	sprintf (copy_buffer, "%d", rect.x);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	sprintf (copy_buffer, "%d", rect.y);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);
	sprintf (copy_buffer, "%d", rect.width);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);
	sprintf (copy_buffer, "%d", rect.height);
	XtentXrmPutStringResource (&db, ArgN (6), copy_buffer, 30);
	ArgNReturn (True);
    }

    case While:
    case _While:
    case OldWhile:
    case _OldWhile:
	frame_data.evaluation_block = True;
				/* fall through */
    case If:
    case _If:
    case OldIf:
    case _OldIf:
    {
	char *arg_str;
	char *val_str;
	int a_item, op_item;

	if (op -> type == _If || op -> type == If ||
	    op -> type == _While || op -> type == While)
	{
	    a_item = 0;
	    op_item = 1;
	}
	else
	{
	    a_item = 1;
	    op_item = 0;
	}

	arg_str = XtentProcessArgN (display, toplevel_ptr, &frame_data, a_item,
				    False);
	arg_ptr = (char *) NULL;

	operation = ArgN (op_item);
	if ((operation[0] && operation[1] && operation[2]) ||
	    (operation[1] != '=' && operation[1] != '\0'))
	    *operation = 'X';

	val_str = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				    False);
	val_ptr = (char *) NULL;

	if (op -> type == While || op -> type == _While ||
	    op -> type == OldWhile || op -> type == _OldWhile)
	    element = XtentProcessArgN (display, toplevel_ptr, &frame_data, 3,
			(op -> type == While || op -> type == OldWhile));
	for (;;)
	{
	    if (arg_ptr != arg_str)
		arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr,
						     arg_str);
	    if (val_ptr != val_str)
		val_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr,
						     val_str);
	    arg_count = False;

	    switch (*operation)
	    {
	    case '>':
		i = (XtentIsNumber (arg_ptr, True) ||
		     XtentIsNumber (val_ptr, True));
		if (operation[1] == '=')
		{
		    if (i)
			arg_count = (atof (arg_ptr) >= atof (val_ptr));
		    else
			arg_count = (atol (arg_ptr) >= atol (val_ptr));
		}
		else
		{
		    if (i)
			arg_count = (atof (arg_ptr) > atof (val_ptr));
		    else
			arg_count = (atol (arg_ptr) > atol (val_ptr));
		}
		break;
	    case '<':
		i = (XtentIsNumber (arg_ptr, True) ||
		     XtentIsNumber (val_ptr, True));
		if (operation[1] == '=')
		{
		    if (i)
			arg_count = (atof (arg_ptr) <= atof (val_ptr));
		    else
			arg_count = (atol (arg_ptr) <= atol (val_ptr));
		}
		else
		{
		    if (i)
			arg_count = (atof (arg_ptr) < atof (val_ptr));
		    else
			arg_count = (atol (arg_ptr) < atol (val_ptr));
		}
		break;
	    case '=':
		arg_count = (strcmp (arg_ptr, val_ptr) == 0);
		if (arg_count == True)
		    break;

		if (XtentIsNumber (arg_ptr, True) &&
		    XtentIsNumber (val_ptr, True))
		    arg_count = (atof (arg_ptr) == atof (val_ptr));
		break;
	    case '!':
		if (operation[1] == '=')
		{
		    arg_count = (strcmp (arg_ptr, val_ptr) != 0);
		    if (arg_count == False)
			break;

		    if (XtentIsNumber (arg_ptr, True) &&
			XtentIsNumber (val_ptr, True))
			arg_count = (atof (arg_ptr) !=
				     atof (val_ptr));
		    break;
		}
		/* fall through */
	    default:
		fprintf (stderr,
     "%s: Illegal comparison in if test at line %d, message %d: \"%s\"\n",
			 XtentProgramName (), XtentLineCount (),
			 XtentMessageCount (), frame_data.buffer);

		if (arg_ptr != arg_str)
		    XtFree (arg_ptr);
		if (val_ptr != val_str)
		    XtFree (val_ptr);
		ArgNReturn (True);
	    }

	    if (op -> type == If || op -> type == _If ||
		op -> type == OldIf || op -> type == _OldIf)
	    {
		if (arg_count)
		    element = XtentProcessArgN (display, toplevel_ptr,
						&frame_data, 3,
				(op -> type == If || op -> type == OldIf));
		else
		    element = XtentProcessArgN (display, toplevel_ptr,
						&frame_data, 4,
				(op -> type == If || op -> type == OldIf));

		if (*element == '\0')
		    break;

		XtentEvalResourceLine (display, toplevel_ptr, element);

		break;
	    }

	    if (arg_count == False)
		break;

	    XtentEvalResourceLine (display, toplevel_ptr, element);

	    if (frame_data.break_from_eval == True)
		break;

	    if (arg_ptr != arg_str)
		XtFree (arg_ptr);
	    if (val_ptr != val_str)
		XtFree (val_ptr);
	}

	if (arg_ptr != arg_str)
	    XtFree (arg_ptr);
	if (val_ptr != val_str)
	    XtFree (val_ptr);

	ArgNReturn (True);
    }

    case Include:
    {
	FILE * fp;

	arg_ptr = ArgN (-1);
	if ((fp = fopen (ExpandFileName (arg_ptr), "r")) == NULL)
	{
	    fprintf (stderr,
		     "%s: Cannot open resource file: %s.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}
	Xtent (display, toplevel_ptr, fp);
	fclose (fp);
	ArgNReturn (True);
    }

    case InternLines:
	intern_lines = XtentTestTrue (ArgN (-1));
	arg_ptr = ArgN (1);
	XtFree ((char *) intern_function);
	if (*arg_ptr != '\0')
	    intern_function = XtNewString (arg_ptr);
	else
	    intern_function = (char *) NULL;
	ArgNReturn (True);

    case InternShellVariables:
	i = 0;
	for (;;)
	{
	    arg_ptr = ArgN (i++);
	    if (*arg_ptr == '\0')
		break;

	    if ((val_ptr = (char *) getenv (arg_ptr)) == (char *) NULL)
		val_ptr = "";

	    XtentXrmPutStringResource (&db, arg_ptr, val_ptr, 30);
	}
	if (i == 1)
	{
	    extern char **environ;
	    char **ptr;

	    for (ptr = environ; *ptr; ptr++)
	    {
		if ((arg_ptr = (char *) strchr (*ptr, '=')) == (char *) NULL)
		    continue;

		*arg_ptr = '\0';
		XtentXrmPutStringResource (&db,
					   *ptr, arg_ptr + 1, 30);
		*arg_ptr = '=';
	    }
	}
	ArgNReturn (True);

    case IsWidget:
	if (buffer == operation ||
	    (*buffer == '*' && (buffer + 1) == operation))
	{
	    w = *toplevel_ptr;
	}
	else
	{
	    parse_bindings[field_count] = (XrmBinding) 0x17;
	    w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				    string_one, parse_quarks, parse_bindings,
				    field_count);
	}
	XtentPutStringReturn (&db, ArgN (-1),
			      (w == (Widget) NULL) ? "False" : "True");
	ArgNReturn (True);

    case Iterate:		/* (variable, test, start, end, step, body) */
    case _Iterate:
	val_ptr = ArgN (0);
	operation = ArgN (1);
	if ((operation[0] && operation[1] && operation[2]) ||
	    (operation[1] != '=' && operation[1] != '\0'))
	    *operation = 'X';
	i = atoi (ArgN (2));
	arg_count = atoi (ArgN (3));
	j = atoi (ArgN (4));
	sprintf (copy_buffer, "%d", i);
	XtentXrmPutStringResource (&db, val_ptr, copy_buffer, 30);
	arg_ptr = XtentProcessArgN (display, toplevel_ptr,
				    &frame_data, 5,
				    (op -> type == Iterate));
	if (*arg_ptr == '\0')
	    ArgNReturn (True);

	frame_data.evaluation_block = True;

	for (;;)
	{
	    switch (*operation)
	    {
	    case '>':
		if (operation[1] == '=')
		{
		    if (i >= arg_count)
			break;
		    ArgNReturn (True);
		}
		if (i > arg_count)
		    break;
		ArgNReturn (True);

	    case '<':
		if (operation[1] == '=')
		{
		    if (i <= arg_count)
			break;
		    ArgNReturn (True);
		}
		if (i < arg_count)
		    break;
		ArgNReturn (True);

	    case '=':
		if (i == arg_count)
		    break;
		ArgNReturn (True);

	    case '!':
		if (i != arg_count)
		    break;
		ArgNReturn (True);

	    default:
		fprintf (stderr,
     "%s: Illegal comparison in iterate at line %d, message %d: \"%s\"\n",
			 XtentProgramName (), XtentLineCount (),
			 XtentMessageCount (), frame_data.buffer);
		ArgNReturn (True);
	    }

	    XtentEvalResourceLine (display, toplevel_ptr, arg_ptr);

	    if (frame_data.break_from_eval == True)
		ArgNReturn (True);

	    i += j;
	    sprintf (copy_buffer, "%d", i);
	    XtentXrmPutStringResource (&db, val_ptr,
				       copy_buffer, 30);
	}

    case LocalVariables:
	i = 0;
	for (;;)
	{
	    arg_ptr = ArgN (i++);
	    if (*arg_ptr == '\0')
		break;

	    XtentLocalVariable (display, XtentVariablesPush,
				frame_data.frame - 1,
				arg_ptr, "");
	}
	ArgNReturn (True);

    case LowerWidget:
	XLowerWindow (display, XtWindow
		      (_xtentNameToWidget (display, toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count)));
	ArgNReturn (True);

    case MapWindow:
    {
	Window window;
	Position x, y;
	XSizeHints sizehints;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNx, &x);
	XtSetArg (args[1], XtNy, &y);
	XtGetValues (w, args, 2);
	sizehints.x = x;
	sizehints.y = y;
	sizehints.flags = USPosition | PPosition;
	window = XtWindow (w);
	XSetNormalHints (display, window, &sizehints);
	XMapWindow (display, window);
	XSync (display, False);
	ArgNReturn (True);
    }

    case Print:
	printf ("%s\n", ArgN (-1));
	ArgNReturn (True);

    case PrintOperations:
    case PrintResources:
    case PrintWidgetClasses:
    case PrintWidgetResources:
    case PrintWidgets:
    {
	XtentOutput * output =
	    (XtentOutput *) XtMalloc (sizeof (XtentOutput));

	switch (op -> type)
	{
	case PrintResources:
	    val_ptr = "PrintResources";
	    operation = (char *) NULL;
	    break;
	case PrintOperations:
	    val_ptr = "PrintOperations";
	case PrintWidgetClasses:
	    if (op -> type == PrintWidgetClasses)
		val_ptr = "PrintWidgetClasses";
	case PrintWidgetResources:
	    if (op -> type == PrintWidgetResources)
		val_ptr = "PrintWidgetResources";
	case PrintWidgets:
	    if (op -> type == PrintWidgets)
		val_ptr = "PrintWidgets";

	    w = _xtentNameToWidget (display, toplevel_ptr,
				    buffer, operation,
				    string_one, parse_quarks, parse_bindings,
				    field_count);
	    operation--;
	    mark = *operation;
	    *operation = '\0';
	}

	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0')
	{
	    arg_ptr = "/dev/tty";
	    output -> resource = (char *) NULL;
	    output -> fp = stdout;
	}
	else
	{
	    val_ptr = ExpandFileName (arg_ptr);
	    if (strncmp (val_ptr, "resource:", 9) == 0)
	    {
		output -> resource = XtentTrimBuffer (val_ptr + 9);
		output -> fp = (FILE *) NULL;
		output -> list = (XtentOutputLink *) NULL;
	    }
	    else
	    {
		output -> resource = (char *) NULL;
		output -> fp = fopen (val_ptr, "w");
		if (output -> fp == NULL)
		{
		    fprintf (stderr,
			     "%s: Cannot open %s file: %s.\n",
			     XtentProgramName (), val_ptr,
			     arg_ptr);
		    if (operation)
			*operation = mark;

		    XtFree ((char *) output);

		    XrmPutLineResource (&db, frame_data.buffer);
		    ArgNReturn (False);
		}
	    }
	}
	switch (op -> type)
	{
	case PrintOperations:
	    op = Operations;
	    while (op -> string != (char *) NULL)
	    {
		XtentFormatPrint (output, "Xt%s\n", op -> string,
				  (char *) NULL);
		op++;
	    }
	    break;
	case PrintResources:
	    if (output -> fp != stdout)
		fclose (output -> fp);
	    XrmPutFileDatabase (db, arg_ptr);
	    break;
	case PrintWidgetClasses:
	    wcn = XtentWidgetClassNames;
	    while (wcn -> string != (char *) NULL)
	    {
		XtentFormatPrint (output, "%s\n", wcn -> string,
				  (char *) NULL);
		wcn++;
	    }
	    break;
	case PrintWidgetResources:
	    XtentPrintWidgetResources (XtClass (w), w,
				  XtentTrimBuffer (frame_data.buffer), output);
	    break;
	case PrintWidgets:
	    XtentProcessWidgetNames (op -> type, w,
				     XtentTrimBuffer (frame_data.buffer),
				     output, (char *) NULL);
	    break;
	}
	if (operation)
	{
	    *operation = mark;
	    if (output -> fp != stdout)
		fclose (output -> fp);
	}
	/* output block */
	if (output -> resource)
	{
	    XtentOutputLink * prev_link, *link, *next_link;

	    prev_link = (XtentOutputLink *) NULL;
	    link = output -> list;
	    i = 0;
	    while (link)
	    {
		/* total length */
		i += link -> char_length;
		/* reverse the links */
		next_link = link -> next;
		link -> next = prev_link;
		prev_link = link;
		if (next_link)
		    link = next_link;
		else
		    break;
	    }
	    arg_ptr = element = (char *) XtMalloc (i);
	    while (link)
	    {
		val_ptr = link -> item;
		while (*arg_ptr = *val_ptr++)
		{
		    if (*arg_ptr == '\n')
			*arg_ptr = ((link -> next || *val_ptr) ?
				    ',' : '\0');
		    arg_ptr++;
		}
		next_link = link -> next;
		XtFree ((char *) link);
		link = next_link;
	    }
	    XtentPutStringReturn (&db, output -> resource, element);
	    XtFree ((char *) element);
	}
	XtFree ((char *) output);
	ArgNReturn (True);
    }

#ifdef SMALL_SWITCHES
    }
    i = 23;			/* defeat simple optimizers */
    switch (op -> type)
    {
#endif
    case QueryPixel:	/* (colormap, pixel, red, green, blue, flags) */
    {
	XColor color;

	XtentQueryPixel (display, ArgN (0), ArgN (1), &color);

	sprintf (copy_buffer, "%d", color.red >> 8);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	sprintf (copy_buffer, "%d", color.green >> 8);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);

	sprintf (copy_buffer, "%d", color.blue >> 8);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);

	sprintf (copy_buffer, "%d", color.flags);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);

	ArgNReturn (True);
    }

    case QueryPointer:
    {
	Window window, root_window, child_window;
	int root_x, root_y, child_x, child_y;
	unsigned int bitmask;

	if (strncmp (buffer, "theRootWindow.", 14) == 0)
	{
	    window = RootWindow (display, DefaultScreen (display));
	}
	else
	{
	    window = XtWindow (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer,
						   operation,
						   string_one, parse_quarks,
						   parse_bindings,
						   field_count));
	}
	XQueryPointer (display, window,
		       &root_window, &child_window,
		       &root_x, &root_y, &child_x, &child_y, &bitmask);

	arg_ptr = ArgN (0);
	if (child_window == None)
	{
	    XtentXrmPutStringResource (&db, arg_ptr, "None", 30);
	}
	else if (child_window == RootWindow (display, DefaultScreen (display)))
	{
	    XtentXrmPutStringResource (&db, arg_ptr, "theRootWindow", 30);
	}
	else
	{
	    w = XtWindowToWidget (display, child_window);
	    XtentXrmPutStringResource (&db, arg_ptr,
				       ((w) ? XtentWidgetToName (w) : "None"),
				       30);
	}

	sprintf (copy_buffer, "%d", child_x);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	sprintf (copy_buffer, "%d", child_y);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	sprintf (copy_buffer, "%d", bitmask);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	ArgNReturn (True);
    }

    case RaiseWidget:
        XRaiseWindow (display, XtWindow
		      (_xtentNameToWidget (display, toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count)));
	ArgNReturn (True);

    case ReadImage:
	arg_ptr = ArgN (1);
	val_ptr = "Optional file types for Read are bitmap and tif.";
	switch (*arg_ptr)
	{
	case '\0':
	case 'b':
	    if (*arg_ptr && strcmp (arg_ptr, "bitmap") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentReadImage (display, ArgN (0), 'b', False);
	    break;
	case 't':
	    if (strcmp (arg_ptr, "tif") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentReadImage (display, ArgN (0), 't',
			    XtentTestTrue (ArgN (2)));
	    break;
	default:
	    XtentWarningMessage (val_ptr);
	    break;
	}
	ArgNReturn (True);

    case ReadPixmap:
	arg_ptr = ArgN (1);
	val_ptr = "Optional file types for Read are bitmap and tif.";
	switch (*arg_ptr)
	{
	case '\0':
	case 'b':
	    if (*arg_ptr && strcmp (arg_ptr, "bitmap") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentReadPixmap (display, ArgN (0), 'b', False);
	    break;
	case 't':
	    if (strcmp (arg_ptr, "tif") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentReadPixmap (display, ArgN (0), 't',
			     XtentTestTrue (ArgN (2)));
	    break;
	default:
	    XtentWarningMessage (val_ptr);
	    break;
	}
	ArgNReturn (True);

    case ReparentWindow:
    {
	Window window;

	window = XtWindow (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count));
	XReparentWindow (display, atoi (ArgN (0)), window,
			 atoi (ArgN (1)), atoi (ArgN (2)));
	XAddToSaveSet (display, atoi (ArgN (0)));
	ArgNReturn (True);
    }

    case Return:		/* .XtReturn: return-value */
    case ReturnN:		/* .XtReturnN: (depth, return-value) */
    {
	XtentFrameData *frame_ptr = frame_data.previous;

	if (op -> type == ReturnN)
	{
	    i = atoi (ArgN (-1));
	    arg_ptr = ArgN (1);
	}
	else
	{
	    i = 1;
	    arg_ptr = ArgN (-1);
	}

	frame_ptr = frame_data.previous;
	while (frame_ptr && i > 0)
	{
	    frame_ptr -> break_from_eval = True;
	    if (frame_ptr -> evaluation_block == True)
		i--;
	    frame_ptr = frame_ptr -> previous;
	}

	if (XtentReturnValue && XtentReturnValue != XtentReturnBuffer)
	    XtFree ((char *) XtentReturnValue);

	XtentReturnValue = (char *) NULL;

	if (*arg_ptr != '\0')
	    XtentSetReturn (arg_ptr);

	ArgNReturn (True);
    }

    case ScaleImage:
	strcpy (copy_buffer, XtentNextImageName ());
	if (XtentScaleImage (display,
			     ArgN (0),
			     atoi (ArgN (1)),
			     atoi (ArgN (2)),
			     copy_buffer) == False)
	    ArgNReturn (True);

	XtentPutStringReturn (&db, ArgN (3), copy_buffer);
	ArgNReturn (True);

    case Set:
	arg_count = 0;
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    val_ptr = ArgN (arg_count++);
	    if (*val_ptr == '\0' && frame_data.end_of_line)
		break;

	    XtentXrmPutStringResource (&db, arg_ptr, val_ptr, 30);
	}
	ArgNReturn (True);

    case SetShellVariables:
    case UnsetShellVariables:
    {
	extern char **environ;
	static char **old_local_environ = (char **) NULL;
	char **local_environ;
	char **lptr;
	char **cptr;
	
	/*
	 * collect the arguments
	 */
	i = 0;
	arg_count = -1;
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0')
		break;
	    if (arg_count == 0)
		arg_count = 1;

	    if (op -> type == SetShellVariables)
		val_ptr = ArgN (arg_count++);

	    if (i >= arg_max_count)
	    {
		arg_max_count += XTENTMAXARGS;
		args = (Arg *) XtRealloc ((char *) args, 
				(Cardinal) sizeof (Arg) * arg_max_count);
	    }

	    j = strlen (arg_ptr);
	    if (op -> type == SetShellVariables)
	    {
		element = (char *) XtMalloc (j + 1 + strlen (val_ptr) + 1);
		sprintf (element, "%s=%s", arg_ptr, val_ptr);
		arg_ptr = element;
	    }
	    XtSetArg (args[i], arg_ptr, (XtPointer) j);
	    i++;
	}

	if (i == 0)
	    ArgNReturn (True);

	/*
	 * allocate space for new variables
	 */
	if (op -> type == SetShellVariables)
	{
	    arg_count = i;
	    cptr = environ;
	    while (*cptr++)
		arg_count++;
	    arg_count += 2;

	    local_environ = (char **) XtMalloc (arg_count * sizeof (char *));

	    lptr = local_environ;
	}
	else
	    lptr = environ;

	if (op -> type == UnsetShellVariables &&
	    strcmp (args[0].name, "-all") == 0)
	{
	    *lptr = (char *) NULL;
	    ArgNReturn (True);
	}

	/*
	 * filter out old replaced or unset variables
	 */
	cptr = environ;
	while (*lptr = *cptr++)
	{
	    val_ptr = *lptr++;
	    for (j = 0; j < i; j++)
	    {
		arg_count = (int) args[j].value;
		if (strncmp (val_ptr, args[j].name, arg_count) == 0 &&
		    val_ptr[arg_count] == '=')
		{
		    lptr--;
		    break;
		}
	    }
	}
	
	/*
	 * install new values
	 */
	if (op -> type == SetShellVariables)
	{
	    for (j = 0; j < i; j++)
		*lptr++ = (char *) args[j].name;
	    *lptr = (char *) NULL;
	    environ = local_environ;
	    XtFree ((char *) old_local_environ);
	    old_local_environ = local_environ;
	}
	
	ArgNReturn (True);
    }

    case SetStdin:
    {
	FILE * fp;

	fp = freopen (ExpandFileName (ArgN (-1)), "r", stdin);
	if (fp == (FILE *) NULL)
	    XtentWarningMessage ("SetStdin failed - the file is probably not readable.");
	ArgNReturn (True);
    }

    case SetStdout:
    {
	FILE * fp;

	fp = freopen (ExpandFileName (ArgN (-1)), "w", stdout);
	if (fp == (FILE *) NULL)
	    XtentWarningMessage ("SetStdout failed - the file is probably not writable.");
	ArgNReturn (True);
    }

    case SetStderr:
    {
	FILE * fp;
	fp = freopen (ExpandFileName (ArgN (-1)), "w", stderr);
	if (fp == (FILE *) NULL)
	    XtentWarningMessage ("SetStderr failed - the file is probably not writable.");
	ArgNReturn (True);
    }

    case ShellEscape:
    case _ShellEscape:
	XtentShellEscapeProc (display, toplevel_ptr,
			      XtentProcessArgN (display, toplevel_ptr,
						&frame_data, -1,
						(op -> type == ShellEscape)));
	ArgNReturn (True);

    case StringSize:
    {
	XCharStruct overall_size;
	XFontStruct * font_struct;

	element = ArgN (0);
	if (*element == '\0')
	{
	    XtentWarningMessage ("No font name supplied for StringSize.");
	    ArgNReturn (True);
	}
	if ((font_struct = XLoadQueryFont (display, element)) == NULL)
	{
	    fprintf (stderr,
		     "%s: Cannot load the font supplied for StringSize: %s.",
		     XtentProgramName (), element);
	    ArgNReturn (True);
	}
	element = ArgN (1);
	XTextExtents (font_struct, element, strlen (element),
		      &j,	        /* ignore the direction field */
		      &i, &arg_count,	/* ascent, descent */
		      &overall_size);
	XFreeFontInfo ((char **) NULL, font_struct, 1);
	/*
	 * left bearing
	 */
	sprintf (copy_buffer, "%d", overall_size.lbearing);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	/*
	 * right bearing
	 */
	sprintf (copy_buffer, "%d", overall_size.rbearing);
	XtentXrmPutStringResource (&db,  ArgN (3), copy_buffer, 30);
	/*
	 * height
	 */
	sprintf (copy_buffer, "%d", overall_size.ascent +
		 overall_size.descent);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);
	/*
	 * font height -  ascent + descent
	 */
	sprintf (copy_buffer, "%d", i + arg_count);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);

	ArgNReturn (True);
    }

    case UnmapWindow:
    {
	Window window;

	window = XtWindow (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count));
	XUnmapWindow (display, window);
	ArgNReturn (True);
    }

    case WarpPointer:
	XWarpPointer (display, None, XtWindow
		      (_xtentNameToWidget (display, toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count)),
		      0, 0, 0, 0,
		      atoi (ArgN (0)), atoi (ArgN (1)));
	ArgNReturn (True);

    case WriteImage:
	arg_ptr = ArgN (2);
	val_ptr = "Optional file types for Write are bitmap, tif, and postscript.";
	switch (*arg_ptr)
	{
	case '\0':
	case 'b':
	    if (*arg_ptr && strcmp (arg_ptr, "bitmap") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWriteImage (display, ArgN (0),
			     ArgN (1),
			     'b', ArgN (3));
	    break;
	case 't':
	    if (strcmp (arg_ptr, "tif") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWriteImage (display, ArgN (0),
			     ArgN (1),
			     't', ArgN (3));
	    break;
	case 'p':
	    if (strcmp (arg_ptr, "postscript") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWriteImage (display, ArgN (0),
			     ArgN (1),
			     'p', ArgN (3));
	    break;
	default:
	    XtentWarningMessage (val_ptr);
	    break;
	}
	ArgNReturn (True);

    case WritePixmap:
	arg_ptr = ArgN (2);
	val_ptr = "Optional file types for Write are bitmap, tif, and postscript.";
	switch (*arg_ptr)
	{
	case '\0':
	case 'b':
	    if (*arg_ptr && strcmp (arg_ptr, "bitmap") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWritePixmap (display, ArgN (0),
			      ArgN (1),
			      'b', ArgN (3));
	    break;
	case 't':
	    if (strcmp (arg_ptr, "tif") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWritePixmap (display, ArgN (0),
			      ArgN (1),
			      't', ArgN (3));
	    break;
	case 'p':
	    if (strcmp (arg_ptr, "postscript") != 0)
	    {
		XtentWarningMessage (val_ptr);
		break;
	    }
	    XtentWritePixmap (display, ArgN (0),
			      ArgN (1),
			      'p', ArgN (3));
	    break;
	default:
	    XtentWarningMessage (val_ptr);
	    break;
	}
	ArgNReturn (True);


    case Add:
	sprintf (copy_buffer, "%d", atoi (ArgN (0)) + atoi (ArgN (1)));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case Calc:
	XtentIntegerCalc (display, toplevel_ptr, &frame_data);
	ArgNReturn (True);

    case DoubleCalc:
	XtentDoubleCalc (display, toplevel_ptr, &frame_data);
	ArgNReturn (True);

    case Sub:
	sprintf (copy_buffer, "%d", atoi (ArgN (0)) - atoi (ArgN (1)));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case Mult:
	sprintf (copy_buffer, "%d", atoi (ArgN (0)) * atoi (ArgN (1)));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case Div:
	i = atoi (ArgN (1));
	if (i == 0)
	{
	    XtentWarningMessage ("Attempted division by zero.");
	    ArgNReturn (True);
	}
	sprintf (copy_buffer, "%d", atoi (ArgN (0)) / i);
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case Hex:
    {
	char format[16];

	arg_count = atoi (ArgN (1));
	if (arg_count <= 0)
	{
	    XtentWarningMessage ("Attempted hex conversion to zero digits.");
	    ArgNReturn (True);
	}
	if (arg_count >= 16)
	{
	    XtentWarningMessage ("Attempted hex conversion to more than 15 digits.");
	    ArgNReturn (True);
	}
	sprintf (format, "%%%dx", arg_count);
	i = (1 << (arg_count << 2)) - 1;
	sprintf (copy_buffer, format, atoi (ArgN (0)) & i);
	for (arg_ptr = copy_buffer; *arg_ptr; arg_ptr++)
	    if (*arg_ptr == ' ')
		*arg_ptr = '0';
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);
    }


    case AddXIpc:
	XtAddXIpc (XtentToplevel (display, toplevel_ptr),
		   ArgN (-1), XtentHandleIpcToClient);
	ArgNReturn (True);

    case RemoveXIpc:
	XtRemoveXIpc ();
	ArgNReturn (True);

    case Send:
	XtentSendMessage (atoi (ArgN (0)), (unsigned char *) ArgN (1));
	ArgNReturn (True);

    case XIPCSetupPortServer:	/* (server_environment_name, port_number,
				   message_handler_function,
				   server_handle_return) */
    case _XIPCSetupPortServer:
    {
	XIpcServer *ipc_server;
	long port_number;
	IPCServerDescriptor *sp;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0')
	    arg_ptr = "XIPC";

	port_number = atol (ArgN (1));

	if ((ipc_server = XIpcSetupPortServer ((char *) NULL,
					       (caddr_t) NULL, (caddr_t) NULL,
					       arg_ptr, port_number)) != NULL)
	{
	    arg_count = strlen (arg_ptr);
	    val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
					(op -> type == XIPCSetupPortServer));
	    j = strlen (val_ptr);
	    sp = (IPCServerDescriptor *) XtMalloc (sizeof (IPCServerDescriptor)
						   + arg_count + 32 + j);

	    for (i = 0; i < XtentIPCServerDescriptorsSize; i++)
	    {
		if (XtentIPCServerDescriptors[i] ==
		    (IPCServerDescriptor *) NULL)
		    break;
	    }

	    if (i == XtentIPCServerDescriptorsSize)
	    {
		XtentIPCServerDescriptors = (IPCServerDescriptor **)
		    XtRealloc ((char *) XtentIPCServerDescriptors,
			       sizeof (IPCServerDescriptor) *
			       (XtentIPCServerDescriptorsSize + 8));

		for (; i < XtentIPCServerDescriptorsSize + 8; i++)
		    XtentIPCServerDescriptors[i] =
			(IPCServerDescriptor *) NULL;

		i = XtentIPCServerDescriptorsSize;
		XtentIPCServerDescriptorsSize += 8;
	    }

	    XtentIPCServerDescriptors[i] = sp;

	    sp -> server = ipc_server;
	    sprintf (sp -> name, "(%d:%s:%ld)", i, arg_ptr, port_number);
	    sp -> name[arg_count + 31] = '\0';
	    sp -> message_handler_code = sp -> name + arg_count + 32;
	    memcpy (sp -> message_handler_code, val_ptr, j + 1);

	    sp -> read_id = XtAppAddInput (
	XtWidgetToApplicationContext (XtentToplevel (display, toplevel_ptr)),
					   ipc_server -> channel,
					   (XtPointer) XtInputReadMask,
				(XtInputCallbackProc) XtentIPCServerInputProc,
					   (XtPointer) sp);

	    XtentPutStringReturn (&db, ArgN (3), sp -> name);
	}
	else
	{
	    fprintf (stderr,
		     "%s: Could not initialize the server (%s:%ld).\n",
		     XtentProgramName (), arg_ptr, port_number);

	    XtentPutStringReturn (&db, ArgN (3), "None");
	}
    	ArgNReturn (True);
    }

    case XIPCCloseServer:
    {
	XIpcServer *server;

	arg_ptr = ArgN (-1);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
	     "%s: Could not find the server \"%s\" for XtXIpcCloseServer.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	server = XtentIPCServerDescriptors[i] -> server;

	XtRemoveInput (XtentIPCServerDescriptors[i] -> read_id);
	XtentIPCCloseServer (server);
	XtFree ((char *) XtentIPCServerDescriptors[i]);
	XtentIPCServerDescriptors[i] = (IPCServerDescriptor *) NULL;

	ArgNReturn (True);
    }

    case XIPCSendToClient: /* (server, client_id, message_type, message,
			      return-string) */
    {
	unsigned short client_id;
	unsigned short type;
	int length;
	XIpcMessage *message;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
	     "%s: Could not find the server \"%s\" for XtXIpcSendToClient.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (4), "False");
	    ArgNReturn (True);
	}

	client_id = atol (ArgN (1));
	type = atol (ArgN (2));
	val_ptr = ArgN (3);
	length = strlen (val_ptr);
	message = (XIpcMessage *) XtMalloc (sizeof (XIpcMessage) + length);
	message -> type = type;
	message -> length = length;
	memcpy (message -> buffer, val_ptr, length);
	i = XIpcSendToClient (XtentIPCServerDescriptors[i] -> server,
			      client_id, message);
	XtFree ((char *) message);

	XtentPutStringReturn (&db, ArgN (4), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCFlushServer:
    {
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
	     "%s: Could not find the server \"%s\" for XtXIpcFlushServer.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	XIpcFlushServer (XtentIPCServerDescriptors[i] -> server);

	ArgNReturn (True);
    }

    case XIPCServerProcessMessage: /* (server, message-name) */
    {
	XIpcMessage *message;
	unsigned short type = 0;
	unsigned short client_id = 0;
	unsigned short length = 0;
	unsigned char * buffer = (unsigned char *) "";
	XrmString value_type;
	XrmValue value_return;
	char *format_buffer;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
     "%s: Could not find the server \"%s\" for XtXIpcServerProcessMessage.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	val_ptr = ArgN (1);
	format_buffer = (char *) XtMalloc (strlen (val_ptr) + 16);
	sprintf (format_buffer, "%s.type", val_ptr);
	if (XrmGetResource (XtDatabase (display), format_buffer, (char *) NULL,
				      &value_type, &value_return) &&
	    value_return.size > 0)
	    type = atol ((char *) value_return.addr);

	sprintf (format_buffer, "%s.client_id", val_ptr);
	if (XrmGetResource (XtDatabase (display), format_buffer, (char *) NULL,
				      &value_type, &value_return) &&
	    value_return.size > 0)
	client_id = atol ((char *) value_return.addr);

	sprintf (format_buffer, "%s.buffer", val_ptr);
	if (XrmGetResource (XtDatabase (display), format_buffer, (char *) NULL,
				      &value_type, &value_return) &&
	    value_return.size > 0)
	buffer = (unsigned char *) value_return.addr;
	length = strlen ((char *) buffer);

	message = (XIpcMessage *) XtMalloc (sizeof (XIpcMessage) + length);
	message -> type = type;
	message -> client_id = client_id;
	message -> length = length;
	memcpy (message -> buffer, buffer, length);
	XIpcServerProcessMessage (XtentIPCServerDescriptors[i] -> server,
				  message);
	XtFree ((char *) format_buffer);
	XtFree ((char *) message);

	ArgNReturn (True);
    }

    case XIPCServerCloseClient:
    {
	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
     "%s: Could not find the server \"%s\" for XtXIpcServerCloseClient.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	XtentIPCServerCloseClient (XtentIPCServerDescriptors[i] -> server,
				   atol (ArgN (1)));

	ArgNReturn (True);
    }

    case XIPCServerSetClientCleanup: /* (server, client, function) */
    case _XIPCServerSetClientCleanup:
    {
	XIpcServer *server;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
    "%s: Could not find the server \"%s\" for XtXIpcServerSetClientCleanup.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	j = atol (ArgN (1));
	server = XtentIPCServerDescriptors[i] -> server;
	if (server && server -> clients[i].data)
	{
	    IPCClientData *client_data =
		(IPCClientData *) server -> clients[i].data;

	    XtFree ((char *) client_data -> client_cleanup_code);

	    arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				(op -> type == XIPCServerSetClientCleanup));
	    if (*arg_ptr)
		client_data -> client_cleanup_code = XtNewString (arg_ptr);
	    else
		client_data -> client_cleanup_code = (char *) NULL;

	   server -> clients[i].cleanup = XtentIPCClientCleanup;
	}
	    
	ArgNReturn (True);
    }

    case XIPCServerClientSynchronize:	/* (server, client, True or False,
					   return-string) */
    {
	XIpcServer *server;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
"%s: Could not find the server \"%s\" for XtXIpcServerClientSynchronize.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (3), "False");
	    ArgNReturn (True);
	}

	j = atol (ArgN (1));
	server = XtentIPCServerDescriptors[i] -> server;

	i =  XIpcSynchronize (&server -> clients[j],
			      XtentTestTrue (ArgN (2)));

	XtentPutStringReturn (&db, ArgN (3), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCIsServerClientActive: /* (server, client_index, return-value) */
    {
	XIpcServer *server;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCServerDescriptorsSize ||
	    XtentIPCServerDescriptors[i] == (IPCServerDescriptor *) NULL)
	{
	    fprintf (stderr,
     "%s: Could not find the server \"%s\" for XtXIpcIsServerClientActive.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (2), "False");
	    ArgNReturn (True);
	}

	j = atol (ArgN (1));
	server = XtentIPCServerDescriptors[i] -> server;

	i = XIpcIsClientActive (&server -> clients[j]);

	XtentPutStringReturn (&db, ArgN (2), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCSetupKeyClient:	/* (xipc-name, xipc-key,
				   message-handler-function, return-string) */
    case _XIPCSetupKeyClient:
    {
	XIpcClient *ipc_client;
	int key;
	IPCClientDescriptor *cp;
	IPCClientData *client_data;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0')
	    arg_ptr = (char *) getenv ("XIPC");

	key = atol (ArgN (1));
	
	if ((ipc_client = XIpcSetupKeyClient (arg_ptr, key, (caddr_t) NULL,
					      (caddr_t) NULL)) != NULL)
	{
	    arg_count = strlen (arg_ptr);
	    val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
					(op -> type == XIPCSetupKeyClient));
	    j = strlen (val_ptr);
	    cp = (IPCClientDescriptor *) XtMalloc (sizeof (IPCClientDescriptor)
						   + arg_count + 32 + j);

	    for (i = 0; i < XtentIPCClientDescriptorsSize; i++)
	    {
		if (XtentIPCClientDescriptors[i] ==
		    (IPCClientDescriptor *) NULL)
		    break;
	    }

	    if (i == XtentIPCClientDescriptorsSize)
	    {
		XtentIPCClientDescriptors = (IPCClientDescriptor **)
		    XtRealloc ((char *) XtentIPCClientDescriptors,
			       sizeof (IPCClientDescriptor) *
			       (XtentIPCClientDescriptorsSize + 8));

		for (; i < XtentIPCClientDescriptorsSize + 8; i++)
		    XtentIPCClientDescriptors[i] =
			(IPCClientDescriptor *) NULL;

		i = XtentIPCClientDescriptorsSize;
		XtentIPCClientDescriptorsSize += 8;
	    }

	    XtentIPCClientDescriptors[i] = cp;

	    cp -> client = ipc_client;
	    sprintf (cp -> name, "(%d:%s:%d)", i, arg_ptr, key);
	    cp -> name[arg_count + 31] = '\0';
	    cp -> message_handler_code = cp -> name + arg_count + 32;
	    memcpy (cp -> message_handler_code, val_ptr, j + 1);

	    client_data = (IPCClientData *) XtMalloc (sizeof (IPCClientData));
	    client_data -> using_write_id = False;
	    client_data -> write_id = (XtInputId) NULL;
	    client_data -> client_cleanup_code = (char *) NULL;
	    
	    client_data -> read_id = XtAppAddInput (
	XtWidgetToApplicationContext (XtentToplevel (display, toplevel_ptr)),
						    ipc_client -> channel, 
						   (XtPointer) XtInputReadMask,
				(XtInputCallbackProc) XtentIPCClientInputProc, 
						    (XtPointer) cp);
	    ipc_client -> data = (XtPointer) client_data;
	    ipc_client -> cleanup = XtentIPCClientCleanup;
	    XtentPutStringReturn (&db, ArgN (3), cp -> name);
	}
	else
	{
	    fprintf (stderr,
		     "%s: Could not initialize the client (%s:%d).\n",
		     XtentProgramName (), arg_ptr, key);

	    XtentPutStringReturn (&db, ArgN (3), "None");
	}
    	ArgNReturn (True);
    }


    case XIPCCloseClient:
    {
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	{
	    fprintf (stderr,
	     "%s: Could not find the client \"%s\" for XtXIpcCloseClient.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	ArgNReturn (True);
    }

    case XIPCSetClientCleanup:	/* (client, function) */
    case _XIPCSetClientCleanup:
    {
	IPCClientData *client_data;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	    i = -1;
	else if (XtentIPCClientDescriptors[i] -> client -> channel ==
		 (XIpcChannel) NULL)
	{
	    i = -1;
	    XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	}
	if (i == -1)
	{
	    fprintf (stderr,
		     "%s: Could not find the client \"%s\" for XtXIpcSetClientCleanup.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	client_data =
	    (IPCClientData *) XtentIPCClientDescriptors[i] -> client -> data;

	XtFree ((char *) client_data -> client_cleanup_code);
	arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    (op -> type == XIPCSetupPortServer));
	if (*arg_ptr)
	    client_data -> client_cleanup_code = XtNewString (arg_ptr);
	else
	    client_data -> client_cleanup_code = (char *) NULL;

	ArgNReturn (True);
    }

    case XIPCSendToServer:	/* (client, type, message-string,
				   return-string) */
    {
	XIpcMessage *message;
	int type, length;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	    i = -1;
	else if (XtentIPCClientDescriptors[i] -> client -> channel ==
		 (XIpcChannel) NULL)
	{
	    i = -1;
	    XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	}
	if (i == -1)
	{
	    fprintf (stderr,
	     "%s: Could not find the client \"%s\" for XtXIpcSendToServer.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (3), "False");
	    ArgNReturn (True);
	}

	type = atol (ArgN (1));
	arg_ptr = ArgN (2);
	length = strlen (arg_ptr);
	message = (XIpcMessage *) XtMalloc (sizeof (XIpcMessage) + length);
	message -> type = type;
	message -> length = length;
	memcpy (message -> buffer, arg_ptr, length);

	i = XIpcSendToServer (XtentIPCClientDescriptors[i] -> client, message);
	XtFree ((char *) message);

	XtentPutStringReturn (&db, ArgN (3), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCFlushClient:
    {
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	    i = -1;
	else if (XtentIPCClientDescriptors[i] -> client -> channel ==
		 (XIpcChannel) NULL)
	{
	    i = -1;
	    XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	}
	if (i == -1)
	{
	    fprintf (stderr,
	     "%s: Could not find the client \"%s\" for XtXIpcFlushClient.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	XIpcFlushClient (XtentIPCClientDescriptors[i] -> client);
	ArgNReturn (True);
    }

    case XIPCClientSynchronize:	/* (client, True or False, return-string) */
    {
	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	    i = -1;
	else if (XtentIPCClientDescriptors[i] -> client -> channel ==
		 (XIpcChannel) NULL)
	{
	    i = -1;
	    XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	}
	if (i == -1)
	{
	    fprintf (stderr,
     "%s: Could not find the client \"%s\" for XtXIpcClientSynchronize.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (2), "False");
	    ArgNReturn (True);
	}

	i =  XIpcSynchronize (XtentIPCClientDescriptors[i] -> client,
			      XtentTestTrue (ArgN (1)));

	XtentPutStringReturn (&db, ArgN (2), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCIsClientActive:
    {
	arg_ptr = ArgN (0);
	if (*arg_ptr == '(' && arg_ptr[1] >= '0' && arg_ptr[1] <= '9')
	    i = atoi (arg_ptr + 1);
	else
	    i = -1;

	if (i < 0 || i > XtentIPCClientDescriptorsSize ||
	    XtentIPCClientDescriptors[i] == (IPCClientDescriptor *) NULL)
	    i = -1;
	else if (XtentIPCClientDescriptors[i] -> client -> channel ==
		 (XIpcChannel) NULL)
	{
	    i = -1;
	    XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i);
	}
	if (i == -1)
	{
	    fprintf (stderr,
     "%s: Could not find the client \"%s\" for XtXIpcIsClientActive.\n",
		     XtentProgramName (), arg_ptr);
	    XtentPutStringReturn (&db, ArgN (1), "False");
	    ArgNReturn (True);
	}

	i = XIpcIsClientActive (XtentIPCClientDescriptors[i] -> client);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XIPCCatchErrors:
	XIpcCatchErrors (XtentTestTrue (ArgN (-1)), (void (*) ()) NULL);
	ArgNReturn (True);

/* RAD */
#ifdef LIB_E
    case AbortE:
	XtentEAbort ( atoi (ArgN (-1)) ); 	/* fd */
	ArgNReturn (TRUE);

    case AddG2FdE:
	XtentEAddG2Fd ( atoi (ArgN (-1)) ); 	/* fd */
	ArgNReturn (TRUE);

    case AddG2FdLongE:
    case _AddG2FdLongE:
	XtentEAddG2FdLong (atoi (ArgN (0)),		/* fd   */
			XtentProcessArgN (display, 	/* release callback */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == AddG2FdLongE)));
	ArgNReturn (TRUE);

    case AnnounceE:
	XtentEAnnounce ( ArgN (0), 		/* service_name   */
			 atoi (ArgN (1)) ); 	/* max connects */
	ArgNReturn (TRUE);

    case AnnounceLongE:
    case _AnnounceLongE:
	XtentEAnnounceLong ( ArgN (0), 		/* service_name   */
			     atoi (ArgN (1)), 	/* max connects */
		XtentProcessArgN (display, 	/* connect callback */
				toplevel_ptr,
				&frame_data, 2,
			    (op -> type == AnnounceLongE)),
		XtentProcessArgN (display, 	/* release callback */
				toplevel_ptr,
				&frame_data, 3,
			    (op -> type == AnnounceLongE)) );
	ArgNReturn (TRUE);

    case  AtExitE:
    case  _AtExitE:
	XtentEAtExit ( XtentProcessArgN (display, 
					toplevel_ptr,
					&frame_data, -1,
				    (op -> type == AtExitE)));
	ArgNReturn (TRUE);

    case BlockE:
	XtentEBlock ( atoi (ArgN (-1)) ); 	/* fd */
	ArgNReturn (TRUE);

    case  CancelTimersE:
	XtentECancelTimers (ArgN (-1));		/* tag */
	ArgNReturn (TRUE);

    case  ClearTraceE:
	XtentEClearTrace (ArgN (-1));
	ArgNReturn (TRUE);

    case ConnectE:
	XtentEConnect ( ArgN (0), 		/* service_name   */
			atoi (ArgN (1)) ); 	/* timeout_value */
	ArgNReturn (TRUE);

    case ConnectLongE:
    case _ConnectLongE:
	XtentEConnectLong ( ArgN (0),    	/* service_name   */
			    atoi (ArgN (1)), 	/* timeout_value */
			    ArgN (2), 		/* passwd */
		XtentProcessArgN (display, 	/* connect callback */
				toplevel_ptr,
				&frame_data, 3,
			    (op -> type == ConnectLongE)),
		XtentProcessArgN (display, 	/* release callback */
				toplevel_ptr,
				&frame_data, 4,
			    (op -> type == ConnectLongE)) );
	ArgNReturn (TRUE);

    case  ErrorE:
	XtentEError (ArgN (-1));
	ArgNReturn (TRUE);

    case ExitE:
	XtentEExit ( atoi (ArgN (-1)) ); 	/* exitCode */
	ArgNReturn (TRUE);

    case  FatalE:
	XtentEFatal (atoi (ArgN (0)), 		/* exitCode   */
		       ArgN (1)); 		/* error message */
	ArgNReturn (TRUE);

    case  FyiE:
	XtentEFyi (ArgN (-1));
	ArgNReturn (TRUE);

    case InitE:
    {
	register int i;
	static int argc;
	static char *argv[99];

	argc = XtentArgc();
	for ( i = 0; i < argc; i++ )
		argv[i] = XtentArgv(i);

	argc = XtentEInit(argc, argv, 
		XtentToplevel (display, toplevel_ptr));
	if ( argc != -1 )
		XtentStoreArgcArgv (argc, argv);

	e_initialized = True;

	ArgNReturn (TRUE);
    }

    case  LogE:
	XtentELog(ArgN (-1));
	ArgNReturn (TRUE);

    case  LogMsgE:
	XtentELogMsg(ArgN (-1));
	ArgNReturn (TRUE);

    case  MsgEvalE:
	XtentEMsgEval (atoi (ArgN (0)), 	/* fd   */
		       ArgN (1)); 		/* g2 message name */
	ArgNReturn (TRUE);

    case  PutE:
	XtentEPut (atoi (ArgN (0)), 	/* fd   */
		      ArgN (1)); 	/* message string */
	ArgNReturn (TRUE);

    case  PutMsgE:
	XtentEPutMsg (atoi (ArgN (0)), 	/* fd   */
		      ArgN (1)); 	/* g2 message name */
	ArgNReturn (TRUE);

    case  ReleaseE:
	XtentERelease (atoi (ArgN (-1)));
	ArgNReturn (TRUE);

    case  ResetHiWaterE:
	XtentEResetHiWater (atoi (ArgN (0)), 	/* fd   */
			    atoi (ArgN (1))); 	/* hi water mark */
	ArgNReturn (TRUE);

    case  RemoveAllChanCbsE:
	XtentERemoveAllChanCbs (atoi (ArgN (-1))); 	/* fd   */
	ArgNReturn (TRUE);

    case  RemoveAllMsgCbsE:
	XtentERemoveAllMsgCbs (ArgN (-1)); 	/* msgname   */
	ArgNReturn (TRUE);

    case  RemoveChanCbE:
    {
	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	XtentERemoveChanCb (atoi (ArgN (0)),	/* fd   */
			   val_ptr,		/* unexpanded xtent cb */
			   arg_ptr);		/* expanded xtent cb */

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (TRUE);
    }
 
    case  RemoveMsgCbE:
    {
	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				False);
	arg_ptr = XtentConvertEmbeddedNames (display, toplevel_ptr, val_ptr);

	XtentERemoveMsgCb (ArgN (0),                    /* msgname   */
			   val_ptr,		/* unexpanded xtent cb */
			   arg_ptr);		/* expanded xtent cb */

	if (arg_ptr != val_ptr)
	    XtFree (arg_ptr);

	ArgNReturn (TRUE);
    }


    case  SetChanCbE:
    case  _SetChanCbE:
    {
	int expanded;
 
	if (op -> type == _SetChanCbE)
	    expanded = False;
	else
	    expanded = True;
 
	XtentESetChanCb (atoi (ArgN (0)),		/* fd   */
			XtentProcessArgN (display, 	/* xtent cb */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == SetChanCbE)),
			expanded);			/* code expansion */
	ArgNReturn (TRUE);
    }

    case  SetClientConnectCbE:
    case  _SetClientConnectCbE:
	XtentESetClientConnectCb ( XtentProcessArgN (display, 
					toplevel_ptr,
					&frame_data, -1,
				    (op -> type == SetClientConnectCbE)));
	ArgNReturn (TRUE);

    case  SetClientHiWaterCbE:
    case  _SetClientHiWaterCbE:
	XtentESetClientHiWaterCb (atoi (ArgN (0)), 	/* hi water mark */
				XtentProcessArgN (display, 	/* xtent cb */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == SetClientHiWaterCbE)));
	ArgNReturn (TRUE);

    case  SetFyiE:
    {
	int barg;

	arg_ptr = ArgN (-1);
	barg = ( atoi(arg_ptr) == 1 ) ? 1 : XtentTestTrue(arg_ptr);
	XtentESetFyi (barg);
	ArgNReturn (TRUE);
    }

    case  SetMsgCbE:
    case  _SetMsgCbE:
    {
	int expanded;
 
	if (op -> type == _SetMsgCbE)
	    expanded = False;
	else
	    expanded = True;

	XtentESetMsgCb (ArgN (0),  			/* msgname(g2)*/
			XtentProcessArgN (display, 	/* xtent cb */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == SetMsgCbE)),
			expanded);			/* code expansion */
	ArgNReturn (TRUE);
    }

    case  SetOrphanCbE:
    case  _SetOrphanCbE:
	XtentESetOrphanCb ( XtentProcessArgN (display, 
					toplevel_ptr,
					&frame_data, -1,
				    (op -> type == SetOrphanCbE)));
	ArgNReturn (TRUE);

    case  SetReleaseCbE:
    case  _SetReleaseCbE:
	XtentESetReleaseCb ( XtentProcessArgN (display, 
					toplevel_ptr,
					&frame_data, -1,
				    (op -> type == SetReleaseCbE)));
	ArgNReturn (TRUE);

    case  SetServerHiWaterCbE:
    case  _SetServerHiWaterCbE:
	XtentESetServerHiWaterCb (atoi (ArgN (0)), 	/* hi water mark */
				XtentProcessArgN (display, 	/* xtent cb */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == SetServerHiWaterCbE)));
	ArgNReturn (TRUE);

    case  SetSvcConnectCbE:
    case  _SetSvcConnectCbE:
	XtentESetServiceConnectCb ( XtentProcessArgN (display, 
					toplevel_ptr,
					&frame_data, -1,
				    (op -> type == SetSvcConnectCbE)));
	ArgNReturn (TRUE);

    case  SetTimerE:
    case  _SetTimerE:
	XtentESetTimer (ArgN (0), 			/* tag */
		        atoi (ArgN (1)),		/* time val */
			XtentProcessArgN (display, 	/* xtent cb */
				toplevel_ptr,
				&frame_data, 2,
			    (op -> type == SetTimerE)));
	ArgNReturn (TRUE);

    case  SetTraceE:
	XtentESetTrace (ArgN (-1));
	ArgNReturn (TRUE);

    case  SetWarningE:
    {
	int barg;

	arg_ptr = ArgN (-1);
	barg = ( atoi(arg_ptr) == 1 ) ? 1 : XtentTestTrue(arg_ptr);
	XtentESetWarning (barg);
	ArgNReturn (TRUE);
    }

    case  SyncCbE:
    case  _SyncCbE:
	XtentESyncCb (atoi (ArgN (0)),			/* fd   */
			XtentProcessArgN (display, 	/* callback code */
					toplevel_ptr,
					&frame_data, 1,
				    (op -> type == SyncCbE)));
	ArgNReturn (TRUE);

    case  TimedSyncCbE:
    case  _TimedSyncCbE:
	XtentETimedSyncCb (atoi (ArgN (0)),			/* fd   */
			   atoi (ArgN (1)),			/* timeOut */
			XtentProcessArgN (display, 	/* callback code */
					toplevel_ptr,
					&frame_data, 2,
				    (op -> type == TimedSyncCbE)));
	ArgNReturn (TRUE);


    case  TraceE:
	arg_ptr = ArgN (0);
	XtentETrace (*arg_ptr, 		/* trace letter   */
		     (ArgN (1))); 	/* message string */
	ArgNReturn (TRUE);

    case  TraceMsgE:
	arg_ptr = ArgN (0);
	XtentETraceMsg(*arg_ptr, 	/* trace letter  */ 
		       ArgN (1)); 	/* message name (g2 message) */
	ArgNReturn (TRUE);

    case UnBlockE:
	XtentEUnBlock ( atoi (ArgN (-1)) ); 	/* fd */
	ArgNReturn (TRUE);

    case  WarningE:
	XtentEWarning (ArgN (-1));
	ArgNReturn (TRUE);

    case WithdrawE:
	XtentEWithdraw ( ArgN (-1) );
	ArgNReturn (TRUE);
#endif   /* LIB_E */
/* RAD */

    case StrIndex:
	element = arg_ptr = ArgN (0);/* s */
	val_ptr = ArgN (1);		/* t */
	arg_count = strlen (val_ptr);
	for (; *arg_ptr; arg_ptr++)
	{
	    if (*arg_ptr == *val_ptr &&
		(strncmp (arg_ptr, val_ptr, arg_count) == 0))
	    {
		sprintf (copy_buffer, "%d", arg_ptr - element);
		XtentPutStringReturn (&db, ArgN (2), copy_buffer);
		ArgNReturn (True);
	    }
	}
	XtentPutStringReturn (&db, ArgN (2), "-1");
	ArgNReturn (True);

    case StrGSub:
    case StrSub:
    {
	/* RAD - regcomp had name collision with e func.  renamed */
	regexp * r = regComp (ArgN (0));/* r */
	char *buf = (char *) NULL;
	int buf_alloc_length = 0;
	int buf_length = 0;
	int length;

	arg_ptr = ArgN (1);	/* s */
	val_ptr = ArgN (2);	/* t */
	if (r)
	{
	    arg_count = 0;
	    do
	    {
		/* RAD - regexec had name collision with e func.  renamed */
		if (regExec (r, val_ptr) == 0)
		    break;
		length = r -> startp[0] - val_ptr;
		if (buf_length + length + 512 > buf_alloc_length)
		{
		    buf_alloc_length = buf_length + length + 1024;
		    buf = (char *) XtRealloc (buf, (Cardinal) buf_alloc_length);
		}
		strncpy (buf + buf_length, val_ptr, length);
		buf_length += length;
		/* RAD - regsub had name collision with e func.  renamed */
		regSub (r, arg_ptr, buf + buf_length);
		buf_length += strlen (buf + buf_length);
		val_ptr = r -> endp[0];
		arg_count++;
	    } while (op -> type == StrGSub && *val_ptr);
	    length = strlen (val_ptr);
	    if (buf_length + length + 1 > buf_alloc_length)
	    {
		buf_alloc_length = buf_length + length + 1;
		buf = (char *) XtRealloc (buf, (Cardinal) buf_alloc_length);
	    }
	    strcpy (buf + buf_length, val_ptr);
	    XtFree ((char *) r);
	    val_ptr = buf;
	}
	XtentXrmPutStringResource (&db, ArgN (3), val_ptr, 30);
	XtFree ((char *) buf);
	sprintf (copy_buffer, "%d", arg_count);
	XtentPutStringReturn (&db, ArgN (4), copy_buffer);
	ArgNReturn (True);
    }

    case StrLength:
	sprintf (copy_buffer, "%d", strlen (ArgN (0)));	/* s */
	XtentPutStringReturn (&db, ArgN (1), copy_buffer);
	ArgNReturn (True);

    case StrMatch:
    {
	regexp * r;

	val_ptr = ArgN (0);	/* s */
	r = regComp (ArgN (1));	/* r */
	if (r == (regexp *) NULL || regExec (r, val_ptr) == 0)
	{
	    XtentXrmPutStringResource (&db, ArgN (2), "-1", 30);
	    XtentXrmPutStringResource (&db, ArgN (3), "-1", 30);
	}
	else
	{
	    sprintf (copy_buffer, "%d", r -> startp[0] - val_ptr);
	    XtentXrmPutStringResource (&db, ArgN (2),
				       copy_buffer, 30);
	    sprintf (copy_buffer, "%d", r -> endp[0] - r -> startp[0]);
	    XtentXrmPutStringResource (&db, ArgN (3),
				       copy_buffer, 30);
	}
	XtFree ((char *) r);
	ArgNReturn (True);
    }

    case StrSplitToArgList: 	/* string, separator, return name */
	element = arg_ptr = ArgN (0);/* string */
	mark = *ArgN (1);		/* separator */
	i = strlen (arg_ptr);
	if (mark == '\0')
	{
	    arg_count = i;
	}
	else
	{
	    for (arg_count = 0; *arg_ptr; arg_ptr++)
	    {
		if (*arg_ptr == mark)
		    arg_count++;
	    }
	}
	arg_ptr = element;
	element = val_ptr = (char *) XtMalloc (i + arg_count * 2 + 1);
	if (mark == '\0')
	{
	    while (*arg_ptr)
	    {
		*val_ptr++ = *arg_ptr++;
		if (*arg_ptr)
		{
		    *val_ptr++ = ',';
		    *val_ptr++ = ' ';
		}
	    }
	}
	else
	{
	    while (*arg_ptr)
	    {
		*val_ptr++ = *arg_ptr;
		if (*arg_ptr++ == mark)
		{
		    *(val_ptr - 1) = ',';
		    *val_ptr++ = ' ';
		}
	    }
	}
	*val_ptr = '\0';
	XtentPutStringReturn (&db, ArgN (2), element);
	XtFree ((char *) element);
	ArgNReturn (True);

    case StrSplitToResource:
	element = arg_ptr = ArgN (0);/* string */
	mark = *ArgN (1);	/* separator */
	operation = ArgN (2);	/* resource name */
	i = atoi (ArgN (3));	/* starting index */
	j = arg_count = strlen (operation);
	colon = (char *) XtMalloc (j + 64);
	strcpy (colon, operation);
	if (mark == '\0')
	{
	    arg_count = strlen (arg_ptr);
	    copy_buffer[1] = '\0';
	    while (*arg_ptr)
	    {
		*copy_buffer = *arg_ptr++;
		sprintf (colon + j, "%d", i++);
		XtentXrmPutStringResource (&db, colon,
					   copy_buffer, 30);
	    }
	}
	else
	{
	    arg_count = 0;
	    while (*arg_ptr)
	    {
		if (*arg_ptr == mark)
		{
		    *arg_ptr = '\0';
		    sprintf (colon + j, "%d", i++);
		    XtentXrmPutStringResource (&db, colon,
					       element, 30);
		    *arg_ptr++ = mark;
		    element = arg_ptr;
		    arg_count++;
		}
		else
		    arg_ptr++;
	    }
	    if (element != arg_ptr)
	    {
		sprintf (colon + j, "%d", i++);
		XtentXrmPutStringResource (&db,  colon,
					   element, 30);
		arg_count++;
	    }
	}
	XtFree ((char *) colon);
	sprintf (copy_buffer, "%d", arg_count);
	XtentPutStringReturn (&db, ArgN (4), copy_buffer);
	ArgNReturn (True);

    case StrSubstr:
	arg_ptr = ArgN (0);
	i = atoi (ArgN (1));	/* start */
	if (i < 0)
	    i = 0;
	val_ptr = ArgN (2);		/* count */
	if (*val_ptr == '\0' ||
	    (j = atoi (val_ptr)) == -1)
	    j = strlen (arg_ptr) - i;
	if (j < 0)
	    j = 0;
	element = val_ptr = (char *) XtMalloc (1 + j);
	for (arg_count = 0; arg_count < i; arg_count++)
	    if (*arg_ptr)
		arg_ptr++;
	j += i;
	for (arg_count = i; arg_count < j; arg_count++)
	{
	    *val_ptr++ = *arg_ptr;
	    if (*arg_ptr)
		arg_ptr++;
	}
	*val_ptr = '\0';
	XtentPutStringReturn (&db, ArgN (3), element);
	XtFree ((char *) element);
	ArgNReturn (True);


    case FClose:		/* XtFclose: (file-descriptor) */
    case PClose:
    {
	FileDescriptor *file, *prev;

	arg_ptr = ArgN (-1);
	file = XtentFileDescriptors;
	prev = (FileDescriptor *) NULL;
	while (file)
	{
	    if (strcmp (file -> name, arg_ptr) == 0)
	    {
		if (op -> type == PClose)
		    i = XtentEnvPClose (file -> fp);
		else
		    i = fclose (file -> fp);

		if (i == 0)
		    val_ptr = "True";
		else
		    val_ptr = "False";

		if (prev)
		    prev -> next = file -> next;
		else
		    XtentFileDescriptors = file -> next;

		XtFree ((char *)file); /* RAD */

		XtentPutStringReturn (&db, ArgN (1), val_ptr);
		ArgNReturn (True);
	    }
	    prev = file;
	    file = file -> next;
	}
	XtentPutStringReturn (&db, ArgN (1), "False");
	ArgNReturn (True);
    }

    case FFlush:
    {
	FileDescriptor *file;
	FILE *fp;

	arg_ptr = ArgN (-1);
	fp = (FILE *) NULL;
	if (strcmp (arg_ptr, "stdout") == 0)
	    fp = stdout;
	else if (strcmp (arg_ptr, "stderr") == 0)
	    fp = stderr;
	else
	{
	    file = XtentFileDescriptors;
	    while (file)
	    {
		if (file -> permission & XtentWritable &&
		    strcmp (file -> name, arg_ptr) == 0)
		{
		    fp = file -> fp;
		    break;
		}
	    }
	    file = file -> next;
	}
	if (fp == (FILE *) NULL)
	    i = EOF;
	else
	    i = fflush (fp);
	XtentPutStringReturn (&db, ArgN (1),
			      ((i == 0) ? "True" : "False"));
	ArgNReturn (True);
    }

    case FOpen:		/* XtFopen: (file-name, read/write, return-key) */
    case POpen:
    {
	FileDescriptor *file;

	arg_ptr = ArgN (0);
	i = strlen (arg_ptr);
	val_ptr = ArgN (1);
	j = strlen (val_ptr);
	file = (FileDescriptor *) XtMalloc (sizeof (FileDescriptor) +
					    1 + i + 1 + j + 1 + 16);

	file -> permission = (unsigned char) NULL;
	if (*val_ptr == 'r')
	{
	    if (val_ptr[1] == '+')
		file -> permission = XtentReadable | XtentWritable;
	    else if (val_ptr[1] == '\0')
		file -> permission = XtentReadable;
	}
	else if (*val_ptr == 'w')
	{
	    if (val_ptr[1] == '+')
		file -> permission = XtentWritable;
	    else if (val_ptr[1] == '\0')
		file -> permission = XtentWritable;
	}
	else if (*val_ptr == 'a')
	{
	    if (val_ptr[1] == '+')
		file -> permission = XtentWritable;
	    else if (val_ptr[1] == '\0')
		file -> permission = XtentWritable;
	}

	if (file -> permission)
	{
	    if (op -> type == POpen)
		file -> fp = XtentEnvPOpen (arg_ptr, val_ptr);
	    else
		file -> fp = fopen (arg_ptr, val_ptr);
	}

	if (file -> permission == (unsigned char) NULL ||
	    file -> fp == (FILE *) NULL)
	{
	    XtFree ((char *) file);
	    XrmPutLineResource (&db, frame_data.buffer);

	    XtentPutStringReturn (&db, ArgN (2), "False");

	    ArgNReturn (False);
	}
	sprintf (file -> name, "(%s:%s:%d)", arg_ptr, val_ptr,
		 fileno (file -> fp));

	XtentPutStringReturn (&db, ArgN (2), file -> name);

	file -> next = XtentFileDescriptors;
	XtentFileDescriptors = file;

	ArgNReturn (True);
    }

    case FGetS:		/* XtFGetS: (return-string, size, stream, eof) */
    {
	FileDescriptor *file;
	FILE *fp;
	char buf[BUFSIZ];

	val_ptr = ArgN (0);
	i = atoi (ArgN (1));
	arg_ptr = ArgN (2);
	if (i < 1)
	{
	    XtentPutStringReturn (&db, val_ptr, "");
	    ArgNReturn (True);
	}

	fp = (FILE *) NULL;
	if (strcmp (arg_ptr, "stdin") == 0)
	    fp = stdin;
	else
	{
	    file = XtentFileDescriptors;
	    while (file)
	    {
		if (strcmp (file -> name, arg_ptr) == 0)
		{
		    if (file -> permission & XtentReadable)
		    {
			fp = file -> fp;
			break;
		    }
		    XtentPutStringReturn (&db, val_ptr, "");
		    ArgNReturn (True);
		}
		file = file -> next;
	    }
	    if (fp == (FILE *) NULL)
	    {
		XtentPutStringReturn (&db, val_ptr, "");
		ArgNReturn (True);
	    }
	}

	if (i <= BUFSIZ)
	    arg_ptr = buf;
	else
	    arg_ptr = (char *) XtMalloc (i);

	element = fgets (arg_ptr, i, fp);

	XtentXrmPutStringResource (&db,  val_ptr, arg_ptr, 30);
	if (arg_ptr != buf)
	    XtFree (arg_ptr);

	XtentXrmPutStringResource (&db,  ArgN (3),
				   (element == (char *) NULL) ?
				   "True" : "False", 30);
	ArgNReturn (True);
    }

    case FPrintF:		/* XtFPrintF: (file, format, arg0, ...) */
    case SPrintF:		/* XtSPrintF: (ret-var, format, arg0, ...) */
    {
	FileDescriptor *file;
	FILE *fp;
	char *format;
	char *format_ptr;
	double x;
	char *sbuffer;
	int sbuffer_length;
	char *sb_start, *sb_end;
	char c;
	int precision;
	int found_precision_dot;

	arg_ptr = ArgN (0);
	format = ArgN (1);
	if (*format == '\0')
	    ArgNReturn (True);

	if (op -> type == FPrintF)
	{
	    fp = (FILE *) NULL;
	    if (strcmp (arg_ptr, "stdout") == 0)
		fp = stdout;
	    else if (strcmp (arg_ptr, "stderr") == 0)
		fp = stderr;
	    else
	    {
		file = XtentFileDescriptors;
		while (file)
		{
		    if (strcmp (file -> name, arg_ptr) == 0)
		    {
			if (file -> permission & XtentWritable)
			{
			    fp = file -> fp;
			    break;
			}
			ArgNReturn (True);
		    }
		    file = file -> next;
		}
		if (fp == (FILE *) NULL)
		    ArgNReturn (True);
	    }
	}
	else
	{
	    sbuffer = (char *) XtMalloc (256);
	    sbuffer_length = 256;
	    sb_start = sbuffer;
	    sb_end = sb_start + 256;
	}

	format_ptr = format;
	arg_count = 2;
	while (*format)
	{
	    if (*format++ == '%')
	    {
		precision = 0;
		found_precision_dot = False;

		for (;;)
		    switch (c = *format++)
		    {
		    case '%':
			mark = *format;
			*format = '\0';
			if (op -> type == FPrintF)
			    fprintf (fp, format_ptr);
			else
			{
			    XtentCheckSprintfSize (precision +
						   (format - format_ptr),
						   &sbuffer,
						   &sbuffer_length,
						   &sb_start,
						   &sb_end);
			    sprintf (sb_start, format_ptr);
			    sb_start += strlen (sb_start);
			}
			goto DonePercent;

		    case 'u':
			if (*format == 'd' || *format == 'i')
			    format++;
		    case 'd':
		    case 'i':
		    case 'o':
		    case 'x':
		    case 'X':
			i = atoi (ArgN (arg_count++));
			mark = *format;
			*format = '\0';
			if (op -> type == FPrintF)
			    fprintf (fp, format_ptr, i);
			else
			{
			    if (precision == 0)
				precision = 16;
			    XtentCheckSprintfSize (precision +
						   (format - format_ptr),
						   &sbuffer,
						   &sbuffer_length,
						   &sb_start,
						   &sb_end);
			    sprintf (sb_start, format_ptr, i);
			    sb_start += strlen (sb_start);
			}
			goto DonePercent;

		    case 'c':
			val_ptr = ArgN (arg_count++);
			mark = *format;
			*format = '\0';
			if (op -> type == FPrintF)
			    fprintf (fp, format_ptr, *val_ptr);
			else
			{
			    if (precision == 0)
				precision = 2;
			    XtentCheckSprintfSize (precision +
						   (format - format_ptr),
						   &sbuffer,
						   &sbuffer_length,
						   &sb_start,
						   &sb_end);
			    sprintf (sb_start, format_ptr, *val_ptr);
			    sb_start += strlen (sb_start);
			}
			goto DonePercent;

		    case 's':
			val_ptr = ArgN (arg_count++);
			mark = *format;
			*format = '\0';
			if (op -> type == FPrintF)
			    fprintf (fp, format_ptr, val_ptr);
			else
			{
			    XtentCheckSprintfSize (precision +
						   (format - format_ptr),
						   &sbuffer,
						   &sbuffer_length,
						   &sb_start,
						   &sb_end);
			    sprintf (sb_start, format_ptr, val_ptr);
			    sb_start += strlen (sb_start);
			}
			goto DonePercent;

		    case 'f':
		    case 'e':
		    case 'E':
		    case 'g':
		    case 'G':
			x = atof (ArgN (arg_count++));
			mark = *format;
			*format = '\0';
			if (op -> type == FPrintF)
			    fprintf (fp, format_ptr, x);
			else
			{
			    if (precision == 0)
				precision = 64;
			    XtentCheckSprintfSize (precision +
						   (format - format_ptr),
						   &sbuffer,
						   &sbuffer_length,
						   &sb_start,
						   &sb_end);
			    sprintf (sb_start, format_ptr, x);
			    sb_start += strlen (sb_start);
			}
			goto DonePercent;

		    case '\0':
			mark = *format;
			format--;
			goto DonePercent;

		    case '.':
			found_precision_dot = True;
			continue;

		    default:
			if (found_precision_dot == False &&
			    c >= '0' && c <= '9')
			    precision = precision * 10 + (c - '0');
			continue;

		    }
	DonePercent:
		*format = mark;
		format_ptr = format;
	    }
	}
	if (format_ptr != format)
	{
	    if (op -> type == FPrintF)
		fprintf (fp, format_ptr);
	    else
	    {
		XtentCheckSprintfSize (precision +
				       (format - format_ptr),
				       &sbuffer,
				       &sbuffer_length,
				       &sb_start,
				       &sb_end);
		sprintf (sb_start, format_ptr);
		sb_start += strlen (sb_start);
	    }
	}
	if (op -> type == SPrintF)
	{
	    XtentPutStringReturn (&db, arg_ptr, sbuffer);
	    XtFree (sbuffer);
	}
	ArgNReturn (True);
    }

    case StatF:			/* (file, success, mode, size) */
    {
	struct stat stat_buf;
	long mode;

	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0')
	    i = 1;
	else
	{
	    memset (&stat_buf, '\0', sizeof (stat_buf));
	    i = stat (arg_ptr, &stat_buf);
	}

	if (i == 0)
	{
	    mode = stat_buf.st_mode & 07;
	    if (getegid () == stat_buf.st_gid)
		mode |= ((stat_buf.st_mode >> 3) & 07);
	    if (geteuid () == stat_buf.st_uid)
		mode |= ((stat_buf.st_mode >> 6) & 07);
	    mode |= (stat_buf.st_mode & (~0777));
	}
	else
	{
	    mode = 0;
	    stat_buf.st_size = 0;
	}

	XtentXrmPutStringResource (&db, ArgN (1),
				   XtentCalcTrueOrFalseString (i == 0), 30);

	sprintf (copy_buffer, "%d", mode);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	sprintf (copy_buffer, "%d", stat_buf.st_size);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);

	ArgNReturn (True);
    }

#ifdef ATHENA
    case XAWListChange: /* (longest, resize, a, b, c, ...) */
    {
	int array_size = 0;
	char **array = (char **) NULL;
	int longest = atoi (ArgN (0));
	int resize = XtentTestTrue (ArgN (1));
	
	/*
	 * collect the arguments
	 */
	i = 0;
	arg_count = 2;
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;
	
	    if (i >= (array_size - 1))
	    {
		array_size += 8;
		array = (char **) XtRealloc ((char *) array, 
				(Cardinal) sizeof (char *) * array_size);
		for (j = i; j < array_size; j++)
		    array[j] = (char *) NULL;
	    }
	    array[i] = XtNewString (arg_ptr);
	    i++;
	}

	if (i == 0)
	    ArgNReturn (True);

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	XawListChange (w, array, i, longest, resize);

	XtAddCallback (w, XtNdestroyCallback,
		       (XtCallbackProc) XtentScrollbarDestroyProc,
		       (XtPointer) array);

	ArgNReturn (True);
    }

    case XAWListHighlight:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawListHighlight (w, atoi (ArgN (-1)));
	ArgNReturn (True);

    case XAWListUnhighlight:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawListUnhighlight (w);
	ArgNReturn (True);

    case XAWListShowCurrent:		/* (string, list_index) */
    {
	XawListReturnStruct *list_item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	list_item = XawListShowCurrent (w);
	if (list_item -> list_index == XAW_LIST_NONE)
	    list_item -> string = "None";
	XtentXrmPutStringResource (&db, ArgN (0), list_item -> string, 30);
	sprintf (copy_buffer, "%d", list_item -> list_index);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	ArgNReturn (True);
    }

    case XAWScrollbarSetThumb:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawScrollbarSetThumb (w, atof (ArgN (0)), atof (ArgN (1)));
	ArgNReturn (True);

    case XAWStripChartAddValueProc:
    case _XAWStripChartAddValueProc:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, -1,
				    op -> type == XAWStripChartAddValueProc);
	arg_ptr = XtNewString (arg_ptr);

	XtAddCallback (w, XtNgetValue,
		       (XtCallbackProc) XtentStripChartGetValueProc,
		       (XtPointer) arg_ptr);
	XtAddCallback (w, XtNdestroyCallback,
		       (XtCallbackProc) XtentStripChartDestroyProc,
		       (XtPointer) arg_ptr);
	ArgNReturn (True);

    case XAWToggleChangeRadioGroup:
    {
	Widget radio_group;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	arg_ptr = ArgN (-1);
	if (*arg_ptr == '\0')
	    radio_group = (Widget) NULL;
	else
	    radio_group = XtentNameToWidget (arg_ptr);

	XawToggleChangeRadioGroup (w, radio_group);
	ArgNReturn (True);
    }

    case XAWToggleGetCurrent:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	arg_ptr = (char *) XawToggleGetCurrent (w);
	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	ArgNReturn (True);

    case XAWToggleSetCurrent:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawToggleSetCurrent (w, ArgN (-1));
	ArgNReturn (True);

    case XAWToggleUnsetCurrent:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawToggleUnsetCurrent (w);
	ArgNReturn (True);

    case XAWSimpleMenuAddGlobalActions:
	XawSimpleMenuAddGlobalActions (XtWidgetToApplicationContext
				       (XtentToplevel (display,
						       toplevel_ptr)));
	ArgNReturn (True);

    case XAWSimpleMenuGetActiveEntry:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	w = XawSimpleMenuGetActiveEntry (w);
	XtentPutStringReturn (&db, ArgN (-1),
			      ((w) ? XtentWidgetToName (w) : "None"));
	ArgNReturn (True);

    case XAWSimpleMenuClearActiveEntry:	/* defined incorrectly in the doc */
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawSimpleMenuClearActiveEntry (w);
	ArgNReturn (True);

    case XAWTextSetSelection:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextSetSelection (w, (XawTextPosition) atol (ArgN (0)),
			     (XawTextPosition) atol (ArgN (1)));
	ArgNReturn (True);

    case XAWTextUnsetSelection:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextUnsetSelection (w);
	ArgNReturn (True);

    case XAWTextGetSelectionPos:
    {
	XawTextPosition begin, end;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextGetSelectionPos (w, &begin, &end);
	sprintf (copy_buffer, "%ld", (long) begin);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%ld", (long) end);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	ArgNReturn (True);
    }

    case XAWTextReplace:	/* (start, end, string, return_string) */
    {
	XawTextPosition begin = (XawTextPosition) atol (ArgN (0));
	XawTextPosition end = (XawTextPosition) atol (ArgN (1));
	XawTextBlock text;
	char *ptr;

	text.firstPos = 0;
	text.ptr = ArgN (2);
	text.length = strlen (text.ptr);
	text.format = FMT8BIT;

	if (text.length)
	{
	    w = _xtentNameToWidget (display, toplevel_ptr,
				    buffer, operation,
				    string_one, parse_quarks, parse_bindings,
				    field_count);
	    i = XawTextReplace (w, begin, end, &text);
	}
	ptr = "None";
	if (i == XawEditDone)
	    ptr = "XawEditDone";
	else if (i == XawPositionError)
	    ptr = "XawPositionError";
	else if (i == XawEditError)
	    ptr = "XawEditError";

	XtentPutStringReturn (&db, ArgN (3), ptr);

	ArgNReturn (True);
    }

    case XAWTextSearch:		/* (direction, string, return_position) */
    {
	XawTextScanDirection direction;
	XawTextBlock text;
	XawTextPosition position;

	arg_ptr = ArgN (0);
	direction = XawsdRight;
	if (strcmp (arg_ptr, "XawsdLeft") == 0)
	    direction = XawsdLeft;
	text.firstPos = 0;
	text.ptr = ArgN (1);
	text.length = strlen (text.ptr);
	text.format = FMT8BIT;
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	position = XawTextSearch (w, direction, &text);

	sprintf (copy_buffer, "%ld", (long) position);
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);

	ArgNReturn (True);
    }

    case XAWTextInvalidate:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextInvalidate (w, (XawTextPosition) atol (ArgN (0)),
			   (XawTextPosition) atol (ArgN (1)));
	ArgNReturn (True);

    case XAWTextEnableRedisplay:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextEnableRedisplay (w);
	ArgNReturn (True);

    case XAWTextDisableRedisplay:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextDisableRedisplay (w);
	ArgNReturn (True);

    case XAWTextDisplay:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextDisplay (w);
	ArgNReturn (True);

    case XAWTextTopPosition:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	sprintf (copy_buffer, "%ld", (long) XawTextTopPosition (w));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);

    case XAWTextSetSelectionArray:
    {
	int array_size = 0;
	XawTextSelectType *array = (XawTextSelectType *) NULL;

	/*
	 * collect the arguments
	 */
	i = 0;
	arg_count = 0;
	for (;;)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;
	
	    if (i >= (array_size - 1))
	    {
		array_size += 16;
		array = (XawTextSelectType *)
		    XtRealloc ((char *) array, 
			       (Cardinal) sizeof (XawTextSelectType *) *
			       array_size);
	    }

	    if (strcmp (arg_ptr, "XawselectPosition") == 0)
		array[i] = XawselectPosition;
	    else if (strcmp (arg_ptr, "XawselectChar") == 0)
		array[i] = XawselectChar;
	    else if (strcmp (arg_ptr, "XawselectWord") == 0)
		array[i] = XawselectWord;
	    else if (strcmp (arg_ptr, " XawselectLine") == 0)
		array[i] =  XawselectLine;
	    else if (strcmp (arg_ptr, "XawselectParagraph") == 0)
		array[i] = XawselectParagraph;
	    else if (strcmp (arg_ptr, "XawselectAll") == 0)
		array[i] = XawselectAll;
	    else
		array[i] = XawselectNull;

	    i++;
	}
	array[i] = XawselectNull;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	XawTextSetSelectionArray (w, array);
	XtFree ((char *) array);

	ArgNReturn (True);
    }

    case XAWTextSetInsertionPoint:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextSetInsertionPoint (w, (XawTextPosition) atol (ArgN (-1)));
	ArgNReturn (True);

    case XAWTextGetInsertionPoint:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	sprintf (copy_buffer, "%ld", (long) XawTextGetInsertionPoint (w));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

    case XAWTextSetSource:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	arg_ptr = ArgN (0);
	XawTextSetSource (w, XtentNameToWidget (arg_ptr),
			  (XawTextPosition) atol (ArgN (1)));
	ArgNReturn (True);

    case XAWTextGetSource:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	w = XawTextGetSource (w);
	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));
	ArgNReturn (True);

    case XAWTextDisplayCaret:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTextDisplayCaret (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case XAWAsciiSourceFreeString:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawAsciiSourceFreeString (w);
	ArgNReturn (True);

    case XAWAsciiSave:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      XtentCalcTrueOrFalseString (XawAsciiSave (w)));
	ArgNReturn (True);

    case XAWAsciiSaveAsFile:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	val_ptr = ArgN (0);
	arg_ptr = ArgN (1);
	XtentPutStringReturn (&db, arg_ptr,
	      XtentCalcTrueOrFalseString (XawAsciiSaveAsFile (w, val_ptr)));
	ArgNReturn (True);

    case XAWAsciiSourceChanged:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
		XtentCalcTrueOrFalseString (XawAsciiSourceChanged (w)));
	ArgNReturn (True);

    case XAWDialogGetValueString:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      (char *) XawDialogGetValueString (w));
	ArgNReturn (True);

    case XAWFormDoLayout:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawFormDoLayout (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case XAWPanedAllowResize:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawPanedAllowResize (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case XAWPanedSetMinMax:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawPanedSetMinMax (w, atoi (ArgN (0)), atoi (ArgN (1)));
	ArgNReturn (True);

    case XAWPanedGetMinMax:
    {
	int min, max;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawPanedGetMinMax (w, &min, &max);

	sprintf (copy_buffer, "%d", min);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", max);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XAWPanedSetRefigureMode:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawPanedSetRefigureMode (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case XAWPanedGetNumSub:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	sprintf (copy_buffer, "%d", XawPanedGetNumSub (w));
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);

#if XT_REVISION > 4
    case XAWTreeForceLayout:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XawTreeForceLayout (w);
	ArgNReturn (True);
#endif

#endif /* ATHENA */

#ifdef MOTIF
    case XMActivateProtocol:	/* (property-atom, protocol-atom) */
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmActivateProtocol (w, XtentStringToAtom (display, ArgN (0)),
			    XtentStringToAtom (display, ArgN (1)));

	ArgNReturn (True);
    }

    case XMActivateWMProtocol:	/* (protocol-atom) */
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmActivateWMProtocol (w, XtentStringToAtom (display, ArgN (-1)));

	ArgNReturn (True);
    }

    case XMAddProtocols:
    case XMAddWMProtocols:
    case XMRemoveProtocols:
    case XMRemoveWMProtocols:
    {
	Atom *atom_list = (Atom *) NULL;
	int list_size = 0;
	Atom property;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMAddProtocols || op -> type == XMRemoveProtocols)
	{
	    property = XtentStringToAtom (display, ArgN (0));
	    arg_count = 1;
	}
	else
	    arg_count = 0;

	for (i = 0; True; i++)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (i == list_size)
	    {
		list_size += 8;
		atom_list = (Atom *) XtRealloc ((char *) atom_list,
						 sizeof (Atom *) * list_size);
	    }
	    atom_list[i] = XtentStringToAtom (display, arg_ptr);
	}

	switch (op -> type)
	{
	case XMAddProtocols:
	    XmAddProtocols (w, property, atom_list, i);
	    break;
	case XMAddWMProtocols:
	    XmAddWMProtocols (w, atom_list, i);
	    break;
	case XMRemoveProtocols:
	    XmRemoveProtocols (w, property, atom_list, i);
	    break;
	case XMRemoveWMProtocols:
	    XmRemoveWMProtocols (w, atom_list, i);
	    break;
	}

	XtFree ((char *) atom_list);
	ArgNReturn (True);
    }

    case XMAddTabGroup:		/* obsolete */
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmAddTabGroup (w);

	ArgNReturn (True);
    }

    case XMCascadeButtonGadgetHighlight:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCascadeButtonGadgetHighlight (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMCascadeButtonHighlight:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCascadeButtonHighlight (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMChangeColor:		/* (color) */
    {
	XrmValue from_value, to_value;
	Pixel pixel;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	
	arg_ptr = ArgN (-1);
	from_value.size = strlen (arg_ptr);
	from_value.addr = arg_ptr;
	to_value.size = 0;
	to_value.addr = (XtPointer) NULL;
	
	_XtConvert (w, XtQString, &from_value,
		    XtQPixel, &to_value, NULL);
	
	if (to_value.size && to_value.addr)
	{
	    pixel = *((Pixel *) to_value.addr);
	    XmChangeColor (w, pixel);
	}

	ArgNReturn (True);
    }

    case XMClipboardCancelCopy:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardCancelCopy (display, XtWindow (w), atol (ArgN (0)));

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardFail";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    /*
     * needs work?
     */
    case XMClipboardCopy:
    {
	long data_id = 0;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (2);
	if (*arg_ptr == '\0')
	{
	    arg_ptr = (char *) NULL;
	    j = 0;
	}
	else
	    j = strlen (arg_ptr);

	i = XmClipboardCopy (display, XtWindow (w),
			     atol (ArgN (0)),        /* item_id */
			     ArgN (1),               /* format_name */
			     arg_ptr,                /* buffer */
			     j,
			     (long) 0,               /* private_id */
			     &data_id);              /* data_id */

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else 	if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardFail";

	XtentPutStringReturn (&db, ArgN (3), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardCopyByName:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (1);
	i = XmClipboardCopyByName (display, XtWindow (w),
				   atol (ArgN (0)),        /* data_id */
				   arg_ptr,                /* buffer */
				   strlen (arg_ptr),
				   (long) 0);               /* private_id */

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardFail";

	XtentPutStringReturn (&db, ArgN (2), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardEndCopy:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardEndCopy (display, XtWindow (w),
				atol (ArgN (0)));        /* data_id */

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardFail";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardEndRetrieve:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardEndRetrieve (display, XtWindow (w));

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else
	    arg_ptr = "ClipboardLocked";

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardInquireCount:
    {
	int count;
	unsigned long max_format_name_length;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardInquireCount (display, XtWindow (w), &count,
				     &max_format_name_length);

	sprintf (copy_buffer, "%d", count);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", max_format_name_length);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardNoData";

	XtentXrmPutStringResource (&db, ArgN (2), arg_ptr, 30);

	ArgNReturn (True);
    }

    case XMClipboardInquireFormat:
    {
	unsigned long copied_len;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardInquireFormat (display, XtWindow (w),
				      atoi (ArgN (0)), /* index */
				      (XtPointer) copy_buffer,
				      (unsigned long) 32,
				      &copied_len);

	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", copied_len);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else if (i == ClipboardTruncate)
	    arg_ptr = "ClipboardTruncate";
	else
	    arg_ptr = "ClipboardNoData";

	XtentXrmPutStringResource (&db, ArgN (3), arg_ptr, 30);

	ArgNReturn (True);
    }

    case XMClipboardInquireLength:
    {
	unsigned long length;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	i = XmClipboardInquireLength (display, XtWindow (w),
				      arg_ptr, &length);

	sprintf (copy_buffer, "%d", length);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else if (i == ClipboardTruncate)
	    arg_ptr = "ClipboardTruncate";
	else
	    arg_ptr = "ClipboardNoData";

	XtentXrmPutStringResource (&db, ArgN (2), arg_ptr, 30);

	ArgNReturn (True);
    }

    /*
     * needs work
     */
    case XMClipboardInquirePendingItems:
    {
	unsigned long length;
	XmClipboardPendingList item_list;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	i = XmClipboardInquirePendingItems (display, XtWindow (w),
					    arg_ptr,
					    &item_list, &length);

	sprintf (copy_buffer, "%d", length);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else
	    arg_ptr = "ClipboardLocked";

	XtentXrmPutStringResource (&db, ArgN (2), arg_ptr, 30);

	ArgNReturn (True);
    }

    case XMClipboardLock:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardLock (display, XtWindow (w));

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else
	    arg_ptr = "ClipboardLocked";

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardRegisterFormat:
    {
	arg_ptr = ArgN (0);
	i = XmClipboardRegisterFormat (display, arg_ptr, strlen (arg_ptr));

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	if (i == ClipboardBadFormat)
	    arg_ptr = "ClipboardBadFormat";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardFail";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardRetrieve:
    {
	unsigned long num_bytes;
	long private_id;
	char *ret_buf;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);	/* format_name */
	val_ptr = ArgN (1);	/* buffer name */
	j = atoi (ArgN (2));	/* buffer length */

	ret_buf = XtMalloc (j);

	i = XmClipboardRetrieve (display, XtWindow (w),
				 arg_ptr,
				 (XtPointer) ret_buf,
				 (unsigned long)j,
				 &num_bytes,
				 &private_id);

	sprintf (copy_buffer, "%d", num_bytes);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	sprintf (copy_buffer, "%d", private_id);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);

	if (i == ClipboardSuccess)
	    arg_ptr = "ClipboardSuccess";
	else if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else if (i == ClipboardTruncate)
	    arg_ptr = "ClipboardTruncate";
	else
	    arg_ptr = "ClipboardNoData";

	XtentXrmPutStringResource (&db, ArgN (5), arg_ptr, 30);

	XtFree ((char *) ret_buf);

	ArgNReturn (True);
    }

    /*
     * needs work
     */
    case XMClipboardStartCopy:
    {
	XmString clip_label;
	long item_id;
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	clip_label = XmStringCreateLocalized (ArgN (0));

	val_ptr = ArgN (1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	i = XmClipboardStartCopy (display, XtWindow (w),
				  clip_label, timestamp, w,
				  (XmCutPasteProc) XtentXmCutPasteProc,
				  &item_id);

	XmStringFree (clip_label);

	if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardSuccess";

	XtentXrmPutStringResource (&db, ArgN (2), arg_ptr, 30);

	ArgNReturn (True);
    }

    case XMClipboardStartRetrieve:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (0);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	i = XmClipboardStartRetrieve (display, XtWindow (w), timestamp);

	if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardSuccess";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardUndoCopy:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardUndoCopy (display, XtWindow (w));

	if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardSuccess";

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardUnlock:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardUnlock (display, XtWindow (w),
			       XtentTestTrue (ArgN (0)));

	if (i == ClipboardFail)
	    arg_ptr = "ClipboardFail";
	else
	    arg_ptr = "ClipboardSuccess";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    case XMClipboardWithdrawFormat:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmClipboardWithdrawFormat (display, XtWindow (w),
				       atol (ArgN (0)));

	if (i == ClipboardLocked)
	    arg_ptr = "ClipboardLocked";
	else
	    arg_ptr = "ClipboardSuccess";

	XtentPutStringReturn (&db, ArgN (1), arg_ptr);

	ArgNReturn (True);
    }

    case XMCommandAppendValue:
    case XMCommandError:
    case XMCommandSetValue:
    {
	XmString command;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	command = XmStringCreateLocalized (ArgN (-1));

	if (op -> type == XMCommandError)
	    XmCommandError (w, command);
	else if (op -> type == XMCommandSetValue)
	    XmCommandSetValue (w, command);
	else
	    XmCommandAppendValue (w, command);

	XmStringFree (command);

	ArgNReturn (True);
    }

    case XMCommandGetChild:
    {
	unsigned char child;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "XmDIALOG_COMMAND_TEXT") == 0)
	    child = XmDIALOG_COMMAND_TEXT;
	else if (strcmp (arg_ptr, "XmDIALOG_PROMPT_LABEL") == 0)
	    child = XmDIALOG_PROMPT_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_HISTORY_LIST") == 0)
	    child = XmDIALOG_HISTORY_LIST;
	else
	    child = XmDIALOG_WORK_AREA;

	w = XmCommandGetChild (w, child);

	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMConvertUnits:
    {
	int orientation;
	int from_unit_type;
	int from_value;
	int to_unit_type;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (strcmp (ArgN (0), "XmVERTICAL") == 0)
	    orientation = XmVERTICAL;
	else
	    orientation = XmHORIZONTAL;

	arg_ptr = ArgN (1);
	if (strcmp (arg_ptr, "Xm100TH_MILLIMETERS") == 0)
	    from_unit_type = Xm100TH_MILLIMETERS;
	else if (strcmp (arg_ptr, "Xm1000TH_INCHES") == 0)
	    from_unit_type = Xm1000TH_INCHES;
	else if (strcmp (arg_ptr, "Xm100TH_POINTS") == 0)
	    from_unit_type = Xm100TH_POINTS;
	else if (strcmp (arg_ptr, "Xm100TH_FONT_UNITS") == 0)
	    from_unit_type = Xm100TH_FONT_UNITS;
	else
	    from_unit_type = XmPIXELS;

	from_value = atoi (ArgN (2));

	arg_ptr = ArgN (3);
	if (strcmp (arg_ptr, "Xm100TH_MILLIMETERS") == 0)
	    to_unit_type = Xm100TH_MILLIMETERS;
	else if (strcmp (arg_ptr, "Xm1000TH_INCHES") == 0)
	    to_unit_type = Xm1000TH_INCHES;
	else if (strcmp (arg_ptr, "Xm100TH_POINTS") == 0)
	    to_unit_type = Xm100TH_POINTS;
	else if (strcmp (arg_ptr, "Xm100TH_FONT_UNITS") == 0)
	    to_unit_type = Xm100TH_FONT_UNITS;
	else
	    to_unit_type = XmPIXELS;

	i = XmConvertUnits (w, 	orientation, from_unit_type, from_value,
			    to_unit_type);

	sprintf (copy_buffer, "%d", i);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMCreateArrowButton:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateArrowButton (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateArrowButtonGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateArrowButtonGadget (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateBulletinBoard:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateBulletinBoard (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateBulletinBoardDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateBulletinBoardDialog (w, ArgN (-1),
				     (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateCascadeButton:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateCascadeButton (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateCascadeButtonGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateCascadeButtonGadget (w, ArgN (-1),
				     (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateCommand:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateCommand (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateDialogShell:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateDialogShell (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateDragIcon:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateDragIcon (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateDrawingArea:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateDrawingArea (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateDrawnButton:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateDrawnButton (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateErrorDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateErrorDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateFileSelectionBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateFileSelectionBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateFileSelectionDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateFileSelectionDialog (w, ArgN (-1),
				     (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateForm:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateForm (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateFormDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateFormDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateFrame:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateFrame (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateInformationDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateInformationDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateLabel:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateLabel (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateLabelGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateLabelGadget (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateList:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateList (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateMainWindow:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateMainWindow (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateMenuBar:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateMenuBar (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateMenuShell:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateMenuShell (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateMessageBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateMessageBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateMessageDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateMessageDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateOptionMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateOptionMenu (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePanedWindow:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePanedWindow (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePopupMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePopupMenu (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePromptDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePromptDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePulldownMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePulldownMenu (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePushButton:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePushButton (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreatePushButtonGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreatePushButtonGadget (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateQuestionDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateQuestionDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateRadioBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateRadioBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateRowColumn:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateRowColumn (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateScale:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateScale (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateScrollBar:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateScrollBar (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateScrolledList:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateScrolledList (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateScrolledText:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateScrolledText (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateScrolledWindow:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateScrolledWindow (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSelectionBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSelectionBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSelectionDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSelectionDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSeparator:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSeparator (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSeparatorGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSeparatorGadget (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimpleCheckBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimpleCheckBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimpleMenuBar:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimpleMenuBar (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimpleOptionMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimpleOptionMenu (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimplePopupMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimplePopupMenu (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimplePulldownMenu:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimplePulldownMenu (w, ArgN (-1),
				    (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateSimpleRadioBox:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateSimpleRadioBox (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateTemplateDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateTemplateDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateText:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateText (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateTextField:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateTextField (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateToggleButton:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateToggleButton (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateToggleButtonGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateToggleButtonGadget (w, ArgN (-1),
				    (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateWorkArea:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateWorkArea (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMCreateWorkingDialog:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmCreateWorkingDialog (w, ArgN (-1), (ArgList) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMDeactivateProtocol:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDeactivateProtocol (w, XtentStringToAtom (display, ArgN (0)),
			      XtentStringToAtom (display, ArgN (1)));

	ArgNReturn (True);
    }

    case XMDeactivateWMProtocol:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDeactivateWMProtocol (w, XtentStringToAtom (display, ArgN (-1)));

	ArgNReturn (True);
    }

    case XMDestroyPixmap:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmDestroyPixmap (XtScreen (w), atol (ArgN (0)));

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMDragStart:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	w = XmDragStart (w, (XEvent *) atol (ArgN (0)), (ArgList) NULL, 0);

	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMDropSiteConfigureStackingOrder:
    {
	Widget sibling;
	Cardinal stack_mode;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (*arg_ptr)
	    sibling = XtentNameToWidget (arg_ptr);
	else
	    sibling = (Widget) NULL;

	arg_ptr = ArgN (1);
	stack_mode = XmABOVE;
	if (strcmp (arg_ptr, "XmBELOW") == 0)
	    stack_mode = XmBELOW;

	XmDropSiteConfigureStackingOrder (w, sibling, stack_mode);

	ArgNReturn (True);
    }

    case XMDropSiteEndUpdate:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteEndUpdate (w);

	ArgNReturn (True);
    }

    case XMDropSiteQueryStackingOrder:
    {
	Widget parent_return;
	Widget *child_returns;
	Cardinal num_child_returns;
	int arg_ptr_len = 0;
	int val_ptr_len = 0;
	int total_len = 0;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteQueryStackingOrder (w, &parent_return, &child_returns,
				      &num_child_returns);

	XtentXrmPutStringResource (&db, ArgN (0),
				   XtentWidgetToName (parent_return), 30);

	val_ptr = (char *) NULL;
	for (i = 0; i < num_child_returns; i++)
	{
	    arg_ptr = (char *) XtentWidgetToName (child_returns[i]);

	    if (*arg_ptr != '\0')
	    {
		arg_ptr_len = strlen (arg_ptr);
		if (arg_ptr_len + total_len >= val_ptr_len)
		{
		    val_ptr_len = total_len + arg_ptr_len + 64;
		    val_ptr = (char *) XtRealloc (val_ptr, val_ptr_len);
		}
		memcpy (val_ptr + total_len, arg_ptr, arg_ptr_len);
		total_len += arg_ptr_len;
		val_ptr[total_len] = ' ';
		total_len++;
	    }
	}
	if (total_len)
	{
	    val_ptr[total_len] = '\0';
	    while (val_ptr[total_len - 1] == ' ')
		val_ptr[--total_len] = '\0';
	}

	XtentXrmPutStringResource (&db, ArgN (1),
				   (val_ptr ? val_ptr : "None"), 30);
	XtFree ((char *) val_ptr);

	sprintf (copy_buffer, "%d", num_child_returns);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMDropSiteRegister:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteRegister (w, (ArgList) NULL, 0);

	ArgNReturn (True);
    }

    case XMDropSiteRetrieve:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteRetrieve (w,  (ArgList) NULL, 0);

	ArgNReturn (True);
    }

    case XMDropSiteStartUpdate:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteStartUpdate (w);

	ArgNReturn (True);
    }

    case XMDropSiteUnregister:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteUnregister (w);

	ArgNReturn (True);
    }

    case XMDropSiteUpdate:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropSiteUpdate (w, (ArgList) NULL, 0);

	ArgNReturn (True);
    }

    case XMDropTransferAdd:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmDropTransferAdd (w, (XmDropTransferEntryRec *) NULL, (Cardinal) 0);

	ArgNReturn (True);
    }

    case XMDropTransferStart:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	w = XmDropTransferStart (w, (ArgList) NULL, (Cardinal) 0);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMFileSelectionBoxGetChild:
    {
	unsigned char child;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "XmDIALOG_APPLY_BUTTON") == 0)
	    child = XmDIALOG_APPLY_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_CANCEL_BUTTON") == 0)
	    child = XmDIALOG_CANCEL_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_DEFAULT_BUTTON") == 0)
	    child = XmDIALOG_DEFAULT_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_DIR_LIST") == 0)
	    child = XmDIALOG_DIR_LIST;
	else if (strcmp (arg_ptr, "XmDIALOG_DIR_LIST_LABEL") == 0)
	    child = XmDIALOG_DIR_LIST_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_FILTER_LABEL") == 0)
	    child = XmDIALOG_FILTER_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_FILTER_TEXT") == 0)
	    child = XmDIALOG_FILTER_TEXT;
	else if (strcmp (arg_ptr, "XmDIALOG_HELP_BUTTON") == 0)
	    child = XmDIALOG_HELP_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_LIST") == 0)
	    child = XmDIALOG_LIST;
	else if (strcmp (arg_ptr, "XmDIALOG_LIST_LABEL") == 0)
	    child = XmDIALOG_LIST_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_OK_BUTTON") == 0)
	    child = XmDIALOG_OK_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_SELECTION_LABEL") == 0)
	    child = XmDIALOG_SELECTION_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_SEPARATOR") == 0)
	    child = XmDIALOG_SEPARATOR;
	else if (strcmp (arg_ptr, "XmDIALOG_TEXT") == 0)
	    child = XmDIALOG_TEXT;
	else
	    child = XmDIALOG_WORK_AREA;

	w = XmFileSelectionBoxGetChild (w, child);
	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMFileSelectionDoSearch:
    {
	XmString command;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	command = XmStringCreateLocalized (ArgN (-1));

	XmFileSelectionDoSearch (w, command);

	XmStringFree (command);

	ArgNReturn (True);
    }

    case XMGetColors:
    {
	XrmValue from_value, to_value;
	Pixel background, foreground, top_shadow, bottom_shadow, select;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	from_value.size = strlen (arg_ptr);
	from_value.addr = arg_ptr;
	to_value.size = 0;
	to_value.addr = (XtPointer) NULL;
	
	_XtConvert (w, XtQString, &from_value, XtQPixel, &to_value, NULL);

	if (to_value.size && to_value.addr)
	    background = *((Pixel *) to_value.addr);
	else
	    background = WhitePixel (display, DefaultScreen (display));

	XmGetColors (XtScreen (w), w -> core.colormap, background,
		     &foreground, &top_shadow, &bottom_shadow, &select);

	sprintf (copy_buffer, "%d", (int) foreground);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) top_shadow);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) bottom_shadow);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) select);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMGetDestination:
    case XMGetFocusWidget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMGetDestination)
	    w = XmGetDestination (display);
	else if (op -> type == XMGetFocusWidget)
	    w = XmGetFocusWidget (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMGetDragContext:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (0);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	w = XmGetDragContext (w, timestamp);

	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMGetPixmap:		/* (image_name, fore, back, return_id) */
    case XMGetPixmapByDepth:
    {
	Pixel foreground, background;
	XrmValue from_value, to_value;
	Pixmap pixmap;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	val_ptr = ArgN (0);

	arg_ptr = ArgN (1);
	from_value.size = strlen (arg_ptr);
	from_value.addr = arg_ptr;
	to_value.size = 0;
	to_value.addr = (XtPointer) NULL;
	
	_XtConvert (w, XtQString, &from_value,
		    XtQPixel, &to_value, NULL);
	
	if (to_value.size && to_value.addr)
	    foreground = *((Pixel *) to_value.addr);
	else
	    foreground = WhitePixel (display, DefaultScreen (display));

	arg_ptr = ArgN (2);
	from_value.size = strlen (arg_ptr);
	from_value.addr = arg_ptr;
	to_value.size = 0;
	to_value.addr = (XtPointer) NULL;
	
	_XtConvert (w, XtQString, &from_value, XtQPixel, &to_value, NULL);
	
	if (to_value.size && to_value.addr)
	    background = *((Pixel *) to_value.addr);
	else
	    background = WhitePixel (display, DefaultScreen (display));

	if (op -> type == XMGetPixmap)
	{
	    pixmap = XmGetPixmap (XtScreen (w), arg_ptr,
				  foreground, background);
	    arg_count = 3;
	}
	else
	{
	    pixmap = XmGetPixmapByDepth (XtScreen (w), arg_ptr,
					 foreground, background,
					 atoi (ArgN (3)));
	    arg_count = 4;
	}

	sprintf (copy_buffer, "%d", (int) pixmap);
	XtentPutStringReturn (&db, ArgN (arg_count), copy_buffer);

	ArgNReturn (True);
    }

    case XMGetPostedFromWidget:
    case XMGetTabGroup:
    case XMGetTearOffControl:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMGetTearOffControl)
	    w = XmGetTearOffControl (w);
	else if (op -> type == XMGetTabGroup)
	    w = XmGetTabGroup (w);
	else
	    w = XmGetPostedFromWidget (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMGetVisibility:
    {
	XmVisibility v;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	v = XmGetVisibility (w);
	arg_ptr = "XmVISIBILITY_FULLY_OBSCURED";
	if (v == XmVISIBILITY_UNOBSCURED)
	    arg_ptr = "XmVISIBILITY_UNOBSCURED";
	else if (v == XmVISIBILITY_PARTIALLY_OBSCURED)
	    arg_ptr = "XmVISIBILITY_PARTIALLY_OBSCURED";

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);

	ArgNReturn (True);
    }

    /*
     * needs work: check these as they may not be creating real widgets
     */
    case XMGetXmDisplay:
    case XMGetXmScreen:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMGetXmScreen)
	    w = (Widget) XmGetXmScreen (XtScreen (w));
	else
	    w = (Widget) XmGetXmDisplay (display);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMInstallImage:
    {
	XImage *image;
	char type;

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr + strlen (arg_ptr) - 4, ".tif") == 0)
	    type = 't';
	else
	    type = 'b';
	image = XtentReadImage (display, arg_ptr, type, False);

	i = XmInstallImage (image, arg_ptr);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMIsMotifWMRunning:
    case XMIsTraversable:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMIsMotifWMRunning)
	    i = XmIsMotifWMRunning (w);
	else
	    i = XmIsTraversable (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMListAddItem:
    case XMListAddItemUnselected:
    case XMListDeleteItem:
    case XMListDeselectItem:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMListAddItem ||
	    op -> type == XMListAddItemUnselected)
	{
	    item = XmStringCreateLocalized (ArgN (0));
	    i = atoi (ArgN(1));
	}
	else
	    item = XmStringCreateLocalized (ArgN (-1));

	if (op -> type == XMListAddItem)
	    XmListAddItem (w, item, i);
	else if (op -> type == XMListAddItemUnselected)
	    XmListAddItemUnselected (w, item, i);
	else if (op -> type == XMListDeleteItem)
	    XmListDeleteItem (w, item);
	else
	    XmListDeselectItem (w, item);

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListAddItems:	/* (position, a, b, c, ...) */
    case XMListAddItemsUnselected:	/* (position, a, b, c, ...) */
    case XMListDeleteItems:	/* (a, b, c, ...) */
    case XMListReplaceItems:	/* (<old items> <new items>) */
    case XMListReplaceItemsPos:	/* (position, a, b, c, ...) */
    case XMListReplaceItemsPosUnselected:  /* (position, a, b, c, ...) */
    case XMListReplaceItemsUnselected:	   /* (<old items> <new items>) */
    {
	int position;
	XmString *items = (XmString *) NULL;
	int item_count = 0;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMListAddItems ||
	    op -> type == XMListAddItemsUnselected ||
	    op -> type == XMListReplaceItemsPos ||
	    op -> type == XMListReplaceItemsPosUnselected)
	{
	    position = atoi (ArgN (0));
	    arg_count = 1;
	}
	else
	    arg_count = 0;

	for (i = 0; True; i++)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (i == item_count)
	    {
		item_count += 8;
		items = (XmString *)
		    XtRealloc ((char *) items, sizeof (XmString *) *
			       item_count);
	    }
	    items[i] = XmStringCreateLocalized (arg_ptr);
	}
	item_count = i;

	switch (op -> type)
	{
	case XMListAddItems:
	    XmListAddItems (w, items, item_count, position);
	    break;
	case XMListAddItemsUnselected:
	    XmListAddItemsUnselected (w, items, item_count, position);
	    break;
	case XMListDeleteItems:
	    XmListDeleteItems (w, items, item_count);
	    break;
	case XMListReplaceItems:
	    XmListReplaceItems (w, items, item_count / 2,
				&items[item_count / 2]);
	    break;
	case XMListReplaceItemsPos:
	    XmListReplaceItemsPos (w, items, item_count, position);
	    break;
	case XMListReplaceItemsPosUnselected:
	    XmListReplaceItemsPosUnselected (w, items, item_count, position);
	    break;
	case XMListReplaceItemsUnselected:
	    XmListReplaceItemsUnselected (w, items, item_count / 2,
					  &items[item_count / 2]);
	    break;
	}

	for (i = 0; i < item_count; i++)
	    XmStringFree (items[i]);

	XtFree ((char *) items);

	ArgNReturn (True);
    }

    case XMListDeleteAllItems:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListDeleteAllItems (w);

	ArgNReturn (True);
    }

    case XMListDeleteItemsPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListDeleteItemsPos (w, atoi (ArgN (0)), atoi (ArgN (1)));

	ArgNReturn (True);
    }

    case XMListDeletePos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListDeletePos (w, atoi (ArgN (0)));

	ArgNReturn (True);
    }

    case XMListDeletePositions:
    {
	int *items = (int *) NULL;
	int item_count = 0;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_count = 0;
	for (i = 0; True; i++)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (i == item_count)
	    {
		item_count += 8;
		items = (int *) XtRealloc ((char *) items, sizeof (int *) *
					   item_count);
	    }
	    items[i] = atoi (arg_ptr);
	}
	item_count = i;

	XmListDeletePositions (w, items, item_count);

	XtFree ((char *) items);

	ArgNReturn (True);
    }

    case XMListDeselectAllItems:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListDeselectAllItems (w);

	ArgNReturn (True);
    }

    case XMListDeselectPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListDeselectPos (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListGetKbdItemPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmListGetKbdItemPos (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMListGetMatchPos:	/* (item, return-list, return-count) */
    case XMListGetSelectedPos:
    {
	XmString item;
	int *position_list = (int *) NULL;
	int position_count;
	int length;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMListGetMatchPos)
	{
	    item = XmStringCreateLocalized (ArgN (0));
	    arg_count = 1;
	    i = XmListGetMatchPos (w, item, &position_list, &position_count);
	}
	else
	{
	    arg_count = 0;
	    i = XmListGetSelectedPos (w, &position_list, &position_count);
	}

	length = 0;
	for (j = 0; j < position_count; j++)
	    length += ((position_list[j] < 1000) ? (3 + 2) : (16 + 2));

	arg_ptr = (char *) XtMalloc (length);

	length = 0;
	for (j = 0; j < position_count; j++)
	{	    
	    sprintf (arg_ptr + length, "%d, ", position_list[j]);
	    length += strlen (arg_ptr + length);
	}

	if (length > 2)
	{
	    length -= 2;
	    arg_ptr[length] = '\0';
	}

	XtentXrmPutStringResource (&db, ArgN (arg_count),
				   XtentCalcTrueOrFalseString (i), 30);
	XtentXrmPutStringResource (&db, ArgN (arg_count + 1), arg_ptr, 30);
	sprintf (copy_buffer, "%d", position_count);
	XtentXrmPutStringResource (&db, ArgN (arg_count + 2), copy_buffer, 30);

	XtFree (arg_ptr);
	XtFree ((char *) position_list);
	if (op -> type == XMListGetMatchPos)
	    XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListItemExists:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	item = XmStringCreateLocalized (ArgN (0));

	i = XmListItemExists (w, item);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListItemPos:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	item = XmStringCreateLocalized (ArgN (0));

	i = XmListItemPos (w, item);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (1), copy_buffer);

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListPosSelected:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmListPosSelected (w, atoi (ArgN (0)));

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMListPosToBounds:	/* (pos, returns bool,x,y,width,height) */
    {
	Position x, y;
	Dimension width, height;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmListPosToBounds (w, atoi (ArgN (0)), &x, &y, &width, &height);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	sprintf (copy_buffer, "%d", (int) x);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) y);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) width);
	XtentXrmPutStringResource (&db, ArgN (4), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) height);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMListReplacePositions: /* (pos-1, item-1, pos-2, item-2, ... ) */
    {
	XmString *items = (XmString *) NULL;
	int item_count = 0;
	int *positions = (int *) NULL;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_count = 0;
	for (i = 0; True; i++)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (i == item_count)
	    {
		item_count += 8;
		items = (XmString *)
		    XtRealloc ((char *) items, sizeof (XmString *) *
			       item_count);
		positions = (int *)
		    XtRealloc ((char *) positions, sizeof (int *) *
			       item_count);
	    }
	    items[i] = XmStringCreateLocalized (arg_ptr);
	    positions[i] = atoi (ArgN (arg_count++));
	}
	item_count = i;

	XmListReplacePositions (w, positions, items, item_count);

	for (i = 0; i < item_count; i++)
	    XmStringFree (items[i]);
	XtFree ((char *) positions);

	ArgNReturn (True);
    }

    case XMListSelectItem:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	item = XmStringCreateLocalized (ArgN (0));

	XmListSelectItem (w, item, XtentTestTrue (ArgN (1)));

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListSelectPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSelectPos (w, atoi (ArgN (0)), XtentTestTrue (ArgN (1)));

	ArgNReturn (True);
    }

    case XMListSetAddMode:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSetAddMode (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListSetBottomItem:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	item = XmStringCreateLocalized (ArgN (-1));

	XmListSetBottomItem (w, item);

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListSetBottomPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSetBottomPos (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListSetHorizPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSetHorizPos (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListSetItem:
    {
	XmString item;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	item = XmStringCreateLocalized (ArgN (-1));

	XmListSetItem (w, item);

	XmStringFree (item);

	ArgNReturn (True);
    }

    case XMListSetKbdItemPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSetKbdItemPos (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListSetPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListSetPos (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMListUpdateSelectedList:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmListUpdateSelectedList (w);

	ArgNReturn (True);
    }

    case XMListYToPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmListYToPos (w, atoi (ArgN (0)));
	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (1), copy_buffer);

	ArgNReturn (True);
    }

    case XMMainWindowSep1:
    case XMMainWindowSep2:
    case XMMainWindowSep3:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (op -> type == XMMainWindowSep1)
	    w = XmMainWindowSep1 (w);
	else if (op -> type == XMMainWindowSep2)
	    w = XmMainWindowSep2 (w);
	else
	    w = XmMainWindowSep3 (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMMainWindowSetAreas:
    {
	Widget menu_bar, command_window, horizontal_scrollbar;
	Widget vertical_scrollbar, work_region;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (*arg_ptr)
	    menu_bar = XtentNameToWidget (arg_ptr);
	else
	    menu_bar = (Widget) NULL;

	arg_ptr = ArgN (1);
	if (*arg_ptr)
	    command_window = XtentNameToWidget (arg_ptr);
	else
	    command_window = (Widget) NULL;

	arg_ptr = ArgN (2);
	if (*arg_ptr)
	    horizontal_scrollbar = XtentNameToWidget (arg_ptr);
	else
	    horizontal_scrollbar = (Widget) NULL;

	arg_ptr = ArgN (0);
	if (*arg_ptr)
	    vertical_scrollbar = XtentNameToWidget (arg_ptr);
	else
	    vertical_scrollbar = (Widget) NULL;

	arg_ptr = ArgN (0);
	if (*arg_ptr)
	    work_region = XtentNameToWidget (arg_ptr);
	else
	    work_region = (Widget) NULL;

	XmMainWindowSetAreas (w, menu_bar, command_window,
			      horizontal_scrollbar, vertical_scrollbar,
			      work_region);

	ArgNReturn (True);
    }

    case XMMenuPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmMenuPosition (w, (XButtonPressedEvent *) atol (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMMessageBoxGetChild:
    {
	unsigned char child;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "XmDIALOG_CANCEL_BUTTON") == 0)
	    child = XmDIALOG_CANCEL_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_DEFAULT_BUTTON") == 0)
	    child = XmDIALOG_DEFAULT_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_HELP_BUTTON") == 0)
	    child = XmDIALOG_HELP_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_MESSAGE_LABEL") == 0)
	    child = XmDIALOG_MESSAGE_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_OK_BUTTON") == 0)
	    child = XmDIALOG_OK_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_SEPARATOR") == 0)
	    child = XmDIALOG_SEPARATOR;
	else
	    child = XmDIALOG_SYMBOL_LABEL;

	w = XmMessageBoxGetChild (w, child);

	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMOptionButtonGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	w = XmOptionButtonGadget (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMOptionLabelGadget:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	w = XmOptionLabelGadget (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMProcessTraversal:
    {
	XmTraversalDirection direction;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "XmTRAVERSE_CURRENT") == 0)
	    direction = XmTRAVERSE_CURRENT;
	else if (strcmp (arg_ptr, "XmTRAVERSE_NEXT") == 0)
	    direction = XmTRAVERSE_NEXT;
	else if (strcmp (arg_ptr, "XmTRAVERSE_PREV") == 0)
	    direction = XmTRAVERSE_PREV;
	else if (strcmp (arg_ptr, "XmTRAVERSE_HOME") == 0)
	    direction = XmTRAVERSE_HOME;
	else if (strcmp (arg_ptr, "XmTRAVERSE_NEXT_TAB_GROUP") == 0)
	    direction = XmTRAVERSE_NEXT_TAB_GROUP;
	else if (strcmp (arg_ptr, "XmTRAVERSE_PREV_TAB_GROUP") == 0)
	    direction = XmTRAVERSE_PREV_TAB_GROUP;
	else if (strcmp (arg_ptr, "XmTRAVERSE_UP") == 0)
	    direction = XmTRAVERSE_UP;
	else if (strcmp (arg_ptr, "XmTRAVERSE_DOWN") == 0)
	    direction = XmTRAVERSE_DOWN;
	else if (strcmp (arg_ptr, "XmTRAVERSE_LEFT") == 0)
	    direction = XmTRAVERSE_LEFT;
	else
	    direction = XmTRAVERSE_RIGHT;

	i = XmProcessTraversal (w, direction);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMRemoveTabGroup:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmRemoveTabGroup (w);

	ArgNReturn (True);
    }

    case XMRepTypeAddReverse:
    {
	XmRepTypeAddReverse (atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMRepTypeGetId:
    {
	XmRepTypeId id;

	id = XmRepTypeGetId (ArgN (0));

	sprintf (copy_buffer, "%d", id);
	XtentPutStringReturn (&db, ArgN (1), copy_buffer);

	ArgNReturn (True);
    }

    case XMRepTypeGetNameList:
    {
	String *ret, *ptr;
	int length = 4;

	ret = XmRepTypeGetNameList (atoi (ArgN (0)), XtentTestTrue (ArgN (1)));

	
	for (ptr = ret; *ptr; ptr++)
	    length += (strlen (*ptr) + 2);

	val_ptr = arg_ptr = (char *) XtMalloc (length);

	for (ptr = ret; *ptr; ptr++)
	{
	    strcpy (arg_ptr, *ptr);
	    arg_ptr += strlen (*ptr);
	    strcpy (arg_ptr, ", ");
	    arg_ptr += 2;
	}

	XtentPutStringReturn (&db, ArgN (2), val_ptr);

	/*
	 *  not clear that this is supposed to be freed
	 */
	for (ptr = ret; *ptr; ptr++)
	    XtFree ((char *) *ptr);
	XtFree ((char *) ret);
	XtFree (val_ptr);

	ArgNReturn (True);
    }

    case XMRepTypeInstallTearOffModelConverter:
    {
	XmRepTypeInstallTearOffModelConverter ();

	ArgNReturn (True);
    }

    case XMRepTypeRegister:	/* (ret-name, type, name1, 1, name2, 2, ...) */
    {				/* or  (ret-name, type, name1, name2, ...) */
	String rep_type;
	String *value_names = (String *) NULL;
	unsigned char *values;
	unsigned char num_values;
	int item_count = 0;
	int pairs_of_values = True;
	XmRepTypeId id;

	val_ptr = ArgN (0);
	rep_type = ArgN (1);

	arg_count = 2;
	for (i = 0; True; i++)
	{
	    arg_ptr = ArgN (arg_count++);
	    if (*arg_ptr == '\0' && frame_data.end_of_line)
		break;

	    if (i == item_count)
	    {
		item_count += 8;
		value_names = (String *)
		    XtRealloc ((char *) value_names, sizeof (String *) *
			       item_count);
		values = (unsigned char *)
		    XtRealloc ((char *) values, sizeof (unsigned char *) *
			       item_count);
	    }

	    value_names[i] = arg_ptr;
	    if (pairs_of_values)
	    {
		arg_ptr = ArgN (arg_count++);
		if (i == 0 && (*arg_ptr < '0' || *arg_ptr > '9'))
		{
		    arg_count--;
		    pairs_of_values = False;
		    continue;
		}
		values[i] = (unsigned char) atoi (arg_ptr);
	    }
	}
	item_count = i;

	if (pairs_of_values == False)
	{
		XtFree ((char *) values);
		values = (unsigned char *) NULL;
	}

	id = XmRepTypeRegister (rep_type, value_names, values, num_values);

	sprintf (copy_buffer, "%d", (int) id);
	XtentPutStringReturn (&db, val_ptr, copy_buffer);

	XtFree ((char *) values);
	XtFree ((char *) value_names);

	ArgNReturn (True);
    }

    case XMRepTypeValidValue:
    {
	XmRepTypeId id;
	unsigned char test_value;

	id = atoi (ArgN (0));
	test_value = (unsigned char) atoi (ArgN (1));
	arg_ptr = ArgN (2);
	if (*arg_ptr)
	    w = XtentNameToWidget (arg_ptr);
	else
	    w = (Widget) NULL;

	i = XmRepTypeValidValue (id, test_value, w);

	XtentPutStringReturn (&db, ArgN (3), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMScaleGetValue:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmScaleGetValue (w, &i);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMScaleSetValue:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmScaleSetValue (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMScrollBarGetValues:
    {
	int value_return, slider_size_return, increment_return;
	int page_increment_return;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmScrollBarGetValues (w, &value_return, &slider_size_return,
			      &increment_return, &page_increment_return);

	sprintf (copy_buffer, "%d", value_return);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", slider_size_return);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", increment_return);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	sprintf (copy_buffer, "%d", page_increment_return);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMScrollBarSetValues:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmScrollBarSetValues (w, atoi (ArgN (0)), atoi (ArgN (1)),
			      atoi (ArgN (2)), atoi (ArgN (3)),
			      XtentTestTrue (ArgN (4)));

	ArgNReturn (True);
    }

    case XMScrollVisible:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmScrollVisible (w, XtentNameToWidget (ArgN (0)),
			 (Dimension) atoi (ArgN (1)),
			 (Dimension) atoi (ArgN (2)));

	ArgNReturn (True);
    }

    case XMScrolledWindowSetAreas:
    {
	Widget sh, sv, wr;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (*arg_ptr)
	    sh = XtentNameToWidget (arg_ptr);
	else
	    sh = (Widget) NULL;

	arg_ptr = ArgN (1);
	if (*arg_ptr)
	    sv = XtentNameToWidget (arg_ptr);
	else
	    sv = (Widget) NULL;

	arg_ptr = ArgN (2);
	if (*arg_ptr)
	    wr = XtentNameToWidget (arg_ptr);
	else
	    wr = (Widget) NULL;

	XmScrolledWindowSetAreas (w, sh, sv, wr);

	ArgNReturn (True);
    }

    case XMSelectionBoxGetChild:
    {
	unsigned char child;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr, "XmDIALOG_APPLY_BUTTON") == 0)
	    child = XmDIALOG_APPLY_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_CANCEL_BUTTON") == 0)
	    child = XmDIALOG_CANCEL_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_DEFAULT_BUTTON") == 0)
	    child = XmDIALOG_DEFAULT_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_HELP_BUTTON") == 0)
	    child = XmDIALOG_HELP_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_LIST") == 0)
	    child = XmDIALOG_LIST;
	else if (strcmp (arg_ptr, "XmDIALOG_LIST_LABEL") == 0)
	    child = XmDIALOG_LIST_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_OK_BUTTON") == 0)
	    child = XmDIALOG_OK_BUTTON;
	else if (strcmp (arg_ptr, "XmDIALOG_SELECTION_LABEL") == 0)
	    child = XmDIALOG_SELECTION_LABEL;
	else if (strcmp (arg_ptr, "XmDIALOG_SEPARATOR") == 0)
	    child = XmDIALOG_SEPARATOR;
	else if (strcmp (arg_ptr, "XmDIALOG_TEXT") == 0)
	    child = XmDIALOG_TEXT;
	else
	    child = XmDIALOG_WORK_AREA;

	w = XmSelectionBoxGetChild (w, child);

	XtentPutStringReturn (&db, ArgN (1), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMSetFontUnit:
    {
	XmSetFontUnit (display, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMSetFontUnits:
    {
	XmSetFontUnits (display, atoi (ArgN (0)), atoi (ArgN (1)));

	ArgNReturn (True);
    }

    case XMTextClearSelection:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextClearSelection (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextCopy:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextCopy (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextCut:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextCut (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextDisableRedisplay:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextDisableRedisplay (w);

	ArgNReturn (True);
    }

    case XMTextEnableRedisplay:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextEnableRedisplay (w);

	ArgNReturn (True);
    }

    case XMTextFieldClearSelection:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextFieldClearSelection (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextFieldCopy:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextFieldCopy (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextFieldCut:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (-1);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextFieldCut (w, timestamp);

	ArgNReturn (True);
    }

    case XMTextFieldGetBaseLine:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldGetBaseLine (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextFieldGetEditable:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldGetEditable (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextFieldGetInsertionPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextFieldGetInsertionPosition (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextFieldGetLastPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextFieldGetLastPosition (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextFieldGetMaxLength:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextFieldGetMaxLength (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextFieldGetSelection:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = XmTextFieldGetSelection (w);
	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextFieldGetSelectionPosition:
    {
	XmTextPosition left, right;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldGetSelectionPosition (w, &left, &right);

	sprintf (copy_buffer, "%d", (int) left);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) right);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	XtentXrmPutStringResource (&db, ArgN (2),
				   XtentCalcTrueOrFalseString (i), 30);

	ArgNReturn (True);
    }

    case XMTextFieldGetString:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = XmTextFieldGetString (w);

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextFieldGetSubstring:
    {
	XmTextPosition start;
#ifndef MB_CUR_MAX
#define MB_CUR_MAX 1
#endif
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	start = (XmTextPosition) atoi (ArgN (0));
	i = atoi (ArgN (1));	/* num chars */
	j = atoi (ArgN (2));	/* buf size */
	arg_ptr = XtMalloc (j * MB_CUR_MAX + 1);

	i = XmTextFieldGetSubstring (w, start, i, j, arg_ptr);

	XtentXrmPutStringResource (&db, ArgN (3), arg_ptr, 30);
	if (i == XmCOPY_SUCCEEDED)
	    val_ptr = "XmCOPY_SUCCEEDED";
	else if (i == XmCOPY_FAILED)
	    val_ptr = "XmCOPY_FAILED";
	else
	    val_ptr = "XmCOPY_TRUNCATED";
	XtentXrmPutStringResource (&db, ArgN (4), val_ptr, 30);

	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextFieldInsert:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldInsert (w, (XmTextPosition) atoi (ArgN (0)), ArgN (1));

	ArgNReturn (True);
    }

    case XMTextFieldPaste:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldPaste (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextFieldPosToXY:
    {
	Position x, y;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldPosToXY (w, (XmTextPosition) atoi (ArgN (0)), &x, &y);

	sprintf (copy_buffer, "%d", (int) x);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) y);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	XtentXrmPutStringResource (&db, ArgN (3),
				   XtentCalcTrueOrFalseString (i), 30);

	ArgNReturn (True);
    }

    case XMTextFieldRemove:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextFieldRemove (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextFieldReplace:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldReplace (w, (XmTextPosition) atoi (ArgN (0)),
			    (XmTextPosition) atoi (ArgN (1)), ArgN (2));

	ArgNReturn (True);
    }

    case XMTextFieldSetAddMode:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldSetAddMode (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextFieldSetEditable:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldSetEditable (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextFieldSetHighlight:
    {
	XmTextPosition left, right;
	XmHighlightMode mode;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	left = atoi (ArgN (0));
	right = atoi (ArgN (1));
	arg_ptr = ArgN (2);
	if (strcmp (arg_ptr, "XmHIGHLIGHT_NORMAL") == 0)
	    mode = XmHIGHLIGHT_NORMAL;
	else if (strcmp (arg_ptr, "XmHIGHLIGHT_SELECTED") == 0)
	    mode = XmHIGHLIGHT_SELECTED;
	else
	    mode = XmHIGHLIGHT_SECONDARY_SELECTED;

	XmTextFieldSetHighlight (w, left, right, mode);

	ArgNReturn (True);
    }

    case XMTextFieldSetInsertionPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldSetInsertionPosition (w, (XmTextPosition) atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextFieldSetMaxLength:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldSetMaxLength (w, (XmTextPosition) atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextFieldSetSelection:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (2);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextFieldSetSelection (w, (XmTextPosition) atoi (ArgN (0)),
				 (XmTextPosition) atoi (ArgN (1)),
				 timestamp);
	ArgNReturn (True);
    }

    case XMTextFieldSetString:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldSetString (w, ArgN (-1));

	ArgNReturn (True);
    }

    case XMTextFieldShowPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextFieldShowPosition (w, (XmTextPosition) atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextFieldXYToPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextFieldXYToPos (w, (Position) atoi (ArgN (0)),
				    (Position) atoi (ArgN (1)));

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextFindString:
    {
	XmTextDirection direction;
	XmTextPosition start, position;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	start = (XmTextPosition) atoi (ArgN (0));
	val_ptr = ArgN (1);	/* search string */
	arg_ptr = ArgN (2);	/* direction */
	if (strcmp (arg_ptr, "XmTEXT_FORWARD") == 0)
	    direction = XmTEXT_FORWARD;
	else
	    direction = XmTEXT_BACKWARD;

	i = XmTextFindString (w, start, val_ptr, direction, &position);

	sprintf (copy_buffer, "%d", (int) position);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);
	XtentXrmPutStringResource (&db, ArgN (4),
				   XtentCalcTrueOrFalseString (i), 30);

	ArgNReturn (True);
    }

    case XMTextGetBaseLine:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextGetBaseLine (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextGetEditable:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextGetEditable (w);
	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextGetInsertionPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextGetInsertionPosition (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextGetLastPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextGetLastPosition (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextGetMaxLength:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextGetMaxLength (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextGetSelection:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = XmTextGetSelection (w);

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);

	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextGetSelectionPosition:
    {
	XmTextPosition left, right;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextGetSelectionPosition (w, &left, &right);

	sprintf (copy_buffer, "%d", (int) left);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) right);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	XtentXrmPutStringResource (&db, ArgN (2),
				   XtentCalcTrueOrFalseString (i), 30);

	ArgNReturn (True);
    }

    case XMTextGetSource:
    {
	XtPointer x;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	x = (XtPointer) XmTextGetSource (w);

	sprintf (copy_buffer, "%ld", x);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextGetString:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = XmTextGetString (w);

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextGetSubstring:
    {
	XmTextPosition start;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	start = (XmTextPosition) atoi (ArgN (0));
	i = atoi (ArgN (1));	/* num chars */
	j = atoi (ArgN (2));	/* buf size */
	arg_ptr = XtMalloc (j * MB_CUR_MAX + 1);

	i = XmTextGetSubstring (w, start, i, j, arg_ptr);

	XtentXrmPutStringResource (&db, ArgN (3), arg_ptr, 30);
	if (i == XmCOPY_SUCCEEDED)
	    val_ptr = "XmCOPY_SUCCEEDED";
	else if (i == XmCOPY_FAILED)
	    val_ptr = "XmCOPY_FAILED";
	else
	    val_ptr = "XmCOPY_TRUNCATED";
	XtentXrmPutStringResource (&db, ArgN (4), val_ptr, 30);

	XtFree (arg_ptr);

	ArgNReturn (True);
    }

    case XMTextGetTopCharacter:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextGetTopCharacter (w);

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);

	ArgNReturn (True);
    }

    case XMTextInsert:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextInsert (w, (XmTextPosition) atoi (ArgN (0)), ArgN (1));

	ArgNReturn (True);
    }

    case XMTextPaste:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextPaste (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextPosToXY:
    {
	Position x, y;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextPosToXY (w, (XmTextPosition) atoi (ArgN (0)), &x, &y);

	sprintf (copy_buffer, "%d", (int) x);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) y);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	XtentXrmPutStringResource (&db, ArgN (3),
				   XtentCalcTrueOrFalseString (i), 30);

	ArgNReturn (True);
    }

    case XMTextRemove:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmTextRemove (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMTextReplace:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextReplace (w, (XmTextPosition) atoi (ArgN (0)),
		       (XmTextPosition) atoi (ArgN (1)), ArgN (2));

	ArgNReturn (True);
    }

    case XMTextScroll:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextScroll (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextSetAddMode:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetAddMode (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextSetEditable:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetEditable (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextSetHighlight:
    {
	XmTextPosition left, right;
	XmHighlightMode mode;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	left = atoi (ArgN (0));
	right = atoi (ArgN (1));
	arg_ptr = ArgN (2);
	if (strcmp (arg_ptr, "XmHIGHLIGHT_NORMAL") == 0)
	    mode = XmHIGHLIGHT_NORMAL;
	else if (strcmp (arg_ptr, "XmHIGHLIGHT_SELECTED") == 0)
	    mode = XmHIGHLIGHT_SELECTED;
	else
	    mode = XmHIGHLIGHT_SECONDARY_SELECTED;

	XmTextSetHighlight (w, left, right, mode);

	ArgNReturn (True);
    }

    case XMTextSetInsertionPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetInsertionPosition (w, (XmTextPosition) atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextSetMaxLength:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetMaxLength (w, (XmTextPosition) atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextSetSelection:
    {
	long timestamp;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	val_ptr = ArgN (2);
	if (*val_ptr == '\0' || (*val_ptr == '-' && *(val_ptr + 1) == '\0'))
	    timestamp = XtLastTimestampProcessed (display);
	else
	    timestamp = atol (val_ptr);

	XmTextSetSelection (w, (XmTextPosition) atoi (ArgN (0)),
			    (XmTextPosition) atoi (ArgN (1)),
			    timestamp);
	ArgNReturn (True);
    }

    case XMTextSetSource:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetSource (w, (XmTextSource) atol (ArgN (0)),
			 (XmTextPosition) atoi (ArgN (1)),
			 (XmTextPosition) atoi (ArgN (2)));
	ArgNReturn (True);
    }

    case XMTextSetString:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetString (w, ArgN (-1));

	ArgNReturn (True);
    }

    case XMTextSetTopCharacter:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextSetTopCharacter (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextShowPosition:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmTextShowPosition (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case XMTextXYToPos:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = (int) XmTextXYToPos (w, (Position) atoi (ArgN (0)),
				 (Position) atoi (ArgN (1)));

	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);

	ArgNReturn (True);
    }

    case XMToggleButtonGadgetGetState:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	i = XmToggleButtonGadgetGetState (w);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMToggleButtonGadgetSetState:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

 	XmToggleButtonGadgetSetState (w, XtentTestTrue (ArgN (0)),
				      XtentTestTrue (ArgN (1)));

	ArgNReturn (True);
    }

    case XMToggleButtonGetState:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XtentPutStringReturn (&db, ArgN (-1), XtentCalcTrueOrFalseString (i));

	XmToggleButtonGetState (w);

	ArgNReturn (True);
    }

    case XMToggleButtonSetState:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

 	XmToggleButtonSetState (w, XtentTestTrue (ArgN (0)),
				XtentTestTrue (ArgN (1)));

	ArgNReturn (True);
    }

    case XMTrackingEvent:
    {
	Cursor cursor;
	XrmValue from_value, to_value;
	XEvent event;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	    cursor = (Cursor) None;
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen ((char *) from_value.addr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value, XtQCursor, &to_value, NULL);
	    if (to_value.size == sizeof (Cursor) && to_value.addr)
		cursor = *((Cursor *) to_value.addr);
	    else
		cursor = (Cursor) None;
	}

	w = XmTrackingEvent (w, cursor, XtentTestTrue (ArgN (1)), &event);

	XtentPutStringReturn (&db, ArgN (2), XtentWidgetToName (w));

	ArgNReturn (True);
    }

    case XMUninstallImage:
    {
	XImage *image;
	char type;

	arg_ptr = ArgN (0);
	if (strcmp (arg_ptr + strlen (arg_ptr) - 4, ".tif") == 0)
	    type = 't';
	else
	    type = 'b';
	image = XtentReadImage (display, arg_ptr, type, False);

	i = XmUninstallImage (image);

	XtentPutStringReturn (&db, ArgN (1), XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    case XMUpdateDisplay:
    {
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmUpdateDisplay (w);

	ArgNReturn (True);
    }

    case XMWidgetGetBaselines:
    {
	Dimension *baselines;
	int length, line_count;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmWidgetGetBaselines (w, &baselines, &line_count);

	length = 0;
	for (j = 0; j < line_count; j++)
	    length += ((baselines[j] < 1000) ? (3 + 2) : (16 + 2));

	arg_ptr = (char *) XtMalloc (length);

	length = 0;
	for (j = 0; j < line_count; j++)
	{	    
	    sprintf (arg_ptr + length, "%d, ", baselines[j]);
	    length += strlen (arg_ptr + length);
	}

	if (length > 2)
	{
	    length -= 2;
	    arg_ptr[length] = '\0';
	}

	XtentXrmPutStringResource (&db, ArgN (0), arg_ptr, 30);
	sprintf (copy_buffer, "%d", line_count);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);

	XtFree (arg_ptr);
	XtFree ((char *) baselines);

	ArgNReturn (True);
    }

    case XMWidgetGetDisplayRect:
    {
	XRectangle displayrect;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XmWidgetGetDisplayRect (w, &displayrect);

	sprintf (copy_buffer, "%d", displayrect.x);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", displayrect.y);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", displayrect.width);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	sprintf (copy_buffer, "%d", displayrect.height);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);

	ArgNReturn (True);
    }

    case XMCvtXmStringTableToString:
	arg_ptr = xtentXmCvtXmStringTableToString (atol (ArgN (0)),
						   atoi (ArgN (1)));
	XtentPutStringReturn (&db, ArgN (2), arg_ptr);
        ArgNReturn (True);

    case XMReinstallXtentConverters:
        XtentAddConverters ();
        ArgNReturn (True);

#endif /* MOTIF */

#ifdef OPENLOOK
    case OLMMToPixel:
	sprintf (copy_buffer, "%d",
		 OlMMToPixel (XtentOLAxis (ArgN (0)),
			      atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OLPointToPixel:
	sprintf (copy_buffer, "%d",
		 OlPointToPixel (XtentOLAxis (ArgN (0)),
				 atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OLPixelToMM:
	sprintf (copy_buffer, "%d",
		 OlPixelToMM (XtentOLAxis (ArgN (0)),
			      atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OLPixelToPoint:
	sprintf (copy_buffer, "%d",
		 OlPixelToPoint (XtentOLAxis (ArgN (0)),
				 atoi (ArgN (1))));
	XtentPutStringReturn (&db,  ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OL_MMToPixel:
	sprintf (copy_buffer, "%f",
		 Ol_MMToPixel (XtentOLAxis (ArgN (0)),
			       atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OL_PointToPixel:
	sprintf (copy_buffer, "%f",
		 Ol_PointToPixel (XtentOLAxis (ArgN (0)),
				  atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OL_PixelToMM:
	sprintf (copy_buffer, "%f",
		 Ol_PixelToMM (XtentOLAxis (ArgN (0)),
			       atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OL_PixelToPoint:
	sprintf (copy_buffer, "%f",
		 Ol_PixelToPoint (XtentOLAxis (ArgN (0)),
				  atoi (ArgN (1))));
	XtentPutStringReturn (&db, ArgN (2), copy_buffer);
	ArgNReturn (True);

    case OLRegisterHelp:
    {
	XtPointer ptr;
	OlFlatHelpId id;
	int atoi_tmp;

	arg_ptr = ArgN (0);
	atoi_tmp = atoi (arg_ptr);
	if (strcmp (arg_ptr, "OL_WIDGET_HELP") == 0 ||
	    atoi_tmp == OL_WIDGET_HELP)
	{
	    i = OL_WIDGET_HELP;
	    ptr = (XtPointer) _xtentNameToWidget (display,
						  toplevel_ptr,
						  buffer,
						  operation,
						  string_one, parse_quarks,
						  parse_bindings,
						  field_count);
	}
	else if (strcmp (arg_ptr, "OL_CLASS_HELP") == 0 ||
		 atoi_tmp == OL_CLASS_HELP)
	{
	    i = OL_CLASS_HELP;
	    operation--;
	    mark = *operation;
	    *operation = '\0';
	    item = XtentStringToQuarkItem (element, False);
	    *operation = mark;
	    if (item -> application_type != (int) XtentWidgetClassNamesType)
	    {
		fprintf (stderr,
			 "%s: Requested widget class not found: %s.\n",
			 XtentProgramName (), ArgN (-1));
		ArgNReturn (True);
	    }
	    wcn = (XtentWidgetClassName *) item -> application_ptr;
	    ptr = (XtPointer) * wcn -> class;
	}
	else if (strcmp (arg_ptr, "OL_WINDOW_HELP") == 0 ||
		 atoi_tmp == OL_WINDOW_HELP)
	{
	    i = OL_WINDOW_HELP;
	    ptr = (XtPointer) XtWindow (_xtentNameToWidget (display,
							    toplevel_ptr,
							    buffer,
							    operation,
							    string_one,
							    parse_quarks,
							    parse_bindings,
							    field_count));
	}
	else if (strcmp (arg_ptr, "OL_FLAT_HELP") == 0 ||
		 atoi_tmp == OL_FLAT_HELP)
	{
	    i = OL_FLAT_HELP;
	    id.widget = _xtentNameToWidget (display,
					    toplevel_ptr,
					    buffer,
					    element,
					    string_one, parse_quarks,
					    parse_bindings,
					    field_count - 1);
	    id.item_index = atoi (element);
	    ptr = (XtPointer) & id;
	}

	arg_ptr = ArgN (3);
	if ((*arg_ptr != '\0') && (strcmp (arg_ptr, "NULL") != 0))
	    arg_ptr = XtNewString (arg_ptr);
	else
	    arg_ptr = (char *) NULL;

	val_ptr = ArgN (2);
	atoi_tmp = atoi (val_ptr);
	if (strcmp (val_ptr, "OL_STRING_SOURCE") == 0 ||
	    atoi_tmp == OL_STRING_SOURCE)
	{
	    j = OL_STRING_SOURCE;
	}
	else if (strcmp (val_ptr, "OL_DISK_SOURCE") == 0 ||
		 atoi_tmp == OL_DISK_SOURCE)
	{
	    j = OL_DISK_SOURCE;
	}
/* RAD */
	else if (strcmp (val_ptr, "OL_TRANSPARENT_SOURCE") == 0 ||
	  	 atoi_tmp == OL_TRANSPARENT_SOURCE )
	{
	    j = OL_TRANSPARENT_SOURCE;
	}
/* RAD */
	else
	{
	    fprintf (stderr, "%s: Unsupported help type reqested: %s.\n",
		     XtentProgramName (), val_ptr);
	    ArgNReturn (True);
	}

	val_ptr = ArgN (1);
	if (*val_ptr != '\0')
	    val_ptr = XtNewString (val_ptr);
	else
	    val_ptr = (char *) NULL;

/* RAD */
	if ( j == OL_TRANSPARENT_SOURCE )
	{
	    OLHelpProcLine *helpproc;

	    helpproc = (OLHelpProcLine *)
		XtMalloc (sizeof (OLHelpProcLine) + strlen (val_ptr));
	    if ( i == OL_FLAT_HELP )
    	    {
	        helpproc -> id = (XtPointer) id.widget;
	        helpproc -> flatitem = id.item_index;
	    }
	    else
	        helpproc -> id = ptr;

	    helpproc -> display = display;
	    helpproc -> toplevel_ptr = toplevel_ptr;
	    helpproc -> next = XtentOLHelpProcLines;
	    strcpy (helpproc -> args, val_ptr);
	    XtentOLHelpProcLines = helpproc;

	    val_ptr = (XtPointer) XtentOLHelpProc;
	}
/* RAD */

	OlRegisterHelp (i, ptr, arg_ptr, j, val_ptr);
	ArgNReturn (True);
    }

    case OLInitialize:
	XtentToplevel (display, toplevel_ptr);
	ArgNReturn (True);

    case OLCallAcceptFocus:
	i = OlCallAcceptFocus (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer, operation,
						   string_one, parse_quarks,
						   parse_bindings,
						   field_count),
			       CurrentTime);
	XtentPutStringReturn (&db, ArgN (-1),
			      (i == 0) ? "False" : "True");
	ArgNReturn (True);

    case OLMoveFocus:
    {
	OlVirtualName i;
	int atoi_tmp;

	val_ptr = ArgN (0);
	atoi_tmp = atoi (val_ptr);

	if (strcmp (val_ptr, "OL_IMMEDIATE") == 0 ||
	    atoi_tmp == OL_IMMEDIATE)
	{
	    i = OL_IMMEDIATE;
	}
	else if (strcmp (val_ptr, "OL_MOVERIGHT") == 0 ||
		 atoi_tmp == OL_MOVERIGHT)
	{
	    i = OL_MOVERIGHT;
	}
	else if (strcmp (val_ptr, "OL_MOVELEFT") == 0 ||
		 atoi_tmp == OL_MOVELEFT)
	{
	    i = OL_MOVELEFT;
	}
	else if (strcmp (val_ptr, "OL_MOVEUP") == 0 ||
		 atoi_tmp == OL_MOVEUP)
	{
	    i = OL_MOVEUP;
	}
	else if (strcmp (val_ptr, "OL_MOVEDOWN") == 0 ||
		 atoi_tmp == OL_MOVEDOWN)
	{
	    i = OL_MOVEDOWN;
	}
	else if (strcmp (val_ptr, "OL_MULTIRIGHT") == 0 ||
		 atoi_tmp == OL_MULTIRIGHT)
	{
	    i = OL_MULTIRIGHT;
	}
	else if (strcmp (val_ptr, "OL_MULTILEFT") == 0 ||
		 atoi_tmp == OL_MULTILEFT)
	{
	    i = OL_MULTILEFT;
	}
	else if (strcmp (val_ptr, "OL_MULTIUP") == 0 ||
		 atoi_tmp == OL_MULTIUP)
	{
	    i = OL_MULTIUP;
	}
	else if (strcmp (val_ptr, "OL_MULTIDOWN") == 0 ||
		 atoi_tmp == OL_MULTIDOWN)
	{
	    i = OL_MULTIDOWN;
	}
	else if (strcmp (val_ptr, "OL_NEXTFIELD") == 0 ||
		 atoi_tmp == OL_NEXTFIELD)
	{
	    i = OL_NEXTFIELD;
	}
	else if (strcmp (val_ptr, "OL_PREVFIELD") == 0 ||
		 atoi_tmp == OL_PREVFIELD)
	{
	    i = OL_PREVFIELD;
	}
	else
	{
	    fprintf (stderr,
		     "%s: Unsupported MoveFocus direction reqested: %s.\n",
		     XtentProgramName (), val_ptr);
	    ArgNReturn (True);
	}

	w = OlMoveFocus (_xtentNameToWidget (display, toplevel_ptr,
					     buffer, operation,
					     string_one, parse_quarks,
					     parse_bindings,
					     field_count),
			 i, CurrentTime);

	XtentPutStringReturn (&db, ArgN (1),
			      ((w) ? XtentWidgetToName (w) : "None"));

	ArgNReturn (True);
    }
    case OLCanAcceptFocus:
	i = OlCanAcceptFocus (_xtentNameToWidget (display, toplevel_ptr,
						  buffer, operation,
						  string_one, parse_quarks,
						  parse_bindings,
						  field_count),
			      CurrentTime);
	XtentPutStringReturn (&db, ArgN (-1),
			      (i == 0) ? "False" : "True");
	ArgNReturn (True);

    case OLHasFocus:
	i = OlHasFocus (_xtentNameToWidget (display, toplevel_ptr,
					    buffer, operation,
					    string_one, parse_quarks,
					    parse_bindings,
					    field_count));
	XtentPutStringReturn (&db, ArgN (-1),
			      (i == 0) ? "False" : "True");
	ArgNReturn (True);

    case OLSetInputFocus:
	OlSetInputFocus (_xtentNameToWidget (display, toplevel_ptr,
					     buffer, operation,
					     string_one, parse_quarks,
					     parse_bindings,
					     field_count),
			 RevertToParent, CurrentTime);
	ArgNReturn (True);

    case OLGetCurrentFocusWidget:
	w = OlGetCurrentFocusWidget (_xtentNameToWidget (display,
							 toplevel_ptr, buffer,
							 operation,
							 string_one,
							 parse_quarks,
							 parse_bindings,
							 field_count));

	XtentPutStringReturn (&db, ArgN (-1),
			      ((w) ? XtentWidgetToName (w) : "None"));

	ArgNReturn (True);


#if OL_VERSION <= 2  /* RAD - pre-solaris OpenWindows */

    case TextClearBuffer:
    {
	void (*textClearBuffer) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextClearBuffer,
		  (XtArgVal) & textClearBuffer);
	XtGetValues (w, args, 1);
	(*textClearBuffer) (w);
	ArgNReturn (True);
    }

    case TextCopyBuffer:
    {
	char *(*textCopyBuffer) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextCopyBuffer,
		  (XtArgVal) & textCopyBuffer);
	XtGetValues (w, args, 1);
	arg_ptr = (*textCopyBuffer) (w);
	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree ((char *) arg_ptr);
	ArgNReturn (True);
    }

    case TextGetInsertPoint:
    {
	OlTextPosition (*textGetInsertPoint) ();
	OlTextPosition end;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextGetInsertPoint,
		  (XtArgVal) & textGetInsertPoint);
	XtGetValues (w, args, 1);
	end = (*textGetInsertPoint) (w);
	sprintf (copy_buffer, "%ld", end);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);
    }

    case TextGetLastPos:
    {
	OlTextPosition (*textGetLastPos) ();
	OlTextPosition end;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextGetLastPos,
		  (XtArgVal) & textGetLastPos);
	XtGetValues (w, args, 1);
	end = (*textGetLastPos) (w);
	sprintf (copy_buffer, "%ld", end);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);
    }

    case TextInsert:
    {
	void (*textInsert) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextInsert,
		  (XtArgVal) & textInsert);
	XtGetValues (w, args, 1);
	(*textInsert) (w, ArgN (-1));
	ArgNReturn (True);
    }

    case TextReadSubString:
    {
	OlTextPosition start, end;
	int (*textReadSubStr) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextReadSubStr,
		  (XtArgVal) & textReadSubStr);
	XtGetValues (w, args, 1);
	start = atol (ArgN (0));
	end = atol (ArgN (1));
	arg_count = 1 + end - start;
	arg_ptr = XtMalloc (arg_count);
	arg_ptr[arg_count - 1] = '\0';
	start = (*textReadSubStr) (w,
				   start, end,
				   arg_ptr, arg_count,
				   &end);
	XtentPutStringReturn (&db, ArgN (2), arg_ptr);
	XtFree ((char *) arg_ptr);
	ArgNReturn (True);
    }

    case TextRedraw:
    {
	void (*textRedraw) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextRedraw,
		  (XtArgVal) & textRedraw);
	XtGetValues (w, args, 1);
	(*textRedraw) (w);
	ArgNReturn (True);
    }

    case TextReplace:
    {
	char *(*textReplace) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextReplace,
		  (XtArgVal) & textReplace);
	XtGetValues (w, args, 1);
	(*textReplace) (w,
			atol (ArgN (0)), atol (ArgN (1)),
			ArgN (2));
	ArgNReturn (True);
    }

    case TextSetInsertPoint:
    {
	char *(*textSetInsertPoint) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextSetInsertPoint,
		  (XtArgVal) & textSetInsertPoint);
	XtGetValues (w, args, 1);
	(*textSetInsertPoint) (w, atol (ArgN (-1)));
	ArgNReturn (True);
    }

    case TextUpdate:
    {
	char *(*textUpdate) ();

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textWidgetClass, buffer) == False)
	    ArgNReturn (True);
	XtSetArg (args[0], XtNtextUpdate,
		  (XtArgVal) & textUpdate);
	XtGetValues (w, args, 1);
	(*textUpdate) (w, XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);
    }

#endif /* OL_VERSION <= 2  */	/* RAD */

    case OLTextEditClearBuffer:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			      ((XtentTestTextType (w,
						   textEditWidgetClass,
						   buffer) &&
				OlTextEditClearBuffer ((TextEditWidget) w)) ?
			       "True" : "False"));
	ArgNReturn (True);

    case OLTextEditCopyBuffer:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textEditWidgetClass, buffer) &&
	    OlTextEditCopyBuffer ((TextEditWidget) w, &element))
	{
	    XtentXrmPutStringResource (&db, ArgN (0), element, 30);
	    XtFree ((char *) element);
	    XtentPutStringReturn (&db, ArgN (1), "True");
	}
	else
	{
	    XtentPutStringReturn (&db, ArgN (1), "False");
	}
	ArgNReturn (True);

    case OLTextEditCopySelection:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (1),
			      ((XtentTestTextType (w,
						   textEditWidgetClass,
						   buffer) &&
				OlTextEditCopySelection ((TextEditWidget) w,
							 XtentTestTrue (ArgN (0)))) ?
			       "True" : "False"));
	ArgNReturn (True);

    case OLTextEditGetCursorPosition:
    {
	TextPosition start, end, cur;
	/* RAD - TextEdit.h defines these as TextPosition */
	/* OlTextPosition start, end, cur;*/

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (XtentTestTextType (w, textEditWidgetClass, buffer) == False)
	{
	    XtentPutStringReturn (&db, ArgN (3), "False");
	    ArgNReturn (True);
	}

	OlTextEditGetCursorPosition ((TextEditWidget) w, &start, &end, &cur);

	sprintf (copy_buffer, "%d", (int) start);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) end);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	sprintf (copy_buffer, "%d", (int) cur);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);
	XtentPutStringReturn (&db, ArgN (3), "True");
	ArgNReturn (True);
    }

    case OLTextEditGetLastPosition:
    {
	TextPosition pos;

	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (XtentTestTextType (w, textEditWidgetClass, buffer) == False)
	{
	    XtentPutStringReturn (&db, ArgN (1), "False");
	    ArgNReturn (True);
	}

	OlTextEditGetLastPosition ((TextEditWidget) w, &pos);

	sprintf (copy_buffer, "%d", (int) pos);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);
	XtentPutStringReturn (&db, ArgN (1), "True");
	ArgNReturn (True);
    }

    case OLTextEditInsert:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (2),
			      ((XtentTestTextType (w,
						   textEditWidgetClass,
						   buffer) &&
				OlTextEditInsert ((TextEditWidget) w, ArgN (0),
						  atoi (ArgN (1)))) ?
			       "True" : "False"));
	ArgNReturn (True);

    case OLTextEditPaste:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
			((XtentTestTextType (w, textEditWidgetClass, buffer) &&
				OlTextEditPaste ((TextEditWidget) w)) ? "True" : "False"));
	ArgNReturn (True);

    case OLTextEditReadSubString:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textEditWidgetClass, buffer) &&
	    OlTextEditReadSubString ((TextEditWidget) w, &element,
				     atoi (ArgN (1)), atoi (ArgN (2))))
	{
	    XtentXrmPutStringResource (&db, ArgN (0), element, 30);
	    XtFree ((char *) element);
	    XtentPutStringReturn (&db, ArgN (3), "True");
	}
	else
	{
	    XtentPutStringReturn (&db, ArgN (3), "False");
	}
	ArgNReturn (True);

    case OLTextEditRedraw:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (-1),
		       ((XtentTestTextType (w, textEditWidgetClass, buffer) &&
				OlTextEditRedraw ((TextEditWidget) w)) ? "True" : "False"));
	ArgNReturn (True);

    case OLTextEditSetCursorPosition:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	if (XtentTestTextType (w, textEditWidgetClass, buffer) ==
	    False)
	{
	    XtentPutStringReturn (&db, ArgN (3), "False");
	    ArgNReturn (True);
	}
	OlTextEditSetCursorPosition ((TextEditWidget) w, (TextPosition)
				     atoi (ArgN (0)),
				     (TextPosition)
				     atoi (ArgN (1)),
				     (TextPosition)
				     atoi (ArgN (2)));
	XtentPutStringReturn (&db, ArgN (3), "True");
	ArgNReturn (True);

    case OLTextEditUpdate:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtentPutStringReturn (&db, ArgN (1),
			      ((XtentTestTextType (w,
						   textEditWidgetClass,
						   buffer) &&
				OlTextEditUpdate ((TextEditWidget) w,
						  XtentTestTrue (ArgN (0)))) ?
			       "True" : "False"));
	ArgNReturn (True);

    case OLTextFieldCopyString:
    case OLTextFieldGetString:
	w = _xtentNameToWidget (display, toplevel_ptr,
				buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	if (XtentTestTextType (w, textFieldWidgetClass, buffer) ==
	    False)
	    ArgNReturn (True);
	arg_ptr = OlTextFieldGetString ((TextFieldWidget) w, &i);
	XtentXrmPutStringResource (&db,
		       ArgN (((op -> type == OLTextFieldCopyString) ? -1 : 0)),
				   arg_ptr, 30);
	XtFree ((char *) arg_ptr);
	if (op -> type == OLTextFieldCopyString)
	    ArgNReturn (True);
	sprintf (copy_buffer, "%d", i);
	XtentPutStringReturn (&db, ArgN (1), copy_buffer);
	ArgNReturn (True);

    case OLMenuPopup:
    {
	Position x, y;

	/*
	 * emanate widget
	 */
	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0' ||
	    (strcmp (arg_ptr, "None") == 0) ||
	    (strcmp (arg_ptr, "NULL") == 0))
	{
	    w = (Widget) NULL;
	}
	else
	{
	    w = XtentNameToWidget (arg_ptr);
	}

	/*
	 * item index
	 */
	i = atoi (ArgN (1));

	/*
	 * state
	 */
	arg_ptr = ArgN (2);
	if ((strcmp (arg_ptr, "OL_PINNED_MENU") == 0) ||
	    (strcmp (arg_ptr, "ol_pinned_menu") == 0) ||
	    (strcmp (arg_ptr, "PINNED_MENU") == 0) ||
	    (strcmp (arg_ptr, "pinned_menu") == 0))
	    j = OL_PINNED_MENU;
	else if ((strcmp (arg_ptr, "OL_PRESS_DRAG_MENU") == 0) ||
		 (strcmp (arg_ptr, "ol_press_drag_menu") == 0) ||
		 (strcmp (arg_ptr, "PRESS_DRAG_MENU") == 0) ||
		 (strcmp (arg_ptr, "press_drag_menu") == 0))
	    j = OL_PRESS_DRAG_MENU;
	else if ((strcmp (arg_ptr, "OL_STAYUP_MENU") == 0) ||
		 (strcmp (arg_ptr, "ol_stayup_menu") == 0) ||
		 (strcmp (arg_ptr, "STAYUP_MENU") == 0) ||
		 (strcmp (arg_ptr, "stayup_menu") == 0))
	    j = OL_STAYUP_MENU;
	else
	{
	    fprintf (stderr,
		     "%s: Error in OlMenuPopup at line %d, message %d: \"%s\"\n",
		     XtentProgramName (), XtentLineCount (),
		     XtentMessageCount (), buffer);
	    fprintf (stderr,
		     "%s: Unsupported OlPopupMenu state: %s.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	/*
	 * set_position
	 */
	arg_count = XtentTestTrue (ArgN (3));

	/*
	 * x, y
	 */
	x = atoi (ArgN (4));
	y = atoi (ArgN (5));
	OlMenuPopup (_xtentNameToWidget (display, toplevel_ptr, buffer,
					 operation,
					 string_one, parse_quarks,
					 parse_bindings,
					 field_count),
		     w, i, j, arg_count, x, y,
		     (OlMenuPositionProc) NULL);
	ArgNReturn (True);
    }

    case OLMenuPopdown:
	OlMenuPopdown (_xtentNameToWidget (display, toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count),
		       XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case OLMenuPost:
	OlMenuPost (_xtentNameToWidget (display, toplevel_ptr, buffer,
					operation,
					string_one, parse_quarks,
					parse_bindings,
					field_count));
	ArgNReturn (True);

    case OLMenuUnpost:
	OlMenuUnpost (_xtentNameToWidget (display, toplevel_ptr, buffer,
					  operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count));
	ArgNReturn (True);


    case OLSLApplAddItem:
    {
	OlListToken (*applAddItem) (), token;
	OlListItem sl_item;
	OLSLDestroyCallbackListItem * list_item_ptr;
	OLSLDestroyCallbackListItem * list_ptr = (OLSLDestroyCallbackListItem *) NULL;
	memset (&sl_item, '\0', sizeof (OlListItem));

	/*
	 * get the function pointer
	 */
	XtSetArg (args[0], XtNuserData, (XtArgVal) & list_ptr);
	XtSetArg (args[1], XtNapplAddItem, (XtArgVal) & applAddItem);
	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtGetValues (w, args, 2);

	/*
	 * parent, reference
	 */
	i = atoi (ArgN (0));
	j = atoi (ArgN (1));

	/*
	 * label_type
	 */
	arg_ptr = ArgN (2);
	if ((strcmp (arg_ptr, "String") == 0) ||
	    (strcmp (arg_ptr, "string") == 0) ||
	    (strcmp (arg_ptr, "STRING") == 0) ||
	    (strcmp (arg_ptr, "OL_STRING") == 0) ||
	    (strcmp (arg_ptr, "ol_string") == 0))
	{
	    val_ptr = ArgN (3);

	    if (list_ptr == (OLSLDestroyCallbackListItem *) NULL)
		XtAddCallback (w, XtNdestroyCallback,
			       (XtCallbackProc) XtentOLSLDestroyCallbackProc,
			       (XtPointer) NULL);
	    list_item_ptr = (OLSLDestroyCallbackListItem *)
		XtMalloc (sizeof (OLSLDestroyCallbackListItem) + strlen (val_ptr));
	    strcpy (list_item_ptr -> args, val_ptr);
	    list_item_ptr -> next = list_ptr;
	    list_ptr = list_item_ptr;

	    XtSetArg (args[0], XtNuserData, (XtArgVal) list_ptr);
	    XtSetValues (w, args, 1);

	    sl_item.label_type = OL_STRING;
	    sl_item.label = (XtPointer) list_item_ptr -> args;
	}
	else if ((strcmp (arg_ptr, "Image") == 0) ||
		 (strcmp (arg_ptr, "image") == 0) ||
		 (strcmp (arg_ptr, "IMAGE") == 0) ||
		 (strcmp (arg_ptr, "OL_IMAGE") == 0) ||
		 (strcmp (arg_ptr, "ol_image") == 0))
	{
	    XrmValue from_value, to_value;

	    sl_item.label_type = OL_IMAGE;
	    from_value.addr = (XtPointer) ArgN (3);
	    from_value.size = sizeof (XtPointer);
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;
	    _XtConvert (w, XtQImage, &from_value,
			XtQString, &to_value, NULL);

	    if (to_value.size && to_value.addr)
		sl_item.label = (XtPointer) to_value.addr;
	    else
		sl_item.label = (XtPointer) NULL;
	}
	else
	{
	    fprintf (stderr,
	       "%s: Error in OlSLApplAddItem at line %d, message %d: \"%s\"\n",
		     XtentProgramName (), XtentLineCount (),
		     XtentMessageCount (), buffer);
	    fprintf (stderr, "%s: Unsupported label_type: %s.\n",
		     XtentProgramName (), arg_ptr);
	    ArgNReturn (True);
	}

	/*
	 * glyph
	 */
	arg_ptr = ArgN (4);
	sl_item.glyph = (XImage *) NULL;
	if (*arg_ptr && (strcmp (arg_ptr, "0") != 0) &&
	    (strcmp (arg_ptr, "None") != 0))
	{
	    XrmValue from_value, to_value;

	    from_value.addr = (XtPointer) arg_ptr;
	    from_value.size = sizeof (XtPointer);
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;
	    _XtConvert (w, XtQImage, &from_value,
			XtQString, &to_value, NULL);

	    if (to_value.size && to_value.addr)
		sl_item.glyph = (XImage *) to_value.addr;
	}

	/*
	 * attr
	 */
	sl_item.attr = (OlBitMask) atoi (ArgN (5));

	token = (*applAddItem) (w, i, j, sl_item);

	sprintf (copy_buffer, "%d", token);
	XtentPutStringReturn (&db, ArgN (6), copy_buffer);

	ArgNReturn (True);
    }

    case OLSLApplDeleteItem:
    {
	void (*applDeleteItem) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplDeleteItem,
		  (XtArgVal) & applDeleteItem);
	XtGetValues (w, args, 1);

	(*applDeleteItem) (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case OLSLApplEditClose:
    {
	void (*applEditClose) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplEditClose,
		  (XtArgVal) & applEditClose);
	XtGetValues (w, args, 1);

	(*applEditClose) (w);

	ArgNReturn (True);
    }

    case OLSLApplEditOpen:
    {
	void (*applEditOpen) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplEditOpen,
		  (XtArgVal) & applEditOpen);
	XtGetValues (w, args, 1);

	(*applEditOpen) (w, XtentTestTrue (ArgN (0)), atoi (ArgN (1)));

	ArgNReturn (True);
    }

    case OLSLApplTouchItem:
    {
	void (*applTouchItem) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplTouchItem,
		  (XtArgVal) & applTouchItem);
	XtGetValues (w, args, 1);

	(*applTouchItem) (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    case OLSLApplUpdateView:
    {
	void (*applUpdateView) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplUpdateView,
		  (XtArgVal) & applUpdateView);
	XtGetValues (w, args, 1);

	(*applUpdateView) (w, XtentTestTrue (ArgN (-1)));

	ArgNReturn (True);
    }

    case OLSLApplViewItem:
    {
	void (*applViewItem) ();

	w = _xtentNameToWidget (display, toplevel_ptr, buffer,
				operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	XtSetArg (args[0], XtNapplViewItem,
		  (XtArgVal) & applViewItem);
	XtGetValues (w, args, 1);

	(*applViewItem) (w, atoi (ArgN (-1)));

	ArgNReturn (True);
    }

    /*
     * dnd: drag and drop support for OpenLook
     */
#ifndef OLD_OPENLOOK
    case OLDnDAllocTransientAtom:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	XtentPutStringReturn (&db,
			      ArgN (-1),
			      XtentAtomToString (display,
						 OlDnDAllocTransientAtom (w)));
	ArgNReturn (True);
    }

    case OLDnDBeginSelectionTransaction:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	OlDnDBeginSelectionTransaction (w,
					XtentStringToAtom (display, ArgN (0)),
					XtLastTimestampProcessed (display),
		(OlDnDProtocolActionCbP) XtentOlDnDProtocolActionCallbackProc,
					XtNewString (ArgN (1)));
	ArgNReturn (True);
    }

    case OLDnDChangeDropSitePreviewHints:
    {
	i = OlDnDChangeDropSitePreviewHints ((OlDnDDropSiteID) atol (ArgN (0)), /* dropsite id */
					     (OlDnDSitePreviewHints) atol (ArgN (1))); /* hints flag */

	XtentPutStringReturn (&db, ArgN (2),
			      XtentCalcTrueOrFalseString (i));
	ArgNReturn (True);
    }

    case OLDnDClearDragState:
    {
	OlDnDClearDragState (_xtentNameToWidget (display, toplevel_ptr, buffer,
						 operation,
						 string_one, parse_quarks,
						 parse_bindings,
						 field_count));
	ArgNReturn (True);
    }

    case OLDnDDeliverPreviewMessage:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	i = OlDnDDeliverPreviewMessage (w, /* selection owner */
					atoi (ArgN (0)), /* drop top window */
					atoi (ArgN (1)), /* root x */
					atoi (ArgN (2)), /* root y */
					XtLastTimestampProcessed (display));

	XtentPutStringReturn (&db, ArgN (3),
			      XtentCalcTrueOrFalseString (i));
	ArgNReturn (True);
    }

    case OLDnDDeliverTriggerMessage:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	i = OlDnDDeliverTriggerMessage (w, /* selection owner */
					atoi (ArgN (0)), /* root */
					atoi (ArgN (1)), /* root x */
					atoi (ArgN (2)), /* root y */
		  XtentStringToAtom (display, ArgN (3)), /* selection */
					atoi (ArgN (4)), /* operation */
					XtLastTimestampProcessed (display));

	XtentPutStringReturn (&db, ArgN (5),
			      XtentCalcTrueOrFalseString (i));
	ArgNReturn (True);
    }

    case OLDnDDestroyDropSite:
    {
	OLDropSiteMessageLine *ds, *ds_prev;
	OlDnDDropSiteID id = (OlDnDDropSiteID) atol (ArgN (-1));

	ds = XtentOLDropSiteMessageLines;
	ds_prev = (OLDropSiteMessageLine *) NULL;
	while (ds)
	{
	    if (ds -> id == id)
	    {
		if (ds_prev)
		    ds_prev = ds -> next;
		else
		    XtentOLDropSiteMessageLines = ds -> next;

		XtFree ((char *) ds);
		break;
	    }
	    ds = ds -> next;
	}

	OlDnDDestroyDropSite (id);
	ArgNReturn (True);
    }

    case OLDnDDisownSelection:
    {
	Atom atom;
	SelectionLine *s, *s_prev;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	atom = XtentStringToAtom (display, ArgN (-1));

	s = SelectionLines;
	s_prev = (SelectionLine *) NULL;
	while (s)
	{
	    if (s -> widget == w && s -> selection == atom)
		break;
	    s_prev = s;
	    s = s -> next;
	}
	if (s)
	{
	    if (s_prev)
		s_prev -> next = s -> next;
	    else
		SelectionLines = s -> next;

	    XtFree ((char *) s -> malloc_return);
	    XtFree ((char *) s);
	}

	OlDnDDisownSelection (w, atom, XtLastTimestampProcessed (display));

	ArgNReturn (True);
    }

    case OLDnDDragAndDrop:
    {
	Window window;
	Position x, y;
	OlDnDDragDropInfo drop_info;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (4);
	if (*arg_ptr)
	    j = OlDnDDragAndDrop (w, &window, &x, &y, &drop_info,
		(OlDnDPreviewAnimateCbP) XtentOlDnDPreviewAnimateCallbackProc,
				  arg_ptr);
	else
	    j = OlDnDDragAndDrop (w, &window, &x, &y, &drop_info, NULL, NULL);

	sprintf (copy_buffer, "%d", window);
	XtentXrmPutStringResource (&db,
				   ArgN (0), copy_buffer, 30);

	sprintf (copy_buffer, "%d", x);
	XtentXrmPutStringResource (&db,
				   ArgN (1), copy_buffer, 30);

	sprintf (copy_buffer, "%d", y);
	XtentXrmPutStringResource (&db,
				   ArgN (2), copy_buffer, 30);

	arg_ptr = ArgN (3);
	i = strlen (arg_ptr) + 16;
	val_ptr = (char *) XtMalloc (i);

	sprintf (val_ptr, "%s.root-window", arg_ptr);
	sprintf (copy_buffer, "%d", drop_info.root_window);
	XtentXrmPutStringResource (&db, val_ptr, copy_buffer, 30);

	sprintf (val_ptr, "%s.root-x", arg_ptr);
	sprintf (copy_buffer, "%d", drop_info.root_x);
	XtentXrmPutStringResource (&db, val_ptr, copy_buffer, 30);

	sprintf (val_ptr, "%s.root-y", arg_ptr);
	sprintf (copy_buffer, "%d", drop_info.root_y);
	XtentXrmPutStringResource (&db, val_ptr, copy_buffer, 30);

	sprintf (val_ptr, "%s.time", arg_ptr);
	sprintf (copy_buffer, "%d", drop_info.drop_timestamp);
	XtentXrmPutStringResource (&db, val_ptr, copy_buffer, 30);

	XtFree (val_ptr);

	XtentPutStringReturn (&db, ArgN (5),
			      XtentCalcTrueOrFalseString (j));
	ArgNReturn (True);
    }

    case OLDnDDragNDropDone:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	OlDnDDragNDropDone (w,
			    XtentStringToAtom (display, ArgN (0)), /* atom */
			    XtLastTimestampProcessed (display),
		(OlDnDProtocolActionCbP) XtentOlDnDProtocolActionCallbackProc,
			    XtNewString (ArgN (1)));
	ArgNReturn (True);
    }

    case OLDnDEndSelectionTransaction:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	OlDnDEndSelectionTransaction (w,
				       /* atom */
				      XtentStringToAtom (display, ArgN (0)),
				      XtLastTimestampProcessed (display),
		(OlDnDProtocolActionCbP) XtentOlDnDProtocolActionCallbackProc,
				      XtNewString (ArgN (1)));
	ArgNReturn (True);
    }

    case OLDnDErrorDuringSelectionTransaction:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	OlDnDErrorDuringSelectionTransaction (w,
				       /* atom */
				      XtentStringToAtom (display, ArgN (0)),
				      XtLastTimestampProcessed (display),
		(OlDnDProtocolActionCbP) XtentOlDnDProtocolActionCallbackProc,
				      XtNewString (ArgN (1)));
	ArgNReturn (True);
    }

    case OLDnDFreeTransientAtom:
    {
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	OlDnDFreeTransientAtom (w, XtentStringToAtom (display, ArgN (0)));
	ArgNReturn (True);
    }

    case OLDnDGetCurrentSelectionsForWidget:
    {
	Atom *atom_return;
	Cardinal num_sites_return;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);
	i = OlDnDGetCurrentSelectionsForWidget (w, &atom_return,
						&num_sites_return);
	if (i == False)
	    num_sites_return = 0;

	arg_ptr = ArgN (-1);
	i = strlen (arg_ptr) + 64;
	val_ptr = (char *) XtMalloc (i);

	sprintf (val_ptr, "%s.num-sites", arg_ptr);
	sprintf (copy_buffer, "%d", num_sites_return);
	XtentXrmPutStringResource (&db, arg_ptr, copy_buffer, 30);

	for (i = 0; i < num_sites_return; i++)
	{
	    sprintf (val_ptr, "%s.%d", arg_ptr, i);
	    XtentXrmPutStringResource (&db, arg_ptr,
				  XtentAtomToString (display, atom_return[i]),
				       30);
	}

	if (num_sites_return)
	    XtFree ((char *) atom_return);

	ArgNReturn (True);
    }

    case OLDnDGetDropSitesOfWidget:
    case OLDnDGetDropSitesOfWindow:
    {
	OlDnDDropSiteID *dropsite_return;
	Cardinal num_sites_return;

	if (op -> type == OLDnDGetDropSitesOfWidget)
	{
	    w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				    string_one, parse_quarks, parse_bindings,
				    field_count);
	    dropsite_return = OlDnDGetDropSitesOfWidget (w, &num_sites_return);

	    arg_ptr = ArgN (0);
	}
	else
	{
	    dropsite_return = OlDnDGetDropSitesOfWindow (display,
							 atol (ArgN (0)),
							 &num_sites_return);
	    arg_ptr = ArgN (1);
	}
	if (dropsite_return == (OlDnDDropSiteID *) NULL)
	    num_sites_return = 0;

	i = strlen (arg_ptr) + 64;
	val_ptr = (char *) XtMalloc (i);

	sprintf (val_ptr, "%s.num-sites", arg_ptr);
	sprintf (copy_buffer, "%d", num_sites_return);
	XtentXrmPutStringResource (&db, arg_ptr, copy_buffer, 30);

	for (i = 0; i < num_sites_return; i++)
	{
	    sprintf (val_ptr, "%s.%d", arg_ptr, i);
	    sprintf (copy_buffer, "%d", dropsite_return[i]);
	    XtentXrmPutStringResource (&db, arg_ptr, copy_buffer,
				       30);
	}

	if (num_sites_return)
	    XtFree ((char *) dropsite_return);
	ArgNReturn (True);
    }

    case OLDnDGetWidgetOfDropSite:
    {
	w = OlDnDGetWidgetOfDropSite ((OlDnDDropSiteID) atol (ArgN (0)));
	XtentPutStringReturn (&db, ArgN (1),
			      ((w) ? XtentWidgetToName (w): "None"));
	ArgNReturn (True);
    }

    case OLDnDGetWindowOfDropSite:
    {
	Window window;

	window = OlDnDGetWindowOfDropSite ((OlDnDDropSiteID) atol (ArgN (0)));
	sprintf (copy_buffer, "%d", window);
	XtentPutStringReturn (&db, ArgN (1),
			      (window ? copy_buffer : "None"));
	ArgNReturn (True);
    }

    case OLDnDInitializeDragState:
    {
	i = OlDnDInitializeDragState (_xtentNameToWidget (display, toplevel_ptr,
							  buffer, operation,
							  string_one,
							  parse_quarks,
							  parse_bindings,
							  field_count));
	XtentPutStringReturn (&db, ArgN (-1),
			      XtentCalcTrueOrFalseString (i));
	ArgNReturn (True);
    }

    case OLDnDOwnSelection:
    {
	Atom atom;
	SelectionLine *s;
	char *atom_name = ArgN (0);
	int atom_name_length = strlen (atom_name) + 1;
	char *trans_code;
	int trans_length;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	atom = XtentStringToAtom (display, atom_name);

	arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 1,
				    op -> type == OLDnDOwnSelection);
	arg_count = strlen (arg_ptr) + 1;

	val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data, 2,
				    op -> type == OLDnDOwnSelection);
	i = strlen (val_ptr) + 1;

	element = XtentProcessArgN (display, toplevel_ptr, &frame_data, 3,
				    op -> type == OLDnDOwnSelection);
	j = strlen (element) + 1;

	trans_code = XtentProcessArgN (display, toplevel_ptr, &frame_data, 4,
				    op -> type == OLDnDOwnSelection);
	trans_length = strlen (trans_code) + 1;

	s = (SelectionLine *) XtMalloc (sizeof (SelectionLine) +
					arg_count + i + j + atom_name_length +
					trans_length);
	s -> widget = w;
	s -> selection = atom;
	s -> malloc_return = (XtPointer) NULL;

	if (arg_count <= 1)
	    *s -> convert_code = '\0';
	else
	    memcpy (s -> convert_code, arg_ptr, arg_count);

	s -> lose_code = s -> convert_code + arg_count;
	if (i <= 1)
	    *s -> lose_code = '\0';
	else
	    memcpy (s -> lose_code, val_ptr, i);

	s -> done_code = s -> lose_code + i;
	if (j <= 1)
	    *s -> done_code = '\0';
	else
	    memcpy (s -> done_code, element, j);

	s -> selection_atom_string = s -> done_code + j;
	if (atom_name_length <= 1)
	    *s -> selection_atom_string = '\0';
	else
	    memcpy (s -> selection_atom_string, atom_name, atom_name_length);

	s -> transaction_state_code = s -> selection_atom_string +
	    atom_name_length;

	if (trans_length <= 1)
	    *s -> transaction_state_code = '\0';
	else
	    memcpy (s -> transaction_state_code, trans_code, trans_length);

	s -> next = SelectionLines;
	SelectionLines = s;

	i = OlDnDOwnSelection (w, atom, XtLastTimestampProcessed (display),
			       XtentConvertSelectionProc,
			       XtentLoseSelectionProc,
			       XtentDoneSelectionProc,
			       XtentOlDnDTransactionStateCallback,
			       (XtPointer) s);

	XtentPutStringReturn (&db, ArgN (5),
			      XtentCalcTrueOrFalseString (i));

	ArgNReturn (True);
    }

    /*
     * we are currently not implmenting incremenatal selections
    case OLDnDOwnSelectionIncremental:
    {
	OlDnDOwnSelectionIncremental ();
	ArgNReturn (True);
    }
    */

    case OLDnDQueryDropSiteInfo:
    {
	Window window;
	OlDnDSitePreviewHints preview_hints;
	OlDnDSiteRect *siterects;
	unsigned int num_rects;
	Boolean on_interest;

	j = OlDnDQueryDropSiteInfo ((OlDnDDropSiteID) atol (ArgN (0)), /* drop site id */
				    &w, &window, &preview_hints,
				    &siterects, &num_rects, &on_interest);

	XtentXrmPutStringResource (&db, ArgN (1),
				   XtentWidgetToName (w), 30);

	sprintf (copy_buffer, "%d", window);
	XtentXrmPutStringResource (&db, ArgN (2), copy_buffer, 30);

	sprintf (copy_buffer, "%d", preview_hints);
	XtentXrmPutStringResource (&db, ArgN (3), copy_buffer, 30);

	arg_ptr = ArgN (4);
	i = strlen (arg_ptr) + 16;
	val_ptr = (char *) XtMalloc (i);
	for (i = 0; i < num_rects; i++)
	{
	    sprintf (val_ptr, "%s.x", arg_ptr);
	    sprintf (copy_buffer, "%d", siterects[i].x);
	    XtentXrmPutStringResource (&db, val_ptr, copy_buffer,
				       30);
	    sprintf (val_ptr, "%s.y", arg_ptr);
	    sprintf (copy_buffer, "%d", siterects[i].y);
	    XtentXrmPutStringResource (&db, val_ptr, copy_buffer,
				       30);
	    sprintf (val_ptr, "%s.width", arg_ptr);
	    sprintf (copy_buffer, "%d", siterects[i].width);
	    XtentXrmPutStringResource (&db, val_ptr, copy_buffer,
				       30);
	    sprintf (val_ptr, "%s.height", arg_ptr);
	    sprintf (copy_buffer, "%d", siterects[i].height);
	    XtentXrmPutStringResource (&db, val_ptr, copy_buffer,
				       30);
	}
	XtFree (val_ptr);

	sprintf (copy_buffer, "%d", num_rects);
	XtentXrmPutStringResource (&db, ArgN (5), copy_buffer, 30);

	XtentXrmPutStringResource (&db, ArgN (6),
				   XtentCalcTrueOrFalseString (on_interest),
				   30);

	XtentXrmPutStringResource (&db, ArgN (7),
				   XtentCalcTrueOrFalseString (j), 30);
	ArgNReturn (True);
    }

    case OLDnDRegisterWidgetDropSite:
    case OLDnDRegisterWindowDropSite:
    case OLDnDUpdateDropSiteGeometry:
    {
	OlDnDSiteRect *site_rects_ptr;
	unsigned int num_site_rects;
	OLDropSiteMessageLine *ds;
	OlDnDDropSiteID id;
	Window window;
	OlDnDSitePreviewHints preview_hints;
	int expand;

	expand = (op -> type == OLDnDRegisterWidgetDropSite ||
		  op -> type == OLDnDRegisterWindowDropSite);

	if (op -> type == OLDnDUpdateDropSiteGeometry)
	{
	    id = (OlDnDDropSiteID) atol (ArgN (0));
	    arg_count = 1;
	}
	else
	{
	    if (op -> type == OLDnDRegisterWidgetDropSite)
	    {
		w = _xtentNameToWidget (display, toplevel_ptr, buffer,
					operation,
					string_one, parse_quarks,
					parse_bindings,
					field_count);
		arg_count = 0;
	    }
	    else
	    {
		window = atol (ArgN (0));
		arg_count = 1;
	    }

	    preview_hints = atol (ArgN (arg_count)); /* preview hints */
	    arg_count++;
	}
	arg_ptr = ArgN (arg_count); /* name for site rects */
	arg_count++;
	i = strlen (arg_ptr) + 64;
	val_ptr = (char *) XtMalloc (i);

	num_site_rects = atol (ArgN (arg_count)); /* number of site rects */
	arg_count++;

	site_rects_ptr = (OlDnDSiteRect *) XtMalloc (sizeof (OlDnDSiteRect) *
						     num_site_rects);
	for (i = 0; i < num_site_rects; i++)
	{
	    XrmString value_type;
	    XrmValue value_return;

	    sprintf (val_ptr, "%s.%d.x", arg_ptr, i);
	    if (!(XrmGetResource (XtDatabase (display),
				  val_ptr, (char *) NULL,
				  &value_type, &value_return) &&
		  value_return.size > 0))
		site_rects_ptr[i].x = 0;
	    else
		site_rects_ptr[i].x = atoi ((char *) value_return.addr);

	    sprintf (val_ptr, "%s.%d.y", arg_ptr, i);
	    if (!(XrmGetResource (XtDatabase (display),
				  val_ptr, (char *) NULL,
				  &value_type, &value_return) &&
		  value_return.size > 0))
		site_rects_ptr[i].y = 0;
	    else
		site_rects_ptr[i].y = atoi ((char *) value_return.addr);

	    sprintf (val_ptr, "%s.%d.width", arg_ptr, i);
	    if (!(XrmGetResource (XtDatabase (display),
				  val_ptr, (char *) NULL,
				  &value_type, &value_return) &&
		  value_return.size > 0))
		site_rects_ptr[i].width = 0;
	    else
		site_rects_ptr[i].width = atoi ((char *) value_return.addr);

	    sprintf (val_ptr, "%s.%d.height", arg_ptr, i);
	    if (!(XrmGetResource (XtDatabase (display),
				  val_ptr, (char *) NULL,
				  &value_type, &value_return) &&
		  value_return.size > 0))
		site_rects_ptr[i].height = 0;
	    else
		site_rects_ptr[i].height = atoi ((char *) value_return.addr);
	}
	XtFree (val_ptr);

	if (op -> type == OLDnDUpdateDropSiteGeometry)
	{
	    i = OlDnDUpdateDropSiteGeometry (id,
				     site_rects_ptr, /* site rects */
				     num_site_rects); /* num site rects */

	    XtentPutStringReturn (&db, ArgN (arg_count),
				  XtentCalcTrueOrFalseString (i));
	}
	else
	{
	    arg_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data,
					arg_count, expand);
	    arg_count++;
	    i = strlen (arg_ptr) + 1;

	    val_ptr = XtentProcessArgN (display, toplevel_ptr, &frame_data,
					arg_count, expand);
	    arg_count++;
	    j = strlen (val_ptr) + 1;

	    ds = (OLDropSiteMessageLine *)
		XtMalloc (sizeof (OLDropSiteMessageLine) + i + j);

	    ds -> trigger_code = ds -> preview_code + j;

	    if (i <= 1)
		*ds -> trigger_code = '\0';
	    else
		memcpy (ds -> trigger_code, arg_ptr, i);

	    if (j <= 1)
		*ds -> preview_code = '\0';
	    else
		memcpy (ds -> preview_code, val_ptr, j);

	    i = XtentTestTrue (ArgN (arg_count));
	    arg_count++;
	    if (op -> type == OLDnDRegisterWidgetDropSite)
	    {
		id = OlDnDRegisterWidgetDropSite (w, /* widget */
					  preview_hints,
					  site_rects_ptr, /* site rects */
					  num_site_rects, /* num site rects */
				(OlDnDTMNotifyProc) ((*ds -> trigger_code) ?
				    XtentOlDnDTriggerMessageNotifyProc : NULL),
				(OlDnDPMNotifyProc) ((*ds -> preview_code) ?
				    XtentOlDnDPreviewMessageNotifyProc : NULL),
					  i, (XtPointer) ds);
	    }
	    else if (op -> type == OLDnDRegisterWindowDropSite)
	    {
		id = OlDnDRegisterWindowDropSite (display, window,
					  preview_hints,
					  site_rects_ptr, /* site rects */
					  num_site_rects, /* num site rects */
				(OlDnDTMNotifyProc) ((*ds -> trigger_code) ?
				    XtentOlDnDTriggerMessageNotifyProc : NULL),
				(OlDnDPMNotifyProc) ((*ds -> preview_code) ?
				    XtentOlDnDPreviewMessageNotifyProc : NULL),
					  i, (XtPointer) ds);
	    }
	    ds -> id = id;
	    ds -> next = XtentOLDropSiteMessageLines;
	    XtentOLDropSiteMessageLines = ds;

	    sprintf (copy_buffer, "%d", id);
	    XtentXrmPutStringResource (&db, ArgN (arg_count),
				       copy_buffer, 30);
	}
	XtFree ((char *) site_rects_ptr);

	ArgNReturn (True);
    }

    case OLDnDSetDropSiteInterest:
    {
	OlDnDSetDropSiteInterest ((OlDnDDropSiteID) atol (ArgN (0)), /* drop site id */
				  XtentTestTrue (ArgN (1))); /* active flag */
	ArgNReturn (True);
    }

    case OLDnDSetInterestInWidgetHier:
    {
	OlDnDSetInterestInWidgetHier (_xtentNameToWidget (display,
							  toplevel_ptr,
							  buffer, operation,
							  string_one,
							  parse_quarks,
							  parse_bindings,
							  field_count),
				  XtentTestTrue (ArgN (-1))); /* active flag */
	ArgNReturn (True);
    }

    case OLDnDWidgetConfiguredInHier:
    {
	OlDnDWidgetConfiguredInHier (_xtentNameToWidget (display,
							 toplevel_ptr,
							 buffer, operation,
							 string_one,
							 parse_quarks,
							 parse_bindings,
							 field_count));
	ArgNReturn (True);
    }

    case OLGrabDragPointer:
    {
	Cursor cursor;
	XrmValue from_value, to_value;

	w = _xtentNameToWidget (display, toplevel_ptr, buffer, operation,
				string_one, parse_quarks, parse_bindings,
				field_count);

	arg_ptr = ArgN (0);
	if (*arg_ptr == '\0' || (strcmp (arg_ptr, "None") == 0))
	    cursor = (Cursor) None;
	else
	{
	    from_value.addr = arg_ptr;
	    from_value.size = strlen (arg_ptr) + 1;
	    to_value.size = 0;
	    to_value.addr = (XtPointer) NULL;

	    _XtConvert (w, XtQString, &from_value, XtQCursor, &to_value, NULL);

	    if (to_value.size && to_value.addr)
		cursor = *((Cursor *) to_value.addr);
	    else
		cursor = (Cursor) None;
	}

	OlGrabDragPointer (w, cursor, atoi (ArgN (1)));

	ArgNReturn (True);
    }

    case OLUngrabDragPointer:
    {
	OlUngrabDragPointer (_xtentNameToWidget (display, toplevel_ptr,
						 buffer, operation,
						 string_one, parse_quarks,
						 parse_bindings,
						 field_count));
	ArgNReturn (True);
    }

#endif /* OLD_OPENLOOK */

#endif					/* OPENLOOK */

#ifdef HP_WIDGETS

    case TextClearBuffer:
	XwTextClearBuffer (_xtentNameToWidget (display, toplevel_ptr,
					       buffer, operation,
					       string_one, parse_quarks,
					       parse_bindings,
					       field_count));
	ArgNReturn (True);

    case TextCopyBuffer:
	arg_ptr = (char *) XwTextCopyBuffer (_xtentNameToWidget
					     (display,
					      toplevel_ptr,
					      buffer,
					      operation,
					      string_one, parse_quarks,
					      parse_bindings,
					      field_count));
	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree ((char *) arg_ptr);
	ArgNReturn (True);

    case TextReadSubString:
    {
	XwTextPosition start, end;

	start = atol (ArgN (0));
	end = atol (ArgN (1));
	arg_count = 1 + end - start;
	arg_ptr = XtMalloc (arg_count);
	arg_ptr[arg_count - 1] = '\0';
	start = XwTextReadSubString (_xtentNameToWidget (display,
							 toplevel_ptr,
							 buffer,
							 operation,
							 string_one,
							 parse_quarks,
							 parse_bindings,
							 field_count),
				     start, end,
				     arg_ptr, arg_count,
				     &end);
	XtentPutStringReturn (&db, ArgN (2), arg_ptr);
	XtFree ((char *) arg_ptr);
	ArgNReturn (True);
    }

    case TextCopySelection:
	arg_ptr = (char *) XwTextCopySelection (_xtentNameToWidget
						(display,
						 toplevel_ptr,
						 buffer,
						 operation,
						 string_one, parse_quarks,
						 parse_bindings,
						 field_count));

	XtentPutStringReturn (&db, ArgN (-1), arg_ptr);
	XtFree ((char *) arg_ptr);
	ArgNReturn (True);

    case TextUnsetSelection:
	XwTextUnsetSelection (_xtentNameToWidget (display, toplevel_ptr,
						  buffer, operation,
						  string_one, parse_quarks,
						  parse_bindings,
						  field_count));
	ArgNReturn (True);

    case TextSetSelection:
	XwTextSetSelection (_xtentNameToWidget (display, toplevel_ptr,
						buffer, operation,
						string_one, parse_quarks,
						parse_bindings,
						field_count),
			    atol (ArgN (0)),
			    atol (ArgN (1)));
	ArgNReturn (True);

    case TextGetSelectionPos:
    {
	XwTextPosition start, end;

	XwTextGetSelectionPos (_xtentNameToWidget (display,
						   toplevel_ptr,
						   buffer, operation,
						   string_one, parse_quarks,
						   parse_bindings,
						   field_count),
			       &start, &end);

	sprintf (copy_buffer, "%ld", start);
	XtentXrmPutStringResource (&db, ArgN (0), copy_buffer, 30);

	sprintf (copy_buffer, "%ld", end);
	XtentXrmPutStringResource (&db, ArgN (1), copy_buffer, 30);
	ArgNReturn (True);
    }

    case TextInsert:
	XwTextInsert (_xtentNameToWidget (display, toplevel_ptr,
					  buffer, operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count),
		      ArgN (-1));
	ArgNReturn (True);

    case TextReplace:
	XwTextReplace (_xtentNameToWidget (display, toplevel_ptr,
					   buffer, operation,
					   string_one, parse_quarks,
					   parse_bindings,
					   field_count),
		       atol (ArgN (0)), atol (ArgN (1)),
		       ArgN (2));
	ArgNReturn (True);

    case TextRedraw:
	XwTextRedraw (_xtentNameToWidget (display, toplevel_ptr,
					  buffer, operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count));
	ArgNReturn (True);

    case TextUpdate:
	XwTextUpdate (_xtentNameToWidget (display, toplevel_ptr,
					  buffer, operation,
					  string_one, parse_quarks,
					  parse_bindings,
					  field_count),
		      XtentTestTrue (ArgN (-1)));
	ArgNReturn (True);

    case TextGetLastPos:
    {
	XwTextPosition start, end;

	end = XwTextGetLastPos (_xtentNameToWidget (display,
						    toplevel_ptr,
						    buffer,
						    operation,
						    string_one, parse_quarks,
						    parse_bindings,
						    field_count));
	sprintf (copy_buffer, "%ld", end);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);
    }

    case TextSetInsertPos:
	XwTextSetInsertPos (_xtentNameToWidget (display, toplevel_ptr,
						buffer, operation,
						string_one, parse_quarks,
						parse_bindings,
						field_count),
			    atol (ArgN (-1)));
	ArgNReturn (True);

    case TextGetInsertPos:
    {
	XwTextPosition start, end;

	end = XwTextGetInsertPos (_xtentNameToWidget (display,
						      toplevel_ptr,
						      buffer,
						      operation,
						      string_one, parse_quarks,
						      parse_bindings,
						      field_count));
	sprintf (copy_buffer, "%ld", end);
	XtentPutStringReturn (&db, ArgN (-1), copy_buffer);
	ArgNReturn (True);
    }
#endif					/* HP_WIDGETS */

    }					/* switch on operation type */
}

/*
 * frame maintenance routines - simple
 */
static XtentFrameData *XtentCurrentFramePointer = (XtentFrameData *) NULL;

static void
XtentCreateFrame (frame_ptr)
XtentFrameData *frame_ptr;
{
    if (XtentCurrentFramePointer)
	frame_ptr -> frame = XtentCurrentFramePointer -> frame + 1;
    else
	frame_ptr -> frame = 1;
    frame_ptr -> previous = XtentCurrentFramePointer;
    XtentCurrentFramePointer = frame_ptr;

    frame_ptr -> arg_buffer = "";
    frame_ptr -> last_arg = (char *) NULL;
    frame_ptr -> used_malloc = False;
    frame_ptr -> end_of_line = False;
    frame_ptr -> evaluation_block = False;
    frame_ptr -> break_from_eval = False;
}

static void
XtentReleaseFrame (frame_ptr)
XtentFrameData *frame_ptr;
{
	if (frame_ptr -> used_malloc)
		XtFree ((char *) frame_ptr -> buffer);

	XtentCurrentFramePointer = frame_ptr -> previous;
}

void
XtentAddCFunction (display, toplevel_ptr, name, function, args)
Display *display;
Widget *toplevel_ptr;
char *name;
void (*function) ();
char *args;
{
    int i;
    int length;
    char *buffer;
    char *ptr;

    /* .XtAddCFunction: (name, pointer, a, b, ...) */
    length = 18 + strlen (name) + 2 + 32 + 2 + strlen (args) + 2;
    buffer = (char *) XtMalloc (length);

    sprintf (buffer, ".XtAddCFunction: (%s, %d", name, function);
    ptr = buffer + strlen (buffer);

    if (args && *args != '\0')
    {
	sprintf (ptr, ", %s", args);
	ptr = ptr + strlen (ptr);
    }

    *ptr++ = ')';
    *ptr = '\0';

    XtentEvalResourceLine (display, toplevel_ptr, buffer);

    XtFree (buffer);
}

void
XtentXrmPutStringResource (db, buffer, value, field_count)
XrmDatabase * db;
char *buffer;
char *value;
int field_count;
{
    static int array_size = 0;
    static XrmBindingList bindings = (XrmBindingList) NULL;
    static XrmQuarkList quarks = (XrmQuarkList) NULL;
    static program_quark = (XrmQuark) NULL;
    int offset;

    if (field_count == 0)
	field_count = 30;

    if (field_count + 2 > array_size)
    {
	array_size = (field_count > (array_size + 30)) ?
	    (field_count + 2) : (array_size + 30 + 2);

	bindings = (XrmBindingList)
	    XtRealloc ((char *) bindings, (Cardinal) array_size * sizeof (XrmBinding));

	quarks = (XrmQuarkList)
	    XtRealloc ((char *) quarks, (Cardinal) array_size * sizeof (XrmQuark));
    }

    /*
     * The line prefix - '.' is equivalent to xtent_program_name
     */
    if (*buffer == '.')
    {
	if (program_quark == (XrmQuark) NULL)
	    quarks[0] = program_quark = XrmStringToQuark (XtentProgramName ());

	quarks[0] = program_quark;
	bindings[0] = XrmBindTightly;

	if (buffer[1] == '*')
	    buffer++;

	offset = 1;
    }
    else
	offset = 0;

    XrmStringToBindingQuarkList (buffer, bindings + offset, quarks + offset);
    XrmQPutStringResource (db, bindings, quarks, value);
}

static void
XtentCheckSprintfSize (string_size, buffer, buffer_length, start, end)
int string_size;
char **buffer;
int *buffer_length;
char **start;
char **end;
{
    int i;
    int existing_space = *end - *start;

    if (string_size >= 	existing_space)
    {
	i = *start - *buffer;
	*buffer_length = *buffer_length + (string_size - existing_space) +
	    256;
	*buffer = (char *) XtRealloc (*buffer, (Cardinal) *buffer_length);
	*start = *buffer + i;
	*end = *buffer + *buffer_length;
    }
}

static Atom
XtentStringToAtom (display, ptr)
Display *display;
char *ptr;
{
    Atom atom;

    if (strcmp (ptr, "None") == 0 || strcmp (ptr, "NULL") == 0)
	atom = (Atom) None;
    else
	atom = XInternAtom (display, ptr, False);

    return atom;
}

static char *
XtentAtomToString (display, atom)
Display *display;
Atom atom;
{
    static char *ptr = (char *) NULL;

    XtFree (ptr);

    if (atom == (Atom) None ||
	(ptr = XGetAtomName (display, atom)) == (char *) NULL)
	return "None";

    return ptr;
}

static int
XtentTestTextType (w, class, buffer)
Widget w;
WidgetClass class;
char *buffer;
{
    if (XtClass (w) != class)
    {
	char *ptr = XtentProgramName ();

	fprintf (stderr,
		 "%s: Text* widget does not match the widget class required for the specified operation: \"%s.%s\".\n",
		 ptr, ptr, buffer);
	return False;
    }
    return True;
}

/*
 * Xtent delays creating the toplevel shell until it is required.
 * This allows the application to set state in the resource database
 * that will affect the toplevel shell.  xtent.allowShellResize: True
 * is a good example of where this is quite useful.
 */
Widget
XtentToplevel (display, toplevel_ptr)
Display * display;
Widget * toplevel_ptr;
{
    Arg args[3];
    static char *argv[2];
    static int argc = 1;

    if (*toplevel_ptr)
	return * toplevel_ptr;

    XtSetArg (args[0], XtNscreen, DefaultScreenOfDisplay (display));
    XtSetArg (args[1], XtNargc, 1);
    argv[0] = XtentProgramName ();
    XtSetArg (args[2], XtNargv, argv);

    *toplevel_ptr = XtAppCreateShell (argv[0], "Xtent",
				      applicationShellWidgetClass,
				      display, args, 3);
#ifdef OPENLOOK
    {
	extern  Widget OlApplicationWidget;
	extern  Display * toplevelDisplay;
	Pixmap background_pixmap;
	Pixel background;
	GC gc;
	XGCValues gcValues;

	/*
	 * BaseWindow Shell widget
	 */
#ifdef PRE_RELEASE_4_0_OPENLOOK
	*toplevel_ptr = XtCreateApplicationShell ("BaseWindowShell",
						  baseWindowShellWidgetClass,
						  (ArgList) NULL,
						  (Cardinal) 0);
#endif
	OlApplicationWidget = *toplevel_ptr;
	toplevelDisplay = XtDisplay (*toplevel_ptr);

	OlPostInitialize ("Xtent", (XrmOptionDescRec *) NULL, NULL,
			  &argc, argv);

	/*
	 * kludge to handle OL under twm
	 */
	background_pixmap = XCreatePixmap (toplevelDisplay,
					   DefaultRootWindow (toplevelDisplay),
					   16, 16,
			      DefaultDepthOfScreen (XtScreen (*toplevel_ptr)));

	XtSetArg (args[0], XtNbackground, &background);
	XtGetValues (*toplevel_ptr, args, 1);
	gcValues.foreground = background;
	gc = XCreateGC (toplevelDisplay,
			DefaultRootWindow (toplevelDisplay),
			GCForeground, &gcValues);
	XFillRectangle (toplevelDisplay, background_pixmap, gc,
			0, 0, 16, 16);
	XFreeGC (toplevelDisplay, gc);

	XtSetArg (args[0], XtNbackgroundPixmap, background_pixmap);
	XtSetValues (*toplevel_ptr, args, 1);
    }
#endif					/* OPENLOOK */

    return * toplevel_ptr;
}

/*
 * these toplevel_ptr storage and retrieval routines are required to
 * get the toplevel_ptr into the action routines.
 */
Widget *
XtentSetToplevelPtr (set_toplevel_ptr)
Widget * set_toplevel_ptr;
{
    static Widget * toplevel_ptr = (Widget *) NULL;

    if (set_toplevel_ptr != (Widget *) NULL)
	toplevel_ptr = set_toplevel_ptr;

    return toplevel_ptr;
}

Widget *
XtentToplevelPtr ()
{
    return XtentSetToplevelPtr ((Widget *) NULL);
}

Display *
XtentSetDisplay (set_display)
Display * set_display;
{
    static Display * display = (Display *) NULL;

    if (set_display != (Display *) NULL)
	display = set_display;

    return display;
}

Display *
XtentDisplay ()
{
    return XtentSetDisplay ((Display *) NULL);
}

static char *
XtentSetArgv (set_argc, set_value)
int set_argc;
char *set_value;
{
    static char **argv;
    static int argc = 0;

    if (set_argc < 0)
    {
	argc = -set_argc;
	argv = (char **) set_value;
	return "";
    }

    if (set_value && set_argc < argc)
	argv[set_argc] = set_value;

    if (argc && set_argc >= 0 && set_argc < argc)
	return argv[set_argc];

    return "";
}

static int
XtentSetArgc (set_argc)
int set_argc;
{
    static int argc = 0;

    if (set_argc > -1)
	argc = set_argc;

    return argc;
}

static int
XtentArgc ()
{
    return XtentSetArgc (-1);
}

static char *
XtentArgv (arg_index)
int arg_index;
{
    if (arg_index < 0)
	return "";

    return XtentSetArgv (arg_index, (char *) NULL);
}

void
XtentStoreArgcArgv (set_argc, set_argv)
int set_argc;
char **set_argv;
{
    if (set_argc < 0)
	return;

    XtentSetArgc (set_argc);
    XtentSetArgv (-set_argc, (char *) set_argv);
}

/*
 * The same object oriented joke on line and message numbers.  These
 * functions are used by the signal catching routine to display where
 * errors occur.
 */
int
XtentSetLineCount (set_count)
int set_count;
{
    static int count = 0;

    if (set_count >= 0)
	count = set_count;

    return count;
}

int
XtentLineCount ()
{
    return XtentSetLineCount (-1);
}

int
XtentSetMessageCount (set_count)
int set_count;
{
    static int count = 0;

    if (set_count >= 0)
	count = set_count;

    return count;
}

int
XtentMessageCount ()
{
    return XtentSetMessageCount (-1);
}

/*
 * utility function for printing widget trees - helps isolate naming problems.
 */
static Boolean
XtentProcessWidgetNames (process_type, root, title, fp, target_widget)
int process_type;
Widget root;
char *title;
XtentOutput *fp;
char *target_widget;
{
    register int i;
    register WidgetList children;
    char *buf = (char *) NULL;
    int length_buf;
    int length_title;
    int length_target;
    char *widget_name;

    if (XtIsWidget (root) &&
	root -> core.num_popups > 0 && root -> core.popup_list)
    {
	/* + 1 for trailing "." */
	length_title = strlen (title) + 1;
	length_buf = 256;
	if (length_buf < length_title)
	    length_buf = length_buf + length_title + 256;
	buf = (char *) XtMalloc (length_buf);

	sprintf (buf, "%s.", title);
	children = root -> core.popup_list;
	for (i = 0; i < root -> core.num_popups; i++)
	{
	    widget_name = XrmQuarkToString (children[i] -> core.xrm_name);
	    length_target = length_title + strlen (widget_name) + 1;
	    if (length_target > length_buf)
	    {
		XtFree ((char *) buf);
		length_buf = length_buf + length_target + 256;
		buf = (char *) XtMalloc (length_buf);
		sprintf (buf, "%s.", title);
	    }
	    strcpy (&buf[length_title], widget_name);
	    XtentFormatPrint (fp, "%s\n", buf, (char *) NULL);

	    if (XtIsWidget (children[i]) &&
		(XtIsComposite (children[i]) ||
		 children[i] -> core.num_popups > 0))
	    {
		if (XtentProcessWidgetNames (process_type,
					     children[i], buf, fp,
					     target_widget))
		{
		    XtFree ((char *) buf);
		    return True;
		}
	    }
	}
    }

    if (XtIsComposite (root))
    {
	/* + 1 for trailing "." */
	length_title = strlen (title) + 1;
	length_buf = 256;
	if (length_buf < length_title)
	    length_buf = length_buf + length_title + 256;
	buf = (char *) XtRealloc (buf, (Cardinal) length_buf);

	sprintf (buf, "%s.", title);
	children = ((CompositeWidget) root) -> composite.children;
	for (i = 0; i < ((CompositeWidget) root)->composite.num_children; i++)
	{
	    widget_name = XrmQuarkToString (children[i] -> core.xrm_name);
	    length_target = length_title + strlen (widget_name) + 1;
	    if (length_target > length_buf)
	    {
		XtFree ((char *) buf);
		length_buf = length_buf + length_target + 256;
		buf = (char *) XtMalloc (length_buf);
		sprintf (buf, "%s.", title);
	    }
	    strcpy (&buf[length_title], widget_name);
	    XtentFormatPrint (fp, "%s\n", buf, (char *) NULL);

	    if (XtIsWidget (children[i]) &&
		(XtIsComposite (children[i]) ||
		 children[i] -> core.num_popups > 0))
	    {
		if (XtentProcessWidgetNames (process_type,
					     children[i], buf, fp,
					     target_widget))
		{
		    XtFree ((char *) buf);
		    return True;
		}
	    }
	}
    }

    if (buf == (char *) NULL)
	XtentFormatPrint (fp, "%s.%s\n", title,
			  XrmQuarkToString (root -> core.xrm_name),
			  (char *) NULL);
    else
	XtFree ((char *) buf);

    return False;
}

/*
 * generic callback function
 */
static XtCallbackProc
XtentCallbackProc (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    CallbackLine *cb = (CallbackLine *) client_data;
    char format_buffer[64];

#ifdef AUDIT_TRAIL		/* cec */
    if (intern_lines == True) fprintf(stderr,
	"\n---> Callback '%s' from w=%s\n",
		cb->callback_name, XtentWidgetToName(w));
#endif

    if (cb -> code == NULL || *cb -> code == '\0')
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%callback.widget",
			XtentWidgetToName (w));

    sprintf (format_buffer, "%d", call_data);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%callback.calldata",
			format_buffer);

    XtentEvalResourceLine (display, toplevel_ptr, cb -> code);

    ArgNReturnVoid ();
}

static XtCallbackProc
XtentCallbackWithArgsProc (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Display *display = XtentDisplay ();
    Widget *toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    char *arg_ptr, *val_ptr, *type_ptr;
    int i;
    XrmValue from_value, to_value;
    XrmQuark resource_quark;
    char format_buffer[64];
    int direct;
    CallbackLine *cb = (CallbackLine *) client_data;
    CallbackWithArgItem *arg_item = cb -> arg_list;

#ifdef AUDIT_TRAIL		/* cec */
    if (intern_lines == True) fprintf(stderr,
	"\n---> CallbackWithArgs '%s' from w=%s\n",
		cb->callback_name, XtentWidgetToName(w));
#endif

    if (cb -> code == NULL || *cb -> code == '\0')
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%callback.widget",
			XtentWidgetToName (w));

    sprintf (format_buffer, "%d", call_data);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%callback.calldata",
			format_buffer);

    i = 1;
    for (;;)
    {
	if (arg_item == (CallbackWithArgItem *) NULL)
	    break;
	arg_ptr = arg_item -> arg;
	arg_item = arg_item -> next;

	switch (*arg_ptr)
	{
	case 'W':
	    /*
	     * Widget
	     */
	    if (strcmp (arg_ptr, "Widget") == 0)
	    {
		if (arg_item == (CallbackWithArgItem *) NULL)
		    continue;
		arg_ptr = arg_item -> arg;
		arg_item = arg_item -> next;

		if (*arg_ptr == '\0')
		    break;
		val_ptr = XtentWidgetToName (w);
		break;
	    }
	    continue;

	case 'C':
	    /*
	     * client data
	     */
	    if (strcmp (arg_ptr, "ClientData") == 0)
	    {
		if (arg_item == (CallbackWithArgItem *) NULL)
		    continue;
		val_ptr = arg_item -> arg;
		arg_item = arg_item -> next;

		if (arg_item == (CallbackWithArgItem *) NULL)
		    continue;
		arg_ptr = arg_item -> arg;
		arg_item = arg_item -> next;

		if (*arg_ptr == '\0')
		    continue;
		break;
	    }
	    /*
	     * call data
	     */
	    direct = False;
	    if (strcmp (arg_ptr, "CallData") == 0)
		direct = True;
	    else if (strcmp (arg_ptr, "CallDataPtr") != 0)
		continue;

	    if (arg_item == (CallbackWithArgItem *) NULL)
		continue;
	    type_ptr = arg_item -> arg;
	    arg_item = arg_item -> next;

	    if (*type_ptr == '\0')
		continue;

	    if (arg_item == (CallbackWithArgItem *) NULL)
		continue;
	    arg_ptr = arg_item -> arg;
	    arg_item = arg_item -> next;

	    if (*arg_ptr == '\0')
		continue;

	    resource_quark = XrmStringToQuark (type_ptr);

	    if ((resource_quark == XtQString || direct == False) &&
		call_data == (char *) NULL)
	    {
		fprintf (stderr,
			 "%s: Attempting to convert CallData: %s\n",
			 XtentProgramName (), client_data);
		fprintf (stderr,
			 "%s: The CallData pointer is NULL.\n",
			 XtentProgramName ());
		continue;
	    }
	    if(resource_quark == XtQString)
	    {
		if (direct)
		    val_ptr = (char *) call_data;
		else
		    val_ptr = *((char **) call_data);
	    }
	    else if (resource_quark == XtQDimension)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((Dimension *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQPosition)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((Position *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQShort)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((short *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQInt)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((int *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQPixel)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((Pixel *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQCardinal)
	    {
		if (direct)
		    sprintf (format_buffer, "%d", call_data);
		else
		    sprintf (format_buffer, "%d", *((Cardinal *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQFloat)
	    {
		if (direct)
		    sprintf (format_buffer, "%f", call_data);
		else
		    sprintf (format_buffer, "%f", *((float *) call_data));
		val_ptr = format_buffer;
	    }
	    else if (resource_quark == XtQBoolean)
	    {
		if (direct)
		{
		    if (call_data)
			val_ptr = "True";
		    else
			val_ptr = "False";
		}
		else
		{
		    if (*((Boolean *) call_data))
			val_ptr = "True";
		    else
			val_ptr = "False";
		}
	    }
	    else
	    {
		if (direct)
		    from_value.addr = (XtPointer) &call_data;
		else
		    from_value.addr = call_data;

		from_value.size = sizeof (XtPointer);
		to_value.size = 0;
		to_value.addr = (XtPointer) NULL;
		_XtConvert (w, resource_quark, &from_value,
			    XtQString, &to_value, NULL);
		if (to_value.size && to_value.addr)
		    val_ptr = (char *) to_value.addr;
		else
		    val_ptr = "";
	    }
	    break;
	default:
	    continue;
	}

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, arg_ptr, val_ptr);
    }

    XtentEvalResourceLine (display, toplevel_ptr, cb -> code);

    ArgNReturnVoid ();
}

static void
XtentGetSelectionProc (w, client_data, selection, type, value, length, format)
Widget w;
XtPointer client_data;
Atom * selection;
Atom * type;
XtPointer value;
unsigned long * length;
int * format;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    char format_buf[64];

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.widget",
			XtentWidgetToName (w));

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.atom",
			XtentAtomToString (display, *selection));

    sprintf (format_buf, "%d", *type);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.type",
			format_buf);

    if (*type == (Atom) 0 || *length == 0)
	value = (XtPointer) "";
    else
    {
	char *ptr = (char *) XtMalloc (*length + 1);

	memcpy (ptr, value, *length);
	ptr[*length] = '\0';
	XtFree (value);
	value = (XtPointer) ptr;
    }
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.value",
			value);


    if (*length > 0)
	XtFree (value);

    sprintf (format_buf, "%d", *length);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.length",
			format_buf);

    sprintf (format_buf, "%d", *format);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%selection.format",
			format_buf);

    XtentEvalResourceLine (display, toplevel_ptr, client_data);
    XtFree (client_data);

    ArgNReturnVoid ();
}

static Widget
XtentToplevelParent (w)
Widget w;
{
    Widget parent = XtParent(w);

    while (parent != NULL)
    {
	w = parent;
	parent = XtParent(w);
    }

    return w;
}

/*
 * XtOwnSelection() generic callback routines
 */
static Boolean
XtentConvertSelectionProc (w, selection, target, type, value, length, format)
Widget w;
Atom *selection;
Atom *target;
Atom *type;
XtPointer *value;
unsigned long *length;
int *format;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    SelectionLine *s;
    XtentFrameData frame_data;
    XrmString value_type;
    XrmValue value_return;
    char *ptr;
    int ran_eval;
    static Atom targets = (Atom) 0;
    if (targets == (Atom) 0)
	targets = XInternAtom (display, "TARGETS", False);

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    s = SelectionLines;
    while (s)
    {
	if (s -> widget == w && s -> selection == *selection)
	    break;
	s = s -> next;
    }

    if (s && s -> malloc_return)
    {
	XtFree ((char *) s -> malloc_return);
	s -> malloc_return = (XtPointer) NULL;
    }

    if (s && s -> convert_code && *s -> convert_code)
    {
	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%convertSelection.widget",
			    XtentWidgetToName (w));

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%convertSelection.selection",
			    s -> selection_atom_string);

	if (*target == XA_STRING)
	    ptr = "XA_STRING";
	else if (*target == XA_WINDOW)
	    ptr = "XA_WINDOW";
	else if (*target == targets)
	    ptr = "XA_TARGETS";
	else
	    ptr = "Unknown";

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%convertSelection.target",
			    ptr);

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%convertSelection.string",
			    (char *) NULL);

	XtentEvalResourceLine (display, toplevel_ptr, s -> convert_code);

	ran_eval = True;
    }
    else
	ran_eval = False;

    if (*target == XA_STRING)
    {

	if (ran_eval &&
	    XrmGetResource (XtDatabase (display), "%convertSelection.string",
			    (char *) NULL, &value_type, &value_return) &&
	    value_return.size > 0)
	    ptr = (char *) value_return.addr;
	else
	    ptr = "";

	*type = XA_STRING;
	*value = s -> malloc_return = XtNewString (ptr);
	*length = strlen (ptr);
	*format = 8;

	ArgNReturn (True);
    }
    if (*target == XA_WINDOW)
    {
	Widget parent = XtentToplevelParent (w);

	*value = s -> malloc_return = XtMalloc (sizeof (Window));
	*(Window*)*value = XtWindow (parent);
	*type = XA_WINDOW;
	*length = 1;
	*format = 32;

	ArgNReturn (True);
    }
    if (*target == targets)
    {
	Atom* targets_returned = (Atom *) XtMalloc (2 * sizeof (Atom));
	int i = 0;

	targets_returned[i++] = XA_STRING;
	targets_returned[i++] = XA_WINDOW;

	*value = s -> malloc_return = (XtPointer) targets_returned;
	*type = XA_ATOM;
	*length = i;
	*format = 32;

	ArgNReturn (True);
    }

    ArgNReturn (False);
}

static void
XtentLoseSelectionProc (w, selection)
Widget w;
Atom *selection;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    SelectionLine *s, *s_prev;
    XtentFrameData frame_data;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    s = SelectionLines;
    s_prev = (SelectionLine *) NULL;
    while (s)
    {
	if (s -> widget == w && s -> selection == *selection)
	    break;
	s_prev = s;
	s = s -> next;
    }

    if (s && s -> lose_code && *s -> lose_code)
    {
	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%loseSelection.widget",
			    XtentWidgetToName (w));

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%loseSelection.selection",
			    s -> selection_atom_string);

	XtentEvalResourceLine (display, toplevel_ptr, s -> lose_code);
    }

    if (s)
    {
	if (s_prev)
	    s_prev -> next = s -> next;
	else
	    SelectionLines = s -> next;

	XtFree ((char *) s -> malloc_return);
	XtFree ((char *) s);
    }

    ArgNReturnVoid ();
}

static void
XtentDoneSelectionProc (w, selection, target)
Widget w;
Atom *selection;
Atom *target;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    SelectionLine *s;
    XtentFrameData frame_data;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    s = SelectionLines;
    while (s)
    {
	if (s -> widget == w && s -> selection == *selection)
	    break;
	s = s -> next;
    }

    if (s && s -> done_code && *s -> done_code)
    {
	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%doneSelection.widget",
			    XtentWidgetToName (w));

	XtentLocalVariable (display, XtentVariablesPush,
			    frame_data.frame, "%doneSelection.selection",
			    s -> selection_atom_string);

	XtentEvalResourceLine (display, toplevel_ptr, s -> done_code);
    }

    ArgNReturnVoid ();
}

/*
 * generic event handler function
 */
static void
XtentEventHandlerProc (w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent * event;
Boolean * continue_to_dispatch;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    EventHandlerLine *eh = (EventHandlerLine *) client_data;
    char *name_ptr;
    char format_buffer[64];
    XrmString value_type;
    XrmValue value_return;

#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> Event (%d) from w=%s\n",
		eh->event_mask,
		XtentWidgetToName(w) );
#endif

    if (eh -> code == NULL || *eh -> code == '\0')
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%event.widget",
			XtentWidgetToName (w));

    sprintf (format_buffer, "%d", event);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%event.pointer",
			format_buffer);

    name_ptr = "%event.continue-to-dispatch";
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, name_ptr,
			"True");

    XtentEvalResourceLine (display, toplevel_ptr, eh -> code);

    if (XrmGetResource (XtDatabase (display), name_ptr, (char *) NULL,
			&value_type, &value_return) &&
	value_return.size > 0)
    {
	*continue_to_dispatch = XtentTestTrue ((char *) value_return.addr);
    }

    ArgNReturnVoid ();
}

/*
 * generic action function
 */
static void
XtentActionProc (w, event, params, count)
Widget w;
XEvent * event;
String * params;
Cardinal * count;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    char *eval_ptr;
    char format_buffer[32];
    int i;

#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> Action (%d) from w=%s\n",
		event->type,
		XtentWidgetToName(w) );
#endif

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    eval_ptr = "%action.event";
    sprintf (format_buffer, "%d", event);
    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
			eval_ptr, format_buffer);

    for (i = 0; i < *count; i++)
    {
	eval_ptr = XtentTrimBuffer (params[i]);
	if (*eval_ptr == '\0')
	    continue;

	XtentEvalResourceLine (display, toplevel_ptr, eval_ptr);
    }

    ArgNReturnVoid ();
}

/*
 * generic input function
 */
static XtInputCallbackProc
XtentInputProc (client_data, source, id)
InputLine * client_data;
int *source;
XtInputId * id;
{
    /*
     * this could be a high volume interface - so leave
     * the buffers in place.
     */
    static char *resource_buffer = (char *) NULL;
    static int resource_buffer_size = 128;
    Display * display = client_data -> display;
    Widget * toplevel_ptr = client_data -> toplevel_ptr;
    XtentFrameData frame_data;

#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> Input \n");
#endif

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;
    frame_data.arg_buffer = "";

    if (resource_buffer == (char *) NULL)
	resource_buffer = (char *) XtMalloc (resource_buffer_size);

    while (XtentReadResourceLine (client_data -> fp, &resource_buffer,
				  &resource_buffer_size) == True)
    {
	XtentEvalResourceLine (client_data -> display,
			       client_data -> toplevel_ptr,
			       resource_buffer);

#ifdef linux
	if (client_data -> fp -> _IO_read_ptr >=
	    client_data -> fp -> _IO_read_end)
	    break;
#else
	if (client_data -> fp -> _cnt == 0)
	    break;
#endif
    }

    clearerr (client_data -> fp);

    ArgNReturnVoid ();
}

/*
 * generic timeout function
 */
static XtTimerCallbackProc
XtentTimeoutProc (client_data, id)
XtPointer client_data;
XtIntervalId id;
{
    TimeoutLine * timeout, *timeout_prev;
    TimeoutLine * to = (TimeoutLine *) client_data;
    Widget * toplevel_ptr = XtentToplevelPtr ();
    Display * display = XtentDisplay ();
    char *eval_ptr;
    XtentFrameData frame_data;


#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> Timeout after %d msecs \n",to->interval);
#endif

    if (client_data == (XtPointer) NULL)
	return;

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    if (to -> code != NULL && *to -> code != '\0')
	XtentEvalResourceLine (to -> display, to -> toplevel_ptr, to -> code);

    for (timeout_prev = NULL, timeout = *to -> timeouts; timeout;
	 timeout_prev = timeout, timeout = timeout -> next)
    {
	if (to == timeout)
	{
	    if (timeout_prev)
		timeout_prev -> next = timeout -> next;
	    else
		*to -> timeouts = timeout -> next;
	    XtFree ((char *) timeout);
	    break;
	}
    }
    ArgNReturnVoid ();
}

/*
 * generic workproc function
 */
static XtWorkProc
XtentWorkProcProc (client_data)
XtPointer client_data;
{
    WorkProcLine * workproc = (WorkProcLine *) client_data;
    Display * display = workproc -> display;
    Widget * toplevel_ptr = workproc -> toplevel_ptr;
    XtentFrameData frame_data;

#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> WorkProc \n");
#endif

    if (workproc -> code == NULL || *workproc -> code == '\0')
	return False;

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentEvalResourceLine (display, workproc -> toplevel_ptr,
			   workproc -> code);

    ArgNReturn (False);
}

/*
 * generic XIpc server client message handler
 */
void
XtentIPCServerClientInputProc (client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
    IPCServerDescriptor *sp = (IPCServerDescriptor *) client_data;
    XIpcServer *server = sp -> server;
    XIpcMessage *message;
    int client_id;
    Widget * toplevel_ptr = XtentToplevelPtr ();
    Display * display = XtentDisplay ();
    XtentFrameData frame_data;
    char *eval_ptr;
    char format_buffer[32];

    for (client_id = 0; client_id < server -> max_clients; client_id++)
	if (server -> clients[client_id].channel == *source)
	    break;
    if (client_id == server -> max_clients)
	return;

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    while (server -> clients[client_id].recv_buffer)
    {
	message = XIpcRecv (&server -> clients[client_id]);
	if (message == (XIpcMessage *) -1)
	{
	    FD_CLR (server -> clients[client_id].channel,
		    &server -> select_mask);

	    XIpcServerCloseClient (server, client_id);
	    break;
	}

	if (message == (XIpcMessage *) NULL)
	{
	    if (XIpcBufferEmpty (&server -> clients[client_id]))
	    {
		FD_CLR (server -> clients[client_id].channel,
			&server -> select_mask);
		break;
	    }
	    continue;
	}

	if (message -> type == XIPC_SERVER_NEW_CLIENT)
	    message -> client_id = client_id;
	else
	    if (client_id != message -> client_id)
		continue;

	if (sp -> message_handler_code && *sp -> message_handler_code)
	{
	    eval_ptr = "%message.type";
	    sprintf (format_buffer, "%ld", (unsigned long) message -> type);
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, format_buffer);

	    eval_ptr = "%message.client_id";
	    sprintf (format_buffer, "%ld",
		     (unsigned long) message -> client_id);
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, format_buffer);

	    eval_ptr = "%message.buffer";
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, (char *) message -> buffer);

	    XtentEvalResourceLine (display, toplevel_ptr,
				   sp -> message_handler_code);
	}
	else
	    XIpcServerProcessMessage (server, message);
    }
    ArgNReturnVoid ();
}

/*
 * generic XIpc client message handler
 */
static void
XtentIPCClientInputProc (client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
    IPCClientDescriptor *cp = (IPCClientDescriptor *) client_data;
    XIpcClient *client = cp -> client;
    XIpcMessage *message;
    Widget * toplevel_ptr = XtentToplevelPtr ();
    Display * display = XtentDisplay ();
    XtentFrameData frame_data;
    char *eval_ptr;
    char format_buffer[32];

#ifdef AUDIT_TRAIL		/* cec */
if (intern_lines == True)
    fprintf(stderr,"\n---> IPC from\n" );
#endif

    /*
     * initialize this frame
     */
    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    while (client -> recv_buffer)
    {
	message = XIpcRecv (client);

	if (message == (XIpcMessage *) -1)
	{
	    XIpcClose (client);
	    break;
	}

	if (message == (XIpcMessage *) NULL)
	{
	    if (XIpcBufferEmpty (client))
		break;
	    continue;
	}

	if (cp -> message_handler_code && *cp -> message_handler_code)
	{
	    eval_ptr = "%message.type";
	    sprintf (format_buffer, "%ld", (unsigned long) message -> type);
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, format_buffer);

	    eval_ptr = "%message.client_id";
	    sprintf (format_buffer, "%ld",
		     (unsigned long) message -> client_id);
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, format_buffer);

	    eval_ptr = "%message.buffer";
	    XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
				eval_ptr, (char *) message -> buffer);

	    XtentEvalResourceLine (display, toplevel_ptr,
				   cp -> message_handler_code);
	}

	if (XIpcBufferEmpty (client))
	    break;
    }

    ArgNReturnVoid ();
}

static void
XtentIPCClientCleanupXtentData (XtentIPCClientDescriptors, i)
IPCClientDescriptor **XtentIPCClientDescriptors;
int i;
{
    XtentIPCClientCleanup (XtentIPCClientDescriptors[i] -> client);
    XIpcCloseClient (XtentIPCClientDescriptors[i] -> client);
    XtFree ((char *) XtentIPCClientDescriptors[i] -> client);
    XtFree ((char *) XtentIPCClientDescriptors[i]);
    XtentIPCClientDescriptors[i] = (IPCClientDescriptor *) NULL;
}

/*
 * wrapper for XtParseTranslationTable() - mainly conversion of \n
 * to newlines.
 */
static XtTranslations
XtentParseTranslationTable (buffer)
char *buffer;
{
    char *ptr;

    buffer = XtentTrimBuffer (buffer);
    ptr = buffer;
    while (*ptr)
    {
	if (*ptr == '\\' && *(ptr + 1) == 'n')
	{
	    *ptr++ = '\n';
	    *ptr = ' ';
	}
	ptr++;
    }
#ifdef OPENLOOK
#if OL_VERSION <= 2  /* RAD - pre-solaris OpenWindows */
    {
	XtTranslations rc;

	ptr = OlConvertVirtualTranslation (buffer);
	rc = XtParseTranslationTable (ptr);
	if (ptr != buffer)
	    XtFree ((char *) ptr);

	return rc;
    }
#else
    return XtParseTranslationTable (buffer);
#endif /* OL_VERSION */
#else
    return XtParseTranslationTable (buffer);
#endif /* OPENLOOK */
}

/*
 * convert strings with embedded GetValues() and XrmGetResource() tokens.
 *
 * ^{widgetname.resource} or ^(resource_ database_name)
 *
 * \ quotes ^, and \n, \t, \r, ...
 */
static char *
XtentConvertEmbeddedNames (display, toplevel_ptr, buffer)
Display *display;
Widget *toplevel_ptr;
char *buffer;
{
    ConvertBuffer *lb, *next;
    ConvertBuffer *top = (ConvertBuffer *) NULL;
    char *ptr, *lptr, *cptr, *tmp;
    XrmString value_type;
    XrmValue value_return;
    int length;
    char c0, c1;
    int mark_count;
    char mark, mark_end;
    int requires_convert;

    /*
     * loop through the string looking for ^(resource db), ^{widget res},
     * ^[function call], and \ quote's.
     */
    for (lptr = ptr = buffer; *ptr; ptr++)
    {
	switch (c0 = *ptr)
	{
	default:
	    continue;

	case '^':
	    /*
	     * find the type of conversion requested
	     */
	    c1 = *(ptr + 1);
	    switch (c1)
	    {
	    case '(':
		mark = '(';
		mark_end = ')';
		break;
	    case '{':
		mark = '{';
		mark_end = '}';
		break;
	    case '[':
		mark = '[';
		mark_end = ']';
		break;
	    default:
		continue;
	    }

	    /*
	     * store the string to this point
	     */
	    if (lptr < ptr)
	    {
		length = ptr - lptr;
		lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer)
						 + length);
		memcpy (lb -> buffer, lptr, length);
		lb -> length = length;
		lb -> next = top;
		top = lb;
	    }

	    /*
	     * find the matching mark or delimiter
	     */
	    ptr += 2;
	    lptr = ptr;
	    mark_count = 1;
	    requires_convert = False;
	    while (*ptr)
	    {
		if (*ptr == mark)
		    mark_count++;
		else if (*ptr == mark_end)
		{
		    mark_count--;
		    if (mark_count == 0)
			break;
		}
		else if (*ptr == '\\')
		{
		    if (ptr[1])
			ptr++;
		}
		else if (*ptr == '^')
		    requires_convert = True;
		ptr++;
	    }
	    if (c1 == '(' && *lptr == '~')
	    {
		requires_convert = False;
	    }
	    else if (requires_convert && mark_count == 0)
	    {
		mark = *ptr;
		*ptr = '\0';
		cptr = XtentConvertEmbeddedNames (display, toplevel_ptr, lptr);
		*ptr = mark;
		if (cptr == lptr)
		{
		    requires_convert = False;
		    mark_count = 1;
		}
		else
		    lptr = cptr;
	    }
	    if (mark_count != 0)
	    {
	fprintf (stderr,"%s: Cannot process macro at line %d, message %d:\n",
		 XtentProgramName (), XtentLineCount (), XtentMessageCount ());
	fprintf (stderr, "%s: \"%s\"\n", XtentProgramName (), buffer);
	    }

	    switch (c1)
	    {
	    case '(':	/* database variable */
		*ptr = '\0';
		if (*lptr == '~') /* quote */
		{
		    length = strlen (lptr + 1);

		    lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer) +
						     length);
		    if (length > 0)
			memcpy (lb -> buffer, lptr + 1, length);
		    lb -> length = length;
		}
		else
		{
		    /*
		     * The line prefix - '.' is equivalent to program_name
		     */
		    if (*lptr == '.')
		    {
			tmp = (char *) XtMalloc (strlen (lptr) +
						 XtentProgramNameLength ()
						 + 1);
			sprintf (tmp, "%s%s", XtentProgramName (), lptr);
		    }
		    else
			tmp = lptr;

		    lb = (ConvertBuffer *) NULL;
		    if (XrmGetResource (XtDatabase (display),
					tmp, (char *) NULL,
					&value_type,
					&value_return))
		    {
			/* including the NULL byte */
			if (value_return.size > 0)
			{
			    value_return.size--;
			    lb = (ConvertBuffer *)
				XtMalloc (sizeof (ConvertBuffer) +
					  value_return.size);
			    memcpy (lb -> buffer, value_return.addr,
				   value_return.size);
			    lb -> length = value_return.size;
			}
		    }

		    if (tmp != lptr)
			XtFree (tmp);

		    if (requires_convert)
			XtFree (lptr);

		    if (lb == (ConvertBuffer *) NULL)
		    {
			lb = (ConvertBuffer *)
			    XtMalloc (sizeof (ConvertBuffer));
			lb -> length = 0;
		    }
		}
		lb -> next = top;
		top = lb;
		*ptr = ')';
		lptr = ptr + 1;
		continue;

	    case '{':	/* widget resource */
		*ptr = '\0';
		if ((cptr = XtentGetValue (display, toplevel_ptr,
					   lptr, (char *) NULL))
		    != NULL)
		{
		    length = strlen (cptr);
		    lb = (ConvertBuffer *)
			XtMalloc (sizeof (ConvertBuffer) + length);
		    memcpy (lb -> buffer, cptr, length);
		    lb -> length = length;
		}
		else
		{
		    lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer));
		    lb -> length = 0;
		}
		lb -> next = top;
		top = lb;

		if (requires_convert)
		    XtFree (lptr);

		*ptr = '}';
		lptr = ptr + 1;
		continue;

	    case '[':	/* function */
	     {
		 XtentFrameData frame_data;

		 XtentCreateFrame (&frame_data);
		 frame_data.buffer = (char *) NULL;
		 frame_data.evaluation_block = True;
		 frame_data.arg_buffer = "";

		 if (XtentReturnValue &&
		     XtentReturnValue != XtentReturnBuffer)
		     XtFree ((char *) XtentReturnValue);
		 XtentReturnValue = (char *) NULL;

		 *ptr = '\0';
		 cptr = XtNewString (lptr);
		 XtentEvalResourceLine (display, toplevel_ptr, cptr);
		 *ptr = ']';
		 XtFree ((char *)cptr);

		 if ((cptr = XtentReturnValue) != NULL)
		     length = strlen (cptr);
		 else
		     length = 0;

		if (length > 0)
		{
		    lb = (ConvertBuffer *)
			XtMalloc (sizeof (ConvertBuffer) + length);
		    memcpy (lb -> buffer, cptr, length);
		    lb -> length = length;
		}
		else
		{
		    lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer));
		    lb -> length = 0;
		}
		lb -> next = top;
		top = lb;

		if (requires_convert)
		    XtFree (lptr);

		lptr = ptr + 1;

		 XtentLocalVariable (display, XtentVariablesPop,
				     frame_data.frame, NULL, NULL);
		 XtentReleaseFrame (&frame_data);

		 continue;
	     }
	    }

	case '\\':
	    /* add a byte for the interpreted char */
	    length = 1 + ptr - lptr;
	    lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer) + length);
	    memcpy (lb -> buffer, lptr, length);
	    lb -> length = length;
	    lb -> next = top;
	    top = lb;

	    c1 = *(ptr + 1);
	    switch (c1)
	    {
	    case 'c':
		c0 = '\0';
		break;
	    case 'n':
		c0 = '\n';
		break;
	    case 't':
		c0 = '\t';
		break;
	    case 'v':
		c0 = '\v';
		break;
	    case 'b':
		c0 = '\b';
		break;
	    case 'f':
		c0 = '\f';
		break;
	    case 'a':
		c0 = 07;
		break;
	    case 'r':
		c0 = '\r';
		break;
	    default:
		c0 = c1;
		break;
	    }
	    lb -> buffer[length - 1] = c0;
	    ptr++;
	    lptr = ptr + 1;
	    continue;
	}
    }

    if (top == NULL)
	return buffer;

    if (lptr < ptr)
    {
	length = ptr - lptr;
	lb = (ConvertBuffer *) XtMalloc (sizeof (ConvertBuffer) + length);
	memcpy (lb -> buffer, lptr, length);
	lb -> length = length;
	lb -> next = top;
	top = lb;
    }

    /*
     * reverse the list and collect the length
     */
    length = 0;
    lb = top;
    top = (ConvertBuffer *) NULL;
    while (lb)
    {
	length += lb -> length;
	next = lb -> next;
	lb -> next = top;
	top = lb;
	lb = next;
    }

    /*
     * make a copy of the fragments and cleanup
     */
    lptr = ptr = (char *) XtMalloc (length + 2);
    lb = top;
    while (lb)
    {
	if (lb -> length)
	    memcpy (lptr, lb -> buffer, lb -> length);
	lptr += lb -> length;
	next = lb -> next;
	XtFree ((char *)lb);
	lb = next;
    }
    *lptr = '\0';
    return ptr;
}

/*
 * trim white space from the front of an input line
 */
static char *
XtentTrimBuffer (buffer)
register char *buffer;
{
    while (*buffer == ' ' || *buffer == '\t' || *buffer == '\n')
	buffer++;

    return buffer;
}

static int
XtentTestTrue (str)
char *str;
{
    char *true = "True";
    char *false = "False";
    char *ptr;
    char *token;

    ptr = str;
    token = true;
    while (*ptr == *token++)
	if (*ptr++ == '\0')
	    return True;
    ptr = str;
    token = false;
    while (*ptr == *token++)
	if (*ptr++ == '\0')
	    return False;

    fprintf (stderr, "%s: Testing for True or False and found: %s.\n",
	     XtentProgramName (), str);
    fprintf (stderr, "%s: Testing for True or False assuming False.\n",
	     XtentProgramName ());

    return False;
}

/*
 * shell commands of the form "xtent.ShellEscape: command"
 *
 * if the first non-blank character is a '#' then the output of the
 * shell command is evaluated as xtent input commands.
 */
static void
XtentShellEscapeProc (display, toplevel_ptr, buffer)
Display * display;
Widget * toplevel_ptr;
char *buffer;
{
    FILE * fp;

    if (*buffer)
    {
	if (*buffer == '#')
	{
	    if ((fp = XtentEnvPOpen (&buffer[1], "r")) == NULL)
	    {
		XtentWarningMessage ("Cannot create start a shell process.");
		fprintf (stderr, "%s: The command was: %s.\n",
			 XtentProgramName (), buffer);
	    }
	    else
	    {
		int line = XtentLineCount ();

		XtentSetLineCount (0);
		Xtent (display, toplevel_ptr, fp);
		XtentEnvPClose (fp);
		XtentSetLineCount (line);
	    }
	}
	else
	    XtentEnvSystem (buffer);
    }
}

/*
 * recursively determine the type of a resource for a given widget
 */
static XrmQuark
ResourceToResourceType (parent, widget_class, top_widget_class, name_quark)
Widget parent;
WidgetClass widget_class;
WidgetClass top_widget_class;
register XrmQuark name_quark;
{
    XrmQuark type_quark = (XrmQuark) NULL;
    register XrmResourceList * list;
    register int i;

    if (widget_class -> core_class.class_inited == False)
	XtInitializeWidgetClass (widget_class);

    /* scan for this class in the core class */
    list = (XrmResourceList *) widget_class -> core_class.resources;
    for (i = 0; i < widget_class -> core_class.num_resources; i++)
    {
	if ((XrmQuark) list[i] -> xrm_name == name_quark)
	    return (XrmQuark) list[i] -> xrm_type;
    }

    if (top_widget_class == widget_class &&
	parent != (Widget) NULL &&
	XtIsConstraint (parent))
    {
	ConstraintWidgetClass class =
	    (ConstraintWidgetClass) XtClass (parent);

	list = (XrmResourceList *) class -> constraint_class.resources;
	for (i = 0; i < class -> constraint_class.num_resources; i++)
	{
	    if ((XrmQuark) list[i] -> xrm_name == name_quark)
		return (XrmQuark) list[i] -> xrm_type;
	}
    }

    /* scan resource names for the superclass */
    if (widget_class -> core_class.superclass != NULL)
	type_quark = ResourceToResourceType
	    (parent, widget_class -> core_class.superclass,
	     top_widget_class, name_quark);

    return type_quark;
}

/*
 * return the XtRString representation for a widget resource
 */
static char *
XtentGetValue (display, toplevel_ptr, buffer, pre_element)
Display * display;
Widget * toplevel_ptr;
char *buffer;
char *pre_element;
{
    char *name, *element;
    Widget w;
    XrmQuark res_quark;
    int length = XtentProgramNameLength ();

    if (strncmp (buffer, XtentProgramName (), length) == 0)
    {
	buffer += length;
	if (*buffer == '.')
	    buffer++;
    }

    if (pre_element)
    {
	name = buffer;
	while (*name)
	    name++;
	element = name;
	if (name != buffer)
	    element++;
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				NULL, NULL, NULL, 0);
	*name = '\0';
	element = pre_element;
    }
    else
    {
	element = name = buffer;
	while (*name)
	{
	    if (*name++ == '.')
		element = name;
	}
	w = _xtentNameToWidget (display, toplevel_ptr, buffer, element,
				NULL, NULL, NULL, 0);
    }

    res_quark = ResourceToResourceType (XtParent (w),
					XtClass (w), XtClass (w),
					XrmStringToQuark (element));

    return XtentQuarkGetValue (w, res_quark, element);
}

static char *
XtentQuarkGetValue (w, res_quark, name)
Widget w;
XrmQuark res_quark;
char *name;
{
    static char format_buffer[32];
    XrmValue from_value, to_value;
    Arg arg;

    if (res_quark == (XrmQuark) NULL)
    {
	XtPointer x = (XtPointer) NULL;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	return x;
    }
    else if (res_quark == XtQString)
    {
	XtPointer x = (XtPointer) NULL;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	if (x == (XtPointer) NULL)
	    x = (XtPointer) "";
	return x;
    }
    else if (res_quark == XtQDimension)
    {
	Dimension x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQPosition)
    {
	Position x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQShort)
    {
	short   x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQInt)
    {
	int x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQPixel)
    {
	int depth = DefaultDepth (XtentDisplay (),
				  DefaultScreen (XtentDisplay ()));
	Pixel x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	x = (x & ((1 << depth) - 1));
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQCardinal)
    {
	Cardinal x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%d", x);
	return format_buffer;
    }
    else if (res_quark == XtQFloat)
    {
	float   xf = 0.0;

	XtSetArg (arg, name, &xf);
	XtGetValues (w, &arg, 1);
	sprintf (format_buffer, "%f", xf);
	return format_buffer;
    }
    else if (res_quark == XtQBoolean)
    {
	Boolean b = False;

	XtSetArg (arg, name, &b);
	XtGetValues (w, &arg, 1);
	if (b)
	    return "True";
	else
	    return "False";
    }
    else
    {
	XtPointer x = 0;

	XtSetArg (arg, name, &x);
	XtGetValues (w, &arg, 1);
	from_value.addr = (XtPointer) & x;
	from_value.size = sizeof (x);
	to_value.addr = (XtPointer) NULL;
	to_value.size = 0;

	_XtConvert (w, res_quark, &from_value, XtQString, &to_value, NULL);

	if (to_value.size && to_value.addr)
	    return (char *) to_value.addr;
	else
	    return (char *) NULL;
    }
}

#define RESITEM_INC (128)

static int
ResItemCmp (a, b)
ResItem ** a;
ResItem ** b;
{
    return strcmp ((*a) -> name, (*b) -> name);
}

static void
XtentPrintWidgetResources (widget_class, widget, widget_name, fp)
WidgetClass widget_class;
Widget widget;
char *widget_name;
XtentOutput *fp;
{
    XrmResourceList * list;
    int i;
    char *value;
    ResItem ** all;
    ResItem * ptr;
    int all_length;
    int all_count;
    Widget parent;

    /*
      if (!XtIsRealized (widget))
      {
      XtentWarningMessage ("Xtent only prints resources of realized widgets.");
      return;
      }
      */
    all_count = 0;
    all_length = RESITEM_INC;
    all = (ResItem **) XtMalloc (sizeof (ResItem *) * all_length);

    while (widget_class != NULL)
    {
	if (widget_class -> core_class.num_resources >=
	    (all_length - all_count))
	{
	    all_length += (RESITEM_INC +
			   widget_class -> core_class.num_resources);
	    all = (ResItem **) XtRealloc ((char *) all, 
				(Cardinal) sizeof (ResItem *) * all_length);
	}
	list = (XrmResourceList *)
	    widget_class -> core_class.resources;
	for (i = 0; i < widget_class -> core_class.num_resources; i++)
	{
	    ptr = all[all_count] =
		(ResItem *) XtMalloc (sizeof (ResItem));
	    ptr -> xrm_name = (XrmQuark) list[i] -> xrm_name;
	    ptr -> name = XrmQuarkToString (ptr -> xrm_name);
	    ptr -> xrm_type = (XrmQuark) list[i] -> xrm_type;
	    all_count++;
	}
	widget_class = widget_class -> core_class.superclass;
    }

    parent = XtParent (widget);
    if (parent != (Widget) NULL &&
	XtIsConstraint (parent) &&
	widget -> core.constraints)
    {
	ConstraintWidgetClass class = (ConstraintWidgetClass) XtClass (parent);

	if (class -> constraint_class.num_resources >=
	    (all_length - all_count))
	{
	    all_length += (RESITEM_INC +
			   class -> constraint_class.num_resources);
	    all = (ResItem **) XtRealloc ((char *) all, 
				(Cardinal) sizeof (ResItem *) * all_length);
	}

	list = (XrmResourceList *) class -> constraint_class.resources;
	for (i = 0; i < class -> constraint_class.num_resources; i++)
	{
	    ptr = all[all_count] =
		(ResItem *) XtMalloc (sizeof (ResItem));
	    ptr -> xrm_name = (XrmQuark) list[i] -> xrm_name;
	    ptr -> name = XrmQuarkToString (ptr -> xrm_name);
	    ptr -> xrm_type = (XrmQuark) list[i] -> xrm_type;
	    all_count++;
	}
    }

    qsort ((char *) all, all_count, sizeof (ResItem *),
	   (QsortCmpProc) ResItemCmp);

    ptr = (ResItem *) NULL;
    for (i = 0; i < all_count; i++)
    {
	if (i != 0)
	{
	    if (ptr -> xrm_name == all[i] -> xrm_name &&
		ptr -> xrm_type == all[i] -> xrm_type)
	    {
		XtFree ((char *) all[i]);
		continue;
	    }
	    XtFree ((char *) ptr);
	}
	ptr = all[i];
	value = XtentQuarkGetValue (widget, ptr -> xrm_type, ptr -> name);

	if (value == (char *) NULL && ptr -> xrm_type == XtQString)
	    value = "";
	else if (value == (char *) NULL) /* could not do the conversion */
	{
	    XtentFormatPrint (fp, "!%s.%s: NULL\n",
			      widget_name, ptr -> name,
			      (char *) NULL);
	    XtentFormatPrint (fp, "!%s.%s.XtRType: %s\n",
			      widget_name, ptr -> name,
			      XrmQuarkToString (ptr -> xrm_type),
			      (char *) NULL);
	    continue;
	}

	if (ptr -> xrm_type == XtQPixel)
	{
	    XColor c;
	    char color[8];

	    memset (&c, '\0', sizeof (XColor));
	    c.pixel = atol (value);
	    XQueryColor (XtentDisplay (),
			 widget -> core.colormap, &c);
	    sprintf (color, "#%2x%2x%2x",
		     (c.red >> 8) & 0xFF, (c.green >> 8) & 0xFF,
		     (c.blue >> 8) & 0xFF);
	    for (value = color; *value; value++)
		if (*value == ' ')
		    *value = '0';
	    value = color;
	    if (strcmp (value, "#ffffff") == 0)
		value = "white";
	    else if (strcmp (value, "#000000") == 0)
		value = "black";
	    else if (strcmp (value, "#ff0000") == 0)
		value = "red";
	    else if (strcmp (value, "#00ff00") == 0)
		value = "green";
	    else if (strcmp (value, "#0000ff") == 0)
		value = "blue";
	}
	XtentFormatPrint (fp, "%s.%s: %s\n", widget_name, ptr -> name,
			  value, (char *) NULL);
	XtentFormatPrint (fp, "%s.%s.XtRType: %s\n",
			  widget_name, ptr -> name,
			  XrmQuarkToString (ptr -> xrm_type), (char *) NULL);

    }
    XtFree ((char *) ptr);
    XtFree ((char *) all);
}

#if defined(__STDC__)		/* RAD */
static void XtentFormatPrint (XtentOutput *output, char *format, ...)
#else
static void 
XtentFormatPrint (output, format, va_alist)
XtentOutput *output;
char *format;
va_dcl
#endif
{
    va_list ap;
    char *args[16];
    int i;

#if defined(__STDC__)		/* RAD */
    va_start (ap, format);
#else
    va_start (ap);
#endif

    if (format == (char *) NULL)
	return;

    i = 0;
    while ((args[i] = va_arg (ap, char *)) != (char *) NULL)
    {
	i++;
	if (i == 16)
	    break;
    }

    va_end (ap);

    if (output -> resource)
    {
	char *ptr;
	int j;
	int length;
	XtentOutputLink *link;

	/*
	 * calculate the space that we will need
	 */
	length = 0;
	ptr = format;
	while (*ptr)
	{
	    if (*ptr == '%')
	    {
		ptr++;
		if (*ptr >= '0' && *ptr <= '9')
		{
		    length += atoi (ptr);
		    break;
		}
		switch (*ptr)
		{
		case 'd': case 'i': case 'u': case 'x': case 'X': case 'o':
		case 'p': case 'n':
		    length += 12;
		    break;
		case 'f': case 'e': case 'E': case 'g': case 'G':
		    length += 24;
		    break;
		case 'c': case 's': case '%':
		    break;
		}
	    }
	    ptr++;
	}

	length += (ptr - format);
	for (j = 0; j < i; j++)
	    length += strlen (args[j]);

	link = (XtentOutputLink *)XtMalloc (sizeof (XtentOutputLink) + length);

	sprintf (link -> item, format,
		 args[0], args[1], args[2], args[3],
		 args[4], args[5], args[6], args[7],
		 args[8], args[9], args[10], args[11],
		 args[12], args[13], args[14], args[15]);

	link -> char_length = strlen (link -> item);
	link -> next = output -> list;
	output -> list = link;

	return;
    }

    if (output -> fp == (FILE *) NULL)
	return;

    fprintf (output -> fp, format,
	     args[0], args[1], args[2], args[3],
	     args[4], args[5], args[6], args[7],
	     args[8], args[9], args[10], args[11],
	     args[12], args[13], args[14], args[15]);
}

#define XtentArgsLocalStoreSize	32

typedef struct ArgumentBuffer
{
    int frame;
    char *buffer;
    struct ArgumentBuffer  *next;
    char local_store[XtentArgsLocalStoreSize];
    char used_malloc;
} ArgumentBuffer;

static char *
XtentProcessArgN (display, toplevel_ptr, frame_data, index, do_expansion)
Display * display;
Widget * toplevel_ptr;
XtentFrameData * frame_data;
int index;
int do_expansion;
{
    static ArgumentBuffer ** args = (ArgumentBuffer **) NULL;
    static int ArgumentBufferCount = 0;
    static ArgumentBuffer * args_free_list = (ArgumentBuffer *) NULL;
    ArgumentBuffer * arg_ptr;
    char *null_return = "";
    register char *ptr;
    char *exp;
    int i, j;
    char c;
    int singular;
    int expand;
    char *buffer;

    /*
     * if this is a multiple argument function check if we have
     * already processed part of the line
     */
    if (frame_data -> last_arg != (char *) NULL &&
	frame_data -> last_arg_index <= index)
    {
	if (frame_data -> end_of_line)
	    return null_return;
	buffer = frame_data -> last_arg;
	if (*buffer == '\0')
	{
	    frame_data -> last_arg_index++;
	    frame_data -> end_of_line = True;
	    return null_return;
	}
	i = frame_data -> last_arg_index;
    }
    else
    {
	/*
	 *  buffer = XtentTrimBuffer (frame_data -> arg_buffer);
	 */
	ptr = frame_data -> arg_buffer;
	while (*ptr == ' ' || *ptr == '\t' || *ptr == '\n')
	    ptr++;
	buffer = ptr;

	frame_data -> parens = 0;
	frame_data -> end_of_line = False;

	if (*ptr == '(')
	{
	    /*
	     * 	    if (*XtentTrimBuffer (buffer + 1) == ')')
	     */
	    ptr++;
	    while (*ptr == ' ' || *ptr == '\t' || *ptr == '\n')
		ptr++;
	    if (*ptr == ')')
	    {
		frame_data -> last_arg = (char *) NULL;
		frame_data -> last_arg_index = 0;
		frame_data -> end_of_line = True;
		return null_return;
	    }
	}
	else if (index > 0) /* && *buffer != '(' */
	{
	    frame_data -> last_arg_index = 1;
	    frame_data -> end_of_line = True;
	    return null_return;
	}

	if (*buffer == '\0')
	{
	    frame_data -> last_arg = (char *) NULL;
	    frame_data -> last_arg_index = 0;
	    frame_data -> end_of_line = True;
	    return null_return;
	}

	frame_data -> last_arg = buffer;
	frame_data -> last_arg_index = index;

	i = 0;
    }

    /*
     * prepare to skip over the first (delimiter) character
     */
    if (index == -1)
    {
	if (*buffer == '(')
	{
	    frame_data -> parens++;
	    singular = False;
	}
	else
	{
	    buffer--;
	    singular = True;
	}
	index = 0;
    }
    else
    {
	singular = False;
	if (*buffer == '(')
	    frame_data -> parens++;
    }

    /*
     * check if the requested argument is within our range
     */
    if (index >= ArgumentBufferCount)
    {
	j = ArgumentBufferCount;

	ArgumentBufferCount =
	    (index >= (ArgumentBufferCount + XTENTMAXARGS) ? (index + 1) :
	     (ArgumentBufferCount + XTENTMAXARGS));

	args = (ArgumentBuffer **) XtRealloc ((char *) args,
				      (Cardinal) sizeof (ArgumentBuffer *) *
					      ArgumentBufferCount);

	for (expand = j; expand < ArgumentBufferCount; expand++)
	    args[expand] = (ArgumentBuffer *) NULL;
    }

    /*
     * loop though the arguments until we hit the one requested.
     */
    for (;;)
    {
	/*
	 * find the start and end of the current argument
	 *
	 *	    buffer = XtentTrimBuffer (buffer + 1);
	 *
	 */
	ptr = buffer;
	if (*ptr)
	{
	    ptr++;
	    while (*ptr == ' ' || *ptr == '\t' || *ptr == '\n')
		ptr++;
	}

	if (*ptr == '\0')
	{
	    frame_data -> last_arg = ptr;
	    frame_data -> last_arg_index = i;
	    frame_data -> end_of_line = True;
	    return null_return;
	}

	buffer = ptr;
	expand = False;
	for (;;)
	{
	    switch (*ptr)
	    {
	    case '\0':
		goto DoubleBreak;

	    case '\\':
		expand = True;
		if (*(ptr + 1))
		    ptr++;
		ptr++;
		continue;

	    case '^':
		expand = True;
		ptr++;
		continue;

	    case ',':
		if (singular == False && frame_data -> parens == 1)
		    goto DoubleBreak;
		ptr++;
		continue;

	    case '(':
		if (singular == False)
		    frame_data -> parens++;
		ptr++;
		continue;

	    case ')':
		if (singular == False)
		{
		    frame_data -> parens--;
		    if (frame_data -> parens == 0)
			goto DoubleBreak;
		}
		ptr++;
		continue;

	    default:
		ptr++;
		continue;
	    }
	}

    DoubleBreak:

	/*
	 * check if this is the argument that we wanted
	 */
	if (i == index)
	{
	    /*
	     * update the frame information
	     */
	    frame_data -> last_arg = ptr;
	    frame_data -> last_arg_index = i + 1;

	    /*
	     * trim trailing blanks
	     */
	    if (*ptr == '\0' || *ptr == ',')
		while ((*(ptr - 1) == ' ' ||
			*(ptr - 1) == '\t' ||
			*(ptr - 1) == '\n') &&
		       *(ptr - 2) != '\\')
		    ptr--;

	    if (ptr <= buffer)
		return null_return;

	    /*
	     * trim trailing blanks and closing paren
	     */
	    if (singular == False)
	    {
		int parens = frame_data -> parens;

		if (parens == 0 &&
		    ((*ptr == ' ' ||
		      *ptr == '\t' ||
		      *ptr == '\n') ||
		     *ptr == '\0') &&
		    *(ptr - 1) == ')')
		{
		    parens++;
		    ptr--;
		    while ((*(ptr - 1) == ' ' ||
			    *(ptr - 1) == '\t' ||
			    *(ptr - 1) == '\n') &&
			   *(ptr - 2) != '\\')
			ptr--;

		    if (ptr <= buffer)
			return null_return;
		}

		if (parens == 0 && *ptr == ')' &&
		    (*(ptr - 1) == ' ' ||
		     *(ptr - 1) == '\t' ||
		     *(ptr - 1) == '\n') &&
		    *(ptr - 2) != '\\')
		{
		    ptr--;
		    while ((*(ptr - 1) == ' ' ||
			    *(ptr - 1) == '\t' ||
			    *(ptr - 1) == '\n') &&
			   *(ptr - 2) != '\\')
			ptr--;

		    if (ptr <= buffer)
			return null_return;
		}
	    }

	    /*
	     * free previous arguments in this slot
	     */
	    j = frame_data -> frame;
	    arg_ptr = args[index];
	    while (arg_ptr && arg_ptr -> frame >= j)
	    {
		arg_ptr = args[index] -> next;
		if (args[index] -> used_malloc)
		    XtFree ((char *) args[index] -> buffer);
		args[index] -> next = args_free_list;
		args_free_list = args[index];
		args[index] = arg_ptr;
	    }

	    /*
	     * terminate the argument with a null
	     */
	    c = *ptr;
	    *ptr = '\0';

	    /*
	     * expand the argument if required
	     */
	    if (*buffer == '~')
	    {
		buffer++;
		expand = False;
	    }
	    if (expand && do_expansion)
		exp = XtentConvertEmbeddedNames (display, toplevel_ptr,
						 buffer);
	    else
		exp = buffer;

	    /*
	     * allocate an argment for the one we found
	     */
	    if (args_free_list == (ArgumentBuffer *) NULL)
	    {
		arg_ptr =
		    (ArgumentBuffer *) XtMalloc (32 * sizeof (ArgumentBuffer));

		args_free_list = arg_ptr;

		for (j = 0; j < 31; j++, arg_ptr++)
		    arg_ptr -> next = arg_ptr + 1;

		arg_ptr -> next = (ArgumentBuffer *) NULL;
	    }
	    arg_ptr = args_free_list;
	    args_free_list = arg_ptr -> next;

	    /*
	     * fill in the slots on the argument
	     */
	    arg_ptr -> frame = frame_data -> frame;

	    if (exp == buffer)
	    {
		j = strlen (exp) + 1;
		if (j <= XtentArgsLocalStoreSize)
		{
		    arg_ptr -> buffer = arg_ptr -> local_store;
		    memcpy (arg_ptr -> buffer, exp, j);

		    arg_ptr -> used_malloc = False;
		}
		else
		{
		    arg_ptr -> buffer = XtNewString (buffer);
		    arg_ptr -> used_malloc = True;
		}
	    }
	    else
	    {
		arg_ptr -> buffer = exp;
		arg_ptr -> used_malloc = True;
	    }
	    *ptr = c;

	    /*
	     * store this argument on the active list
	     */
	    arg_ptr -> next = args[index];
	    args[index] = arg_ptr;

	    return arg_ptr -> buffer;
	}

	/*
	 * move to the next argument
	 */
	buffer = ptr;
	i++;
	if (*buffer == '\0')
	{
	    frame_data -> last_arg = buffer;
	    frame_data -> last_arg_index = i;
	    frame_data -> end_of_line = True;
	    return null_return;
	}
    }
}

static void
XtentLocalVariable (display, access_type, frame_number,
		    argument_name, argument_value)
Display * display;
int access_type;
int frame_number;
char *argument_name;
char *argument_value;
{
    static XtentLocalArg * arg_list = (XtentLocalArg *) NULL;
    XrmDatabase db = XtDatabase(display);
    XtentLocalArg * arg_ptr;
    XrmString value_type;
    XrmValue value_return;
    char *ptr;
    int arg_size;

    switch (access_type)
    {
    case XtentVariablesPush:
	value_return.addr = (XtPointer) NULL;
	value_return.size = 0;
	if (!XrmGetResource (XtDatabase (display),
			     argument_name,
			     (char *) NULL,
			     &value_type,
			     &value_return))
	    value_return.size = 0;

	if (value_return.size <= 0)
	{
	    value_return.addr = "";
	    value_return.size = 1;
	}

	arg_size = strlen (argument_name) + 1;
	ptr = (char *) XtMalloc (sizeof (XtentLocalArg) +
				 value_return.size + arg_size);
	arg_ptr = (XtentLocalArg *) ptr;
	ptr += sizeof (XtentLocalArg);
	arg_ptr -> arg_name = ptr;
	ptr += arg_size;
	arg_ptr -> arg_value = ptr;

	memcpy (arg_ptr -> arg_name, argument_name, arg_size);
	memcpy (arg_ptr -> arg_value, value_return.addr,
	       value_return.size);

	arg_ptr -> reset_frame_number = frame_number;
	arg_ptr -> next = arg_list;
	arg_list = arg_ptr;

	if (argument_value &&
	    strcmp ((char *) value_return.addr, argument_value) != 0)
	    XtentXrmPutStringResource (&db,
				       argument_name, argument_value, 30);

	return;

    case XtentVariablesPop:
	arg_ptr = arg_list;
	while (arg_ptr)
	{
	    if (arg_ptr -> reset_frame_number < frame_number)
		return;

	    XtentXrmPutStringResource (&db,
				       arg_ptr -> arg_name,
				       arg_ptr -> arg_value, 30);

	    arg_list = arg_ptr -> next;
	    XtFree ((char *) arg_ptr);
	    arg_ptr = arg_list;
	}

	return;
    }
}

enum
{
    INCREMENT = 178,
    DECREMENT,
    SHIFTLEFT,
    SHIFTRIGHT,
    NUMBER,
    STRING,
    ABS,
    ACOS,
    ASIN,
    ATAN,
    ATAN2,
    COS,
    DUP,
    EXP,
    NEG,
    RET,
    SIN,
    SQRT,
    TAN,

    EQUAL,
    NOTEQUAL,
    GREATEROREQUAL,
    LESSOREQUAL,

    LOGIC_AND,
    LOGIC_OR
};

static char *
XtentCalcTrueOrFalseString (b)
int b;
{
    return (b ? "True" : "False");
}

enum
{
    ARG_BOOLEAN = 23,
    ARG_STRING,
    ARG_NUMBER
};

static void
XtentCalcParse (arg_ptr, double_type, arg_stack_required, arg_type)
register char *arg_ptr;
int double_type;
int *arg_stack_required;
unsigned int *arg_type;
{
    register int stack_required;
    register unsigned int type;

    /*
     * parse
     */
    type = *arg_ptr & 0177;
    stack_required = 0;

    switch (type)
    {
    case '!':
	if (arg_ptr[1] == '=' && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = NOTEQUAL;
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 1;
	    break;
	}
	type = STRING;
	break;
    case '&':
	if (arg_ptr[1] == '&' && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = LOGIC_AND;
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	break;
    case '%':
    case '*':
    case '/':
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	break;
    case '+':
    case '-':
	if (arg_ptr[1] == *arg_ptr && arg_ptr[2] == '\0')
	{
	    stack_required = 1;
	    type = ((*arg_ptr == '+') ?
		    INCREMENT : DECREMENT);
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	if (*arg_ptr == '-')
	{
	    if (XtentIsNumber (arg_ptr, False))
		type = NUMBER;
	}
	break;
    case '<':
    case '>':
	if (arg_ptr[1] == *arg_ptr && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = ((*arg_ptr == '<') ?
		    SHIFTLEFT : SHIFTRIGHT);
	    break;
	}
	if (arg_ptr[1] == '=' && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = ((*arg_ptr == '<') ?
		    LESSOREQUAL : GREATEROREQUAL);
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	break;
    case '=':
	if (arg_ptr[1] == '=' && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = EQUAL;
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	break;
    case '|':
	if (arg_ptr[1] == '|' && arg_ptr[2] == '\0')
	{
	    stack_required = 2;
	    type = LOGIC_OR;
	    break;
	}
	if (arg_ptr[1] == '\0')
	{
	    stack_required = 2;
	    break;
	}
	type = STRING;
	break;
    case 'A':
	if (strcmp (arg_ptr, "ABS") == 0)
	{
	    stack_required = 1;
	    type = ABS;
	    break;
	}
	if (strcmp (arg_ptr, "ACOS") == 0)
	{
	    stack_required = 1;
	    type = ACOS;
	    break;
	}
	if (strcmp (arg_ptr, "ASIN") == 0)
	{
	    stack_required = 1;
	    type = ASIN;
	    break;
	}
	if (strcmp (arg_ptr, "ATAN") == 0)
	{
	    stack_required = 1;
	    type = ATAN;
	    break;
	}
	if (strcmp (arg_ptr, "ATAN2") == 0)
	{
	    stack_required = 2;
	    type = ATAN2;
	    break;
	}
	type = STRING;
	break;
    case 'C':
	if (strcmp (arg_ptr, "COS") == 0)
	{
	    stack_required = 1;
	    type = COS;
	    break;
	}
	type = STRING;
	break;
    case 'D':
	if (strcmp (arg_ptr, "DUP") == 0)
	{
	    stack_required = 1;
	    type = DUP;
	    break;
	}
	type = STRING;
	break;
    case 'E':
	if (strcmp (arg_ptr, "EXP") == 0)
	{
	    stack_required = 2;
	    type = EXP;
	    break;
	}
	type = STRING;
	break;
    case 'N':
	if (strcmp (arg_ptr, "NEG") == 0)
	{
	    stack_required = 1;
	    type = NEG;
	    break;
	}
	type = STRING;
	break;
    case 'R':
	if (strcmp (arg_ptr, "RET") == 0)
	{
	    stack_required = 1;
	    type = RET;
	    break;
	}
	type = STRING;
	break;
    case 'S':
	if (strcmp (arg_ptr, "SIN") == 0)
	{
	    stack_required = 1;
	    type = SIN;
	    break;
	}
	if (strcmp (arg_ptr, "SQRT") == 0)
	{
	    stack_required = 1;
	    type = SQRT;
	    break;
	}
	type = STRING;
	break;
    case 'T':
	if (strcmp (arg_ptr, "TAN") == 0)
	{
	    stack_required = 1;
	    type = TAN;
	    break;
	}
	type = STRING;
	break;
    case '.':
	if (double_type && XtentIsNumber (arg_ptr, False))
	    type = NUMBER;
	else
	    type = STRING;
	break;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
	if (XtentIsNumber (arg_ptr, False))
	    type = NUMBER;
	else
	    type = STRING;
	break;
    default:
	if (type)
	    type = STRING;
	else
	    type = NUMBER;
	break;
    }

    *arg_type = type;
    *arg_stack_required = stack_required;
}

#undef ARGTYPE
#undef BOOLEANCONVERTER
#undef CONVERSIONFORMAT
#undef STRINGCONVERTER
#undef THISTYPE

#define ARGTYPE			XtentCalcIntegerPostFixArgs
#define BOOLEANCONVERTER	XtentCalcIntegerToBoolean
#define CONVERSIONFORMAT	"%d"
#define STRINGCONVERTER		atoi
#define THISTYPE		int

static int
XtentCalcIntegerToBoolean (ptr)
ARGTYPE * ptr;
{
    int b;

    switch (ptr -> type)
    {
    case ARG_BOOLEAN:
	return ptr -> x.bvalue;

    case ARG_STRING:
	if (strcmp (ptr -> x.svalue, "False") == 0)
	    b = False;
	else if (strcmp (ptr -> x.svalue, "True") == 0)
	    b = True;
	else if (*ptr -> x.svalue)
	    b = True;
	else
	    b = False;
	return b;

    case ARG_NUMBER:
	return (ptr -> x.nvalue != (THISTYPE) 0);
    }
    return False;
}

static void
XtentIntegerCalc (display, toplevel_ptr, frame_data_ptr)
Display * display;
Widget * toplevel_ptr;
XtentFrameData * frame_data_ptr;
{
    XrmDatabase db = XtDatabase(display);
    int current_arg;
    int stack_index = 0;
    int stack_size = 0;
    ARGTYPE * stack = (ARGTYPE *) NULL;
    register ARGTYPE * ptr1, *ptr2;
    char buffer[64];
    int stack_required;
    unsigned int type;
    register char *arg_ptr;
    int a, b;

    current_arg = 0;
    for (;;)
    {
	arg_ptr = XtentProcessArgN (display, toplevel_ptr, frame_data_ptr,
				    current_arg++, True);
	if (*arg_ptr == '\0' && frame_data_ptr -> end_of_line)
	    break;

	XtentCalcParse (arg_ptr, False, &stack_required, &type);

	if (stack_index < stack_required)
	{
	    fprintf (stderr,
		     "%s: The operation, \"%s\", was issued without enough arguments in XtCalc\n  at line %d, message %d: \"%s\"\n",
		     XtentProgramName (), arg_ptr,
		     XtentLineCount (), XtentMessageCount (),
		     frame_data_ptr -> buffer);
	    XtFree ((char *) stack);
	    return;
	}

	/*
	 * execute
	 */
	ptr1 = &stack[stack_index - 1];
	ptr2 = &stack[stack_index - 2];
	switch (type)
	{
	case '!':
	    ptr1 -> x.bvalue = (!BOOLEANCONVERTER (ptr1));
	    ptr1 -> type = ARG_BOOLEAN;
	    break;
	case '%':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue % (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '&':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue & (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '*':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue * ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '+':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue + ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '-':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue - ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '/':
	    if (ptr1 -> x.nvalue == (THISTYPE) 0)
	    {
		fprintf (stderr,
			 "%s: An attempted division by zero was found in XtCalc\n  at line %d, message %d: \"%s\"\n",
			 XtentProgramName (),
			 XtentLineCount (),
			 XtentMessageCount (),
			 buffer);
		XtFree ((char *) stack);
		return;
	    }
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue / ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '<':
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue < ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) < 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) < BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case '=':
	    if (ptr1 -> type == ARG_STRING)
	    {
		if (ptr2 -> type == ARG_BOOLEAN)
		    arg_ptr = XtentCalcTrueOrFalseString (ptr2 -> x.bvalue);
		else if (ptr2 -> type == ARG_STRING)
		    arg_ptr = ptr2 -> x.svalue;
		else
		{
		    sprintf (buffer, CONVERSIONFORMAT, ptr2 -> x.nvalue);
		    arg_ptr = buffer;
		}
		XtentXrmPutStringResource (&db, ptr1 -> x.svalue,
					   arg_ptr, 30);
	    }
	    stack_index--;
	    break;
	case '>':
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue > ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) > 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) > BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case '|':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue | (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case INCREMENT:
	    ptr1 -> x.nvalue++;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case DECREMENT:
	    ptr1 -> x.nvalue--;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case SHIFTLEFT:
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue <<
		(int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case SHIFTRIGHT:
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue >>
		(int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case NUMBER:
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
				       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index].x.nvalue = STRINGCONVERTER (arg_ptr);
	    stack[stack_index].type = ARG_NUMBER;
	    stack_index++;
	    break;
	case STRING: 		/* variable names and expr */
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
					       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index].x.svalue = arg_ptr;
	    stack[stack_index].type = ARG_STRING;
	    stack_index++;
	    break;
	case ABS:
	    ptr1 -> x.nvalue = XtentAbs (ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ACOS:
	    ptr1 -> x.nvalue = (THISTYPE) acos ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ASIN:
	    ptr1 -> x.nvalue = (THISTYPE) asin ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ATAN:
	    ptr1 -> x.nvalue = (THISTYPE) atan ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ATAN2:
	    ptr2 -> x.nvalue = (THISTYPE) atan2 ((double) ptr2 -> x.nvalue,
						 (double) ptr1 -> x.nvalue);
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case COS:
	    ptr1 -> x.nvalue = (THISTYPE) cos ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case DUP:
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
					       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index].x.svalue = ptr1 -> x.svalue;
	    stack[stack_index].type = ptr1 -> type;
	    stack_index++;
	    break;
	case EXP:
	{
	    THISTYPE x;
	    int count;
	    THISTYPE value;

	    x = ptr2 -> x.nvalue;
	    count = ptr1 -> x.nvalue;
	    value = 1;
	    while (count > 0)
	    {
		value *= x;
		count--;
	    }
	    ptr2 -> x.nvalue = value;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	}
	case NEG:
	    ptr1 -> x.nvalue = ptr1 -> x.nvalue * -1;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case RET:
	    if (ptr1 -> type == ARG_BOOLEAN)
		arg_ptr = XtentCalcTrueOrFalseString (ptr1 -> x.bvalue);
	    else if (ptr1 -> type == ARG_STRING)
		arg_ptr = ptr1 -> x.svalue;
	    else
	    {
		sprintf (buffer, CONVERSIONFORMAT, ptr1 -> x.nvalue);
		arg_ptr = buffer;
	    }
	    XtentSetReturn (arg_ptr);
	    break;
	case SIN:
	    ptr1 -> x.nvalue = (THISTYPE) sin ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case SQRT:
	    ptr1 -> x.nvalue = (THISTYPE) sqrt ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case TAN:
	    ptr1 -> x.nvalue = (THISTYPE) tan ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;

	case EQUAL:
	case NOTEQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue == ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) == 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) == BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = ((type == EQUAL) ? a : (!a));
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case GREATEROREQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue >= ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) >= 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) >= BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.nvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case LESSOREQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue <= ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) <= 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) <= BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.nvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case LOGIC_AND: 		/* a && b */
	case LOGIC_OR: 		/* a || b */
	    a = BOOLEANCONVERTER (ptr2);
	    b = BOOLEANCONVERTER (ptr1);
	    ptr2 -> x.nvalue = ((type == LOGIC_AND) ? (a && b) : (a || b));
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	}
    }
    XtFree ((char *) stack);
}

#undef ARGTYPE
#undef BOOLEANCONVERTER
#undef CONVERSIONFORMAT
#undef STRINGCONVERTER
#undef THISTYPE

#define ARGTYPE			XtentCalcDoublePostFixArgs
#define BOOLEANCONVERTER	XtentCalcDoubleToBoolean
#define CONVERSIONFORMAT	"%f"
#define STRINGCONVERTER		atof
#define THISTYPE		double

static int
XtentCalcDoubleToBoolean (ptr)
ARGTYPE * ptr;
{
    int b;

    switch (ptr -> type)
    {
    case ARG_BOOLEAN:
	return ptr -> x.bvalue;

    case ARG_STRING:
	if (strcmp (ptr -> x.svalue, "False") == 0)
	    b = False;
	else if (strcmp (ptr -> x.svalue, "True") == 0)
	    b = True;
	else if (*ptr -> x.svalue)
	    b = True;
	else
	    b = False;
	return b;

    case ARG_NUMBER:
	return (ptr -> x.nvalue != (THISTYPE) 0);
    }
    return False;
}

static void
XtentDoubleCalc (display, toplevel_ptr, frame_data_ptr)
Display * display;
Widget * toplevel_ptr;
XtentFrameData * frame_data_ptr;
{
    XrmDatabase db = XtDatabase(display);
    int current_arg;
    int stack_index = 0;
    int stack_size = 0;
    ARGTYPE * stack = (ARGTYPE *) NULL;
    register ARGTYPE * ptr1, *ptr2;
    char buffer[64];
    int stack_required;
    unsigned int type;
    register char *arg_ptr;
    int a, b;

    current_arg = 0;
    for (;;)
    {
	arg_ptr = XtentProcessArgN (display, toplevel_ptr, frame_data_ptr,
				    current_arg++, True);
	if (*arg_ptr == '\0' && frame_data_ptr -> end_of_line)
	    break;

	XtentCalcParse (arg_ptr, True, &stack_required, &type);

	if (stack_index < stack_required)
	{
	    fprintf (stderr,
		     "%s: The operation, \"%s\", was issued without enough arguments in XtCalc\n  at line %d, message %d: \"%s\"\n",
		     XtentProgramName (), arg_ptr,
		     XtentLineCount (), XtentMessageCount (),
		     frame_data_ptr -> buffer);
	    XtFree ((char *) stack);
	    return;
	}

	/*
	 * execute
	 */
	ptr1 = &stack[stack_index - 1];
	ptr2 = &stack[stack_index - 2];
	switch (type)
	{
	case '!':
	    ptr1 -> x.bvalue = (!BOOLEANCONVERTER (ptr1));
	    ptr1 -> type = ARG_BOOLEAN;
	    break;
	case '%':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue % (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '&':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue & (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '*':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue * ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '+':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue + ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '-':
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue - ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '/':
	    if (ptr1 -> x.nvalue == (THISTYPE) 0)
	    {
		fprintf (stderr,
			 "%s: An attempted division by zero was found in XtCalc\n  at line %d, message %d: \"%s\"\n",
			 XtentProgramName (),
			 XtentLineCount (),
			 XtentMessageCount (),
			 buffer);
		XtFree ((char *) stack);
		return;
	    }
	    ptr2 -> x.nvalue = ptr2 -> x.nvalue / ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case '<':
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue < ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) < 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) < BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case '=':
	    if (ptr1 -> type == ARG_STRING)
	    {
		if (ptr2 -> type == ARG_BOOLEAN)
		    arg_ptr = XtentCalcTrueOrFalseString (ptr2 -> x.bvalue);
		else if (ptr2 -> type == ARG_STRING)
		    arg_ptr = ptr2 -> x.svalue;
		else
		{
		    sprintf (buffer, CONVERSIONFORMAT, ptr2 -> x.nvalue);
		    arg_ptr = buffer;
		}
		XtentXrmPutStringResource (&db, ptr1 -> x.svalue,
					   arg_ptr, 30);
	    }
	    stack_index--;
	    break;
	case '>':
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue > ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) > 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) > BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case '|':
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue | (int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case INCREMENT:
	    ptr1 -> x.nvalue++;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case DECREMENT:
	    ptr1 -> x.nvalue--;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case SHIFTLEFT:
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue <<
		(int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case SHIFTRIGHT:
	    ptr2 -> x.nvalue = (int) ptr2 -> x.nvalue >>
		(int) ptr1 -> x.nvalue;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case NUMBER:
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
				       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index].x.nvalue = STRINGCONVERTER (arg_ptr);
	    stack[stack_index].type = ARG_NUMBER;
	    stack_index++;
	    break;
	case STRING: 		/* variable names and expr */
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
				       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index].x.svalue = arg_ptr;
	    stack[stack_index].type = ARG_STRING;
	    stack_index++;
	    break;
	case ABS:
	    ptr1 -> x.nvalue = XtentAbs (ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ACOS:
	    ptr1 -> x.nvalue = (THISTYPE) acos ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ASIN:
	    ptr1 -> x.nvalue = (THISTYPE) asin ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ATAN:
	    ptr1 -> x.nvalue = (THISTYPE) atan ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case ATAN2:
	    ptr2 -> x.nvalue = (THISTYPE) atan2 ((double) ptr2 -> x.nvalue,
						 (double) ptr1 -> x.nvalue);
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	case COS:
	    ptr1 -> x.nvalue = (THISTYPE) cos ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case DUP:
	    if (stack_index == stack_size)
	    {
		stack_size += 16;
		stack = (ARGTYPE *) XtRealloc ((char *) stack,
				       (Cardinal) sizeof (ARGTYPE) * stack_size);
	    }
	    stack[stack_index] = *ptr1;
	    stack_index++;
	    break;
	case EXP:
	{
	    THISTYPE x;
	    int count;
	    THISTYPE value;

	    x = ptr2 -> x.nvalue;
	    count = ptr1 -> x.nvalue;
	    value = 1;
	    while (count > 0)
	    {
		value *= x;
		count--;
	    }
	    ptr2 -> x.nvalue = value;
	    ptr2 -> type = ARG_NUMBER;
	    stack_index--;
	    break;
	}
	case NEG:
	    ptr1 -> x.nvalue = ptr1 -> x.nvalue * -1;
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case RET:
	    if (ptr1 -> type == ARG_BOOLEAN)
		arg_ptr = XtentCalcTrueOrFalseString (ptr1 -> x.bvalue);
	    else if (ptr1 -> type == ARG_STRING)
		arg_ptr = ptr1 -> x.svalue;
	    else
	    {
		sprintf (buffer, CONVERSIONFORMAT, ptr1 -> x.nvalue);
		arg_ptr = buffer;
	    }
	    XtentSetReturn (arg_ptr);
	    break;
	case SIN:
	    ptr1 -> x.nvalue = (THISTYPE) sin ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case SQRT:
	    ptr1 -> x.nvalue = (THISTYPE) sqrt ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;
	case TAN:
	    ptr1 -> x.nvalue = (THISTYPE) tan ((double) ptr1 -> x.nvalue);
	    ptr1 -> type = ARG_NUMBER;
	    break;

	case EQUAL:
	case NOTEQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue == ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) == 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) == BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.bvalue = ((type == EQUAL) ? a : (!a));
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case GREATEROREQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue >= ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) >= 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) >= BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.nvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case LESSOREQUAL:
	    if (ptr1 -> type == ARG_NUMBER && ptr2 -> type == ARG_NUMBER)
		a = (ptr2 -> x.nvalue <= ptr1 -> x.nvalue);
	    else if (ptr1 -> type == ARG_STRING && ptr2 -> type == ARG_STRING)
		a = (strcmp (ptr2 -> x.svalue, ptr1 -> x.svalue) <= 0);
	    else
		a = (BOOLEANCONVERTER (ptr2) <= BOOLEANCONVERTER (ptr1));
	    ptr2 -> x.nvalue = a;
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	case LOGIC_AND: 		/* a && b */
	case LOGIC_OR: 		/* a || b */
	    a = BOOLEANCONVERTER (ptr2);
	    b = BOOLEANCONVERTER (ptr1);
	    ptr2 -> x.nvalue = ((type == LOGIC_AND) ? (a && b) : (a || b));
	    ptr2 -> type = ARG_BOOLEAN;
	    stack_index--;
	    break;
	}
    }
    XtFree ((char *) stack);
}

static void
XtentSetReturn (value)
char *value;
{
    int length;

    if (XtentReturnValue &&
	XtentReturnValue != XtentReturnBuffer)
	XtFree ((char *) XtentReturnValue);

    length = strlen (value) + 1;
    if (length < XtentReturnBufferSize)
	XtentReturnValue = XtentReturnBuffer;
    else
	XtentReturnValue = (char *) XtMalloc (length);

    memcpy (XtentReturnValue, value, length);
}

static void
XtentPutStringReturn (db, variable_name, value)
XrmDatabase * db;
char *variable_name;
char *value;
{
    if (variable_name && *variable_name)
	XtentXrmPutStringResource (db, variable_name, value, 30);
    else
    {				/* same as XtentSetReturn (value) */
	int length;

	if (XtentReturnValue &&
	    XtentReturnValue != XtentReturnBuffer)
	    XtFree ((char *) XtentReturnValue);

	length = strlen (value) + 1;
	if (length < XtentReturnBufferSize)
	    XtentReturnValue = XtentReturnBuffer;
	else
	    XtentReturnValue = (char *) XtMalloc (length);

	memcpy (XtentReturnValue, value, length);
    }
}

static int
XtentIsNumber (ptr, check_dot)
register char *ptr;
int check_dot;
{
    char c;
    int dot = 0;
    int digit = 0;
    int minus = 0;

    for (;;)
    {
	c = *ptr++;
	switch (c)
	{
	case '\0':
	    return (check_dot ? (dot && digit) : (digit));
	case '.':
	    if (dot)
		return False;
	    dot++;
	    break;
	case '-':
	    if (minus)
		return False;
	    minus++;
	    break;
	case ' ': 			/* trim front and back */
	case '\t':
	case '\n':
	    while (*ptr == ' ' || *ptr == '\t' || *ptr == '\n')
		ptr++;
	    if (*ptr)
	    {
		if (dot || digit || minus)
		    return False;
		continue;
	    }
	    return (check_dot ? (dot && digit) : (digit));

	default:
	    if (!(c >= '0' && c <= '9'))
		return False;
	    digit++;
	}
    }
}

#ifdef ATHENA

static void
XtentScrollbarDestroyProc (w, client_data, value)
Widget w;
XtPointer client_data;
XtPointer value;
{
    char **array = (char **) client_data;
    int i = 0;
    
    while (array[i])
    {
	XtFree (array[i]);
	i++;
    }
    XtFree ((char *) array);
}

static void
XtentStripChartGetValueProc (w, client_data, value)
Widget w;
XtPointer client_data;
XtPointer value;
{
    Display * display = XtDisplay (w);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    char *eval_ptr = (char *) client_data;
    double *x = (double *) value;
    XtentFrameData frame_data;
    char format_buffer[64];
    char *name_ptr = "%strip-chart.value";
    XrmString value_type;
    XrmValue value_return;

    if (eval_ptr == NULL || *eval_ptr == '\0')
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    sprintf (format_buffer, "%f", *x);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, name_ptr,
			format_buffer);

    XtentEvalResourceLine (display, toplevel_ptr, eval_ptr);

    if (XrmGetResource (XtDatabase (display), name_ptr, (char *) NULL,
			&value_type, &value_return) &&
	value_return.size > 0)
    {
	*x = atof ((char *) value_return.addr);
    }

    ArgNReturnVoid ();
}

static void
XtentStripChartDestroyProc (w, client_data, value)
Widget w;
XtPointer client_data;
XtPointer value;
{
    XtFree ((char *) client_data);
}

#endif /* ATHENA */

#ifdef MOTIF

/*
 * needs work: add the eval source
 */
static void
XtentXmCutPasteProc (w, data_id, private, reason)
Widget w;
int *data_id;
int *private;
int *reason;
{
    Display * display = XtentDisplay ();
    Widget * toplevel_ptr = XtentToplevelPtr ();
    XtentFrameData frame_data;
    char format_buffer[64];
    char *ptr;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%cutPaste.widget",
			XtentWidgetToName (w));

    sprintf (format_buffer, "%d", *data_id);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%cutPaste.data_id",
			format_buffer);

    sprintf (format_buffer, "%d", *private);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%cutPaste.private",
			format_buffer);

    ptr = "XmCR_CLIPBOARD_DATA_DELETE";
    if (*reason == XmCR_CLIPBOARD_DATA_REQUEST)
	ptr = "XmCR_CLIPBOARD_DATA_REQUEST";

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%cutPaste.reason",
			ptr);
/*
    XtentEvalResourceLine (display, toplevel_ptr, cb -> code);
*/
    ArgNReturnVoid ();
}

#endif /* MOTIF */

#ifdef OPENLOOK

static int
XtentOLAxis (arg_ptr)
char *arg_ptr;
{
    if (strcmp (arg_ptr, "OL_HORIZONTAL") == 0 ||
	atoi (arg_ptr) == OL_HORIZONTAL)
	return OL_HORIZONTAL;
    else
	return OL_VERTICAL;
}

static void
XtentOLSLDestroyCallbackProc (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Arg arg;
    OLSLDestroyCallbackListItem * list_next_ptr;
    OLSLDestroyCallbackListItem * list_ptr =
	(OLSLDestroyCallbackListItem *) NULL;

    XtSetArg (arg, XtNuserData, (XtArgVal) & list_ptr);
    XtGetValues (w, &arg, 1);
    while (list_ptr)
    {
	list_next_ptr = list_ptr -> next;
	XtFree ((char *) list_ptr);
	list_ptr = list_next_ptr;
    }
}

/* RAD */
/*
 * OpenLook generic help function
 */
static void
XtentOLHelpProc (id_type, id, src_x, src_y)
OlDefine id_type;
XtPointer id;
int  src_x, src_y;
{
        Display *display;
        Widget *toplevel_ptr;
        XtentFrameData frame_data;
        char *eval_ptr;
	XtentWidgetClassName *wcn;
	char *name;
	char buffer[64];
	register char *arg_ptr;
	OlFlatHelpId *flatid;
	XtPointer lookupid;
	OLHelpProcLine *helpproc, *helpproc_prev;

	name = "";
	if ( id_type == OL_WIDGET_HELP )
	{
		name = XtentWidgetToName ((Widget) id);
	}
	else if ( id_type == OL_FLAT_HELP )
	{
		flatid = (OlFlatHelpId *) id;
		name = XtentWidgetToName (flatid->widget);
	}
	else
	{
                wcn = XtentWidgetClassNames;
                while (wcn -> string != (char *) NULL)
                {
                        if (*wcn -> class == (WidgetClass) id)
                        {
				name = wcn -> string;
                                break;
                        }
                        wcn++;
                }
	}

	/*
	 * initialize this frame
	 */
	XtentCreateFrame (&frame_data);
	frame_data.buffer = (char *) NULL;
	frame_data.evaluation_block = True;

	lookupid = (id_type == OL_FLAT_HELP) ? (XtPointer) flatid->widget : id;

	eval_ptr = "";
	for (helpproc_prev = NULL, helpproc = XtentOLHelpProcLines; helpproc;
             helpproc_prev = helpproc, helpproc = helpproc -> next)
        {
		if ( lookupid == helpproc -> id )
                {
			if ( id_type == OL_FLAT_HELP && 
				helpproc -> flatitem != flatid -> item_index)
				continue;
			else
			{
				display = helpproc -> display;
				toplevel_ptr = helpproc -> toplevel_ptr;
				eval_ptr = XtentTrimBuffer (helpproc -> args);
				break;
			}
                }
        }

	if (*eval_ptr == '\0')
		ArgNReturnVoid ();
        frame_data.arg_buffer = eval_ptr;
        eval_ptr = ArgN (-1);
        if (*eval_ptr == '\0')
		ArgNReturnVoid ();

	arg_ptr = buffer;

	XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
			    "%help.widget", name);

	if ( id_type == OL_FLAT_HELP )
	{
		sprintf (arg_ptr, "%d", flatid->item_index);
		XtentLocalVariable (display, XtentVariablesPush,
				    frame_data.frame, "%help.flatitem",
				    arg_ptr);
	}

	sprintf (arg_ptr, "%d", src_x);
	XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
			    "%help.x", arg_ptr);

	sprintf (arg_ptr, "%d", src_y);
	XtentLocalVariable (display, XtentVariablesPush, frame_data.frame,
			    "%help.y", arg_ptr);

        XtentEvalResourceLine (display, toplevel_ptr, eval_ptr);

	ArgNReturnVoid ();
}
/* RAD */

#ifndef OLD_OPENLOOK

static void
XtentOlDnDPreviewAnimateCallbackProc (widget, eventcode, time_stamp,
				      sensitivity, closure)
Widget widget;
int eventcode;
Time time_stamp;
Boolean sensitivity;
XtPointer closure;
{
    Display * display = XtDisplay (widget);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    char *eval_ptr = (char *) closure;
    XtentFrameData frame_data;
    char format_buffer[32];

    if (eval_ptr == NULL || *eval_ptr == '\0')
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%drag-and-drop.widget",
			XtentWidgetToName (widget));

    sprintf (format_buffer, "%d", eventcode);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%drag-and-drop.eventcode",
			format_buffer);

    sprintf (format_buffer, "%d", time_stamp);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%drag-and-drop.time-stamp",
			format_buffer);

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%drag-and-drop.sensitivity",
			XtentCalcTrueOrFalseString (sensitivity));

    XtentEvalResourceLine (display, toplevel_ptr, eval_ptr);

    ArgNReturnVoid ();
}

static void
XtentOlDnDTriggerMessageNotifyProc (widget, window, root_x, root_y,
				    selection, time_stamp, dropsiteid,
				    operation, send_done, forwarded, closure)
Widget widget;
Window window;
Position root_x;
Position root_y;
Atom selection;
Time time_stamp;
OlDnDDropSiteID dropsiteid;
OlDnDTriggerOperation operation;
Boolean send_done;
Boolean forwarded;
XtPointer closure;
{
    Display * display = XtDisplay (widget);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    OLDropSiteMessageLine *ds = (OLDropSiteMessageLine *) closure;
    XtentFrameData frame_data;
    char format_buffer[32];

    if (!(ds && ds -> trigger_code && *ds -> trigger_code))
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.widget",
			XtentWidgetToName (widget));

    sprintf (format_buffer, "%d", window);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%triggerwindow",
			format_buffer);

    sprintf (format_buffer, "%d", root_x);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.root-x",
			format_buffer);

    sprintf (format_buffer, "%d", root_y);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.root-y",
			format_buffer);

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.selection",
			XtentAtomToString (display, selection));

    sprintf (format_buffer, "%d", time_stamp);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.time-stamp",
			format_buffer);

    sprintf (format_buffer, "%d", dropsiteid);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.dropsite-id",
			format_buffer);

    sprintf (format_buffer, "%d", operation);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.operation",
			format_buffer);

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.send-done",
			XtentCalcTrueOrFalseString (send_done));

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%trigger.forwarded",
			XtentCalcTrueOrFalseString (forwarded));

    XtentEvalResourceLine (display, toplevel_ptr, ds -> trigger_code);

    ArgNReturnVoid ();
}

/* the Sun supplied function prototype does not match the documentation */
static void
XtentOlDnDPreviewMessageNotifyProc (widget, window, root_x, root_y, operation,
				    time_stamp, dropsiteid, forwarded, closure)
Widget widget;
Window window;
Position root_x;
Position root_y;
int operation;
Time time_stamp;
OlDnDDropSiteID dropsiteid;
Boolean forwarded;
XtPointer closure;
{
    Display * display = XtDisplay (widget);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    OLDropSiteMessageLine *ds = (OLDropSiteMessageLine *) closure;
    XtentFrameData frame_data;
    char format_buffer[32];

    if (!(ds && ds -> preview_code && *ds -> preview_code))
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.widget",
			XtentWidgetToName (widget));

    sprintf (format_buffer, "%d", window);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%previewwindow",
			format_buffer);

    sprintf (format_buffer, "%d", root_x);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.root-x",
			format_buffer);

    sprintf (format_buffer, "%d", root_y);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.root-y",
			format_buffer);

    sprintf (format_buffer, "%d", operation);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.operation",
			format_buffer);

    sprintf (format_buffer, "%d", time_stamp);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.time-stamp",
			format_buffer);

    sprintf (format_buffer, "%d", dropsiteid);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.dropsite-id",
			format_buffer);

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%preview.forwarded",
			XtentCalcTrueOrFalseString (forwarded));

    XtentEvalResourceLine (display, toplevel_ptr, ds -> preview_code);

    ArgNReturnVoid ();
}

static void
XtentOlDnDProtocolActionCallbackProc (widget, selection, protocol_action,
				      flag, closure)
Widget widget;
Atom selection;
OlDnDProtocolAction protocol_action;
Boolean flag;
XtPointer closure;
{
    Display * display = XtDisplay (widget);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    char *code = closure;
    XtentFrameData frame_data;
    char format_buffer[32];

    if (!(code && *code))
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%protocol-action.widget",
			XtentWidgetToName (widget));

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%protocol-action.selection",
			XtentAtomToString (display, selection));

    sprintf (format_buffer, "%d", protocol_action);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%protocol-action.protocol-action",
			format_buffer);

    sprintf (format_buffer, "%d", flag);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%protocol-action.flag",
			XtentCalcTrueOrFalseString (flag));

    XtentEvalResourceLine (display, toplevel_ptr, code);

    XtFree (code);

    ArgNReturnVoid ();
}

static void
XtentOlDnDTransactionStateCallback (widget, selection, state, time_stamp,
				    closure)
Widget widget;
Atom selection;
OlDnDTransactionState state;
Time time_stamp;
XtPointer closure;
{
    Display * display = XtDisplay (widget);
    Widget * toplevel_ptr = XtentToplevelPtr ();
    SelectionLine *s = (SelectionLine *) closure;
    XtentFrameData frame_data;
    char *code_ptr;
    char format_buffer[32];

    if (!(s && s -> transaction_state_code && *s -> transaction_state_code))
	return;

    XtentCreateFrame (&frame_data);
    frame_data.buffer = (char *) NULL;
    frame_data.evaluation_block = True;

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%transaction.widget",
			XtentWidgetToName (widget));

    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%transaction.selection",
			s -> selection_atom_string);

    sprintf (format_buffer, "%d", state);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%transaction.state",
			format_buffer);

    sprintf (format_buffer, "%d", time_stamp);
    XtentLocalVariable (display, XtentVariablesPush,
			frame_data.frame, "%transaction.time-stamp",
			format_buffer);

    code_ptr = XtNewString (s -> transaction_state_code);
    XtentEvalResourceLine (display, toplevel_ptr, code_ptr);
    XtFree (code_ptr);

    ArgNReturnVoid ();
}

#endif /* OLD_OPENLOOK */

#endif /* OPENLOOK */
