static char TMXGetPoints_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
/*
#include <X11/copyright.h>
*/
/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.
 *
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 * MODIFICATION HISTORY
 *
 * 000 -- Loretta Guarino Reid, DEC Ultrix Engineering Group
 * 001 -- Ralph R. Swick, DEC/MIT Project Athena
 *	  tailor to uwm; use global resources created by uwm
 * 002 -- completely recast as XGetRect() for use by applications
 *        most every line has been touched - Blewett
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

/*
 *  Function prototypes used in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern XRectangle *
XGetPoints C_P_ARGS((Display *display, int screen, Window window,
		     XSizeHints *hints, char *format, char *font,
		     Cursor application_cursor, int move_window, int type,
		     XRectangle *rect, Window *return_window));

static void
MoveWindow C_P_ARGS((Display * display, Window window,
		     int width, int height, int border_width, int root_width,
		     int winx, int winy, int x1, int y1, int x2, int y2));

static Window
locate_sub_window C_P_ARGS((Display *display, XEvent *event));

C_PROTOS_END_EXTERN


#define FALSE			False
#define TRUE			True
#define MIN(x, y)		((x) <= (y) ? (x) : (y))
#define MAX(x, y)		((x) >= (y) ? (x) : (y))
#define ABS(a)			((a) > 0 ? (a) : -(a))
#define DIVMUL(a, b)		((b == 1) ? (a) : (((int)((a) / (b))) * (b)))
#define LARGEST_DIMENSION	0xffff	/* largest unsigned 16 bit number */
#define PCOUNT			1 + (4 * 2 * 2)
#define BORDER_WIDTH		2
#define BUTTON_EVENTS		(ButtonPressMask | ButtonReleaseMask)


XRectangle *
XGetPoints (display, screen, window, hints, format, font, application_cursor,
	    type, move_window,
	    rect, return_window)
Display *display;
int screen;
Window window;
XSizeHints *hints;
char *format;
char *font;
Cursor application_cursor;
int move_window, type;
XRectangle *rect;
Window *return_window;
{
	Cursor ur, ul, ll, lr;		/* cursors for rubber banding */
	Cursor current_cursor;
	int     change_cursor = FALSE;
	XFontStruct *prompt_font;	/* application specified font */
	char   *text;			/* prompt string storage */
	int     text_len;
	XGCValues xgc;
	GC prompt_gc = (GC) NULL;
	GC box_gc = (GC) NULL;
	Window prompt_window;		/* prompt window creation */
	int     prompt_window_width, prompt_window_height;
	XSetWindowAttributes attr;
	Window root = RootWindow (display, screen);
	Window root_window, sub_window;	/* for XQueryPointer */
	int     rootx, rooty, ignore;	/* for XQueryPointer */
	int     root_window_width;
	int     minwidth, minheight;	/* values from the hints */
	int     maxwidth, maxheight;
	int     winx, winy, defwidth, defheight, winwidth, winheight;
	int     xinc = 1, yinc = 1;
	int     width_offset, height_offset;
	int     x1, y1;			/* location of mouse */
	int     x2, y2;			/* other corner of box */
	int     hsize, vsize;
	int     Rdx, Rdy;		/* real sizes */
	int     dx, dy;
	int     button_released;	/* loop variables */
	int     changed;
	int     chosen = -1;
	unsigned int button_mask;
	int     xa = -1, ya = -1, xb = -1, yb = -1;
	int	temp;
	XEvent event;
	XPoint box[PCOUNT];

	/*
	 * check hints for complete spec
	 */
	if (hints && hints -> flags & USPosition)
	{
		rect -> x = hints -> x;
		rect -> y = hints -> y;
		rect -> width = hints -> width;
		rect -> height = hints -> height;
		if (hints -> flags & PMinSize)
		{
			if ((int) rect -> width < hints -> min_width)
				rect -> width = hints -> min_width;
			if ((int) rect -> height < hints -> min_height)
				rect -> height = hints -> min_height;
		}
		return rect;
	}
	
	/*
	 * cursors for rubber banding
	 */
	if (type == 2)
	{
		if (application_cursor == (Cursor) None)
			current_cursor = XCreateFontCursor (display,
							    XC_crosshair);
		else
			current_cursor = application_cursor;
	}
	else
	{
		ur = XCreateFontCursor (display, XC_ur_angle);
		ul = XCreateFontCursor (display, XC_ul_angle);
		ll = XCreateFontCursor (display, XC_ll_angle);
		lr = XCreateFontCursor (display, XC_lr_angle);
		current_cursor = ul;
	}
	/*
	 * load the application specified font
	 */
	if (format)
	{
		prompt_font = XLoadQueryFont (display, font);
		if (prompt_font == NULL)
		{
			fprintf (stderr, "GetRect: cannot open font: %s\n",
				 font);
			return rect;
		}
	}
	else
		move_window = FALSE;	/* avoid the window */
	
	/*
	 * allocate space for the prompt string
	 */
	if (format)
	{
		text_len = strlen (format) + 256; /* take a guess */
		if ((text = (char *) malloc (text_len)) == (char *) NULL)
		{
			fprintf (stderr, "GetRect: cannot allocate space.\n");
			return rect;
		}
		if (type)
			sprintf (text, format, 0, 0);
		else
			sprintf (text, format, 0, 0, 0, 0);
		text_len = strlen (text);
	}
	
	/* 
	 * spin loop waiting to grab the mouse
	 */
	for (;;)
	{
		if (XGrabPointer (display, window, FALSE, BUTTON_EVENTS,
				  GrabModeAsync, GrabModeAsync,
				  None, current_cursor,
				  CurrentTime) == GrabSuccess)
			break;
		sleep (1);
	}

	/*
	 * pixels for GC's and windows
	 */
	xgc.foreground = WhitePixel (display, screen);
	xgc.background = BlackPixel (display, screen);
	
	/*
	 * GC's for the prompt string and for the on screen rectangle
	 */
	if (format)
	{
		xgc.font = prompt_font -> fid;
		prompt_gc = XCreateGC (display, root,
				       GCForeground | GCBackground | GCFont,
				       &xgc);
	}
	xgc.function = GXinvert;
	xgc.subwindow_mode = IncludeInferiors;
	box_gc = XCreateGC (display, root, GCFunction | GCSubwindowMode, &xgc);

	/*
	 * create the prompt window
	 */
	if (format)
	{
		prompt_window_width = XTextWidth (prompt_font, text, text_len) +
			2 * BORDER_WIDTH;
		prompt_window_height = prompt_font -> ascent +
			prompt_font -> descent + 2 * BORDER_WIDTH;

		prompt_window = XCreateSimpleWindow (display, root, 0, 0,
						     prompt_window_width,
						     prompt_window_height,
						     BORDER_WIDTH,
						     xgc.foreground,
						     xgc.background);
		attr.save_under = TRUE;
		attr.event_mask = (VisibilityChangeMask | ExposureMask);
		attr.override_redirect = TRUE;
		XChangeWindowAttributes (display, prompt_window,
					 (CWSaveUnder | CWEventMask |
					  CWOverrideRedirect), &attr);

		XTranslateCoordinates (display, window, root, 0, 0,
				       &winx, &winy, &sub_window);
		
		XMoveWindow (display, prompt_window, winx, winy);
	}
	
	/* 
	 * get the current size and border width to use as defaults
	 */
	XGetGeometry (display, window, &root_window, &ignore, &ignore,
		      (unsigned int *) &winwidth, (unsigned int *) &winheight, 
		      (unsigned int *) &ignore, (unsigned int *) &ignore);
	XGetGeometry (display, root, &root_window, &ignore, &ignore,
		      (unsigned int *) &defwidth, (unsigned int *) &defheight, 
		      (unsigned int *) &ignore, (unsigned int *) &ignore);
	root_window_width = defwidth;

	/*
	 * scan the values from the hints structure
	 */
	if (hints && hints -> flags & PMinSize)
	{
		minwidth = hints -> min_width;
		minheight = hints -> min_height;
	}
	else
	{
		minwidth = 0;
		minheight = 0;
	}
	
	if (hints && hints -> flags & PMaxSize)
	{
		maxwidth = MAX (hints -> max_width, minwidth);
		maxheight = MAX (hints -> max_height, minheight);
	}
	else
	{
		maxwidth = LARGEST_DIMENSION;
		maxheight = LARGEST_DIMENSION;
	}
	if (hints && hints -> flags & PResizeInc)
	{
		xinc = hints -> width_inc;
		yinc = hints -> height_inc;
	}
	if (xinc <= 0)
		xinc = 1;
	if (yinc <= 0)
		yinc = 1;
	
	if (hints && (hints -> flags & PSize || hints -> flags & USSize))
	{
		defwidth = hints -> width;
		defheight = hints -> height;
	}
	else
		if (hints && hints -> flags & PMinSize)
		{
			defwidth = hints -> min_width;
			defheight = hints -> min_height;
		}
		else
			if (hints && hints -> flags & PMaxSize)
			{
				defwidth = hints -> max_width;
				defheight = hints -> max_height;
			}
	
	/* 
	 * until there are better WM_HINTS, we'll assume that the client's
	 * minimum width and height are the appropriate offsets to subtract
	 * when resizing  with an explicit resize increment.
	 */
	if (hints && hints -> flags & PMinSize && hints -> flags & PResizeInc)
	{
		width_offset = hints -> min_width;
		height_offset = hints -> min_height;
	}
	else
		width_offset = height_offset = 0;
	
	/*
	 * get an initial (x, y) position to start the loop
	 */
	XQueryPointer (display, window, &root_window, &sub_window,
		       &rootx, &rooty, &x1, &y1, &button_mask);

	if (button_mask & Button2Mask)
	    chosen = Button2;
	if (chosen != -1 && type != 2)
	    change_cursor = True;

	if (move_window)
		MoveWindow (display, prompt_window,
			    prompt_window_width,
			    prompt_window_height,
			    BORDER_WIDTH, root_window_width,
			    winx, winy, x1, y1, x1, y1);

	if (format)
		XMapWindow (display, prompt_window);

	hsize = defwidth;		/* already includes border_width */
	vsize = defheight;		/* already includes border_width */
	if (type == 2)
	{
		x2 = x1;
		y2 = y1;
	}
	else
	{
		x2 = x1 + hsize;
		y2 = y1 + vsize;
	}
	button_released = FALSE;
	changed = TRUE;
	while (button_released == FALSE)
	{
		if (type != 2 &&
		    (xb != MAX (x1, x2)) || (yb != MAX (y1, y2)) ||
		    (xa != MIN (x1, x2)) || (ya != MIN (y1, y2)))
		{
			int     i;

			xa = MIN (x1, x2);
			ya = MIN (y1, y2);
			xb = MAX (x1, x2);
			yb = MAX (y1, y2);
			for (i = 0; i < PCOUNT; i += 4)
			{
				box[i].x = xa;
				box[i].y = ya;
				if (i + 1 == PCOUNT)
					break;
				box[i + 1].x = xb;
				box[i + 1].y = ya;
				box[i + 2].x = xb;
				box[i + 2].y = yb;
				box[i + 3].x = xa;
				box[i + 3].y = yb;
			}
			changed = TRUE;
		}

		if (format &&
		    XPending (display) &&
		    XCheckWindowEvent (display, prompt_window, ~NoEventMask,
				       &event))
		{
			switch (event.type)
			{
			case VisibilityNotify: 
				if (((XVisibilityEvent *) & event) -> state !=
				    VisibilityUnobscured)
					XRaiseWindow (display, prompt_window);
				continue;/* go to top of while loop */
			case Expose: 
				changed = TRUE;
				break;
				/* but go to next if statement */
			default: 
				break;/* ignore it */
			}
		}

		if (format && changed)
		{
			int Hsize = (hsize - width_offset) / xinc;
			int Vsize = (vsize - height_offset) / yinc;
			int width;
			
			changed = FALSE;
			if (type == 2)
				sprintf (text, format, x1, y1);
			else if (type)
				sprintf (text, format, Hsize, Vsize);
			else
				sprintf (text, format, xa, ya,
					 Hsize, Vsize);
			text_len = strlen (text);
			width = XTextWidth (prompt_font, text, text_len) +
				2 * BORDER_WIDTH;
			if (width != prompt_window_width)
			{
				prompt_window_width = width;
				XResizeWindow (display, prompt_window,
					       prompt_window_width,
					       prompt_window_height);
			}
			XDrawImageString (display, prompt_window, prompt_gc,
					  BORDER_WIDTH,
					  BORDER_WIDTH + prompt_font -> ascent,
					  text, text_len);
		}

		if (type != 2)
			XDrawLines (display, window, box_gc, box, PCOUNT,
				    CoordModeOrigin);

		if (XPending (display) &&
		    XCheckMaskEvent (display, ButtonPressMask |
				     ButtonReleaseMask, &event))
		{
			if (chosen < 0 && event.type == ButtonPress)
			{
				x1 = x2 = ((XButtonEvent *) & event) -> x;
				y1 = y2 = ((XButtonEvent *) & event) -> y;
				chosen = ((XButtonEvent *) & event) -> button;
				if (chosen == Button2)
					change_cursor = TRUE;
			}
			else
				if ((event.type == ButtonRelease) &&
				    ((((XButtonEvent *) & event) -> button) ==
				     chosen))
				{
					x2 = ((XButtonEvent *) & event) -> x;
					y2 = ((XButtonEvent *) & event) -> y;

					*return_window = locate_sub_window
						(display, &event);
					button_released = TRUE;
				}
				else
					XQueryPointer (display, window,
						       &root_window,
						       &sub_window,
						       &rootx, &rooty,
						       &x2, &y2, 
						       (unsigned int *) &ignore);
		}
		else

			XQueryPointer (display, window, &root_window,
				       &sub_window, &rootx, &rooty,
				       &x2, &y2, (unsigned int *) &ignore);
		if (window != root)
		{
			temp = FALSE;
			if (x2 > winwidth)
			{
				x2 = winwidth;
				temp = TRUE;
			}
			if (x2 < 0)
			{
				x2 = 0;
				temp = TRUE;
			}
			if (y2 > winheight)
			{
				y2 = winheight;
				temp = TRUE;
			}
			if (y2 < 0)
			{
				y2 = 0;
				temp = TRUE;
			}
			if (temp)
				XWarpPointer (display, (Window) NULL, window,
					      0, 0, 0, 0,
					      x2, y2);
		}

		if (type == 2)
		{
			x1 = x2;
			y1 = y2;
			if (move_window)
				MoveWindow (display, prompt_window,
					    prompt_window_width,
					    prompt_window_height,
					    BORDER_WIDTH, root_window_width,
					    winx, winy, x1, y1, x2, y2);
			continue;
		}

		if (change_cursor)
		{
			if ((x2 >= x1) && (y2 >= y1) && current_cursor != lr)
			{
				XChangeActivePointerGrab (display,
							  BUTTON_EVENTS, lr,
							  CurrentTime);
				current_cursor = lr;
			}
			else
				if ((x2 >= x1) && (y2 < y1) &&
				    current_cursor != ur)
				{
					XChangeActivePointerGrab (display,
								  BUTTON_EVENTS,
								  ur,
								  CurrentTime);
					current_cursor = ur;
				}
				else
					if ((x2 < x1) && (y2 >= y1) &&
					    current_cursor != ll)
					{
						XChangeActivePointerGrab (display, BUTTON_EVENTS, ll, CurrentTime);
						current_cursor = ll;
					}
					else
						if ((x2 < x1) && (y2 < y1) &&
						    (current_cursor != ul))
						{
							XChangeActivePointerGrab (display, BUTTON_EVENTS, ul, CurrentTime);
							current_cursor = ul;
						}
		}

		if (chosen != Button2)
		{
			x1 = x2;
			y1 = y2;
			if (chosen >= 0)
			{
				x2 = defwidth;
				if (chosen == Button1)
					y2 = defheight;
				else
					y2 = defheight - y1;
				x2 = x1 + x2;
				y2 = y1 + y2;
			}
			else
			{
				x2 = x1 + defwidth;
				y2 = y1 + defheight;
			}
		}
		
		dx = MAX (MIN (ABS (x2 - x1), maxwidth), minwidth);
		dx = DIVMUL (dx - minwidth, xinc) + minwidth;
		Rdx = dx;
		
		dy = MAX (MIN (ABS (y2 - y1), maxheight), minheight);
		dy = DIVMUL (dy - minheight, yinc) + minheight;
		Rdy = dy;
		
		if (hints && hints -> flags & PAspect)
		{
			int     delta;

			if (Rdx * hints -> max_aspect.y >
			    Rdy * hints -> max_aspect.x)
			{
				delta = DIVMUL ((Rdx * hints -> max_aspect.y /
						 hints -> max_aspect.x) - Rdy,
						yinc);
				if ((dy + delta) <= maxheight)
					dy += delta;
				else
				{
					delta = DIVMUL (Rdx - hints -> max_aspect.x * Rdy / hints -> max_aspect.y,
							xinc);
					if ((dx - delta) >= minwidth)
						dx -= delta;
				}
			}

			if (Rdx * hints -> min_aspect.y <
			    Rdy * hints -> min_aspect.x)
			{
				delta = DIVMUL ((hints -> min_aspect.x * Rdy /
						 hints -> min_aspect.y) - Rdx,
						xinc);
				if (dx + delta <= maxwidth)
					dx += delta;
				else
				{
					delta = DIVMUL (Rdy - (Rdx * hints -> min_aspect.y / hints -> min_aspect.x),
							yinc);
					if ((dy - delta) >= minheight)
						dy -= delta;
				}
			}
			
		}
		
		if (dx != hsize)
		{
			hsize = dx;
			changed = TRUE;
		}
		if (dy != vsize)
		{
			vsize = dy;
			changed = TRUE;
		}
		
		if (x2 < x1)
			x2 = x1 - dx;
		else
			x2 = x1 + dx;
		
		if (y2 < y1)
			y2 = y1 - dy;
		else
			y2 = y1 + dy;

		if (move_window)
			MoveWindow (display, prompt_window,
				    prompt_window_width,
				    prompt_window_height,
				    BORDER_WIDTH, root_window_width,
				    winx, winy, x1, y1, x2, y2);
	}
	
	XUngrabPointer (display, CurrentTime);
	
	if (format)
	{
		XDestroyWindow (display, prompt_window);
		XFreeFont (display, prompt_font);
		XFree (text);
	}
	if (type == 2)
	{
		if (application_cursor == (Cursor) None)
			XFreeCursor (display, current_cursor);
	}
	else
	{
		XFreeCursor (display, ur);
		XFreeCursor (display, ul);
		XFreeCursor (display, lr);
		XFreeCursor (display, ll);
	}

	if (box_gc)
	    XFreeGC (display, box_gc);

	if (prompt_gc)
	    XFreeGC (display, prompt_gc);

	rect -> x = MIN (x1, x2);
	rect -> y = MIN (y1, y2);
	rect -> width = hsize;
	rect -> height = vsize;
	XSync (display, FALSE);

	return rect;
}

static void
MoveWindow (display, window, width, height, border_width, root_width,
	    winx, winy, x1, y1, x2, y2)
Display * display;
Window window;
int width, height, border_width, root_width;
int winx, winy;
int x1, y1, x2, y2;
{
	static int last_x = -1;
	static int last_y = -1;
	int x, y;

	x1 += winx; x2 += winx; y1 += winy; y2 += winy;
	if ((x = MIN (x1, x2)) < 0)
		x = MAX (x1, x2) + 2 * border_width;
	if ((x + width + 2 * border_width) > root_width)
		x = root_width - (width + 2 * border_width);
	if ((y = (MIN (y1, y2) - (height + 2 * border_width))) < 0)
		y = MAX (y1, y2);

	if (last_x != x || last_y != y)
		XMoveWindow (display, window, last_x = x, last_y = y);
}

static Window
locate_sub_window (display, event)
Display *display;
XEvent *event;
{
	Window parent, sub, child;
	int x, y;

	parent = event -> xbutton.window;
	sub = event -> xbutton.subwindow;
	if (sub == (Window) NULL)
		return parent;
	child = sub;
	x = event -> xbutton.x;
	y = event -> xbutton.y;
	/* returns child window of sub if that contains coords, else nil */
	while (child != None)
	{
		if (XTranslateCoordinates (display, parent, sub,
					   x, y, &x, &y,
					   &child) == FALSE)
		{
			fprintf (stderr,
				 "GetRect: XTranslateCoordinates() failed.\n");
			return sub;
		}

		parent = sub;
		sub = child;
	}

	return parent;
}
