static char TMHPResConvert_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifdef HP_WIDGETS
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        ResConvert.c
 **
 **   Project:     X Widgets
 **
 **   Description: Contains a function to register all of the resource
 **                type converters used within Xw and the converter
 **                routines.
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/TextEdit.h>
#include <X11/StringDefs.h>
#include "C_P_args.h"

static void _XwCvtStringToTraversalType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToHighlightStyle C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToTileType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToSlideOrientation C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToArrowDirection C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToRowColMode C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToLayoutPolicy C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToLabelLocation C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static Boolean StringsAreEqual C_P_ARGS((char *, char *));
static void _XwCvtStringToAlignment C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToWidgetType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToLayoutType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToSeparatorType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToSelectionMethod C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToSelectionStyle C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToSelectionBias C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToElementHighlight C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToDestroyMode C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToGravity  C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToTitlePositionType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToLabelType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtStringToTitleType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void  CvtStringToEditMode C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtStringToSourceType C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void  CvtStringToWrap C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtStringToWrapBreak C_P_ARGS((XrmValue *, Cardinal, XrmValue *,
		XrmValue *));
static void  CvtStringToWrapForm C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtStringToScroll C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtStringToGrow C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));

static void _XwCvtTraversalTypeToString  C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtHighlightStyleToString  C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtTileTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtSlideOrientationToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtArrowDirectionToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtRowColModeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtLayoutPolicyToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtLabelLocationToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtAlignmentToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtWidgetTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtLayoutTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtSeparatorTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtSelectionMethodToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtSelectionStyleToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtSelectionBiasToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtElementHighlightToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtDestroyModeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtGravityToString  C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtTitlePositionTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtLabelTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void _XwCvtTitleTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void  CvtEditModeToString C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtSourceTypeToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void  CvtWrapToString C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtWrapBreakToString C_P_ARGS((XrmValue *, Cardinal, 
		XrmValue *, XrmValue *));
static void  CvtWrapFormToString C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtScrollToString C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));
static void  CvtGrowToString C_P_ARGS((XrmValue *, Cardinal, XrmValue *, 
		XrmValue *));

typedef struct {
  unsigned char *string;
  int value;
} XwSetValuePair;

#define NUMVALUESETS            7
#define XwEditTypeValueSetNum   0
#define XwSourceTypeValueSetNum 1
#define XwWrapValueSetNum       2
#define XwWrapFormValueSetNum   3  
#define XwWrapBreakValueSetNum  4
#define XwScrollValueSetNum     5
#define XwGrowValueSetNum       6

static XwSetValuePair XwEditTypeValueSet[] =
    { {(unsigned char *)"edit",   (int) XwtextEdit},
      {(unsigned char *)"append", (int) XwtextAppend},
      {(unsigned char *)"read",   (int) XwtextRead},
	NULL };
static XwSetValuePair XwSourceTypeValueSet[] =
    {{(unsigned char *)"stringsrc",   (int) XwstringSrc},
     {(unsigned char *)"disksrc",     (int) XwdiskSrc},
     {(unsigned char *)"userdefined", (int) XwprogDefinedSrc},
     NULL };
static XwSetValuePair XwWrapValueSet[] =
    {{(unsigned char *)"wrapoff",     (int) XwWrapOff},
     {(unsigned char *)"softwrap",    (int) XwSoftWrap},
     {(unsigned char *)"hardwrap",    (int) XwHardWrap},
     NULL };
static XwSetValuePair XwWrapFormValueSet[] =
    {{(unsigned char *)"sourceform",  (int) XwSourceForm},
     {(unsigned char *)"displayform", (int) XwDisplayForm},
     NULL };
static XwSetValuePair XwWrapBreakValueSet[] =
    {{(unsigned char *)"wrapany",        (int) XwWrapAny},
     {(unsigned char *)"wrapwhitespace", (int) XwWrapWhiteSpace},
     NULL };
static XwSetValuePair XwScrollValueSet[] =
    {{(unsigned char *)"autoscrolloff",        (int) XwAutoScrollOff},
     {(unsigned char *)"autoscrollvertical",   (int) XwAutoScrollVertical},
     {(unsigned char *)"autoscrollhorizontal", (int) XwAutoScrollHorizontal},
     {(unsigned char *)"autoscrollboth",       (int) XwAutoScrollBoth},
     NULL };
static XwSetValuePair XwGrowValueSet[] =
    {{(unsigned char *)"growoff",        (int) XwGrowOff},
     {(unsigned char *)"growhorizontal", (int) XwGrowHorizontal},
     {(unsigned char *)"growvertical",   (int) XwGrowVertical},
     {(unsigned char *)"growboth",       (int) XwGrowBoth},
     NULL };

static XwSetValuePair *valuepairsets[NUMVALUESETS];

/************************************************************************
 *
 *  XwRegisterConverters
 *	Register all of the Xw resource type converters.  Retain a
 *	flag indicating whether the converters have already been
 *	registered.
 *
 ************************************************************************/

XwRegisterConverters ()
{
   static Boolean registered = False;

   if (!registered)
   {
      XtAddConverter (XtRString, XtRTraversalType,
                      _XwCvtStringToTraversalType, NULL, 0);
      XtAddConverter (XtRString, XtRRCMode,
		      _XwCvtStringToRowColMode, NULL, 0);
      XtAddConverter (XtRString, XtRLayout,
		      _XwCvtStringToLayoutPolicy, NULL, 0);
      XtAddConverter (XtRString, XtRHighlightStyle,
		      _XwCvtStringToHighlightStyle, NULL, 0);
      XtAddConverter (XtRString, XtRTileType,
		      _XwCvtStringToTileType, NULL, 0);
      XtAddConverter (XtRString, XtRArrowDirection,
                      _XwCvtStringToArrowDirection, NULL, 0);
      XtAddConverter (XtRString, XtRLabelLocation,
                      _XwCvtStringToLabelLocation, NULL, 0);
      XtAddConverter (XtRString, XtRSlideOrientation,
                      _XwCvtStringToSlideOrientation, NULL, 0);
      XtAddConverter (XtRString, XtRAlignment,
                      _XwCvtStringToAlignment, NULL, 0);
      XtAddConverter (XtRString, XtRWidgetType,
                      _XwCvtStringToWidgetType, NULL, 0);
      XtAddConverter (XtRString, XtRLayoutType,
                      _XwCvtStringToLayoutType, NULL, 0);
      XtAddConverter (XtRString, XtRSeparatorType,
                      _XwCvtStringToSeparatorType, NULL, 0);
      XtAddConverter (XtRString, XtRSelectionMethod,
		      _XwCvtStringToSelectionMethod, NULL,0);
      XtAddConverter (XtRString, XtRSelectionStyle,
		      _XwCvtStringToSelectionStyle, NULL,0);
      XtAddConverter (XtRString, XtRSelectionBias,
		      _XwCvtStringToSelectionBias, NULL,0);
      XtAddConverter (XtRString, XtRElementHighlight,
		      _XwCvtStringToElementHighlight, NULL,0);
      XtAddConverter (XtRString, XtRDestroyMode,
		      _XwCvtStringToDestroyMode, NULL,0);
      XtAddConverter (XtRString, XtRGravity,
		      _XwCvtStringToGravity, NULL,0);
      XtAddConverter (XtRString, XtRTitlePositionType,
                      _XwCvtStringToTitlePositionType, NULL, 0);
      XtAddConverter (XtRString, XtRTitleType, _XwCvtStringToTitleType, 
                      NULL, 0);
      XtAddConverter (XtRString, XtRLabelType, _XwCvtStringToLabelType, 
                      NULL, 0);

  valuepairsets[XwEditTypeValueSetNum] = XwEditTypeValueSet;  
  valuepairsets[XwSourceTypeValueSetNum] = XwSourceTypeValueSet;
  valuepairsets[XwWrapValueSetNum] = XwWrapValueSet;
  valuepairsets[XwWrapFormValueSetNum] = XwWrapFormValueSet;
  valuepairsets[XwWrapBreakValueSetNum] = XwWrapBreakValueSet;
  valuepairsets[XwScrollValueSetNum] = XwScrollValueSet;
  valuepairsets[XwGrowValueSetNum] = XwGrowValueSet;

  XtAddConverter(XtRString, XtREditMode, CvtStringToEditMode, NULL, 0);
  XtAddConverter(XtRString, XtRSourceType, CvtStringToSourceType, NULL, 0);
  XtAddConverter(XtRString, XtRWrap, CvtStringToWrap, NULL, 0);
  XtAddConverter(XtRString, XtRWrapBreak, CvtStringToWrapBreak, NULL, 0);
  XtAddConverter(XtRString, XtRWrapForm, CvtStringToWrapForm, NULL, 0);
  XtAddConverter(XtRString, XtRScroll, CvtStringToScroll, NULL, 0);
  XtAddConverter(XtRString, XtRGrow, CvtStringToGrow, NULL, 0);

/*
 * back to string routines
 */
      XtAddConverter (XtRTraversalType, XtRString,
                      _XwCvtTraversalTypeToString, NULL, 0);
      XtAddConverter (XtRRCMode, XtRString,
		      _XwCvtRowColModeToString, NULL, 0);
      XtAddConverter (XtRLayout, XtRString,
		      _XwCvtLayoutPolicyToString, NULL, 0);
      XtAddConverter (XtRHighlightStyle, XtRString,
		      _XwCvtHighlightStyleToString, NULL, 0);
      XtAddConverter (XtRTileType, XtRString,
		      _XwCvtTileTypeToString, NULL, 0);
      XtAddConverter (XtRArrowDirection, XtRString,
                      _XwCvtArrowDirectionToString, NULL, 0);
      XtAddConverter (XtRLabelLocation, XtRString,
                      _XwCvtLabelLocationToString, NULL, 0);
      XtAddConverter (XtRSlideOrientation, XtRString,
                      _XwCvtSlideOrientationToString, NULL, 0);
      XtAddConverter (XtRAlignment, XtRString,
                      _XwCvtAlignmentToString, NULL, 0);
      XtAddConverter (XtRWidgetType, XtRString,
                      _XwCvtWidgetTypeToString, NULL, 0);
      XtAddConverter (XtRLayoutType, XtRString,
                      _XwCvtLayoutTypeToString, NULL, 0);
      XtAddConverter (XtRSeparatorType, XtRString,
                      _XwCvtSeparatorTypeToString, NULL, 0);
      XtAddConverter (XtRSelectionMethod, XtRString,
		      _XwCvtSelectionMethodToString, NULL,0);
      XtAddConverter (XtRSelectionStyle, XtRString,
		      _XwCvtSelectionStyleToString, NULL,0);
      XtAddConverter (XtRSelectionBias, XtRString,
		      _XwCvtSelectionBiasToString, NULL,0);
      XtAddConverter (XtRElementHighlight, XtRString,
		      _XwCvtElementHighlightToString, NULL,0);
      XtAddConverter (XtRDestroyMode, XtRString,
		      _XwCvtDestroyModeToString, NULL,0);
      XtAddConverter (XtRGravity, XtRString,
		      _XwCvtGravityToString, NULL,0);
      XtAddConverter (XtRTitlePositionType, XtRString,
                      _XwCvtTitlePositionTypeToString, NULL, 0);
      XtAddConverter (XtRTitleType, XtRString, _XwCvtTitleTypeToString, 
                      NULL, 0);
      XtAddConverter (XtRLabelType, XtRString, _XwCvtLabelTypeToString, 
                      NULL, 0);

  XtAddConverter(XtREditMode, XtRString, CvtEditModeToString, NULL, 0);
  XtAddConverter(XtRSourceType, XtRString, CvtSourceTypeToString, NULL, 0);
  XtAddConverter(XtRWrap, XtRString, CvtWrapToString, NULL, 0);
  XtAddConverter(XtRWrapBreak, XtRString, CvtWrapBreakToString, NULL, 0);
  XtAddConverter(XtRWrapForm, XtRString, CvtWrapFormToString, NULL, 0);
  XtAddConverter(XtRScroll, XtRString, CvtScrollToString, NULL, 0);
  XtAddConverter(XtRGrow, XtRString, CvtGrowToString, NULL, 0);

  }
   registered = True;
}




/************************************************************************
 *
 *  Resource Conversion Functions
 *     The following set of functions are used by the resource
 *     manager to convert the resource types defined for this class.
 *
 ************************************************************************/


/*  Convert a string to a traversal type.  */

static void _XwCvtStringToTraversalType (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwHIGHLIGHT_OFF;

   if (((*in_str) == 'H') || ((*in_str) == 'h'))
   {
      if (StringsAreEqual (in_str, "highlight_traversal"))
         i = XwHIGHLIGHT_TRAVERSAL;
      else if (StringsAreEqual (in_str, "highlight_enter"))
         i = XwHIGHLIGHT_ENTER;
   }

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtTraversalTypeToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwHIGHLIGHT_OFF:
	   in_str = "highlight_off";
	   break;
   case XwHIGHLIGHT_TRAVERSAL:
	   in_str = "highlight_traversal";
	   break;
   case XwHIGHLIGHT_ENTER:
	   in_str = "highlight_enter";
	   break;
   }

   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/*  Convert a string to a Selection Style.  */

static void _XwCvtStringToSelectionStyle (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   static int i;

   if (StringsAreEqual ("instant", (char *) fromVal -> addr) )
      i = XwINSTANT;
   else if (StringsAreEqual("sticky", (char *) fromVal -> addr))
      i = XwSTICKY;
   else
      i = XwSTICKY;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtSelectionStyleToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwINSTANT:
	   in_str = "instant";
	   break;
   case XwSTICKY:
   default:
	   in_str = "sticky";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/*  Convert a string to a Selection Method.  */

static void _XwCvtStringToSelectionMethod (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   static int i;

   if (StringsAreEqual ("single", (char *) fromVal -> addr))
      i = XwSINGLE;
   else if (StringsAreEqual ("multiple", (char *) fromVal -> addr))
      i = XwMULTIPLE;
   else
      i = XwSINGLE;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtSelectionMethodToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwSINGLE:
   default:
	   in_str = "single";
	   break;
   case XwMULTIPLE:
	   in_str = "multiple";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/*  Convert a string to a Selection Bias.  */

static void _XwCvtStringToSelectionBias (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   static int i;

   if (StringsAreEqual ("col_bias", (char *) fromVal -> addr) )
      i = XwCOL_BIAS;
   else if (StringsAreEqual ("row_bias", (char *) fromVal -> addr))
      i = XwROW_BIAS;
   else
      i = XwNO_BIAS;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtSelectionBiasToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwCOL_BIAS:
	   in_str = "col_bias";
	   break;
   case XwROW_BIAS:
	   in_str = "row_bias";
	   break;
   case XwNO_BIAS:
   default:
	   in_str = "no_bias";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/*  Convert a string to a element highlight.  */

static void _XwCvtStringToElementHighlight (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   static int i;

   if (StringsAreEqual ("border", (char *) fromVal -> addr))
      i = XwBORDER;
   else if (StringsAreEqual ("invert", (char *) fromVal -> addr))
      i = XwINVERT;
   else
      i = XwINVERT;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtElementHighlightToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwBORDER:
	   in_str = "border";
	   break;
   case XwINVERT:
   default:
	   in_str = "invert";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/*  Convert a string to a destroy mode.  */

static void _XwCvtStringToDestroyMode (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   static int i;

   if (StringsAreEqual ("no_shrink", (char *) fromVal -> addr))
      i = XwNO_SHRINK;
   else if (StringsAreEqual ("shrink_all", (char *) fromVal -> addr))
      i = XwSHRINK_ALL;
   else
      i = XwSHRINK_COLUMN;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtDestroyModeToString (args, numArgs, fromVal, toVal) 
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwNO_SHRINK:
	   in_str = "no_shrink";
	   break;
   case XwSHRINK_ALL:
	   in_str = "shrink_all";
	   break;
   case XwSHRINK_COLUMN:
   default:
	   in_str = "shrink_column";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/******************************************************/
/*  Convert a string to a ButtonClass Label Location. */
/******************************************************/
static void _XwCvtStringToLabelLocation (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

    if (((*in_str)== 'L') || ((*in_str)=='l'))
        {
           if (StringsAreEqual(in_str,"left")) i = XwLEFT;
	}
   else
      i = XwRIGHT;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtLabelLocationToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwLEFT:
	   in_str = "left";
	   break;
   case XwRIGHT:
   default:
	   in_str = "right";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}



/*****************************************************/
/*  Convert a string to a Row/Column selection type. */
/*****************************************************/
static void _XwCvtStringToRowColMode (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

    if (((*in_str)== 'O') || ((*in_str)=='o'))
        {
           if (StringsAreEqual(in_str,"one_of_many")) i = XwONE_OF_MANY;
	}
   else
      i = XwN_OF_MANY;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtRowColModeToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwONE_OF_MANY:
	   in_str = "one_of_many";
	   break;
   case XwN_OF_MANY:
   default:
	   in_str = "n_of_many";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}



/********************************************************/
/*  Convert a string to ManagerClass layout mode type.  */
/********************************************************/
static void _XwCvtStringToLayoutPolicy (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwMINIMIZE;

   switch(*in_str)
   {
      case 'I':
      case 'i':
           if (StringsAreEqual(in_str,"ignore")) i = XwIGNORE;
	   break;
	   
      case 'M':
      case 'm':
           if (StringsAreEqual(in_str,"maximize")) i = XwMAXIMIZE;

   }

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtLayoutPolicyToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwIGNORE:
	   in_str = "ignore";
	   break;
   case XwMAXIMIZE:
	   in_str = "maximize";
	   break;
   case XwMINIMIZE:
   default:
	   in_str = "minimize";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}



static Boolean StringsAreEqual(in_str, test_str)
char *in_str, *test_str;
{
   int i, j;

   for (;;)
   {
      i = *in_str;
      j = *test_str;

      if (isupper(i)) i = tolower(i);
      if (isupper(j)) j = tolower(j);
      if (i != j) return (False);
      if (i == 0) return (True);

      in_str++;
      test_str++;
   }
}   


/*  Convert a string to a highlight type.  */

static void _XwCvtStringToHighlightStyle (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwWIDGET_DEFINED;

   if (((*in_str) == 'P') || ((*in_str) == 'p'))
      if (StringsAreEqual (in_str, "pattern_border"))
         i = XwPATTERN_BORDER;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtHighlightStyleToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwPATTERN_BORDER:
	   in_str = "pattern_border";
	   break;
   case XwWIDGET_DEFINED:
   default:
	   in_str = "widget_defined";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}




/*  Convert a string to an tile type.  */

static void _XwCvtStringToTileType (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = Xw50_FOREGROUND;

   switch (*in_str)
   {
      case 'F':
      case 'f':
         if (StringsAreEqual (in_str, "foreground")) i = XwFOREGROUND;
      break;

      case 'B':
      case 'b':
         if (StringsAreEqual (in_str, "background")) i = XwBACKGROUND;
      break;

      case '2':
         if (StringsAreEqual (in_str, "25_foreground")) i = Xw25_FOREGROUND;
      break;

      case '5':
         if (StringsAreEqual (in_str, "50_foreground")) i = Xw50_FOREGROUND;
      break;

      case '7':
         if (StringsAreEqual (in_str, "75_foreground")) i = Xw75_FOREGROUND;
      break;

      case 'V':
      case 'v':
         if (StringsAreEqual (in_str, "vertical_tile")) i = XwVERTICAL_TILE;
      break;

      case 'H':
      case 'h':
         if (StringsAreEqual(in_str,"horizontal_tile")) i = XwHORIZONTAL_TILE;
      break;

      case 'S':
      case 's':
         if (StringsAreEqual (in_str, "slant_left")) i = XwSLANT_LEFT;
         else if (StringsAreEqual (in_str, "slant_right")) i = XwSLANT_RIGHT;
      break;
   }


   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtTileTypeToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwFOREGROUND:
	   in_str = "foreground";
	   break;
   case XwBACKGROUND:
	   in_str = "background";
	   break;
   case Xw25_FOREGROUND:
	   in_str = "25_foreground";
	   break;
   case Xw50_FOREGROUND:
   default:
	   in_str = "50_foreground";
	   break;
   case Xw75_FOREGROUND:
	   in_str = "75_foreground";
	   break;
   case XwVERTICAL_TILE:
	   in_str = "vertical_tile";
	   break;
   case XwHORIZONTAL_TILE:
	   in_str = "horizontal_tile";
	   break;
   case XwSLANT_LEFT:
	   in_str = "slant_left";
	   break;
   case XwSLANT_RIGHT:
	   in_str = "slant_right";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}




/*  Convert a string to a slide orientation.  */

static void _XwCvtStringToSlideOrientation (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwVERTICAL;

   if (((*in_str) == 'H') || ((*in_str) == 'h'))
      if (StringsAreEqual (in_str, "horizontal")) i = XwHORIZONTAL;

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtSlideOrientationToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwVERTICAL:
   default:
	   in_str = "vertical";
	   break;
   case XwHORIZONTAL:
	   in_str = "horizontal";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}



/*  Convert a string to an arrow direction.  */

static void _XwCvtStringToArrowDirection (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwARROW_UP;

   if (((*in_str) == 'A') || ((*in_str) == 'a'))
   {
      if (StringsAreEqual (in_str, "arrow_down")) i = XwARROW_DOWN;
      else if (StringsAreEqual (in_str, "arrow_left")) i = XwARROW_LEFT;
      else if (StringsAreEqual (in_str, "arrow_right")) i = XwARROW_RIGHT;
   }

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtArrowDirectionToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwARROW_UP:
   default:
	   in_str = "arrow_up";
	   break;
   case XwARROW_DOWN:
	   in_str = "arrow_down";
	   break;
   case XwARROW_LEFT:
	   in_str = "arrow_left";
	   break;
   case XwARROW_RIGHT:
	   in_str = "arrow_right";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}


/*************************************<->*************************************
 *
 *   static  void _XwCvtStringToAlignment()
 *		Display	*display;
 *		XrmValue	*p_fromVal;
 *		XrmValue	*toVal;
 *
 *	Description:
 *	-----------
 *		This is a type conversion procedure for the resource manager.
 *		converts strings to type XwAlignment.  The conversion is case
 *		insensitive.
 *
 *	Inputs:
 *	------
 *		See "Xlib - C Language X Interface Protocol Version 11"
 *
 *	Outputs:
 *	-------
 *		See "Xlib - C Language X Interface Protocol Version 11"
 *
 *	Procedures Called
 *	-----------------
 *		StringsAreEqual
 *
 *************************************<->***********************************/
static void _XwCvtStringToAlignment(args,num,p_fromVal,toVal)
	XrmValue	*args;
	Cardinal	num;
	XrmValue	*p_fromVal;
	XrmValue	*toVal;
{
	static XwAlignment	Align = XwALIGN_LEFT;
	char	*from_str;
	Boolean	match = FALSE;

	from_str = (char *) (p_fromVal->addr);
	toVal->addr = (caddr_t) &Align;
	toVal->size = sizeof(XwAlignment);

	switch(*from_str)
	{
		case 'L':
		case 'l':
			if (match = StringsAreEqual(from_str,"left"))
				Align = XwALIGN_LEFT;
		break;
		case 'C':
		case 'c':
			if (match = StringsAreEqual(from_str,"center"))
				Align = XwALIGN_CENTER;
		break;
		case 'R':
		case 'r':
			if (match = StringsAreEqual(from_str,"right"))
				Align = XwALIGN_RIGHT;
		break;
		case 'N':
		case 'n':
			if (match = StringsAreEqual(from_str,"none"))
				Align = XwALIGN_NONE;
		break;
		default:
			match = FALSE;
		break;
	}

	if(!match)
	{
		toVal->addr = NULL;
		toVal->size = 0;
	}
}

static void _XwCvtAlignmentToString (args,num,fromVal,toVal)
	XrmValue	*args;
	Cardinal	num;
	XrmValue	*fromVal;
	XrmValue	*toVal;
{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwALIGN_LEFT:
   default:
	   in_str = "left";
	   break;
   case XwALIGN_CENTER:
	   in_str = "center";
	   break;
   case XwALIGN_RIGHT:
	   in_str = "right";
	   break;
   case XwALIGN_NONE:
	   in_str = "none";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}


/*************************************<->*************************************
 *
 *   static  void _XwCvtStringToWidgetType()
 *		Display	*display;
 *		XrmValue	*p_fromVal;
 *		XrmValue	*toVal;
 *
 *	Description:
 *	-----------
 *		This is a type conversion procedure for the resource manager.
 *		converts strings to type XwWidgetType.  The conversion is case
 *		insensitive.
 *
 *	Inputs:
 *	------
 *		See "Xlib - C Language X Interface Protocol Version 11"
 *
 *	Outputs:
 *	-------
 *		See "Xlib - C Language X Interface Protocol Version 11"
 *
 *	Procedures Called
 *	-----------------
 *		StringsAreEqual
 *
 *************************************<->***********************************/
static void _XwCvtStringToWidgetType(args,num,p_fromVal,toVal)
	XrmValue	*args;
	Cardinal	num;
	XrmValue	*p_fromVal;
	XrmValue	*toVal;
{
	static XwWidgetType	WType = XwUNKNOWN;
	char	*from_str;
	Boolean	match = FALSE;

	from_str = (char *) (p_fromVal->addr);
	toVal->addr = (caddr_t) &WType;
	toVal->size = sizeof(XwWidgetType);

	switch(*from_str)
	{
		case 'T':
		case 't':
			if (match = StringsAreEqual(from_str,"title"))
				WType = XwTITLE;
		break;
		case 'P':
		case 'p':
			if (match = StringsAreEqual(from_str,"pulldown"))
				WType = XwPULLDOWN;
		break;
		case 'W':
		case 'w':
			if (match = StringsAreEqual(from_str,"work space"))
				WType = XwWORK_SPACE;
		break;
		case 'U':
		case 'u':
			if (match = StringsAreEqual(from_str,"unknown"))
				WType = XwUNKNOWN;
		break;
		default:
			match = FALSE;
		break;
	}

	if(!match)
	{
		toVal->addr = NULL;
		toVal->size = 0;
	}
}

static void _XwCvtWidgetTypeToString(args,num,fromVal,toVal)
	XrmValue	*args;
	Cardinal	num;
	XrmValue	*fromVal;
	XrmValue	*toVal;
{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwTITLE:
	   in_str = "title";
	   break;
   case XwPULLDOWN:
	   in_str = "pulldown";
	   break;
   case XwWORK_SPACE:
	   in_str = "work space";
	   break;
   case XwUNKNOWN:
   default:
	   in_str = "unknown";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}


/************************************************************************
 *
 *  _XwCvtStringToLayoutType
 *	Convert a resource string to a layout type.
 *
 ************************************************************************/

static void _XwCvtStringToLayoutType (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwREQUESTED_COLUMNS;

   if (((*in_str) == 'M') || ((*in_str) =='m'))
   {
      if (StringsAreEqual (in_str, "maximum_columns")) i = XwMAXIMUM_COLUMNS;
      else if (StringsAreEqual (in_str, "maximum_unaligned"))
         i = XwMAXIMUM_UNALIGNED;
   }

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtLayoutTypeToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwREQUESTED_COLUMNS:
	   in_str = "requested_columns";
	   break;
   case XwMAXIMUM_COLUMNS:
	   in_str = "maximum_columns";
	   break;
   case XwMAXIMUM_UNALIGNED:
	   in_str = "maximum_unaligned";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}



/************************************************************************
 *
 *  _XwCvtStringToSeparatorType
 *      Convert a resource string to a menu separator type.
 *
 ************************************************************************/

static void _XwCvtStringToSeparatorType (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str = (char *) (fromVal->addr);
   static int i;

   i = XwSINGLE_LINE;

   switch(*in_str)
   {
      case 'D':
      case 'd':
         if (StringsAreEqual (in_str, "double_line")) i = XwDOUBLE_LINE;
         else if (StringsAreEqual (in_str, "double_dashed_line"))
            i = XwDOUBLE_DASHED_LINE;
      break;

      case 'S':
      case 's':
         if (StringsAreEqual (in_str, "single_dashed_line"))
            i = XwSINGLE_DASHED_LINE;
      break;

      case 'N':
      case 'n':
         if (StringsAreEqual (in_str, "no_line")) i = XwNO_LINE;
      break;
   }

   (*toVal).size = sizeof (int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtSeparatorTypeToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwSINGLE_LINE:
   default:
	   in_str = "single_line";
	   break;
   case XwDOUBLE_LINE:
	   in_str = "double_line";
	   break;
   case XwSINGLE_DASHED_LINE:
	   in_str = "single_dashed_line";
	   break;
   case XwNO_LINE:
	   in_str = "NO_line";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

/************************************************************************
 *
 *  _XwCvtStringToGravity
 *      Convert a resource string to a gravity value.
 *
 ************************************************************************/

static void _XwCvtStringToGravity (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
	static int gravity = CenterGravity;
	char	*from_str;
	Boolean	match = FALSE;

	from_str = (char *) (fromVal->addr);
	toVal->addr = (caddr_t) &gravity;
	toVal->size = sizeof(int);

	switch (*from_str)
	{
		case 'N':
		case 'n':
			if (match = StringsAreEqual(from_str,"NorthGravity"))
				gravity = NorthGravity;
			else if (match = StringsAreEqual(from_str,"NorthWestGravity"))
				gravity = NorthWestGravity;
			else if (match = StringsAreEqual(from_str,"NorthEastGravity"))
				gravity = NorthEastGravity;
		break;
		case 'S':
		case 's':
			if (match = StringsAreEqual(from_str,"SouthGravity"))
				gravity = SouthGravity;
			else if (match = StringsAreEqual(from_str,"SouthWestGravity"))
				gravity = SouthWestGravity;
			else if (match = StringsAreEqual(from_str,"SouthEastGravity"))
				gravity = SouthEastGravity;
		break;
		case 'W':
		case 'w':
			if (match = StringsAreEqual(from_str,"WestGravity"))
				gravity = WestGravity;
		break;
		case 'E':
		case 'e':
			if (match = StringsAreEqual(from_str,"EastGravity"))
				gravity = EastGravity;
		break;
		case 'C':
		case 'c':
			if (match = StringsAreEqual(from_str,"CenterGravity"))
				gravity = CenterGravity;
		break;
		default:
			match = FALSE;
		break;
	}

	if(!match)
	{
		toVal->addr = NULL;
		toVal->size = 0;
	}
}

static void _XwCvtGravityToString (args, numArgs, fromVal, toVal)
XrmValue * args;
Cardinal   numArgs;
XrmValue * fromVal;
XrmValue * toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case NorthGravity:
	   in_str = "NorthGravity";
	   break;
   case NorthWestGravity:
	   in_str = "NorthWestGravity";
	   break;
   case NorthEastGravity:
	   in_str = "NorthEastGravity";
	   break;
   case SouthGravity:
	   in_str = "SouthGravity";
	   break;
   case SouthWestGravity:
	   in_str = "SouthWestGravity";
	   break;
   case SouthEastGravity:
	   in_str = "SouthEastGravity";
	   break;
   case WestGravity:
	   in_str = "WestGravity";
	   break;
   case EastGravity:
	   in_str = "EastGravity";
	   break;
   case CenterGravity:
	   in_str = "CenterGravity";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}


static void _XwCvtStringToTitleType (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal  * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   static int i;
   String source = (String) fromVal->addr;

   if (source)
   {
      if (strcmp ("string", source) == 0)
         i = XwSTRING;
      else if (strcmp ("image", source) == 0)
         i = XwIMAGE;
      else
      {
         i = XwSTRING;
         XtWarning (
            "MenuPane: Unknown title type specified; using string title");
      }
   }
   else
   {
      i = XwSTRING;
      XtWarning ("MenuPane: Unknown title type specified; using string title");
   }

   (*toVal).size = sizeof(int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtTitleTypeToString (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal  * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwSTRING:
   default:
	   in_str = "string";
	   break;
   case XwIMAGE:
	   in_str = "image";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

static void _XwCvtStringToLabelType (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal  * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   static int i;

   if (strcmp ("string", (char *) fromVal->addr) == 0)
      i = XwSTRING;
   else if (strcmp ("image", (char *) fromVal->addr) == 0)
      i = XwIMAGE;
   else
   {
      i = XwSTRING;
      XtWarning
	 ("MenuButton: Unknown label type specified; using string label");
   }

   (*toVal).size = sizeof(int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtLabelTypeToString (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal  * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwSTRING:
   default:
	   in_str = "string";
	   break;
   case XwIMAGE:
	   in_str = "image";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}

static void _XwCvtStringToTitlePositionType (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   static int i;
   String source = (char *) fromVal->addr;

   if (source)
   {
      /* Force the comparison to be case insensitive */
      for (i = 0; i < XwStrlen(source); i++)
      {
         if (isupper (source[i]))
            source[i] = tolower(source[i]);
      }

      if (strcmp ("bottom", source) == 0)
         i = XwBOTTOM;
      else if (strcmp ("top", source) == 0)
         i = XwTOP;
      else if (strcmp ("both", source) == 0)
         i = XwTOP | XwBOTTOM;
      else
      {
         i = XwTOP;
         XtWarning ("Cascade: Invalid title position; position set to top");
      }
   }
   else
   {
      i = XwTOP;
      XtWarning ("Cascade: Invalid title position; position set to top");
   }

   (*toVal).size = sizeof(int);
   (*toVal).addr = (caddr_t) &i;
}

static void _XwCvtTitlePositionTypeToString (args, num_args, fromVal, toVal)

   XrmValuePtr args;
   Cardinal * num_args;
   XrmValuePtr fromVal;
   XrmValuePtr toVal;

{
   char * in_str;
   int i = *((int *) fromVal -> addr);

   switch (i)
   {
   case XwBOTTOM:
	   in_str = "bottom";
	   break;
   case XwTOP:
   default:
	   in_str = "top";
	   break;
   case XwTOP | XwBOTTOM:
	   in_str = "both";
	   break;
   }
   (*toVal).addr = (caddr_t) in_str;
   (*toVal).size = strlen (in_str) + 1;
}


/*--------------------------------------------------------------------------+*/
static void SetConverter(fromVal, toVal, setNum)
/*--------------------------------------------------------------------------+*/
     XrmValuePtr fromVal, toVal;
     int setNum;
{
  int j;
  XwSetValuePair *ptr;
  static int value;
  unsigned char *fromstr;

  fromstr = (unsigned char *)fromVal->addr;
  ptr = valuepairsets[setNum];
  for(j=0; *ptr[j].string; j++)
    if ((strcmp(ptr[j].string, fromstr)) == NULL) {
      value = ptr[j].value;
      toVal->size = sizeof(int);
      toVal->addr = (caddr_t)&value;
      return;
    };
  toVal->size = 0;
  toVal->addr = NULL;
}

/*--------------------------------------------------------------------------+*/
static void SetUnConverter(fromVal, toVal, setNum)
/*--------------------------------------------------------------------------+*/
     XrmValuePtr fromVal, toVal;
     int setNum;
{
  int j;
  XwSetValuePair *ptr;
  static int value;
  int from_value = *((int *) fromVal -> addr);

  ptr = valuepairsets[setNum];
  for(j=0; *ptr[j].string; j++)
    if (ptr[j].value == from_value)
    {
	    (*toVal).addr = (caddr_t) ptr[j].string;
	    (*toVal).size = strlen (ptr[j].string) + 1;
	    return;
    };
  toVal->size = 0;
  toVal->addr = NULL;
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToEditMode(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwEditTypeValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtEditModeToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwEditTypeValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToSourceType(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwSourceTypeValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtSourceTypeToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwSourceTypeValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToWrap(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwWrapValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtWrapToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwWrapValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToWrapForm(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwWrapFormValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtWrapFormToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwWrapFormValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToWrapBreak(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwWrapBreakValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtWrapBreakToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwWrapBreakValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToScroll(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwScrollValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtScrollToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwScrollValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtStringToGrow(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetConverter(fromVal, toVal, XwGrowValueSetNum);
}

/*--------------------------------------------------------------------------+*/
static void CvtGrowToString(args, num_args, fromVal, toVal)
/*--------------------------------------------------------------------------+*/
    XrmValuePtr *args;  /* unused */
    Cardinal    *num_args; /* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
  SetUnConverter(fromVal, toVal, XwGrowValueSetNum);
}
#else
static char token_for_the_loaders;
#endif /* HP_WIDGETS */
