static char TMxtops_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/Form.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/Text.h>
#include <Xol/TextField.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/Form.h>
#include <Xw/PButton.h>
#include <Xw/Arrow.h>
#include <Xw/Valuator.h>
#include <Xw/ScrollBar.h>
#include <Xw/SWindow.h>
#include <Xw/SText.h>
#include <Xw/TextEdit.h>
#include <Xw/BBoard.h>
#endif /* HP_WIDGETS */

#include "SMRaster.h"

extern double atof();

#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))
#define LOCAL_BUFSIZ	(256)	    /* largest filename */
#define MAX_IMAGE	(64 * 1024) /* screen chunk size */

/*
 * Command line options data
 */
static XrmOptionDescRec options[] =
{
	{"-mag",   "magnification",        XrmoptionSepArg, NULL},
	{"-m",     "magnification",        XrmoptionSepArg, NULL},
	{"-out",   "output_file",          XrmoptionSepArg, NULL},
	{"-o",     "output_file",          XrmoptionSepArg, NULL},
};

typedef struct
{
	char *magnification;
	char *output_file;
} app_resourceRec, *app_res;

app_resourceRec app_resources;

static XtResource resources[] =
{
	{
		"magnification", "Magnification",
		XtRString, sizeof (String),
		XtOffset (app_res, magnification),
		XtRString, (caddr_t) "1"
	},
	{
		"output_file", "Output_File",
		XtRString, sizeof (String),
		XtOffset (app_res, output_file),
		XtRString, (caddr_t) "out.ps"
	},
};

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static void
Syntax C_P_ARGS((char *call));

extern void
main C_P_ARGS((int argc, char **argv));

static void
AppNewImage C_P_ARGS((Widget w, Widget *closure, caddr_t call_data));

static void
AppNewFile C_P_ARGS((Widget w, caddr_t closure, caddr_t call_data));

static void
AppSaveImage C_P_ARGS((Widget w, Widget *closure, caddr_t call_data));

static void
AppNewMagnification C_P_ARGS((Widget w, Widget *closure, caddr_t call_data));

static void
AppExit C_P_ARGS((Widget w, caddr_t client_data, caddr_t call_data));

static XImage *
CreateImage C_P_ARGS((Display *display, int out_width, int out_height));

static void
PseudoMapToGreyMap C_P_ARGS((XColor *colors, unsigned char *greymap,
			     int size));

static int
ImageToPostScriptFile C_P_ARGS((Display *display, XImage *image,
				Colormap colormap, char *output_file));

C_PROTOS_END_EXTERN

/*
 * Report the syntax
 */
static void
Syntax (call)
char *call;
{
	fprintf (stderr,
		 "%s: usage\n  %s [[-out] <output file name>] [-mag <magnification>]\n",
		 call, call);
	exit (1);
}

void
main (argc, argv)
int argc;
char **argv;
{
	extern void AppNewImage ();
	extern void AppNewFile ();
	extern void AppNewMagnification ();
	extern void AppSaveImage ();
	extern void AppExit ();
	Widget toplevel, form, NewImage, Exitw, sw, SaveImage;
	Widget magnification_title, Magnification, file_title, File;
	Widget MagnifierWidget;
	XtCallbackRec toll_call[2];
	XtTranslations text_trans;
	Arg args[20];
	char buf[32];
	int i;
	XImage *image;
	XColor xch, xce;
	double fmag;
	XrmDatabase db;
#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test",
				 options, XtNumber (options),
				 &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test",
				 options, XtNumber (options),
				 &argc, argv);
#endif /* OPENLOOK */

	XtGetApplicationResources (toplevel, &app_resources,
				   resources, XtNumber (resources),
				   NULL, 0);
	if (argc == 2)
		app_resources.output_file = argv[1];
	else
		if (argc > 1)
			Syntax (argv[0]);

	i = 0;
	XtSetArg (args[i], XtNallowShellResize, True); i++;
	XtSetValues (toplevel, args, i);

	db = XtDatabase(XtDisplay(toplevel));
	XrmPutLineResource (&db, "*font: fixed");

	image = XGetImage (XtDisplay (toplevel),
			   RootWindow (XtDisplay (toplevel),
				       DefaultScreen (XtDisplay (toplevel))),
			   0, 0,
			   64, 64,
			   AllPlanes,
			   (DefaultDepth (XtDisplay (toplevel),
				  DefaultScreen (XtDisplay (toplevel))) > 1) ?
			   ZPixmap : XYPixmap);
	if (image == (XImage *) NULL)
		exit (1);

	if (XAllocNamedColor (XtDisplay (toplevel),
			      DefaultColormap (XtDisplay (toplevel), 0),
			      "blue",
			      &xch, &xce) == FALSE)
		xch.pixel = NULL;

#ifdef OPENLOOK
	form = XtCreateManagedWidget ("form", formWidgetClass,
				      toplevel, NULL, 0);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	form = XtCreateManagedWidget ("form", XwformWidgetClass,
				      toplevel, NULL, 0);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhighlightThickness, 2); i++;
	XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
	if (xch.pixel)
		XtSetArg (args[i], XtNhighlightColor, xch.pixel), i++;
#endif /* HP_WIDGETS */

	XtSetArg (args[i], XtNlabel, "New Image"); i++;
	toll_call[0].callback = (XtCallbackProc) AppNewImage;
	toll_call[0].closure = (caddr_t) &MagnifierWidget;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);

#ifdef OPENLOOK
	NewImage = XtCreateManagedWidget ("NewImage", oblongButtonWidgetClass,
					  form, args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	NewImage = XtCreateManagedWidget ("NewImage", XwpushButtonWidgetClass,
					  form, args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNxAttachRight, TRUE); i++;
	XtSetArg (args[i], XtNxVaryOffset, TRUE); i++;

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhighlightThickness, 2); i++;
	XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
	if (xch.pixel)
		XtSetArg (args[i], XtNhighlightColor, xch.pixel), i++;
#endif /* HP_WIDGETS */

	XtSetArg (args[i], XtNlabel, "Exit"); i++;
	toll_call[0].callback = (XtCallbackProc) AppExit;
	toll_call[0].closure = NULL;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[i], XtNselect, toll_call); i++;

#ifdef OPENLOOK
	Exitw = XtCreateManagedWidget ("Exit", oblongButtonWidgetClass,
				       form, args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	Exitw = XtCreateManagedWidget ("Exit", XwpushButtonWidgetClass,
				       form, args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, NewImage); i++;
	XtSetArg (args[i], XtNyRefWidget, NewImage); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyOffset, 10); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNstring, "Magnification:"); i++;
	XtSetArg (args[i], XtNborderWidth, 0); i++;

#ifdef OPENLOOK
	magnification_title = XtCreateManagedWidget ("magnification_title",
						     staticTextWidgetClass,
						     form,
						     args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	magnification_title = XtCreateManagedWidget ("magnification_title",
						     XwstatictextWidgetClass,
						     form,
						     args, i);
#endif /* HP_WIDGETS */

	fmag = atof (app_resources.magnification);
	if (fmag < 0.0)
		fmag = 1.0;
	if (fmag > 64.0)
		fmag = 64.0;
	if (fmag <= 0.0)
		fmag = 1.0;
	sprintf (buf, "%f", fmag);
	i = strlen (buf);
	if (i)
		i--;
	while (buf[i] == '0')
		buf[i--] = '\0';
	i = 0;
	XtSetArg (args[i], XtNstring, buf); i++;
	XtSetArg (args[i], XtNxRefWidget, magnification_title); i++;
	XtSetArg (args[i], XtNyRefWidget, magnification_title); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNxAddWidth, TRUE); i++;
	XtSetArg (args[i], XtNheight, 30); i++;
	XtSetArg (args[i], XtNwidth, 80); i++;
	XtSetArg (args[i], XtNmaximumSize, 5); i++;
	toll_call[0].callback = (XtCallbackProc) AppNewMagnification;
	toll_call[0].closure = (caddr_t) &MagnifierWidget;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[i], XtNleaveVerification, toll_call); i++;

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhighlightThickness, 2); i++;
	XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
	if (xch.pixel)
		XtSetArg (args[i], XtNhighlightColor, xch.pixel), i++;
#endif /* HP_WIDGETS */

#ifdef OPENLOOK
	Magnification = XtCreateManagedWidget ("Magnification",
					       textFieldWidgetClass,
					       form,
					       args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	Magnification = XtCreateManagedWidget ("Magnification",
					       XwtexteditWidgetClass,
					       form,
					       args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, NewImage); i++;
	XtSetArg (args[i], XtNyRefWidget, Magnification); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyOffset, 10); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNstring, "Output file:"); i++;
	XtSetArg (args[i], XtNborderWidth, 0); i++;
#ifdef OPENLOOK
	file_title = XtCreateManagedWidget ("file_title",
					    staticTextWidgetClass,
					    form,
					    args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	file_title = XtCreateManagedWidget ("file_title",
					    XwstatictextWidgetClass,
					    form,
					    args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, file_title); i++;
	XtSetArg (args[i], XtNyRefWidget, file_title); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNxAddWidth, TRUE); i++;
	XtSetArg (args[i], XtNstring, app_resources.output_file); i++;
	XtSetArg (args[i], XtNheight, 30); i++;
	XtSetArg (args[i], XtNwidth, 120); i++;
	XtSetArg (args[i], XtNmaximumSize, LOCAL_BUFSIZ); i++;
	toll_call[0].callback = (XtCallbackProc) AppNewFile;
	toll_call[0].closure = (caddr_t) NULL;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[i], XtNleaveVerification, toll_call); i++;

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhighlightThickness, 2); i++;
	XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
	if (xch.pixel)
		XtSetArg (args[i], XtNhighlightColor, xch.pixel), i++;
#endif /* HP_WIDGETS */

#ifdef OPENLOOK
	File = XtCreateManagedWidget ("File",
				      textFieldWidgetClass,
				      form,
				      args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	File = XtCreateManagedWidget ("File",
				      XwtexteditWidgetClass,
				      form,
				      args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNyRefWidget, File); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhighlightThickness, 2); i++;
	XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
	if (xch.pixel)
		XtSetArg (args[i], XtNhighlightColor, xch.pixel), i++;
#endif /* HP_WIDGETS */

	XtSetArg (args[i], XtNlabel, "Save Image"); i++;
	toll_call[0].callback = (XtCallbackProc) AppSaveImage;
	toll_call[0].closure = (caddr_t) &MagnifierWidget;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
#ifdef OPENLOOK
	SaveImage = XtCreateManagedWidget ("SaveImage",
					   oblongButtonWidgetClass,
					   form, args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	SaveImage = XtCreateManagedWidget ("SaveImage",
					   XwpushButtonWidgetClass,
					   form, args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNyRefWidget, SaveImage); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNxResizable, TRUE); i++;
	XtSetArg (args[i], XtNyResizable, TRUE); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNxAttachRight, TRUE); i++;
	XtSetArg (args[i], XtNyAttachBottom, TRUE); i++;
	XtSetArg (args[i], XtNwidth, 256); i++;
	XtSetArg (args[i], XtNheight, 256); i++;
#ifdef OPENLOOK
	sw = XtCreateManagedWidget ("window", scrolledWindowWidgetClass,
				    form, args, i);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	sw = XtCreateManagedWidget ("window", XwswindowWidgetClass,
				    form, args, i);
#endif /* HP_WIDGETS */

	i = 0;
	XtSetArg (args[i], XtNxRefWidget, sw); i++;
	XtSetArg (args[i], XtNyRefWidget, sw); i++;
	XtSetArg (args[i], XtNxResizable, TRUE); i++;
	XtSetArg (args[i], XtNyResizable, TRUE); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNxAttachRight, TRUE); i++;
	XtSetArg (args[i], XtNsRimage, image); i++;
	XtSetArg (args[i], XtNsMRmagnification, buf); i++;
	MagnifierWidget = XtCreateManagedWidget ("magnifier",
						 XwsmrasterWidgetClass,
						 sw,
						 args, i);

	XtRealizeWidget (toplevel);

#ifdef OPENLOOK
	text_trans = XtParseTranslationTable (
		        "Ctrl<Key>M:	VerifyString()\n\
	 		 Ctrl<Key>J:	VerifyString()\n\
			 <Key>Return:	VerifyString()\n");
#else
	text_trans = XtParseTranslationTable (
		        "Ctrl<Key>M:	leave() enter()\n\
	 		 Ctrl<Key>J:	leave() enter()\n\
			 <Key>Delete:	delete-previous-character()\n\
			 Ctrl<Key>?:	delete-previous-character()\n\
			 <Key>Return:	leave() enter()\n");
#endif /* OPENLOOK */

	XtOverrideTranslations (Magnification, text_trans);
	XtOverrideTranslations (File, text_trans);

	XtMainLoop ();
}

static void
AppNewImage (w, closure, call_data)
Widget w;
Widget *closure;
caddr_t call_data;
{
	XSizeHints sizehints;
	XRectangle rect;
	XImage *image_out, *image_in;
	char *data_out, *data_in;
	int current_line, lines_per_sample, i;
	char buffer[BUFSIZ + 64];
	Arg arg;
	Display *display = XtDisplay (w);
	int screen = DefaultScreen (display);
	Window root = RootWindow (display, screen);
	Widget MagnifierWidget = *closure;

	sprintf (buffer, "%s: x=%%d y=%%d width=%%d height=%%d",
		 app_resources.output_file);
	sizehints.flags = PSize | PMinSize;
	sizehints.width = sizehints.min_width = 8;
	sizehints.height = sizehints.min_height = 8;
	XGetRect (display, screen, root, &sizehints,
		  buffer, "fixed",
		  FALSE, TRUE, &rect);

	/*
	 * create an XImage large enough to store the entire image
	 */
	image_out = CreateImage (display, (int) rect.width, (int) rect.height);
	if (image_out == NULL)
		exit (1);

	/*
	 * Loop getting parts of the image
	 */
	lines_per_sample = MAX_IMAGE / image_out -> bytes_per_line;
	current_line = 0;
	data_out = image_out -> data;
	for (current_line = 0; current_line < image_out -> height;
	     current_line += lines_per_sample)
	{
		if (current_line + lines_per_sample > image_out -> height)
			lines_per_sample = image_out -> height - current_line;

		image_in = XGetImage (display,
				      RootWindow (display, screen),
				      rect.x,
				      rect.y + current_line,
				      rect.width,
				      lines_per_sample,
				      AllPlanes,
				      image_out -> format);

		data_in = image_in -> data;
		for (i = 0; i < image_in -> height; i++)
		{
			bcopy (data_in, data_out, image_in -> bytes_per_line);
			data_in += image_in -> bytes_per_line;
			data_out += image_out -> bytes_per_line;
		}

		(*image_in -> f.destroy_image) (image_in);
	}
	if (image_out != (XImage *) NULL)
	{
		XtSetArg (arg, XtNsRimage, image_out);
		XtSetValues (MagnifierWidget, &arg, 1);
	}
}

static void
AppNewFile (w, closure, call_data)
Widget w;
caddr_t closure;
caddr_t call_data;
{
	static char buf[LOCAL_BUFSIZ];
	int used;
	int length;
#ifdef OPENLOOK
	OlTextPosition (* textGetLastPos) ();
	int (*textReadSubString) ();
	Arg args[2];
	OlTextPosition pos;

	XtSetArg (args[0], XtNtextGetLastPos, (XtArgVal) &textGetLastPos);
	XtSetArg (args[1], XtNtextReadSubStr, (XtArgVal) &textReadSubString);
	XtGetValues (w, args, 2);

	pos = (*textGetLastPos) (w);
	if (pos < 1)
		return;

	(*textReadSubString) (w, 0, pos, buf, 64, &used);
	buf[pos] = '\0';
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	length = XwTextGetLastPos (w);
	if (length < 1)
		return;

	XwTextReadSubString (w, 0, length, buf, LOCAL_BUFSIZ, &used);
	buf[length] = '\0';
#endif /* HP_WIDGETS */

	app_resources.output_file = buf;
}

static void
AppSaveImage (w, closure, call_data)
Widget w;
Widget *closure;
caddr_t call_data;
{
	Display *display = XtDisplay (w);
	int screen = DefaultScreen (display);
	Arg arg;
	Widget MagnifierWidget = *closure;
	XImage *image;

	XtSetArg (arg, XtNsRimage, &image);
	XtGetValues (MagnifierWidget, &arg, 1);

	ImageToPostScriptFile (display, image,
			       DefaultColormap (display, screen),
			       app_resources.output_file);
}

static void
AppNewMagnification (w, closure, call_data)
Widget w;
Widget *closure;
caddr_t call_data;
{
	Widget MagnifierWidget = *closure;
	double fmag;
	static char buf[64];
	int used;
	int length;
	Arg arg;
#ifdef OPENLOOK
	OlTextPosition (* textGetLastPos) ();
	int (*textReadSubString) ();
	Arg args[2];
	OlTextPosition pos;

	XtSetArg (args[0], XtNtextGetLastPos, (XtArgVal) &textGetLastPos);
	XtSetArg (args[1], XtNtextReadSubStr, (XtArgVal) &textReadSubString);
	XtGetValues (w, args, 2);

	pos = (*textGetLastPos) (w);
	if (pos < 1)
		return;

	(*textReadSubString) (w, 0, pos, buf, 64, &used);
	buf[pos] = '\0';
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	length = XwTextGetLastPos(w);
	if (length < 1)
		return;

	XwTextReadSubString (w, 0, length, buf, 64, &used);
	buf[length] = '\0';
#endif /* HP_WIDGETS */

	fmag = atof (buf);

	if (fmag <= 0.0)
		fmag = 1.0;
	else if (fmag > 64.0)
		fmag = 64.0;

	if (fmag >= 1.0 && fmag <= 64.0)
	{
		used = fmag; /* truncate */
		fmag = used;
	}

	sprintf (buf, "%.2f", fmag);
	XtSetArg (arg, XtNstring, buf);
	XtSetValues (w, &arg, 1);

	if (strcmp (app_resources.magnification, buf) == 0)
		return;

	strcpy (app_resources.magnification, buf);
	XtSetArg (arg, XtNsMRmagnification, buf);
	XtSetValues (MagnifierWidget, &arg, 1);
}

static void
AppExit (w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	exit (0);
}

/*
 * create an image that matches the display
 */
static XImage *
CreateImage (display, out_width, out_height)
Display *display;
int out_width;
int out_height;
{
	XImage *out;
	char *data;
	int screen = DefaultScreen (display);
	int depth = DefaultDepth (display, screen);
	int line_width = ((depth * out_width + 7) / 8); /* bytes per line */
	char *error_message = "Cannot allocate image space.\n";

	if ((data = (char *) malloc (line_width * out_height)) == NULL)
	{
		fprintf (stderr, error_message);
		return ((XImage *) NULL);
	}

	out = XCreateImage (display, DefaultVisual (display, screen),
			    depth,
			    (depth > 1) ? ZPixmap : XYPixmap,
			    0,			       /* offset */
			    data,
			    out_width, out_height,
			    8,			       /* bitmap quantum */
			    line_width);

	if (out == (XImage *) NULL)
	{
		fprintf (stderr, error_message);
		XFree ((char *) data);
		return ((XImage *) NULL);
	}

	return out;
}

static void
PseudoMapToGreyMap (colors, greymap, size)
XColor *colors;
unsigned char *greymap;
int size;
{
	XColor *cptr = colors;
	unsigned char *gptr = greymap;
	unsigned long grey;
	int i;

	for (i = 0; i < size; i++)
	{
		grey = ((cptr -> red >> 8) & 255) * 77 +
			((cptr -> green >> 8) & 255) * 151 +
				((cptr -> blue >> 8) & 255) * 28;
		*gptr++ = grey >> 8;
		cptr++;
	}
}

static char *post_script_uncompress[] =
{
"",
"/image-check-each-character % stack: character",
"{",
"	dup 170 eq % look for AA",
"	{",
"		/image-duplicate-character-flag true def pop",
"	}",
"	{",
"		image-buffer image-character-position 3 -1 roll put",
"		/image-character-position image-character-position 1 add def",
"	} ifelse",
"} def",
"",
"/image-create-run % stack: length",
"{",
"	image-character-position add dup",
"	image-character-position 1 3 -1 roll",
"	{",
"		image-buffer exch image-run-character put",
"	} for",
"	/image-character-position exch def",
"} def",
"",
"/image-recursive-create-run % stack: length",
"{",
"	dup cvi 1 cvi and exch",
"	cvi -1 cvi bitshift dup",
"	3 -1 roll add dup",
"	4 gt",
"	{",
"		image-recursive-create-run",
"	} %else",
"	{",
"		image-create-run",
"	} ifelse",
"	dup dup",
"	image-buffer image-character-position",
"	image-buffer image-character-position 5 -1 roll sub 6 -1 roll",
"	getinterval putinterval",
"	/image-character-position exch image-character-position add def",
"} def",
"",
"/image-read-compressed",
"{",
"	/image-character-position 0 def",
"	currentfile image-read-buffer readhexstring pop",
"	{",
"		image-duplicate-character-flag",
"		{",
"			image-create-run-flag",
"			{",
"				image-recursive-create-run",
"				/image-duplicate-character-flag false def",
"				/image-create-run-flag false def",
"			} % else",
"			{",
"				/image-run-character exch def",
"				/image-create-run-flag true def",
"			} ifelse",
"		} % else",
"		{",
"			image-check-each-character",
"		} ifelse",
"	} forall",
"	% trim unused space from the end of image-buffer",
"	image-buffer 0 image-character-position getinterval",
"} def",
"",
"/image-process % stack: width, height",
"{",
"	/image-depth exch def",
"	/image-height exch def",
"	/image-width exch def",
"",
"	% allocate space for one line of input",
"	/image-read-buffer 36 string def",
"",
"	% must be at least 255 * 36 / 3 bytes",
"	/image-buffer 3072 string def",
"",
"	% flags",
"	/image-duplicate-character-flag false def",
"	/image-create-run-flag false def",
"",
"	% read and dump the image",
"	image-width image-height image-depth",
"		[image-width 0 0 image-height neg 0 image-height]",
"		{ image-read-compressed } image",
"} def",
(char *) NULL
};

#define PRINT_LINE_WIDTH	72

#define PRINT_HEX(fp, char_to_print, byte_count) \
{						 \
	fprintf (fp, "%02x", char_to_print);	 \
	byte_count += 2;			 \
	if (byte_count == PRINT_LINE_WIDTH)	 \
	{					 \
		fprintf (fp, "\n");		 \
		byte_count = 0;			 \
	}					 \
}

#define PRINT_COMPACT(fp, c, last_c, c_count, byte_count)		\
{									\
	if (c_count == 0)						\
	{								\
		c_count = 1;						\
		last_c = c;						\
	}								\
	else if (c == last_c)						\
	{								\
		if (c_count == 255)					\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
			c_count = 1;					\
		}							\
		else							\
			c_count++;					\
	}								\
	else								\
	{								\
		if (last_c == 0xAA || c_count > 3)			\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
		}							\
		else							\
		{							\
			for (c_index = 0; c_index < c_count; c_index++)	\
				PRINT_HEX(fp, last_c, byte_count);	\
		}							\
		c_count = 1;						\
		last_c = c;						\
	}								\
}									\

static int
ImageToPostScriptFile (display, image, colormap, output_file)
Display *display;
XImage *image;
Colormap colormap;
char *output_file;
{
    FILE *fp;
    XColor *colors = (XColor *) NULL;
    unsigned char *greymap;
    int screen = DefaultScreen (display);
    int swap;
    int i, j;
    int width, depth;
    int cmap_size;
    unsigned char *data_ptr;
    long clock;
    double aspect_ratio, pict_x_min, pict_y_min, pict_width, pict_height;
    unsigned char last_c;
    int c_count = 0;
    int byte_count = 0;
    int c_index;
    unsigned char c;
    char **ptr;

    if ((fp = fopen (output_file, "w")) == NULL)
    {
	fprintf (stderr, "Cannot open the file: %s\n", output_file);
	return FALSE;
    }

    switch (image -> depth)
    {
    default:	/* make all pixmaps 8 bits deep */
    case 8:
	cmap_size = 1 << image -> depth;
	greymap = (unsigned char *) XtMalloc (sizeof (XColor) *
					      (cmap_size + cmap_size));
	colors = (XColor *) greymap;
	greymap += (sizeof (XColor) * cmap_size);
	for (i = 0; i < cmap_size; i++)
	    colors[i].pixel = i;
	XQueryColors (display, colormap, colors, cmap_size);
	PseudoMapToGreyMap (colors, greymap, cmap_size);
	width = image -> width;
	depth = 8;
	break;
    case 1:
	width = (image -> width + 7) / 8;
	depth = 1;
	swap = (BlackPixel (display, screen) == 0);
	break;
    }

    fprintf (fp, "%%!\n");
    fprintf (fp, "%%%%Title: %s\n", output_file);
    fprintf (fp, "%%%%Creator: X11 screen dump\n");
    time (&clock);
    fprintf (fp, "%%%%CreationDate: %s", ctime (&clock));
    fprintf (fp, "%%%%BoundingBox: 0 0 %d %d\n",
	     image -> width, image -> height);
    fprintf (fp, "%%%%Pages: (atend)\n");
    fprintf (fp, "%%%%EndComments\n");

    /* center on the page with .5 inch margin - Jonathan Shopiro */
    aspect_ratio = (float) image -> width / (float) image -> height;
    if (aspect_ratio < .75)
    {			/* tall & narrow */
	pict_width = 10 * aspect_ratio;  /* inches */
	pict_height = 10;
	pict_x_min = (8.5 - pict_width) / 2;
	pict_y_min = .5;
    }
    else
    {			/* short & wide */
	pict_width = 7.5;
	pict_height = 7.5 / aspect_ratio;
	pict_x_min = .5;
	pict_y_min = (11 - pict_height) / 2;
    }
    /*
     * centered image translate and scale
     */
    fprintf (fp, "\n");
    fprintf (fp, "%s\n", "%%%");
    fprintf (fp, "%s\n", "%%% centered image");
    fprintf (fp, "%s\n", "%%%");
    fprintf (fp, "%% /inch {72 mul} def\n");
    fprintf (fp, "%% %f inch %f inch translate\n", pict_x_min, pict_y_min);
    fprintf (fp, "%% %f inch %f inch scale\n", pict_width, pict_height);

    /*
     * encapulated image translate and scale
     */
    fprintf (fp, "\n");
    fprintf (fp, "%s\n", "%%%");
    fprintf (fp, "%s\n", "%%% encapsulated image");
    fprintf (fp, "%s\n", "%%%");
    fprintf (fp, "0 0 translate\n");
    fprintf (fp, "%d %d scale\n", image -> width, image -> height);

    /*
     * print out the PostScript de-compression code
     */
    ptr =  post_script_uncompress;
    while (*ptr)
	fprintf (fp, "%s\n", *ptr++);

    /*
     * print out the PostScript command to read in the image data
     */
    fprintf (fp, "\n");
    fprintf (fp, "%d %d %d image-process\n",
	     image -> width, image -> height, depth);

    switch (image -> depth)
    {
    case 8:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		c = greymap[*data_ptr++];
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }

	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;

    case 1:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		if (swap)
		    c =  (*data_ptr++) & 0377;
		else
		    c = ~(*data_ptr++) & 0377;
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }
	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;

    default:
	for (data_ptr = (unsigned char *) image -> data, i = 0;
	     i < image -> height; i++)
	{
	    for (j = 0; j < width; j++)
	    {
		c = greymap[XGetPixel (image, j, i)];
		PRINT_COMPACT(fp, c, last_c, c_count,
			      byte_count);
	    }
	    data_ptr = (unsigned char *) image -> data +
		image -> bytes_per_line * i;
	}
	break;
    }

    if (last_c == 0xAA || c_count > 3)
    {
	PRINT_HEX(fp, 0xAA, byte_count);
	PRINT_HEX(fp, last_c, byte_count);
	PRINT_HEX(fp, c_count, byte_count);
    }
    else
    {
	for (c_index = 0; c_index < c_count; c_index++)
	{
	    PRINT_HEX(fp, last_c, byte_count);
	}
    }
    while (byte_count < PRINT_LINE_WIDTH)
    {
	fprintf (fp, "0");
	byte_count++;
    }

    fprintf (fp, "\nshowpage\n");
    XFree ((char *) colors);
    return (fclose (fp) == 0);
}
