static char TMxnet9_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifdef MOTIF

main ()
{
    printf ("this example has not been converted to Motif\n");
}

#else

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifdef OPENLOOK
#include <X11/Shell.h>
#endif /* OPENLOOK */

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#include <Xol/Form.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/PButton.h>
#include <Xw/Arrow.h>
#include <Xw/Valuator.h>
#include <Xw/ScrollBar.h>
#include <Xw/SWindow.h>
#include <Xw/SText.h>
#include <Xw/TextEdit.h>
#include <Xw/BBoard.h>
#include <Xw/Form.h>
#endif /* HP_WIDGETS */

#ifdef OPENLOOK
#define INITIALIZE		OlInitialize
#define FORMWDG			formWidgetClass
#define PBUTTONWDG		oblongButtonWidgetClass
#define SCROLLEDWINDOWWDG	scrolledWindowWidgetClass
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#define INITIALIZE		XtInitialize
#define FORMWDG			XwformWidgetClass
#define PBUTTONWDG		XwpushButtonWidgetClass
#define SCROLLEDWINDOWWDG	XwswindowWidgetClass
#endif /* HP_WIDGETS */

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
CycleNodes C_P_ARGS((Widget w, NetWidget *net_ptr, caddr_t call_data));

static void
CycleLinks C_P_ARGS((Widget w, NetWidget *net_ptr, caddr_t call_data));

C_PROTOS_END_EXTERN

/*
 * sample main routine for exercising the widgets
 */
void
main (argc, argv)
int argc;
char **argv;
{
	void CycleNodes ();
	void CycleLinks ();
	Arg args[10];
	int i;
	Pixmap background_pixmap;
	Widget toplevel, form, cycle_nodes, cycle_links, scrolledwindow;
	Widget netwidget;
	XtCallbackRec toll_call[2];

	/*
	 * initialize the connection to the server and the toolkit
	 */
	toplevel = INITIALIZE (argv[0], "Test", NULL, 0, &argc, argv);

	/*
	 * install the resource data base conversion machinery
	 */
	netResourcesInitialize ();

#ifdef OPENLOOK
	i = 0;
	XtSetArg (args[i], XtNallowShellResize, False); i++;
	XtSetValues (toplevel, args, i);
#endif /* OPENLOOK */

	/*
	 * create the toplevel form widget - all other widgets are
	 * contained within this widget or its children
	 */
	form = XtCreateManagedWidget ("form", FORMWDG,
				      toplevel, NULL, 0);

	/*
	 * cycle nodes pushbutton
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Cycle Nodes"); i++;
	toll_call[0].callback = (XtCallbackProc) CycleNodes;
	toll_call[0].closure = (caddr_t) &netwidget;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	cycle_nodes = XtCreateManagedWidget ("Cycle_Nodes", PBUTTONWDG,
					     form, args, i);

	/*
	 * cycle links pushbutton
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, cycle_nodes); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Cycle Links"); i++;
	toll_call[0].callback = (XtCallbackProc) CycleLinks;
	toll_call[0].closure = (caddr_t) &netwidget;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	cycle_links = XtCreateManagedWidget ("Cycle_Links", PBUTTONWDG,
					     form, args, i);

	/*
	 * scrolled window for handling a network widget
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 185); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNrecomputeWidth, FALSE); i++;
	XtSetArg (args[i], XtNrecomputeHeight, FALSE); i++;
#endif /* OPENLOOK */
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						SCROLLEDWINDOWWDG,
						form, args, i);
#ifdef OPENLOOK
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

	/*
	 * create a background pixmap for filled nodes
	 */
	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	/*
	 * create the network widget
	 */
	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;

	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	/*
	 * realize the widgets
	 */
	XtRealizeWidget (toplevel);

	/*
	 * run the widgets
	 */
	XtMainLoop ();
}

/*
 * Callbacks for the push buttons
 */
static void
CycleNodes (w, net_ptr, call_data)
Widget w;
NetWidget *net_ptr;
caddr_t call_data;
{
	XrmDatabase db = XtDatabase(XtDisplay(w));
	Arg args[8];
	NetWidget netwidget = *net_ptr;
	XrmValue from_value, to_value;
	netNode *node;
	static int state = 0;

	switch (state)
	{
	case 0:			/* add */
	case 2:
		state++;
		printf ("add\n");
		from_value.addr = "resource:list.nodes";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		to_value.addr = (char *) NULL;
		to_value.size = 0;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetNodeAddArray, &to_value);
		if (to_value.size != sizeof (netNodePtr))
			return;
		node = *((netNodePtr *) to_value.addr);
		XtSetArg (args[0], XtNnetAddNodes, node);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 1:			/* remove */
		state = 2;
		printf ("remove\n");
		from_value.addr = "resource:list.nodes";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		to_value.addr = (char *) NULL;
		to_value.size = 0;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetNodeRemoveArray, &to_value);
		if (to_value.size != sizeof (netNodePtr))
			return;
		node = *((netNodePtr *) to_value.addr);
		XtSetArg (args[0], XtNnetRemoveNodes, node);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 3:			/* update 1 */
		state = 4;
		printf ("update 1\n");
		XrmPutLineResource (&db,
				    "b.type: symbolislabel");
		XrmPutLineResource (&db,
				    "b.symbolLabel: attr");
		from_value.addr = "b";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		to_value.addr = (char *) NULL;
		to_value.size = 0;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetNodeUpdateArray, &to_value);
		if (to_value.size != sizeof (netNodePtr))
			return;
		node = *((netNodePtr *) to_value.addr);
		XtSetArg (args[0], XtNnetUpdateNodes, node);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 4:			/* update  2 */
		state = 1;
		printf ("update 2\n");
		XrmPutLineResource (&db,
				    "b.type:");
		XrmPutLineResource (&db,
				    "b.x: 0.0");
		from_value.addr = "b";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		to_value.addr = (char *) NULL;
		to_value.size = 0;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetNodeUpdateArray, &to_value);
		if (to_value.size != sizeof (netNodePtr))
			return;
		node = *((netNodePtr *) to_value.addr);
		XtSetArg (args[0], XtNnetUpdateNodes, node);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	}
}

static void
CycleLinks (w, net_ptr, call_data)
Widget w;
NetWidget *net_ptr;
caddr_t call_data;
{
	XrmDatabase db = XtDatabase(XtDisplay(w));
	Arg args[8];
	NetWidget netwidget = *net_ptr;
	XrmValue from_value, to_value;
	netLink *link;
	static int state = 0;

	switch (state)
	{
	case 0:			/* add */
	case 2:
		state++;
		printf ("add\n");
		from_value.addr = "resource:some.links";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetLinkAddArray, &to_value);
		if (to_value.size != sizeof (netLinkPtr))
			return;
		link = *((netLinkPtr *) to_value.addr);
		XtSetArg (args[0], XtNnetAddLinks, link);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 1:			/* remove */
		state = 2;
		printf ("remove\n");
		from_value.addr = "resource:some.links";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetLinkRemoveArray, &to_value);
		if (to_value.size != sizeof (netLinkPtr))
			return;
		link = *((netLinkPtr *) to_value.addr);
		XtSetArg (args[0], XtNnetRemoveLinks, link);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 3:			/* update 1 */
		state = 4;
		printf ("update 1\n");
		XrmPutLineResource (&db,
				    "l.bc.type: linkisline");
		XrmPutLineResource (&db,
				    "l.bc.line: attr");
		from_value.addr = "l.bc";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetLinkUpdateArray, &to_value);
		if (to_value.size != sizeof (netLinkPtr))
			return;
		link = *((netLinkPtr *) to_value.addr);
		XtSetArg (args[0], XtNnetUpdateLinks, link);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	case 4:			/* update  2 */
		state = 1;
		printf ("update 2\n");
		XrmPutLineResource (&db,
				    "l.bc.type:");
		from_value.addr = "l.bc";
		from_value.size = strlen ((char *) from_value.addr) + 1;
		XtConvert ((Widget) netwidget,
			   XtRString, &from_value,
			   XtRNetLinkUpdateArray, &to_value);
		if (to_value.size != sizeof (netLinkPtr))
			return;
		link = *((netLinkPtr *) to_value.addr);
		XtSetArg (args[0], XtNnetUpdateLinks, link);
		XtSetValues ((Widget) netwidget, args, 1);
		break;
	}
}

#endif /* ! MOTIF */
