static char TMxnet8_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifdef MOTIF

main ()
{
    printf ("this example has not been converted to Motif\n");
}

#else

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#ifdef XIPC_TEST
#include "../../../xtent/lib/xtent.h"
#endif /* XIPC_TEST */

#ifdef OPENLOOK
#include <X11/Shell.h>
#endif /* OPENLOOK */

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#include <Xol/Form.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/PButton.h>
#include <Xw/Arrow.h>
#include <Xw/Valuator.h>
#include <Xw/ScrollBar.h>
#include <Xw/SWindow.h>
#include <Xw/SText.h>
#include <Xw/TextEdit.h>
#include <Xw/BBoard.h>
#include <Xw/Form.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#endif /* MOTIF */

#ifdef OPENLOOK
#define INITIALIZE		OlInitialize
#define FORMWDG			formWidgetClass
#define PBUTTONWDG		oblongButtonWidgetClass
#define SCROLLEDWINDOWWDG	scrolledWindowWidgetClass
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#define INITIALIZE		XtInitialize
#define FORMWDG			XwformWidgetClass
#define PBUTTONWDG		XwpushButtonWidgetClass
#define SCROLLEDWINDOWWDG	XwswindowWidgetClass
#endif /* HP_WIDGETS */

#ifdef MOTIF
#define INITIALIZE		XtInitialize
#define FORMWDG			xmFormWidgetClass
#define PBUTTONWDG		xmPushButtonWidgetClass
#define SCROLLEDWINDOWWDG	xmScrolledWindowWidgetClass
#endif /* MOTIF */

#include "Net.h"
#include "NetP.h"

/*
 * node to node hash table constants
 */
#define HASH_BIT_COUNT		(6) /* 2^n hash buckets */
#define HASH_TABLE_SIZE		(1 << HASH_BIT_COUNT)
#define HASH_TABLE_MASK		(HASH_TABLE_SIZE - 1)

/*
 * hash function - assume that malloc'ed nodes are word aligned
 */
#define HASH_FUNCTION(x)	(((int) (x) >> 2) & HASH_TABLE_MASK)

/*
 * structure for keeping track of nodes in the two widgets
 */
typedef struct netNodePair
{
	netNode *orig;
	netNode *copy;
	struct netNodePair *new_hash_next;
	struct netNodePair *old_hash_next;
} netNodePair;

/*
 * the structure for managing all birds eye related data
 */
typedef struct
{
	netNode *top_node;
	netNodePair *node_pairs;
	int node_pairs_count;
	netNodePair *new_hash_table[HASH_TABLE_SIZE];
	netNodePair *old_hash_table[HASH_TABLE_SIZE];
	Widget netwidget;
	Widget scrolledwindow;
	Widget birdseye;
} BirdsEyeData;

/*
 * zoom options
 */
#define ZOOM_IN		1
#define ZOOM_OUT	2

/*
 * birds eye related functions - contained at the end of this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
BirdsEyeZoomInCB C_P_ARGS((Widget w, BirdsEyeData **closure,
			   caddr_t call_data));

static void
BirdsEyeZoomOutCB C_P_ARGS((Widget w, BirdsEyeData **closure,
			    caddr_t call_data));

static void
BirdsEyeZoom C_P_ARGS((BirdsEyeData *birdseye, int zoom_direction,
		       int zoom_factor));

static void
BirdsEyeSize C_P_ARGS((Widget scrolledwindow, Widget netwidget,
		       double *fwidth, double *fheight));

static void
BirdsEyeXY C_P_ARGS((Widget netwidget, double *fx, double *fy));

static netNode *
BirdsEyeFindMatchingNewNode C_P_ARGS((BirdsEyeData *birdseye, netNode *node));

static netNode *
BirdsEyeFindMatchingOldNode C_P_ARGS((BirdsEyeData *birdseye, netNode *node));

static void
BirdsEyeCopyNodes C_P_ARGS((BirdsEyeData *birdseye, netNode *old_nodelist));

static BirdsEyeData *
BirdsEyeCreate C_P_ARGS((char *birdseye_name, Widget birdseye_parent,
			 Arg *initial_args, int initial_args_length,
			 Widget netwidget, Widget scrolledwindow,
			 int width, int height));

static void
BirdsEyeAddCallbacks C_P_ARGS((BirdsEyeData *birdseye));

static void
BirdsEyeScrollbarCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			      caddr_t call_data));

static void
BirdsEyeUpdateCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			   NetCallbackData *data));

static void
BirdsEyeDragCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			 NetCallbackData *data));

static void
BirdsEyeChangeNames C_P_ARGS((BirdsEyeData *birdseye, int type,
			      char *title_name, char *symbol_name));

static Pixel
BirdsEyeGetPixel C_P_ARGS((Widget w, char *str));

static NetDrawProc
BirdsEyeNode C_P_ARGS((int type, Widget w, netNode *node,
		       Drawable d, int xor, netXSRectangle *clip_rect));

C_PROTOS_END_EXTERN

/*
 * sample main routine for exercising the widgets
 */
void
main (argc, argv)
int argc;
char **argv;
{
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Pixmap background_pixmap;
	netMapPolygon *maps;
	BirdsEyeData *birdseye;
	Widget toplevel, form, zoomin, zoomout, scrolledwindow, netwidget;
	XtCallbackRec toll_call[2];
	int depth;

	/*
	 * initialize the connection to the server and the toolkit
	 */
	toplevel = INITIALIZE (argv[0], "Test", NULL, 0, &argc, argv);

#ifdef OPENLOOK
	i = 0;
	XtSetArg (args[i], XtNallowShellResize, False); i++;
	XtSetValues (toplevel, args, i);
#endif /* OPENLOOK */

	depth = XDefaultDepth (XtDisplay (toplevel),
			       DefaultScreen (XtDisplay (toplevel)));

	/*
	 * create the toplevel form widget - all other widgets are
	 * contained within this widget or its children
	 */
	form = XtCreateManagedWidget ("form", FORMWDG,
				      toplevel, NULL, 0);

	/*
	 * zoom in push button
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Zoom In"); i++;
	toll_call[0].callback = (XtCallbackProc) BirdsEyeZoomInCB;
	toll_call[0].closure = (caddr_t) &birdseye;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	zoomin = XtCreateManagedWidget ("ZoomIn", PBUTTONWDG,
					form, args, i);

	/*
	 * zoom out push button
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, zoomin); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Zoom Out"); i++;
	toll_call[0].callback = (XtCallbackProc) BirdsEyeZoomOutCB;
	toll_call[0].closure = (caddr_t) &birdseye;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	zoomout = XtCreateManagedWidget ("ZoomOut", PBUTTONWDG,
					 form, args, i);

	/*
	 * scrolled window for handling a network widget
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 185); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNrecomputeWidth, FALSE); i++;
	XtSetArg (args[i], XtNrecomputeHeight, FALSE); i++;
#endif /* OPENLOOK */
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						SCROLLEDWINDOWWDG,
						form, args, i);
#ifdef OPENLOOK
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

	/*
	 * create a list of nodes and links
	 */
	nodes[0].type = NETBOXSYMBOL;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = (char *) NULL;
	nodes[0].symbol.name = "1";
	nodes[0].next = &nodes[1];

	nodes[1].type = NETBOXSYMBOL;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = (char *) NULL;
	nodes[1].symbol.name = "1.1";
	nodes[1].next = &nodes[2];

	nodes[2].type = NETBOXSYMBOL;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = (char *) NULL;
	nodes[2].symbol.name = "1.2";
	nodes[2].next = &nodes[3];

	nodes[3].type = NETBOXSYMBOL;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = (char *) NULL;
	nodes[3].symbol.name = "1.1.1";
	nodes[3].next = &nodes[4];

	nodes[4].type = NETBOXSYMBOL;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = (char *) NULL;
	nodes[4].symbol.name = "1.1.2";
	nodes[4].next = &nodes[5];

	nodes[5].type = NETBOXSYMBOL;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "1.1.2.1";
	nodes[5].next = (netNode *) NULL;

	links[0].type = 0;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = &links[1];

	links[1].type = 0;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = &links[2];

	links[2].type = 0;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = &links[3];

	links[3].type = 0;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = &links[4];

	links[4].type = 0;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	/*
	 * create a background pixmap for filled nodes
	 */
	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	/*
	 * create the network widget
	 */
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;

	if (depth > 1)
	{
		if (SetupPolygons ("map.list", &maps) == FALSE)
		{
			XtWarning ("Cannot allocate polygons.");
		}
		else
		{
			XtSetArg (args[i], XtNnetMapPolygons, maps);
			i++;
		}
	}
#ifdef DO_BITMAP
	{
		int width, height;
		Pixmap bitmap;
		int x_hot, y_hot;
		XImage *image;
		Display *display = XtDisplay (toplevel);
		
		if (XReadBitmapFile (display,
				     RootWindow (display,
						 DefaultScreen (display)),
				     "backbitmap.x",
				     &width, &height, &bitmap,
				     &x_hot, &y_hot) ==
		    BitmapSuccess)
		{
			image = XGetImage (display, bitmap,
					   0, 0, width, height,
					   1, XYPixmap);
			
			XtSetArg (args[i], XtNnetImage, image); i++;
			XFreePixmap (display, bitmap);
		}
		else
		{
			XtWarning ("Cannot read the bitmap file: backbitmap.x");
		}
	}
#endif
	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	/*
	 * create a birds eye of the network widget created above
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 15); i++;
	XtSetArg (args[i], XtNyRefWidget, zoomout); i++;
	XtSetArg (args[i], XtNyOffset, 10); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, FALSE), i++;
	birdseye = BirdsEyeCreate ("BirdsEye", form, args, i,
				   netwidget, scrolledwindow, 150, 150);

	/*
	 * change the title and symbol names of all of the nodes
	 */
	BirdsEyeChangeNames (birdseye, 0, (char *) NULL, "*");

	/*
	 * realize the widgets
	 */
	XtRealizeWidget (toplevel);

	/*
	 * zoom in on the network widget - the widgets must be realized
	 * prior to making this call
	 */
	BirdsEyeZoom (birdseye, ZOOM_IN, 4);

#ifdef XIPC_TEST
	XtentInitializeForXIpcHandler (argc, argv);
	XtAddXIpc (toplevel, getenv ("XIPC"), XtentHandleIpcToClient);
#endif /* XIPC_TEST */

	/*
	 * run the widgets
	 */
	XtMainLoop ();
}

/*
 * Callbacks for the zoom in and zoom out push buttons
 */
static void
BirdsEyeZoomInCB (w, closure, call_data)
Widget w;
BirdsEyeData **closure;
caddr_t call_data;
{
	BirdsEyeZoom (*closure, ZOOM_IN, 2);
}

static void
BirdsEyeZoomOutCB (w, closure, call_data)
Widget w;
BirdsEyeData **closure;
caddr_t call_data;
{
	BirdsEyeZoom (*closure, ZOOM_OUT, 2);
}

/*
 * function for zooming the network widget.  This function keeps the
 * birds eye in sync with the "zoomed" network widget.
 */
static void
BirdsEyeZoom (birdseye, zoom_direction, zoom_factor)
BirdsEyeData *birdseye;
int zoom_direction;
int zoom_factor;
{
	int i;
	Arg args[16];
	Position x, y;
	Dimension width, height;
#ifdef OPENLOOK
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */
	netNode node;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (birdseye -> scrolledwindow, args, i);
	hextent /= 2;
	vextent /= 2;

	i = 0;
	XtSetArg (args[i], XtNx, &x); i++;
	XtSetArg (args[i], XtNy, &y); i++;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (birdseye -> netwidget, args, i);

	switch (zoom_direction)
	{
	case ZOOM_IN:
		width = width * zoom_factor;
		height = height * zoom_factor;
		if (width > 16384 || height > 16384)
		{
		XtWarning ("Cannot zoom scrolled windows larger than 16384.");
			return;
		}
		i = 0;
		XtSetArg (args[i], XtNwidth, width); i++;
		XtSetArg (args[i], XtNheight, height); i++;
		XtSetValues (birdseye -> netwidget, args, i);

		x = (abs (x) + hextent) * zoom_factor - hextent;
		y = (abs (y) + vextent) * zoom_factor - vextent;

		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;

#ifdef OPENLOOK
		XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */
		break;

	case ZOOM_OUT:
		if (width > zoom_factor)
			x = (abs (x) + hextent) / zoom_factor - hextent;
		if (height > zoom_factor)
			y = (abs (y) + vextent) / zoom_factor - vextent;

		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;
#ifdef OPENLOOK
		XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */

		i = 0;
		if (width > zoom_factor)
		{
			width /= zoom_factor;
			XtSetArg (args[i], XtNwidth, width); i++;
		}
		if (height > zoom_factor)
		{
			height /= zoom_factor;
			XtSetArg (args[i], XtNheight, height);
			i++;
		}
		if (i)
			XtSetValues (birdseye -> netwidget, args, i);
	}

	node = *birdseye -> top_node;
	if (x <= 0)
		node.pf.x = 0.0;
	else
		node.pf.x = (double) x / (double) width;
	if (y <= 0)
		node.pf.y = 1.0;
	else
		node.pf.y =  1.0 - (double) y / (double) height;
	netUpdateNode ((NetWidget) birdseye -> birdseye, &node, birdseye -> top_node);
}

/*
 * get the width and height in unit square dimensions
 */
static void
BirdsEyeSize (scrolledwindow, netwidget, fwidth, fheight)
Widget scrolledwindow, netwidget;
double *fwidth, *fheight;
{
	int i;
	Arg args[16];
#ifdef OPENLOOK
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */
	Dimension width, height;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (scrolledwindow, args, i);

	i = 0;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (netwidget, args, i);

	*fwidth = (vextent ? (((double) vextent) / ((double) width)) : 0.0);
	*fheight = (hextent ? (((double) hextent) / ((double) height)) : 0.0);
}

/*
 * get the X and Y position of the network widget within the scrolled
 * window in unit square dimensions.
 */
static void
BirdsEyeXY (netwidget, fx, fy)
Widget netwidget;
double *fx, *fy;
{
	int i;
	Arg args[16];
	Position x, y;
	Dimension width, height;

	i = 0;
	XtSetArg (args[i], XtNx, &x); i++;
	XtSetArg (args[i], XtNy, &y); i++;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (netwidget, args, i);

	if (x >= 0)
		*fx = 0.0;
	else
		*fx = (double) -x / (double) width;
	if (y >= 0)
		*fy = 1.0;
	else
		*fy =  1.0 + (double) y / (double) height;
}

/*
 * find the new node that matches the specified old node
 */
static netNode *
BirdsEyeFindMatchingNewNode (birdseye, node)
BirdsEyeData *birdseye;
register netNode *node;
{
	netNodePair *node_pairs_ptr;

	node_pairs_ptr = birdseye -> old_hash_table[HASH_FUNCTION (node)];
	while (node_pairs_ptr)
	{
		if (node_pairs_ptr -> orig == node)
			return node_pairs_ptr -> copy;
		node_pairs_ptr = node_pairs_ptr -> old_hash_next;
	}
	return node;		/* should not happen */
}

/*
 * find the old node that matches the specified new node
 */
static netNode *
BirdsEyeFindMatchingOldNode (birdseye, node)
BirdsEyeData *birdseye;
register netNode *node;
{
	netNodePair *node_pairs_ptr;

	node_pairs_ptr = birdseye -> new_hash_table[HASH_FUNCTION (node)];
	while (node_pairs_ptr)
	{
		if (node_pairs_ptr -> copy == node)
			return node_pairs_ptr -> orig;
		node_pairs_ptr = node_pairs_ptr -> new_hash_next;
	}
	return node;		/* should not happen */
}

/*
 * make a copy of the node list from the network widget.  The top
 * node is the new birds eye node that displays the position of the
 * network widget within the scrolled window widget.
 *
 * this functions stores the birds eye structure in the top nodes
 * application pointer so that it will be available in the
 * BirdsEyeNode() function.
 */
static void
BirdsEyeCopyNodes (birdseye, old_nodelist)
BirdsEyeData *birdseye;
netNode *old_nodelist;
{
	netNode *top_node = (netNode *) NULL;
	netNode *last_node;
	netNode *node;
	netNodePair *node_pairs;
	netNodePair *node_pairs_ptr;
	int node_pairs_count = 0;
	int hash_index;

	if (old_nodelist)
	{
		node = old_nodelist;
		while (node)
		{
			node = node -> next;
			node_pairs_count++;
		}
		node_pairs = (netNodePair *) XtMalloc (sizeof (netNodePair) *
						    node_pairs_count);
		node_pairs_ptr = node_pairs;

		while (old_nodelist)
		{
			node = (netNode *) XtMalloc (sizeof (netNode));
			if (top_node == (netNode *) NULL)
				top_node = node;
			else
				last_node -> next = node;

			last_node = node;
			*node = *old_nodelist;
			if (node -> type & NETTITLEISLABEL)
			{
				node -> title.label = (netLabel *)
					XtMalloc (sizeof (netLabel));
				*node -> title.label =
					*old_nodelist -> title.label;
			}
			else
				node -> title = old_nodelist -> title;
			
			if (node -> type & NETSYMBOLISLABEL)
			{
				node -> symbol.label = (netLabel *)
					XtMalloc (sizeof (netLabel));
				*node -> symbol.label =
					*old_nodelist -> symbol.label;
			}
			else
				node -> symbol = old_nodelist -> symbol;
			
			node_pairs_ptr -> orig = old_nodelist;
			node_pairs_ptr -> copy = node;
			hash_index = HASH_FUNCTION (node);
			node_pairs_ptr -> new_hash_next =
				birdseye -> new_hash_table[hash_index];
			birdseye -> new_hash_table[hash_index] =
				node_pairs_ptr;
			hash_index = HASH_FUNCTION (old_nodelist);
			node_pairs_ptr -> old_hash_next =
				birdseye -> old_hash_table[hash_index];
			birdseye -> old_hash_table[hash_index] =
				node_pairs_ptr;
			node_pairs_ptr++;
			old_nodelist = old_nodelist -> next;
		}
	}
	else
		node_pairs = (netNodePair *) NULL;

	node = (netNode *) XtMalloc (sizeof (netNode));
	bzero (node, sizeof (netNode));
	node -> type = NETSYMBOLISPROC;
	node -> symbol.draw_proc = BirdsEyeNode;
	node -> title.name = (char *) NULL;
	node -> pf.x = 0.0;
	node -> pf.y = 1.0;
	if (top_node)
		node -> next = top_node;
	else
		node -> next = (netNode *) NULL;

	birdseye -> top_node = node;
	birdseye -> node_pairs = node_pairs;
	birdseye -> node_pairs_count = node_pairs_count;

	/*
	 * store the birds eye structure in the application pointer so
	 * that it will be available in the BirdsEyeNode() function
	 */
	node -> application_ptr = (caddr_t) birdseye;
}

/*
 * create a birds eye for a network widget.
 */
static BirdsEyeData *
BirdsEyeCreate (birdseye_name, birdseye_parent,
		initial_args, initial_args_length,
		netwidget, scrolledwindow, width, height)
char *birdseye_name;
Widget birdseye_parent;
Arg *initial_args;
int initial_args_length;
Widget netwidget;
Widget scrolledwindow;
int width;
int height;
{
	Pixel old_symbolforeground;
	Pixel old_titleforeground;
	Pixel old_linkforeground;
	XFontStruct *old_symbolfont;
	XFontStruct *old_titlefont;
	netNode *old_nodelist;
	netLink *old_linklist;
	netMapPolygon *old_mappolygons;
	Boolean old_polygonsAsLines;
	int old_thSpace;
	int old_tvSpace;
	int old_shSpace;
	int old_svSpace;
	Boolean old_drawsymbolbackground;
	Pixmap old_symbolbackgroundPixmap;
	Boolean old_drawtitlebackground;
	Pixmap old_titlebackgroundPixmap;
	XImage *old_image;
	netNode *old_allnodes;
	netLink *old_alllinks;
	int i, j;
	Arg *args;
	BirdsEyeData *birdseye;

	/*
	 * check that we have the correct widget types
	 */
	if (XtClass (netwidget) != netWidgetClass)
	{
XtWarning ("BirdsEyeCreate: The specified widget is not a network widget.");
		return (BirdsEyeData *) NULL;
	}
	if (XtClass (scrolledwindow) != SCROLLEDWINDOWWDG)
	{
XtWarning ("BirdsEyeCreate: The specified widget is not contained within a scrolling window widget.");
		return (BirdsEyeData *) NULL;
	}

	/*
	 * allocate the return structure
	 */
	birdseye = (BirdsEyeData *) XtMalloc (sizeof (BirdsEyeData));
	bzero (birdseye, sizeof (BirdsEyeData));
	birdseye -> netwidget = netwidget;
	birdseye -> scrolledwindow = scrolledwindow;

	/*
	 * allocate the widget creation argument structure
	 */
	args = (Arg *) XtMalloc (sizeof (Arg) * (initial_args_length + 32));

	/*
	 * get a copy of the network widget data
	 */
	i = 0;
	XtSetArg (args[i], XtNnetSymbolForeground, &old_symbolforeground); i++;
	XtSetArg (args[i], XtNnetTitleForeground, &old_titleforeground); i++;
	XtSetArg (args[i], XtNnetLinkForeground, &old_linkforeground); i++;
	XtSetArg (args[i], XtNnetSymbolFont, &old_symbolfont); i++;
	XtSetArg (args[i], XtNnetTitleFont, &old_titlefont); i++;
	XtSetArg (args[i], XtNnetNodeList, &old_nodelist); i++;
	XtSetArg (args[i], XtNnetLinkList, &old_linklist); i++;
	XtSetArg (args[i], XtNnetMapPolygons, &old_mappolygons); i++;
	XtSetArg (args[i], XtNnetPolygonsAsLines, &old_polygonsAsLines); i++;
	XtSetArg (args[i], XtNnetTitleHorizSpace, &old_thSpace); i++;
	XtSetArg (args[i], XtNnetTitleVertSpace, &old_tvSpace); i++;
	XtSetArg (args[i], XtNnetSymbolHorizSpace, &old_shSpace); i++;
	XtSetArg (args[i], XtNnetSymbolVertSpace, &old_svSpace); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground,
		  &old_drawsymbolbackground); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  &old_symbolbackgroundPixmap); i++;
	XtSetArg (args[i], XtNnetDrawTitleBackground,
		  &old_drawtitlebackground); i++;
	XtSetArg (args[i], XtNnetTitleBackgroundPixmap,
		  &old_titlebackgroundPixmap); i++;
	XtSetArg (args[i], XtNnetImage, &old_image); i++;
	XtSetArg (args[i], XtNnetAllNodes, &old_allnodes); i++;
	XtSetArg (args[i], XtNnetAllLinks, &old_alllinks); i++;
	XtGetValues (netwidget, args, i);

	/*
	 * create an argument list containing the correct bits - only
	 * copy in the ones that matter.
	 */
	i = 0;
	if (old_symbolforeground)
	{
		XtSetArg (args[i], XtNnetSymbolForeground, old_symbolforeground);
		i++;
	}

	if (old_titleforeground)
	{
		XtSetArg (args[i], XtNnetTitleForeground, old_titleforeground);
		i++;
	}

	if (old_linkforeground)
	{
		XtSetArg (args[i], XtNnetLinkForeground, old_linkforeground);
		i++;
	}

	if (old_symbolfont)
	{
		XtSetArg (args[i], XtNnetSymbolFont, old_symbolfont);
		i++;
	}

	if (old_titlefont)
	{
		XtSetArg (args[i], XtNnetTitleFont, old_titlefont);
		i++;
	}

	BirdsEyeCopyNodes (birdseye,
			   (old_nodelist ? old_nodelist : old_allnodes));
	XtSetArg (args[i], XtNnetNodeList, birdseye -> top_node); i++;

	if (old_linklist || old_alllinks)
	{
		netLink *top_link = (netLink *) NULL;
		netLink *last_link = (netLink *) NULL;
		netLink *link;

		if (old_linklist == (netLink *) NULL)
			old_linklist = old_alllinks;

		while (old_linklist)
		{
			link = (netLink *) XtMalloc (sizeof (netLink));
			if (top_link == (netLink *) NULL)
				top_link = link;
			else
				last_link -> next = link;
			last_link = link;
			*link = *old_linklist;
			link -> A = BirdsEyeFindMatchingNewNode (birdseye,
								 link -> A);
			link -> B = BirdsEyeFindMatchingNewNode (birdseye,
								 link -> B);
			if (link -> type & NETLINKISLINE)
			{
				link -> line.line = (netLine *)
					XtMalloc (sizeof (netLine));
				*link -> line.line =
					*old_linklist -> line.line;
			}
			else
				link -> line = old_linklist -> line;

			old_linklist = old_linklist -> next;
		}
		if (last_link)
		{
			last_link -> next = (netLink *) NULL;
			XtSetArg (args[i], XtNnetLinkList, top_link);
			i++;
		}
	}

	if (old_mappolygons)
	{
		netMapPolygon *top_mappolygon = (netMapPolygon *) NULL;
		netMapPolygon *last_mappolygon = (netMapPolygon *) NULL;
		netMapPolygon *mappolygon;

		while (old_mappolygons)
		{
			mappolygon = (netMapPolygon *)
				XtMalloc (sizeof (netMapPolygon));
			if (top_mappolygon == (netMapPolygon *) NULL)
				top_mappolygon = mappolygon;
			else
				last_mappolygon -> next = mappolygon;
			last_mappolygon = mappolygon;
			*mappolygon = *old_mappolygons;
			mappolygon -> points = (netXFPoint *)
				XtMalloc (sizeof (netXFPoint) *
					  mappolygon -> npoints);
			mappolygon -> p = (XPoint *)
				XtMalloc (sizeof (XPoint) *
					  mappolygon -> npoints);
			bcopy (old_mappolygons -> points, mappolygon -> points,
			       sizeof (netXFPoint) * mappolygon -> npoints);
			old_mappolygons = old_mappolygons -> next;
		}
		if (last_mappolygon)
		{
			last_mappolygon -> next = (netMapPolygon *) NULL;
			XtSetArg (args[i], XtNnetMapPolygons, top_mappolygon);
			i++;
		}
	}

	XtSetArg (args[i], XtNnetPolygonsAsLines, old_polygonsAsLines); i++;

	XtSetArg (args[i], XtNnetTitleHorizSpace, old_thSpace); i++;
	XtSetArg (args[i], XtNnetTitleVertSpace, old_tvSpace); i++;
	XtSetArg (args[i], XtNnetSymbolHorizSpace, old_shSpace); i++;
	XtSetArg (args[i], XtNnetSymbolVertSpace, old_svSpace); i++;

	XtSetArg (args[i], XtNnetDrawSymbolBackground, 
		  old_drawsymbolbackground); i++;

	if (old_symbolbackgroundPixmap)
	{
		XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
			  old_symbolbackgroundPixmap);
		i++;
	}

	XtSetArg (args[i], XtNnetDrawTitleBackground,
		  old_drawtitlebackground); i++;

	if (old_titlebackgroundPixmap)
	{
		XtSetArg (args[i], XtNnetTitleBackgroundPixmap,
			  old_titlebackgroundPixmap);
		i++;
	}

	if (old_image)		/* share the image */
	{
		XtSetArg (args[i], XtNnetImage, old_image);
		i++;
	}

	XtSetArg (args[i], XtNwidth, width); i++;
	XtSetArg (args[i], XtNheight, height); i++;

	/*
	 * now add the supplied arguments to the end of the list
	 * so they are seen last - so they may override the copied
	 * values.
	 */
	initial_args_length += i;
	for (j = 0; i < initial_args_length; i++, j++)
		XtSetArg (args[i], initial_args[j].name,
			  initial_args[j].value);

	/*
	 * create the birds eye widget - assume that they want it to
	 * be manged.  They can call XtUnmageWidget() if necessary.
	 */
	birdseye -> birdseye = XtCreateManagedWidget (birdseye_name,
						      netWidgetClass,
						      birdseye_parent,
						      args, i);
	/*
	 * free the argument list - no longer needed
	 */
	XFree ((char *) args);

	/*
	 * add the callbacks that make the thing work
	 */
	BirdsEyeAddCallbacks (birdseye);

	return birdseye;
}

/*
 * function to add callbacks to the widgets involved with the birds
 * eye operations
 */
static void
BirdsEyeAddCallbacks (birdseye)
BirdsEyeData *birdseye;
{
#ifdef OPENLOOK
	XtAddCallback (birdseye -> scrolledwindow, XtNvSliderMoved,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
	XtAddCallback (birdseye -> scrolledwindow, XtNhSliderMoved,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtAddCallback (birdseye -> scrolledwindow, XtNvScrollEvent,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
	XtAddCallback (birdseye -> scrolledwindow, XtNhScrollEvent,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
#endif /* HP_WIDGETS */

	XtAddCallback (birdseye -> birdseye, XtNnetProcDrag,
		       (XtCallbackProc) BirdsEyeDragCB, birdseye);
	XtAddCallback (birdseye -> birdseye, XtNnetProcUpdate,
		       (XtCallbackProc) BirdsEyeUpdateCB, birdseye);
	XtAddCallback (birdseye -> netwidget, XtNnetProcUpdate,
		       (XtCallbackProc) BirdsEyeUpdateCB, birdseye);
}

/*
 * callback to be run when the scrolled window scrollbars are moved by
 * the end user.
 */
static void
BirdsEyeScrollbarCB (w, birdseye, call_data)
Widget w;
BirdsEyeData *birdseye;
caddr_t call_data;
{
	netNode node;
	double fx, fy;

	node = *birdseye -> top_node;
	BirdsEyeXY (birdseye -> netwidget, &fx, &fy);
	node.pf.x = fx;
	node.pf.y = fy;
	netUpdateNode ((NetWidget) birdseye -> birdseye, &node, birdseye -> top_node);
}

/*
 * callback to be run when a node is moved by the end user - in either
 * the netwidget or the birds eye.
 */
static void
BirdsEyeUpdateCB (w, birdseye, data)
Widget w;
BirdsEyeData *birdseye;
NetCallbackData *data;
{
	netNode *node;
	netNode *nodetomove;
	netNode nodecopy;

	if (data -> data_type != NETTITLE && data -> data_type != NETSYMBOL)
		return;

	node = data -> selected_node;

	if (node != birdseye -> top_node)
	{
		if (w == birdseye -> netwidget)
		{
			nodetomove = BirdsEyeFindMatchingNewNode (birdseye,
								  node);
			w = birdseye -> birdseye;
		}
		else
		{
			nodetomove = BirdsEyeFindMatchingOldNode (birdseye,
								  node);
			w = birdseye -> netwidget;
		}
		if (nodetomove -> pf.x != node -> pf.x ||
		    nodetomove -> pf.y != node -> pf.y)
		{
			nodecopy = *nodetomove;
			nodecopy.pf.x = node -> pf.x;
			nodecopy.pf.y = node -> pf.y;
			netUpdateNode ((NetWidget) w, &nodecopy, nodetomove);
		}
	}
}

/*
 * callback to be run when the birds eye node is moved by the end user.
 * this function adjust which part of the network widget is curently
 * visible.
 */
static void
BirdsEyeDragCB (w, birdseye, data)
Widget w;
BirdsEyeData *birdseye;
NetCallbackData *data;
{
	netNode *node;
	int i;
	Arg args[16];
	int x;
	int y;
#ifdef OPENLOOK
	Widget hsb, vsb;
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */

	if (data -> data_type != NETTITLE && data -> data_type != NETSYMBOL)
		return;

	node = data -> selected_node;

	if (node != birdseye -> top_node)
		return;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNhScrollbar, &hsb); i++;
	XtSetArg (args[i], XtNvScrollbar, &vsb); i++;
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (birdseye -> scrolledwindow, args, i);

	i = 0;
	x = node -> pf.x * birdseye -> netwidget -> core.width;
	if (x + hextent > birdseye -> netwidget -> core.width)
		x = birdseye -> netwidget -> core.width - hextent;
	y = (1.0 - node -> pf.y) * birdseye -> netwidget -> core.height;
	if (y + vextent > birdseye -> netwidget -> core.height)
		y = birdseye -> netwidget -> core.height - vextent;
#ifdef OPENLOOK
	XtSetArg (args[0], XtNsliderValue, x);
	XtSetValues (hsb, args, 1);
	XtSetArg (args[0], XtNsliderValue, y);
	XtSetValues (vsb, args, 1);
	XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderOrigin, x); i++;
	XtSetArg (args[i], XtNvSliderOrigin, y); i++;
	XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */
}

/*
 * helper function for changing the title and symbol names
 * in the birds eye widget.
 */
static void
BirdsEyeChangeNames (birdseye, type, title_name, symbol_name)
BirdsEyeData *birdseye;
int type;
char *title_name;
char *symbol_name;
{
	netNode *nodelist;
	netNode *allnodes;
	Arg args[16];
	int i;
	netNode *node;

	i = 0;
	XtSetArg (args[i], XtNnetNodeList, &nodelist); i++;
	XtSetArg (args[i], XtNnetAllNodes, &allnodes); i++;
	XtGetValues (birdseye -> birdseye, args, i);

	if (nodelist)
		node = nodelist;
	else
		node = allnodes;

	if (node == (netNode *) NULL)
		return;

	nodelist = node;
	for (; node != (netNode *) NULL; node = node -> next)
	{
		if (node -> type == NETSYMBOLISPROC &&
		    node -> symbol.draw_proc == BirdsEyeNode)
			continue;
		/* Free the labels - these are copies so use XFree() */
		if (node -> type & NETTITLEISLABEL)
			XFree ((char *) node -> title.label);
		if (node -> type & NETSYMBOLISLABEL)
			XFree ((char *) node -> symbol.label);
		node -> type = type;
		node -> title.name = title_name;
		node -> symbol.name = symbol_name;
	}

	if (XtIsRealized (birdseye -> birdseye) == FALSE)
		return;

	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodelist); i++;
	XtSetValues (birdseye -> birdseye, args, i);
}

/*
 * helper function for allocating colors - repeated as often as
 * possible.
 */
static Pixel
BirdsEyeGetPixel (w, str)
Widget w;
char *str;
{
	XColor xch, xce;
	Display *display = XtDisplay (w);

	if (XAllocNamedColor (display,
			      DefaultColormap (display,
					       DefaultScreen (display)),
			      str,
			      &xch, &xce))
		return xch.pixel;

	return (Pixel) NULL;
}

/*
 * birds eye node function.  This function is used for the node that
 * represents which part of the network widget is curently visible.
 */
static NetDrawProc
BirdsEyeNode (type, w, node, d, xor, clip_rect)
int type;
Widget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	XGCValues xgcvalues;
	static GC gc = NULL;
	static GC xor_gc = NULL;
	static int reference_count = 0;
	GC lgc;
	double fwidth, fheight;
	BirdsEyeData *birdseye = (BirdsEyeData *) node -> application_ptr;

	switch (type)
	{
	case NETPROCINIT:
		reference_count++;
		xgcvalues.function = GXcopy;
		xgcvalues.line_style = LineOnOffDash;
		xgcvalues.foreground = BirdsEyeGetPixel (w, "red");
		if (gc == NULL)
			gc = XCreateGC (XtDisplay (w), XtWindow (w),
					GCFunction | GCLineStyle |
					GCForeground,
					&xgcvalues);
		xgcvalues.function = NET_GXXOR_OP;
		if (xor_gc == NULL)
			xor_gc = XCreateGC (XtDisplay (w), XtWindow (w),
					    GCFunction | GCLineStyle |
					    GCForeground,
					    &xgcvalues);
		node -> s_width = 0;
		break;

	case NETPROCSIZE:
		BirdsEyeSize (birdseye -> scrolledwindow,
			      birdseye -> netwidget, &fwidth, &fheight);
		node -> s.width = fwidth * w -> core.width;
		node -> s.height = fheight * w -> core.height;
		node -> p.x = node -> pf.x * w -> core.width;
		node -> p.y = w -> core.height - node -> pf.y *
			w -> core.height;
		node -> s.x = node -> p.x;
		if (node -> s.x + node -> s.width > w -> core.width)
			node -> p.x = node -> s.x = w -> core.width -
				node -> s.width;
		node -> s.y = node -> p.y;
		if (node -> s.y + node -> s.height > w -> core.height)
			node -> p.y = node -> s.y = w -> core.height -
				node -> s.height;
		break;

	case NETPROCDRAW:
		if (xor)
			lgc = xor_gc;
		else
			lgc = gc;

		if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
		{
			XSetClipRectangles (XtDisplay (w),
					    lgc, 0,0,
					    (XRectangle *)clip_rect,
					    1, YXBanded);
		}

		XDrawRectangle (XtDisplay (w), d, lgc,
				node -> s.x, node -> s.y,
				node -> s.width - 1,
				node -> s.height - 1);

		if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
		{
			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), lgc,
				   GCClipMask, &xgcvalues);
		}
		break;

	case NETPROCPICK:
		{
		NetPickArgs *pick_args = (NetPickArgs *) d;
		
		pick_args -> return_value = PtInRect (pick_args -> p,
						      &node -> s);
		break;
		}

	case NETPROCDESTROY:
		if (--reference_count)
			break;
		if (gc)
		{
			XFreeGC (XtDisplay (w), gc);
			gc = (GC) NULL;
		}
		if (xor_gc)
		{
			XFreeGC (XtDisplay (w), xor_gc);
			xor_gc = (GC) NULL;
		}
		break;
	}
}
#endif /* ! MOTIF */
