static char TMxnet7_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"

typedef struct netNodeListPtr
{
	netNode *node;
	struct netNodeListPtr *next;
} netNodeListPtr;

typedef struct netLinkListPtr
{
	netLink *link;
	struct netLinkListPtr *next;
} netLinkListPtr;

typedef struct
{
	int state;
	netNodeListPtr *nodes;
	netLinkListPtr *links;
} netNodeSubList;

#define DISPLAYED	1
#define NOT_DISPLAYED	0

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
netLinksandNodesCB C_P_ARGS((Widget w, caddr_t call_data,
			     NetCallbackData *data));

static void
toggle_nodes_and_links C_P_ARGS((Widget w, netNode *node));

C_PROTOS_END_EXTERN

void
main (argc, argv)
int argc;
char **argv;
{
	extern void netLinksandNodesCB ();
	netNodeSubList node_sub_list[6];
	int node_sub_count = 0;
	netNodeListPtr node_list[5];
	int node_count = 0;
	netLinkListPtr link_list[5];
	int link_count = 0;
	XtCallbackRec toll_call[2];

	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Widget toplevel, scrolledwindow, netwidget;
	Pixmap background_pixmap;

#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	nodes[0].type = NETBOXSYMBOL;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = (char *) NULL;
	nodes[0].symbol.name = "1";
	nodes[0].next = (netNode *) NULL;

	nodes[1].type = NETBOXSYMBOL;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = (char *) NULL;
	nodes[1].symbol.name = "1.1";
	nodes[1].next = (netNode *) NULL;

	nodes[2].type = NETBOXSYMBOL;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = (char *) NULL;
	nodes[2].symbol.name = "1.2";
	nodes[2].next = (netNode *) NULL;

	nodes[3].type = NETBOXSYMBOL;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = (char *) NULL;
	nodes[3].symbol.name = "1.1.1";
	nodes[3].next = (netNode *) NULL;

	nodes[4].type = NETBOXSYMBOL;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = (char *) NULL;
	nodes[4].symbol.name = "1.1.2";
	nodes[4].next = (netNode *) NULL;

	nodes[5].type = NETBOXSYMBOL;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "1.1.2.1";
	nodes[5].next = (netNode *) NULL;

	links[0].type = 0;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = (netLink *) NULL;

	links[1].type = 0;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = (netLink *) NULL;

	links[2].type = 0;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = (netLink *) NULL;

	links[3].type = 0;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = (netLink *) NULL;

	links[4].type = 0;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	/* node 0 descendants */
	nodes[0].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = &node_list[node_count];
	node_list[node_count].node = &nodes[1];
	node_list[node_count].next = &node_list[node_count + 1];
	node_count++;
	node_list[node_count].node = &nodes[2];
	node_list[node_count].next = (netNodeListPtr *) NULL;
	node_count++;
	node_sub_list[node_sub_count].links = &link_list[link_count];
	link_list[link_count].link = &links[0];
	link_list[link_count].next = &link_list[link_count + 1];
	link_count++;
	link_list[link_count].link = &links[1];
	link_list[link_count].next = (netLinkListPtr *) NULL;
	link_count++;
	node_sub_count++;

	/* node 1 descendants */
	nodes[1].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = &node_list[node_count];
	node_list[node_count].node = &nodes[3];
	node_list[node_count].next = &node_list[node_count + 1];
	node_count++;
	node_list[node_count].node = &nodes[4];
	node_list[node_count].next = (netNodeListPtr *) NULL;
	node_count++;
	node_sub_list[node_sub_count].links = &link_list[link_count];
	link_list[link_count].link = &links[2];
	link_list[link_count].next = &link_list[link_count + 1];
	link_count++;
	link_list[link_count].link = &links[3];
	link_list[link_count].next = (netLinkListPtr *) NULL;
	link_count++;
	node_sub_count++;

	/* node 2 descendants */
	nodes[2].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = (netNodeListPtr *) NULL;
	node_sub_list[node_sub_count].links = (netLinkListPtr *) NULL;
	node_sub_count++;

	/* node 3 descendants */
	nodes[3].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = (netNodeListPtr *) NULL;
	node_sub_list[node_sub_count].links = (netLinkListPtr *) NULL;
	node_sub_count++;

	/* node 4 descendants */
	nodes[4].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = &node_list[node_count];
	node_list[node_count].node = &nodes[5];
	node_list[node_count].next = (netNodeListPtr *) NULL;
	node_count++;
	node_sub_list[node_sub_count].links = &link_list[link_count];
	link_list[link_count].link = &links[4];
	link_list[link_count].next = (netLinkListPtr *) NULL;
	link_count++;
	node_sub_count++;

	/* node 5 descendants */
	nodes[5].application_ptr = (char *) &node_sub_list[node_sub_count];
	node_sub_list[node_sub_count].state = NOT_DISPLAYED;
	node_sub_list[node_sub_count].nodes = (netNodeListPtr *) NULL;
	node_sub_list[node_sub_count].links = (netLinkListPtr *) NULL;
	node_sub_count++;

	i = 0;
	toll_call[0].callback = (XtCallbackProc) netLinksandNodesCB;
	toll_call[0].closure = NULL;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[i], XtNnetProcPoint, toll_call); i++;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;

	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

	XtMainLoop ();
}

static void
netLinksandNodesCB (w, call_data, data)
Widget w;
caddr_t call_data;
NetCallbackData *data;
{
	if (data -> data_type == NETTITLE ||
	    data -> data_type == NETSYMBOL)
		toggle_nodes_and_links (w, data -> selected_node);
}

static void
toggle_nodes_and_links (w, node)
Widget w;
netNode *node;
{
	netNodeSubList *node_sub_ptr;
	netNodeListPtr *child_node_list;
	netNode *last_node;
	netLinkListPtr *child_link_list;
	netLink *last_link;
	
	last_node = node;
	node_sub_ptr = (netNodeSubList *) node -> application_ptr;
	child_node_list = node_sub_ptr -> nodes;
	while (child_node_list)
	{
		if (node_sub_ptr -> state == DISPLAYED)
		{
			netRemoveNode ((NetWidget) w, child_node_list -> node);
		}
		else
		{
			child_node_list -> node -> type &=
				~(NETMARKBIT | NETMOVED);
			netAddNode ((NetWidget) w, child_node_list -> node,
				    NETADDPREVIOUS, last_node);
			last_node = child_node_list -> node;
		}
		
		if (((netNodeSubList *) child_node_list -> node ->
		     application_ptr) -> state == node_sub_ptr -> state)
			toggle_nodes_and_links (w, child_node_list -> node);

		child_node_list = child_node_list -> next;
	}

	if (node_sub_ptr -> state == NOT_DISPLAYED)
	{
		child_link_list = node_sub_ptr -> links;
		last_link = (netLink *) NULL;
		while (child_link_list)
		{
			child_link_list -> link -> type &=
				~(NETMARKBIT | NETMOVED);
			netAddLink ((NetWidget) w, child_link_list -> link,
				    (last_link ? NETADDPREVIOUS :
				     NETADDLAST), last_link);
			last_link = child_link_list -> link;
			
			child_link_list = child_link_list -> next;
		}
	}

	if (node_sub_ptr -> state == DISPLAYED)
		node_sub_ptr -> state = NOT_DISPLAYED;
	else
		node_sub_ptr -> state = DISPLAYED;
}
