static char TMxnet3_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"
#include <math.h>

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
net_zoom C_P_ARGS((Widget w, XEvent *event, String *params, Cardinal *count));

static Pixel
GetPixel C_P_ARGS((Widget w, char *str));

static NetDrawProc
link_draw_proc C_P_ARGS((int type, Widget w, netLink *link, Drawable d,
			 int xor, netXSRectangle *clip_rect));

static void
arrow C_P_ARGS((netXFPoint *a, netXFPoint *b, netXFPoint *p1, netXFPoint *p2));

C_PROTOS_END_EXTERN

#define MAX(a,b)	((a > b) ? a : b)
#define MIN(a,b)	((a < b) ? a : b)

/*
 * make then globals as an expedient - do not do this in a working system
 */
static Widget toplevel, scrolledwindow, netwidget;

void
main (argc, argv)
int argc;
char **argv;
{
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Pixmap background_pixmap;
	XtActionsRec action;
	XtTranslations trans;

#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	nodes[0].type = NETBOXTITLE;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = "1";
	nodes[0].symbol.name = (char *) NULL;
	nodes[0].next = &nodes[1];

	nodes[1].type = NETBOXTITLE;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = "1.1";
	nodes[1].symbol.name = (char *) NULL;
	nodes[1].next = &nodes[2];

	nodes[2].type = NETBOXTITLE;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = "1.2";
	nodes[2].symbol.name = (char *) NULL;
	nodes[2].next = &nodes[3];

	nodes[3].type = NETBOXTITLE;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = "1.1.1";
	nodes[3].symbol.name = (char *) NULL;
	nodes[3].next = &nodes[4];

	nodes[4].type = NETBOXTITLE;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = "1.1.2";
	nodes[4].symbol.name = (char *) NULL;
	nodes[4].next = &nodes[5];

	nodes[5].type = NETBOXTITLE;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = "1.1.2.1";
	nodes[5].symbol.name = (char *) NULL;
	nodes[5].next = (netNode *) NULL;

	links[0].type = NETLINEISPROC;
	links[0].line.draw_proc = link_draw_proc;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = &links[1];

	links[1].type = NETLINEISPROC;
	links[1].line.draw_proc = link_draw_proc;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = &links[2];

	links[2].type = NETLINEISPROC;
	links[2].line.draw_proc = link_draw_proc;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = &links[3];

	links[3].type = NETLINEISPROC;
	links[3].line.draw_proc = link_draw_proc;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = &links[4];

	links[4].type = NETLINEISPROC;
	links[4].line.draw_proc = link_draw_proc;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_RIGHT);
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	XtSetArg (args[i], XtNnetTitleBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetTitleForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawTitleBackground, TRUE); i++;

	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

#ifdef HP_WIDGETS
	action.string = "NetZoom";
	action.proc = net_zoom;
	XtAppAddActions (XtWidgetToApplicationContext (toplevel),
			 &action, 1);

	trans = XtParseTranslationTable (
			"Ctrl Shift <Btn1Down>:  NetZoom(\"zoom in\")\n\
			 Ctrl <Btn1Down>:        NetZoom(\"zoom out\")\n");

	XtOverrideTranslations (netwidget, trans);
#endif
	XtMainLoop ();
}

#ifdef HP_WIDGETS

#define ZOOM_FACTOR	2

static void
net_zoom (w, event, params, count)
Widget w;
XEvent *event;
String *params;
Cardinal *count;
{
	int i;
	Arg args[16];
	int hextent, vextent;
	Position x, y;
	Dimension width, height;

	i = 0;
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
	XtGetValues (scrolledwindow, args, i);
	hextent /= 2;
	vextent /= 2;

	i = 0;
	XtSetArg (args[i], XtNx, &x); i++;
	XtSetArg (args[i], XtNy, &y); i++;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (netwidget, args, i);

	if (strcmp (params[0], "zoom in") == 0)
	{
		i = 0;
		XtSetArg (args[i], XtNwidth, width * ZOOM_FACTOR); i++;
		XtSetArg (args[i], XtNheight, height * ZOOM_FACTOR); i++;
		XtSetValues (netwidget, args, i);

		x = (abs (x) + hextent) * ZOOM_FACTOR - hextent;
		y = (abs (y) + vextent) * ZOOM_FACTOR - vextent;

		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (scrolledwindow, args, i);
	}
	else if (strcmp (params[0], "zoom out") == 0)
	{
		if (width > ZOOM_FACTOR)
			x = (abs (x) + hextent) / ZOOM_FACTOR - hextent;
		if (height > ZOOM_FACTOR)
			y = (abs (y) + vextent) / ZOOM_FACTOR - vextent;

		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (scrolledwindow, args, i);

		i = 0;
		if (width > ZOOM_FACTOR)
		{
			XtSetArg (args[i], XtNwidth, width / ZOOM_FACTOR);
			i++;
		}
		if (height > ZOOM_FACTOR)
		{
			XtSetArg (args[i], XtNheight, height / ZOOM_FACTOR);
			i++;
		}
		if (i)
			XtSetValues (netwidget, args, i);
	}
}
#endif /* HP_WIDGETS */

static Pixel
GetPixel (w, str)
Widget w;
char *str;
{
	XColor xch, xce;
	Display *display = XtDisplay (w);

	if (XAllocNamedColor (display,
			      DefaultColormap (display,
					       DefaultScreen (display)),
			      str,
			      &xch, &xce))
		return xch.pixel;
	
	return (Pixel) NULL;
}

static NetDrawProc
link_draw_proc (type, w, link, d, xor, clip_rect)
int type;
Widget w;
netLink *link;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	XGCValues gcValues;
	static GC gc = NULL;
	static GC xor_gc = NULL;
	XPoint p_arrow[4];
	netXFPoint pf1, pf2;
	float scale_x;
	float scale_y;
	GC cgc;
	static int reference_count = 0;

	link -> type &= ~(NETLINEISPROC);
	link -> line.line = (netLine *) link -> application_ptr;
	
	switch (type)
	{
	case NETPROCINIT:
		reference_count++;

		gcValues.function = GXcopy;
		gcValues.foreground = GetPixel (w, "black");
		if (gc == NULL)
			gc = XCreateGC (XtDisplay (w), XtWindow (w),
					GCFunction | GCForeground,
					&gcValues);
		gcValues.function = NET_GXXOR_OP;
		if (xor_gc == NULL)
			xor_gc = XCreateGC (XtDisplay (w), XtWindow (w),
					    GCFunction | GCForeground,
					    &gcValues);
		netInitializeLink ((NetWidget) w, link);
		break;
		
	case NETPROCSIZE:
		netSetLinkRect ((NetWidget) w, link);
		arrow (&link -> A -> pf, &link -> B -> pf, &pf1, &pf2);
		scale_x = w -> core.width;
		scale_y = w -> core.height;
		p_arrow[1].x = pf1.x * scale_x;
		p_arrow[1].y = scale_y - pf1.y * scale_y;
		MergeRectPt (&link -> l, &p_arrow[1]);
		p_arrow[2].x = pf2.x * scale_x;
		p_arrow[2].y = scale_y - pf2.y * scale_y;
		MergeRectPt (&link -> l, &p_arrow[2]);
		break;
		
	case NETPROCDRAW:
		if (xor)
			cgc = xor_gc;
		else
			cgc = gc;

		if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
			XSetClipRectangles (XtDisplay (w), cgc,
					    0, 0, (XRectangle *) clip_rect,
					    1, YXBanded);
		arrow (&link -> A -> pf, &link -> B -> pf, &pf1, &pf2);
		scale_x = w -> core.width;
		scale_y = w -> core.height;
		p_arrow[0].x = link -> B -> p.x;
		p_arrow[0].y = link -> B -> p.y;
		p_arrow[1].x = pf1.x * scale_x;
		p_arrow[1].y = scale_y - pf1.y * scale_y;
		p_arrow[2].x = pf2.x * scale_x;
		p_arrow[2].y = scale_y - pf2.y * scale_y;
		p_arrow[3] = p_arrow[0];
		XFillPolygon (XtDisplay (w), d, cgc, p_arrow, 4,
			      Convex, CoordModeOrigin);
		netDrawLink ((NetWidget) w, link, d, xor, clip_rect);
		if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
		{
			XGCValues xgcvalues;

			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), cgc, GCClipMask, &xgcvalues);
		}
		break;
		
	case NETPROCPICK:
	{
		NetPickArgs *pick_args = (NetPickArgs *) d;
		
		pick_args -> return_value = netPickLink ((NetWidget) w, link,
							 pick_args -> p -> x,
							 pick_args -> p -> y);
		break;
	}
		
	case NETPROCDESTROY:
		netDestroyLink ((NetWidget) w, link);
		if (--reference_count)
			break;
		if (gc)
		{
			XFreeGC (XtDisplay (w), gc);
			gc = (GC) NULL;
		}
		if (xor_gc)
		{
			XFreeGC (XtDisplay (w), xor_gc);
			xor_gc = (GC) NULL;
		}
		break;
	}
	
	link -> type |= NETLINEISPROC;
	link -> line.draw_proc = link_draw_proc;
}

#define ARROWwid	0.025
#define ARROWht		0.05

static void
arrow (a, b, p1, p2)
register netXFPoint *a, *b;
register netXFPoint *p1, *p2;
{
	double alpha, rot, hyp;
	double dx, dy;

	rot = atan2 ((double) ARROWht, (double) (ARROWwid / 2.0));
	hyp = sqrt ((double) (ARROWwid * ARROWwid + ARROWht * ARROWht));
	alpha = atan2 ((double) (b -> x - a -> x), (double) (b -> y - a -> y));
	alpha += M_PI;

	dx = hyp * cos (alpha + rot);
	dy = hyp * sin (alpha + rot);
	p1 -> x = b -> x - dx;
	p1 -> y = b -> y + dy;

	dx = hyp * cos (alpha - rot);
	dy = hyp * sin (alpha - rot);
	p2 -> x = b -> x + dx;
	p2 -> y = b -> y - dy;
}
