static char TMxnet13_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifdef MOTIF

main ()
{
    printf ("this example has not been converted to Motif\n");
}

#else

#include <stdio.h>
#include <setjmp.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifdef OPENLOOK
#include <X11/Shell.h>
#endif /* OPENLOOK */

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#include <Xol/Form.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/PButton.h>
#include <Xw/Arrow.h>
#include <Xw/Valuator.h>
#include <Xw/ScrollBar.h>
#include <Xw/SWindow.h>
#include <Xw/SText.h>
#include <Xw/TextEdit.h>
#include <Xw/BBoard.h>
#include <Xw/Form.h>
#endif /* HP_WIDGETS */

#ifdef OPENLOOK
#define INITIALIZE		OlInitialize
#define FORMWDG			formWidgetClass
#define PBUTTONWDG		oblongButtonWidgetClass
#define SCROLLEDWINDOWWDG	scrolledWindowWidgetClass
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#define INITIALIZE		XtInitialize
#define FORMWDG			XwformWidgetClass
#define PBUTTONWDG		XwpushButtonWidgetClass
#define SCROLLEDWINDOWWDG	XwswindowWidgetClass
#endif /* HP_WIDGETS */

#include "Net.h"
#include "NetP.h"

/*
 * node to node hash table constants
 */
#define HASH_BIT_COUNT		(6) /* 2^n hash buckets */
#define HASH_TABLE_SIZE		(1 << HASH_BIT_COUNT)
#define HASH_TABLE_MASK		(HASH_TABLE_SIZE - 1)

/*
 * hash function - assume that malloc'ed nodes are word aligned
 */
#define HASH_FUNCTION(x)	(((int) (x) >> 2) & HASH_TABLE_MASK)

/*
 * structure for keeping track of nodes in the two widgets
 */
typedef struct netNodePair
{
	netNode *orig;
	netNode *copy;
	struct netNodePair *new_hash_next;
	struct netNodePair *old_hash_next;
} netNodePair;

/*
 * the structure for managing all birds eye related data
 */
typedef struct
{
	netNode *top_node;
	netNodePair *node_pairs;
	int node_pairs_count;
	netNodePair *new_hash_table[HASH_TABLE_SIZE];
	netNodePair *old_hash_table[HASH_TABLE_SIZE];
	Widget netwidget;
	Widget scrolledwindow;
	Widget birdseye;
} BirdsEyeData;

/*
 * zoom options
 */
#define ZOOM_IN		1
#define ZOOM_OUT	2

/*
 * the structure for managing printing related data
 */
typedef struct
{
	Widget toplevel;
	Widget scrolled_window;
	Widget netwidget;
	char *output_filename;
} netPrintData;

Widget toplevel;

/*
 * birds eye related functions - contained at the end of this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
BirdsEyeZoomInCB C_P_ARGS((Widget w, BirdsEyeData **closure,
			   caddr_t call_data));

static void
BirdsEyeZoomOutCB C_P_ARGS((Widget w, BirdsEyeData **closure,
			    caddr_t call_data));

static void
BirdsEyeZoom C_P_ARGS((BirdsEyeData *birdseye, int zoom_direction,
		       int zoom_factor));

static void
BirdsEyeSize C_P_ARGS((Widget scrolledwindow, Widget netwidget, double *fwidth,
		       double *fheight));

static void
BirdsEyeXY C_P_ARGS((Widget netwidget, double *fx, double *fy));

static netNode *
BirdsEyeFindMatchingNewNode C_P_ARGS((BirdsEyeData *birdseye, netNode *node));

static netNode *
BirdsEyeFindMatchingOldNode C_P_ARGS((BirdsEyeData *birdseye, netNode *node));

static void
BirdsEyeCopyNodes C_P_ARGS((BirdsEyeData *birdseye, netNode *old_nodelist));

static BirdsEyeData *
BirdsEyeCreate C_P_ARGS((char *birdseye_name, Widget birdseye_parent,
			 Arg *initial_args, int initial_args_length,
			 Widget netwidget, Widget scrolledwindow, int width,
			 int height));

static void
BirdsEyeAddCallbacks C_P_ARGS((BirdsEyeData *birdseye));

static void
BirdsEyeScrollbarCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			      caddr_t call_data));

static void
BirdsEyeUpdateCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			   NetCallbackData *data));

static void
BirdsEyeDragCB C_P_ARGS((Widget w, BirdsEyeData *birdseye,
			 NetCallbackData *data));

static void
BirdsEyeChangeNames C_P_ARGS((BirdsEyeData *birdseye, int type,
			      char *title_name, char *symbol_name));

static Pixel
BirdsEyeGetPixel C_P_ARGS((Widget w, char *str));

static NetDrawProc
BirdsEyeNode C_P_ARGS((int type, Widget w, netNode *node, Drawable d,
		       int xor, netXSRectangle *clip_rect));

static void
netPrintCB C_P_ARGS((Widget w, netPrintData *net_print_data,
		     caddr_t call_data));

static void
netPrintTimeoutProc C_P_ARGS((jmp_buf env, XtIntervalId id));

static void
netPrintInPages C_P_ARGS((Widget toplevel, Widget scrolled_window,
			  NetWidget netwidget, char *file));

static void
netMoveTheWindow C_P_ARGS((Widget netwidget, Widget scrolled_window,
			   int x, int y, int width, int height));

static void
PseudoMapToGreyMap C_P_ARGS((XColor *colors, unsigned char *greymap,
			     int size));

static int
ImageToPostScriptFile C_P_ARGS((Display *display, XImage *image,
				Colormap colormap, char *output_file));

C_PROTOS_END_EXTERN

/*
 * sample main routine for exercising the widgets
 */
void
main (argc, argv)
int argc;
char **argv;
{
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Pixmap background_pixmap;
	netMapPolygon *maps;
	BirdsEyeData *birdseye;
	netPrintData net_print_data;
	Widget form, zoomin, zoomout, printout, scrolledwindow, netwidget;
	XtCallbackRec toll_call[2];
	int depth;

	/*
	 * initialize the connection to the server and the toolkit
	 */
	toplevel = INITIALIZE (argv[0], "Test", NULL, 0, &argc, argv);

#ifdef OPENLOOK
	i = 0;
	XtSetArg (args[i], XtNallowShellResize, False); i++;
	XtSetValues (toplevel, args, i);
#endif /* OPENLOOK */

	depth = XDefaultDepth (XtDisplay (toplevel),
			       DefaultScreen (XtDisplay (toplevel)));

	/*
	 * create the toplevel form widget - all other widgets are
	 * contained within this widget or its children
	 */
	form = XtCreateManagedWidget ("form", FORMWDG,
				      toplevel, NULL, 0);

	/*
	 * zoom in push button
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Zoom In"); i++;
	toll_call[0].callback = (XtCallbackProc) BirdsEyeZoomInCB;
	toll_call[0].closure = (caddr_t) &birdseye;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	zoomin = XtCreateManagedWidget ("ZoomIn", PBUTTONWDG,
					form, args, i);

	/*
	 * zoom out push button
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, zoomin); i++;
	XtSetArg (args[i], XtNyAddHeight, True); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Zoom Out"); i++;
	toll_call[0].callback = (XtCallbackProc) BirdsEyeZoomOutCB;
	toll_call[0].closure = (caddr_t) &birdseye;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	zoomout = XtCreateManagedWidget ("ZoomOut", PBUTTONWDG,
					 form, args, i);

	/*
	 * print out push button
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 5); i++;
	XtSetArg (args[i], XtNyRefWidget, zoomout); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNyOffset, 5); i++;
	XtSetArg (args[i], XtNlabel, "Print Out"); i++;
	toll_call[0].callback = (XtCallbackProc) netPrintCB;
	toll_call[0].closure = (caddr_t) &net_print_data;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[0], XtNselect, toll_call);
	printout = XtCreateManagedWidget ("PrintOut", PBUTTONWDG,
					 form, args, i);

	/*
	 * scrolled window for handling a network widget
	 */
	i = 0;
/*
	XtSetArg (args[i], XtNxRefName, "BirdsEye"); i++;
	XtSetArg (args[i], XtNxAddWidth, True); i++;
	XtSetArg (args[i], XtNxOffset, 20); i++;
*/
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 200); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;
	XtSetArg (args[i], XtNyOffset, 10); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNrecomputeWidth, FALSE); i++;
	XtSetArg (args[i], XtNrecomputeHeight, FALSE); i++;
#endif /* OPENLOOK */
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						SCROLLEDWINDOWWDG,
						form, args, i);
#ifdef OPENLOOK
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

	/*
	 * create a list of nodes and links
	 */
	nodes[0].type = NETBOXSYMBOL;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = (char *) NULL;
	nodes[0].symbol.name = "1";
	nodes[0].next = &nodes[1];

	nodes[1].type = NETBOXSYMBOL;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = (char *) NULL;
	nodes[1].symbol.name = "1.1";
	nodes[1].next = &nodes[2];

	nodes[2].type = NETBOXSYMBOL;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = (char *) NULL;
	nodes[2].symbol.name = "1.2";
	nodes[2].next = &nodes[3];

	nodes[3].type = NETBOXSYMBOL;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = (char *) NULL;
	nodes[3].symbol.name = "1.1.1";
	nodes[3].next = &nodes[4];

	nodes[4].type = NETBOXSYMBOL;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = (char *) NULL;
	nodes[4].symbol.name = "1.1.2";
	nodes[4].next = &nodes[5];

	nodes[5].type = NETBOXSYMBOL;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "1.1.2.1";
	nodes[5].next = (netNode *) NULL;

	links[0].type = 0;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = &links[1];

	links[1].type = 0;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = &links[2];

	links[2].type = 0;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = &links[3];

	links[3].type = 0;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = &links[4];

	links[4].type = 0;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	/*
	 * create a background pixmap for filled nodes
	 */
	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	/*
	 * create the network widget
	 */
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	XtSetArg (args[i], XtNwidth, 1000); i++;
	XtSetArg (args[i], XtNheight, 1000); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;

	if (depth > 1)
	{
		if (SetupPolygons ("map.list", &maps) == FALSE)
		{
			XtWarning ("Cannot allocate polygons.");
		}
		else
		{
			XtSetArg (args[i], XtNnetMapPolygons, maps);
			i++;
		}
	}
#ifdef DO_BITMAP
	{
		int width, height;
		Pixmap bitmap;
		int x_hot, y_hot;
		XImage *image;
		Display *display = XtDisplay (toplevel);
		
		if (XReadBitmapFile (display,
				     RootWindow (display,
						 DefaultScreen (display)),
				     "backbitmap.x",
				     &width, &height, &bitmap,
				     &x_hot, &y_hot) ==
		    BitmapSuccess)
		{
			image = XGetImage (display, bitmap,
					   0, 0, width, height,
					   1, XYPixmap);
			
			XtSetArg (args[i], XtNnetImage, image); i++;
			XFreePixmap (display, bitmap);
		}
		else
		{
			XtWarning ("Cannot read the bitmap file: backbitmap.x");
		}
	}
#endif
	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);
	net_print_data.toplevel = toplevel;
	net_print_data.scrolled_window = scrolledwindow;
	net_print_data.netwidget = netwidget;
	net_print_data.output_filename = "output";

	/*
	 * create a birds eye of the network widget created above
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNxOffset, 15); i++;
	XtSetArg (args[i], XtNyRefWidget, printout); i++;
	XtSetArg (args[i], XtNyOffset, 10); i++;
	XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, FALSE), i++;
	birdseye = BirdsEyeCreate ("BirdsEye", form, args, i,
				   netwidget, scrolledwindow, 150, 150);

	/*
	 * change the title and symbol names of all of the nodes
	 */
	BirdsEyeChangeNames (birdseye, 0, (char *) NULL, "*");

	/*
	 * realize the widgets
	 */
	XtRealizeWidget (toplevel);

	/*
	 * run the widgets
	 */
	XtMainLoop ();
}

/*
 * Callbacks for the zoom in and zoom out push buttons
 */
static void
BirdsEyeZoomInCB (w, closure, call_data)
Widget w;
BirdsEyeData **closure;
caddr_t call_data;
{
	BirdsEyeZoom (*closure, ZOOM_IN, 2);
}

static void
BirdsEyeZoomOutCB (w, closure, call_data)
Widget w;
BirdsEyeData **closure;
caddr_t call_data;
{
	BirdsEyeZoom (*closure, ZOOM_OUT, 2);
}

/*
 * function for zooming the network widget.  This function keeps the
 * birds eye in sync with the "zoomed" network widget.
 */
static void
BirdsEyeZoom (birdseye, zoom_direction, zoom_factor)
BirdsEyeData *birdseye;
int zoom_direction;
int zoom_factor;
{
	int i;
	Arg args[16];
	Position x, y;
	Dimension width, height;
#ifdef OPENLOOK
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */
	netNode node;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (birdseye -> scrolledwindow, args, i);
	hextent /= 2;
	vextent /= 2;

	i = 0;
	XtSetArg (args[i], XtNx, &x); i++;
	XtSetArg (args[i], XtNy, &y); i++;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (birdseye -> netwidget, args, i);

	switch (zoom_direction)
	{
	case ZOOM_IN:
		width = width * zoom_factor;
		height = height * zoom_factor;
		if (width > 16384 || height > 16384)
		{
		XtWarning ("Cannot zoom scrolled windows larger than 16384.");
			return;
		}
		i = 0;
		XtSetArg (args[i], XtNwidth, width); i++;
		XtSetArg (args[i], XtNheight, height); i++;
		XtSetValues (birdseye -> netwidget, args, i);

		x = (abs (x) + hextent) * zoom_factor - hextent;
		y = (abs (y) + vextent) * zoom_factor - vextent;

		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;

#ifdef OPENLOOK
		XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */
		break;

	case ZOOM_OUT:
		if (width > zoom_factor)
			x = (abs (x) + hextent) / zoom_factor - hextent;
		if (height > zoom_factor)
			y = (abs (y) + vextent) / zoom_factor - vextent;

		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;
#ifdef OPENLOOK
		XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
		i = 0;
		XtSetArg (args[i], XtNhSliderOrigin, x); i++;
		XtSetArg (args[i], XtNvSliderOrigin, y); i++;
		XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */

		i = 0;
		if (width > zoom_factor)
		{
			width /= zoom_factor;
			XtSetArg (args[i], XtNwidth, width); i++;
		}
		if (height > zoom_factor)
		{
			height /= zoom_factor;
			XtSetArg (args[i], XtNheight, height);
			i++;
		}
		if (i)
			XtSetValues (birdseye -> netwidget, args, i);
	}

	node = *birdseye -> top_node;
	if (x <= 0)
		node.pf.x = 0.0;
	else
		node.pf.x = (double) x / (double) width;
	if (y <= 0)
		node.pf.y = 1.0;
	else
		node.pf.y =  1.0 - (double) y / (double) height;
	netUpdateNode ((NetWidget) birdseye -> birdseye, &node, birdseye -> top_node);
}

/*
 * get the width and height in unit square dimensions
 */
static void
BirdsEyeSize (scrolledwindow, netwidget, fwidth, fheight)
Widget scrolledwindow, netwidget;
double *fwidth, *fheight;
{
	int i;
	Arg args[16];
#ifdef OPENLOOK
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */
	Dimension width, height;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */
	XtGetValues (scrolledwindow, args, i);

	i = 0;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (netwidget, args, i);

	*fwidth = (vextent ? (((double) vextent) / ((double) width)) : 0.0);
	*fheight = (hextent ? (((double) hextent) / ((double) height)) : 0.0);
}

/*
 * get the X and Y position of the network widget within the scrolled
 * window in unit square dimensions.
 */
static void
BirdsEyeXY (netwidget, fx, fy)
Widget netwidget;
double *fx, *fy;
{
	int i;
	Arg args[16];
	Position x, y;
	Dimension width, height;

	i = 0;
	XtSetArg (args[i], XtNx, &x); i++;
	XtSetArg (args[i], XtNy, &y); i++;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (netwidget, args, i);

	if (x >= 0)
		*fx = 0.0;
	else
		*fx = (double) -x / (double) width;
	if (y >= 0)
		*fy = 1.0;
	else
		*fy =  1.0 + (double) y / (double) height;
}

/*
 * find the new node that matches the specified old node
 */
static netNode *
BirdsEyeFindMatchingNewNode (birdseye, node)
BirdsEyeData *birdseye;
register netNode *node;
{
	netNodePair *node_pairs_ptr;

	node_pairs_ptr = birdseye -> old_hash_table[HASH_FUNCTION (node)];
	while (node_pairs_ptr)
	{
		if (node_pairs_ptr -> orig == node)
			return node_pairs_ptr -> copy;
		node_pairs_ptr = node_pairs_ptr -> old_hash_next;
	}
	return node;		/* should not happen */
}

/*
 * find the old node that matches the specified new node
 */
static netNode *
BirdsEyeFindMatchingOldNode (birdseye, node)
BirdsEyeData *birdseye;
register netNode *node;
{
	netNodePair *node_pairs_ptr;

	node_pairs_ptr = birdseye -> new_hash_table[HASH_FUNCTION (node)];
	while (node_pairs_ptr)
	{
		if (node_pairs_ptr -> copy == node)
			return node_pairs_ptr -> orig;
		node_pairs_ptr = node_pairs_ptr -> new_hash_next;
	}
	return node;		/* should not happen */
}

/*
 * make a copy of the node list from the network widget.  The top
 * node is the new birds eye node that displays the position of the
 * network widget within the scrolled window widget.
 *
 * this functions stores the birds eye structure in the top nodes
 * application pointer so that it will be available in the
 * BirdsEyeNode() function.
 */
static void
BirdsEyeCopyNodes (birdseye, old_nodelist)
BirdsEyeData *birdseye;
netNode *old_nodelist;
{
	netNode *top_node = (netNode *) NULL;
	netNode *last_node;
	netNode *node;
	netNodePair *node_pairs;
	netNodePair *node_pairs_ptr;
	int node_pairs_count = 0;
	int hash_index;

	if (old_nodelist)
	{
		node = old_nodelist;
		while (node)
		{
			node = node -> next;
			node_pairs_count++;
		}
		node_pairs = (netNodePair *) XtMalloc (sizeof (netNodePair) *
						    node_pairs_count);
		node_pairs_ptr = node_pairs;

		while (old_nodelist)
		{
			node = (netNode *) XtMalloc (sizeof (netNode));
			if (top_node == (netNode *) NULL)
				top_node = node;
			else
				last_node -> next = node;

			last_node = node;
			*node = *old_nodelist;
			if (node -> type & NETTITLEISLABEL)
			{
				node -> title.label = (netLabel *)
					XtMalloc (sizeof (netLabel));
				*node -> title.label =
					*old_nodelist -> title.label;
			}
			else
				node -> title = old_nodelist -> title;
			
			if (node -> type & NETSYMBOLISLABEL)
			{
				node -> symbol.label = (netLabel *)
					XtMalloc (sizeof (netLabel));
				*node -> symbol.label =
					*old_nodelist -> symbol.label;
			}
			else
				node -> symbol = old_nodelist -> symbol;
			
			node_pairs_ptr -> orig = old_nodelist;
			node_pairs_ptr -> copy = node;
			hash_index = HASH_FUNCTION (node);
			node_pairs_ptr -> new_hash_next =
				birdseye -> new_hash_table[hash_index];
			birdseye -> new_hash_table[hash_index] =
				node_pairs_ptr;
			hash_index = HASH_FUNCTION (old_nodelist);
			node_pairs_ptr -> old_hash_next =
				birdseye -> old_hash_table[hash_index];
			birdseye -> old_hash_table[hash_index] =
				node_pairs_ptr;
			node_pairs_ptr++;
			old_nodelist = old_nodelist -> next;
		}
	}
	else
		node_pairs = (netNodePair *) NULL;

	node = (netNode *) XtMalloc (sizeof (netNode));
	bzero (node, sizeof (netNode));
	node -> type = NETSYMBOLISPROC;
	node -> symbol.draw_proc = BirdsEyeNode;
	node -> title.name = (char *) NULL;
	node -> pf.x = 0.0;
	node -> pf.y = 1.0;
	if (top_node)
		node -> next = top_node;
	else
		node -> next = (netNode *) NULL;

	birdseye -> top_node = node;
	birdseye -> node_pairs = node_pairs;
	birdseye -> node_pairs_count = node_pairs_count;

	/*
	 * store the birds eye structure in the application pointer so
	 * that it will be available in the BirdsEyeNode() function
	 */
	node -> application_ptr = (caddr_t) birdseye;
}

/*
 * create a birds eye for a network widget.
 */
static BirdsEyeData *
BirdsEyeCreate (birdseye_name, birdseye_parent,
		initial_args, initial_args_length,
		netwidget, scrolledwindow, width, height)
char *birdseye_name;
Widget birdseye_parent;
Arg *initial_args;
int initial_args_length;
Widget netwidget;
Widget scrolledwindow;
int width;
int height;
{
	Pixel old_symbolforeground;
	Pixel old_titleforeground;
	Pixel old_linkforeground;
	XFontStruct *old_symbolfont;
	XFontStruct *old_titlefont;
	netNode *old_nodelist;
	netLink *old_linklist;
	netMapPolygon *old_mappolygons;
	Boolean old_polygonsAsLines;
	int old_thSpace;
	int old_tvSpace;
	int old_shSpace;
	int old_svSpace;
	Boolean old_drawsymbolbackground;
	Pixmap old_symbolbackgroundPixmap;
	Boolean old_drawtitlebackground;
	Pixmap old_titlebackgroundPixmap;
	XImage *old_image;
	netNode *old_allnodes;
	netLink *old_alllinks;
	int i, j;
	Arg *args;
	BirdsEyeData *birdseye;

	/*
	 * check that we have the correct widget types
	 */
	if (XtClass (netwidget) != netWidgetClass)
	{
XtWarning ("BirdsEyeCreate: The specified widget is not a network widget.");
		return (BirdsEyeData *) NULL;
	}
	if (XtClass (scrolledwindow) != SCROLLEDWINDOWWDG)
	{
XtWarning ("BirdsEyeCreate: The specified widget is not contained within a scrolling window widget.");
		return (BirdsEyeData *) NULL;
	}

	/*
	 * allocate the return structure
	 */
	birdseye = (BirdsEyeData *) XtMalloc (sizeof (BirdsEyeData));
	bzero (birdseye, sizeof (BirdsEyeData));
	birdseye -> netwidget = netwidget;
	birdseye -> scrolledwindow = scrolledwindow;

	/*
	 * allocate the widget creation argument structure
	 */
	args = (Arg *) XtMalloc (sizeof (Arg) * (initial_args_length + 32));

	/*
	 * get a copy of the network widget data
	 */
	i = 0;
	XtSetArg (args[i], XtNnetSymbolForeground, &old_symbolforeground); i++;
	XtSetArg (args[i], XtNnetTitleForeground, &old_titleforeground); i++;
	XtSetArg (args[i], XtNnetLinkForeground, &old_linkforeground); i++;
	XtSetArg (args[i], XtNnetSymbolFont, &old_symbolfont); i++;
	XtSetArg (args[i], XtNnetTitleFont, &old_titlefont); i++;
	XtSetArg (args[i], XtNnetNodeList, &old_nodelist); i++;
	XtSetArg (args[i], XtNnetLinkList, &old_linklist); i++;
	XtSetArg (args[i], XtNnetMapPolygons, &old_mappolygons); i++;
	XtSetArg (args[i], XtNnetPolygonsAsLines, &old_polygonsAsLines); i++;
	XtSetArg (args[i], XtNnetTitleHorizSpace, &old_thSpace); i++;
	XtSetArg (args[i], XtNnetTitleVertSpace, &old_tvSpace); i++;
	XtSetArg (args[i], XtNnetSymbolHorizSpace, &old_shSpace); i++;
	XtSetArg (args[i], XtNnetSymbolVertSpace, &old_svSpace); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground,
		  &old_drawsymbolbackground); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  &old_symbolbackgroundPixmap); i++;
	XtSetArg (args[i], XtNnetDrawTitleBackground,
		  &old_drawtitlebackground); i++;
	XtSetArg (args[i], XtNnetTitleBackgroundPixmap,
		  &old_titlebackgroundPixmap); i++;
	XtSetArg (args[i], XtNnetImage, &old_image); i++;
	XtSetArg (args[i], XtNnetAllNodes, &old_allnodes); i++;
	XtSetArg (args[i], XtNnetAllLinks, &old_alllinks); i++;
	XtGetValues (netwidget, args, i);

	/*
	 * create an argument list containing the correct bits - only
	 * copy in the ones that matter.
	 */
	i = 0;
	if (old_symbolforeground)
	{
		XtSetArg (args[i], XtNnetSymbolForeground, old_symbolforeground);
		i++;
	}

	if (old_titleforeground)
	{
		XtSetArg (args[i], XtNnetTitleForeground, old_titleforeground);
		i++;
	}

	if (old_linkforeground)
	{
		XtSetArg (args[i], XtNnetLinkForeground, old_linkforeground);
		i++;
	}

	if (old_symbolfont)
	{
		XtSetArg (args[i], XtNnetSymbolFont, old_symbolfont);
		i++;
	}

	if (old_titlefont)
	{
		XtSetArg (args[i], XtNnetTitleFont, old_titlefont);
		i++;
	}

	BirdsEyeCopyNodes (birdseye,
			   (old_nodelist ? old_nodelist : old_allnodes));
	XtSetArg (args[i], XtNnetNodeList, birdseye -> top_node); i++;

	if (old_linklist || old_alllinks)
	{
		netLink *top_link = (netLink *) NULL;
		netLink *last_link = (netLink *) NULL;
		netLink *link;

		if (old_linklist == (netLink *) NULL)
			old_linklist = old_alllinks;

		while (old_linklist)
		{
			link = (netLink *) XtMalloc (sizeof (netLink));
			if (top_link == (netLink *) NULL)
				top_link = link;
			else
				last_link -> next = link;
			last_link = link;
			*link = *old_linklist;
			link -> A = BirdsEyeFindMatchingNewNode (birdseye,
								 link -> A);
			link -> B = BirdsEyeFindMatchingNewNode (birdseye,
								 link -> B);
			if (link -> type & NETLINKISLINE)
			{
				link -> line.line = (netLine *)
					XtMalloc (sizeof (netLine));
				*link -> line.line =
					*old_linklist -> line.line;
			}
			else
				link -> line = old_linklist -> line;

			old_linklist = old_linklist -> next;
		}
		if (last_link)
		{
			last_link -> next = (netLink *) NULL;
			XtSetArg (args[i], XtNnetLinkList, top_link);
			i++;
		}
	}

	if (old_mappolygons)
	{
		netMapPolygon *top_mappolygon = (netMapPolygon *) NULL;
		netMapPolygon *last_mappolygon = (netMapPolygon *) NULL;
		netMapPolygon *mappolygon;

		while (old_mappolygons)
		{
			mappolygon = (netMapPolygon *)
				XtMalloc (sizeof (netMapPolygon));
			if (top_mappolygon == (netMapPolygon *) NULL)
				top_mappolygon = mappolygon;
			else
				last_mappolygon -> next = mappolygon;
			last_mappolygon = mappolygon;
			*mappolygon = *old_mappolygons;
			mappolygon -> points = (netXFPoint *)
				XtMalloc (sizeof (netXFPoint) *
					  mappolygon -> npoints);
			mappolygon -> p = (XPoint *)
				XtMalloc (sizeof (XPoint) *
					  mappolygon -> npoints);
			bcopy (old_mappolygons -> points, mappolygon -> points,
			       sizeof (netXFPoint) * mappolygon -> npoints);
			old_mappolygons = old_mappolygons -> next;
		}
		if (last_mappolygon)
		{
			last_mappolygon -> next = (netMapPolygon *) NULL;
			XtSetArg (args[i], XtNnetMapPolygons, top_mappolygon);
			i++;
		}
	}

	XtSetArg (args[i], XtNnetPolygonsAsLines, old_polygonsAsLines); i++;

	XtSetArg (args[i], XtNnetTitleHorizSpace, old_thSpace); i++;
	XtSetArg (args[i], XtNnetTitleVertSpace, old_tvSpace); i++;
	XtSetArg (args[i], XtNnetSymbolHorizSpace, old_shSpace); i++;
	XtSetArg (args[i], XtNnetSymbolVertSpace, old_svSpace); i++;

	XtSetArg (args[i], XtNnetDrawSymbolBackground, 
		  old_drawsymbolbackground); i++;

	if (old_symbolbackgroundPixmap)
	{
		XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
			  old_symbolbackgroundPixmap);
		i++;
	}

	XtSetArg (args[i], XtNnetDrawTitleBackground,
		  old_drawtitlebackground); i++;

	if (old_titlebackgroundPixmap)
	{
		XtSetArg (args[i], XtNnetTitleBackgroundPixmap,
			  old_titlebackgroundPixmap);
		i++;
	}

	if (old_image)		/* share the image */
	{
		XtSetArg (args[i], XtNnetImage, old_image);
		i++;
	}

	XtSetArg (args[i], XtNwidth, width); i++;
	XtSetArg (args[i], XtNheight, height); i++;

	/*
	 * now add the supplied arguments to the end of the list
	 * so they are seen last - so they may override the copied
	 * values.
	 */
	initial_args_length += i;
	for (j = 0; i < initial_args_length; i++, j++)
		XtSetArg (args[i], initial_args[j].name,
			  initial_args[j].value);

	/*
	 * create the birds eye widget - assume that they want it to
	 * be manged.  They can call XtUnmageWidget() if necessary.
	 */
	birdseye -> birdseye = XtCreateManagedWidget (birdseye_name,
						      netWidgetClass,
						      birdseye_parent,
						      args, i);
	/*
	 * free the argument list - no longer needed
	 */
	XFree ((char *) args);

	/*
	 * add the callbacks that make the thing work
	 */
	BirdsEyeAddCallbacks (birdseye);

	return birdseye;
}

/*
 * function to add callbacks to the widgets involved with the birds
 * eye operations
 */
static void
BirdsEyeAddCallbacks (birdseye)
BirdsEyeData *birdseye;
{
#ifdef OPENLOOK
	XtAddCallback (birdseye -> scrolledwindow, XtNvSliderMoved,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
	XtAddCallback (birdseye -> scrolledwindow, XtNhSliderMoved,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtAddCallback (birdseye -> scrolledwindow, XtNvScrollEvent,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
	XtAddCallback (birdseye -> scrolledwindow, XtNhScrollEvent,
		       (XtCallbackProc) BirdsEyeScrollbarCB, birdseye);
#endif /* HP_WIDGETS */

	XtAddCallback (birdseye -> birdseye, XtNnetProcDrag,
		       (XtCallbackProc) BirdsEyeDragCB, birdseye);
	XtAddCallback (birdseye -> birdseye, XtNnetProcUpdate,
		       (XtCallbackProc) BirdsEyeUpdateCB, birdseye);
	XtAddCallback (birdseye -> netwidget, XtNnetProcUpdate,
		       (XtCallbackProc) BirdsEyeUpdateCB, birdseye);
}

/*
 * callback to be run when the scrolled window scrollbars are moved by
 * the end user.
 */
static void
BirdsEyeScrollbarCB (w, birdseye, call_data)
Widget w;
BirdsEyeData *birdseye;
caddr_t call_data;
{
	netNode node;
	double fx, fy;

	node = *birdseye -> top_node;
	BirdsEyeXY (birdseye -> netwidget, &fx, &fy);
	node.pf.x = fx;
	node.pf.y = fy;
	netUpdateNode ((NetWidget) birdseye -> birdseye, &node, birdseye -> top_node);
}

/*
 * callback to be run when a node is moved by the end user - in either
 * the netwidget or the birds eye.
 */
static void
BirdsEyeUpdateCB (w, birdseye, data)
Widget w;
BirdsEyeData *birdseye;
NetCallbackData *data;
{
	netNode *node;
	netNode *nodetomove;
	netNode nodecopy;

	if (data -> data_type != NETTITLE && data -> data_type != NETSYMBOL)
		return;

	node = data -> selected_node;

	if (node != birdseye -> top_node)
	{
		if (w == birdseye -> netwidget)
		{
			nodetomove = BirdsEyeFindMatchingNewNode (birdseye,
								  node);
			w = birdseye -> birdseye;
		}
		else
		{
			nodetomove = BirdsEyeFindMatchingOldNode (birdseye,
								  node);
			w = birdseye -> netwidget;
		}
		if (nodetomove -> pf.x != node -> pf.x ||
		    nodetomove -> pf.y != node -> pf.y)
		{
			nodecopy = *nodetomove;
			nodecopy.pf.x = node -> pf.x;
			nodecopy.pf.y = node -> pf.y;
			netUpdateNode ((NetWidget) w, &nodecopy, nodetomove);
		}
	}
}

/*
 * callback to be run when the birds eye node is moved by the end user.
 * this function adjust which part of the network widget is curently
 * visible.
 */
static void
BirdsEyeDragCB (w, birdseye, data)
Widget w;
BirdsEyeData *birdseye;
NetCallbackData *data;
{
	netNode *node;
	int i;
	Arg args[16];
	int x;
	int y;
#ifdef OPENLOOK
	Widget hsb, vsb;
	Dimension hextent, vextent;
#else
	int hextent, vextent;
#endif /* OPENLOOK */

	if (data -> data_type != NETTITLE && data -> data_type != NETSYMBOL)
		return;

	node = data -> selected_node;

	if (node != birdseye -> top_node)
		return;

	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNhScrollbar, &hsb); i++;
	XtSetArg (args[i], XtNvScrollbar, &vsb); i++;
	XtSetArg (args[i], XtNviewHeight, &hextent); i++;
	XtSetArg (args[i], XtNviewWidth, &vextent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &hextent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vextent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (birdseye -> scrolledwindow, args, i);

	i = 0;
	x = node -> pf.x * birdseye -> netwidget -> core.width;
	if (x + hextent > birdseye -> netwidget -> core.width)
		x = birdseye -> netwidget -> core.width - hextent;
	y = (1.0 - node -> pf.y) * birdseye -> netwidget -> core.height;
	if (y + vextent > birdseye -> netwidget -> core.height)
		y = birdseye -> netwidget -> core.height - vextent;
#ifdef OPENLOOK
	XtSetArg (args[0], XtNsliderValue, x);
	XtSetValues (hsb, args, 1);
	XtSetArg (args[0], XtNsliderValue, y);
	XtSetValues (vsb, args, 1);
	XtMoveWidget (birdseye -> netwidget, -x, -y);
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderOrigin, x); i++;
	XtSetArg (args[i], XtNvSliderOrigin, y); i++;
	XtSetValues (birdseye -> scrolledwindow, args, i);
#endif /* HP_WIDGETS */
}

/*
 * helper function for changing the title and symbol names
 * in the birds eye widget.
 */
static void
BirdsEyeChangeNames (birdseye, type, title_name, symbol_name)
BirdsEyeData *birdseye;
int type;
char *title_name;
char *symbol_name;
{
	netNode *nodelist;
	netNode *allnodes;
	Arg args[16];
	int i;
	netNode *node;

	i = 0;
	XtSetArg (args[i], XtNnetNodeList, &nodelist); i++;
	XtSetArg (args[i], XtNnetAllNodes, &allnodes); i++;
	XtGetValues (birdseye -> birdseye, args, i);

	if (nodelist)
		node = nodelist;
	else
		node = allnodes;

	if (node == (netNode *) NULL)
		return;

	nodelist = node;
	for (; node != (netNode *) NULL; node = node -> next)
	{
		if (node -> type == NETSYMBOLISPROC &&
		    node -> symbol.draw_proc == BirdsEyeNode)
			continue;
		/* Free the labels - these are copies so use XFree() */
		if (node -> type & NETTITLEISLABEL)
			XFree ((char *) node -> title.label);
		if (node -> type & NETSYMBOLISLABEL)
			XFree ((char *) node -> symbol.label);
		node -> type = type;
		node -> title.name = title_name;
		node -> symbol.name = symbol_name;
	}

	if (XtIsRealized (birdseye -> birdseye) == FALSE)
		return;

	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodelist); i++;
	XtSetValues (birdseye -> birdseye, args, i);
}

/*
 * helper function for allocating colors - repeated as often as
 * possible.
 */
static Pixel
BirdsEyeGetPixel (w, str)
Widget w;
char *str;
{
	XColor xch, xce;
	Display *display = XtDisplay (w);

	if (XAllocNamedColor (display,
			      DefaultColormap (display,
					       DefaultScreen (display)),
			      str,
			      &xch, &xce))
		return xch.pixel;

	return (Pixel) NULL;
}

/*
 * birds eye node function.  This function is used for the node that
 * represents which part of the network widget is curently visible.
 */
static NetDrawProc
BirdsEyeNode (type, w, node, d, xor, clip_rect)
int type;
Widget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	XGCValues xgcvalues;
	static GC gc = NULL;
	static GC xor_gc = NULL;
	static int reference_count = 0;
	GC lgc;
	double fwidth, fheight;
	BirdsEyeData *birdseye = (BirdsEyeData *) node -> application_ptr;

	switch (type)
	{
	case NETPROCINIT:
		reference_count++;
		xgcvalues.function = GXcopy;
		xgcvalues.line_style = LineOnOffDash;
		xgcvalues.foreground = BirdsEyeGetPixel (w, "red");
		if (gc == NULL)
			gc = XCreateGC (XtDisplay (w), XtWindow (w),
					GCFunction | GCLineStyle |
					GCForeground,
					&xgcvalues);
		xgcvalues.function = NET_GXXOR_OP;
		if (xor_gc == NULL)
			xor_gc = XCreateGC (XtDisplay (w), XtWindow (w),
					    GCFunction | GCLineStyle |
					    GCForeground,
					    &xgcvalues);
		node -> s_width = 0;
		break;

	case NETPROCSIZE:
		BirdsEyeSize (birdseye -> scrolledwindow,
			      birdseye -> netwidget, &fwidth, &fheight);
		node -> s.width = fwidth * w -> core.width;
		node -> s.height = fheight * w -> core.height;
		node -> p.x = node -> pf.x * w -> core.width;
		node -> p.y = w -> core.height - node -> pf.y *
			w -> core.height;
		node -> s.x = node -> p.x;
		if (node -> s.x + node -> s.width > w -> core.width)
			node -> p.x = node -> s.x = w -> core.width -
				node -> s.width;
		node -> s.y = node -> p.y;
		if (node -> s.y + node -> s.height > w -> core.height)
			node -> p.y = node -> s.y = w -> core.height -
				node -> s.height;
		break;

	case NETPROCDRAW:
		if (xor)
			lgc = xor_gc;
		else
			lgc = gc;

		if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
		{
			XSetClipRectangles (XtDisplay (w),
					    lgc, 0,0,
					    (XRectangle *) clip_rect,
					    1, YXBanded);
		}

		XDrawRectangle (XtDisplay (w), d, lgc,
				node -> s.x, node -> s.y,
				node -> s.width - 1,
				node -> s.height - 1);

		if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
		{
			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), lgc,
				   GCClipMask, &xgcvalues);
		}
		break;

	case NETPROCPICK:
		{
		NetPickArgs *pick_args = (NetPickArgs *) d;
		
		pick_args -> return_value = PtInRect (pick_args -> p,
						      &node -> s);
		break;
		}

	case NETPROCDESTROY:
		if (--reference_count)
			break;
		if (gc)
		{
			XFreeGC (XtDisplay (w), gc);
			gc = (GC) NULL;
		}
		if (xor_gc)
		{
			XFreeGC (XtDisplay (w), xor_gc);
			xor_gc = (GC) NULL;
		}
		break;
	}
}

static void
netPrintCB (w, net_print_data, call_data)
Widget w;
netPrintData *net_print_data;
caddr_t call_data;
{
	netPrintInPages (net_print_data -> toplevel,
			 net_print_data -> scrolled_window,
			 (NetWidget) net_print_data -> netwidget,
			 net_print_data -> output_filename);
}

static void
netPrintTimeoutProc (env, id)
jmp_buf env;
XtIntervalId id;
{
	longjmp (env, TRUE);
}

static void
netPrintInPages (toplevel, scrolled_window, netwidget, file)
Widget toplevel;
Widget scrolled_window;
NetWidget netwidget;
char *file;
{
	Display *display = XtDisplay (netwidget);
	Window netwindow = XtWindow (netwidget);
	int widget_width = netwidget -> core.width;
	int widget_height = netwidget -> core.height;
	int width;
	int height;
	XImage *image, *sub_image;
	int x, y;
	int image_width, image_height;
	int pixmap_type;
	Position original_x, original_y;
	Arg args[4];
#ifdef OPENLOOK
	Dimension horizontal_extent, vertical_extent;
#else
	int horizontal_extent, vertical_extent;
#endif /* OPENLOOK */
	Dimension border_width;
	int i;
	jmp_buf env;
	XtAppContext application_context;
	XtIntervalId timeout_id;
	XWindowAttributes window_attributes;
	int screen = DefaultScreen (display);
	/* allocate space for file.x.y.ps: file.000.000.ps\0 */
	char *output_file = XtMalloc (strlen (file) + 4 + 4 + 3 + 1);
	int plate_x, plate_y;

	/*
	 * raise the window and wait for it to happen
	 */
	XRaiseWindow (display, XtWindow (toplevel));

	application_context = XtWidgetToApplicationContext (toplevel);
	timeout_id = XtAppAddTimeOut (application_context, 1 * 1000,
			      (XtTimerCallbackProc) netPrintTimeoutProc,
				      (XtPointer) env);
	if (setjmp (env) == FALSE)
	{
		XEvent event;

		for (;;)
		{
			XtAppNextEvent (application_context, &event);
			XtDispatchEvent (&event);

			if (event.type == ConfigureNotify ||
			    event.type == Expose)
			{
				XtRemoveTimeOut (timeout_id);

				while (XtAppPending (application_context) &
				       XtIMXEvent)
				{
					XtAppNextEvent (application_context,
							&event);
					XtDispatchEvent (&event);
				}
				break;
			}
		}
	}

	/*
	 * Grab the server so that nothing writes over our window
	 */
	XGrabServer (display);

	/*
	 * get the visible width and height from the scrolled window
	 */
	i = 0;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNviewHeight, &horizontal_extent); i++;
	XtSetArg (args[i], XtNviewWidth, &vertical_extent); i++;
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	XtSetArg (args[i], XtNhSliderExtent, &horizontal_extent); i++;
	XtSetArg (args[i], XtNvSliderExtent, &vertical_extent); i++;
#endif /* HP_WIDGETS */

	XtGetValues (scrolled_window, args, i);

	if (XGetWindowAttributes (display, netwindow, &window_attributes) ==
	    True)
		border_width = window_attributes.border_width;
	else
		border_width = 0;

	width = horizontal_extent - border_width - 1;
	if (width > widget_width)
		width = widget_width;

	height = vertical_extent - border_width - 1;
	if (height > widget_height)
		height = widget_height;

	/*
	 * create an image for getting the less than full size snap shots
	 */
	sub_image = netCreateImage (display, width, height);
	if (sub_image == (XImage *) NULL)
	{
		XUngrabServer (display);
		return;
	}

	/*
	 * determine the pixmap type for the XGetImage() calls
	 */
	pixmap_type = ((DefaultDepth (display, screen) > 1) ?
		       ZPixmap : XYPixmap);

	/*
	 * save the initial location of the window
	 */
	i = 0;
	XtSetArg (args[i], XtNx, &original_x); i++;
	XtSetArg (args[i], XtNy, &original_y); i++;
	XtGetValues ((Widget) netwidget, args, i);

	/*
	 * print it out in newspaper like columns
	 *	top to bottom then left to right
	 */
	for (plate_x = 0, x = 0; x < widget_width; x += width, plate_x++)
	{
		if (x + width > widget_width)
			image_width = widget_width - x;
		else
			image_width = width;

		for (plate_y = 0, y = 0; y < widget_height;
		     y += height, plate_y++)
		{
			if (y + height > widget_height)
				image_height = widget_height - y;
			else
				image_height = height;
			
			netMoveTheWindow ((Widget) netwidget, scrolled_window,
					  x, y, image_width, image_height);

			image = XGetImage (display, netwindow,
					   x, y,
					   image_width, image_height,
					   AllPlanes, pixmap_type);

			if (image == (XImage *) NULL)
			{
				fprintf (stderr,
					 "Could not get an image.\n");
				continue;
			}

			/*
			 * XGetSubImage() is too slow - do it by hand
			 */
			if (image_height != height || image_width != width)
			{
				char *image_data = image -> data;
				char *sub_image_data = sub_image -> data;
				int depth = image -> depth;
				int byte_width =
					(image -> width * depth + 7) / 8;
				int byte_width_unrounded;
				int mask;

				if (depth < 8)
				{
					byte_width_unrounded = (image -> width * depth) / 8;
					mask = ~((1 << (8 - (depth * image -> width & 07))) - 1);
				}

				for (i = 0; i < image -> height; i++)
				{
					if (depth < 8 &&
					    byte_width != byte_width_unrounded)
						image_data[byte_width_unrounded] &= mask;
					bcopy (image_data, sub_image_data,
					       byte_width);

					bzero (sub_image_data + byte_width,
					       sub_image -> bytes_per_line -
					       byte_width);

					image_data += image -> bytes_per_line;
					sub_image_data +=
						sub_image -> bytes_per_line;
				}

				bzero (sub_image_data,
				       (sub_image -> height - i) *
				       sub_image -> bytes_per_line);

				(*image -> f.destroy_image) (image);
				image = sub_image;
			}

#ifdef DebuggingImagestoPost
			XPutImage (display,
				   RootWindow (display,
					       DefaultScreen (display)),
				   DefaultGC (display,
					      DefaultScreen (display)),
				   image,
				   0, 0, 0, 0,
				   image -> width, image -> height);
#endif

			/* file.x.y.ps: file.000.000.ps\n */
			sprintf (output_file, "%s.%d.%d.ps",
				 file, plate_x, plate_y);
			ImageToPostScriptFile (display, image,
					    DefaultColormap (display, screen),
					       output_file);

			if (image != sub_image)
				(*image -> f.destroy_image) (image);
		}
	}


	/*
	 * release the server
	 */
	XUngrabServer (display);

	/*
	 * free the sub-image cache
	 */
	(*sub_image -> f.destroy_image) (sub_image);

	/*
	 * restore the screen
	 */
	x = abs ((int) original_x);
	y = abs ((int) original_y);
	if (x + width > widget_width)
		image_width = widget_width - x;
	else
		image_width = width;

	if (y + height > widget_height)
		image_height = widget_height - y;
	else
		image_height = height;
		
	netMoveTheWindow ((Widget) netwidget, scrolled_window,
			  x, y, 0, 0);
}

static void
netMoveTheWindow (netwidget, scrolled_window, x, y, width, height)
Widget netwidget;
Widget scrolled_window;
int x, y;
int width, height;
{
	Arg args[2];
	XExposeEvent expose_event;

	XtMoveWidget (netwidget, -x, -y);

	if (width < 1 || height < 1)
		return;

	expose_event.type = Expose;
	expose_event.x = x;
	expose_event.y = y;
	expose_event.width = width;
	expose_event.height = height;
	netShowNetwork ((NetWidget) netwidget, &expose_event);
}

static void
PseudoMapToGreyMap (colors, greymap, size)
XColor *colors;
unsigned char *greymap;
int size;
{
	XColor *cptr = colors;
	unsigned char *gptr = greymap;
	unsigned long grey;
	int i;

	for (i = 0; i < size; i++)
	{
		grey = ((cptr -> red >> 8) & 255) * 77 +
			((cptr -> green >> 8) & 255) * 151 +
				((cptr -> blue >> 8) & 255) * 28;
		*gptr++ = grey >> 8;
		cptr++;
	}
}

static char *post_script_uncompress[] =
{
"",
"/image-check-each-character % stack: character",
"{",
"	dup 170 eq % look for AA",
"	{",
"		/image-duplicate-character-flag true def pop",
"	}",
"	{",
"		image-buffer image-character-position 3 -1 roll put",
"		/image-character-position image-character-position 1 add def",
"	} ifelse",
"} def",
"",
"/image-create-run % stack: length",
"{",
"	image-character-position add dup",
"	image-character-position 1 3 -1 roll",
"	{",
"		image-buffer exch image-run-character put",
"	} for",
"	/image-character-position exch def",
"} def",
"",
"/image-recursive-create-run % stack: length",
"{",
"	dup cvi 1 cvi and exch",
"	cvi -1 cvi bitshift dup",
"	3 -1 roll add dup",
"	4 gt",
"	{",
"		image-recursive-create-run",
"	} %else",
"	{",
"		image-create-run",
"	} ifelse",
"	dup dup",
"	image-buffer image-character-position",
"	image-buffer image-character-position 5 -1 roll sub 6 -1 roll",
"	getinterval putinterval",
"	/image-character-position exch image-character-position add def",
"} def",
"",
"/image-read-compressed",
"{",
"	/image-character-position 0 def",
"	currentfile image-read-buffer readhexstring pop",
"	{",
"		image-duplicate-character-flag",
"		{",
"			image-create-run-flag",
"			{",
"				image-recursive-create-run",
"				/image-duplicate-character-flag false def",
"				/image-create-run-flag false def",
"			} % else",
"			{",
"				/image-run-character exch def",
"				/image-create-run-flag true def",
"			} ifelse",
"		} % else",
"		{",
"			image-check-each-character",
"		} ifelse",
"	} forall",
"	% trim unused space from the end of image-buffer",
"	image-buffer 0 image-character-position getinterval",
"} def",
"",
"/image-process % stack: width, height",
"{",
"	/image-depth exch def",
"	/image-height exch def",
"	/image-width exch def",
"",
"	% allocate space for one line of input",
"	/image-read-buffer 36 string def",
"",
"	% must be at least 255 * 36 / 3 bytes",
"	/image-buffer 3072 string def",
"",
"	% flags",
"	/image-duplicate-character-flag false def",
"	/image-create-run-flag false def",
"",
"	% read and dump the image",
"	image-width image-height image-depth",
"		[image-width 0 0 image-height neg 0 image-height]",
"		{ image-read-compressed } image",
"} def",
(char *) NULL
};

#define PRINT_LINE_WIDTH	72

#define PRINT_HEX(fp, char_to_print, byte_count) \
{						 \
	fprintf (fp, "%02x", char_to_print);	 \
	byte_count += 2;			 \
	if (byte_count == PRINT_LINE_WIDTH)	 \
	{					 \
		fprintf (fp, "\n");		 \
		byte_count = 0;			 \
	}					 \
}

#define PRINT_COMPACT(fp, c, last_c, c_count, byte_count)		\
{									\
	if (c_count == 0)						\
	{								\
		c_count = 1;						\
		last_c = c;						\
	}								\
	else if (c == last_c)						\
	{								\
		if (c_count == 255)					\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
			c_count = 1;					\
		}							\
		else							\
			c_count++;					\
	}								\
	else								\
	{								\
		if (last_c == 0xAA || c_count > 3)			\
		{							\
			PRINT_HEX(fp, 0xAA, byte_count);		\
			PRINT_HEX(fp, last_c, byte_count);		\
			PRINT_HEX(fp, c_count, byte_count);		\
		}							\
		else							\
		{							\
			for (c_index = 0; c_index < c_count; c_index++)	\
				PRINT_HEX(fp, last_c, byte_count);	\
		}							\
		c_count = 1;						\
		last_c = c;						\
	}								\
}									\

static int
ImageToPostScriptFile (display, image, colormap, output_file)
Display *display;
XImage *image;
Colormap colormap;
char *output_file;
{
	FILE *fp;
	XColor *colors = (XColor *) NULL;
	unsigned char *greymap;
	int i, j;
	int width, depth;
	int cmap_size;
	unsigned char *data_ptr;
	long clock;
	double aspect_ratio, pict_x_min, pict_y_min, pict_width, pict_height;
	unsigned char last_c;
	int c_count = 0;
	int byte_count = 0;
	int c_index;
	unsigned char c;
	char **ptr;

	if ((fp = fopen (output_file, "w")) == NULL)
	{
		fprintf (stderr, "Cannot open the file: %s\n", output_file);
		return FALSE;
	}

	switch (image -> depth)
	{
	default:	/* make all pixmaps 8 bits deep */
	case 8:
		cmap_size = 1 << image -> depth;
		greymap = (unsigned char *) XtMalloc (sizeof (XColor) *
						      cmap_size + cmap_size);
		colors = (XColor *) greymap;
		greymap += (sizeof (XColor) * cmap_size);
		for (i = 0; i < cmap_size; i++)
			colors[i].pixel = i;
		XQueryColors (display, colormap, colors, cmap_size);
		PseudoMapToGreyMap (colors, greymap, cmap_size);
		width = image -> width;
		depth = 8;
		break;
	case 1:
		width = (image -> width + 7) / 8;
		depth = 1;
		break;
	}

	fprintf (fp, "%%!\n");
	fprintf (fp, "%%%%Title: %s\n", output_file);
	fprintf (fp, "%%%%Creator: X11 screen dump\n");
	time (&clock);
	fprintf (fp, "%%%%CreationDate: %s", ctime (&clock));
	fprintf (fp, "%%%%BoundingBox: 0 0 %d %d\n",
		 image -> width, image -> height);
	fprintf (fp, "%%%%Pages: (atend)\n");
	fprintf (fp, "%%%%EndComments\n");

	/* center on the page with .5 inch margin - Jonathan Shopiro */
	aspect_ratio = (float) image -> width / (float) image -> height;
	if (aspect_ratio < .75)
	{			/* tall & narrow */
		pict_width = 10 * aspect_ratio;  /* inches */
		pict_height = 10;
		pict_x_min = (8.5 - pict_width) / 2;
		pict_y_min = .5;
	}
	else
	{			/* short & wide */
		pict_width = 7.5;
		pict_height = 7.5 / aspect_ratio;
		pict_x_min = .5;
		pict_y_min = (11 - pict_height) / 2;
	}
	/*
	 * centered image translate and scale
	 */
	fprintf (fp, "\n");
	fprintf (fp, "%s\n", "%%%");
	fprintf (fp, "%s\n", "%%% centered image");
	fprintf (fp, "%s\n", "%%%");
	fprintf (fp, "%% /inch {72 mul} def\n");
	fprintf (fp, "%% %f inch %f inch translate\n", pict_x_min, pict_y_min);
	fprintf (fp, "%% %f inch %f inch scale\n", pict_width, pict_height);
		
	/*
	 * encapulated image translate and scale
	 */
	fprintf (fp, "\n");
	fprintf (fp, "%s\n", "%%%");
	fprintf (fp, "%s\n", "%%% encapsulated image");
	fprintf (fp, "%s\n", "%%%");
	fprintf (fp, "0 0 translate\n");
	fprintf (fp, "%d %d scale\n", image -> width, image -> height);

	/*
	 * print out the PostScript de-compression code
	 */
	ptr =  post_script_uncompress;
	while (*ptr)
		fprintf (fp, "%s\n", *ptr++);

	/*
	 * print out the PostScript command to read in the image data
	 */
	fprintf (fp, "\n");
	fprintf (fp, "%d %d %d image-process\n",
		 image -> width, image -> height, depth);
		 
	switch (image -> depth)
	{
	case 8:
		for (data_ptr = (unsigned char *) image -> data, i = 0;
		     i < image -> height; i++)
		{
			for (j = 0; j < width; j++)
			{
				c = greymap[*data_ptr++];
				PRINT_COMPACT(fp, c, last_c, c_count,
					      byte_count);
			}

			data_ptr = (unsigned char *) image -> data +
				image -> bytes_per_line * i;
		}
		break;

	case 1:
		for (data_ptr = (unsigned char *) image -> data, i = 0;
		     i < image -> height; i++)
		{
			for (j = 0; j < width; j++)
			{
				c = ~(*data_ptr++) & 0377;
				PRINT_COMPACT(fp, c, last_c, c_count,
					      byte_count);
			}
			data_ptr = (unsigned char *) image -> data +
				image -> bytes_per_line * i;
		}
		break;

	default:
		for (data_ptr = (unsigned char *) image -> data, i = 0;
		     i < image -> height; i++)
		{
			for (j = 0; j < width; j++)
			{
				c = greymap[XGetPixel (image, j, i)];
				PRINT_COMPACT(fp, c, last_c, c_count,
					      byte_count);
			}
			data_ptr = (unsigned char *) image -> data +
				image -> bytes_per_line * i;
		}
		break;
	}

	if (last_c == 0xAA || c_count > 3)
	{
		PRINT_HEX(fp, 0xAA, byte_count);
		PRINT_HEX(fp, last_c, byte_count);
		PRINT_HEX(fp, c_count, byte_count);
	}
	else
	{
		for (c_index = 0; c_index < c_count; c_index++)
		{
			PRINT_HEX(fp, last_c, byte_count);
		}
	}
	while (byte_count < PRINT_LINE_WIDTH)
	{
		fprintf (fp, "0");
		byte_count++;
	}

	fprintf (fp, "\nshowpage\n");
	XFree ((char *) colors);
	return (fclose (fp) == 0);
}
#endif /* ! MOTIF */
