static char TMxnet12_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#include <Xol/BulletinBo.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static int
nodes_overlap C_P_ARGS((netNode *nodes));

C_PROTOS_END_EXTERN

void
main (argc, argv)
int argc;
char **argv;
{
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Widget toplevel, scrolledwindow, netwidget;
	Pixmap background_pixmap;
	int width, height;

#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	XtSetArg (args[i], XtNrecomputeWidth, False); i++;
	XtSetArg (args[i], XtNrecomputeHeight, False); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	nodes[0].type = NETBOXSYMBOL;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = (char *) NULL;
	nodes[0].symbol.name = "1";
	nodes[0].next = &nodes[1];

	nodes[1].type = NETBOXSYMBOL;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = (char *) NULL;
	nodes[1].symbol.name = "1.1";
	nodes[1].next = &nodes[2];

	nodes[2].type = NETBOXSYMBOL;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = (char *) NULL;
	nodes[2].symbol.name = "1.2";
	nodes[2].next = &nodes[3];

	nodes[3].type = NETBOXSYMBOL;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = (char *) NULL;
	nodes[3].symbol.name = "1.1.1";
	nodes[3].next = &nodes[4];

	nodes[4].type = NETBOXSYMBOL;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = (char *) NULL;
	nodes[4].symbol.name = "1.1.2";
	nodes[4].next = &nodes[5];

	nodes[5].type = NETBOXSYMBOL;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "1.1.2.1";
	nodes[5].next = (netNode *) NULL;

	links[0].type = 0;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = &links[1];

	links[1].type = 0;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = &links[2];

	links[2].type = 0;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = &links[3];

	links[3].type = 0;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = &links[4];

	links[4].type = 0;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	width = height = 16;
	XtSetArg (args[i], XtNwidth, width); i++;
	XtSetArg (args[i], XtNheight, height); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;

	netwidget = XtCreateWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

	while (nodes_overlap (nodes))
	{
		width <<= 1;
		height <<= 1;
		XtSetArg (args[0], XtNwidth, width);
		XtSetArg (args[1], XtNheight, height);
		XtSetValues (netwidget, args, 2);
	}

	XtManageChild (netwidget);

	XtMainLoop ();
}

static int
nodes_overlap (nodes)
netNode *nodes;
{
	netNode *node, *comp_node;
	netXSRectangle node_rect, comp_node_rect;

	node = nodes;
	while (node)
	{
		netGetNodeRect (node, &node_rect);
		comp_node = node -> next;
		while (comp_node)
		{
			if (RectXRect (&node_rect,
				       netGetNodeRect (comp_node,
						       &comp_node_rect)))
				return TRUE;
			comp_node = comp_node -> next;
		}
		node = node -> next;
	}
	return FALSE;
}
