static char TMxnet10_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"
#include "NetP.h"
#include <math.h>

#define MAX(a,b)	((a > b) ? a : b)
#define MIN(a,b)	((a < b) ? a : b)

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static Pixmap
BitmapToPixmap C_P_ARGS((Display *display, Pixmap bitmap,
			 Pixel foreground, Pixel background,
			 unsigned int width, unsigned int height));

C_PROTOS_END_EXTERN

void
main (argc, argv)
int argc;
char **argv;
{
	extern NetDrawProc link_draw_proc ();
	extern Pixmap BitmapToPixmap ();
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLabel labels[6];
	Arg args[10];
	int i;
	Widget toplevel, scrolledwindow, netwidget;

#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	{
		Display *display = XtDisplay (toplevel);
		int screen = DefaultScreen (display);
		Window root = RootWindow (display, screen);
		static unsigned int width, height;
		int x_hot, y_hot;
		Pixel black = BlackPixel (display, screen);
		Pixel white = WhitePixel (display, screen);
		Pixmap pixmap, bitmap;
		Pixmap background;
		char *filename = "einstein.x";

		background = XwCreateTile (XtScreen (toplevel),
					   white, black, XwSLANT_LEFT);

		if (XReadBitmapFile (display, root, filename,
				     &width, &height, &bitmap,
				     &x_hot, &y_hot) !=
		    BitmapSuccess)
		{
			fprintf (stderr,
				 "Cannot read the bitmap file: %s.\n",
				 filename);
			exit (1);
		}

		pixmap = BitmapToPixmap (display, bitmap,
					 black, white,
					 width, height);

		XFreePixmap (display, bitmap);
		
		filename = "einstein.mask.x";
		if (XReadBitmapFile (display, root, filename,
				     &width, &height, &bitmap,
				     &x_hot, &y_hot) !=
		    BitmapSuccess)
		{
			fprintf (stderr,
				 "Cannot read the bitmap file: %s.\n",
				 filename);
			exit (1);
		}

		for (i = 0; i < 6; i++)
		{
			bzero (&labels[i], sizeof (netLabel));

			labels[i].type =  NETBGSUPPLIED |
				NETPIXMAP | NETBOXSYMBOL;
			labels[i].box_background = background;
			labels[i].pixmap = pixmap;
			labels[i].pixmap_mask = bitmap;

			bzero (&nodes[i], sizeof (netNode));
			nodes[i].type = NETSYMBOLISLABEL;
			nodes[i].symbol.label = &labels[i];
			nodes[i].title.name = (char *) NULL;
			nodes[i].next = &nodes[i + 1];
		}
		nodes[5].next = (netNode *) NULL;
	}
			
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].symbol.label -> name = (char *) NULL /* "1" */;

	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].symbol.label -> name = "1.1";

	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].symbol.label -> name = "1.2";

	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].symbol.label -> name = "1.1.1";

	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].symbol.label -> name = "1.1.2";

	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].symbol.label -> name = "1.1.2.1";

	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

	XtMainLoop ();
}

static Pixmap
BitmapToPixmap (display, bitmap, foreground, background, width, height)
Display *display;
Pixmap bitmap;
Pixel foreground;
Pixel background;
unsigned int width;
unsigned int height;
{
	Pixmap pixmap;
	int screen = DefaultScreen (display);
	int depth = DefaultDepth (display, screen);
	Window root = RootWindow (display, screen);
	GC gc;
	XGCValues gcvalues;

	pixmap = XCreatePixmap (display, root, width, height, depth);
	
	if (pixmap == (Pixmap) NULL)
		return pixmap;

	gcvalues.function = GXcopy;
	gcvalues.foreground = foreground;
	gcvalues.background = background;
	gc = XCreateGC (display, root,
			GCFunction | GCForeground | GCBackground,
			&gcvalues);

	XCopyPlane (display, bitmap, pixmap, gc,
		    0, 0, width, height, 0, 0, 1L);
	
	XFreeGC (display, gc);

	return (pixmap);
}
