static char TMnetUpLnk_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netUpdateLink C_P_ARGS((NetWidget w, netLink *new_link, netLink *src_link));

C_PROTOS_END_EXTERN

void
netUpdateLink (w, new_link, src_link)
NetWidget w;
netLink *new_link;
netLink *src_link;
{
	XExposeEvent expose_event;
	register netNode *node;
	register netLink *link;
	netXSRectangle n;
	netXSRectangle t;
	Widget rw = (Widget) w;
	Window window = XtWindow (rw);
	int mark;

	if (new_link == NULL)
	    return;

	/* START HGK additions - 3/12/91 */
	if (!XtIsRealized(rw)) {
		new_link -> next = src_link -> next;
		*src_link = *new_link;
		return;
	}
	/* END HGK additions */

	/*
	 * mark the new link to be redrawn
	 */
	src_link -> type |= NETMARKBIT;
	n = src_link -> l;
	if ((src_link -> A != new_link -> A &&
	     (src_link -> A -> pf.x != new_link -> A -> pf.x ||
	      src_link -> A -> pf.y != new_link -> A -> pf.y))  ||
	    (src_link -> B != new_link -> B &&
	     (src_link -> B -> pf.x != new_link -> B -> pf.x ||
	      src_link -> B -> pf.y != new_link -> B -> pf.y)))
		new_link -> type |= (NETMARKBIT | NETMOVED);
	else
		new_link -> type |= NETMARKBIT;

	if (w -> net.do_updates == True)
	{
	    if (n.x < 0)
	    {
		n.width += n.x;
		n.x = 0;
	    }
	    if (n.y < 0)
	    {
		n.height += n.y;
		n.y = 0;
	    }
	    
	    /*
	     * find the links that are in this rectangle
	     */
	    link = w -> net.Link_List;
	    while (link)
	    {
		if (link -> type & NETMARKBIT)
		{
		    link = link -> next;
		    continue;
		}
		
		if (RectXRect (&n, &link -> l))
		    link -> type |= NETMARKBIT;
		
		link = link -> next;
	    }
	    
	    expose_event.type = Expose;
	    expose_event.x = n.x;
	    expose_event.y = n.y;
	    expose_event.width = n.width;
	    expose_event.height = n.height;
	    netShowNetworkBackground (w, &expose_event, FALSE);
	}

	netInitializeLink (w, new_link);
	netSetLinkRect (w, new_link);
	new_link -> next = src_link -> next;
	*src_link = *new_link;

	link = w -> net.Link_List;
	mark = FALSE;
	while (link)
	{
		if (link -> type & NETMARKBIT)
		{
			if (link -> type & NETMOVED)
			{
				netSetLinkRect (w, link);
				netDrawLink (w, link, window, FALSE,
					      (netXSRectangle *) NULL);
				if (mark)
				{
					MergeRects (&t, &link -> l);
				}
				else
				{
					t = link -> l;
					mark = TRUE;
				}
			}
			else
				netDrawLink (w, link, window, FALSE, &n);

			link -> type &= ~(NETMARKBIT | NETMOVED);
		}
		link = link -> next;
	}

	if (w -> net.do_updates == False)
	    return;

	if (mark && RectXRect (&n, &t))
	{
		MergeRects (&n, &t);
		mark = FALSE;
	}

	node = w -> net.Node_List;
	while (node)
	{
		if (mark)
		{
			if (RectXRect (&node -> s, &t))
				netDrawSymbol (w, node, window, FALSE, &t);
			
			if (RectXRect (&node -> t, &t))
				netDrawTitle (w, node, window, FALSE, &t);
		}
		if (RectXRect (&node -> s, &n))
			netDrawSymbol (w, node, window, FALSE, &n);

		if (RectXRect (&node -> t, &n))
			netDrawTitle (w, node, window, FALSE, &n);

		node = node -> next;
	}
}
