static char TMnetRmvLnk_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netRemoveLink C_P_ARGS((NetWidget w, netLink *old_link));

C_PROTOS_END_EXTERN

void
netRemoveLink (w, old_link)
NetWidget w;
netLink *old_link;
{
	Widget rw = (Widget) w;
	Window window = XtWindow (rw);
	XExposeEvent expose_event;
	register netNode *node;
	register netLink *link;
	netLink *link_previous, *link_temp;
	netXSRectangle n;
	netXSRectangle t;

	if (old_link == NULL)
	    return;

	/* BEGIN HGK changes - 5/24/90 */
	if (XtIsRealized(rw))
		link = w -> net.Link_List;
	else
		link = w -> net.linklist;
	
	link_previous = (netLink *) NULL;
	while (link && link != old_link) {
		link_previous = link;
		link = link -> next;
	}
	/* END HGK changes */
	
	if (link == NULL)
	{
		XtWarning ("Cannot find link to be removed.");
		old_link -> next = (netLink *) NULL;
		return;
	}

	/* BEGIN HGK changes - 5/24/90 */
	if (!XtIsRealized(rw)) {
		if (link_previous) {
			link_previous->next = link->next;
		} else {
			w->net.linklist = link->next; /* remove first link */
		}
		
		return; /* DONE */
	}
	/* END HGK changes */

	/* else widget is realized */
	old_link -> type |= (NETMARKBIT | NETMOVED);

	if (w -> net.do_updates == True)
	{
	    n = old_link -> l;
	    
	    if (n.x < 0)
	    {
		n.width += n.x;
		n.x = 0;
	    }
	    if (n.y < 0)
	    {
		n.height += n.y;
		n.y = 0;
	    }
	    
	    expose_event.type = Expose;
	    expose_event.x = n.x;
	    expose_event.y = n.y;
	    expose_event.width = n.width;
	    expose_event.height = n.height;
	    netShowNetworkBackground (w, &expose_event, FALSE);
	}

	link_previous = (netLink *) NULL;
	link = w -> net.Link_List;
	while (link)
	{
		if (link -> type & NETMOVED)
		{
			if (link_previous)
				link_previous -> next = link -> next;
			else
				w -> net.Link_List = link -> next;
			link_temp = link -> next;

			link -> type &= ~(NETMARKBIT | NETMOVED);
			netDestroyLink (w, link);

			link = link_temp;
			continue;
		}

		if (w -> net.do_updates == True &&
		    RectXRect (&n, &link -> l))
			netDrawLink (w, link, window, FALSE, &n);

		link_previous = link;
		link = link -> next;
	}

	if (w -> net.do_updates == False)
	    return;

	node = w -> net.Node_List;
	while (node)
	{
		if (RectXRect (&n, &node -> s))
			netDrawSymbol (w, node, window, FALSE, &n);
		if (RectXRect (&n, &node -> t))
			netDrawTitle (w, node, window, FALSE, &n);

		node = node -> next;
	}
}
