static char TMSetupPolys_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include "Net.h"
#include "string.h"
#include <fcntl.h>
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern int
SetupPolygons C_P_ARGS((char *inputfile, netMapPolygon **maps));

static netMapPolygon *
ReadMapBin C_P_ARGS((int fd));

static netMapPolygon *
ReadMapAscii C_P_ARGS((char *file));

C_PROTOS_END_EXTERN

#define NextWord(x)     (((x) + 3) & (~03))


/*
 * this is a sample polygon reading routine.  Applications may wish to
 * substitute their own reader.  To do that wrtie a routine that replaces
 * SetupPolygons ().
 */

int
SetupPolygons (inputfile, maps)
char *inputfile;
netMapPolygon **maps;
{
	FILE *fp;
	int fd;
	int len;
        netMapPolygon *mp, *mpc, *mp_first, *mp_last;
	unsigned char buf[BUFSIZ];
	unsigned char *ptr;

	if ((fp = fopen (ExpandFileName (inputfile), "r")) == NULL)
	{
                XtWarning ("NetWidget: Cannot open polygon file for reading.");
                return FALSE;
	}

        mp_first = mp_last = (netMapPolygon *) NULL;
	while (fgets ((char *) buf, BUFSIZ, fp) != NULL)
	{
		ptr = buf;
		while (*ptr && *ptr != ' ' && *ptr != '\t')
			ptr++;

		while (*ptr && (*ptr == ' ' || *ptr == '\t'))
			*ptr++ = '\0';

		if (*ptr < ' ' || *ptr > 127)
		{
			XtWarning ("NetWidget: There is an error in polygon list file.");
			fclose (fp);
			return FALSE;
		}

		len = strlen ((char *) ptr) - 1;
		if (ptr[len] == '\n')
			ptr[len] = '\0';

		if ((fd = open (ExpandFileName ((char *)buf), O_RDONLY)) == -1)
		{
			fprintf (stderr, "NetWidget: cannont open file: %s\n",
				 ExpandFileName ((char *) buf));
			continue;
		}

		/*
		 * Will now read binary map polygon file - and loops through
		 * the polygon list file to read until EOF
		 */
		while ((mp = ReadMapBin (fd)) != NULL)
		{
			if (mp_first == NULL)
				mp_first = mp;
			if (mp_last)
				mp_last -> next = mp;
			else
				mp_last = mp;
			mpc = mp;
			while (mpc)
			{
				mp_last = mpc;
				mpc -> color =
				    (char *) XtNewString ((char *) ptr);
				mpc = mpc -> next;
			}
		}

		close (fd);
	}
	*maps = mp_first;
	fclose (fp);

	if (mp_first == NULL)
		return FALSE;
	else
		return TRUE;
}

static netMapPolygon *
ReadMapBin (fd)
int	fd;
{
	netMapPolygon *mp;
	netMapPolygon *mptop;
	netXFPoint *pf;
	int npoints;
	int XFPoint_size;

	if (read(fd, (char *)&npoints, sizeof(int)) <= 0)
	    return NULL;

	XFPoint_size = sizeof(netXFPoint) * npoints;

	mptop = mp = (netMapPolygon *) XtMalloc (sizeof (netMapPolygon));

	pf = (netXFPoint *) XtMalloc (XFPoint_size);

	mp -> p = (XPoint *) XtMalloc (sizeof (XPoint) * npoints);

	mp -> points = pf;
	mp -> npoints = npoints;

	if (read(fd, pf, XFPoint_size) <= 0)
		return NULL;

	mp->next = NULL;

	return mptop;
}

#ifdef OLD_ReadMapAscii
/* Previous routine that reads ascii polygon file */

static netMapPolygon *
ReadMapAscii (file)
char *file;
{
	FILE *fp;
	netMapPolygon *mp, *mp2;
	netMapPolygon *mptop;
	int npoints;
	int eof;
	int op;
	int new;
	char buf[BUFSIZ];
	int i;
	float x, y;

	if ((fp = fopen (ExpandFileName (file), "r")) == NULL)
		return (netMapPolygon *) NULL;

	npoints = 0;
	while (fgets (buf, BUFSIZ, fp) != NULL)
	{
		if (strncmp (buf, "#define TOTAL_COOR ", 19) == 0)
		{
			npoints = atoi (&buf[19]);
			break;
		}
	}
	if (npoints < 1)
	{
		fclose (fp);
		return (netMapPolygon *) NULL;
	}
	if ((mp = (netMapPolygon *) malloc (sizeof (netMapPolygon))) == NULL)
	{
		fclose (fp);
		return (netMapPolygon *) NULL;
	}
	mptop = mp;
	mp -> points = (netXFPoint *) malloc (sizeof (netXFPoint) * npoints);
	mp -> p = (XPoint *) malloc (sizeof (XPoint) * npoints);
	if (mp -> points  == NULL || mp -> p == NULL)
	{
		XFree (mp -> points);
		XFree (mp -> p);
		XFree (mp);
		fclose (fp);
		return (netMapPolygon *) NULL;
	}

	eof = TRUE;
	while (fgets (buf, BUFSIZ, fp) != NULL)
	{
		if (strncmp (buf, "COOR US[]= {", 12) == 0)
		{
			eof = FALSE;
			break;
		}
	}
	if (eof)
	{
		XFree (mp);
		fclose (fp);
		return (netMapPolygon *) NULL;
	}

	mp -> npoints = 0;
	mp -> next = (netMapPolygon *) NULL;
	new = FALSE;
	for (i = 0; i < npoints; i++)
	{
		if (fscanf (fp, "%d,%f,%f,\n", &op, &x, &y) != 3)
			break;

		if (op == 1)
		{
			new = TRUE;
			continue;
		}
		if (op == 2)
		{
			if (new)
			{
				new = FALSE;
				/* assume that realloc() smaller always wins */
				mp -> points = (netXFPoint *)
					realloc (mp -> points,
						 sizeof (netXFPoint) *
						 mp -> npoints);
				mp -> p = (XPoint *)
					realloc (mp -> p,
						 sizeof (XPoint) *
						 mp -> npoints);

				if ((mp2 = (netMapPolygon *)
				     malloc (sizeof (netMapPolygon))) != NULL)
				{
					mp2 -> points = (netXFPoint *) 
						malloc (sizeof (netXFPoint) *
							npoints - i);
					mp2 -> p = (XPoint *) 
						malloc (sizeof (XPoint) *
							npoints - i);
				}
				if (mp2 != NULL && mp2 -> points != NULL &&
				    mp2 -> p != NULL)
				{
					mp -> next = mp2;
					mp = mp -> next;
					mp -> npoints = 0;
					mp -> next = (netMapPolygon *) NULL;
				}
				else
				{
					XFree (mp2 -> points);
					XFree (mp2 -> p);
					XFree (mp2);
					mp = mptop;
					while (mp)
					{
						XFree (mp -> points);
						XFree (mp -> p);
						mp2 = mp -> next;
						XFree (mp);
						mp = mp2;
					}
					fclose (fp);
					return (netMapPolygon *) NULL;
				}
			}
			mp -> points[mp -> npoints].x = x;
			mp -> points[mp -> npoints].y = y;
			mp -> npoints++;
		}
	}

	fclose (fp);
	return mptop;
}
#endif
