static char TMNet_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
/*
#include <X11/keysymdef.h>
*/
#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

/*
 * Xt widget definition routines - in the order they appear in NetClassRec
 */
static void
netClassInitialize C_P_NO_ARGS();

static void
netInitialize C_P_ARGS((NetWidget request, NetWidget new, ArgList args,
			Cardinal * num_args));

static void
netRealize C_P_ARGS((NetWidget w, Mask *valueMask,
		     XSetWindowAttributes *attributes));

static void
netDestroy C_P_ARGS((NetWidget w));

static void
netResize C_P_ARGS((NetWidget w, XtWidgetGeometry geometry));

static void
netRedisplay C_P_ARGS((NetWidget w, XExposeEvent *event));

static Boolean
netSetValues C_P_ARGS((NetWidget current, NetWidget request,
		       NetWidget new_widget, ArgList args,
		       Cardinal *num_args));
/*
 * utitity routines
 */
static Boolean
netConvertStringToPolygonList C_P_ARGS((Display *display, XrmValue *args,
					Cardinal *num_args,
					XrmValuePtr fromVal, XrmValuePtr toVal,
					XtPointer data));

extern void
netCreateGCs C_P_ARGS((NetWidget w, int symbolgc, int titlegc, int linkgc,
		       int backgroundgc));

extern void
netShowNetworkBackground C_P_ARGS((NetWidget w, XExposeEvent *event,
				   C_Promoted_Boolean always_update));

extern void
netShowNetwork C_P_ARGS((NetWidget w, XExposeEvent *event));

/*
 * drawing support and structure maintenance
 */
extern void
netDrawLink C_P_ARGS((NetWidget w, netLink *link, Drawable d, int xor,
		      netXSRectangle *clip_rect));

extern void
netInitializeMap C_P_ARGS((NetWidget w));

extern void
netDestroyMap C_P_ARGS((NetWidget w));

extern void
netDestroyPolygon C_P_ARGS((NetWidget w, netMapPolygon *mpi));

static void
netScalePoints C_P_ARGS((netXFPoint *fpt, int nfpt, XPoint *pt, int scale_x,
			 int scale_y, netXSRectangle *r));

extern void
netInitializeTitle C_P_ARGS((NetWidget w, netNode *node));

extern void
netInitializeSymbol C_P_ARGS((NetWidget w, netNode *node));

extern void
netInitializeLink C_P_ARGS((NetWidget w, netLink *link));

static void
netSetShapeRect C_P_ARGS((Widget w, int shape, int display_type,
			  netXSRectangle *rect, int line_width,
			  int box_hspace, int box_vspace));

static void
netDrawShape C_P_ARGS((Widget w, Drawable d, GC gc, int shape, int x, int y,
		       int width, int height));

static void
netFillShape C_P_ARGS((Widget w, Drawable d, GC gc, int shape, int x, int y,
		       int width, int height));

static void
netDrawString C_P_ARGS((Widget w, Drawable d, GC gc, netNode *node,
			int display_type, int shape, char *name,
			int x, int y, XFontStruct *fs));

static void
netDrawOblong C_P_ARGS((Display *display, Drawable drawable, GC gc,
			int x, int y, int width, int height));

static void
netFillOblong C_P_ARGS((Display *display, Drawable drawable, GC gc,
			int x, int y, int width, int height));

extern void
netDrawSpline C_P_ARGS((Display *display, Drawable d, GC gc,
			int offset_x, int offset_y, XPoint *p, int n));

extern int
netPickSpline C_P_ARGS((int x, int y, int offset_x, int offset_y, XPoint *p,
			int n));

extern void
netSplineLocateArrow C_P_ARGS((netXSRectangle *A_rect, netXSRectangle *B_rect,
			       int offset_x, int offset_y, XPoint *p,
			       int n, XPoint *a_vertex, XPoint *a_tail,
			       XPoint *b_tail, XPoint *b_vertex));

extern void
netArrowTails C_P_ARGS((int width, int height, XPoint *a, XPoint *b,
			XPoint *p1, XPoint *p2));

extern void
netSetTitleRect C_P_ARGS((NetWidget w, netNode *node));

extern void
netSetSymbolRect C_P_ARGS((NetWidget w, netNode *node));

extern void
netDrawTitle C_P_ARGS((NetWidget w, netNode *node, Drawable d, int xor,
		       netXSRectangle *clip_rect));

extern void
netDrawSymbol C_P_ARGS((NetWidget w, netNode *node, Drawable d, int xor,
			netXSRectangle *clip_rect));

extern void
netDestroyTitle C_P_ARGS((NetWidget w, netNode *node));

extern void
netDestroySymbol C_P_ARGS((NetWidget w, netNode *node));

extern void
netDestroyLabel C_P_ARGS((NetWidget w, netLabel *label));

extern void
netDestroyLink C_P_ARGS((NetWidget w, netLink *link));

extern void
netDestroyLine C_P_ARGS((NetWidget w, netLine *line));

extern void
netSetLinkRect C_P_ARGS((NetWidget w, netLink *link));

extern netXSRectangle *
netGetNodeRect C_P_ARGS((netNode *node, netXSRectangle *t));

/*
 * support for selection
 */
extern netLink *
netPickLinks C_P_ARGS((NetWidget w, int x, int y));

extern int
netPickLink C_P_ARGS((NetWidget w, netLink *link, int x, int y));

extern void
netPickTitlesAndSymbols C_P_ARGS((NetWidget w, int x, int y,
				  int *return_type, netNode **return_node));

extern netNode *
netPickTitles C_P_ARGS((NetWidget w, int x, int y));

extern netNode *
netPickSymbols C_P_ARGS((NetWidget w, int x, int y));

/*
 * cleanup after node movement
 */
static void
netDragUpdateNodes C_P_ARGS((NetWidget w));

extern void
netDragLinks C_P_ARGS((NetWidget w, netNode *node, Drawable d));

/*
 * all net related actions
 */
static void
netAction C_P_ARGS((NetWidget w, XEvent *event, String *params,
		    Cardinal *num_params));

/*
 * support for multi-line text symbols and titles
 *
 *  Rich Kempinski
 */
static char*
  netNextChar C_P_ARGS((char* p, C_Promoted_Char c, int len));

static int
  netSegmentStr C_P_ARGS((char* str, int slen, C_Promoted_Char delim,
			  int maxnum, char** lines, int* lens));

static void
  netDrawMultiStr C_P_ARGS((Display* dis, Drawable d, GC gc, int num_lines,
			    char* lines[], int lens[], int x, int y,
			    int max_width, XFontStruct *fs));

static int
  netMaxWidthMultiStr C_P_ARGS((int num_lines, char* lines[], int lens[],
				XFontStruct *font_struct));

C_PROTOS_END_EXTERN

#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))

#define DELTA		(10)	/* delta for pointing - close enough */
#define FLICKER_COUNT	(6)	/* flashes for selection - must be even! */
#define LINEWIDTH	(1)
#define MAX_NODE_LINES	(30)    /* max lines of text in a node */

static XtActionsRec actions[] =
{
#ifdef HP_WIDGETS
	{ "enter",			(XtActionProc) _XwPrimitiveEnter },
	{ "leave",			(XtActionProc) _XwPrimitiveLeave },
#endif /* HP_WIDGETS */
	{ "netaction",			(XtActionProc) netAction },
	{ NULL, NULL }
};

static char defaultTranslationTable[] =
#ifdef HP_WIDGETS
   "<EnterWindow>:   enter()\n\
    <LeaveWindow>:   leave()\n\
    <Btn1Down>:      netaction(point)\n\
    <Btn1Motion>:    netaction(drag)\n\
    <Btn1Up>:        netaction(update)\n\
    <Btn2Down>:      netaction(point)\n\
    <Btn2Motion>:    netaction(rubberband)\n\
    <Btn2Up>:        netaction(update)\n\
    <Btn3Down>:      netaction(point)\n\
    <Btn3Motion>:    netaction(expensiverubberband)\n\
    <Btn3Up>:        netaction(update)\n";
#else
   "<Btn1Down>:      netaction(point)\n\
    <Btn1Motion>:    netaction(drag)\n\
    <Btn1Up>:        netaction(update)\n\
    <Btn2Down>:      netaction(point)\n\
    <Btn2Motion>:    netaction(rubberband)\n\
    <Btn2Up>:        netaction(update)\n\
    <Btn3Down>:      netaction(point)\n\
    <Btn3Motion>:    netaction(expensiverubberband)\n\
    <Btn3Up>:        netaction(update)\n";
#endif /* HP_WIDGETS */

static XtResource resources[] = {
/*
 * pixels
 */
{
	XtNnetSymbolForeground, XtCNetSymbolForeground, XtRPixel,
	sizeof (Pixel), XtOffset (NetWidget, net.symbolforeground),
	XtRString, "black"
},
{
	XtNnetTitleForeground, XtCNetTitleForeground, XtRPixel, sizeof (Pixel),
	XtOffset (NetWidget, net.titleforeground),
	XtRString, "black"
},
{
	XtNnetLinkForeground, XtCNetLinkForeground, XtRPixel, sizeof (Pixel),
	XtOffset (NetWidget, net.linkforeground),
	XtRString, "black"
},
/*
 * fonts
 */
{
	XtNnetSymbolFont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
	XtOffset(NetWidget, net.symbolfont_struct),
	XtRString, "fixed"
},
{
	XtNnetTitleFont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
	XtOffset(NetWidget, net.titlefont_struct),
	XtRString, "fixed"
},
/*
 * callbacks
 */
{
	XtNnetProcPoint, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(NetWidget, net.netProcPoint),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetProcDrag, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(NetWidget, net.netProcDrag),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetProcUpdate, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(NetWidget, net.netProcUpdate),
	XtRPointer, (caddr_t) NULL
},
/*
 * node and link data
 */
{
	XtNnetNodeList, XtCNetNodeList, XtRNetNodeList, sizeof (netNode *),
	XtOffset (NetWidget, net.nodelist),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetLinkList, XtCNetLinkList, XtRNetLinkList, sizeof (netLink *),
	XtOffset (NetWidget, net.linklist),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetMapPolygons, XtCNetMapPolygons, XtRNetMapPolygons,
	sizeof (netMapPolygon *), XtOffset (NetWidget, net.mappolygons),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetPolygonsAsLines, XtCNetPolygonsAsLines, XtRBoolean,
	sizeof (Boolean), XtOffset (NetWidget, net.polygons_as_lines),
	XtRString, "False"
},
/*
 * padding information - titles and then symbols
 */
{
	XtNnetTitleHorizSpace, XtCNetTitleHorizSpace, XtRInt, sizeof(int),
	XtOffset(NetWidget, net.internal_twidth),
	XtRString, "3"
},
{
	XtNnetTitleVertSpace, XtCNetTitleVertSpace, XtRInt, sizeof(int),
	XtOffset(NetWidget, net.internal_theight),
	XtRString, "3"
},
{
	XtNnetSymbolHorizSpace, XtCNetSymbolHorizSpace, XtRInt, sizeof(int),
	XtOffset(NetWidget, net.internal_swidth),
	XtRString, "3"
},
{
	XtNnetSymbolVertSpace, XtCNetSymbolVertSpace, XtRInt, sizeof(int),
	XtOffset(NetWidget, net.internal_sheight),
	XtRString, "3"
},
/*
 * background pixmap support for titles and symbols
 */
{
	XtNnetTitleBackgroundPixmap, XtCNetTitleBackgroundPixmap, XtRPixmap,
	sizeof (Pixmap), XtOffset (NetWidget, net.titlebackground_pixmap),
	XtRPixmap, (caddr_t) NULL
},
{
	XtNnetDrawTitleBackground, XtCNetDrawTitleBackground, XtRBoolean,
	sizeof (Boolean), XtOffset (NetWidget, net.draw_titlebackground),
	XtRString, "False"
},
{
	XtNnetSymbolBackgroundPixmap, XtCNetSymbolBackgroundPixmap, XtRPixmap,
	sizeof (Pixmap), XtOffset (NetWidget, net.symbolbackground_pixmap),
	XtRPixmap, (caddr_t) NULL
},
{
	XtNnetDrawSymbolBackground, XtCNetDrawSymbolBackground, XtRBoolean,
	sizeof (Boolean), XtOffset (NetWidget, net.draw_symbolbackground),
	XtRString, "False"
},
/*
 * background image for the widget
 */
{
	XtNnetImage, XtCNetImage, XtRNetImage, sizeof (XImage *),
	XtOffset (NetWidget, net.net_image),
	XtRInt, 0
},
/*
 * START HGK additions - 2/15/90
 */
{
	XtNnetAllNodes, XtCNetNodeList, XtRNetNodeList, sizeof (netNode *),
	XtOffset (NetWidget, net.Node_List),
	XtRPointer, (caddr_t) NULL
},
{
	XtNnetAllLinks, XtCNetLinkList, XtRNetLinkList, sizeof (netLink *),
	XtOffset (NetWidget, net.Link_List),
	XtRPointer, (caddr_t) NULL
},
/*
 * END HGK additions
 */

/*
 * START HGK additions - 4/15/90
 */
{
	XtNnetApplicationPtr, XtCNetApplicationPtr, XtRString,
	sizeof (caddr_t), XtOffset (NetWidget, net.application_ptr),
	XtRPointer, (caddr_t) NULL
},
/*
 * END HGK additions
 */

/*
 * JSA node and link manipulation functions
 */
{
	XtNnetDoUpdates, XtCNetDoUpdates, XtRBoolean,
	sizeof (Boolean), XtOffset (NetWidget, net.do_updates),
	XtRString, "True"
},

{
	XtNnetAddNodes, XtCNetAddNodes, XtRNetNodeAddArray, sizeof (netNode *),
	XtOffset (NetWidget, net.addnodes),
	XtRString, (caddr_t) NULL
},
{
	XtNnetRemoveNodes, XtCNetRemoveNodes, XtRNetNodeRemoveArray,
	sizeof (netNode *), XtOffset (NetWidget, net.removenodes),
	XtRString, (caddr_t) NULL
},
{
	XtNnetUpdateNodes, XtCNetUpdateNodes, XtRNetNodeUpdateArray,
	sizeof (netNode *), XtOffset (NetWidget, net.updatenodes),
	XtRString, (caddr_t) NULL
},
{
	XtNnetAddLinks, XtCNetAddLinks, XtRNetLinkAddArray, sizeof (netLink *),
	XtOffset (NetWidget, net.addlinks),
	XtRString, (caddr_t) NULL
},
{
	XtNnetRemoveLinks, XtCNetRemoveLinks, XtRNetLinkRemoveArray,
	sizeof (netLink *), XtOffset (NetWidget, net.removelinks),
	XtRString, (caddr_t) NULL
},
{
	XtNnetUpdateLinks, XtCNetUpdateLinks, XtRNetLinkUpdateArray,
	sizeof (netLink *), XtOffset (NetWidget, net.updatelinks),
	XtRString, (caddr_t) NULL
},
/*
 * JSA callback data
 */
{
	XtNnetSelectionType, XtCNetSelectionType, XtRNetSelectionType,
	sizeof (int), XtOffset (NetWidget, net.action_data.selection_type),
	XtRInt, NULL
},
{
	XtNnetDataType, XtCNetDataType, XtRNetDataType, sizeof (int),
	XtOffset (NetWidget, net.action_data.data_type),
	XtRInt, NULL
},
{
	XtNnetSelectedNode, XtCNetSelectedNode, XtRNetNode, sizeof (netNode *),
	XtOffset (NetWidget, net.action_data.selected_node),
	XtRNetNode, NULL
},
{
	XtNnetSelectedLink, XtCNetSelectedLink, XtRNetLink, sizeof (netLink *),
	XtOffset (NetWidget, net.action_data.selected_link),
	XtRNetLink, NULL
},
{
	XtNnetMouseX, XtCNetMouseX, XtRInt, sizeof (int),
	XtOffset (NetWidget, net.action_data.mouse_x),
	XtRInt, NULL
},
{
	XtNnetMouseY, XtCNetMouseY, XtRInt, sizeof (int),
	XtOffset (NetWidget, net.action_data.mouse_y),
	XtRInt, NULL
},
{
	XtNnetOldX, XtCNetOldX, XtRFloat, sizeof (float),
	XtOffset (NetWidget, net.action_data.old_x),
	XtRFloat, NULL
},
{
	XtNnetOldY, XtCNetOldY, XtRFloat, sizeof (float),
	XtOffset (NetWidget, net.action_data.old_y),
	XtRFloat, NULL
},
};

NetClassRec netClassRec = {
  {
	/* core fields */
#ifdef OPENLOOK
	(WidgetClass) &primitiveClassRec,	/* superclass		 */
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
	(WidgetClass) &XwprimitiveClassRec,	/* superclass            */
#endif /* HP_WIDGETS */
#ifdef MOTIF
	(WidgetClass) &xmPrimitiveClassRec,	/* superclass		 */
#endif /* MOTIF */
#ifdef ATHENA
	(WidgetClass) &(widgetClassRec),	/* superclass		 */
#endif /* ATHENA */
	"Net",					/* class_name            */
	sizeof (NetRec),			/* size                  */
	(XtProc) netClassInitialize,		/* class_initialize      */
	(XtWidgetClassProc) NULL,   		/* class_part_initialize */
	FALSE,					/* class_inited          */
	(XtInitProc) netInitialize,		/* initialize            */
	(XtArgsProc) NULL,		        /* initialize_hook       */
	(XtRealizeProc) netRealize,		/* realize               */
	actions,				/* actions               */
	XtNumber (actions),			/* num_actions           */
	resources,				/* resources             */
	XtNumber (resources),			/* num_resources         */
	NULLQUARK,				/* xrm_class             */
	TRUE,					/* compress_motion       */
	TRUE,					/* compress_exposure     */
	TRUE,					/* compress_enterleave   */
	FALSE,					/* visible_interest      */
	(XtWidgetProc) netDestroy,		/* destroy               */
	(XtWidgetProc) netResize,		/* resize                */
	(XtExposeProc) netRedisplay,		/* expose                */
	(XtSetValuesFunc) netSetValues,		/* set_values            */
	(XtArgsFunc) NULL,	                /* set_values_hook       */
	(XtAlmostProc) XtInheritSetValuesAlmost,/* set_values_almost     */
	(XtArgsProc) NULL,		        /* get_values_hook       */
	(XtAcceptFocusProc) NULL,		/* accept_focus          */
        (XtVersionType) XtVersion,              /* version               */
	NULL,					/* callback_private      */
        defaultTranslationTable,                /* tm_table              */
        (XtGeometryHandler) NULL,               /* query_geometry        */
  },
#ifdef OPENLOOK
  {					/* primitive class     */
      NULL,				/* can_accept_focus    */
      XtInheritHighlightHandler,	/* highlight_handler   */
      XtInheritTraversalHandler,	/* traversal_handler   */
      NULL,				/* register_focus      */
      XtInheritActivateFunc,		/* Activate            */
      NULL,				/* event_procs	       */
      0,				/* num_event_procs     */
      OlVersion,			/* version             */
      NULL				/* extension           */
  },
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
  {
      NULL,         /* Primitive border_highlight   */
      NULL,         /* Primitive border_unhighlight */
      NULL,         /* Primitive select_proc        */
      NULL,         /* Primitive release_proc       */
      NULL,         /* Primitive toggle_proc        */
  },
#endif /* HP_WIDGETS */
#ifdef MOTIF
  {
      NULL,
  },
#endif
  {		    /* net class */
      (int) NULL
  }
};

WidgetClass netWidgetClass = (WidgetClass) &netClassRec;

/*
 * Xt widget definition routines - in the order they appear in NetClassRec
 */
static void
netClassInitialize ()
{
	static XtConvertArgRec contextConvertArgs [] =
	{
	        {
			XtWidgetBaseOffset,
			(XtPointer)XtOffset(Widget, core.self),
			sizeof(Widget),
		},
	};

	XtSetTypeConverter (XtRString, XtRNetMapPolygons,
			    (XtTypeConverter) netConvertStringToPolygonList,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);
}

static void
netInitialize (request, new, args, num_args)
NetWidget request;			/* what the client asked for */
NetWidget new;				/* what they get */
ArgList args;
Cardinal * num_args;
{
	if (request -> core.width == 0)
	{
		if (request -> net.net_image != NULL)
			new -> core.width =
				request -> net.net_image -> width;
		else
			new -> core.width = 512;
	}

	if (request -> core.height == 0)
	{
		if (request -> net.net_image != NULL)
			new -> core.height =
				request -> net.net_image -> height;
		else
			new -> core.height = 512;
	}
	new -> net.second_pass = FALSE;
	new -> net.allocated_symbolfont = FALSE;
	new -> net.allocated_titlefont = FALSE;
	new -> net.action_data.selection_type = 0;
	new -> net.action_data.data_type = 0;
	new -> net.Map_Polygons = (netMapPolygon *) NULL;
	new -> net.Net_Image = (XImage *) NULL;
	new -> net.gcsymbols_background = (GC) NULL;
	new -> net.gctitles_background = (GC) NULL;
}

static void
netRealize (w, valueMask, attributes)
NetWidget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	netNode *node;
	netLink *link;

#ifdef HP_WIDGETS
	_XwRealize (w, valueMask, attributes);
#else
	XtCreateWindow ((Widget) w, InputOutput, (Visual *) CopyFromParent,
			*valueMask, attributes);
#endif /* HP_WIDGETS */

	XDefineCursor (XtDisplay (w), XtWindow (w),
		       XCreateFontCursor (XtDisplay (w), XC_left_ptr));

	w -> net.second_pass = FALSE;
	w -> net.allocated_symbolfont = FALSE;
	w -> net.allocated_titlefont = FALSE;
	w -> net.action_data.selection_type = 0;
	w -> net.action_data.data_type = 0;
	w -> net.Map_Polygons = (netMapPolygon *) NULL;
	w -> net.Net_Image = (XImage *) NULL;
	w -> net.gcsymbols_background = (GC) NULL;
	w -> net.gctitles_background = (GC) NULL;
/*
 * pixmap support added by jags july 26, 1989
 */
	if (w -> net.titlebackground_pixmap == (Pixmap) NULL)
		w -> net.titlebackground_pixmap =
			XwCreateTile (XtScreen((Widget)w),
				      w -> net.titleforeground,
				      w -> core.background_pixel,
				      Xw25_FOREGROUND);

	if (w -> net.symbolbackground_pixmap == (Pixmap) NULL)
		w -> net.symbolbackground_pixmap =
			XwCreateTile (XtScreen((Widget)w),
				      w -> net.symbolforeground,
				      w -> core.background_pixel,
				      Xw25_FOREGROUND);

	netCreateGCs (w, TRUE, TRUE, TRUE, TRUE);

	node = ((netNode *) w -> net.nodelist);
	w -> net.Node_List = node;
	w -> net.nodelist = NULL;
	while (node)
	{
		netInitializeSymbol (w, node);
		netSetSymbolRect ((NetWidget) w, node);
		netInitializeTitle (w, node);
		netSetTitleRect (w, node);
		node = node -> next;
	}

	link = ((netLink *) w -> net.linklist);
	w -> net.Link_List = link;
	w -> net.linklist = NULL;
	while (link)
	{
		netInitializeLink (w, link);
		netSetLinkRect (w, link);
		link = link -> next;
	}

	netInitializeMap (w);

	if (w -> net.net_image && w -> net.net_image -> data)
	{
		if (w -> core.width != w -> net.net_image -> width ||
		    w -> core.height != w -> net.net_image -> height)
		{
			w -> net.Net_Image = netCreateImage (XtDisplay (w),
						w -> core.width,
						w -> core.height);

			if (w -> net.Net_Image == NULL)
			{
				w -> net.net_image = (XImage *) NULL;
				XtWarning ("Cannot allocate image for net widget.");
			}
			else
				SampleImage (w -> net.net_image,
					     w -> net.Net_Image);
		}
		else
			w -> net.Net_Image = (XImage *) NULL;
	}
}

static void
netDestroy (w)
NetWidget w;
{
	netNode *node;
	netLink *link;

	if (w -> net.second_pass)
	{
	    if (w -> net.allocated_symbolfont)
		XFreeFontInfo ((char **) NULL, w -> net.symbolfont_struct, 1);
	    if (w -> net.allocated_titlefont)
		XFreeFontInfo ((char **) NULL, w -> net.titlefont_struct, 1);

	    XtReleaseGC ((Widget) w, w -> net.gcsymbols);
	    XtReleaseGC ((Widget) w, w -> net.gcsymbols_xor);
	    XtReleaseGC ((Widget) w, w -> net.gctitles);
	    XtReleaseGC ((Widget) w, w -> net.gctitles_xor);
	    XtReleaseGC ((Widget) w, w -> net.gclinks);
	    XtReleaseGC ((Widget) w, w -> net.gclinks_xor);
	    XtReleaseGC ((Widget) w, w -> net.gcbackground);
	    if (w -> net.gcsymbols_background)
		XtReleaseGC ((Widget) w,
			     w -> net.gcsymbols_background);
	    if (w -> net.gctitles_background)
		XtReleaseGC ((Widget) w, w -> net.gctitles_background);
	}

	netDestroyMap (w);

	if (w -> net.Net_Image)
		XDestroyImage (w -> net.Net_Image);

	node = w -> net.Node_List;
	while (node)
	{
		netDestroySymbol (w, node);
		netDestroyTitle (w, node);
		node = node -> next;
	}

	link = w -> net.Link_List;
	while (link)
	{
		netDestroyLink (w, link);
		link = link -> next;
	}
}

static void
netResize (w, geometry)
NetWidget w;
XtWidgetGeometry geometry;
{
	netNode *node;
	netLink *link;

	if (XtIsRealized ((Widget) w) == FALSE)
		return;
	node = w -> net.Node_List;
	while (node)
	{
		netSetSymbolRect (w, node);
		netSetTitleRect (w, node);
		node = node -> next;
	}

	link = w -> net.Link_List;
	while (link)
	{
		netSetLinkRect (w, link);
		link = link -> next;
	}

	netInitializeMap (w);

	if (w -> net.net_image && w -> net.net_image -> data)
	{
		if (w -> net.Net_Image)
			XDestroyImage (w -> net.Net_Image);

		if (w -> core.width != w -> net.net_image -> width ||
		    w -> core.height != w -> net.net_image -> height)
		{
			w -> net.Net_Image = netCreateImage (XtDisplay (w),
						w -> core.width,
						w -> core.height);

			if (w -> net.Net_Image == NULL)
			{
				w -> net.net_image = (XImage *) NULL;
				XtWarning ("Cannot allocate image for net widget.");
			}
			else
				SampleImage (w -> net.net_image,
					     w -> net.Net_Image);
		}
		else
			w -> net.Net_Image = (XImage *) NULL;
	}
}

static void
netRedisplay (w, event)
NetWidget w;
XExposeEvent *event;
{
	netShowNetwork (w, event);
}

static Boolean
netSetValues (current, request, new_widget, args, num_args)
NetWidget current;
NetWidget request;
NetWidget new_widget;
ArgList args;
Cardinal *num_args;
{
	int redraw = FALSE;
	int symbolgc = FALSE;
	int titlegc = FALSE;
	int linkgc = FALSE;
	int backgroundgc = FALSE;
	int init_symbol = FALSE;
	int init_title = FALSE;
	int init_link = FALSE;
	Arg arg;
	Pixel current_background;
	Pixel request_background;

	XSync (XtDisplay (current), FALSE);

	if (request -> net.symbolfont_struct !=
	    current -> net.symbolfont_struct)
	{
	    init_symbol = symbolgc = redraw = TRUE;
	    if (current -> net.allocated_symbolfont)
	    {
		XFreeFontInfo ((char **) NULL,
			       current -> net.symbolfont_struct, 1);

		request -> net.allocated_symbolfont = False;
	    }
	}
	else
	if (request -> net.symbolforeground !=
	    current -> net.symbolforeground)
		init_symbol = symbolgc = redraw = TRUE;
/*
 * pixmap and offset support added by jags july 26, 1989
 */
	else
	if (request -> net.draw_symbolbackground !=
	    current -> net.draw_symbolbackground)
		init_symbol = symbolgc = redraw = TRUE;
	else
	if (request -> net.symbolbackground_pixmap !=
	    current -> net.symbolbackground_pixmap)
		init_symbol = symbolgc = redraw = TRUE;
	else
	if (request -> net.internal_sheight !=
	    current -> net.internal_sheight)
		init_symbol = redraw = TRUE;
	else
	if (request -> net.internal_swidth !=
	    current -> net.internal_swidth)
		init_symbol = redraw = TRUE;
/*
 * end addition by jags july 26 1989
 */
	if (request -> net.titlefont_struct !=
	    current -> net.titlefont_struct)
	{
	    init_title = titlegc = redraw = TRUE;
	    if (current -> net.allocated_titlefont)
	    {
		XFreeFontInfo ((char **) NULL,
			       current -> net.titlefont_struct, 1);

		request -> net.allocated_titlefont = False;
	    }
	}
	else
	if (request -> net.titleforeground !=
	    current -> net.titleforeground)
		init_title = titlegc = redraw = TRUE;
/*
 * pixmap and offset support added by jags july 26, 1989
 */
	else
	if (request -> net.draw_titlebackground !=
	    current -> net.draw_titlebackground)
		init_title = titlegc = redraw = TRUE;
	else
	if (request -> net.titlebackground_pixmap !=
	    current -> net.titlebackground_pixmap)
		init_title = titlegc = redraw = TRUE;
	else
	if (request -> net.internal_theight !=
	    current -> net.internal_theight)
		init_title = redraw = TRUE;
	else
	if (request -> net.internal_twidth !=
	    current -> net.internal_twidth)
		init_title = redraw = TRUE;
/*
 * end addition by jags july 26 1989
 */
	if (request -> net.linkforeground !=
	    current -> net.linkforeground)
		init_link = linkgc = redraw = TRUE;

	if (XtIsRealized ((Widget) current))
	{
	    XtSetArg (arg, XtNbackground, &request_background);
	    XtGetValues ((Widget) request, &arg, 1);
	    XtSetArg (arg, XtNbackground, &current_background);
	    XtGetValues ((Widget) current, &arg, 1);
	    if (current_background != request_background)
		backgroundgc = redraw = TRUE;
	}
	if (request -> net.nodelist != current -> net.nodelist ||
	    init_title || init_symbol)
	{
		if (XtIsRealized ((Widget) current))
		{
			netNode *node;

			redraw = TRUE;
			if (request -> net.nodelist == NULL &&
			    request -> net.Node_List)
				node = ((netNode *) request -> net.Node_List);
			else
			{
				init_title = init_symbol = TRUE;
				node = ((netNode *) request -> net.nodelist);
				request -> net.Node_List = node;
				request -> net.nodelist = NULL;
			}
			while (node)
			{
				if (init_symbol)
				{
					netInitializeSymbol (request, node);
					netSetSymbolRect (request, node);
				}
				if (init_title)
				{
					netInitializeTitle (request, node);
					netSetTitleRect (request, node);
				}
				node = node -> next;
			}
		}
		else
			request->net.Node_List = NULL;
	}

	if (request -> net.linklist != current -> net.linklist || init_link)
	{
		if (XtIsRealized ((Widget) current))
		{
			netLink *link;

			redraw = TRUE;
			if (request -> net.linklist == NULL &&
			    request -> net.Link_List)
				link = ((netLink *) request -> net.Link_List);
			else
			{
				link = ((netLink *) request -> net.linklist);
				request -> net.Link_List = link;
				request -> net.linklist = NULL;
			}
			while (link)
			{
				netInitializeLink (request, link);
				netSetLinkRect (request, link);
				link = link -> next;
			}
		}
		else
			request -> net.Link_List = NULL;
	}

	if (request -> net.mappolygons !=
	    current -> net.mappolygons)
	{
		redraw = TRUE;
		netInitializeMap (request);
	}

	if (request -> net.net_image &&
	    request -> net.net_image -> data &&
	    request -> net.net_image != current -> net.net_image)
	{
		redraw = TRUE;
		if (request -> net.Net_Image)
			XDestroyImage (request -> net.Net_Image);

		if (request -> core.width !=
		    request -> net.net_image -> width ||
		    request -> core.height !=
		    request -> net.net_image -> height)
		{
			request -> net.Net_Image = netCreateImage (XtDisplay (request),
						request -> core.width,
						request -> core.height);

			if (request -> net.Net_Image == NULL)
			{
				request -> net.net_image = (XImage *) NULL;
				XtWarning ("Cannot allocate image for net widget.");
			}
			else
				SampleImage (request -> net.net_image,
					     request -> net.Net_Image);
		}
		else
			request -> net.Net_Image = (XImage *) NULL;
	}

	new_widget -> net = request -> net;	/* Install everything */

	if (symbolgc || titlegc || linkgc || backgroundgc)
		netCreateGCs (new_widget, symbolgc, titlegc, linkgc,
			      backgroundgc);

	return (redraw);
}

/*
 * utitity routines
 */

/*
 * netConvertStringToPolygonList - assumes that the string is a file name
 */
static Boolean
netConvertStringToPolygonList (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	netMapPolygon *maps;

	if ((char *) fromVal -> addr)
	{
		if (SetupPolygons ((char *) fromVal -> addr, &maps) == FALSE)
		{
			XtWarning ("NetWidget: cannot convert string to polygons");
			toVal -> size = 0;
			return False;
		}
		netConverterReturn (netMapPolygon *, toVal, maps);
	}
	return False;
}

void
netCreateGCs (w, symbolgc, titlegc, linkgc, backgroundgc)
NetWidget w;
int symbolgc, titlegc, linkgc, backgroundgc;
{
	XGCValues gcValues;
	char *ptr = "Illegal font specified for net widget.";

	if (symbolgc)
	{
		if (w -> net.symbolfont_struct == NULL)
		{
		    if ((w -> net.symbolfont_struct =
			 XLoadQueryFont (XtDisplay (w), "fixed")) == NULL)
		    {
			XtError (ptr);
			return;
		    }
		    w -> net.allocated_symbolfont = True;
		}
		gcValues.font = w -> net.symbolfont_struct -> fid;
		gcValues.foreground = w -> net.symbolforeground;

		if (w -> net.second_pass)
		{
			XtReleaseGC ((Widget) w, w -> net.gcsymbols);
			XtReleaseGC ((Widget) w, w -> net.gcsymbols_xor);
			if (w -> net.gcsymbols_background)
				XtReleaseGC ((Widget) w,
					 w -> net.gcsymbols_background);
		}

		w -> net.gcsymbols = XtGetGC ((Widget) w,
						 GCFont | GCForeground,
						 &gcValues);
		gcValues.function = NET_GXXOR_OP;
		w -> net.gcsymbols_xor = XtGetGC ((Widget) w,
						     GCFunction |
						     GCFont | GCForeground,
						     &gcValues);
		if (w -> net.draw_symbolbackground)
		{
			gcValues.fill_style = FillTiled;
			gcValues.tile = w -> net.symbolbackground_pixmap;
			w -> net.gcsymbols_background = XtGetGC ((Widget) w,
						    GCFillStyle | GCTile,
						    &gcValues);
		}
	}

	if (titlegc)
	{
		if (w -> net.titlefont_struct == NULL)
		{
		    if ((w -> net.titlefont_struct =
			 XLoadQueryFont (XtDisplay (w), "fixed")) == NULL)
		    {
			XtError (ptr);
			return;
		    }
		    w -> net.allocated_titlefont = True;
		}
		gcValues.font = w -> net.titlefont_struct -> fid;
		gcValues.foreground = w -> net.titleforeground;
		if (w -> net.second_pass)
		{
			XtReleaseGC ((Widget) w, w -> net.gctitles);
			XtReleaseGC ((Widget) w, w -> net.gctitles_xor);
			if (w -> net.gctitles_background)
				XtReleaseGC ((Widget) w,
					 w -> net.gctitles_background);
		}
		w -> net.gctitles = XtGetGC ((Widget) w,
						GCFont | GCForeground,
						&gcValues);

		gcValues.function = NET_GXXOR_OP;
		w -> net.gctitles_xor = XtGetGC ((Widget) w,
						    GCFunction |
						    GCFont | GCForeground,
						    &gcValues);
		if (w -> net.draw_titlebackground)
		{
			gcValues.fill_style = FillTiled;
			gcValues.tile = w -> net.titlebackground_pixmap;
			w -> net.gctitles_background = XtGetGC ((Widget) w,
							GCFillStyle | GCTile,
							&gcValues);
		}
	}

	if (linkgc)
	{
		gcValues.foreground = w -> net.linkforeground;
		gcValues.line_width = 0; /* 2 looks better - 0 is fastest */
		if (w -> net.second_pass)
		{
			XtReleaseGC ((Widget) w, w -> net.gclinks);
			XtReleaseGC ((Widget) w, w -> net.gclinks_xor);
		}
		w -> net.gclinks = XtGetGC ((Widget) w,
					       GCLineWidth |
					       GCForeground,
					       &gcValues);

		gcValues.function = NET_GXXOR_OP;
		w -> net.gclinks_xor = XtGetGC ((Widget) w,
						   GCFunction |
						   GCLineWidth |
						   GCForeground,
						   &gcValues);
	}

	if (backgroundgc)
	{
		Arg arg;
		Pixel background;

		XtSetArg (arg, XtNbackground, &background);
		XtGetValues ((Widget) w, &arg, 1);

		if (w -> net.second_pass)
			XtReleaseGC ((Widget) w, w -> net.gcbackground);

		gcValues.foreground = background;
		gcValues.function = GXcopy;
		w -> net.gcbackground = XtGetGC ((Widget) w,
						   GCFunction | GCForeground,
						   &gcValues);
	}

	w -> net.second_pass = TRUE;
}

void					/* from static raster */
netShowNetworkBackground (w, event, always_update)
register NetWidget w;
XExposeEvent *event;
Boolean always_update;
{
	int HOffset, WOffset;
	int VisHeight, VisWidth;
	int src_x = 0;
	int src_y = 0;
	netXSRectangle r_small;
	register netMapPolygon *map;
	Drawable d = (Drawable) XtWindow (w);
	Display *display = XtDisplay (w);

	if (XtIsRealized ((Widget) w) == FALSE)
		return;

	if (always_update == False && w -> net.do_updates == False)
	    return;

#ifdef HP_WIDGETS
	HOffset = WOffset = (int) w -> primitive.highlight_thickness;
#else
	HOffset = WOffset = 0;
#endif /* HP_WIDGETS */

	VisWidth = w -> core.width - (WOffset << 1);
	VisHeight = w -> core.height - (HOffset << 1);

	if (event && event -> type == Expose)
	{
		src_x = event -> x;
		src_y = event -> y;
		WOffset += src_x;
		HOffset += src_y;
		if (event -> width < VisWidth)
			VisWidth = event -> width;
		if (event -> height < VisHeight)
			VisHeight = event -> height;
	}

	r_small.x = src_x;
	r_small.y = src_y;
	r_small.width = VisWidth;
	r_small.height = VisHeight;

	if (w -> net.net_image == NULL)
		XFillRectangle (display, d,
				w -> net.gcbackground,
				r_small.x, r_small.y,
				r_small.width, r_small.height);
	else
		XPutImage (display, d, w -> net.gcbackground,
			   (w -> net.Net_Image ?
			    w -> net.Net_Image : w -> net.net_image),
			   src_x, src_y, WOffset, HOffset,
			   VisWidth, VisHeight);

	map = w -> net.Map_Polygons;
	while (map)
	{
		if (RectInRect (&map -> r, &r_small))
		{
			if (w -> net.polygons_as_lines)
				XDrawLines (display, d,
					    map -> gc,
					    map -> p, map -> npoints,
					    CoordModeOrigin);
			else
				XFillPolygon (display, d,
					      map -> gc,
					      map -> p, map -> npoints,
					      Complex, CoordModeOrigin);
		}
		else if (RectXRect (&r_small, &map -> r))
		{
			XGCValues xgcvalues;

			XSetClipRectangles (display, map -> gc,
					    0, 0, (XRectangle *) &r_small,
					    1, YXBanded);

			if (w -> net.polygons_as_lines)
				XDrawLines (display, d,
					    map -> gc,
					    map -> p, map -> npoints,
					    CoordModeOrigin);
			else
				XFillPolygon (display, d,
					      map -> gc,
					      map -> p, map -> npoints,
					      Complex, CoordModeOrigin);

			xgcvalues.clip_mask = None;
			XChangeGC (display, map -> gc, GCClipMask, &xgcvalues);
		}
		map = map -> next;
	}
#ifdef HP_WIDGETS
	if (w -> primitive.highlighted)
	{
		_XwHighlightBorder (w);
		w -> primitive.display_highlighted = TRUE;
	}
	else
		if (w -> primitive.display_highlighted)
		{
			_XwUnhighlightBorder(w);
			w -> primitive.display_highlighted = FALSE;
		}
#endif /* HP_WIDGETS */
}

void
netShowNetwork (w, event)
register NetWidget w;
XExposeEvent *event;
{
	int HOffset, WOffset;
	int VisHeight, VisWidth;
	int src_x = 0;
	int src_y = 0;
	netXSRectangle r_small, r_large;
	register netMapPolygon *map;
	register netLink *link;
	register netNode *node;
	Drawable d = (Drawable) XtWindow (w);
	Display *display = XtDisplay (w);

	if (XtIsRealized ((Widget) w) == FALSE)
		return;

#ifdef HP_WIDGETS
	HOffset = WOffset = (int) w -> primitive.highlight_thickness;
#else
	HOffset = WOffset = 0;
#endif /* HP_WIDGETS */

	VisWidth = w -> core.width - (WOffset << 1);
	VisHeight = w -> core.height - (HOffset << 1);

	if (event && event -> type == Expose)
	{
		src_x = event -> x;
		src_y = event -> y;
		WOffset += src_x;
		HOffset += src_y;
		if (event -> width < VisWidth)
			VisWidth = event -> width;
		if (event -> height < VisHeight)
			VisHeight = event -> height;
	}
	r_small.x = src_x;
	r_small.y = src_y;
	r_small.width = VisWidth;
	r_small.height = VisHeight;

	if (w -> net.net_image)
		XPutImage (display, d, w -> net.gcbackground,
			   (w -> net.Net_Image ?
			    w -> net.Net_Image : w -> net.net_image),
			   src_x, src_y, WOffset, HOffset,
			   VisWidth, VisHeight);

	map = w -> net.Map_Polygons;
	while (map)
	{
		if (RectInRect (&map -> r, &r_small))
		{
			if (w -> net.polygons_as_lines)
				XDrawLines (display, d,
					    map -> gc,
					    map -> p, map -> npoints,
					    CoordModeOrigin);
			else
				XFillPolygon (display, d,
					      map -> gc,
					      map -> p, map -> npoints,
					      Complex, CoordModeOrigin);
		}
		else if (RectXRect (&r_small, &map -> r))
		{
			XGCValues xgcvalues;
			XSetClipRectangles (display, map -> gc,
					    0, 0, (XRectangle *) &r_small,
					    1, YXBanded);

			if (w -> net.polygons_as_lines)
				XDrawLines (display, d,
					    map -> gc,
					    map -> p, map -> npoints,
					    CoordModeOrigin);
			else
				XFillPolygon (display, d,
					      map -> gc,
					      map -> p, map -> npoints,
					      Complex, CoordModeOrigin);

			xgcvalues.clip_mask = None;
			XChangeGC (display, map -> gc, GCClipMask, &xgcvalues);
		}
		map = map -> next;
	}
	link = w -> net.Link_List;
	while (link)
	{
		if (RectXRect (&r_small, &link -> l))
			netDrawLink (w, link, d, FALSE, &r_small);
		link = link -> next;
	}

	node = w -> net.Node_List;
	while (node)
	{
		if (RectXRect (&r_small, &node -> s))
			netDrawSymbol (w, node, d, FALSE, &r_small);

		if (RectXRect (&r_small, &node -> t))
			netDrawTitle (w, node, d, FALSE, &r_small);

		node = node -> next;
	}

#ifdef HP_WIDGETS
	if (w -> primitive.highlighted)
	{
		_XwHighlightBorder (w);
		w -> primitive.display_highlighted = TRUE;
	}
	else
		if (w -> primitive.display_highlighted)
		{
			_XwUnhighlightBorder(w);
			w -> primitive.display_highlighted = FALSE;
		}
#endif /* HP_WIDGETS */
}

/*
 * drawing support
 */
void
netDrawLink (w, link, d, xor, clip_rect)
register NetWidget w;
register netLink *link;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	GC lgc;
	int spline, spline_points, arrow_a, arrow_b;
	XPoint points[5];

	if (link -> type & NETLINEISPROC)
	{
		(*link -> line.draw_proc) (NETPROCDRAW, w, link, d, xor,
					   clip_rect);
		return;
	}

	if (link -> type & NETLINKISLINE)
	{
		register netLine *ptr = link -> line.line;

		if (xor)
			lgc = ptr -> xor_gc;
		else
			lgc = ptr -> gc;

		spline = ptr -> type & NETSPLINELINK;
		spline_points = ptr -> type & NETSPLINEPOINTS;
		arrow_a = ptr -> type & NETARROWALINK;
		arrow_b = ptr -> type & NETARROWBLINK;
	}
	else
	{
		if (xor)
			lgc = w -> net.gclinks_xor;
		else
			lgc = w -> net.gclinks;

		spline = link -> type & NETSPLINELINK;
		spline_points = False;
		arrow_a = link -> type & NETARROWALINK;
		arrow_b = link -> type & NETARROWBLINK;
	}

	if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
		XSetClipRectangles (XtDisplay (w), lgc, 0, 0,
				    (XRectangle *) clip_rect, 1, YXBanded);
	
	if (spline_points)
	{
	    netDrawSpline (XtDisplay (w), d, lgc, 1, 1,
			   link -> line.line -> _spline_points,
			   link -> line.line -> _spline_count);
	}
	else if (spline)
	{
		points[0].x = link -> A -> p.x;
		points[0].y = link -> A -> p.y;
		points[1].x = link -> A -> p.x;
		points[1].y = link -> B -> p.y;
		points[2].x = link -> B -> p.x;
		points[2].y = link -> B -> p.y;
		points[4] = points[3] = points[2];
		netDrawSpline (XtDisplay (w), d, lgc, 1, 1, points, 3);
	}
	else
		XDrawLine (XtDisplay (w), d, lgc,
			   link -> A -> p.x, link -> A -> p.y,
			   link -> B -> p.x, link -> B -> p.y);
	
	if (arrow_a)
	{
		points[0] = link -> arrowA[0];
		points[1] = link -> arrowA[1];
		points[2] = link -> arrowA[2];
		points[3] = points[0];
		XFillPolygon (XtDisplay (w), d, lgc, points, 4,
			      Convex, CoordModeOrigin);
	}

	if (arrow_b)
	{
		points[0] = link -> arrowB[0];
		points[1] = link -> arrowB[1];
		points[2] = link -> arrowB[2];
		points[3] = points[0];
		XFillPolygon (XtDisplay (w), d, lgc, points, 4,
			      Convex, CoordModeOrigin);
	}

	if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
	{
		XGCValues xgcvalues;

		xgcvalues.clip_mask = None;
		XChangeGC (XtDisplay (w), lgc, GCClipMask, &xgcvalues);
	}
}

/*
 * net structure maintenance routines
 */
void
netInitializeMap (w)
register NetWidget w;
{
	Display *display = XtDisplay (w);
	register netMapPolygon *mp;
	register netMapPolygon *mpi;
	char *color;
	GC gc;
	XGCValues gcvalues;
	static XrmQuark XtQstring_quark;
	static XrmQuark XtQpixel_quark;

	if (XtQstring_quark == (XrmQuark) NULL)
	{
	    XtQstring_quark = XrmStringToQuark (XtRString);
	    XtQpixel_quark = XrmStringToQuark (XtRPixel);
	}

	if (w -> net.Map_Polygons == NULL)
	{
		w -> net.Map_Polygons = (netMapPolygon *) w -> net.mappolygons;
		mp = (netMapPolygon *) w -> net.mappolygons;
		while (mp)
		{
			mp -> gc = (GC) NULL;
			mp = mp -> next;
		}
	}
	else
	if (w -> net.mappolygons)
	{
		mp = (netMapPolygon *) w -> net.mappolygons;
		mpi = w -> net.Map_Polygons;
		while (mpi && mp)
		{
			if (mpi != mp) /* eq not equal */
				break;
			mp = mp -> next;
			mpi = mpi -> next;
		}

		if (mpi != mp)
		{
			netDestroyMap (w);
			w -> net.Map_Polygons =
				(netMapPolygon *) w -> net.mappolygons;
			/* assume a fresh start */
			mp = (netMapPolygon *) w -> net.mappolygons;
			while (mp)
			{
				mp -> gc = (GC) NULL;
				mp = mp -> next;
			}
		}
	}

	w -> net.mappolygons = (netMapPolygon *) NULL;

	color = "";
	gc = (GC) NULL;
	mpi = w -> net.Map_Polygons;
	while (mpi)
	{
		netScalePoints (mpi -> points, mpi -> npoints, mpi -> p,
				 w -> core.width, w -> core.height,
				 &mpi -> r);

		if (mpi -> gc == NULL)
		{
			if (strcmp (mpi -> color, color) != 0)
			{
				XrmValue from_value, to_value;

				color = mpi -> color;
				from_value.size = strlen (color);
				from_value.addr = color;
				to_value.size = 0;
				to_value.addr = (caddr_t) NULL;

				_XtConvert (w, XtQstring_quark, &from_value,
					    XtQpixel_quark, &to_value, NULL);

				if (to_value.size && to_value.addr)
					gcvalues.foreground = *((Pixel *)
								to_value.addr);
				else
					gcvalues.foreground = (Pixel) NULL;
				gcvalues.function = GXcopy;
			}
			gc = XtGetGC ((Widget) w,
					GCForeground | GCFunction,
					&gcvalues);
			mpi -> gc = gc;
		}
		mpi = mpi -> next;
	}
}

void
netDestroyMap (w)
register NetWidget w;
{
	register netMapPolygon *mpi, *mp;

	mpi = w -> net.Map_Polygons;
	while (mpi)
	{
		if (mpi -> gc)
			XtReleaseGC ((Widget) w, mpi -> gc);
		mpi -> gc = (GC) NULL;
/*
		XFree (mpi -> color);
		XFree (mpi -> points);

		XFree (mpi -> p);
		mp = mpi -> next;
		XFree (mpi);
		mpi = mp;
*/
		mpi = mpi -> next;
	}
	w -> net.Map_Polygons = (netMapPolygon *) NULL;
}

void
netDestroyPolygon (w, mpi)
NetWidget w;
register netMapPolygon *mpi;
{
	if (mpi -> p)
	{
		if (XtIsRealized ((Widget) w))
			XtReleaseGC ((Widget) w, mpi -> gc);
		XFree ((char *) mpi -> color);
		XFree ((char *) mpi -> points);
		XFree ((char *) mpi -> p);
		XFree ((char *) mpi);
	}
}

static void
netScalePoints (fpt, nfpt, pt, scale_x, scale_y, r)
register netXFPoint *fpt;
int nfpt;
register XPoint *pt;
int scale_x;
int scale_y;
netXSRectangle *r;
{
	int i;

	if (nfpt < 1)
		return;

	pt[0].x = fpt[0].x * scale_x;
	pt[0].y = scale_y - fpt[0].y * scale_y;
	r -> width = r -> height = 0;
	r -> x = pt[0].x;
	r -> y = pt[0].y;

	for (i = 1; i < nfpt; i++)
	{
		pt[i].x = fpt[i].x * scale_x;
		pt[i].y = scale_y - fpt[i].y * scale_y;
		MergeRectPt (r, &pt[i]);
	}
}

void
netInitializeTitle (w, node)
register NetWidget w;
register netNode *node;
{
	XGCValues gcvalues;
	int valuemask = 0;
	XFontStruct *font_struct;
	char *name;
	int ignore;
	XCharStruct overall_size;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (node -> type & NETTITLEISPROC)
	{
		(*node -> title.draw_proc) (NETPROCINIT, w, node,
					    (Drawable) NULL, NULL,
					    (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETTITLEISLABEL)
	{
		register netLabel *ptr = node -> title.label;

		name = ptr -> name;

		if (ptr -> type & NETGRAPHICS_FUNCTION)
		{
			valuemask |= GCFunction;
			gcvalues.function = ptr -> graphics_function;
		}

		if (ptr -> type & NETFOREGROUND)
		{
			valuemask |= GCForeground;
			gcvalues.foreground = ptr -> foreground;
		}
		else
		{
			valuemask |= GCForeground;
			gcvalues.foreground = w -> net.titleforeground;
		}

		if (ptr -> type & NETLINE_WIDTH)
		{
			valuemask |= GCLineWidth;
			gcvalues.line_width = ptr -> line_width;
		}

		if (ptr -> type & NETLINE_STYLE)
		{
			valuemask |= GCLineStyle;
			gcvalues.line_style = ptr -> line_style;
		}

		if (ptr -> type & NETFONT)
		{
			if (ptr -> font_struct == NULL)
				ptr -> font_struct =
					XLoadQueryFont (XtDisplay (w),
							ptr -> font);
			if (ptr -> font_struct == NULL)
			{
				XtError ("Illegal font specified for net widget.");
				return;
			}
			font_struct = ptr -> font_struct;
			valuemask |= GCFont;
			gcvalues.font = ptr -> font_struct -> fid;
		}
		else
		{
		    if (w -> net.titlefont_struct == NULL)
		    {
			if ((w -> net.titlefont_struct =
			     XLoadQueryFont (XtDisplay (w), "fixed")) == NULL)
			{
			    XtError ("Illegal font specified for net widget.");
			    return;
			}
			w -> net.allocated_titlefont = True;
		    }
		    font_struct = w -> net.titlefont_struct;
		    valuemask |= GCFont;
		    gcvalues.font = w -> net.titlefont_struct -> fid;
		}

		if (ptr -> type & NETPIXMAP)
		{
			Window root;
			int ignore;
			int width, height, depth;
			int mask_width, mask_height, mask_depth;
			Pixmap bitmap;

			if (XGetGeometry (XtDisplay (w), ptr -> pixmap, &root,
					  &ignore, &ignore,
					  (unsigned int *) &width, 
					  (unsigned int *) &height, 
					  (unsigned int *) &ignore,
					  (unsigned int *) &depth) == FALSE)
		XtError ("Could not get the geometry the label pixmap.");

			if (ptr -> pixmap_mask)
			{
				if (XGetGeometry (XtDisplay (w),
					  ptr -> pixmap_mask,
					  &root, &ignore, &ignore,
					  (unsigned int *) &mask_width,
					  (unsigned int *) &mask_height,
					  (unsigned int *) &ignore,
					  (unsigned int *) &mask_depth) ==
				    FALSE)
		XtError ("Could not get the geometry for the label pixmap mask.");

				if (mask_depth != 1)
		XtError ("A pixmap mask is more than one bit deep.");
			}

			ptr -> pixmap_rect.width = width;
			ptr -> pixmap_rect.height = height;
		}

		if (ptr -> gc)
		    XtReleaseGC ((Widget) w, ptr -> gc);

		ptr -> gc = XtGetGC ((Widget) w, valuemask, &gcvalues);

		if (ptr -> xor_gc)
		    XtReleaseGC ((Widget) w, ptr -> xor_gc);

		gcvalues.function = NET_GXXOR_OP;
		ptr -> xor_gc = XtGetGC ((Widget) w,
					 valuemask | GCFunction, &gcvalues);

		/*
		 * addition by jags july 25 1989
		 */
		if (w -> net.draw_titlebackground ||
		    ptr -> type & NETBGSUPPLIED)
		{
			valuemask = GCFillStyle;
			gcvalues.fill_style = FillTiled;
			valuemask |= GCTile;
			if (ptr -> type & NETBGSUPPLIED &&
			    ptr -> box_background)
				gcvalues.tile = ptr -> box_background;
			else
				gcvalues.tile = w -> net.titlebackground_pixmap;
			if (ptr -> background_gc)
			    XtReleaseGC ((Widget) w, ptr -> background_gc);

			ptr -> background_gc = XtGetGC ((Widget) w, valuemask,
							&gcvalues);
		}
		/*
		 * end addition
		 */
	}
	else
	{
		name = node -> title.name;
		font_struct = w -> net.titlefont_struct;
	}

	if (name == NULL)
	{
		node -> t_width = 0;
	}
	else
	{
	  /* begin modifications for supporting multi-line text
	   */

	  /* locals used for multi-line text
	   */
	  int lens[MAX_NODE_LINES];
	  char* lines[MAX_NODE_LINES];
	  
	  /* check for existence of multi-line text
	   */
	  node -> t_line_count = netSegmentStr (name, strlen(name), '\n',
				     MAX_NODE_LINES, lines, lens);

	  if (node -> t_line_count > 1)
	  {
	      node -> t_width = netMaxWidthMultiStr (node -> t_line_count,
						     lines, lens, font_struct);
	  }
	  else
	  {
	      XTextExtents (font_struct, name, strlen (name),
			    &ignore, &ignore, &ignore, &overall_size);

	      node -> t_width = overall_size.lbearing +
		  overall_size.rbearing;
	  }
	  /* end modifications for supporting multi-line text
	   */
	}
}

void
netInitializeSymbol (w, node)
register NetWidget w;
register netNode *node;
{
	XGCValues gcvalues;
	int valuemask = 0;
	XFontStruct *font_struct;
	char *name;
	int ignore;
	XCharStruct overall_size;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (node -> type & NETSYMBOLISPROC)
	{
		(*node -> symbol.draw_proc) (NETPROCINIT, w, node,
					     (Drawable) NULL, NULL,
					     (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETSYMBOLISLABEL)
	{
		register netLabel *ptr = node -> symbol.label;

		name = ptr -> name;

		if (ptr -> type & NETGRAPHICS_FUNCTION)
		{
			valuemask |= GCFunction;
			gcvalues.function = ptr -> graphics_function;
		}

		if (ptr -> type & NETFOREGROUND)
		{
			valuemask |= GCForeground;
			gcvalues.foreground = ptr -> foreground;
		}
		else
		{
			valuemask |= GCForeground;
			gcvalues.foreground = w -> net.symbolforeground;
		}

		if (ptr -> type & NETLINE_WIDTH)
		{
			valuemask |= GCLineWidth;
			gcvalues.line_width = ptr -> line_width;
		}

		if (ptr -> type & NETLINE_STYLE)
		{
			valuemask |= GCLineStyle;
			gcvalues.line_style = ptr -> line_style;
		}

		if (ptr -> type & NETFONT)
		{
			if (ptr -> font_struct == NULL)
				ptr -> font_struct =
					XLoadQueryFont (XtDisplay (w),
							ptr -> font);
			if (ptr -> font_struct == NULL)
			{
				XtError ("Illegal font specified for net widget.");
				return;
			}
			font_struct = ptr -> font_struct;
			valuemask |= GCFont;
			gcvalues.font = ptr -> font_struct -> fid;
		}
		else
		{
			if (w -> net.symbolfont_struct == NULL)
			{
			    if ((w -> net.symbolfont_struct =
				 XLoadQueryFont (XtDisplay (w), "fixed")) ==
				NULL)
			    {
				XtError ("Illegal font specified for net widget.");
				return;
			    }
			    w -> net.allocated_symbolfont = True;
			}
			font_struct = w -> net.symbolfont_struct;
			valuemask |= GCFont;
			gcvalues.font = w -> net.symbolfont_struct -> fid;
		}

		if (ptr -> type & NETPIXMAP)
		{
			Window root;
			int ignore;
			int width, height, depth;
			int mask_width, mask_height, mask_depth;
			Pixmap bitmap;

			if (XGetGeometry (XtDisplay (w), ptr -> pixmap, &root,
					  &ignore, &ignore,
					  (unsigned int *) &width, 
					  (unsigned int *) &height, 
					  (unsigned int *) &ignore,
					  (unsigned int *) &depth) == FALSE)
		XtError ("Could not get the geometry the label pixmap.");

			if (ptr -> pixmap_mask)
			{
				if (XGetGeometry (XtDisplay (w),
					  ptr -> pixmap_mask,
					  &root, &ignore, &ignore,
					  (unsigned int *) &mask_width,
					  (unsigned int *) &mask_height,
					  (unsigned int *) &ignore,
					  (unsigned int *) &mask_depth) ==
								    FALSE)
		XtError ("Could not get the geometry for the label pixmap mask.");

				if (mask_depth != 1)
		XtError ("A pixmap mask is more than one bit deep.");
			}

			ptr -> pixmap_rect.width = width;
			ptr -> pixmap_rect.height = height;
		}

		if (ptr -> gc)
		    XtReleaseGC ((Widget) w, ptr -> gc);

		ptr -> gc = XtGetGC ((Widget) w, valuemask, &gcvalues);

		if (ptr -> xor_gc)
		    XtReleaseGC ((Widget) w, ptr -> xor_gc);

		gcvalues.function = NET_GXXOR_OP;
		ptr -> xor_gc = XtGetGC ((Widget) w, valuemask | GCFunction, &gcvalues);

		/*
		 * addition by jags july 25 1989
		 */
		if (w -> net.draw_symbolbackground ||
		    ptr -> type & NETBGSUPPLIED)
		{
			valuemask = GCFillStyle;
			gcvalues.fill_style = FillTiled;
			valuemask |= GCTile;
			if (ptr -> type & NETBGSUPPLIED &&
			    ptr -> box_background)
				gcvalues.tile = ptr -> box_background;
			else
				gcvalues.tile = w -> net.symbolbackground_pixmap;
			if (ptr -> background_gc)
			    XtReleaseGC ((Widget) w, ptr -> background_gc);

			ptr -> background_gc = XtGetGC ((Widget) w, valuemask,
							&gcvalues);
		}
		/*
		 * end addition
		 */
	}
	else
	{
		name = node -> symbol.name;
		font_struct = w -> net.symbolfont_struct;
	}

	if (name == NULL)
	{
		node -> s_width = 0;
	}
	else
	{
	  /* begin modifications for supporting multi-line text
	   */

	  /* locals used for multi-line text
	   */
	  int lens[MAX_NODE_LINES];
	  char* lines[MAX_NODE_LINES];
	  
	  /* check for existence of multi-line text
	   */
	  node -> s_line_count = netSegmentStr (name, strlen(name), '\n',
				     MAX_NODE_LINES, lines, lens);

	  if (node -> s_line_count > 1)
	  {
	      node -> s_width = netMaxWidthMultiStr (node -> s_line_count,
						     lines, lens, font_struct);
	  }
	  else
	  {
	      XTextExtents (font_struct, name, strlen (name),
			    &ignore, &ignore, &ignore, &overall_size);

	      node -> s_width = overall_size.lbearing +
		  overall_size.rbearing;
	  }
	  /* end modifications for supporting multi-line text
	   */
	}
}

void
netInitializeLink (w, link)
register NetWidget w;
register netLink *link;
{
	XGCValues gcvalues;
	int valuemask = 0;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (link -> type & NETLINEISPROC)
	{
		(*link -> line.draw_proc) (NETPROCINIT, w, link,
					   (Drawable) NULL, NULL,
					   (netXSRectangle *) NULL);
		return;
	}

	if (link -> type & NETLINKISLINE)
	{
		register netLine *ptr = link -> line.line;

		if (ptr -> type & NETGRAPHICS_FUNCTION)
		{
			valuemask |= GCFunction;
			gcvalues.function = ptr -> graphics_function;
		}

		if (ptr -> type & NETFOREGROUND)
		{
			valuemask |= GCForeground;
			gcvalues.foreground = ptr -> foreground;
		}

		if (ptr -> type & NETLINE_WIDTH)
		{
			valuemask |= GCLineWidth;
			gcvalues.line_width = ptr -> line_width;
		}

		if (ptr -> type & NETLINE_STYLE)
		{
			valuemask |= GCLineStyle;
			gcvalues.line_style = ptr -> line_style;
		}

		if (ptr -> gc)
		    XtReleaseGC ((Widget) w, ptr -> gc);

		ptr -> gc = XtGetGC ((Widget) w, valuemask, &gcvalues);

		if (ptr -> xor_gc)
		    XtReleaseGC ((Widget) w, ptr -> xor_gc);

		gcvalues.function = NET_GXXOR_OP;
		ptr -> xor_gc = XtGetGC ((Widget) w,
					 valuemask | GCFunction, &gcvalues);

		if (ptr -> type & NETSPLINEPOINTS)
		{
		    netXFPoint *points = ptr -> spline_points;
		    int count = 0;

		    while (points[count].x != -999.0 &&
			   points[count].y != -999.0)
			count++;

		    ptr -> _spline_count = count;
		    count += 2;
		    XtFree ((char *) ptr -> _spline_points);
		    ptr -> _spline_points = (XPoint *)
			XtMalloc (sizeof (XPoint) * count);
		}

	}
}

static void
netSetShapeRect (w, shape, display_type, rect, line_width,
		 box_hspace, box_vspace)
Widget w;
int shape;
int display_type;
netXSRectangle *rect;
int line_width;
int box_hspace;
int box_vspace;
{
	short delta;

	switch (shape)
	{
	default:
	case 0:

	case NETBOXSYMBOL:
	case NETBOXTITLE:

	case NETELLIPSESYMBOL:
	case NETELLIPSETITLE:

	case NETOBLONGSYMBOL:
	case NETOBLONGTITLE:
		if (display_type == NETSYMBOL)
			rect -> x -= (line_width + box_hspace);
		rect -> y -=  (line_width + box_vspace);
		rect -> width +=  (2 * (line_width + box_hspace));
		rect -> height += (2 * (line_width + box_vspace));
		break;

	case NETCIRCLESYMBOL:
	case NETCIRCLETITLE:
		if (rect -> width < rect -> height)
		{
			if (display_type == NETSYMBOL)
			{
				delta = rect -> height - rect -> width;
				rect -> x -= delta / 2;
			}
			rect -> width = rect -> height;
		}
		if (rect -> height < rect -> width)
		{
			delta = rect -> width - rect -> height;
			rect -> y -= delta / 2;
			rect -> height = rect -> width;
		}
		if (display_type == NETSYMBOL)
			rect -> x -= (line_width + box_hspace);
		rect -> y -=  (line_width + box_vspace);
		rect -> width +=  (2 * (line_width + box_hspace));
		rect -> height += (2 * (line_width + box_vspace));
		break;
	}
}

static void
netDrawShape (w, d, gc, shape, x, y, width, height)
Widget w;
Drawable d;
GC gc;
int shape;
int x, y, width, height;
{
	void netDrawOblong ();

	switch (shape)
	{
	default:
	case NETBOXSYMBOL:
	case NETBOXTITLE:
		XDrawRectangle (XtDisplay (w), d, gc, x, y, width, height);
		break;

	case NETELLIPSESYMBOL:
	case NETELLIPSETITLE:
	case NETCIRCLESYMBOL:
	case NETCIRCLETITLE:
		XDrawArc (XtDisplay (w), d, gc, x, y, width - 1, height - 1,
			  0, 360 * 64);
		break;

	case NETOBLONGSYMBOL:
	case NETOBLONGTITLE:
		netDrawOblong (XtDisplay (w), d, gc, x, y, width, height);
		break;
	}
}

static void
netFillShape (w, d, gc, shape, x, y, width, height)
Widget w;
Drawable d;
GC gc;
int shape;
int x, y, width, height;
{
	void netFillOblong ();

	switch (shape)
	{
	default:
	case NETBOXSYMBOL:
	case NETBOXTITLE:
		XFillRectangle (XtDisplay (w), d, gc, x, y, width, height);
		break;

	case NETELLIPSESYMBOL:
	case NETELLIPSETITLE:
	case NETCIRCLESYMBOL:
	case NETCIRCLETITLE:
		XFillArc (XtDisplay (w), d, gc, x, y, width - 1, height - 1,
			  0, 360 * 64);
		break;

	case NETOBLONGSYMBOL:
	case NETOBLONGTITLE:
		netFillOblong (XtDisplay (w), d, gc, x, y, width, height);
		break;
	}
}

/*
 * begin additional code for supporting multi-line 
 * symbols and titles -- kempinski
 *
 */

/*
 * netNextChar(p,c,len)
 * returns pointer to next occurance of c in the string p
 * of length len. Returns NULL if p does not contain c
 */
static char*
  netNextChar (p, c, len)
register char* p;
register char c;
int len;
{
  register char *end = p + len;

  while (p < end)
  {
      if (*p == c)
	  return p;
      p++;
  }
  return (char *) NULL;
}

/*
 * netSegmentStr() will breakup the str delimited by delim into
 * an array of pointers to the sub-strings.   str is not modified.
 *
 * lines[] will be an array pointing to the substrings.
 * lens[] will be an array of ints that contains the lengths
 * of the string in lines[]
 *
 * the number of substrings in lines[] will be returned.
 * this will be less than maxnum.
 *
 * this function assumes that lines[] and lens[] have enough
 * space in them to hold at least maxnum elements
 */
static int
  netSegmentStr(str, slen, delim, maxnum, lines, lens)
char* str;
int slen;
char  delim;
int maxnum;
char** lines;    /* returned */
int* lens;      /* returned */
{
  int argc;
  char* p;
  int len;

  argc = 1;
  lines[argc-1] = str;

  lens[argc-1] = slen;

  while ((p = netNextChar(str, delim, slen)) != NULL)
    {
      /* length of previous sub-string
       */

      len = p - str;
      lens[argc-1] = len;   

      if (argc == maxnum-1)
	break;

      /* move to next sub-string
       */
      argc += 1;
      str = p;

      slen = slen - (len + 1);   /* length of remaining string */

      if (slen <= 0)
	{
	  lines[argc-1] = "";
	  lens[argc-1] = 0;
	  break;
	}
      else
	{
	  ++str;     	/* move one char past the previous delim char  */
	  lines[argc-1] = str;
	  lens[argc-1] = slen;
	}
    }
  return argc;
} 

/*
 * draws the multiple-line string
 */
static void
  netDrawMultiStr(dis, d, gc, num_lines, lines, lens, x, y, max_width, fs)
Display* dis;
Drawable d;
GC gc;
int num_lines;
char* lines[];
int lens[];
int x;
int y;
int max_width;
XFontStruct *fs;
{
  int ignore;
  XCharStruct overall_size;
  int xd;
  int i;

  int vert = fs -> max_bounds.ascent + fs -> max_bounds.descent;

  for (i=0; i<num_lines; i++)
    {
      XTextExtents (fs, lines[i], lens[i],
		    &ignore, &ignore, &ignore, &overall_size);
      
      xd = x + ((max_width - (overall_size.lbearing + overall_size.rbearing))/2);
      
      XDrawString (dis, d, gc, xd, y, lines[i], lens[i]);
      y = y + vert;
    }
}

/*
 * returns the max width of the multiple-line string
 */
static int 
  netMaxWidthMultiStr(num_lines, lines, lens, font_struct)
int num_lines;
char* lines[];
int lens[];
XFontStruct *font_struct;
{
  int max_width = 0;
  int i;
  int ignore;
  XCharStruct overall_size;

  for (i = 0; i < num_lines; i++)
    {
      XTextExtents (font_struct, lines[i], lens[i],
		    &ignore, &ignore, &ignore, &overall_size);
      max_width = MAX(max_width,overall_size.lbearing + overall_size.rbearing);
    }
  return max_width;
}

/*
 * end additional code for supporting multi-line text
 */

/* begin modifications for supporting multi-line text
 */
static void
netDrawString (w, d, gc, node, display_type, shape, name, x, y, fs)
Widget w;
Drawable d;
GC gc;
netNode *node;
int display_type;
int shape;
char *name;
int x, y;
XFontStruct *fs;
{
	netNode rect_node;
	short delta;

	/* locals used for multi-line text
	 */
	int lens[MAX_NODE_LINES];
	char* lines[MAX_NODE_LINES];
	int max_width = 0;
	int num_lines;

	/* check for existence of multi-line text
	 */
	if (display_type == NETSYMBOL)
	{
	    num_lines = node -> s_line_count;
	    max_width = node -> s_width;
	}
	else
	{
	    num_lines = node -> t_line_count;
	    max_width = node -> t_width;
	}

	if (num_lines > 1)
	    num_lines = netSegmentStr (name, strlen(name), '\n',
				       MAX_NODE_LINES, lines, lens);

	switch (shape)
	{
	default:
	case 0:

	case NETBOXSYMBOL:
	case NETBOXTITLE:

	case NETELLIPSESYMBOL:
	case NETELLIPSETITLE:

	case NETOBLONGSYMBOL:
	case NETOBLONGTITLE:

	        if (num_lines == 1)
		   XDrawString (XtDisplay (w), d, gc,
				x, y, name, strlen (name));
		else 
		   netDrawMultiStr(XtDisplay (w), d, gc, num_lines, lines,
				   lens, x, y, max_width, fs);
		break;

	case NETCIRCLESYMBOL:
	case NETCIRCLETITLE:
		rect_node = *node;
		/* must use display_type for labels */
		if (display_type == NETSYMBOL)
		{
			if (node -> type & NETSYMBOLISLABEL)
			{
				node -> symbol.label -> type &=
					~(NETCIRCLESYMBOL);
				node -> symbol.label -> type |=
					NETBOXSYMBOL;
			}
			else
			{
				rect_node.type &= ~(NETCIRCLESYMBOL);
				rect_node.type |= NETBOXSYMBOL;
			}
			netSetSymbolRect ((NetWidget) w, &rect_node);
			if (rect_node.s.height != node -> s.height)
			{
				delta = node -> s.height - rect_node.s.height;
				y += delta / 2;
			}
			if (rect_node.s.width != node -> s.width)
			{
				delta = node -> s.width - rect_node.s.width;
				x += delta / 2;
			}

			if (num_lines == 1)
			  XDrawString (XtDisplay (w), d, gc, 
				       x, y, name, strlen (name));
			else
			  netDrawMultiStr(XtDisplay(w), d, gc, num_lines, 
					  lines, lens, x, y, max_width, fs);

			if (node -> type & NETSYMBOLISLABEL)
			{
				node -> symbol.label -> type |=
					NETCIRCLESYMBOL;
				node -> symbol.label -> type &=
					~(NETBOXSYMBOL);
			}
		}
		else
		{
			if (node -> type & NETTITLEISLABEL)
			{
				node -> title.label -> type &=
					~(NETCIRCLETITLE);
				node -> title.label -> type |=
					NETBOXTITLE;
			}
			else
			{
				rect_node.type &= ~(NETCIRCLETITLE);
				rect_node.type |= NETBOXTITLE;
			}
			netSetTitleRect ((NetWidget) w, &rect_node);
			if (rect_node.t.height != node -> t.height)
			{
				delta = node -> t.height - rect_node.t.height;
				y += delta / 2;
			}
			if (rect_node.t.width != node -> t.width)
			{
				delta = node -> t.width - rect_node.t.width;
				x += delta / 2;
			}

			if (num_lines == 1)
			  XDrawString (XtDisplay (w), d, gc, x, y,
				       name, strlen (name));
			else
			  netDrawMultiStr(XtDisplay (w), d, gc, num_lines, 
					  lines, lens, x, y, max_width, fs);

			if (node -> type & NETTITLEISLABEL)
			{
				node -> title.label -> type |=
					NETCIRCLETITLE;
				node -> title.label -> type &=
					~(NETBOXTITLE);
			}
		}
		break;
	}
}

/* end modifications for supporting multi-line text
 */

static void
netDrawOblong (display, drawable, gc, x, y, width, height)
Display *display;
Drawable drawable;
GC gc;
int x, y, width, height;
{
	XArc arcs[4];
	XGCValues vals;
	int overlap;

	if (width <= height)
	{
		XDrawArc (display, drawable, gc, x, y, width, height,
			  0 * 64, 360 * 64);
		return;
	}

	XGetGCValues(display, gc, GCLineWidth, &vals);
	overlap = (vals.line_width == 0) ? 1 : 0;

	/*
	 * left circle or cap - the width is equal to the height
	 */
	arcs[0].x = x;
	arcs[0].y = y;
	arcs[0].width = height;
	arcs[0].height = height;
	arcs[0].angle1 = 90 * 64;
	arcs[0].angle2 = 180 * 64;

	/*
	 * top line
	 */
	arcs[1].x = x + height / 2 + 1;
	arcs[1].y = y;
	arcs[1].width = width - height - overlap;
	arcs[1].height = 0;
	arcs[1].angle1 = 0;
	arcs[1].angle2 = 180 * 64;

	/*
	 * right circle or cap
	 */
	arcs[2].x = x + width - height;
	arcs[2].y = y;
	arcs[2].width = height;
	arcs[2].height = height;
	arcs[2].angle1 = 270 * 64;
	arcs[2].angle2 = 180 * 64;

	/*
	 * bottom line
	 */
	arcs[3].x = x + height / 2 + 1;
	arcs[3].y = y + height;
	arcs[3].width = width - height - overlap;
	arcs[3].height = 0;
	arcs[3].angle1 = 0;
	arcs[3].angle2 = 180 * 64;

	XDrawArcs (display, drawable, gc, arcs, 4);
}

static void
netFillOblong (display, drawable, gc, x, y, width, height)
Display *display;
Drawable drawable;
GC gc;
int x, y, width, height;
{
	XArc arcs[2];
	XGCValues vals;

	XGetGCValues(display, gc, GCArcMode, &vals);
	if (vals.arc_mode != ArcPieSlice)
	    XSetArcMode(display, gc, ArcPieSlice);

	if (width <= height)
	{
		XFillArc (display, drawable, gc, x, y, width, height,
			  0 * 64, 360 * 64);

		if (vals.arc_mode != ArcPieSlice)
			XSetArcMode(display, gc, vals.arc_mode);

		return;
	}

	/*
	 * left circle or cap - the width is equal to the height
	 */
	arcs[0].x = x;
	arcs[0].y = y;
	arcs[0].width = height;
	arcs[0].height = height;
	arcs[0].angle1 = 90 * 64;
	arcs[0].angle2 = 180 * 64;

	/*
	 * right circle or cap
	 */
	arcs[1].x = x + width - height;
	arcs[1].y = y;
	arcs[1].width = height;
	arcs[1].height = height;
	arcs[1].angle1 = 270 * 64;
	arcs[1].angle2 = 180 * 64;

	XFillArcs (display, drawable, gc, arcs, 2);

	/*
	 * the rectangular center of the oblong
	 */
	XFillRectangle (display, drawable, gc, x + height / 2 + 1, y,
			width - height, height);

	if (vals.arc_mode != ArcPieSlice)
	    XSetArcMode(display, gc, vals.arc_mode);
}

/*
 * spline routine from cip - beware that p must be of length n + 1;
 */
#define SCALE (long) 1024
#define STEPS 8

void
netDrawSpline (display, d, gc, offset_x, offset_y, p, n)
Display *display;
Drawable d;
GC gc;
int offset_x, offset_y; 
register XPoint *p;
int n;
{
	register long w, t1, t2, t3; 
	register int i, j; 
	XPoint q;
	XPoint pcurrent;		/* Current point */
	
	if (p == (XPoint *) NULL)
		return;
	
	pcurrent.x = p[0].x + offset_x;
	pcurrent.y = p[0].y + offset_y;
	
	for (i = 0; i < n - 1; i++)
	{
		for (j = 0; j < STEPS; j++)
		{
			w = SCALE * j / STEPS;
			t1 = w * w / (2 * SCALE);
			w = w - SCALE / 2;
			t2 = 3 * SCALE / 4 - w * w / SCALE;
			w = w - SCALE / 2;
			t3 = w * w / (2 * SCALE);
			q.x = offset_x +
				(t1 * p[i+2].x + t2 * p[i+1].x +
				 t3 * p[i].x + SCALE / 2) / SCALE;
			q.y = offset_y +
				(t1 * p[i+2].y + t2 * p[i+1].y +
				 t3 * p[i].y + SCALE / 2) / SCALE;
			XDrawLine (display, d, gc,
				   pcurrent.x, pcurrent.y,
				   q.x, q.y);
			pcurrent = q;
		}
	}
}

#define CLOSE (2 * (offset_x + offset_y + 1))

int
netPickSpline (x, y, offset_x, offset_y, p, n)
int x;
int y;
int offset_x, offset_y; 
register XPoint *p;
int n;
{
	register long w, t1, t2, t3; 
	register int i, j; 
	XPoint q;
	
	if (p == (XPoint *) NULL)
		return FALSE;

	for (i = 0; i < n - 1; i++)
	{
		for (j = 0; j < STEPS; j++)
		{
			w = SCALE * j / STEPS;
			t1 = w * w / (2 * SCALE);
			w = w - SCALE / 2;
			t2 = 3 * SCALE / 4 - w * w / SCALE;
			w = w - SCALE / 2;
			t3 = w * w / (2 * SCALE);
			q.x = offset_x +
				(t1 * p[i+2].x + t2 * p[i+1].x +
				 t3 * p[i].x + SCALE / 2) / SCALE;
			q.y = offset_y +
				(t1 * p[i+2].y + t2 * p[i+1].y +
				 t3 * p[i].y + SCALE / 2) / SCALE;
			if (x >= q.x - CLOSE && x <= q.x + CLOSE &&
			    y >= q.y - CLOSE && y <= q.y + CLOSE)
				return TRUE;
		}
	}

	return FALSE;
}

void
netSplineLocateArrow (A_rect, B_rect, offset_x, offset_y, p, n,
		      a_vertex, a_tail, b_tail, b_vertex)
netXSRectangle *A_rect;
netXSRectangle *B_rect;
int offset_x, offset_y; 
register XPoint *p;
int n;
XPoint *a_vertex, *a_tail;
XPoint *b_tail, *b_vertex;
{
	XPoint LineXRect ();
	register long w, t1, t2, t3; 
	register int i, j; 
	XPoint q;
	XPoint prev;
	XPoint prev2;
	XPoint t_point;
	int found_a;
	int found_b;

	if (p == (XPoint *) NULL)
		return;

	prev.x = p[0].x;
	prev.y = p[0].y;
	prev2 = prev;

	found_a = FALSE;
	found_b = FALSE;

	for (i = 0; i < n - 1; i++)
	{
		for (j = 0; j < ((2 * STEPS) / 3); j++)
		{
			w = SCALE * j / ((2 * STEPS) / 3);
			t1 = w * w / (2 * SCALE);
			w = w - SCALE / 2;
			t2 = 3 * SCALE / 4 - w * w / SCALE;
			w = w - SCALE / 2;
			t3 = w * w / (2 * SCALE);

			q.x = offset_x +
				(t1 * p[i+2].x + t2 * p[i+1].x +
				 t3 * p[i].x + SCALE / 2) / SCALE;

			q.y = offset_y +
				(t1 * p[i+2].y + t2 * p[i+1].y +
				 t3 * p[i].y + SCALE / 2) / SCALE;

			if (found_a == 0 &&
			    PtInRect (&q, A_rect) == FALSE)
			{
				found_a = 1;
				*a_tail = q;
				*a_vertex = prev2;
			}
			else if (found_a == 1)
			{
				*a_tail = q;
				*a_vertex = LineXRect (a_tail, &prev2, A_rect);
				found_a = 2;
			}

			if (PtInRect (&q, B_rect))
			{
				*b_tail = prev2;
				*b_vertex = LineXRect (b_tail, &q, B_rect);
				found_b = TRUE;
				break;
			}

			prev2 = prev;
			prev = q;
		}
		if (found_b)
			break;
	}

	if (found_a == 1)
	{
		*a_vertex = LineXRect (a_tail, a_vertex, A_rect);
	}
	else if (found_a != 2)
	{
		*a_tail = p[n - 1];
		*a_vertex = LineXRect (a_tail, &p[0], A_rect);
	}

	if (found_b == FALSE)
	{
		*b_tail = prev2;
		prev.x = B_rect -> x + B_rect -> width / 2;
		prev.y = B_rect -> y + B_rect -> height / 2;
		*b_vertex = LineXRect (b_tail, &prev, B_rect);
	}
}

void
netArrowTails (width, height, a, b, p1, p2)
int width;
int height;
register XPoint *a, *b;
register XPoint *p1, *p2;
{
	double rot;
	double hyp;
	double alpha;
	double dx, dy;

	rot = atan2 ((double) height, (double) ((double) width / 2.0));
	hyp = sqrt ((double) (width * width + height * height));
	dx = b -> x - a -> x;
	dy = b -> y - a -> y;
	if (dx == 0.0 && dy == 0.0)
		alpha = M_PI;
	else
		alpha = atan2 (dx, dy) + M_PI;

	dx = hyp * cos (alpha + rot);
	dy = hyp * sin (alpha + rot);
	p1 -> x = (double) b -> x - dx + 0.5;
	p1 -> y = (double) b -> y + dy + 0.5;

	dx = hyp * cos (alpha - rot);
	dy = hyp * sin (alpha - rot);
	p2 -> x = (double) b -> x + dx + 0.5;
	p2 -> y = (double) b -> y - dy + 0.5;
}

void
netSetTitleRect (w, node)
register NetWidget w;
register netNode *node;
{
	XFontStruct *font_struct = w -> net.titlefont_struct;
	int line_width = 1;
	int box_hspace = w -> net.internal_twidth;
	int box_vspace = w -> net.internal_theight;
	int shape;
	int pixmap;
	int scale_x = w -> core.width;
	int scale_y = w -> core.height;
	netLabel *label_ptr = node -> title.label;
	char* name = (char *) NULL;
	int max_vert;

	node -> p.x = node -> pf.x * scale_x;
	node -> p.y = scale_y - node -> pf.y * scale_y;

	if (label_ptr == (netLabel *) NULL)
	{
		node -> t.x = node -> p.x;
		node -> t.y = node -> p.y;
		node -> t.width = 0;
		node -> t.height = 0;
		return;
	}

	if (node -> type & NETTITLEISPROC)
	{
		(*node -> title.draw_proc) (NETPROCSIZE, w, node,
					    (Drawable) NULL, NULL,
					    (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETTITLEISLABEL)
	{
		if (label_ptr -> type & NETLINE_WIDTH)
		{
			line_width = label_ptr -> line_width;
			if (line_width < 1)
				line_width = 1;
		}
		if (label_ptr -> type & NETFONT)
			font_struct = label_ptr -> font_struct;

		if (label_ptr -> type & NETBOXHORIZSPACE)
			box_hspace = label_ptr -> box_hspace;

		if (label_ptr -> type & NETBOXVERTSPACE)
			box_vspace = label_ptr -> box_vspace;

		name = node -> title.label -> name;
		shape = label_ptr -> type & (NETTITLESHAPE | NETSYMBOLSHAPE);
		pixmap = label_ptr -> type & NETPIXMAP;
	}
	else
	{
		name = node -> title.name;
		shape = node -> type & NETTITLESHAPE;
		pixmap = FALSE;
	}


	/*
	 * begin modifications for supporting multi-line text
	 */
	
	if (name && node -> t_line_count > 1)
	  {
	    max_vert = node -> t_line_count *
		(font_struct -> max_bounds.descent +
		 font_struct -> max_bounds.ascent);
	  }
	else
	  {
	    max_vert = font_struct -> max_bounds.descent +
	               font_struct -> max_bounds.ascent;
	  }

	node -> t.x = node -> p.x;
	node -> t.y = node -> p.y - max_vert + font_struct -> max_bounds.descent;
	node -> t.width = node -> t_width;
	node -> t.height = max_vert;

	/*
	 * end modifications for supporting multi-line text
	 */

	if (shape)
		netSetShapeRect ((Widget) w, shape, NETTITLE, &node -> t,
				 line_width, box_hspace, box_vspace);

	if (pixmap)
	{
		label_ptr -> string_rect = node -> t;
		if (node -> title.label -> name)
		{
			label_ptr -> pixmap_rect.x =
				node -> p.x + node -> t.width / 2 -
					label_ptr -> pixmap_rect.width / 2;
			label_ptr -> pixmap_rect.y = node -> t.y -
				label_ptr -> pixmap_rect.height;
		}
		else
		{
			label_ptr -> pixmap_rect.x = node -> p.x;
			label_ptr -> pixmap_rect.y = node -> p.y -
				label_ptr -> pixmap_rect.height / 2;
		}
		MergeRects (&node -> t, &label_ptr -> pixmap_rect);
	}
}

void
netSetSymbolRect (w, node)
register NetWidget w;
register netNode *node;
{
	XFontStruct *font_struct = w -> net.symbolfont_struct;
	int line_width = 1;
	int box_hspace = w -> net.internal_swidth;
	int box_vspace = w -> net.internal_sheight;
	int shape;
	int pixmap;
	int scale_x = w -> core.width;
	int scale_y = w -> core.height;
	netLabel *label_ptr = node -> symbol.label;
	char* name = (char *) NULL;
	int max_vert;

	node -> p.x = node -> pf.x * scale_x;
	node -> p.y = scale_y - node -> pf.y * scale_y;

	if (label_ptr == (netLabel *) NULL)
	{
		node -> s.x = node -> p.x;
		node -> s.y = node -> p.y;
		node -> s.width = 0;
		node -> s.height = 0;
		return;
	}

	if (node -> type & NETSYMBOLISPROC)
	{
		(*node -> symbol.draw_proc) (NETPROCSIZE, w, node,
					     (Drawable) NULL, NULL,
					     (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETSYMBOLISLABEL)
	{
		if (label_ptr -> type & NETLINE_WIDTH)
		{
			line_width = label_ptr -> line_width;
			if (line_width < 1)
				line_width = 1;
		}
		if (label_ptr -> type & NETFONT)
			font_struct = label_ptr -> font_struct;

		if (label_ptr -> type & NETBOXHORIZSPACE)
			box_hspace = label_ptr -> box_hspace;

		if (label_ptr -> type & NETBOXVERTSPACE)
			box_vspace = label_ptr -> box_vspace;

		name = node -> symbol.label -> name;
		shape = label_ptr -> type & (NETTITLESHAPE | NETSYMBOLSHAPE);
		pixmap = label_ptr -> type & NETPIXMAP;
	}
	else
	{
		name = node -> symbol.name;
		shape = node -> type & NETSYMBOLSHAPE;
		pixmap = FALSE;
	}


	/*
	 * begin modifications for supporting multi-line text
	 */
	
	if (name && node -> s_line_count > 1)
	  {
	    max_vert = node -> s_line_count *
		(font_struct -> max_bounds.descent +
		 font_struct -> max_bounds.ascent);
	  }
	else
	  {
	    max_vert = font_struct -> max_bounds.descent +
	               font_struct -> max_bounds.ascent;
	  }
	
	node -> s.width = node -> s_width;
	node -> s.x = node -> p.x - ((node -> s.width) / 2);
	node -> s.y = node -> p.y - max_vert / 2;
	node -> s.height = max_vert;
	
	/*
	 * end modifications for supporting multi-line text
	 */

	if (shape)
		netSetShapeRect ((Widget) w, shape, NETSYMBOL, &node -> s,
				 line_width, box_hspace, box_vspace);

	if (pixmap)
	{
		label_ptr -> string_rect = node -> s;
		label_ptr -> pixmap_rect.x = node -> p.x -
			label_ptr -> pixmap_rect.width / 2;
		if (node -> symbol.label -> name)
			label_ptr -> pixmap_rect.y = node -> s.y -
				label_ptr -> pixmap_rect.height;
		else
			label_ptr -> pixmap_rect.y = node -> p.y -
				label_ptr -> pixmap_rect.height / 2;
		MergeRects (&node -> s, &label_ptr -> pixmap_rect);
	}
}

void
netDrawTitle (w, node, d, xor, clip_rect)
register NetWidget w;
register netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	int shape;
	int pixmap;
	int clipped = FALSE;
	int line_width = 1;
	XGCValues xgcvalues;
	GC lgc, lgc_background;
	XFontStruct *font_struct = w -> net.titlefont_struct;
	char *name;
	int box_hspace = w -> net.internal_twidth;
	int box_vspace = w -> net.internal_theight;
	int x, y, width, height;
	int left_bear;
	netLabel *label_ptr = node -> title.label;

	if (label_ptr == (netLabel *) NULL)
		return;

	if (node -> type & NETTITLEISPROC)
	{
		(*node -> title.draw_proc) (NETPROCDRAW, w, node, d, xor,
					    clip_rect);
		return;
	}

	if (node -> type & NETTITLEISLABEL)
	{
		if (label_ptr -> name == (char *) NULL &&
		    (label_ptr -> type & NETPIXMAP) == 0)
			return;

		if (xor)
			lgc = label_ptr -> xor_gc;
		else
		{
			lgc = label_ptr -> gc;
			lgc_background = label_ptr -> background_gc;
		}

		if (label_ptr -> type & NETLINE_WIDTH)
		{
			line_width = label_ptr -> line_width;
			if (line_width < 1)
				line_width = 1;
		}

		if (label_ptr -> type & NETFONT)
			font_struct = label_ptr -> font_struct;

		if (label_ptr -> type & NETBOXHORIZSPACE)
			box_hspace = label_ptr -> box_hspace;

		if (label_ptr -> type & NETBOXVERTSPACE)
			box_vspace = label_ptr -> box_vspace;

		name = label_ptr -> name;
		shape = label_ptr -> type & NETSHAPE;
		pixmap = label_ptr -> type & NETPIXMAP;
	}
	else
	{
		if (xor)
			lgc = w -> net.gctitles_xor;
		else
		{
			lgc = w -> net.gctitles;
			lgc_background = w -> net.gctitles_background;
		}

		name = node -> title.name;
		shape = node -> type & NETTITLESHAPE;
		pixmap = FALSE;
	}

	if (clip_rect && RectInRect (&node -> t, clip_rect) == FALSE)
	{
		clipped = TRUE;

		XSetClipRectangles (XtDisplay (w), lgc, 0, 0,
				    (XRectangle *) clip_rect, 1, YXBanded);

		if (!xor && (((node -> type & NETTITLEISLABEL) == 0 &&
			      w -> net.draw_titlebackground)        ||
			     (node -> type & NETTITLEISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			XSetClipRectangles (XtDisplay (w), lgc_background,
					    0, 0,
					    (XRectangle *) clip_rect,
					    1, YXBanded);
	}

	if (name)
	{
		netXSRectangle s;

		if (pixmap)
			s = label_ptr -> string_rect;
		else
			s = node -> t;

		if (shape == FALSE)
			line_width = 0;

		width = (s.width >= (2 * line_width)) ?
			s.width - (2 * line_width) : 0;
		height = (s.height >= (2 * line_width)) ?
			s.height - (2 * line_width) : 0;

		/*
		 * addition by jags july 24 1989
		 * if global background pixmap is unspecified do nothing
		 */
		if (!xor && (((node -> type & NETTITLEISLABEL) == 0 &&
			      w -> net.draw_titlebackground)        ||
			     (node -> type & NETTITLEISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			netFillShape ((Widget) w, d, lgc_background, shape,
					s.x + line_width,
					s.y + line_width,
					width, height);
		/*
		 * end of addition
		 */
		if (font_struct -> per_char &&
		    name[0] >= font_struct -> min_char_or_byte2 &&
		    name[0] <= font_struct -> max_char_or_byte2)
			left_bear = font_struct -> per_char[name[0]].lbearing;
		else
			left_bear = 0;

		x = s.x + left_bear;
		y = s.y + font_struct -> max_bounds.ascent;
		if (shape)
		{
			x += (line_width + box_hspace);
			y += (line_width + box_vspace);
		}

		netDrawString ((Widget) w, d, lgc, node, NETTITLE, shape,
			       name, x, y, font_struct);

		if (shape)
			netDrawShape ((Widget) w, d, lgc, shape,
				      s.x + line_width,
				      s.y + line_width,
				      width, height);
	}

	if (pixmap && (clipped == FALSE ||
		       RectXRect (clip_rect, &label_ptr -> pixmap_rect)))
	{
		XPoint dp;
		netXSRectangle sp;

		if (label_ptr -> pixmap_mask)
		{
			xgcvalues.clip_mask = label_ptr -> pixmap_mask;
			xgcvalues.clip_x_origin = label_ptr -> pixmap_rect.x;
			xgcvalues.clip_y_origin = label_ptr -> pixmap_rect.y;
			XChangeGC (XtDisplay (w), lgc,
				   GCClipMask | GCClipXOrigin | GCClipYOrigin,
				   &xgcvalues);
		}

		sp.x = sp.y = 0;
		sp.width = label_ptr -> pixmap_rect.width;
		sp.height = label_ptr -> pixmap_rect.height;
		dp.x = label_ptr -> pixmap_rect.x;
		dp.y = label_ptr -> pixmap_rect.y;
		if (clipped)
		{
			int delta;

			if (dp.x < clip_rect -> x)
			{
				delta = clip_rect -> x - dp.x;
				sp.width -= delta;
				sp.x = delta;
				dp.x = clip_rect -> x;
			}
			if (dp.y < clip_rect -> y)
			{
				delta = clip_rect -> y - dp.y;
				sp.height -= delta;
				sp.y = delta;
				dp.y = clip_rect -> y;
			}
			if (dp.x + sp.width >
			    clip_rect -> x + clip_rect -> width)
				sp.width = clip_rect -> x +
					clip_rect -> width - dp.x;
			if (dp.y + sp.height >
			    clip_rect -> y + clip_rect -> height)
				sp.height = clip_rect -> y +
					clip_rect -> height - dp.y;
		}

		XCopyArea (XtDisplay (w), label_ptr -> pixmap, d, lgc,
			   (int) sp.x, (int) sp.y,
			   (int) sp.width, (int) sp.height,
			   (int) dp.x, (int) dp.y);

		if (label_ptr -> pixmap_mask && clipped == FALSE)
		{
			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), lgc, GCClipMask, &xgcvalues);
		}
	}

	if (clipped)
	{
		xgcvalues.clip_mask = None;
		XChangeGC (XtDisplay (w), lgc, GCClipMask, &xgcvalues);

		if (!xor && (((node -> type & NETTITLEISLABEL) == 0 &&
			      w -> net.draw_titlebackground)        ||
			     (node -> type & NETTITLEISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			XChangeGC (XtDisplay (w), lgc_background,
				   GCClipMask, &xgcvalues);
	}
}

void
netDrawSymbol (w, node, d, xor, clip_rect)
register NetWidget w;
register netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	int shape;
	int pixmap;
	int clipped = FALSE;
	int line_width = 1;
	XGCValues xgcvalues;
	GC lgc, lgc_background;
	XFontStruct *font_struct = w -> net.symbolfont_struct;
	char *name;
	int box_hspace = w -> net.internal_swidth;
	int box_vspace = w -> net.internal_sheight;
	int x, y, width, height;
	int left_bear;
	netLabel *label_ptr = node -> symbol.label;

	if (label_ptr == (netLabel *) NULL)
		return;

	if (node -> type & NETSYMBOLISPROC)
	{
		(*node -> symbol.draw_proc) (NETPROCDRAW, w, node, d, xor,
					     clip_rect);
		return;
	}

	if (node -> type & NETSYMBOLISLABEL)
	{
		if (label_ptr -> name == (char *) NULL &&
		    (label_ptr -> type & NETPIXMAP) == 0)
			return;

		if (xor)
			lgc = label_ptr -> xor_gc;
		else
		{
			lgc = label_ptr -> gc;
			lgc_background = label_ptr -> background_gc;
		}

		if (label_ptr -> type & NETLINE_WIDTH)
		{
			line_width = label_ptr -> line_width;
			if (line_width < 1)
				line_width = 1;
		}

		if (label_ptr -> type & NETFONT)
			font_struct = label_ptr -> font_struct;

		if (label_ptr -> type & NETBOXHORIZSPACE)
			box_hspace = label_ptr -> box_hspace;

		if (label_ptr -> type & NETBOXVERTSPACE)
			box_vspace = label_ptr -> box_vspace;

		name = label_ptr -> name;
		shape = label_ptr -> type & NETSHAPE;
		pixmap = label_ptr -> type & NETPIXMAP;
	}
	else
	{
		if (xor)
			lgc = w -> net.gcsymbols_xor;
		else
		{
			lgc = w -> net.gcsymbols;
			lgc_background = w -> net.gcsymbols_background;
		}

		name = node -> symbol.name;
		shape = node -> type & NETSYMBOLSHAPE;
		pixmap = FALSE;
	}

	if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
	{
		clipped = TRUE;

		XSetClipRectangles (XtDisplay (w), lgc, 0, 0,
				    (XRectangle *) clip_rect, 1, YXBanded);

		if (!xor && (((node -> type & NETSYMBOLISLABEL) == 0 &&
			      w -> net.draw_symbolbackground)        ||
			     (node -> type & NETSYMBOLISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			XSetClipRectangles (XtDisplay (w), lgc_background,
					    0, 0, (XRectangle *) clip_rect,
					    1, YXBanded);
	}

	if (name)
	{
		netXSRectangle s;

		if (pixmap)
			s = label_ptr -> string_rect;
		else
			s = node -> s;

		if (shape == FALSE)
			line_width = 0;

		width = (s.width >= (2 * line_width)) ?
			s.width - (2 * line_width) : 0;
		height = (s.height >= (2 * line_width)) ?
			s.height - (2 * line_width) : 0;

		/*
		 * addition by jags july 24 1989
		 * if global background pixmap is unspecified do nothing
		 */
		if (!xor && (((node -> type & NETSYMBOLISLABEL) == 0 &&
			      w -> net.draw_symbolbackground)        ||
			     (node -> type & NETSYMBOLISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			netFillShape ((Widget) w, d, lgc_background, shape,
				      s.x + line_width,
				      s.y + line_width,
				      width, height);
		/*
		 * end of addition
		 */
		if (font_struct -> per_char &&
		    name[0] >= font_struct -> min_char_or_byte2 &&
		    name[0] <= font_struct -> max_char_or_byte2)
			left_bear = font_struct -> per_char[name[0]].lbearing;
		else
			left_bear = 0;

		x = s.x + left_bear;
		y = s.y + font_struct -> max_bounds.ascent;
		if (shape)
		{
			x += (line_width + box_hspace);
			y += (line_width + box_vspace);
		}

		netDrawString ((Widget) w, d, lgc, node, NETSYMBOL, shape,
			       name, x, y, font_struct);

		if (shape)
			netDrawShape ((Widget) w, d, lgc, shape,
				      s.x + line_width,
				      s.y + line_width,
				      width, height);
	}

	if (pixmap && (clipped == FALSE ||
		       RectXRect (clip_rect, &label_ptr -> pixmap_rect)))
	{
		XPoint dp;
		netXSRectangle sp;

		if (label_ptr -> pixmap_mask)
		{
			xgcvalues.clip_mask = label_ptr -> pixmap_mask;
			xgcvalues.clip_x_origin = label_ptr -> pixmap_rect.x;
			xgcvalues.clip_y_origin = label_ptr -> pixmap_rect.y;
			XChangeGC (XtDisplay (w), lgc,
				   GCClipMask | GCClipXOrigin | GCClipYOrigin,
				   &xgcvalues);
		}

		sp.x = sp.y = 0;
		sp.width = label_ptr -> pixmap_rect.width;
		sp.height = label_ptr -> pixmap_rect.height;
		dp.x = label_ptr -> pixmap_rect.x;
		dp.y = label_ptr -> pixmap_rect.y;
		if (clipped)
		{
			int delta;

			if (dp.x < clip_rect -> x)
			{
				delta = clip_rect -> x - dp.x;
				sp.width -= delta;
				sp.x = delta;
				dp.x = clip_rect -> x;
			}
			if (dp.y < clip_rect -> y)
			{
				delta = clip_rect -> y - dp.y;
				sp.height -= delta;
				sp.y = delta;
				dp.y = clip_rect -> y;
			}
			if (dp.x + sp.width >
			    clip_rect -> x + clip_rect -> width)
				sp.width = clip_rect -> x +
					clip_rect -> width - dp.x;
			if (dp.y + sp.height >
			    clip_rect -> y + clip_rect -> height)
				sp.height = clip_rect -> y +
					clip_rect -> height - dp.y;
		}

		XCopyArea (XtDisplay (w), label_ptr -> pixmap, d, lgc,
			   (int) sp.x, (int) sp.y,
			   (int) sp.width, (int) sp.height,
			   (int) dp.x, (int) dp.y);

		if (label_ptr -> pixmap_mask && clipped == FALSE)
		{
			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), lgc, GCClipMask, &xgcvalues);
		}
	}

	if (clipped)
	{
		xgcvalues.clip_mask = None;
		XChangeGC (XtDisplay (w), lgc, GCClipMask, &xgcvalues);

		if (!xor && (((node -> type & NETSYMBOLISLABEL) == 0 &&
			      w -> net.draw_symbolbackground)        ||
			     (node -> type & NETSYMBOLISLABEL &&
			      label_ptr -> type & NETBGSUPPLIED)))
			XChangeGC (XtDisplay (w), lgc_background,
				   GCClipMask, &xgcvalues);
	}
}

void
netDestroyTitle (w, node)
register NetWidget w;
register netNode *node;
{
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (node -> type & NETTITLEISPROC)
	{
		(*node -> title.draw_proc) (NETPROCDESTROY, w, node,
					    (Drawable) NULL, NULL,
					    (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETTITLEISLABEL)
	    netDestroyLabel (w, node -> title.label);
}

void
netDestroySymbol (w, node)
register NetWidget w;
register netNode *node;
{
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (node -> type & NETSYMBOLISPROC)
	{
		(*node -> symbol.draw_proc) (NETPROCDESTROY, w, node,
					     (Drawable) NULL, NULL,
					     (netXSRectangle *) NULL);
		return;
	}

	if (node -> type & NETSYMBOLISLABEL)
	    netDestroyLabel (w, node -> symbol.label);
}

void
netDestroyLabel (w, label)
register NetWidget w;
register netLabel *label;
{
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (label -> font_struct)
	{
		XFreeFontInfo ((char **) NULL, label -> font_struct, 1);
		label -> font_struct = (XFontStruct  *) NULL;
	}
	if (label -> gc)
	{
		XtReleaseGC ((Widget) w, label -> gc);
		label -> gc = (GC) NULL;
	}
	if (label -> xor_gc)
	{
		XtReleaseGC ((Widget) w, label -> xor_gc);
		label -> xor_gc = (GC) NULL;
	}
	if (label -> background_gc)
	{
		XtReleaseGC ((Widget) w, label -> background_gc);
		label -> background_gc = (GC) NULL;
	}
}

void
netDestroyLink (w, link)
register NetWidget w;
register netLink *link;
{
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (link -> type & NETLINEISPROC)
	{
		(*link -> line.draw_proc) (NETPROCDESTROY, w, link,
					   (Drawable) NULL, NULL,
					   (netXSRectangle *) NULL);
		return;
	}

	if (link -> type & NETLINKISLINE)
	    netDestroyLine (w, link -> line.line);
}

void
netDestroyLine (w, line)
register NetWidget w;
register netLine *line;
{
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return;
	/* END HGK changes */

	if (line -> gc)
	{
		XtReleaseGC ((Widget) w, line -> gc);
		line -> gc = (GC) NULL;
	}
	if (line -> xor_gc)
	{
		XtReleaseGC ((Widget) w, line -> xor_gc);
		line -> xor_gc = (GC) NULL;
	}
	if (line -> _spline_points)
	{
	    XtFree ((char *) line -> _spline_points);
	    line -> _spline_points = (XPoint *) NULL;
	}
	line -> _spline_count = 0;
}

void
netSetLinkRect (w, link)
register NetWidget w;
register netLink *link;
{
    register int t;
    int spline, spline_points, arrow_a, arrow_b;
    XPoint points[5];
    netXSRectangle A_node_rect;
    netXSRectangle B_node_rect;
    XPoint a_vertex, a_tail;
    XPoint b_vertex, b_tail;
    int line_width = 1;

    if (link -> type & NETLINEISPROC)
    {
	(*link -> line.draw_proc) (NETPROCSIZE, w, link,
				   (Drawable) NULL, NULL,
				   (netXSRectangle *) NULL);
	return;
    }

    if (link -> A == (netNode *) NULL || link -> B == (netNode *) NULL)
    {
	link -> l.x = 0;
	link -> l.y = 0;
	link -> l.width = 0;
	link -> l.height = 0;
	return;
    }

    link -> l.x = (t = MIN (link -> A -> p.x, link -> B -> p.x)) < 0 ? 0 : t;
    link -> l.y = (t = MIN (link -> A -> p.y, link -> B -> p.y)) < 0 ? 0 : t;
    link -> l.width = (t = MAX (link -> A -> p.x, link -> B -> p.x)) < 0 ? 0 : t;
    link -> l.height = (t = MAX (link -> A -> p.y, link -> B -> p.y)) < 0 ? 0 : t;
    link -> l.width -= link -> l.x;
    link -> l.height -= link -> l.y;

    if (link -> type & NETLINKISLINE)
    {
	register netLine *ptr = link -> line.line;

	if (ptr -> type & NETLINE_WIDTH)
	{
	    line_width = ptr -> line_width;
	    if (line_width < 1)
		line_width = 1;
	}
	spline = ptr -> type & NETSPLINELINK;
	spline_points = ptr -> type & NETSPLINEPOINTS;
	arrow_a = ptr -> type & NETARROWALINK;
	arrow_b = ptr -> type & NETARROWBLINK;
    }
    else
    {
	spline = link -> type & NETSPLINELINK;
	spline_points = False;
	arrow_a = link -> type & NETARROWALINK;
	arrow_b = link -> type & NETARROWBLINK;
    }

    link -> l.x -= line_width;
    link -> l.y -= line_width;
    link -> l.width += (2 * line_width);
    link -> l.height += (2 * line_width);

    if (link -> l.width < 1)
	link -> l.width = 1;
    if (link -> l.height < 1)
	link -> l.height = 1;

    if (spline_points)
    {
	netXFPoint *src_points = link -> line.line -> spline_points;
	XPoint *dst_points = link -> line.line -> _spline_points;
	int scale_x = ((Widget) w) -> core.width;
	int scale_y = ((Widget) w) -> core.height;
	int i;
	int count = link -> line.line -> _spline_count;

	for (i = 0; i < count; i++)
	{
	    dst_points[i].x = src_points[i].x * scale_x;
	    dst_points[i].y = scale_y - src_points[i].y * scale_y;
	    MergeRectPt (&link -> l, &dst_points[i]);
	}
	i--;
	dst_points[i + 2].x = dst_points[i + 1].x = dst_points[i].x;
	dst_points[i + 2].y = dst_points[i + 1].y = dst_points[i].y;
    }

    if (spline || spline_points)
    {
	link -> l.x -= line_width;
	link -> l.y -= line_width;
	link -> l.width += (2 * line_width);
	link -> l.height += (2 * line_width);
    }

    if ((spline || spline_points) && (arrow_a || arrow_b))
    {
	netGetNodeRect (link -> A, &A_node_rect);
	if (A_node_rect.width < 2)
	    A_node_rect.width = 2;
	if (A_node_rect.height < 2)
	    A_node_rect.height = 2;

	netGetNodeRect (link -> B, &B_node_rect);
	if (B_node_rect.width < 2)
	    B_node_rect.width = 2;
	if (B_node_rect.height < 2)
	    B_node_rect.height = 2;

	if (spline_points)
	{
	    t = link -> line.line -> _spline_count - 1;
	    if (PtInRect (&link -> line.line -> _spline_points[0],
			  &A_node_rect) == False)
	    {
		A_node_rect.x = link -> line.line -> _spline_points[0].x;
		A_node_rect.y = link -> line.line -> _spline_points[0].y;
		A_node_rect.width = 2;
		A_node_rect.height = 2;
	    }

	    if (PtInRect (&link -> line.line -> _spline_points[t],
			  &B_node_rect) == False)
	    {
		B_node_rect.x = link -> line.line -> _spline_points[t].x;
		B_node_rect.y = link -> line.line -> _spline_points[t].y;
		B_node_rect.width = 2;
		B_node_rect.height = 2;
	    }

	    netSplineLocateArrow (&A_node_rect, &B_node_rect, 1, 1,
				  link -> line.line -> _spline_points,
				  link -> line.line -> _spline_count,
				  &a_vertex, &a_tail,
				  &b_tail, &b_vertex);
	}
	else
	{
	    /*
	     * generate the spline data
	     */
	    points[0].x = link -> A -> p.x;
	    points[0].y = link -> A -> p.y;
	    points[1].x = link -> A -> p.x;
	    points[1].y = link -> B -> p.y;
	    points[2].x = link -> B -> p.x;
	    points[2].y = link -> B -> p.y;
	    points[4] = points[3] = points[2];

	    netSplineLocateArrow (&A_node_rect, &B_node_rect, 1, 1,
				  points, 3,
				  &a_vertex, &a_tail,
				  &b_tail, &b_vertex);
	}
    }

    if ((spline || spline_points) == FALSE && arrow_a)
    {
	netGetNodeRect (link -> A, &A_node_rect);
	if (A_node_rect.width < 2)
	    A_node_rect.width = 2;
	if (A_node_rect.height < 2)
	    A_node_rect.height = 2;
	a_vertex = LineXRect (&link -> B -> p,
			      &link -> A -> p,
			      &A_node_rect);
	a_tail = link -> B -> p;
    }

    if ((spline || spline_points) == FALSE && arrow_b)
    {
	netGetNodeRect (link -> B, &B_node_rect);
	if (B_node_rect.width < 2)
	    B_node_rect.width = 2;
	if (B_node_rect.height < 2)
	    B_node_rect.height = 2;
	b_vertex = LineXRect (&link -> A -> p,
			      &link -> B -> p,
			      &B_node_rect);
	b_tail = link -> A -> p;
    }

    /*
     * A arrow calculation
     */
    if (arrow_a)
    {
	netArrowTails (8, 16, &a_tail, &a_vertex,
		       &link -> arrowA[1], &link -> arrowA[2]);
	link -> arrowA[0] = a_vertex;

	A_node_rect.x = link -> arrowA[0].x;
	A_node_rect.y = link -> arrowA[0].y;
	A_node_rect.width = A_node_rect.height = 0;
	MergeRectPt (&A_node_rect, &link -> arrowA[1]);
	MergeRectPt (&A_node_rect, &link -> arrowA[2]);
	A_node_rect.x -= line_width;
	A_node_rect.y -= line_width;
	A_node_rect.width += (2 * line_width);
	A_node_rect.height += (2 * line_width);
	MergeRects (&link -> l, &A_node_rect);
    }
    /*
     * B arrow calculation
     */
    if (arrow_b)
    {
	netArrowTails (8, 16, &b_tail, &b_vertex,
		       &link -> arrowB[1], &link -> arrowB[2]);
	link -> arrowB[0] = b_vertex;

	B_node_rect.x = link -> arrowB[0].x;
	B_node_rect.y = link -> arrowB[0].y;
	B_node_rect.width = B_node_rect.height = 0;
	MergeRectPt (&B_node_rect, &link -> arrowB[1]);
	MergeRectPt (&B_node_rect, &link -> arrowB[2]);
	B_node_rect.x -= line_width;
	B_node_rect.y -= line_width;
	B_node_rect.width += (2 * line_width);
	B_node_rect.height += (2 * line_width);
	MergeRects (&link -> l, &B_node_rect);
    }
}

netXSRectangle *
netGetNodeRect (node, t)
register netNode *node;
register netXSRectangle *t;
{
	if (node -> title.name)
	{
		t -> x = node -> t.x;
		t -> y = node -> t.y;
		t -> width = node -> t.width;
		t -> height = node -> t.height;
		if (node -> symbol.name)
			MergeRects (t, &node -> s);
		return t;
	}
	if (node -> symbol.name)
	{
		t -> x = node -> s.x;
		t -> y = node -> s.y;
		t -> width = node -> s.width;
		t -> height = node -> s.height;
		return t;
	}
	t -> x = node -> p.x;
	t -> y = node -> p.y;
	t -> width = t -> height = 0;
	return t;
}

/*
 * support for selection
 */
netLink *
netPickLinks (w, x, y)
NetWidget w;
register int x, y;
{
	register netLink *link;
	int j;
	int newy;
	int yu, yl;
	XPoint points[5];

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return (netLink *) NULL;
	/* END HGK changes */

	for (link = w -> net.Link_List; link; link = link -> next)
	{
		if (link -> type & NETUNTOUCHABLE)
			continue;

		if (link -> type & NETLINEISPROC)
		{
			NetPickArgs pick_args;
			XPoint p;

			pick_args.return_value = FALSE;
			p.x = x; p.y = y;
			pick_args.p = &p;
			(*link -> line.draw_proc) (NETPROCPICK, w, link,
						   &pick_args, NULL,
						   (netXSRectangle *) NULL);
			if (pick_args.return_value == FALSE)
				continue;

			for (j = 0; j < FLICKER_COUNT; j++)
			{
				netDrawLink (w, link, XtWindow (w), TRUE,
					      (netXSRectangle *) NULL);
				XSync (XtDisplay (w), FALSE);
			}
			return link;
		}

		if (link -> type & NETLINKISLINE &&
		    link -> line.line -> type & NETSPLINEPOINTS)
		{
			if (netPickSpline (x, y, 1, 1,
					   link -> line.line -> _spline_points,
					   link -> line.line -> _spline_count))
			{
				for (j = 0; j < FLICKER_COUNT; j++)
				{
					netDrawLink (w, link, XtWindow (w),
						     TRUE,
						     (netXSRectangle *) NULL);
					XSync (XtDisplay (w), FALSE);
				}
				return link;
			}
			continue;
		}
	        else if (link -> type & NETSPLINELINK ||
		    (link -> type & NETLINKISLINE &&
		     link -> line.line -> type & NETSPLINELINK))
		{
			points[0].x = link -> A -> p.x;
			points[0].y = link -> A -> p.y;
			points[1].x = link -> A -> p.x;
			points[1].y = link -> B -> p.y;
			points[2].x = link -> B -> p.x;
			points[2].y = link -> B -> p.y;
			points[4] = points[3] = points[2];
			
			if (netPickSpline (x, y, 1, 1, points, 3))
			{
				for (j = 0; j < FLICKER_COUNT; j++)
				{
					netDrawLink (w, link, XtWindow (w),
						     TRUE,
						     (netXSRectangle *) NULL);
					XSync (XtDisplay (w), FALSE);
				}
				return link;
			}
			continue;
		}

		if (x > (link -> l.x + link -> l.width + DELTA) ||
		    x < (link -> l.x - DELTA) ||
		    y > (yu = (link -> l.y + link -> l.height + DELTA)) ||
		    y < (yl = (link -> l.y - DELTA)))
				continue;

		if (link -> l.width < DELTA ||
		    link -> B -> p.x - link -> A -> p.x == 0)
				newy = y;
		else if (link -> l.height < DELTA ||
			 link -> B -> p.y - link -> A -> p.y == 0)
				newy = link -> A -> p.y;
		else
			newy = link -> A -> p.y +
				((link -> B -> p.y - link -> A -> p.y) *
				 (x - link -> A -> p.x)) /
					 (link -> B -> p.x - link -> A -> p.x);

		if (newy < yu && newy > yl && (abs (newy - y)) < DELTA)
		{
			for (j = 0; j < FLICKER_COUNT; j++)
			{
				netDrawLink (w, link, XtWindow (w), TRUE,
					      (netXSRectangle *) NULL);
				XSync (XtDisplay (w), FALSE);
			}
			return link;
		}
	}
	return (netLink *) NULL;
}

int
netPickLink (w, link, x, y)
NetWidget w;
register netLink *link;
register int x, y;
{
	int j;
	int newy;
	int yu, yl;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return FALSE;
	/* END HGK changes */

	if (x > (link -> l.x + link -> l.width + DELTA) ||
	    x < (link -> l.x - DELTA) ||
	    y > (yu = (link -> l.y + link -> l.height + DELTA)) ||
	    y < (yl = (link -> l.y - DELTA)))
		return FALSE;

	if (link -> l.width < DELTA ||
	    link -> B -> p.x - link -> A -> p.x == 0)
		newy = y;
	else if (link -> l.height < DELTA ||
		 link -> B -> p.y - link -> A -> p.y == 0)
		newy = link -> A -> p.y;
	else
		newy = link -> A -> p.y +
			((link -> B -> p.y - link -> A -> p.y) *
			 (x - link -> A -> p.x)) /
				 (link -> B -> p.x - link -> A -> p.x);

	if (newy < yu && newy > yl && (abs (newy - y)) < DELTA)
		return TRUE;

	return FALSE;
}

void
netPickTitlesAndSymbols (w, x, y, return_type, return_node)
NetWidget w;
register int x, y;
int *return_type;
netNode **return_node;
{
	register netNode *node;
	netNode *selected_node = (netNode *) NULL;
	int selected_type = 0;
	int j;
	XPoint p;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
	{
		*return_type = selected_type;
		*return_node = selected_node;
		return;
	}
	/* END HGK changes */

	p.x = x;
	p.y = y;

	for (node = w -> net.Node_List; node; node = node -> next)
	{
		if (node -> type & NETUNTOUCHABLE)
			continue;

		if (node -> title.name != (char *) NULL)
		{
			if (node -> type & NETTITLEISPROC)
			{
				NetPickArgs pick_args;

				pick_args.return_value = FALSE;
				pick_args.p = &p;
				(*node -> title.draw_proc) (NETPROCPICK, w,
							    node,
							    &pick_args, NULL,
							    (netXSRectangle *)
							    NULL);
				if (pick_args.return_value)
				{
					selected_type = NETTITLE;
					selected_node = node;
				}
			}
			else if (PtInRect (&p, &node -> t))
			{
				selected_type = NETTITLE;
				selected_node = node;
			}

		}
		if (node -> symbol.name != (char *) NULL &&
		    selected_node != node)
		{
			if (node -> type & NETSYMBOLISPROC)
			{
				NetPickArgs pick_args;

				pick_args.return_value = FALSE;
				pick_args.p = &p;
				(*node -> symbol.draw_proc) (NETPROCPICK, w,
							    node,
							    &pick_args, NULL,
							    (netXSRectangle *)
							    NULL);
				if (pick_args.return_value)
				{
					selected_type = NETSYMBOL;
					selected_node = node;
				}
			}
			else if (PtInRect (&p, &node -> s))
			{
				selected_type = NETSYMBOL;
				selected_node = node;
			}
		}
	}

	if (selected_node != NULL)
	{
		for (j = 0; j < FLICKER_COUNT; j++)
		{
			if (selected_type == NETTITLE)
				netDrawTitle (w, selected_node, XtWindow (w),
					      TRUE, (netXSRectangle *) NULL);
			else
				netDrawSymbol (w, selected_node, XtWindow (w),
					       TRUE, (netXSRectangle *) NULL);
			XSync (XtDisplay (w), FALSE);
		}
	}

	*return_type = selected_type;
	*return_node = selected_node;
}

netNode *
netPickTitles (w, x, y)
NetWidget w;
register int x, y;
{
	register netNode *node;
	netNode *selected_node = (netNode *) NULL;
	int j;
	XPoint p;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return (netNode *) NULL;
	/* END HGK changes */

	p.x = x;
	p.y = y;

	for (node = w -> net.Node_List; node; node = node -> next)
	{
		if (node -> type & NETUNTOUCHABLE ||
		    node -> title.name == (char *) NULL)
			continue;

		if (node -> type & NETTITLEISPROC)
		{
			NetPickArgs pick_args;

			pick_args.return_value = FALSE;
			pick_args.p = &p;
			(*node -> title.draw_proc) (NETPROCPICK, w, node,
						    &pick_args, NULL,
						    (netXSRectangle *) NULL);
			if (pick_args.return_value)
				selected_node = node;
			continue;
		}

		if (PtInRect (&p, &node -> t))
			selected_node = node;
	}

	if (selected_node != NULL)
	{
		for (j = 0; j < FLICKER_COUNT; j++)
		{
			netDrawTitle (w, selected_node, XtWindow (w), TRUE,
				      (netXSRectangle *) NULL);
			XSync (XtDisplay (w), FALSE);
		}
	}

	return selected_node;
}

netNode *
netPickSymbols (w, x, y)
NetWidget w;
register int x, y;
{
	register netNode *node;
	netNode *selected_node = (netNode *) NULL;
	int j;
	XPoint p;

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized ((Widget) w))
		return (netNode *) NULL;
	/* END HGK changes */

	p.x = x;
	p.y = y;

	for (node = w -> net.Node_List; node; node = node -> next)
	{
		if (node -> type & NETUNTOUCHABLE ||
		    node -> symbol.name == (char *) NULL)
			continue;

		if (node -> type & NETSYMBOLISPROC)
		{
			NetPickArgs pick_args;

			pick_args.return_value = FALSE;
			pick_args.p = &p;
			(*node -> symbol.draw_proc) (NETPROCPICK, w, node,
						     &pick_args, NULL,
						     (netXSRectangle *) NULL);
			if (pick_args.return_value)
				selected_node = node;
			continue;
		}

		if (PtInRect (&p, &node -> s))
			selected_node = node;
	}

	if (selected_node != NULL)
	{
		for (j = 0; j < FLICKER_COUNT; j++)
		{
			netDrawSymbol (w, selected_node, XtWindow (w), TRUE,
				       (netXSRectangle *) NULL);
			XSync (XtDisplay (w), FALSE);
		}
	}

	return selected_node;
}

/*
 * cleanup after net movement
 */
static void
netDragUpdateNodes (w)
NetWidget w;
{
	XExposeEvent expose_event;
	netNode *src_node;
	register netNode *node;
	register netLink *link;
	netXSRectangle n;
	netXSRectangle t;
	float old_x, old_y;
	Window window = XtWindow (w);
	int mark;

	src_node = w -> net.action_data.selected_node;
	old_x = src_node -> pf.x;
	old_y = src_node -> pf.y;
	src_node -> pf.x = w -> net.action_data.old_x;
	src_node -> pf.y = w -> net.action_data.old_y;
	netSetSymbolRect (w, src_node);
	netSetTitleRect (w, src_node);
	netGetNodeRect (src_node, &n);

	/*
	 * find the links that use this node
	 */
	if (old_x != src_node -> pf.x ||
	    old_y != src_node -> pf.y)
	{
		link = w -> net.Link_List;
		while (link)
		{
			if (link -> A == src_node || link -> B == src_node)
			{
				MergeRects (&n, &link -> l);
				link -> type |= (NETMARKBIT | NETMOVED);
			}
			link = link -> next;
		}
	}

	if (n.x < 0)
	{
		n.width += n.x;
		n.x = 0;
	}
	if (n.y < 0)
	{
		n.height += n.y;
		n.y = 0;
	}

	/*
	 * find the links that are in this rectangle
	 */
	link = w -> net.Link_List;
	while (link)
	{
		if (link -> type & NETMARKBIT)
		{
			link = link -> next;
			continue;
		}

		if (RectXRect (&n, &link -> l))
			link -> type |= NETMARKBIT;
		link = link -> next;
	}

	expose_event.type = Expose;
	expose_event.x = n.x;
	expose_event.y = n.y;
	expose_event.width = n.width;
	expose_event.height = n.height;
	netShowNetworkBackground (w, &expose_event, TRUE);

	src_node -> pf.x = old_x;
	src_node -> pf.y = old_y;
	netSetSymbolRect (w, src_node);
	netSetTitleRect (w, src_node);
	netGetNodeRect (src_node, &t);

	link = w -> net.Link_List;
	while (link)
	{
		if (link -> type & NETMARKBIT)
		{
			if (link -> type & NETMOVED)
			{
				netSetLinkRect (w, link);
				netDrawLink (w, link, window, FALSE,
					      (netXSRectangle *) NULL);
				MergeRects (&t, &link -> l);
			}
			else
				netDrawLink (w, link, window, FALSE, &n);

			link -> type &= ~(NETMARKBIT | NETMOVED);
		}

		link = link -> next;
	}

	if (RectXRect (&src_node -> s, &n))
		MergeRects (&n, &src_node -> s);
	if (RectXRect (&src_node -> t, &n))
		MergeRects (&n, &src_node -> t);
	if (RectXRect (&src_node -> s, &t))
		MergeRects (&t, &src_node -> s);
	if (RectXRect (&src_node -> t, &t))
		MergeRects (&t, &src_node -> t);
	if (RectXRect (&n, &t))
	{
		MergeRects (&n, &t);
		mark = FALSE;
	}
	else
		mark = TRUE;

	node = w -> net.Node_List;
	while (node)
	{
		if (node == src_node)
		{
			netDrawSymbol (w, src_node, window, FALSE,
				       (netXSRectangle *) NULL);
			netDrawTitle (w, src_node, window, FALSE,
				      (netXSRectangle *) NULL);
			node = node -> next;
			continue;
		}
		if (mark)
		{
			if (RectXRect (&node -> s, &t))
				netDrawSymbol (w, node, window, FALSE, &t);

			if (RectXRect (&node -> t, &t))
				netDrawTitle (w, node, window, FALSE, &t);
		}
		if (RectXRect (&node -> s, &n))
			netDrawSymbol (w, node, window, FALSE, &n);

		if (RectXRect (&node -> t, &n))
			netDrawTitle (w, node, window, FALSE, &n);

		node = node -> next;
	}
}

void
netDragLinks (w, node, d)
NetWidget w;
register netNode *node;
Drawable d;
{
	register netLink *link;
	netLine *ptr;
	int type;

	link = w -> net.Link_List;
	while (link)
	{
		if (link -> A == node || link -> B == node)
		{
			if (link -> type & NETLINKISLINE)
			{
				ptr = link -> line.line;
				type = ptr -> type;
				ptr -> type &=
					~(NETARROWALINK | NETARROWBLINK);
			}
			else
			{
				type = link -> type;
				link -> type &=
					~(NETARROWALINK | NETARROWBLINK);
			}

			netDrawLink (w, link, d, TRUE,
				     (netXSRectangle *) NULL);

			if (link -> type & NETLINKISLINE)
				ptr -> type = type;
			else
				link -> type = type;
		}
		link = link -> next;
	}
}

/*
 * all net related actions
 */
static void
netAction (w, event, params, num_params)
register NetWidget w;
XEvent *event;
String *params;				/* type: point | drag | update */
Cardinal *num_params;			/* we only support 1 */
{
	register netNode *node;
	netLink *link;
	char type;
	netXSRectangle t;
	float scale_x = w -> core.width;
	float scale_y = w -> core.height;
	Window window = XtWindow (w);

	if (scale_x <= 0.0)
		scale_x = 1.0;
	if (scale_y <= 0.0)
		scale_y = 1.0;

	if (*num_params > 0)
		type = *params[0];
	else
		type = 'P';

	switch (type)
	{
	case 'P':   /* point */
	case 'p':
		if (w -> net.action_data.selection_type != 0)
			return;
		w -> net.action_data.selection_type = NETSELECTED;
		w -> net.action_data.data_type = 0;
		w -> net.action_data.selected_node = (netNode *) NULL;
		w -> net.action_data.selected_link = (netLink *) NULL;
		w -> net.action_data.nodes = w -> net.Node_List;
		w -> net.action_data.links = w -> net.Link_List;

		netPickTitlesAndSymbols (w, event -> xmotion.x,
					 event -> xmotion.y,
					 &w -> net.action_data.data_type,
					 &w -> net.action_data.selected_node);

		if (w -> net.action_data.selected_node == (netNode *) NULL)
		{
			link = netPickLinks (w, event -> xmotion.x,
					     event -> xmotion.y);
			if (link)
			{
				w -> net.action_data.data_type = NETLINK;
				w -> net.action_data.selected_link = link;
			}
		}

		/* START HGK additions - 2/15/90 */
		w -> net.action_data.mouse_x = event -> xmotion.x;
		w -> net.action_data.mouse_y = event -> xmotion.y;
		/* END HGK additions */
		XtCallCallbacks ((Widget) w, XtNnetProcPoint,
				 &w -> net.action_data);
		if (w -> net.action_data.selected_node == NULL && link == NULL)
			w -> net.action_data.selection_type = 0;
		break;

	case 'D':   /* drag */
	case 'd':
		if (w -> net.action_data.selection_type != NETSELECTED &&
		    w -> net.action_data.selection_type != NETDRAGGED)
			break;

		if (w -> net.action_data.data_type != NETSYMBOL &&
		    w -> net.action_data.data_type != NETTITLE)
		{
			w -> net.action_data.selection_type = 0;
			break;
		}

		if (w -> net.action_data.selection_type == NETSELECTED &&
		    (abs (w -> net.action_data.mouse_x - event -> xmotion.x) < 5 &&
		     abs (w -> net.action_data.mouse_y - event -> xmotion.y) < 5))
			break;

		node = w -> net.action_data.selected_node;

		if (node -> type & NETUNMOVEABLE)
			break;

		netGetNodeRect (node, &t);

		if (w -> net.action_data.selection_type == NETSELECTED)
		{
			w -> net.action_data.old_x = node -> pf.x;
			w -> net.action_data.old_y = node -> pf.y;
		}
		netDrawSymbol (w, node, window, TRUE, (netXSRectangle *) NULL);
		netDrawTitle (w, node, window, TRUE, (netXSRectangle *) NULL);
		if ((node -> type & NETCONSTRAINX) == 0)
		    node -> pf.x = ((float) event -> xmotion.x) / scale_x;
		if ((node -> type & NETCONSTRAINY) == 0)
		    node -> pf.y = (scale_y - event -> xmotion.y) / scale_y;
		if ((node -> type & NETUNCONSTRAINED) == 0)
		{
			if (node -> pf.x < 0.0)
				node -> pf.x = 0.0;
			if (node -> pf.x > 1.0)
				node -> pf.x = 1.0;
			if (node -> pf.y < 0.0)
				node -> pf.y = 0.0;
			if (node -> pf.y > 1.0)
				node -> pf.y = 1.0;
		}
		netSetSymbolRect (w, node);
		netSetTitleRect (w, node);
		netDrawSymbol (w, node, window, TRUE, (netXSRectangle *) NULL);
		netDrawTitle (w, node, window, TRUE, (netXSRectangle *) NULL);
		w -> net.action_data.selection_type = NETDRAGGED;
		/* START HGK additions - 2/15/90 */
		w -> net.action_data.mouse_x = event -> xmotion.x;
		w -> net.action_data.mouse_y = event -> xmotion.y;
		/* END HGK additions */
		XtCallCallbacks ((Widget) w, XtNnetProcDrag,
				 &w -> net.action_data);
		break;

	case 'U':   /* update */
	case 'u':
		if (w -> net.action_data.selection_type != NETSELECTED &&
		    w -> net.action_data.selection_type != NETDRAGGED &&
		    w -> net.action_data.selection_type != NETRUBBERBAND)
		{
		    w -> net.action_data.mouse_x = event -> xmotion.x;
		    w -> net.action_data.mouse_y = event -> xmotion.y;
		    w -> net.action_data.selection_type = 0;
		    w -> net.action_data.data_type = 0;
		    XtCallCallbacks ((Widget) w, XtNnetProcUpdate,
				     &w -> net.action_data);
		    return;
		}
		if (w -> net.action_data.selection_type == NETDRAGGED ||
		    w -> net.action_data.selection_type == NETRUBBERBAND)
		{
			netDragUpdateNodes (w);
			XSync (XtDisplay (w), FALSE);
		}
		/* START HGK additions - 2/15/90 */
		w -> net.action_data.mouse_x = event -> xmotion.x;
		w -> net.action_data.mouse_y = event -> xmotion.y;
		/* END HGK additions */
		XtCallCallbacks ((Widget) w, XtNnetProcUpdate,
				 &w -> net.action_data);
		w -> net.action_data.selection_type = 0;
		w -> net.action_data.data_type = 0;
		break;

	case 'R':   /* rubberband */
	case 'r':
	case 'E':   /* expensive rubberband */
	case 'e':
		if (w -> net.action_data.selection_type != NETSELECTED &&
		    w -> net.action_data.selection_type != NETRUBBERBAND &&
		    w -> net.action_data.selection_type !=
		    NETEXPENSIVERUBBERBAND)
			break;

		if (w -> net.action_data.data_type != NETSYMBOL &&
		    w -> net.action_data.data_type != NETTITLE)
		{
			w -> net.action_data.selection_type = 0;
			break;
		}

		if (w -> net.action_data.selection_type == NETSELECTED &&
		    (abs (w -> net.action_data.mouse_x - event -> xmotion.x) < 5 &&
		     abs (w -> net.action_data.mouse_y - event -> xmotion.y) < 5))
			break;

		node = w -> net.action_data.selected_node;

		if (node -> type & NETUNMOVEABLE)
			break;

		if (type == 'E' || type == 'e')
		{
			w -> net.action_data.old_x = node -> pf.x;
			w -> net.action_data.old_y = node -> pf.y;

			if ((node -> type & NETCONSTRAINX) == 0)
			    node -> pf.x = ((float) event -> xmotion.x) /
				scale_x;
			if ((node -> type & NETCONSTRAINY) == 0)
			    node -> pf.y = (scale_y - event -> xmotion.y) /
				scale_y;
			if ((node -> type & NETUNCONSTRAINED) == 0)
			{
				if (node -> pf.x < 0.0)
					node -> pf.x = 0.0;
				if (node -> pf.x > 1.0)
					node -> pf.x = 1.0;
				if (node -> pf.y < 0.0)
					node -> pf.y = 0.0;
				if (node -> pf.y > 1.0)
					node -> pf.y = 1.0;
			}
			netSetSymbolRect (w, node);
			netSetTitleRect (w, node);
			
			netDragUpdateNodes (w);
			
			w -> net.action_data.selection_type = NETRUBBERBAND;
			/* START HGK additions - 2/15/90 */
			w -> net.action_data.mouse_x = event -> xmotion.x;
			w -> net.action_data.mouse_y = event -> xmotion.y;
			/* END HGK additions */
			
			XtCallCallbacks ((Widget) w, XtNnetProcDrag,
					 &w -> net.action_data);
			
			break;
		}

		netGetNodeRect (node, &t);

		if (w -> net.action_data.selection_type == NETSELECTED)
		{
			XExposeEvent expose_event;

			w -> net.action_data.old_x = node -> pf.x;
			w -> net.action_data.old_y = node -> pf.y;

			netDragLinks (w, node, window);
			expose_event.type = Expose;
			expose_event.x = t.x;
			expose_event.y = t.y;
			expose_event.width = t.width;
			expose_event.height = t.height;
			netShowNetworkBackground (w, &expose_event, TRUE);
		}
		else
		{
			netDragLinks (w, node, window);
			netDrawSymbol (w, node, window, TRUE,
				       (netXSRectangle *) NULL);
			netDrawTitle (w, node, window, TRUE,
				      (netXSRectangle *) NULL);
		}

		if ((node -> type & NETCONSTRAINX) == 0)
		    node -> pf.x = ((float) event -> xmotion.x) / scale_x;
		if ((node -> type & NETCONSTRAINY) == 0)
		    node -> pf.y = (scale_y - event -> xmotion.y) / scale_y;
		if ((node -> type & NETUNCONSTRAINED) == 0)
		{
			if (node -> pf.x < 0.0)
				node -> pf.x = 0.0;
			if (node -> pf.x > 1.0)
				node -> pf.x = 1.0;
			if (node -> pf.y < 0.0)
				node -> pf.y = 0.0;
			if (node -> pf.y > 1.0)
				node -> pf.y = 1.0;
		}
		netSetSymbolRect (w, node);
		netSetTitleRect (w, node);
		netDragLinks (w, node, window);
		netDrawSymbol (w, node, window, TRUE, (netXSRectangle *) NULL);
		netDrawTitle (w, node, window, TRUE, (netXSRectangle *) NULL);

		w -> net.action_data.selection_type = NETRUBBERBAND;
		/* START HGK additions - 2/15/90 */
		w -> net.action_data.mouse_x = event -> xmotion.x;
		w -> net.action_data.mouse_y = event -> xmotion.y;
		/* END HGK additions */

		XtCallCallbacks ((Widget) w, XtNnetProcDrag,
				 &w -> net.action_data);

		break;
	}
}
