#include <stdio.h>
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>

#ifndef TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern XImage *
LoadImage C_P_ARGS((Display *display, int screen, char *fname, int new_map,
		    Colormap *colormap_return));

C_PROTOS_END_EXTERN

void
main(argc, argv)
int argc;
char **argv;
{
    Display *display;
    int screen;
    Window rootwindow;
    int width, height;
    Pixmap p;
    Colormap colormap;
    XImage *image;
    char buffer[BUFSIZ];
    char *ptr;

    /*
     * Open up the display.
     */
    if ((display = XOpenDisplay(NULL)) == NULL)
    {
	fprintf (stderr, "%s: Can't open display.\n", argv[0]);
	exit (1);
    }
    screen = DefaultScreen (display);
    rootwindow = RootWindow (display, screen);
	
    while (fgets (buffer, BUFSIZ, stdin) != NULL)
    {
	ptr = buffer;
	while (*ptr != ' ' && *ptr != '\t')
	    ptr++;
	*ptr++ = '\0';

	p = (Pixmap) atol (ptr);

	image = LoadImage (display, screen,
			   buffer, FALSE,
			   &colormap);

	if (image == NULL)
	    continue;

	XPutImage (display, p,
		   DefaultGC (display, screen),
		   image,
		   0, 0, 0, 0,
		   image -> width, image -> height);
	
	XDestroyImage (image);

	XSync (display, 0);
    }
}
