#include <stdio.h>
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include "tiffio.h"
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static
CVTOldToNewTiffFile C_P_ARGS((char *program_name,
			      char *filein, char *fileout));

C_PROTOS_END_EXTERN

void
main(argc, argv)
int argc;
char **argv;
{
    if (argc != 3)
    {
	fprintf (stderr,
		 "%s usage:\n\t%s <input filename> <output filename>\n",
		 argv[0], argv[0]);
	exit (1);
    }

    CVTOldToNewTiffFile (argv[0], argv[1], argv[2]);
}

static
CVTOldToNewTiffFile (program_name, filein, fileout)
char *program_name;
char *filein;
char *fileout;
{
    TIFF *in, *out;
    long width, height;
    unsigned short orient;
    unsigned short compress;
    unsigned short config;
    unsigned short photo;
    unsigned short bitspersample, samplesperpixel;
    unsigned short *rm, *gm, *bm;
    unsigned char *data_in;
    unsigned char *data_out;
    unsigned char c;
    int i, j_in, j_out, bit_count;

    in = TIFFOpen (filein, "r");
    if (in == NULL)
    {
	fprintf (stderr, "%s: Cannot open input file: %s.\n",
		 program_name, filein);
	return;
    }

    out = TIFFOpen (fileout, "w");
    if (out == NULL)
    {
	fprintf (stderr, "%s: Cannot open output file: %s.\n",
		 program_name, fileout);
	return;
    }

    TIFFGetField (in, TIFFTAG_IMAGEWIDTH, &width);
    TIFFGetField (in, TIFFTAG_IMAGELENGTH, &height);
    TIFFGetField (in, TIFFTAG_ORIENTATION, &orient);
    TIFFGetField (in, TIFFTAG_COMPRESSION, &compress);
    TIFFGetField (in, TIFFTAG_PLANARCONFIG, &config);

    TIFFSetField (out, TIFFTAG_IMAGEWIDTH, width);
    TIFFSetField (out, TIFFTAG_IMAGELENGTH, height);
    TIFFSetField (out, TIFFTAG_ORIENTATION, orient);
    TIFFSetField (out, TIFFTAG_COMPRESSION, compress);
    TIFFSetField (out, TIFFTAG_PLANARCONFIG, config);
    TIFFSetField (out, TIFFTAG_RESOLUTIONUNIT, RESUNIT_NONE);

    TIFFGetField (in, TIFFTAG_BITSPERSAMPLE, &bitspersample);
    TIFFGetField (in, TIFFTAG_SAMPLESPERPIXEL, &samplesperpixel);

    TIFFSetField (out, TIFFTAG_BITSPERSAMPLE, 1);
    TIFFSetField (out, TIFFTAG_SAMPLESPERPIXEL, 1);
    TIFFSetField(out, TIFFTAG_COMPRESSION, COMPRESSION_CCITTFAX4);

    data_in = (unsigned char *) malloc (TIFFScanlineSize (in));
    data_out = (unsigned char *) malloc (TIFFScanlineSize (out));

    for (i = 0; i < height; i++)
    {
	TIFFReadScanline (in, data_in, i, 0);

	j_out = 0;
	bit_count = 7;
	c = (unsigned char ) 0;

	for (j_in = 0; j_in < width; j_in++)
	{
	    if (data_in[j_in])
		c |= (1 << bit_count);
	    bit_count--;
	    if (bit_count == -1)
	    {
		data_out[j_out] = c;
		j_out++;
		bit_count = 7;
		c = (unsigned char ) 0;
	    }
	}
	if (bit_count < 7)
	    data_out[j_out] = c;

	TIFFWriteScanline (out, data_out, i, 0);
    }

    TIFFClose (in);
    TIFFClose (out);
}
